# type: ignore
# -*- coding: utf-8 -*-
#
# English Language RTD & Sphinx config file
#
# Uses ../conf_common.py for most non-language-specific settings.
# Importing conf_common adds all the non-language-specific
# parts to this conf module
try:
    from conf_common import *  # noqa: F403,F401
except ImportError:
    import os
    import sys

    sys.path.insert(0, os.path.abspath('..'))
    from conf_common import *  # noqa: F403,F401

import datetime

current_year = datetime.datetime.now().year

# General information about the project.
project = 'ESP-IDF 编程指南'
copyright = '2016 - {} 乐鑫信息科技（上海）股份有限公司'.format(current_year)  # noqa: A001

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'zh_CN'

html_zip = f'esp-idf-{language}-{release}'  # noqa: F405

# The chatbot is able to answer only about the latest documentation.
# Enable Documentation Chatbot widget only for the master branch.
if release == 'latest':  # noqa: F405
    html_js_files = ['js/chatbot_widget_cn.js']
