/*
 * SPDX-FileCopyrightText: 2022-2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: CC0-1.0
 */

#include "unity.h"
#include "unity_test_runner.h"
#include "unity_test_utils_memory.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "dev_msc.h"
#include "phy_common.h"
#include "usb/usb_host.h"

// ----------------------------------------------------- Macros --------------------------------------------------------

#define TEST_P4_OTG11 0 // Change this to 1 to test on OTG1.1 peripheral - only for ESP32-P4

// --------------------- Constants -------------------------

#if TEST_P4_OTG11
#define TEST_PHY                USB_PHY_TARGET_INT
#define TEST_PERIPHERAL_MAP     BIT1
#else
#if CONFIG_IDF_TARGET_ESP32P4
#define TEST_PHY                USB_PHY_TARGET_UTMI
#else
#define TEST_PHY                USB_PHY_TARGET_INT
#endif
#define TEST_PERIPHERAL_MAP     BIT0
#endif // TEST_P4_OTG11

void setUp(void)
{
    unity_utils_record_free_mem();
    dev_msc_init();
    // Install PHY separately
    test_setup_usb_phy(TEST_PHY);
    // Install USB Host
    usb_host_config_t host_config = {
        .skip_phy_setup = true,
        .root_port_unpowered = false,
        .intr_flags = ESP_INTR_FLAG_LEVEL1,
        .peripheral_map = TEST_PERIPHERAL_MAP,
    };
    ESP_ERROR_CHECK(usb_host_install(&host_config));
    printf("USB Host installed\n");
}

void tearDown(void)
{
    // Short delay to allow task to be cleaned up
    vTaskDelay(10);
    // Clean up USB Host
    printf("USB Host uninstall\n");
    ESP_ERROR_CHECK(usb_host_uninstall());
    test_delete_usb_phy();
    // Short delay to allow task to be cleaned up after client uninstall
    vTaskDelay(10);
    unity_utils_evaluate_leaks();
}

void app_main(void)
{
    //  ____ ___  ___________________    __                   __
    // |    |   \/   _____/\______   \ _/  |_  ____   _______/  |_
    // |    |   /\_____  \  |    |  _/ \   __\/ __ \ /  ___/\   __\.
    // |    |  / /        \ |    |   \  |  | \  ___/ \___ \  |  |
    // |______/ /_______  / |______  /  |__|  \___  >____  > |__|
    //                  \/         \/             \/     \/
    printf(" ____ ___  ___________________    __                   __   \r\n");
    printf("|    |   \\/   _____/\\______   \\ _/  |_  ____   _______/  |_ \r\n");
    printf("|    |   /\\_____  \\  |    |  _/ \\   __\\/ __ \\ /  ___/\\   __\\\r\n");
    printf("|    |  / /        \\ |    |   \\  |  | \\  ___/ \\___ \\  |  |  \r\n");
    printf("|______/ /_______  / |______  /  |__|  \\___  >____  > |__|  \r\n");
    printf("                 \\/         \\/             \\/     \\/        \r\n");

    unity_utils_setup_heap_record(80);
    unity_utils_set_leak_level(128);
    unity_run_menu();
}
