/*
 * SPDX-FileCopyrightText: 2017-2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef _SOC_INTERRUPT_CORE0_REG_H_
#define _SOC_INTERRUPT_CORE0_REG_H_


#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

#define DR_REG_INTERRUPT_CORE0_BASE                 DR_REG_INTERRUPT_BASE

#define INTERRUPT_CORE0_MAC_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x000)
/* INTERRUPT_CORE0_MAC_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_MAC_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_MAC_INTR_MAP_M  ((INTERRUPT_CORE0_MAC_INTR_MAP_V)<<(INTERRUPT_CORE0_MAC_INTR_MAP_S))
#define INTERRUPT_CORE0_MAC_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_MAC_INTR_MAP_S  0

#define INTERRUPT_CORE0_MAC_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x004)
/* INTERRUPT_CORE0_MAC_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_MAC_NMI_MAP  0x0000001F
#define INTERRUPT_CORE0_MAC_NMI_MAP_M  ((INTERRUPT_CORE0_MAC_NMI_MAP_V)<<(INTERRUPT_CORE0_MAC_NMI_MAP_S))
#define INTERRUPT_CORE0_MAC_NMI_MAP_V  0x1F
#define INTERRUPT_CORE0_MAC_NMI_MAP_S  0

#define INTERRUPT_CORE0_PWR_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x008)
/* INTERRUPT_CORE0_PWR_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_PWR_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_PWR_INTR_MAP_M  ((INTERRUPT_CORE0_PWR_INTR_MAP_V)<<(INTERRUPT_CORE0_PWR_INTR_MAP_S))
#define INTERRUPT_CORE0_PWR_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_PWR_INTR_MAP_S  0

#define INTERRUPT_CORE0_BB_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x00C)
/* INTERRUPT_CORE0_BB_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_BB_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_BB_INT_MAP_M  ((INTERRUPT_CORE0_BB_INT_MAP_V)<<(INTERRUPT_CORE0_BB_INT_MAP_S))
#define INTERRUPT_CORE0_BB_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_BB_INT_MAP_S  0

#define INTERRUPT_CORE0_BT_MAC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x010)
/* INTERRUPT_CORE0_BT_MAC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_BT_MAC_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_BT_MAC_INT_MAP_M  ((INTERRUPT_CORE0_BT_MAC_INT_MAP_V)<<(INTERRUPT_CORE0_BT_MAC_INT_MAP_S))
#define INTERRUPT_CORE0_BT_MAC_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_BT_MAC_INT_MAP_S  0

#define INTERRUPT_CORE0_BT_BB_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x014)
/* INTERRUPT_CORE0_BT_BB_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_BT_BB_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_BT_BB_INT_MAP_M  ((INTERRUPT_CORE0_BT_BB_INT_MAP_V)<<(INTERRUPT_CORE0_BT_BB_INT_MAP_S))
#define INTERRUPT_CORE0_BT_BB_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_BT_BB_INT_MAP_S  0

#define INTERRUPT_CORE0_BT_BB_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x018)
/* INTERRUPT_CORE0_BT_BB_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_BT_BB_NMI_MAP  0x0000001F
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_M  ((INTERRUPT_CORE0_BT_BB_NMI_MAP_V)<<(INTERRUPT_CORE0_BT_BB_NMI_MAP_S))
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_V  0x1F
#define INTERRUPT_CORE0_BT_BB_NMI_MAP_S  0

#define INTERRUPT_CORE0_RWBT_IRQ_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x01C)
/* INTERRUPT_CORE0_RWBT_IRQ_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_RWBT_IRQ_MAP  0x0000001F
#define INTERRUPT_CORE0_RWBT_IRQ_MAP_M  ((INTERRUPT_CORE0_RWBT_IRQ_MAP_V)<<(INTERRUPT_CORE0_RWBT_IRQ_MAP_S))
#define INTERRUPT_CORE0_RWBT_IRQ_MAP_V  0x1F
#define INTERRUPT_CORE0_RWBT_IRQ_MAP_S  0

#define INTERRUPT_CORE0_RWBLE_IRQ_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x020)
/* INTERRUPT_CORE0_RWBLE_IRQ_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_RWBLE_IRQ_MAP  0x0000001F
#define INTERRUPT_CORE0_RWBLE_IRQ_MAP_M  ((INTERRUPT_CORE0_RWBLE_IRQ_MAP_V)<<(INTERRUPT_CORE0_RWBLE_IRQ_MAP_S))
#define INTERRUPT_CORE0_RWBLE_IRQ_MAP_V  0x1F
#define INTERRUPT_CORE0_RWBLE_IRQ_MAP_S  0

#define INTERRUPT_CORE0_RWBT_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x024)
/* INTERRUPT_CORE0_RWBT_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_RWBT_NMI_MAP  0x0000001F
#define INTERRUPT_CORE0_RWBT_NMI_MAP_M  ((INTERRUPT_CORE0_RWBT_NMI_MAP_V)<<(INTERRUPT_CORE0_RWBT_NMI_MAP_S))
#define INTERRUPT_CORE0_RWBT_NMI_MAP_V  0x1F
#define INTERRUPT_CORE0_RWBT_NMI_MAP_S  0

#define INTERRUPT_CORE0_RWBLE_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x028)
/* INTERRUPT_CORE0_RWBLE_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_RWBLE_NMI_MAP  0x0000001F
#define INTERRUPT_CORE0_RWBLE_NMI_MAP_M  ((INTERRUPT_CORE0_RWBLE_NMI_MAP_V)<<(INTERRUPT_CORE0_RWBLE_NMI_MAP_S))
#define INTERRUPT_CORE0_RWBLE_NMI_MAP_V  0x1F
#define INTERRUPT_CORE0_RWBLE_NMI_MAP_S  0

#define INTERRUPT_CORE0_I2C_MST_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x02C)
/* INTERRUPT_CORE0_I2C_MST_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_I2C_MST_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_I2C_MST_INT_MAP_M  ((INTERRUPT_CORE0_I2C_MST_INT_MAP_V)<<(INTERRUPT_CORE0_I2C_MST_INT_MAP_S))
#define INTERRUPT_CORE0_I2C_MST_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_I2C_MST_INT_MAP_S  0

#define INTERRUPT_CORE0_SLC0_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x030)
/* INTERRUPT_CORE0_SLC0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SLC0_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_SLC0_INTR_MAP_M  ((INTERRUPT_CORE0_SLC0_INTR_MAP_V)<<(INTERRUPT_CORE0_SLC0_INTR_MAP_S))
#define INTERRUPT_CORE0_SLC0_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_SLC0_INTR_MAP_S  0

#define INTERRUPT_CORE0_SLC1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x034)
/* INTERRUPT_CORE0_SLC1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SLC1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_SLC1_INTR_MAP_M  ((INTERRUPT_CORE0_SLC1_INTR_MAP_V)<<(INTERRUPT_CORE0_SLC1_INTR_MAP_S))
#define INTERRUPT_CORE0_SLC1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_SLC1_INTR_MAP_S  0

#define INTERRUPT_CORE0_UHCI0_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x038)
/* INTERRUPT_CORE0_UHCI0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_UHCI0_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_UHCI0_INTR_MAP_M  ((INTERRUPT_CORE0_UHCI0_INTR_MAP_V)<<(INTERRUPT_CORE0_UHCI0_INTR_MAP_S))
#define INTERRUPT_CORE0_UHCI0_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_UHCI0_INTR_MAP_S  0

#define INTERRUPT_CORE0_UHCI1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x03C)
/* INTERRUPT_CORE0_UHCI1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_UHCI1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_UHCI1_INTR_MAP_M  ((INTERRUPT_CORE0_UHCI1_INTR_MAP_V)<<(INTERRUPT_CORE0_UHCI1_INTR_MAP_S))
#define INTERRUPT_CORE0_UHCI1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_UHCI1_INTR_MAP_S  0

#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x040)
/* INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP  0x0000001F
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_M  ((INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_V)<<(INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_S))
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_V  0x1F
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_MAP_S  0

#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x044)
/* INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP  0x0000001F
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_M  ((INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_V)<<(INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_S))
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_V  0x1F
#define INTERRUPT_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_S  0

#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x048)
/* INTERRUPT_CORE0_GPIO_INTERRUPT_APP_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_MAP  0x0000001F
#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_MAP_M  ((INTERRUPT_CORE0_GPIO_INTERRUPT_APP_MAP_V)<<(INTERRUPT_CORE0_GPIO_INTERRUPT_APP_MAP_S))
#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_MAP_V  0x1F
#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_MAP_S  0

#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x04C)
/* INTERRUPT_CORE0_GPIO_INTERRUPT_APP_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_NMI_MAP  0x0000001F
#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_NMI_MAP_M  ((INTERRUPT_CORE0_GPIO_INTERRUPT_APP_NMI_MAP_V)<<(INTERRUPT_CORE0_GPIO_INTERRUPT_APP_NMI_MAP_S))
#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_NMI_MAP_V  0x1F
#define INTERRUPT_CORE0_GPIO_INTERRUPT_APP_NMI_MAP_S  0

#define INTERRUPT_CORE0_SPI_INTR_1_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x050)
/* INTERRUPT_CORE0_SPI_INTR_1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SPI_INTR_1_MAP  0x0000001F
#define INTERRUPT_CORE0_SPI_INTR_1_MAP_M  ((INTERRUPT_CORE0_SPI_INTR_1_MAP_V)<<(INTERRUPT_CORE0_SPI_INTR_1_MAP_S))
#define INTERRUPT_CORE0_SPI_INTR_1_MAP_V  0x1F
#define INTERRUPT_CORE0_SPI_INTR_1_MAP_S  0

#define INTERRUPT_CORE0_SPI_INTR_2_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x054)
/* INTERRUPT_CORE0_SPI_INTR_2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SPI_INTR_2_MAP  0x0000001F
#define INTERRUPT_CORE0_SPI_INTR_2_MAP_M  ((INTERRUPT_CORE0_SPI_INTR_2_MAP_V)<<(INTERRUPT_CORE0_SPI_INTR_2_MAP_S))
#define INTERRUPT_CORE0_SPI_INTR_2_MAP_V  0x1F
#define INTERRUPT_CORE0_SPI_INTR_2_MAP_S  0

#define INTERRUPT_CORE0_SPI_INTR_3_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x058)
/* INTERRUPT_CORE0_SPI_INTR_3_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SPI_INTR_3_MAP  0x0000001F
#define INTERRUPT_CORE0_SPI_INTR_3_MAP_M  ((INTERRUPT_CORE0_SPI_INTR_3_MAP_V)<<(INTERRUPT_CORE0_SPI_INTR_3_MAP_S))
#define INTERRUPT_CORE0_SPI_INTR_3_MAP_V  0x1F
#define INTERRUPT_CORE0_SPI_INTR_3_MAP_S  0

#define INTERRUPT_CORE0_SPI_INTR_4_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x05C)
/* INTERRUPT_CORE0_SPI_INTR_4_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SPI_INTR_4_MAP  0x0000001F
#define INTERRUPT_CORE0_SPI_INTR_4_MAP_M  ((INTERRUPT_CORE0_SPI_INTR_4_MAP_V)<<(INTERRUPT_CORE0_SPI_INTR_4_MAP_S))
#define INTERRUPT_CORE0_SPI_INTR_4_MAP_V  0x1F
#define INTERRUPT_CORE0_SPI_INTR_4_MAP_S  0

#define INTERRUPT_CORE0_LCD_CAM_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x060)
/* INTERRUPT_CORE0_LCD_CAM_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_LCD_CAM_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_LCD_CAM_INT_MAP_M  ((INTERRUPT_CORE0_LCD_CAM_INT_MAP_V)<<(INTERRUPT_CORE0_LCD_CAM_INT_MAP_S))
#define INTERRUPT_CORE0_LCD_CAM_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_LCD_CAM_INT_MAP_S  0

#define INTERRUPT_CORE0_I2S0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x064)
/* INTERRUPT_CORE0_I2S0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_I2S0_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_I2S0_INT_MAP_M  ((INTERRUPT_CORE0_I2S0_INT_MAP_V)<<(INTERRUPT_CORE0_I2S0_INT_MAP_S))
#define INTERRUPT_CORE0_I2S0_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_I2S0_INT_MAP_S  0

#define INTERRUPT_CORE0_I2S1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x068)
/* INTERRUPT_CORE0_I2S1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_I2S1_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_I2S1_INT_MAP_M  ((INTERRUPT_CORE0_I2S1_INT_MAP_V)<<(INTERRUPT_CORE0_I2S1_INT_MAP_S))
#define INTERRUPT_CORE0_I2S1_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_I2S1_INT_MAP_S  0

#define INTERRUPT_CORE0_UART_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x06C)
/* INTERRUPT_CORE0_UART_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_UART_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_UART_INTR_MAP_M  ((INTERRUPT_CORE0_UART_INTR_MAP_V)<<(INTERRUPT_CORE0_UART_INTR_MAP_S))
#define INTERRUPT_CORE0_UART_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_UART_INTR_MAP_S  0

#define INTERRUPT_CORE0_UART1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x070)
/* INTERRUPT_CORE0_UART1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_UART1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_UART1_INTR_MAP_M  ((INTERRUPT_CORE0_UART1_INTR_MAP_V)<<(INTERRUPT_CORE0_UART1_INTR_MAP_S))
#define INTERRUPT_CORE0_UART1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_UART1_INTR_MAP_S  0

#define INTERRUPT_CORE0_UART2_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x074)
/* INTERRUPT_CORE0_UART2_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_UART2_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_UART2_INTR_MAP_M  ((INTERRUPT_CORE0_UART2_INTR_MAP_V)<<(INTERRUPT_CORE0_UART2_INTR_MAP_S))
#define INTERRUPT_CORE0_UART2_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_UART2_INTR_MAP_S  0

#define INTERRUPT_CORE0_SDIO_HOST_INTERRUPT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x078)
/* INTERRUPT_CORE0_SDIO_HOST_INTERRUPT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SDIO_HOST_INTERRUPT_MAP  0x0000001F
#define INTERRUPT_CORE0_SDIO_HOST_INTERRUPT_MAP_M  ((INTERRUPT_CORE0_SDIO_HOST_INTERRUPT_MAP_V)<<(INTERRUPT_CORE0_SDIO_HOST_INTERRUPT_MAP_S))
#define INTERRUPT_CORE0_SDIO_HOST_INTERRUPT_MAP_V  0x1F
#define INTERRUPT_CORE0_SDIO_HOST_INTERRUPT_MAP_S  0

#define INTERRUPT_CORE0_PWM0_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x07C)
/* INTERRUPT_CORE0_PWM0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_PWM0_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_PWM0_INTR_MAP_M  ((INTERRUPT_CORE0_PWM0_INTR_MAP_V)<<(INTERRUPT_CORE0_PWM0_INTR_MAP_S))
#define INTERRUPT_CORE0_PWM0_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_PWM0_INTR_MAP_S  0

#define INTERRUPT_CORE0_PWM1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x080)
/* INTERRUPT_CORE0_PWM1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_PWM1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_PWM1_INTR_MAP_M  ((INTERRUPT_CORE0_PWM1_INTR_MAP_V)<<(INTERRUPT_CORE0_PWM1_INTR_MAP_S))
#define INTERRUPT_CORE0_PWM1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_PWM1_INTR_MAP_S  0

#define INTERRUPT_CORE0_PWM2_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x084)
/* INTERRUPT_CORE0_PWM2_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_PWM2_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_PWM2_INTR_MAP_M  ((INTERRUPT_CORE0_PWM2_INTR_MAP_V)<<(INTERRUPT_CORE0_PWM2_INTR_MAP_S))
#define INTERRUPT_CORE0_PWM2_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_PWM2_INTR_MAP_S  0

#define INTERRUPT_CORE0_PWM3_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x088)
/* INTERRUPT_CORE0_PWM3_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_PWM3_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_PWM3_INTR_MAP_M  ((INTERRUPT_CORE0_PWM3_INTR_MAP_V)<<(INTERRUPT_CORE0_PWM3_INTR_MAP_S))
#define INTERRUPT_CORE0_PWM3_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_PWM3_INTR_MAP_S  0

#define INTERRUPT_CORE0_LEDC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x08C)
/* INTERRUPT_CORE0_LEDC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_LEDC_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_LEDC_INT_MAP_M  ((INTERRUPT_CORE0_LEDC_INT_MAP_V)<<(INTERRUPT_CORE0_LEDC_INT_MAP_S))
#define INTERRUPT_CORE0_LEDC_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_LEDC_INT_MAP_S  0

#define INTERRUPT_CORE0_EFUSE_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x090)
/* INTERRUPT_CORE0_EFUSE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_EFUSE_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_EFUSE_INT_MAP_M  ((INTERRUPT_CORE0_EFUSE_INT_MAP_V)<<(INTERRUPT_CORE0_EFUSE_INT_MAP_S))
#define INTERRUPT_CORE0_EFUSE_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_EFUSE_INT_MAP_S  0

#define INTERRUPT_CORE0_CAN_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x094)
/* INTERRUPT_CORE0_CAN_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CAN_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_CAN_INT_MAP_M  ((INTERRUPT_CORE0_CAN_INT_MAP_V)<<(INTERRUPT_CORE0_CAN_INT_MAP_S))
#define INTERRUPT_CORE0_CAN_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_CAN_INT_MAP_S  0

#define INTERRUPT_CORE0_USB_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x098)
/* INTERRUPT_CORE0_USB_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_USB_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_USB_INTR_MAP_M  ((INTERRUPT_CORE0_USB_INTR_MAP_V)<<(INTERRUPT_CORE0_USB_INTR_MAP_S))
#define INTERRUPT_CORE0_USB_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_USB_INTR_MAP_S  0

#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x09C)
/* INTERRUPT_CORE0_RTC_CORE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP_M  ((INTERRUPT_CORE0_RTC_CORE_INTR_MAP_V)<<(INTERRUPT_CORE0_RTC_CORE_INTR_MAP_S))
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_RTC_CORE_INTR_MAP_S  0

#define INTERRUPT_CORE0_RMT_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0A0)
/* INTERRUPT_CORE0_RMT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_RMT_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_RMT_INTR_MAP_M  ((INTERRUPT_CORE0_RMT_INTR_MAP_V)<<(INTERRUPT_CORE0_RMT_INTR_MAP_S))
#define INTERRUPT_CORE0_RMT_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_RMT_INTR_MAP_S  0

#define INTERRUPT_CORE0_PCNT_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0A4)
/* INTERRUPT_CORE0_PCNT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_PCNT_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_PCNT_INTR_MAP_M  ((INTERRUPT_CORE0_PCNT_INTR_MAP_V)<<(INTERRUPT_CORE0_PCNT_INTR_MAP_S))
#define INTERRUPT_CORE0_PCNT_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_PCNT_INTR_MAP_S  0

#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0A8)
/* INTERRUPT_CORE0_I2C_EXT0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_M  ((INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_V)<<(INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_S))
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_I2C_EXT0_INTR_MAP_S  0

#define INTERRUPT_CORE0_I2C_EXT1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0AC)
/* INTERRUPT_CORE0_I2C_EXT1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_I2C_EXT1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_I2C_EXT1_INTR_MAP_M  ((INTERRUPT_CORE0_I2C_EXT1_INTR_MAP_V)<<(INTERRUPT_CORE0_I2C_EXT1_INTR_MAP_S))
#define INTERRUPT_CORE0_I2C_EXT1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_I2C_EXT1_INTR_MAP_S  0

#define INTERRUPT_CORE0_SPI2_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0B0)
/* INTERRUPT_CORE0_SPI2_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SPI2_DMA_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_SPI2_DMA_INT_MAP_M  ((INTERRUPT_CORE0_SPI2_DMA_INT_MAP_V)<<(INTERRUPT_CORE0_SPI2_DMA_INT_MAP_S))
#define INTERRUPT_CORE0_SPI2_DMA_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_SPI2_DMA_INT_MAP_S  0

#define INTERRUPT_CORE0_SPI3_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0B4)
/* INTERRUPT_CORE0_SPI3_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SPI3_DMA_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_SPI3_DMA_INT_MAP_M  ((INTERRUPT_CORE0_SPI3_DMA_INT_MAP_V)<<(INTERRUPT_CORE0_SPI3_DMA_INT_MAP_S))
#define INTERRUPT_CORE0_SPI3_DMA_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_SPI3_DMA_INT_MAP_S  0

#define INTERRUPT_CORE0_SPI4_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0B8)
/* INTERRUPT_CORE0_SPI4_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SPI4_DMA_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_SPI4_DMA_INT_MAP_M  ((INTERRUPT_CORE0_SPI4_DMA_INT_MAP_V)<<(INTERRUPT_CORE0_SPI4_DMA_INT_MAP_S))
#define INTERRUPT_CORE0_SPI4_DMA_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_SPI4_DMA_INT_MAP_S  0

#define INTERRUPT_CORE0_WDG_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0BC)
/* INTERRUPT_CORE0_WDG_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_WDG_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_WDG_INT_MAP_M  ((INTERRUPT_CORE0_WDG_INT_MAP_V)<<(INTERRUPT_CORE0_WDG_INT_MAP_S))
#define INTERRUPT_CORE0_WDG_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_WDG_INT_MAP_S  0

#define INTERRUPT_CORE0_TIMER_INT1_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0C0)
/* INTERRUPT_CORE0_TIMER_INT1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_TIMER_INT1_MAP  0x0000001F
#define INTERRUPT_CORE0_TIMER_INT1_MAP_M  ((INTERRUPT_CORE0_TIMER_INT1_MAP_V)<<(INTERRUPT_CORE0_TIMER_INT1_MAP_S))
#define INTERRUPT_CORE0_TIMER_INT1_MAP_V  0x1F
#define INTERRUPT_CORE0_TIMER_INT1_MAP_S  0

#define INTERRUPT_CORE0_TIMER_INT2_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0C4)
/* INTERRUPT_CORE0_TIMER_INT2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_TIMER_INT2_MAP  0x0000001F
#define INTERRUPT_CORE0_TIMER_INT2_MAP_M  ((INTERRUPT_CORE0_TIMER_INT2_MAP_V)<<(INTERRUPT_CORE0_TIMER_INT2_MAP_S))
#define INTERRUPT_CORE0_TIMER_INT2_MAP_V  0x1F
#define INTERRUPT_CORE0_TIMER_INT2_MAP_S  0

#define INTERRUPT_CORE0_TG_T0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0C8)
/* INTERRUPT_CORE0_TG_T0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_TG_T0_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_TG_T0_INT_MAP_M  ((INTERRUPT_CORE0_TG_T0_INT_MAP_V)<<(INTERRUPT_CORE0_TG_T0_INT_MAP_S))
#define INTERRUPT_CORE0_TG_T0_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_TG_T0_INT_MAP_S  0

#define INTERRUPT_CORE0_TG_T1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0CC)
/* INTERRUPT_CORE0_TG_T1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_TG_T1_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_TG_T1_INT_MAP_M  ((INTERRUPT_CORE0_TG_T1_INT_MAP_V)<<(INTERRUPT_CORE0_TG_T1_INT_MAP_S))
#define INTERRUPT_CORE0_TG_T1_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_TG_T1_INT_MAP_S  0

#define INTERRUPT_CORE0_TG_WDT_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0D0)
/* INTERRUPT_CORE0_TG_WDT_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_TG_WDT_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_TG_WDT_INT_MAP_M  ((INTERRUPT_CORE0_TG_WDT_INT_MAP_V)<<(INTERRUPT_CORE0_TG_WDT_INT_MAP_S))
#define INTERRUPT_CORE0_TG_WDT_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_TG_WDT_INT_MAP_S  0

#define INTERRUPT_CORE0_TG1_T0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0D4)
/* INTERRUPT_CORE0_TG1_T0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_TG1_T0_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_TG1_T0_INT_MAP_M  ((INTERRUPT_CORE0_TG1_T0_INT_MAP_V)<<(INTERRUPT_CORE0_TG1_T0_INT_MAP_S))
#define INTERRUPT_CORE0_TG1_T0_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_TG1_T0_INT_MAP_S  0

#define INTERRUPT_CORE0_TG1_T1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0D8)
/* INTERRUPT_CORE0_TG1_T1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_TG1_T1_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_TG1_T1_INT_MAP_M  ((INTERRUPT_CORE0_TG1_T1_INT_MAP_V)<<(INTERRUPT_CORE0_TG1_T1_INT_MAP_S))
#define INTERRUPT_CORE0_TG1_T1_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_TG1_T1_INT_MAP_S  0

#define INTERRUPT_CORE0_TG1_WDT_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0DC)
/* INTERRUPT_CORE0_TG1_WDT_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_TG1_WDT_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_TG1_WDT_INT_MAP_M  ((INTERRUPT_CORE0_TG1_WDT_INT_MAP_V)<<(INTERRUPT_CORE0_TG1_WDT_INT_MAP_S))
#define INTERRUPT_CORE0_TG1_WDT_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_TG1_WDT_INT_MAP_S  0

#define INTERRUPT_CORE0_CACHE_IA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0E0)
/* INTERRUPT_CORE0_CACHE_IA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP_M  ((INTERRUPT_CORE0_CACHE_IA_INT_MAP_V)<<(INTERRUPT_CORE0_CACHE_IA_INT_MAP_S))
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_CACHE_IA_INT_MAP_S  0

#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0E4)
/* INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_M  ((INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_V)<<(INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_S))
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_SYSTIMER_TARGET0_INT_MAP_S  0

#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0E8)
/* INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_M  ((INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_V)<<(INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_S))
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_SYSTIMER_TARGET1_INT_MAP_S  0

#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0EC)
/* INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_M  ((INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_V)<<(INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_S))
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_SYSTIMER_TARGET2_INT_MAP_S  0

#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0F0)
/* INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_M  ((INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_V)<<(INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_S))
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_SPI_MEM_REJECT_INTR_MAP_S  0

#define INTERRUPT_CORE0_DCACHE_PRELOAD_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0F4)
/* INTERRUPT_CORE0_DCACHE_PRELOAD_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DCACHE_PRELOAD_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DCACHE_PRELOAD_INT_MAP_M  ((INTERRUPT_CORE0_DCACHE_PRELOAD_INT_MAP_V)<<(INTERRUPT_CORE0_DCACHE_PRELOAD_INT_MAP_S))
#define INTERRUPT_CORE0_DCACHE_PRELOAD_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DCACHE_PRELOAD_INT_MAP_S  0

#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0F8)
/* INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_M  ((INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_V)<<(INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_S))
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_ICACHE_PRELOAD_INT_MAP_S  0

#define INTERRUPT_CORE0_DCACHE_SYNC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x0FC)
/* INTERRUPT_CORE0_DCACHE_SYNC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DCACHE_SYNC_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DCACHE_SYNC_INT_MAP_M  ((INTERRUPT_CORE0_DCACHE_SYNC_INT_MAP_V)<<(INTERRUPT_CORE0_DCACHE_SYNC_INT_MAP_S))
#define INTERRUPT_CORE0_DCACHE_SYNC_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DCACHE_SYNC_INT_MAP_S  0

#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x100)
/* INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_M  ((INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_V)<<(INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_S))
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_ICACHE_SYNC_INT_MAP_S  0

#define INTERRUPT_CORE0_APB_ADC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x104)
/* INTERRUPT_CORE0_APB_ADC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_APB_ADC_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_APB_ADC_INT_MAP_M  ((INTERRUPT_CORE0_APB_ADC_INT_MAP_V)<<(INTERRUPT_CORE0_APB_ADC_INT_MAP_S))
#define INTERRUPT_CORE0_APB_ADC_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_APB_ADC_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_IN_CH0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x108)
/* INTERRUPT_CORE0_DMA_IN_CH0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_IN_CH0_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_IN_CH0_INT_MAP_M  ((INTERRUPT_CORE0_DMA_IN_CH0_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_IN_CH0_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_IN_CH0_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_IN_CH0_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_IN_CH1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x10C)
/* INTERRUPT_CORE0_DMA_IN_CH1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_IN_CH1_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_IN_CH1_INT_MAP_M  ((INTERRUPT_CORE0_DMA_IN_CH1_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_IN_CH1_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_IN_CH1_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_IN_CH1_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_IN_CH2_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x110)
/* INTERRUPT_CORE0_DMA_IN_CH2_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_IN_CH2_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_IN_CH2_INT_MAP_M  ((INTERRUPT_CORE0_DMA_IN_CH2_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_IN_CH2_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_IN_CH2_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_IN_CH2_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_IN_CH3_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x114)
/* INTERRUPT_CORE0_DMA_IN_CH3_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_IN_CH3_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_IN_CH3_INT_MAP_M  ((INTERRUPT_CORE0_DMA_IN_CH3_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_IN_CH3_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_IN_CH3_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_IN_CH3_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_IN_CH4_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x118)
/* INTERRUPT_CORE0_DMA_IN_CH4_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_IN_CH4_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_IN_CH4_INT_MAP_M  ((INTERRUPT_CORE0_DMA_IN_CH4_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_IN_CH4_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_IN_CH4_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_IN_CH4_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_OUT_CH0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x11C)
/* INTERRUPT_CORE0_DMA_OUT_CH0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_OUT_CH0_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_OUT_CH0_INT_MAP_M  ((INTERRUPT_CORE0_DMA_OUT_CH0_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_OUT_CH0_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_OUT_CH0_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_OUT_CH0_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_OUT_CH1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x120)
/* INTERRUPT_CORE0_DMA_OUT_CH1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_OUT_CH1_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_OUT_CH1_INT_MAP_M  ((INTERRUPT_CORE0_DMA_OUT_CH1_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_OUT_CH1_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_OUT_CH1_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_OUT_CH1_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_OUT_CH2_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x124)
/* INTERRUPT_CORE0_DMA_OUT_CH2_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_OUT_CH2_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_OUT_CH2_INT_MAP_M  ((INTERRUPT_CORE0_DMA_OUT_CH2_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_OUT_CH2_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_OUT_CH2_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_OUT_CH2_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_OUT_CH3_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x128)
/* INTERRUPT_CORE0_DMA_OUT_CH3_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_OUT_CH3_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_OUT_CH3_INT_MAP_M  ((INTERRUPT_CORE0_DMA_OUT_CH3_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_OUT_CH3_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_OUT_CH3_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_OUT_CH3_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_OUT_CH4_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x12C)
/* INTERRUPT_CORE0_DMA_OUT_CH4_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_OUT_CH4_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_OUT_CH4_INT_MAP_M  ((INTERRUPT_CORE0_DMA_OUT_CH4_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_OUT_CH4_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_OUT_CH4_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_OUT_CH4_INT_MAP_S  0

#define INTERRUPT_CORE0_RSA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x130)
/* INTERRUPT_CORE0_RSA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_RSA_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_RSA_INT_MAP_M  ((INTERRUPT_CORE0_RSA_INT_MAP_V)<<(INTERRUPT_CORE0_RSA_INT_MAP_S))
#define INTERRUPT_CORE0_RSA_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_RSA_INT_MAP_S  0

#define INTERRUPT_CORE0_AES_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x134)
/* INTERRUPT_CORE0_AES_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_AES_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_AES_INT_MAP_M  ((INTERRUPT_CORE0_AES_INT_MAP_V)<<(INTERRUPT_CORE0_AES_INT_MAP_S))
#define INTERRUPT_CORE0_AES_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_AES_INT_MAP_S  0

#define INTERRUPT_CORE0_SHA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x138)
/* INTERRUPT_CORE0_SHA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_SHA_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_SHA_INT_MAP_M  ((INTERRUPT_CORE0_SHA_INT_MAP_V)<<(INTERRUPT_CORE0_SHA_INT_MAP_S))
#define INTERRUPT_CORE0_SHA_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_SHA_INT_MAP_S  0

#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x13C)
/* INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP  0x0000001F
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_M  ((INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_V)<<(INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_S))
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_V  0x1F
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_0_MAP_S  0

#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x140)
/* INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP  0x0000001F
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_M  ((INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_V)<<(INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_S))
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_V  0x1F
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_1_MAP_S  0

#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x144)
/* INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP  0x0000001F
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_M  ((INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_V)<<(INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_S))
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_V  0x1F
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_2_MAP_S  0

#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x148)
/* INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP  0x0000001F
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_M  ((INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_V)<<(INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_S))
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_V  0x1F
#define INTERRUPT_CORE0_CPU_INTR_FROM_CPU_3_MAP_S  0

#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x14C)
/* INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_M  ((INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_V)<<(INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_S))
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_ASSIST_DEBUG_INTR_MAP_S  0

#define INTERRUPT_CORE0_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x150)
/* INTERRUPT_CORE0_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE0_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE0_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE0_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x154)
/* INTERRUPT_CORE0_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE0_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE0_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE0_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x158)
/* INTERRUPT_CORE0_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE0_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE0_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE0_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x15C)
/* INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x160)
/* INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_M  ((INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V)<<(INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S))
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x164)
/* INTERRUPT_CORE0_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE0_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE0_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE0_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x168)
/* INTERRUPT_CORE0_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE0_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE0_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE0_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x16C)
/* INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x170)
/* INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_M  ((INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V)<<(INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S))
#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S  0

#define INTERRUPT_CORE0_BACKUP_PMS_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x174)
/* INTERRUPT_CORE0_BACKUP_PMS_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_BACKUP_PMS_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE0_BACKUP_PMS_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE0_BACKUP_PMS_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE0_BACKUP_PMS_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE0_BACKUP_PMS_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE0_BACKUP_PMS_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x178)
/* INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_M  ((INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_V)<<(INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_S))
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_CACHE_CORE0_ACS_INT_MAP_S  0

#define INTERRUPT_CORE0_CACHE_CORE1_ACS_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x17C)
/* INTERRUPT_CORE0_CACHE_CORE1_ACS_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_CACHE_CORE1_ACS_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_CACHE_CORE1_ACS_INT_MAP_M  ((INTERRUPT_CORE0_CACHE_CORE1_ACS_INT_MAP_V)<<(INTERRUPT_CORE0_CACHE_CORE1_ACS_INT_MAP_S))
#define INTERRUPT_CORE0_CACHE_CORE1_ACS_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_CACHE_CORE1_ACS_INT_MAP_S  0

#define INTERRUPT_CORE0_USB_DEVICE_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x180)
/* INTERRUPT_CORE0_USB_DEVICE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_USB_DEVICE_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_USB_DEVICE_INT_MAP_M  ((INTERRUPT_CORE0_USB_DEVICE_INT_MAP_V)<<(INTERRUPT_CORE0_USB_DEVICE_INT_MAP_S))
#define INTERRUPT_CORE0_USB_DEVICE_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_USB_DEVICE_INT_MAP_S  0

#define INTERRUPT_CORE0_PERI_BACKUP_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x184)
/* INTERRUPT_CORE0_PERI_BACKUP_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_PERI_BACKUP_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_PERI_BACKUP_INT_MAP_M  ((INTERRUPT_CORE0_PERI_BACKUP_INT_MAP_V)<<(INTERRUPT_CORE0_PERI_BACKUP_INT_MAP_S))
#define INTERRUPT_CORE0_PERI_BACKUP_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_PERI_BACKUP_INT_MAP_S  0

#define INTERRUPT_CORE0_DMA_EXTMEM_REJECT_INT_MAP_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x188)
/* INTERRUPT_CORE0_DMA_EXTMEM_REJECT_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE0_DMA_EXTMEM_REJECT_INT_MAP  0x0000001F
#define INTERRUPT_CORE0_DMA_EXTMEM_REJECT_INT_MAP_M  ((INTERRUPT_CORE0_DMA_EXTMEM_REJECT_INT_MAP_V)<<(INTERRUPT_CORE0_DMA_EXTMEM_REJECT_INT_MAP_S))
#define INTERRUPT_CORE0_DMA_EXTMEM_REJECT_INT_MAP_V  0x1F
#define INTERRUPT_CORE0_DMA_EXTMEM_REJECT_INT_MAP_S  0

#define INTERRUPT_CORE0_INTR_STATUS_0_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x18C)
/* INTERRUPT_CORE0_INTR_STATUS_0 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define INTERRUPT_CORE0_INTR_STATUS_0  0xFFFFFFFF
#define INTERRUPT_CORE0_INTR_STATUS_0_M  ((INTERRUPT_CORE0_INTR_STATUS_0_V)<<(INTERRUPT_CORE0_INTR_STATUS_0_S))
#define INTERRUPT_CORE0_INTR_STATUS_0_V  0xFFFFFFFF
#define INTERRUPT_CORE0_INTR_STATUS_0_S  0

#define INTERRUPT_CORE0_INTR_STATUS_1_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x190)
/* INTERRUPT_CORE0_INTR_STATUS_1 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define INTERRUPT_CORE0_INTR_STATUS_1  0xFFFFFFFF
#define INTERRUPT_CORE0_INTR_STATUS_1_M  ((INTERRUPT_CORE0_INTR_STATUS_1_V)<<(INTERRUPT_CORE0_INTR_STATUS_1_S))
#define INTERRUPT_CORE0_INTR_STATUS_1_V  0xFFFFFFFF
#define INTERRUPT_CORE0_INTR_STATUS_1_S  0

#define INTERRUPT_CORE0_INTR_STATUS_2_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x194)
/* INTERRUPT_CORE0_INTR_STATUS_2 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define INTERRUPT_CORE0_INTR_STATUS_2  0xFFFFFFFF
#define INTERRUPT_CORE0_INTR_STATUS_2_M  ((INTERRUPT_CORE0_INTR_STATUS_2_V)<<(INTERRUPT_CORE0_INTR_STATUS_2_S))
#define INTERRUPT_CORE0_INTR_STATUS_2_V  0xFFFFFFFF
#define INTERRUPT_CORE0_INTR_STATUS_2_S  0

#define INTERRUPT_CORE0_INTR_STATUS_3_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x198)
/* INTERRUPT_CORE0_INTR_STATUS_3 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define INTERRUPT_CORE0_INTR_STATUS_3  0xFFFFFFFF
#define INTERRUPT_CORE0_INTR_STATUS_3_M  ((INTERRUPT_CORE0_INTR_STATUS_3_V)<<(INTERRUPT_CORE0_INTR_STATUS_3_S))
#define INTERRUPT_CORE0_INTR_STATUS_3_V  0xFFFFFFFF
#define INTERRUPT_CORE0_INTR_STATUS_3_S  0

#define INTERRUPT_CORE0_CLOCK_GATE_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x19c)
/* INTERRUPT_CORE0_CLK_EN : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: */
#define INTERRUPT_CORE0_CLK_EN  (BIT(0))
#define INTERRUPT_CORE0_CLK_EN_M  (BIT(0))
#define INTERRUPT_CORE0_CLK_EN_V  0x1
#define INTERRUPT_CORE0_CLK_EN_S  0

#define INTERRUPT_CORE0_INTERRUPT_DATE_REG          (DR_REG_INTERRUPT_CORE0_BASE + 0x7FC)
/* INTERRUPT_CORE0_INTERRUPT_DATE : R/W ;bitpos:[27:0] ;default: 28'h2012300 ; */
/*description: */
#define INTERRUPT_CORE0_INTERRUPT_DATE  0x0FFFFFFF
#define INTERRUPT_CORE0_INTERRUPT_DATE_M  ((INTERRUPT_CORE0_INTERRUPT_DATE_V)<<(INTERRUPT_CORE0_INTERRUPT_DATE_S))
#define INTERRUPT_CORE0_INTERRUPT_DATE_V  0xFFFFFFF
#define INTERRUPT_CORE0_INTERRUPT_DATE_S  0

#ifdef __cplusplus
}
#endif



#endif /*_SOC_INTERRUPT_CORE0_REG_H_ */
