/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** TEE_LP2HP_PMS_DATE_REG register
 *  NA
 */
#define TEE_LP2HP_PMS_DATE_REG (DR_REG_TEE_BASE + 0x0)
/** TEE_TEE_DATE : R/W; bitpos: [31:0]; default: 2363943;
 *  NA
 */
#define TEE_TEE_DATE    0xFFFFFFFFU
#define TEE_TEE_DATE_M  (TEE_TEE_DATE_V << TEE_TEE_DATE_S)
#define TEE_TEE_DATE_V  0xFFFFFFFFU
#define TEE_TEE_DATE_S  0

/** TEE_PMS_CLK_EN_REG register
 *  NA
 */
#define TEE_PMS_CLK_EN_REG (DR_REG_TEE_BASE + 0x4)
/** TEE_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define TEE_REG_CLK_EN    (BIT(0))
#define TEE_REG_CLK_EN_M  (TEE_REG_CLK_EN_V << TEE_REG_CLK_EN_S)
#define TEE_REG_CLK_EN_V  0x00000001U
#define TEE_REG_CLK_EN_S  0

/** TEE_LP_MM_PMS_REG0_REG register
 *  NA
 */
#define TEE_LP_MM_PMS_REG0_REG (DR_REG_TEE_BASE + 0x8)
/** TEE_REG_LP_MM_PSRAM_ALLOW : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_PSRAM_ALLOW    (BIT(0))
#define TEE_REG_LP_MM_PSRAM_ALLOW_M  (TEE_REG_LP_MM_PSRAM_ALLOW_V << TEE_REG_LP_MM_PSRAM_ALLOW_S)
#define TEE_REG_LP_MM_PSRAM_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_PSRAM_ALLOW_S  0
/** TEE_REG_LP_MM_FLASH_ALLOW : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_FLASH_ALLOW    (BIT(1))
#define TEE_REG_LP_MM_FLASH_ALLOW_M  (TEE_REG_LP_MM_FLASH_ALLOW_V << TEE_REG_LP_MM_FLASH_ALLOW_S)
#define TEE_REG_LP_MM_FLASH_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_FLASH_ALLOW_S  1
/** TEE_REG_LP_MM_L2MEM_ALLOW : R/W; bitpos: [2]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_L2MEM_ALLOW    (BIT(2))
#define TEE_REG_LP_MM_L2MEM_ALLOW_M  (TEE_REG_LP_MM_L2MEM_ALLOW_V << TEE_REG_LP_MM_L2MEM_ALLOW_S)
#define TEE_REG_LP_MM_L2MEM_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_L2MEM_ALLOW_S  2
/** TEE_REG_LP_MM_L2ROM_ALLOW : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_L2ROM_ALLOW    (BIT(3))
#define TEE_REG_LP_MM_L2ROM_ALLOW_M  (TEE_REG_LP_MM_L2ROM_ALLOW_V << TEE_REG_LP_MM_L2ROM_ALLOW_S)
#define TEE_REG_LP_MM_L2ROM_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_L2ROM_ALLOW_S  3
/** TEE_REG_LP_MM_TRACE0_ALLOW : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_TRACE0_ALLOW    (BIT(6))
#define TEE_REG_LP_MM_TRACE0_ALLOW_M  (TEE_REG_LP_MM_TRACE0_ALLOW_V << TEE_REG_LP_MM_TRACE0_ALLOW_S)
#define TEE_REG_LP_MM_TRACE0_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_TRACE0_ALLOW_S  6
/** TEE_REG_LP_MM_TRACE1_ALLOW : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_TRACE1_ALLOW    (BIT(7))
#define TEE_REG_LP_MM_TRACE1_ALLOW_M  (TEE_REG_LP_MM_TRACE1_ALLOW_V << TEE_REG_LP_MM_TRACE1_ALLOW_S)
#define TEE_REG_LP_MM_TRACE1_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_TRACE1_ALLOW_S  7
/** TEE_REG_LP_MM_CPU_BUS_MON_ALLOW : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_CPU_BUS_MON_ALLOW    (BIT(8))
#define TEE_REG_LP_MM_CPU_BUS_MON_ALLOW_M  (TEE_REG_LP_MM_CPU_BUS_MON_ALLOW_V << TEE_REG_LP_MM_CPU_BUS_MON_ALLOW_S)
#define TEE_REG_LP_MM_CPU_BUS_MON_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_CPU_BUS_MON_ALLOW_S  8
/** TEE_REG_LP_MM_L2MEM_MON_ALLOW : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_L2MEM_MON_ALLOW    (BIT(9))
#define TEE_REG_LP_MM_L2MEM_MON_ALLOW_M  (TEE_REG_LP_MM_L2MEM_MON_ALLOW_V << TEE_REG_LP_MM_L2MEM_MON_ALLOW_S)
#define TEE_REG_LP_MM_L2MEM_MON_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_L2MEM_MON_ALLOW_S  9
/** TEE_REG_LP_MM_TCM_MON_ALLOW : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_TCM_MON_ALLOW    (BIT(10))
#define TEE_REG_LP_MM_TCM_MON_ALLOW_M  (TEE_REG_LP_MM_TCM_MON_ALLOW_V << TEE_REG_LP_MM_TCM_MON_ALLOW_S)
#define TEE_REG_LP_MM_TCM_MON_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_TCM_MON_ALLOW_S  10
/** TEE_REG_LP_MM_CACHE_ALLOW : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_CACHE_ALLOW    (BIT(11))
#define TEE_REG_LP_MM_CACHE_ALLOW_M  (TEE_REG_LP_MM_CACHE_ALLOW_V << TEE_REG_LP_MM_CACHE_ALLOW_S)
#define TEE_REG_LP_MM_CACHE_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_CACHE_ALLOW_S  11

/** TEE_LP_MM_PMS_REG1_REG register
 *  NA
 */
#define TEE_LP_MM_PMS_REG1_REG (DR_REG_TEE_BASE + 0x30)
/** TEE_REG_LP_MM_HP_USBOTG_ALLOW : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_USBOTG_ALLOW    (BIT(0))
#define TEE_REG_LP_MM_HP_USBOTG_ALLOW_M  (TEE_REG_LP_MM_HP_USBOTG_ALLOW_V << TEE_REG_LP_MM_HP_USBOTG_ALLOW_S)
#define TEE_REG_LP_MM_HP_USBOTG_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_USBOTG_ALLOW_S  0
/** TEE_REG_LP_MM_HP_USBOTG11_ALLOW : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_USBOTG11_ALLOW    (BIT(1))
#define TEE_REG_LP_MM_HP_USBOTG11_ALLOW_M  (TEE_REG_LP_MM_HP_USBOTG11_ALLOW_V << TEE_REG_LP_MM_HP_USBOTG11_ALLOW_S)
#define TEE_REG_LP_MM_HP_USBOTG11_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_USBOTG11_ALLOW_S  1
/** TEE_REG_LP_MM_HP_USBOTG11_WRAP_ALLOW : R/W; bitpos: [2]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_USBOTG11_WRAP_ALLOW    (BIT(2))
#define TEE_REG_LP_MM_HP_USBOTG11_WRAP_ALLOW_M  (TEE_REG_LP_MM_HP_USBOTG11_WRAP_ALLOW_V << TEE_REG_LP_MM_HP_USBOTG11_WRAP_ALLOW_S)
#define TEE_REG_LP_MM_HP_USBOTG11_WRAP_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_USBOTG11_WRAP_ALLOW_S  2
/** TEE_REG_LP_MM_HP_GDMA_ALLOW : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_GDMA_ALLOW    (BIT(3))
#define TEE_REG_LP_MM_HP_GDMA_ALLOW_M  (TEE_REG_LP_MM_HP_GDMA_ALLOW_V << TEE_REG_LP_MM_HP_GDMA_ALLOW_S)
#define TEE_REG_LP_MM_HP_GDMA_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_GDMA_ALLOW_S  3
/** TEE_REG_LP_MM_HP_REGDMA_ALLOW : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_REGDMA_ALLOW    (BIT(4))
#define TEE_REG_LP_MM_HP_REGDMA_ALLOW_M  (TEE_REG_LP_MM_HP_REGDMA_ALLOW_V << TEE_REG_LP_MM_HP_REGDMA_ALLOW_S)
#define TEE_REG_LP_MM_HP_REGDMA_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_REGDMA_ALLOW_S  4
/** TEE_REG_LP_MM_HP_SDMMC_ALLOW : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_SDMMC_ALLOW    (BIT(5))
#define TEE_REG_LP_MM_HP_SDMMC_ALLOW_M  (TEE_REG_LP_MM_HP_SDMMC_ALLOW_V << TEE_REG_LP_MM_HP_SDMMC_ALLOW_S)
#define TEE_REG_LP_MM_HP_SDMMC_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_SDMMC_ALLOW_S  5
/** TEE_REG_LP_MM_HP_AHB_PDMA_ALLOW : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_AHB_PDMA_ALLOW    (BIT(6))
#define TEE_REG_LP_MM_HP_AHB_PDMA_ALLOW_M  (TEE_REG_LP_MM_HP_AHB_PDMA_ALLOW_V << TEE_REG_LP_MM_HP_AHB_PDMA_ALLOW_S)
#define TEE_REG_LP_MM_HP_AHB_PDMA_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_AHB_PDMA_ALLOW_S  6
/** TEE_REG_LP_MM_HP_JPEG_ALLOW : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_JPEG_ALLOW    (BIT(7))
#define TEE_REG_LP_MM_HP_JPEG_ALLOW_M  (TEE_REG_LP_MM_HP_JPEG_ALLOW_V << TEE_REG_LP_MM_HP_JPEG_ALLOW_S)
#define TEE_REG_LP_MM_HP_JPEG_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_JPEG_ALLOW_S  7
/** TEE_REG_LP_MM_HP_PPA_ALLOW : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_PPA_ALLOW    (BIT(8))
#define TEE_REG_LP_MM_HP_PPA_ALLOW_M  (TEE_REG_LP_MM_HP_PPA_ALLOW_V << TEE_REG_LP_MM_HP_PPA_ALLOW_S)
#define TEE_REG_LP_MM_HP_PPA_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_PPA_ALLOW_S  8
/** TEE_REG_LP_MM_HP_DMA2D_ALLOW : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_DMA2D_ALLOW    (BIT(9))
#define TEE_REG_LP_MM_HP_DMA2D_ALLOW_M  (TEE_REG_LP_MM_HP_DMA2D_ALLOW_V << TEE_REG_LP_MM_HP_DMA2D_ALLOW_S)
#define TEE_REG_LP_MM_HP_DMA2D_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_DMA2D_ALLOW_S  9
/** TEE_REG_LP_MM_HP_KEY_MANAGER_ALLOW : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_KEY_MANAGER_ALLOW    (BIT(10))
#define TEE_REG_LP_MM_HP_KEY_MANAGER_ALLOW_M  (TEE_REG_LP_MM_HP_KEY_MANAGER_ALLOW_V << TEE_REG_LP_MM_HP_KEY_MANAGER_ALLOW_S)
#define TEE_REG_LP_MM_HP_KEY_MANAGER_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_KEY_MANAGER_ALLOW_S  10
/** TEE_REG_LP_MM_HP_AXI_PDMA_ALLOW : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_AXI_PDMA_ALLOW    (BIT(11))
#define TEE_REG_LP_MM_HP_AXI_PDMA_ALLOW_M  (TEE_REG_LP_MM_HP_AXI_PDMA_ALLOW_V << TEE_REG_LP_MM_HP_AXI_PDMA_ALLOW_S)
#define TEE_REG_LP_MM_HP_AXI_PDMA_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_AXI_PDMA_ALLOW_S  11
/** TEE_REG_LP_MM_HP_FLASH_ALLOW : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_FLASH_ALLOW    (BIT(12))
#define TEE_REG_LP_MM_HP_FLASH_ALLOW_M  (TEE_REG_LP_MM_HP_FLASH_ALLOW_V << TEE_REG_LP_MM_HP_FLASH_ALLOW_S)
#define TEE_REG_LP_MM_HP_FLASH_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_FLASH_ALLOW_S  12
/** TEE_REG_LP_MM_HP_PSRAM_ALLOW : R/W; bitpos: [13]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_PSRAM_ALLOW    (BIT(13))
#define TEE_REG_LP_MM_HP_PSRAM_ALLOW_M  (TEE_REG_LP_MM_HP_PSRAM_ALLOW_V << TEE_REG_LP_MM_HP_PSRAM_ALLOW_S)
#define TEE_REG_LP_MM_HP_PSRAM_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_PSRAM_ALLOW_S  13
/** TEE_REG_LP_MM_HP_CRYPTO_ALLOW : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_CRYPTO_ALLOW    (BIT(14))
#define TEE_REG_LP_MM_HP_CRYPTO_ALLOW_M  (TEE_REG_LP_MM_HP_CRYPTO_ALLOW_V << TEE_REG_LP_MM_HP_CRYPTO_ALLOW_S)
#define TEE_REG_LP_MM_HP_CRYPTO_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_CRYPTO_ALLOW_S  14
/** TEE_REG_LP_MM_HP_GMAC_ALLOW : R/W; bitpos: [15]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_GMAC_ALLOW    (BIT(15))
#define TEE_REG_LP_MM_HP_GMAC_ALLOW_M  (TEE_REG_LP_MM_HP_GMAC_ALLOW_V << TEE_REG_LP_MM_HP_GMAC_ALLOW_S)
#define TEE_REG_LP_MM_HP_GMAC_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_GMAC_ALLOW_S  15
/** TEE_REG_LP_MM_HP_USB_PHY_ALLOW : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_USB_PHY_ALLOW    (BIT(16))
#define TEE_REG_LP_MM_HP_USB_PHY_ALLOW_M  (TEE_REG_LP_MM_HP_USB_PHY_ALLOW_V << TEE_REG_LP_MM_HP_USB_PHY_ALLOW_S)
#define TEE_REG_LP_MM_HP_USB_PHY_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_USB_PHY_ALLOW_S  16
/** TEE_REG_LP_MM_HP_PVT_ALLOW : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_PVT_ALLOW    (BIT(17))
#define TEE_REG_LP_MM_HP_PVT_ALLOW_M  (TEE_REG_LP_MM_HP_PVT_ALLOW_V << TEE_REG_LP_MM_HP_PVT_ALLOW_S)
#define TEE_REG_LP_MM_HP_PVT_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_PVT_ALLOW_S  17
/** TEE_REG_LP_MM_HP_CSI_HOST_ALLOW : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_CSI_HOST_ALLOW    (BIT(18))
#define TEE_REG_LP_MM_HP_CSI_HOST_ALLOW_M  (TEE_REG_LP_MM_HP_CSI_HOST_ALLOW_V << TEE_REG_LP_MM_HP_CSI_HOST_ALLOW_S)
#define TEE_REG_LP_MM_HP_CSI_HOST_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_CSI_HOST_ALLOW_S  18
/** TEE_REG_LP_MM_HP_DSI_HOST_ALLOW : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_DSI_HOST_ALLOW    (BIT(19))
#define TEE_REG_LP_MM_HP_DSI_HOST_ALLOW_M  (TEE_REG_LP_MM_HP_DSI_HOST_ALLOW_V << TEE_REG_LP_MM_HP_DSI_HOST_ALLOW_S)
#define TEE_REG_LP_MM_HP_DSI_HOST_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_DSI_HOST_ALLOW_S  19
/** TEE_REG_LP_MM_HP_ISP_ALLOW : R/W; bitpos: [20]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_ISP_ALLOW    (BIT(20))
#define TEE_REG_LP_MM_HP_ISP_ALLOW_M  (TEE_REG_LP_MM_HP_ISP_ALLOW_V << TEE_REG_LP_MM_HP_ISP_ALLOW_S)
#define TEE_REG_LP_MM_HP_ISP_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_ISP_ALLOW_S  20
/** TEE_REG_LP_MM_HP_H264_CORE_ALLOW : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_H264_CORE_ALLOW    (BIT(21))
#define TEE_REG_LP_MM_HP_H264_CORE_ALLOW_M  (TEE_REG_LP_MM_HP_H264_CORE_ALLOW_V << TEE_REG_LP_MM_HP_H264_CORE_ALLOW_S)
#define TEE_REG_LP_MM_HP_H264_CORE_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_H264_CORE_ALLOW_S  21
/** TEE_REG_LP_MM_HP_RMT_ALLOW : R/W; bitpos: [22]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_RMT_ALLOW    (BIT(22))
#define TEE_REG_LP_MM_HP_RMT_ALLOW_M  (TEE_REG_LP_MM_HP_RMT_ALLOW_V << TEE_REG_LP_MM_HP_RMT_ALLOW_S)
#define TEE_REG_LP_MM_HP_RMT_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_RMT_ALLOW_S  22
/** TEE_REG_LP_MM_HP_BITSRAMBLER_ALLOW : R/W; bitpos: [23]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_BITSRAMBLER_ALLOW    (BIT(23))
#define TEE_REG_LP_MM_HP_BITSRAMBLER_ALLOW_M  (TEE_REG_LP_MM_HP_BITSRAMBLER_ALLOW_V << TEE_REG_LP_MM_HP_BITSRAMBLER_ALLOW_S)
#define TEE_REG_LP_MM_HP_BITSRAMBLER_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_BITSRAMBLER_ALLOW_S  23
/** TEE_REG_LP_MM_HP_AXI_ICM_ALLOW : R/W; bitpos: [24]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_AXI_ICM_ALLOW    (BIT(24))
#define TEE_REG_LP_MM_HP_AXI_ICM_ALLOW_M  (TEE_REG_LP_MM_HP_AXI_ICM_ALLOW_V << TEE_REG_LP_MM_HP_AXI_ICM_ALLOW_S)
#define TEE_REG_LP_MM_HP_AXI_ICM_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_AXI_ICM_ALLOW_S  24
/** TEE_REG_LP_MM_HP_PERI_PMS_ALLOW : R/W; bitpos: [25]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_PERI_PMS_ALLOW    (BIT(25))
#define TEE_REG_LP_MM_HP_PERI_PMS_ALLOW_M  (TEE_REG_LP_MM_HP_PERI_PMS_ALLOW_V << TEE_REG_LP_MM_HP_PERI_PMS_ALLOW_S)
#define TEE_REG_LP_MM_HP_PERI_PMS_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_PERI_PMS_ALLOW_S  25
/** TEE_REG_LP_MM_LP2HP_PERI_PMS_ALLOW : R/W; bitpos: [26]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_LP2HP_PERI_PMS_ALLOW    (BIT(26))
#define TEE_REG_LP_MM_LP2HP_PERI_PMS_ALLOW_M  (TEE_REG_LP_MM_LP2HP_PERI_PMS_ALLOW_V << TEE_REG_LP_MM_LP2HP_PERI_PMS_ALLOW_S)
#define TEE_REG_LP_MM_LP2HP_PERI_PMS_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_LP2HP_PERI_PMS_ALLOW_S  26
/** TEE_REG_LP_MM_DMA_PMS_ALLOW : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_DMA_PMS_ALLOW    (BIT(27))
#define TEE_REG_LP_MM_DMA_PMS_ALLOW_M  (TEE_REG_LP_MM_DMA_PMS_ALLOW_V << TEE_REG_LP_MM_DMA_PMS_ALLOW_S)
#define TEE_REG_LP_MM_DMA_PMS_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_DMA_PMS_ALLOW_S  27
/** TEE_REG_LP_MM_HP_H264_DMA2D_ALLOW : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_H264_DMA2D_ALLOW    (BIT(28))
#define TEE_REG_LP_MM_HP_H264_DMA2D_ALLOW_M  (TEE_REG_LP_MM_HP_H264_DMA2D_ALLOW_V << TEE_REG_LP_MM_HP_H264_DMA2D_ALLOW_S)
#define TEE_REG_LP_MM_HP_H264_DMA2D_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_H264_DMA2D_ALLOW_S  28
/** TEE_REG_LP_MM_AXI_PERF_MON_ALLOW : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_AXI_PERF_MON_ALLOW    (BIT(29))
#define TEE_REG_LP_MM_AXI_PERF_MON_ALLOW_M  (TEE_REG_LP_MM_AXI_PERF_MON_ALLOW_V << TEE_REG_LP_MM_AXI_PERF_MON_ALLOW_S)
#define TEE_REG_LP_MM_AXI_PERF_MON_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_AXI_PERF_MON_ALLOW_S  29

/** TEE_LP_MM_PMS_REG2_REG register
 *  NA
 */
#define TEE_LP_MM_PMS_REG2_REG (DR_REG_TEE_BASE + 0xa4)
/** TEE_REG_LP_MM_HP_MCPWM0_ALLOW : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_MCPWM0_ALLOW    (BIT(0))
#define TEE_REG_LP_MM_HP_MCPWM0_ALLOW_M  (TEE_REG_LP_MM_HP_MCPWM0_ALLOW_V << TEE_REG_LP_MM_HP_MCPWM0_ALLOW_S)
#define TEE_REG_LP_MM_HP_MCPWM0_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_MCPWM0_ALLOW_S  0
/** TEE_REG_LP_MM_HP_MCPWM1_ALLOW : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_MCPWM1_ALLOW    (BIT(1))
#define TEE_REG_LP_MM_HP_MCPWM1_ALLOW_M  (TEE_REG_LP_MM_HP_MCPWM1_ALLOW_V << TEE_REG_LP_MM_HP_MCPWM1_ALLOW_S)
#define TEE_REG_LP_MM_HP_MCPWM1_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_MCPWM1_ALLOW_S  1
/** TEE_REG_LP_MM_HP_TIMER_GROUP0_ALLOW : R/W; bitpos: [2]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_TIMER_GROUP0_ALLOW    (BIT(2))
#define TEE_REG_LP_MM_HP_TIMER_GROUP0_ALLOW_M  (TEE_REG_LP_MM_HP_TIMER_GROUP0_ALLOW_V << TEE_REG_LP_MM_HP_TIMER_GROUP0_ALLOW_S)
#define TEE_REG_LP_MM_HP_TIMER_GROUP0_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_TIMER_GROUP0_ALLOW_S  2
/** TEE_REG_LP_MM_HP_TIMER_GROUP1_ALLOW : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_TIMER_GROUP1_ALLOW    (BIT(3))
#define TEE_REG_LP_MM_HP_TIMER_GROUP1_ALLOW_M  (TEE_REG_LP_MM_HP_TIMER_GROUP1_ALLOW_V << TEE_REG_LP_MM_HP_TIMER_GROUP1_ALLOW_S)
#define TEE_REG_LP_MM_HP_TIMER_GROUP1_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_TIMER_GROUP1_ALLOW_S  3
/** TEE_REG_LP_MM_HP_I2C0_ALLOW : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_I2C0_ALLOW    (BIT(4))
#define TEE_REG_LP_MM_HP_I2C0_ALLOW_M  (TEE_REG_LP_MM_HP_I2C0_ALLOW_V << TEE_REG_LP_MM_HP_I2C0_ALLOW_S)
#define TEE_REG_LP_MM_HP_I2C0_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_I2C0_ALLOW_S  4
/** TEE_REG_LP_MM_HP_I2C1_ALLOW : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_I2C1_ALLOW    (BIT(5))
#define TEE_REG_LP_MM_HP_I2C1_ALLOW_M  (TEE_REG_LP_MM_HP_I2C1_ALLOW_V << TEE_REG_LP_MM_HP_I2C1_ALLOW_S)
#define TEE_REG_LP_MM_HP_I2C1_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_I2C1_ALLOW_S  5
/** TEE_REG_LP_MM_HP_I2S0_ALLOW : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_I2S0_ALLOW    (BIT(6))
#define TEE_REG_LP_MM_HP_I2S0_ALLOW_M  (TEE_REG_LP_MM_HP_I2S0_ALLOW_V << TEE_REG_LP_MM_HP_I2S0_ALLOW_S)
#define TEE_REG_LP_MM_HP_I2S0_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_I2S0_ALLOW_S  6
/** TEE_REG_LP_MM_HP_I2S1_ALLOW : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_I2S1_ALLOW    (BIT(7))
#define TEE_REG_LP_MM_HP_I2S1_ALLOW_M  (TEE_REG_LP_MM_HP_I2S1_ALLOW_V << TEE_REG_LP_MM_HP_I2S1_ALLOW_S)
#define TEE_REG_LP_MM_HP_I2S1_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_I2S1_ALLOW_S  7
/** TEE_REG_LP_MM_HP_I2S2_ALLOW : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_I2S2_ALLOW    (BIT(8))
#define TEE_REG_LP_MM_HP_I2S2_ALLOW_M  (TEE_REG_LP_MM_HP_I2S2_ALLOW_V << TEE_REG_LP_MM_HP_I2S2_ALLOW_S)
#define TEE_REG_LP_MM_HP_I2S2_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_I2S2_ALLOW_S  8
/** TEE_REG_LP_MM_HP_PCNT_ALLOW : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_PCNT_ALLOW    (BIT(9))
#define TEE_REG_LP_MM_HP_PCNT_ALLOW_M  (TEE_REG_LP_MM_HP_PCNT_ALLOW_V << TEE_REG_LP_MM_HP_PCNT_ALLOW_S)
#define TEE_REG_LP_MM_HP_PCNT_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_PCNT_ALLOW_S  9
/** TEE_REG_LP_MM_HP_UART0_ALLOW : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_UART0_ALLOW    (BIT(10))
#define TEE_REG_LP_MM_HP_UART0_ALLOW_M  (TEE_REG_LP_MM_HP_UART0_ALLOW_V << TEE_REG_LP_MM_HP_UART0_ALLOW_S)
#define TEE_REG_LP_MM_HP_UART0_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_UART0_ALLOW_S  10
/** TEE_REG_LP_MM_HP_UART1_ALLOW : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_UART1_ALLOW    (BIT(11))
#define TEE_REG_LP_MM_HP_UART1_ALLOW_M  (TEE_REG_LP_MM_HP_UART1_ALLOW_V << TEE_REG_LP_MM_HP_UART1_ALLOW_S)
#define TEE_REG_LP_MM_HP_UART1_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_UART1_ALLOW_S  11
/** TEE_REG_LP_MM_HP_UART2_ALLOW : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_UART2_ALLOW    (BIT(12))
#define TEE_REG_LP_MM_HP_UART2_ALLOW_M  (TEE_REG_LP_MM_HP_UART2_ALLOW_V << TEE_REG_LP_MM_HP_UART2_ALLOW_S)
#define TEE_REG_LP_MM_HP_UART2_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_UART2_ALLOW_S  12
/** TEE_REG_LP_MM_HP_UART3_ALLOW : R/W; bitpos: [13]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_UART3_ALLOW    (BIT(13))
#define TEE_REG_LP_MM_HP_UART3_ALLOW_M  (TEE_REG_LP_MM_HP_UART3_ALLOW_V << TEE_REG_LP_MM_HP_UART3_ALLOW_S)
#define TEE_REG_LP_MM_HP_UART3_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_UART3_ALLOW_S  13
/** TEE_REG_LP_MM_HP_UART4_ALLOW : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_UART4_ALLOW    (BIT(14))
#define TEE_REG_LP_MM_HP_UART4_ALLOW_M  (TEE_REG_LP_MM_HP_UART4_ALLOW_V << TEE_REG_LP_MM_HP_UART4_ALLOW_S)
#define TEE_REG_LP_MM_HP_UART4_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_UART4_ALLOW_S  14
/** TEE_REG_LP_MM_HP_PARLIO_ALLOW : R/W; bitpos: [15]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_PARLIO_ALLOW    (BIT(15))
#define TEE_REG_LP_MM_HP_PARLIO_ALLOW_M  (TEE_REG_LP_MM_HP_PARLIO_ALLOW_V << TEE_REG_LP_MM_HP_PARLIO_ALLOW_S)
#define TEE_REG_LP_MM_HP_PARLIO_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_PARLIO_ALLOW_S  15
/** TEE_REG_LP_MM_HP_GPSPI2_ALLOW : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_GPSPI2_ALLOW    (BIT(16))
#define TEE_REG_LP_MM_HP_GPSPI2_ALLOW_M  (TEE_REG_LP_MM_HP_GPSPI2_ALLOW_V << TEE_REG_LP_MM_HP_GPSPI2_ALLOW_S)
#define TEE_REG_LP_MM_HP_GPSPI2_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_GPSPI2_ALLOW_S  16
/** TEE_REG_LP_MM_HP_GPSPI3_ALLOW : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_GPSPI3_ALLOW    (BIT(17))
#define TEE_REG_LP_MM_HP_GPSPI3_ALLOW_M  (TEE_REG_LP_MM_HP_GPSPI3_ALLOW_V << TEE_REG_LP_MM_HP_GPSPI3_ALLOW_S)
#define TEE_REG_LP_MM_HP_GPSPI3_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_GPSPI3_ALLOW_S  17
/** TEE_REG_LP_MM_HP_USBDEVICE_ALLOW : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_USBDEVICE_ALLOW    (BIT(18))
#define TEE_REG_LP_MM_HP_USBDEVICE_ALLOW_M  (TEE_REG_LP_MM_HP_USBDEVICE_ALLOW_V << TEE_REG_LP_MM_HP_USBDEVICE_ALLOW_S)
#define TEE_REG_LP_MM_HP_USBDEVICE_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_USBDEVICE_ALLOW_S  18
/** TEE_REG_LP_MM_HP_LEDC_ALLOW : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_LEDC_ALLOW    (BIT(19))
#define TEE_REG_LP_MM_HP_LEDC_ALLOW_M  (TEE_REG_LP_MM_HP_LEDC_ALLOW_V << TEE_REG_LP_MM_HP_LEDC_ALLOW_S)
#define TEE_REG_LP_MM_HP_LEDC_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_LEDC_ALLOW_S  19
/** TEE_REG_LP_MM_HP_ETM_ALLOW : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_ETM_ALLOW    (BIT(21))
#define TEE_REG_LP_MM_HP_ETM_ALLOW_M  (TEE_REG_LP_MM_HP_ETM_ALLOW_V << TEE_REG_LP_MM_HP_ETM_ALLOW_S)
#define TEE_REG_LP_MM_HP_ETM_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_ETM_ALLOW_S  21
/** TEE_REG_LP_MM_HP_INTRMTX_ALLOW : R/W; bitpos: [22]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_INTRMTX_ALLOW    (BIT(22))
#define TEE_REG_LP_MM_HP_INTRMTX_ALLOW_M  (TEE_REG_LP_MM_HP_INTRMTX_ALLOW_V << TEE_REG_LP_MM_HP_INTRMTX_ALLOW_S)
#define TEE_REG_LP_MM_HP_INTRMTX_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_INTRMTX_ALLOW_S  22
/** TEE_REG_LP_MM_HP_TWAI0_ALLOW : R/W; bitpos: [23]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_TWAI0_ALLOW    (BIT(23))
#define TEE_REG_LP_MM_HP_TWAI0_ALLOW_M  (TEE_REG_LP_MM_HP_TWAI0_ALLOW_V << TEE_REG_LP_MM_HP_TWAI0_ALLOW_S)
#define TEE_REG_LP_MM_HP_TWAI0_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_TWAI0_ALLOW_S  23
/** TEE_REG_LP_MM_HP_TWAI1_ALLOW : R/W; bitpos: [24]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_TWAI1_ALLOW    (BIT(24))
#define TEE_REG_LP_MM_HP_TWAI1_ALLOW_M  (TEE_REG_LP_MM_HP_TWAI1_ALLOW_V << TEE_REG_LP_MM_HP_TWAI1_ALLOW_S)
#define TEE_REG_LP_MM_HP_TWAI1_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_TWAI1_ALLOW_S  24
/** TEE_REG_LP_MM_HP_TWAI2_ALLOW : R/W; bitpos: [25]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_TWAI2_ALLOW    (BIT(25))
#define TEE_REG_LP_MM_HP_TWAI2_ALLOW_M  (TEE_REG_LP_MM_HP_TWAI2_ALLOW_V << TEE_REG_LP_MM_HP_TWAI2_ALLOW_S)
#define TEE_REG_LP_MM_HP_TWAI2_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_TWAI2_ALLOW_S  25
/** TEE_REG_LP_MM_HP_I3C_MST_ALLOW : R/W; bitpos: [26]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_I3C_MST_ALLOW    (BIT(26))
#define TEE_REG_LP_MM_HP_I3C_MST_ALLOW_M  (TEE_REG_LP_MM_HP_I3C_MST_ALLOW_V << TEE_REG_LP_MM_HP_I3C_MST_ALLOW_S)
#define TEE_REG_LP_MM_HP_I3C_MST_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_I3C_MST_ALLOW_S  26
/** TEE_REG_LP_MM_HP_I3C_SLV_ALLOW : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_I3C_SLV_ALLOW    (BIT(27))
#define TEE_REG_LP_MM_HP_I3C_SLV_ALLOW_M  (TEE_REG_LP_MM_HP_I3C_SLV_ALLOW_V << TEE_REG_LP_MM_HP_I3C_SLV_ALLOW_S)
#define TEE_REG_LP_MM_HP_I3C_SLV_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_I3C_SLV_ALLOW_S  27
/** TEE_REG_LP_MM_HP_LCDCAM_ALLOW : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_LCDCAM_ALLOW    (BIT(28))
#define TEE_REG_LP_MM_HP_LCDCAM_ALLOW_M  (TEE_REG_LP_MM_HP_LCDCAM_ALLOW_V << TEE_REG_LP_MM_HP_LCDCAM_ALLOW_S)
#define TEE_REG_LP_MM_HP_LCDCAM_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_LCDCAM_ALLOW_S  28
/** TEE_REG_LP_MM_HP_ADC_ALLOW : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_ADC_ALLOW    (BIT(30))
#define TEE_REG_LP_MM_HP_ADC_ALLOW_M  (TEE_REG_LP_MM_HP_ADC_ALLOW_V << TEE_REG_LP_MM_HP_ADC_ALLOW_S)
#define TEE_REG_LP_MM_HP_ADC_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_ADC_ALLOW_S  30
/** TEE_REG_LP_MM_HP_UHCI_ALLOW : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_UHCI_ALLOW    (BIT(31))
#define TEE_REG_LP_MM_HP_UHCI_ALLOW_M  (TEE_REG_LP_MM_HP_UHCI_ALLOW_V << TEE_REG_LP_MM_HP_UHCI_ALLOW_S)
#define TEE_REG_LP_MM_HP_UHCI_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_UHCI_ALLOW_S  31

/** TEE_LP_MM_PMS_REG3_REG register
 *  NA
 */
#define TEE_LP_MM_PMS_REG3_REG (DR_REG_TEE_BASE + 0x11c)
/** TEE_REG_LP_MM_HP_GPIO_ALLOW : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_GPIO_ALLOW    (BIT(0))
#define TEE_REG_LP_MM_HP_GPIO_ALLOW_M  (TEE_REG_LP_MM_HP_GPIO_ALLOW_V << TEE_REG_LP_MM_HP_GPIO_ALLOW_S)
#define TEE_REG_LP_MM_HP_GPIO_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_GPIO_ALLOW_S  0
/** TEE_REG_LP_MM_HP_IOMUX_ALLOW : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_IOMUX_ALLOW    (BIT(1))
#define TEE_REG_LP_MM_HP_IOMUX_ALLOW_M  (TEE_REG_LP_MM_HP_IOMUX_ALLOW_V << TEE_REG_LP_MM_HP_IOMUX_ALLOW_S)
#define TEE_REG_LP_MM_HP_IOMUX_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_IOMUX_ALLOW_S  1
/** TEE_REG_LP_MM_HP_SYSTIMER_ALLOW : R/W; bitpos: [2]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_SYSTIMER_ALLOW    (BIT(2))
#define TEE_REG_LP_MM_HP_SYSTIMER_ALLOW_M  (TEE_REG_LP_MM_HP_SYSTIMER_ALLOW_V << TEE_REG_LP_MM_HP_SYSTIMER_ALLOW_S)
#define TEE_REG_LP_MM_HP_SYSTIMER_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_SYSTIMER_ALLOW_S  2
/** TEE_REG_LP_MM_HP_SYS_REG_ALLOW : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_SYS_REG_ALLOW    (BIT(3))
#define TEE_REG_LP_MM_HP_SYS_REG_ALLOW_M  (TEE_REG_LP_MM_HP_SYS_REG_ALLOW_V << TEE_REG_LP_MM_HP_SYS_REG_ALLOW_S)
#define TEE_REG_LP_MM_HP_SYS_REG_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_SYS_REG_ALLOW_S  3
/** TEE_REG_LP_MM_HP_CLKRST_ALLOW : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define TEE_REG_LP_MM_HP_CLKRST_ALLOW    (BIT(4))
#define TEE_REG_LP_MM_HP_CLKRST_ALLOW_M  (TEE_REG_LP_MM_HP_CLKRST_ALLOW_V << TEE_REG_LP_MM_HP_CLKRST_ALLOW_S)
#define TEE_REG_LP_MM_HP_CLKRST_ALLOW_V  0x00000001U
#define TEE_REG_LP_MM_HP_CLKRST_ALLOW_S  4

#ifdef __cplusplus
}
#endif
