/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** IOMUX_MSPI_PIN_CLK_EN0_REG register
 *  apb registers auto clock gating reg
 */
#define IOMUX_MSPI_PIN_CLK_EN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x0)
/** IOMUX_MSPI_PIN_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  1: auto clock gating on
 *  0: auto clock gating off
 */
#define IOMUX_MSPI_PIN_REG_CLK_EN    (BIT(0))
#define IOMUX_MSPI_PIN_REG_CLK_EN_M  (IOMUX_MSPI_PIN_REG_CLK_EN_V << IOMUX_MSPI_PIN_REG_CLK_EN_S)
#define IOMUX_MSPI_PIN_REG_CLK_EN_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_CLK_EN_S  0

/** IOMUX_MSPI_PIN_FLASH_CS_PIN0_REG register
 *  IOMUX_MSPI_PIN_FLASH_CS_PIN0_REG
 */
#define IOMUX_MSPI_PIN_FLASH_CS_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x4)
/** IOMUX_MSPI_PIN_REG_FLASH_CS_HYS : R/W; bitpos: [0]; default: 0;
 *  flash cs hys
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CS_HYS    (BIT(0))
#define IOMUX_MSPI_PIN_REG_FLASH_CS_HYS_M  (IOMUX_MSPI_PIN_REG_FLASH_CS_HYS_V << IOMUX_MSPI_PIN_REG_FLASH_CS_HYS_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CS_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_CS_HYS_S  0
/** IOMUX_MSPI_PIN_REG_FLASH_CS_IE : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CS_IE    (BIT(1))
#define IOMUX_MSPI_PIN_REG_FLASH_CS_IE_M  (IOMUX_MSPI_PIN_REG_FLASH_CS_IE_V << IOMUX_MSPI_PIN_REG_FLASH_CS_IE_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CS_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_CS_IE_S  1
/** IOMUX_MSPI_PIN_REG_FLASH_CS_WPU : R/W; bitpos: [2]; default: 0;
 *  flash cs wpu
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CS_WPU    (BIT(2))
#define IOMUX_MSPI_PIN_REG_FLASH_CS_WPU_M  (IOMUX_MSPI_PIN_REG_FLASH_CS_WPU_V << IOMUX_MSPI_PIN_REG_FLASH_CS_WPU_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CS_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_CS_WPU_S  2
/** IOMUX_MSPI_PIN_REG_FLASH_CS_WPD : R/W; bitpos: [3]; default: 0;
 *  flash cs wpd
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CS_WPD    (BIT(3))
#define IOMUX_MSPI_PIN_REG_FLASH_CS_WPD_M  (IOMUX_MSPI_PIN_REG_FLASH_CS_WPD_V << IOMUX_MSPI_PIN_REG_FLASH_CS_WPD_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CS_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_CS_WPD_S  3
/** IOMUX_MSPI_PIN_REG_FLASH_CS_DRV : R/W; bitpos: [5:4]; default: 0;
 *  flash cs drv
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CS_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_CS_DRV_M  (IOMUX_MSPI_PIN_REG_FLASH_CS_DRV_V << IOMUX_MSPI_PIN_REG_FLASH_CS_DRV_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CS_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_CS_DRV_S  4

/** IOMUX_MSPI_PIN_FLASH_Q_PIN0_REG register
 *  IOMUX_MSPI_PIN_FLASH_Q_PIN0_REG
 */
#define IOMUX_MSPI_PIN_FLASH_Q_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x8)
/** IOMUX_MSPI_PIN_REG_FLASH_Q_HYS : R/W; bitpos: [0]; default: 0;
 *  flash q hys
 */
#define IOMUX_MSPI_PIN_REG_FLASH_Q_HYS    (BIT(0))
#define IOMUX_MSPI_PIN_REG_FLASH_Q_HYS_M  (IOMUX_MSPI_PIN_REG_FLASH_Q_HYS_V << IOMUX_MSPI_PIN_REG_FLASH_Q_HYS_S)
#define IOMUX_MSPI_PIN_REG_FLASH_Q_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_Q_HYS_S  0
/** IOMUX_MSPI_PIN_REG_FLASH_Q_IE : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_FLASH_Q_IE    (BIT(1))
#define IOMUX_MSPI_PIN_REG_FLASH_Q_IE_M  (IOMUX_MSPI_PIN_REG_FLASH_Q_IE_V << IOMUX_MSPI_PIN_REG_FLASH_Q_IE_S)
#define IOMUX_MSPI_PIN_REG_FLASH_Q_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_Q_IE_S  1
/** IOMUX_MSPI_PIN_REG_FLASH_Q_WPU : R/W; bitpos: [2]; default: 0;
 *  flash q wpu
 */
#define IOMUX_MSPI_PIN_REG_FLASH_Q_WPU    (BIT(2))
#define IOMUX_MSPI_PIN_REG_FLASH_Q_WPU_M  (IOMUX_MSPI_PIN_REG_FLASH_Q_WPU_V << IOMUX_MSPI_PIN_REG_FLASH_Q_WPU_S)
#define IOMUX_MSPI_PIN_REG_FLASH_Q_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_Q_WPU_S  2
/** IOMUX_MSPI_PIN_REG_FLASH_Q_WPD : R/W; bitpos: [3]; default: 0;
 *  flash q wpd
 */
#define IOMUX_MSPI_PIN_REG_FLASH_Q_WPD    (BIT(3))
#define IOMUX_MSPI_PIN_REG_FLASH_Q_WPD_M  (IOMUX_MSPI_PIN_REG_FLASH_Q_WPD_V << IOMUX_MSPI_PIN_REG_FLASH_Q_WPD_S)
#define IOMUX_MSPI_PIN_REG_FLASH_Q_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_Q_WPD_S  3
/** IOMUX_MSPI_PIN_REG_FLASH_Q_DRV : R/W; bitpos: [5:4]; default: 0;
 *  flash q drv
 */
#define IOMUX_MSPI_PIN_REG_FLASH_Q_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_Q_DRV_M  (IOMUX_MSPI_PIN_REG_FLASH_Q_DRV_V << IOMUX_MSPI_PIN_REG_FLASH_Q_DRV_S)
#define IOMUX_MSPI_PIN_REG_FLASH_Q_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_Q_DRV_S  4

/** IOMUX_MSPI_PIN_FLASH_WP_PIN0_REG register
 *  IOMUX_MSPI_PIN_FLASH_WP_PIN0_REG
 */
#define IOMUX_MSPI_PIN_FLASH_WP_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0xc)
/** IOMUX_MSPI_PIN_REG_FLASH_WP_HYS : R/W; bitpos: [0]; default: 0;
 *  flash wp hys
 */
#define IOMUX_MSPI_PIN_REG_FLASH_WP_HYS    (BIT(0))
#define IOMUX_MSPI_PIN_REG_FLASH_WP_HYS_M  (IOMUX_MSPI_PIN_REG_FLASH_WP_HYS_V << IOMUX_MSPI_PIN_REG_FLASH_WP_HYS_S)
#define IOMUX_MSPI_PIN_REG_FLASH_WP_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_WP_HYS_S  0
/** IOMUX_MSPI_PIN_REG_FLASH_WP_IE : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_FLASH_WP_IE    (BIT(1))
#define IOMUX_MSPI_PIN_REG_FLASH_WP_IE_M  (IOMUX_MSPI_PIN_REG_FLASH_WP_IE_V << IOMUX_MSPI_PIN_REG_FLASH_WP_IE_S)
#define IOMUX_MSPI_PIN_REG_FLASH_WP_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_WP_IE_S  1
/** IOMUX_MSPI_PIN_REG_FLASH_WP_WPU : R/W; bitpos: [2]; default: 0;
 *  flash wp wpu
 */
#define IOMUX_MSPI_PIN_REG_FLASH_WP_WPU    (BIT(2))
#define IOMUX_MSPI_PIN_REG_FLASH_WP_WPU_M  (IOMUX_MSPI_PIN_REG_FLASH_WP_WPU_V << IOMUX_MSPI_PIN_REG_FLASH_WP_WPU_S)
#define IOMUX_MSPI_PIN_REG_FLASH_WP_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_WP_WPU_S  2
/** IOMUX_MSPI_PIN_REG_FLASH_WP_WPD : R/W; bitpos: [3]; default: 0;
 *  flash wp wpd
 */
#define IOMUX_MSPI_PIN_REG_FLASH_WP_WPD    (BIT(3))
#define IOMUX_MSPI_PIN_REG_FLASH_WP_WPD_M  (IOMUX_MSPI_PIN_REG_FLASH_WP_WPD_V << IOMUX_MSPI_PIN_REG_FLASH_WP_WPD_S)
#define IOMUX_MSPI_PIN_REG_FLASH_WP_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_WP_WPD_S  3
/** IOMUX_MSPI_PIN_REG_FLASH_WP_DRV : R/W; bitpos: [5:4]; default: 0;
 *  flash wp drv
 */
#define IOMUX_MSPI_PIN_REG_FLASH_WP_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_WP_DRV_M  (IOMUX_MSPI_PIN_REG_FLASH_WP_DRV_V << IOMUX_MSPI_PIN_REG_FLASH_WP_DRV_S)
#define IOMUX_MSPI_PIN_REG_FLASH_WP_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_WP_DRV_S  4

/** IOMUX_MSPI_PIN_FLASH_HOLD_PIN0_REG register
 *  IOMUX_MSPI_PIN_FLASH_HOLD_PIN0_REG
 */
#define IOMUX_MSPI_PIN_FLASH_HOLD_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x10)
/** IOMUX_MSPI_PIN_REG_FLASH_HOLD_HYS : R/W; bitpos: [0]; default: 0;
 *  flash hold hys
 */
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_HYS    (BIT(0))
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_HYS_M  (IOMUX_MSPI_PIN_REG_FLASH_HOLD_HYS_V << IOMUX_MSPI_PIN_REG_FLASH_HOLD_HYS_S)
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_HYS_S  0
/** IOMUX_MSPI_PIN_REG_FLASH_HOLD_IE : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_IE    (BIT(1))
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_IE_M  (IOMUX_MSPI_PIN_REG_FLASH_HOLD_IE_V << IOMUX_MSPI_PIN_REG_FLASH_HOLD_IE_S)
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_IE_S  1
/** IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPU : R/W; bitpos: [2]; default: 0;
 *  flash hold wpu
 */
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPU    (BIT(2))
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPU_M  (IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPU_V << IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPU_S)
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPU_S  2
/** IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPD : R/W; bitpos: [3]; default: 0;
 *  flash hold wpd
 */
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPD    (BIT(3))
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPD_M  (IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPD_V << IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPD_S)
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_WPD_S  3
/** IOMUX_MSPI_PIN_REG_FLASH_HOLD_DRV : R/W; bitpos: [5:4]; default: 0;
 *  flash hold drv
 */
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_DRV_M  (IOMUX_MSPI_PIN_REG_FLASH_HOLD_DRV_V << IOMUX_MSPI_PIN_REG_FLASH_HOLD_DRV_S)
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_HOLD_DRV_S  4

/** IOMUX_MSPI_PIN_FLASH_CK_PIN0_REG register
 *  IOMUX_MSPI_PIN_FLASH_CK_PIN0_REG
 */
#define IOMUX_MSPI_PIN_FLASH_CK_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x14)
/** IOMUX_MSPI_PIN_REG_FLASH_CK_HYS : R/W; bitpos: [0]; default: 0;
 *  flash ck hys
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CK_HYS    (BIT(0))
#define IOMUX_MSPI_PIN_REG_FLASH_CK_HYS_M  (IOMUX_MSPI_PIN_REG_FLASH_CK_HYS_V << IOMUX_MSPI_PIN_REG_FLASH_CK_HYS_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CK_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_CK_HYS_S  0
/** IOMUX_MSPI_PIN_REG_FLASH_CK_IE : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CK_IE    (BIT(1))
#define IOMUX_MSPI_PIN_REG_FLASH_CK_IE_M  (IOMUX_MSPI_PIN_REG_FLASH_CK_IE_V << IOMUX_MSPI_PIN_REG_FLASH_CK_IE_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CK_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_CK_IE_S  1
/** IOMUX_MSPI_PIN_REG_FLASH_CK_WPU : R/W; bitpos: [2]; default: 0;
 *  flash ck wpu
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CK_WPU    (BIT(2))
#define IOMUX_MSPI_PIN_REG_FLASH_CK_WPU_M  (IOMUX_MSPI_PIN_REG_FLASH_CK_WPU_V << IOMUX_MSPI_PIN_REG_FLASH_CK_WPU_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CK_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_CK_WPU_S  2
/** IOMUX_MSPI_PIN_REG_FLASH_CK_WPD : R/W; bitpos: [3]; default: 0;
 *  flash ck wpd
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CK_WPD    (BIT(3))
#define IOMUX_MSPI_PIN_REG_FLASH_CK_WPD_M  (IOMUX_MSPI_PIN_REG_FLASH_CK_WPD_V << IOMUX_MSPI_PIN_REG_FLASH_CK_WPD_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CK_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_CK_WPD_S  3
/** IOMUX_MSPI_PIN_REG_FLASH_CK_DRV : R/W; bitpos: [5:4]; default: 0;
 *  flash ck drv
 */
#define IOMUX_MSPI_PIN_REG_FLASH_CK_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_CK_DRV_M  (IOMUX_MSPI_PIN_REG_FLASH_CK_DRV_V << IOMUX_MSPI_PIN_REG_FLASH_CK_DRV_S)
#define IOMUX_MSPI_PIN_REG_FLASH_CK_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_CK_DRV_S  4

/** IOMUX_MSPI_PIN_FLASH_D_PIN0_REG register
 *  IOMUX_MSPI_PIN_FLASH_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_FLASH_D_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x18)
/** IOMUX_MSPI_PIN_REG_FLASH_D_HYS : R/W; bitpos: [0]; default: 0;
 *  flash d hys
 */
#define IOMUX_MSPI_PIN_REG_FLASH_D_HYS    (BIT(0))
#define IOMUX_MSPI_PIN_REG_FLASH_D_HYS_M  (IOMUX_MSPI_PIN_REG_FLASH_D_HYS_V << IOMUX_MSPI_PIN_REG_FLASH_D_HYS_S)
#define IOMUX_MSPI_PIN_REG_FLASH_D_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_D_HYS_S  0
/** IOMUX_MSPI_PIN_REG_FLASH_D_IE : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_FLASH_D_IE    (BIT(1))
#define IOMUX_MSPI_PIN_REG_FLASH_D_IE_M  (IOMUX_MSPI_PIN_REG_FLASH_D_IE_V << IOMUX_MSPI_PIN_REG_FLASH_D_IE_S)
#define IOMUX_MSPI_PIN_REG_FLASH_D_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_D_IE_S  1
/** IOMUX_MSPI_PIN_REG_FLASH_D_WPU : R/W; bitpos: [2]; default: 0;
 *  flash d wpu
 */
#define IOMUX_MSPI_PIN_REG_FLASH_D_WPU    (BIT(2))
#define IOMUX_MSPI_PIN_REG_FLASH_D_WPU_M  (IOMUX_MSPI_PIN_REG_FLASH_D_WPU_V << IOMUX_MSPI_PIN_REG_FLASH_D_WPU_S)
#define IOMUX_MSPI_PIN_REG_FLASH_D_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_D_WPU_S  2
/** IOMUX_MSPI_PIN_REG_FLASH_D_WPD : R/W; bitpos: [3]; default: 0;
 *  flash d wpd
 */
#define IOMUX_MSPI_PIN_REG_FLASH_D_WPD    (BIT(3))
#define IOMUX_MSPI_PIN_REG_FLASH_D_WPD_M  (IOMUX_MSPI_PIN_REG_FLASH_D_WPD_V << IOMUX_MSPI_PIN_REG_FLASH_D_WPD_S)
#define IOMUX_MSPI_PIN_REG_FLASH_D_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_FLASH_D_WPD_S  3
/** IOMUX_MSPI_PIN_REG_FLASH_D_DRV : R/W; bitpos: [5:4]; default: 0;
 *  flash d drv
 */
#define IOMUX_MSPI_PIN_REG_FLASH_D_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_D_DRV_M  (IOMUX_MSPI_PIN_REG_FLASH_D_DRV_V << IOMUX_MSPI_PIN_REG_FLASH_D_DRV_S)
#define IOMUX_MSPI_PIN_REG_FLASH_D_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_FLASH_D_DRV_S  4

/** IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x1c)
/** IOMUX_MSPI_PIN_REG_PSRAM_D_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram d dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_D_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_D_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_D_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram d dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_D_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_D_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_D_HYS : R/W; bitpos: [8]; default: 0;
 *  psram d hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_D_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_D_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_D_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_D_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_D_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_D_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_D_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_D_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_D_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_D_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_D_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_D_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_D_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_D_WPU : R/W; bitpos: [10]; default: 0;
 *  psram d wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_D_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_D_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_D_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_D_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_D_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_D_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_D_WPD : R/W; bitpos: [11]; default: 0;
 *  psram d wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_D_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_D_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_D_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_D_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_D_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_D_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_D_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram d drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_D_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_D_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_D_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_Q_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_Q_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x20)
/** IOMUX_MSPI_PIN_REG_PSRAM_Q_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram q dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_Q_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_Q_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_Q_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram q dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_Q_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_Q_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_Q_HYS : R/W; bitpos: [8]; default: 0;
 *  psram q hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_Q_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_Q_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_Q_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_Q_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_Q_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_Q_WPU : R/W; bitpos: [10]; default: 0;
 *  psram q wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_Q_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_Q_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_Q_WPD : R/W; bitpos: [11]; default: 0;
 *  psram q wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_Q_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_Q_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_Q_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram q drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_Q_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_Q_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_Q_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_WP_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_WP_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x24)
/** IOMUX_MSPI_PIN_REG_PSRAM_WP_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram wp dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_WP_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_WP_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_WP_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram wp dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_WP_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_WP_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_WP_HYS : R/W; bitpos: [8]; default: 0;
 *  psram wp hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_WP_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_WP_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_WP_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_WP_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_WP_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_WP_WPU : R/W; bitpos: [10]; default: 0;
 *  psram wp wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_WP_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_WP_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_WP_WPD : R/W; bitpos: [11]; default: 0;
 *  psram wp wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_WP_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_WP_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_WP_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram wp drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_WP_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_WP_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_WP_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_HOLD_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_HOLD_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x28)
/** IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram hold dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram hold dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_HOLD_HYS : R/W; bitpos: [8]; default: 0;
 *  psram hold hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_HOLD_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_HOLD_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_HOLD_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_HOLD_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_HOLD_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPU : R/W; bitpos: [10]; default: 0;
 *  psram hold wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPD : R/W; bitpos: [11]; default: 0;
 *  psram hold wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram hold drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_HOLD_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ4_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ4_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x2c)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq4 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq4 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ4_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq4 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ4_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ4_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ4_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ4_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ4_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq4 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq4 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq4 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ4_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ5_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ5_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x30)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq5 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq5 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ5_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq5 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ5_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ5_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ5_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ5_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ5_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq5 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq5 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq5 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ5_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ6_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ6_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x34)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq6 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq6 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ6_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq6 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ6_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ6_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ6_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ6_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ6_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq6 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq6 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq6 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ6_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ7_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ7_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x38)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq7 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq7 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ7_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq7 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ7_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ7_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ7_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ7_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ7_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq7 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq7 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq7 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ7_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQS_0_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQS_0_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x3c)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_XPD : R/W; bitpos: [0]; default: 0;
 *  psram xpd dqs0
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_XPD    (BIT(0))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_XPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_XPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_XPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_XPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_XPD_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_PHASE : R/W; bitpos: [2:1]; default: 0;
 *  psram dqs0 phase
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_PHASE    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_PHASE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_PHASE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_PHASE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_PHASE_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_PHASE_S  1
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DLI : R/W; bitpos: [6:3]; default: 0;
 *  psram dqs0 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DLI_S  3
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_90 : R/W; bitpos: [10:7]; default: 0;
 *  psram dqs0 delay 90
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_90    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_90_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_90_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_90_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_90_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_90_S  7
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_HYS : R/W; bitpos: [11]; default: 0;
 *  psram dqs0 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_HYS    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_HYS_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_IE : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_IE    (BIT(12))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_IE_S  12
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPU : R/W; bitpos: [13]; default: 0;
 *  psram dqs0 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPU    (BIT(13))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPU_S  13
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPD : R/W; bitpos: [14]; default: 0;
 *  psram dqs0 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPD    (BIT(14))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_WPD_S  14
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DRV : R/W; bitpos: [16:15]; default: 0;
 *  psram dqs0 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DRV_S  15
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_270 : R/W; bitpos: [20:17]; default: 0;
 *  psram dqs0 delay 270
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_270    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_270_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_270_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_270_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_270_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_0_DELAY_270_S  17

/** IOMUX_MSPI_PIN_PSRAM_CK_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_CK_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x40)
/** IOMUX_MSPI_PIN_REG_PSRAM_CK_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram ck dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_CK_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_CK_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_CK_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram ck dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_CK_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_CK_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_CK_HYS : R/W; bitpos: [8]; default: 0;
 *  psram ck hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_CK_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_CK_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_CK_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_CK_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_CK_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_CK_WPU : R/W; bitpos: [10]; default: 0;
 *  psram ck wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_CK_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_CK_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_CK_WPD : R/W; bitpos: [11]; default: 0;
 *  psram ck wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_CK_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_CK_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_CK_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram ck drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_CK_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_CK_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_CK_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_CS_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_CS_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x44)
/** IOMUX_MSPI_PIN_REG_PSRAM_CS_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram cs dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_CS_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_CS_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_CS_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram cs dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_CS_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_CS_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_CS_HYS : R/W; bitpos: [8]; default: 0;
 *  psram cs hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_CS_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_CS_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_CS_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_CS_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_CS_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_CS_WPU : R/W; bitpos: [10]; default: 0;
 *  psram cs wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_CS_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_CS_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_CS_WPD : R/W; bitpos: [11]; default: 0;
 *  psram cs wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_CS_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_CS_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_CS_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram cs drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_CS_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_CS_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_CS_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ8_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ8_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x48)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq8 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq8 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ8_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq8 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ8_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ8_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ8_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ8_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ8_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq8 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq8 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq8 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ8_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ9_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ9_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x4c)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq9 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq9 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ9_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq9 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ9_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ9_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ9_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ9_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ9_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq9 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq9 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq9 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ9_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ10_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ10_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x50)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq10 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq10 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ10_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq10 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ10_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ10_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ10_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ10_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ10_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq10 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq10 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq10 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ10_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ11_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ11_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x54)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq11 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq11 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ11_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq11 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ11_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ11_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ11_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ11_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ11_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq11 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq11 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq11 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ11_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ12_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ12_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x58)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq12 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq12 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ12_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq12 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ12_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ12_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ12_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ12_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ12_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq12 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq12 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq12 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ12_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ13_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ13_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x5c)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq13 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq13 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ13_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq13 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ13_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ13_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ13_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ13_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ13_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq13 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq13 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq13 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ13_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ14_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ14_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x60)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq14 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq14 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ14_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq14 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ14_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ14_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ14_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ14_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ14_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq14 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq14 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq14 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ14_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQ15_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQ15_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x64)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLI : R/W; bitpos: [3:0]; default: 0;
 *  psram dq15 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLI_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLC : R/W; bitpos: [7:4]; default: 0;
 *  psram dq15 dlc
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLC    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLC_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLC_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLC_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLC_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DLC_S  4
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ15_HYS : R/W; bitpos: [8]; default: 0;
 *  psram dq15 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_HYS    (BIT(8))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ15_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ15_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_HYS_S  8
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ15_IE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_IE    (BIT(9))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ15_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ15_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_IE_S  9
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPU : R/W; bitpos: [10]; default: 0;
 *  psram dq15 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPU    (BIT(10))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPU_S  10
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPD : R/W; bitpos: [11]; default: 0;
 *  psram dq15 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPD    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_WPD_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DRV : R/W; bitpos: [13:12]; default: 0;
 *  psram dq15 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQ15_DRV_S  12

/** IOMUX_MSPI_PIN_PSRAM_DQS_1_PIN0_REG register
 *  IOMUX_MSPI_PIN_PSRAM_D_PIN0_REG
 */
#define IOMUX_MSPI_PIN_PSRAM_DQS_1_PIN0_REG (DR_REG_IOMUX_MSPI_PIN_BASE + 0x68)
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_XPD : R/W; bitpos: [0]; default: 0;
 *  psram xpd dqs1
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_XPD    (BIT(0))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_XPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_XPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_XPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_XPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_XPD_S  0
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_PHASE : R/W; bitpos: [2:1]; default: 0;
 *  psram dqs1 phase
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_PHASE    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_PHASE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_PHASE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_PHASE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_PHASE_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_PHASE_S  1
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DLI : R/W; bitpos: [6:3]; default: 0;
 *  psram dqs1 dli
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DLI    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DLI_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DLI_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DLI_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DLI_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DLI_S  3
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_90 : R/W; bitpos: [10:7]; default: 0;
 *  psram dqs1 delay 90
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_90    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_90_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_90_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_90_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_90_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_90_S  7
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_HYS : R/W; bitpos: [11]; default: 0;
 *  psram dqs1 hys
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_HYS    (BIT(11))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_HYS_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_HYS_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_HYS_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_HYS_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_HYS_S  11
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_IE : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_IE    (BIT(12))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_IE_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_IE_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_IE_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_IE_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_IE_S  12
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPU : R/W; bitpos: [13]; default: 0;
 *  psram dqs1 wpu
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPU    (BIT(13))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPU_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPU_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPU_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPU_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPU_S  13
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPD : R/W; bitpos: [14]; default: 0;
 *  psram dqs1 wpd
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPD    (BIT(14))
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPD_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPD_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPD_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPD_V  0x00000001U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_WPD_S  14
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DRV : R/W; bitpos: [16:15]; default: 0;
 *  psram dqs1 drv
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DRV    0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DRV_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DRV_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DRV_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DRV_V  0x00000003U
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DRV_S  15
/** IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_270 : R/W; bitpos: [20:17]; default: 0;
 *  psram dqs1 delay 270
 */
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_270    0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_270_M  (IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_270_V << IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_270_S)
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_270_V  0x0000000FU
#define IOMUX_MSPI_PIN_REG_PSRAM_DQS_1_DELAY_270_S  17

#ifdef __cplusplus
}
#endif
