/**
 * SPDX-FileCopyrightText: 2023-2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** PVT_PMUP_BITMAP_HIGH0_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_HIGH0_REG (DR_REG_PVT_BASE + 0x0)
/** PVT_PUMP_BITMAP_HIGH0 : R/W; bitpos: [31:0]; default: 0;
 *  select valid high channel0
 */
#define PVT_PUMP_BITMAP_HIGH0    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH0_M  (PVT_PUMP_BITMAP_HIGH0_V << PVT_PUMP_BITMAP_HIGH0_S)
#define PVT_PUMP_BITMAP_HIGH0_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH0_S  0

/** PVT_PMUP_BITMAP_HIGH1_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_HIGH1_REG (DR_REG_PVT_BASE + 0x4)
/** PVT_PUMP_BITMAP_HIGH1 : R/W; bitpos: [31:0]; default: 0;
 *  select valid high channel1
 */
#define PVT_PUMP_BITMAP_HIGH1    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH1_M  (PVT_PUMP_BITMAP_HIGH1_V << PVT_PUMP_BITMAP_HIGH1_S)
#define PVT_PUMP_BITMAP_HIGH1_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH1_S  0

/** PVT_PMUP_BITMAP_HIGH2_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_HIGH2_REG (DR_REG_PVT_BASE + 0x8)
/** PVT_PUMP_BITMAP_HIGH2 : R/W; bitpos: [31:0]; default: 0;
 *  select valid high channel2
 */
#define PVT_PUMP_BITMAP_HIGH2    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH2_M  (PVT_PUMP_BITMAP_HIGH2_V << PVT_PUMP_BITMAP_HIGH2_S)
#define PVT_PUMP_BITMAP_HIGH2_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH2_S  0

/** PVT_PMUP_BITMAP_HIGH3_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_HIGH3_REG (DR_REG_PVT_BASE + 0xc)
/** PVT_PUMP_BITMAP_HIGH3 : R/W; bitpos: [31:0]; default: 0;
 *  select valid high channel3
 */
#define PVT_PUMP_BITMAP_HIGH3    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH3_M  (PVT_PUMP_BITMAP_HIGH3_V << PVT_PUMP_BITMAP_HIGH3_S)
#define PVT_PUMP_BITMAP_HIGH3_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH3_S  0

/** PVT_PMUP_BITMAP_HIGH4_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_HIGH4_REG (DR_REG_PVT_BASE + 0x10)
/** PVT_PUMP_BITMAP_HIGH4 : R/W; bitpos: [31:0]; default: 0;
 *  select valid high channel4
 */
#define PVT_PUMP_BITMAP_HIGH4    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH4_M  (PVT_PUMP_BITMAP_HIGH4_V << PVT_PUMP_BITMAP_HIGH4_S)
#define PVT_PUMP_BITMAP_HIGH4_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_HIGH4_S  0

/** PVT_PMUP_BITMAP_LOW0_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_LOW0_REG (DR_REG_PVT_BASE + 0x14)
/** PVT_PUMP_BITMAP_LOW0 : R/W; bitpos: [31:0]; default: 0;
 *  select valid low channel0
 */
#define PVT_PUMP_BITMAP_LOW0    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW0_M  (PVT_PUMP_BITMAP_LOW0_V << PVT_PUMP_BITMAP_LOW0_S)
#define PVT_PUMP_BITMAP_LOW0_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW0_S  0

/** PVT_PMUP_BITMAP_LOW1_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_LOW1_REG (DR_REG_PVT_BASE + 0x18)
/** PVT_PUMP_BITMAP_LOW1 : R/W; bitpos: [31:0]; default: 0;
 *  select valid low channel1
 */
#define PVT_PUMP_BITMAP_LOW1    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW1_M  (PVT_PUMP_BITMAP_LOW1_V << PVT_PUMP_BITMAP_LOW1_S)
#define PVT_PUMP_BITMAP_LOW1_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW1_S  0

/** PVT_PMUP_BITMAP_LOW2_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_LOW2_REG (DR_REG_PVT_BASE + 0x1c)
/** PVT_PUMP_BITMAP_LOW2 : R/W; bitpos: [31:0]; default: 0;
 *  select valid low channel2
 */
#define PVT_PUMP_BITMAP_LOW2    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW2_M  (PVT_PUMP_BITMAP_LOW2_V << PVT_PUMP_BITMAP_LOW2_S)
#define PVT_PUMP_BITMAP_LOW2_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW2_S  0

/** PVT_PMUP_BITMAP_LOW3_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_LOW3_REG (DR_REG_PVT_BASE + 0x20)
/** PVT_PUMP_BITMAP_LOW3 : R/W; bitpos: [31:0]; default: 0;
 *  select valid low channel3
 */
#define PVT_PUMP_BITMAP_LOW3    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW3_M  (PVT_PUMP_BITMAP_LOW3_V << PVT_PUMP_BITMAP_LOW3_S)
#define PVT_PUMP_BITMAP_LOW3_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW3_S  0

/** PVT_PMUP_BITMAP_LOW4_REG register
 *  select valid pvt channel
 */
#define PVT_PMUP_BITMAP_LOW4_REG (DR_REG_PVT_BASE + 0x24)
/** PVT_PUMP_BITMAP_LOW4 : R/W; bitpos: [31:0]; default: 0;
 *  select valid low channel4
 */
#define PVT_PUMP_BITMAP_LOW4    0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW4_M  (PVT_PUMP_BITMAP_LOW4_V << PVT_PUMP_BITMAP_LOW4_S)
#define PVT_PUMP_BITMAP_LOW4_V  0xFFFFFFFFU
#define PVT_PUMP_BITMAP_LOW4_S  0

/** PVT_PMUP_DRV_CFG_REG register
 *  configure pump drv
 */
#define PVT_PMUP_DRV_CFG_REG (DR_REG_PVT_BASE + 0x28)
/** PVT_PUMP_EN : R/W; bitpos: [9]; default: 0;
 *  configure pvt charge xpd
 */
#define PVT_PUMP_EN    (BIT(9))
#define PVT_PUMP_EN_M  (PVT_PUMP_EN_V << PVT_PUMP_EN_S)
#define PVT_PUMP_EN_V  0x00000001U
#define PVT_PUMP_EN_S  9
/** PVT_CLK_EN : R/W; bitpos: [10]; default: 0;
 *  force register clken
 */
#define PVT_CLK_EN    (BIT(10))
#define PVT_CLK_EN_M  (PVT_CLK_EN_V << PVT_CLK_EN_S)
#define PVT_CLK_EN_V  0x00000001U
#define PVT_CLK_EN_S  10
/** PVT_PUMP_DRV4 : R/W; bitpos: [14:11]; default: 0;
 *  configure cmd4 drv
 */
#define PVT_PUMP_DRV4    0x0000000FU
#define PVT_PUMP_DRV4_M  (PVT_PUMP_DRV4_V << PVT_PUMP_DRV4_S)
#define PVT_PUMP_DRV4_V  0x0000000FU
#define PVT_PUMP_DRV4_S  11
/** PVT_PUMP_DRV3 : R/W; bitpos: [18:15]; default: 0;
 *  configure cmd3 drv
 */
#define PVT_PUMP_DRV3    0x0000000FU
#define PVT_PUMP_DRV3_M  (PVT_PUMP_DRV3_V << PVT_PUMP_DRV3_S)
#define PVT_PUMP_DRV3_V  0x0000000FU
#define PVT_PUMP_DRV3_S  15
/** PVT_PUMP_DRV2 : R/W; bitpos: [22:19]; default: 0;
 *  configure cmd2 drv
 */
#define PVT_PUMP_DRV2    0x0000000FU
#define PVT_PUMP_DRV2_M  (PVT_PUMP_DRV2_V << PVT_PUMP_DRV2_S)
#define PVT_PUMP_DRV2_V  0x0000000FU
#define PVT_PUMP_DRV2_S  19
/** PVT_PUMP_DRV1 : R/W; bitpos: [26:23]; default: 0;
 *  configure cmd1 drv
 */
#define PVT_PUMP_DRV1    0x0000000FU
#define PVT_PUMP_DRV1_M  (PVT_PUMP_DRV1_V << PVT_PUMP_DRV1_S)
#define PVT_PUMP_DRV1_V  0x0000000FU
#define PVT_PUMP_DRV1_S  23
/** PVT_PUMP_DRV0 : R/W; bitpos: [30:27]; default: 0;
 *  configure cmd0 drv
 */
#define PVT_PUMP_DRV0    0x0000000FU
#define PVT_PUMP_DRV0_M  (PVT_PUMP_DRV0_V << PVT_PUMP_DRV0_S)
#define PVT_PUMP_DRV0_V  0x0000000FU
#define PVT_PUMP_DRV0_S  27

/** PVT_PMUP_CHANNEL_CFG_REG register
 *  configure the code of valid pump channel code
 */
#define PVT_PMUP_CHANNEL_CFG_REG (DR_REG_PVT_BASE + 0x2c)
/** PVT_PUMP_CHANNEL_CODE4 : R/W; bitpos: [11:7]; default: 0;
 *  configure cmd4 code
 */
#define PVT_PUMP_CHANNEL_CODE4    0x0000001FU
#define PVT_PUMP_CHANNEL_CODE4_M  (PVT_PUMP_CHANNEL_CODE4_V << PVT_PUMP_CHANNEL_CODE4_S)
#define PVT_PUMP_CHANNEL_CODE4_V  0x0000001FU
#define PVT_PUMP_CHANNEL_CODE4_S  7
/** PVT_PUMP_CHANNEL_CODE3 : R/W; bitpos: [16:12]; default: 0;
 *  configure cmd3 code
 */
#define PVT_PUMP_CHANNEL_CODE3    0x0000001FU
#define PVT_PUMP_CHANNEL_CODE3_M  (PVT_PUMP_CHANNEL_CODE3_V << PVT_PUMP_CHANNEL_CODE3_S)
#define PVT_PUMP_CHANNEL_CODE3_V  0x0000001FU
#define PVT_PUMP_CHANNEL_CODE3_S  12
/** PVT_PUMP_CHANNEL_CODE2 : R/W; bitpos: [21:17]; default: 0;
 *  configure cmd2 code
 */
#define PVT_PUMP_CHANNEL_CODE2    0x0000001FU
#define PVT_PUMP_CHANNEL_CODE2_M  (PVT_PUMP_CHANNEL_CODE2_V << PVT_PUMP_CHANNEL_CODE2_S)
#define PVT_PUMP_CHANNEL_CODE2_V  0x0000001FU
#define PVT_PUMP_CHANNEL_CODE2_S  17
/** PVT_PUMP_CHANNEL_CODE1 : R/W; bitpos: [26:22]; default: 0;
 *  configure cmd1 code
 */
#define PVT_PUMP_CHANNEL_CODE1    0x0000001FU
#define PVT_PUMP_CHANNEL_CODE1_M  (PVT_PUMP_CHANNEL_CODE1_V << PVT_PUMP_CHANNEL_CODE1_S)
#define PVT_PUMP_CHANNEL_CODE1_V  0x0000001FU
#define PVT_PUMP_CHANNEL_CODE1_S  22
/** PVT_PUMP_CHANNEL_CODE0 : R/W; bitpos: [31:27]; default: 0;
 *  configure cmd0 code
 */
#define PVT_PUMP_CHANNEL_CODE0    0x0000001FU
#define PVT_PUMP_CHANNEL_CODE0_M  (PVT_PUMP_CHANNEL_CODE0_V << PVT_PUMP_CHANNEL_CODE0_S)
#define PVT_PUMP_CHANNEL_CODE0_V  0x0000001FU
#define PVT_PUMP_CHANNEL_CODE0_S  27

/** PVT_CLK_CFG_REG register
 *  configure pvt clk
 */
#define PVT_CLK_CFG_REG (DR_REG_PVT_BASE + 0x30)
/** PVT_PUMP_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  needs field desc
 */
#define PVT_PUMP_CLK_DIV_NUM    0x000000FFU
#define PVT_PUMP_CLK_DIV_NUM_M  (PVT_PUMP_CLK_DIV_NUM_V << PVT_PUMP_CLK_DIV_NUM_S)
#define PVT_PUMP_CLK_DIV_NUM_V  0x000000FFU
#define PVT_PUMP_CLK_DIV_NUM_S  0
/** PVT_MONITOR_CLK_PVT_EN : R/W; bitpos: [8]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_CLK_PVT_EN    (BIT(8))
#define PVT_MONITOR_CLK_PVT_EN_M  (PVT_MONITOR_CLK_PVT_EN_V << PVT_MONITOR_CLK_PVT_EN_S)
#define PVT_MONITOR_CLK_PVT_EN_V  0x00000001U
#define PVT_MONITOR_CLK_PVT_EN_S  8
/** PVT_CLK_SEL : R/W; bitpos: [31]; default: 0;
 *  select pvt clk
 */
#define PVT_CLK_SEL    (BIT(31))
#define PVT_CLK_SEL_M  (PVT_CLK_SEL_V << PVT_CLK_SEL_S)
#define PVT_CLK_SEL_V  0x00000001U
#define PVT_CLK_SEL_S  31

/** PVT_DBIAS_CHANNEL_SEL0_REG register
 *  needs desc
 */
#define PVT_DBIAS_CHANNEL_SEL0_REG (DR_REG_PVT_BASE + 0x34)
/** PVT_DBIAS_CHANNEL3_SEL : R/W; bitpos: [10:4]; default: 64;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL3_SEL    0x0000007FU
#define PVT_DBIAS_CHANNEL3_SEL_M  (PVT_DBIAS_CHANNEL3_SEL_V << PVT_DBIAS_CHANNEL3_SEL_S)
#define PVT_DBIAS_CHANNEL3_SEL_V  0x0000007FU
#define PVT_DBIAS_CHANNEL3_SEL_S  4
/** PVT_DBIAS_CHANNEL2_SEL : R/W; bitpos: [17:11]; default: 64;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL2_SEL    0x0000007FU
#define PVT_DBIAS_CHANNEL2_SEL_M  (PVT_DBIAS_CHANNEL2_SEL_V << PVT_DBIAS_CHANNEL2_SEL_S)
#define PVT_DBIAS_CHANNEL2_SEL_V  0x0000007FU
#define PVT_DBIAS_CHANNEL2_SEL_S  11
/** PVT_DBIAS_CHANNEL1_SEL : R/W; bitpos: [24:18]; default: 64;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL1_SEL    0x0000007FU
#define PVT_DBIAS_CHANNEL1_SEL_M  (PVT_DBIAS_CHANNEL1_SEL_V << PVT_DBIAS_CHANNEL1_SEL_S)
#define PVT_DBIAS_CHANNEL1_SEL_V  0x0000007FU
#define PVT_DBIAS_CHANNEL1_SEL_S  18
/** PVT_DBIAS_CHANNEL0_SEL : R/W; bitpos: [31:25]; default: 64;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL0_SEL    0x0000007FU
#define PVT_DBIAS_CHANNEL0_SEL_M  (PVT_DBIAS_CHANNEL0_SEL_V << PVT_DBIAS_CHANNEL0_SEL_S)
#define PVT_DBIAS_CHANNEL0_SEL_V  0x0000007FU
#define PVT_DBIAS_CHANNEL0_SEL_S  25

/** PVT_DBIAS_CHANNEL_SEL1_REG register
 *  needs desc
 */
#define PVT_DBIAS_CHANNEL_SEL1_REG (DR_REG_PVT_BASE + 0x38)
/** PVT_DBIAS_CHANNEL4_SEL : R/W; bitpos: [31:25]; default: 64;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL4_SEL    0x0000007FU
#define PVT_DBIAS_CHANNEL4_SEL_M  (PVT_DBIAS_CHANNEL4_SEL_V << PVT_DBIAS_CHANNEL4_SEL_S)
#define PVT_DBIAS_CHANNEL4_SEL_V  0x0000007FU
#define PVT_DBIAS_CHANNEL4_SEL_S  25

/** PVT_DBIAS_CHANNEL0_SEL_REG register
 *  needs desc
 */
#define PVT_DBIAS_CHANNEL0_SEL_REG (DR_REG_PVT_BASE + 0x3c)
/** PVT_DBIAS_CHANNEL0_CFG : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL0_CFG    0x0001FFFFU
#define PVT_DBIAS_CHANNEL0_CFG_M  (PVT_DBIAS_CHANNEL0_CFG_V << PVT_DBIAS_CHANNEL0_CFG_S)
#define PVT_DBIAS_CHANNEL0_CFG_V  0x0001FFFFU
#define PVT_DBIAS_CHANNEL0_CFG_S  0

/** PVT_DBIAS_CHANNEL1_SEL_REG register
 *  needs desc
 */
#define PVT_DBIAS_CHANNEL1_SEL_REG (DR_REG_PVT_BASE + 0x40)
/** PVT_DBIAS_CHANNEL1_CFG : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL1_CFG    0x0001FFFFU
#define PVT_DBIAS_CHANNEL1_CFG_M  (PVT_DBIAS_CHANNEL1_CFG_V << PVT_DBIAS_CHANNEL1_CFG_S)
#define PVT_DBIAS_CHANNEL1_CFG_V  0x0001FFFFU
#define PVT_DBIAS_CHANNEL1_CFG_S  0

/** PVT_DBIAS_CHANNEL2_SEL_REG register
 *  needs desc
 */
#define PVT_DBIAS_CHANNEL2_SEL_REG (DR_REG_PVT_BASE + 0x44)
/** PVT_DBIAS_CHANNEL2_CFG : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL2_CFG    0x0001FFFFU
#define PVT_DBIAS_CHANNEL2_CFG_M  (PVT_DBIAS_CHANNEL2_CFG_V << PVT_DBIAS_CHANNEL2_CFG_S)
#define PVT_DBIAS_CHANNEL2_CFG_V  0x0001FFFFU
#define PVT_DBIAS_CHANNEL2_CFG_S  0

/** PVT_DBIAS_CHANNEL3_SEL_REG register
 *  needs desc
 */
#define PVT_DBIAS_CHANNEL3_SEL_REG (DR_REG_PVT_BASE + 0x48)
/** PVT_DBIAS_CHANNEL3_CFG : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL3_CFG    0x0001FFFFU
#define PVT_DBIAS_CHANNEL3_CFG_M  (PVT_DBIAS_CHANNEL3_CFG_V << PVT_DBIAS_CHANNEL3_CFG_S)
#define PVT_DBIAS_CHANNEL3_CFG_V  0x0001FFFFU
#define PVT_DBIAS_CHANNEL3_CFG_S  0

/** PVT_DBIAS_CHANNEL4_SEL_REG register
 *  needs desc
 */
#define PVT_DBIAS_CHANNEL4_SEL_REG (DR_REG_PVT_BASE + 0x4c)
/** PVT_DBIAS_CHANNEL4_CFG : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CHANNEL4_CFG    0x0001FFFFU
#define PVT_DBIAS_CHANNEL4_CFG_M  (PVT_DBIAS_CHANNEL4_CFG_V << PVT_DBIAS_CHANNEL4_CFG_S)
#define PVT_DBIAS_CHANNEL4_CFG_V  0x0001FFFFU
#define PVT_DBIAS_CHANNEL4_CFG_S  0

/** PVT_DBIAS_CMD0_REG register
 *  needs desc
 */
#define PVT_DBIAS_CMD0_REG (DR_REG_PVT_BASE + 0x50)
/** PVT_DBIAS_CMD0 : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CMD0_OFFSET_FLAG 1
#define PVT_DBIAS_CMD0_OFFSET_FLAG_S 16
#define PVT_DBIAS_CMD0_OFFSET_VALUE 0x1F
#define PVT_DBIAS_CMD0_OFFSET_VALUE_S 11
#define PVT_DBIAS_CMD0_PVT 0x7FF
#define PVT_DBIAS_CMD0_PVT_S 0

/** PVT_DBIAS_CMD1_REG register
 *  needs desc
 */
#define PVT_DBIAS_CMD1_REG (DR_REG_PVT_BASE + 0x54)
/** PVT_DBIAS_CMD1 : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CMD1_OFFSET_FLAG 1
#define PVT_DBIAS_CMD1_OFFSET_FLAG_S 16
#define PVT_DBIAS_CMD1_OFFSET_VALUE 0x1F
#define PVT_DBIAS_CMD1_OFFSET_VALUE_S 11
#define PVT_DBIAS_CMD1_PVT 0x7FF
#define PVT_DBIAS_CMD1_PVT_S 0

/** PVT_DBIAS_CMD2_REG register
 *  needs desc
 */
#define PVT_DBIAS_CMD2_REG (DR_REG_PVT_BASE + 0x58)
/** PVT_DBIAS_CMD2 : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CMD2_OFFSET_FLAG 1
#define PVT_DBIAS_CMD2_OFFSET_FLAG_S 16
#define PVT_DBIAS_CMD2_OFFSET_VALUE 0x1F
#define PVT_DBIAS_CMD2_OFFSET_VALUE_S 11
#define PVT_DBIAS_CMD2_PVT 0x7FF
#define PVT_DBIAS_CMD2_PVT_S 0

/** PVT_DBIAS_CMD3_REG register
 *  needs desc
 */
#define PVT_DBIAS_CMD3_REG (DR_REG_PVT_BASE + 0x5c)
/** PVT_DBIAS_CMD3 : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CMD3    0x0001FFFFU
#define PVT_DBIAS_CMD3_M  (PVT_DBIAS_CMD3_V << PVT_DBIAS_CMD3_S)
#define PVT_DBIAS_CMD3_V  0x0001FFFFU
#define PVT_DBIAS_CMD3_S  0

/** PVT_DBIAS_CMD4_REG register
 *  needs desc
 */
#define PVT_DBIAS_CMD4_REG (DR_REG_PVT_BASE + 0x60)
/** PVT_DBIAS_CMD4 : R/W; bitpos: [16:0]; default: 0;
 *  needs field desc
 */
#define PVT_DBIAS_CMD4    0x0001FFFFU
#define PVT_DBIAS_CMD4_M  (PVT_DBIAS_CMD4_V << PVT_DBIAS_CMD4_S)
#define PVT_DBIAS_CMD4_V  0x0001FFFFU
#define PVT_DBIAS_CMD4_S  0

/** PVT_DBIAS_TIMER_REG register
 *  needs desc
 */
#define PVT_DBIAS_TIMER_REG (DR_REG_PVT_BASE + 0x64)
/** PVT_TIMER_TARGET : R/W; bitpos: [30:15]; default: 65535;
 *  needs field desc
 */
#define PVT_TIMER_TARGET    0x0000FFFFU
#define PVT_TIMER_TARGET_M  (PVT_TIMER_TARGET_V << PVT_TIMER_TARGET_S)
#define PVT_TIMER_TARGET_V  0x0000FFFFU
#define PVT_TIMER_TARGET_S  15
/** PVT_TIMER_EN : R/W; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMER_EN    (BIT(31))
#define PVT_TIMER_EN_M  (PVT_TIMER_EN_V << PVT_TIMER_EN_S)
#define PVT_TIMER_EN_V  0x00000001U
#define PVT_TIMER_EN_S  31

/** PVT_COMB_PD_SITE0_UNIT0_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT0_VT0_CONF1_REG (DR_REG_PVT_BASE + 0x68)
/** PVT_MONITOR_EN_VT0_PD_SITE0_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT0_M  (PVT_MONITOR_EN_VT0_PD_SITE0_UNIT0_V << PVT_MONITOR_EN_VT0_PD_SITE0_UNIT0_S)
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT0_M  (PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT0_V << PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT0_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT0_M  (PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT0_V << PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT0_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT0_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE0_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_VT0_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_VT0_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT0_S  31

/** PVT_COMB_PD_SITE0_UNIT1_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT1_VT0_CONF1_REG (DR_REG_PVT_BASE + 0x6c)
/** PVT_MONITOR_EN_VT0_PD_SITE0_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT1_M  (PVT_MONITOR_EN_VT0_PD_SITE0_UNIT1_V << PVT_MONITOR_EN_VT0_PD_SITE0_UNIT1_S)
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT1_M  (PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT1_V << PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT1_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT1_M  (PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT1_V << PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT1_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT1_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE0_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_VT0_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_VT0_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT1_S  31

/** PVT_COMB_PD_SITE0_UNIT2_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT2_VT0_CONF1_REG (DR_REG_PVT_BASE + 0x70)
/** PVT_MONITOR_EN_VT0_PD_SITE0_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT2_M  (PVT_MONITOR_EN_VT0_PD_SITE0_UNIT2_V << PVT_MONITOR_EN_VT0_PD_SITE0_UNIT2_S)
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT2_M  (PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT2_V << PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT2_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT2_M  (PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT2_V << PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT2_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT2_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE0_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_VT0_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_VT0_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT2_S  31

/** PVT_COMB_PD_SITE0_UNIT3_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT3_VT0_CONF1_REG (DR_REG_PVT_BASE + 0x74)
/** PVT_MONITOR_EN_VT0_PD_SITE0_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT3_M  (PVT_MONITOR_EN_VT0_PD_SITE0_UNIT3_V << PVT_MONITOR_EN_VT0_PD_SITE0_UNIT3_S)
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE0_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE0_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT3_M  (PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT3_V << PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT3_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE0_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT3_M  (PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT3_V << PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT3_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE0_UNIT3_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE0_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_VT0_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_VT0_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE0_UNIT3_S  31

/** PVT_COMB_PD_SITE0_UNIT0_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT0_VT1_CONF1_REG (DR_REG_PVT_BASE + 0x78)
/** PVT_MONITOR_EN_VT1_PD_SITE0_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT0_M  (PVT_MONITOR_EN_VT1_PD_SITE0_UNIT0_V << PVT_MONITOR_EN_VT1_PD_SITE0_UNIT0_S)
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT0_M  (PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT0_V << PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT0_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT0_M  (PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT0_V << PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT0_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT0_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE0_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_VT1_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_VT1_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT0_S  31

/** PVT_COMB_PD_SITE0_UNIT1_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT1_VT1_CONF1_REG (DR_REG_PVT_BASE + 0x7c)
/** PVT_MONITOR_EN_VT1_PD_SITE0_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT1_M  (PVT_MONITOR_EN_VT1_PD_SITE0_UNIT1_V << PVT_MONITOR_EN_VT1_PD_SITE0_UNIT1_S)
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT1_M  (PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT1_V << PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT1_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT1_M  (PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT1_V << PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT1_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT1_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE0_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_VT1_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_VT1_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT1_S  31

/** PVT_COMB_PD_SITE0_UNIT2_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT2_VT1_CONF1_REG (DR_REG_PVT_BASE + 0x80)
/** PVT_MONITOR_EN_VT1_PD_SITE0_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT2_M  (PVT_MONITOR_EN_VT1_PD_SITE0_UNIT2_V << PVT_MONITOR_EN_VT1_PD_SITE0_UNIT2_S)
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT2_M  (PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT2_V << PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT2_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT2_M  (PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT2_V << PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT2_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT2_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE0_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_VT1_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_VT1_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT2_S  31

/** PVT_COMB_PD_SITE0_UNIT3_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT3_VT1_CONF1_REG (DR_REG_PVT_BASE + 0x84)
/** PVT_MONITOR_EN_VT1_PD_SITE0_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT3_M  (PVT_MONITOR_EN_VT1_PD_SITE0_UNIT3_V << PVT_MONITOR_EN_VT1_PD_SITE0_UNIT3_S)
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE0_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE0_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT3_M  (PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT3_V << PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT3_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE0_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT3_M  (PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT3_V << PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT3_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE0_UNIT3_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE0_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_VT1_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_VT1_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE0_UNIT3_S  31

/** PVT_COMB_PD_SITE0_UNIT0_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT0_VT2_CONF1_REG (DR_REG_PVT_BASE + 0x88)
/** PVT_MONITOR_EN_VT2_PD_SITE0_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT0_M  (PVT_MONITOR_EN_VT2_PD_SITE0_UNIT0_V << PVT_MONITOR_EN_VT2_PD_SITE0_UNIT0_S)
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT0_M  (PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT0_V << PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT0_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT0_M  (PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT0_V << PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT0_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT0_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE0_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_VT2_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_VT2_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT0_S  31

/** PVT_COMB_PD_SITE0_UNIT1_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT1_VT2_CONF1_REG (DR_REG_PVT_BASE + 0x8c)
/** PVT_MONITOR_EN_VT2_PD_SITE0_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT1_M  (PVT_MONITOR_EN_VT2_PD_SITE0_UNIT1_V << PVT_MONITOR_EN_VT2_PD_SITE0_UNIT1_S)
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT1_M  (PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT1_V << PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT1_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT1_M  (PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT1_V << PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT1_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT1_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE0_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_VT2_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_VT2_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT1_S  31

/** PVT_COMB_PD_SITE0_UNIT2_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT2_VT2_CONF1_REG (DR_REG_PVT_BASE + 0x90)
/** PVT_MONITOR_EN_VT2_PD_SITE0_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT2_M  (PVT_MONITOR_EN_VT2_PD_SITE0_UNIT2_V << PVT_MONITOR_EN_VT2_PD_SITE0_UNIT2_S)
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT2_M  (PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT2_V << PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT2_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT2_M  (PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT2_V << PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT2_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT2_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE0_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_VT2_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_VT2_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT2_S  31

/** PVT_COMB_PD_SITE0_UNIT3_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT3_VT2_CONF1_REG (DR_REG_PVT_BASE + 0x94)
/** PVT_MONITOR_EN_VT2_PD_SITE0_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT3_M  (PVT_MONITOR_EN_VT2_PD_SITE0_UNIT3_V << PVT_MONITOR_EN_VT2_PD_SITE0_UNIT3_S)
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE0_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE0_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT3_M  (PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT3_V << PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT3_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE0_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT3_M  (PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT3_V << PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT3_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE0_UNIT3_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE0_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_VT2_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_VT2_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE0_UNIT3_S  31

/** PVT_COMB_PD_SITE1_UNIT0_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT0_VT0_CONF1_REG (DR_REG_PVT_BASE + 0x98)
/** PVT_MONITOR_EN_VT0_PD_SITE1_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT0_M  (PVT_MONITOR_EN_VT0_PD_SITE1_UNIT0_V << PVT_MONITOR_EN_VT0_PD_SITE1_UNIT0_S)
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT0_M  (PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT0_V << PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT0_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT0_M  (PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT0_V << PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT0_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT0_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE1_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_VT0_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_VT0_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT0_S  31

/** PVT_COMB_PD_SITE1_UNIT1_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT1_VT0_CONF1_REG (DR_REG_PVT_BASE + 0x9c)
/** PVT_MONITOR_EN_VT0_PD_SITE1_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT1_M  (PVT_MONITOR_EN_VT0_PD_SITE1_UNIT1_V << PVT_MONITOR_EN_VT0_PD_SITE1_UNIT1_S)
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT1_M  (PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT1_V << PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT1_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT1_M  (PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT1_V << PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT1_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT1_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE1_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_VT0_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_VT0_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT1_S  31

/** PVT_COMB_PD_SITE1_UNIT2_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT2_VT0_CONF1_REG (DR_REG_PVT_BASE + 0xa0)
/** PVT_MONITOR_EN_VT0_PD_SITE1_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT2_M  (PVT_MONITOR_EN_VT0_PD_SITE1_UNIT2_V << PVT_MONITOR_EN_VT0_PD_SITE1_UNIT2_S)
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT2_M  (PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT2_V << PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT2_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT2_M  (PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT2_V << PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT2_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT2_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE1_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_VT0_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_VT0_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT2_S  31

/** PVT_COMB_PD_SITE1_UNIT3_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT3_VT0_CONF1_REG (DR_REG_PVT_BASE + 0xa4)
/** PVT_MONITOR_EN_VT0_PD_SITE1_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT3_M  (PVT_MONITOR_EN_VT0_PD_SITE1_UNIT3_V << PVT_MONITOR_EN_VT0_PD_SITE1_UNIT3_S)
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE1_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE1_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT3_M  (PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT3_V << PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT3_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE1_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT3_M  (PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT3_V << PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT3_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE1_UNIT3_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE1_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_VT0_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_VT0_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE1_UNIT3_S  31

/** PVT_COMB_PD_SITE1_UNIT0_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT0_VT1_CONF1_REG (DR_REG_PVT_BASE + 0xa8)
/** PVT_MONITOR_EN_VT1_PD_SITE1_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT0_M  (PVT_MONITOR_EN_VT1_PD_SITE1_UNIT0_V << PVT_MONITOR_EN_VT1_PD_SITE1_UNIT0_S)
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT0_M  (PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT0_V << PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT0_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT0_M  (PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT0_V << PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT0_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT0_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE1_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_VT1_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_VT1_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT0_S  31

/** PVT_COMB_PD_SITE1_UNIT1_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT1_VT1_CONF1_REG (DR_REG_PVT_BASE + 0xac)
/** PVT_MONITOR_EN_VT1_PD_SITE1_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT1_M  (PVT_MONITOR_EN_VT1_PD_SITE1_UNIT1_V << PVT_MONITOR_EN_VT1_PD_SITE1_UNIT1_S)
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT1_M  (PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT1_V << PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT1_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT1_M  (PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT1_V << PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT1_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT1_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE1_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_VT1_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_VT1_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT1_S  31

/** PVT_COMB_PD_SITE1_UNIT2_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT2_VT1_CONF1_REG (DR_REG_PVT_BASE + 0xb0)
/** PVT_MONITOR_EN_VT1_PD_SITE1_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT2_M  (PVT_MONITOR_EN_VT1_PD_SITE1_UNIT2_V << PVT_MONITOR_EN_VT1_PD_SITE1_UNIT2_S)
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT2_M  (PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT2_V << PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT2_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT2_M  (PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT2_V << PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT2_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT2_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE1_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_VT1_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_VT1_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT2_S  31

/** PVT_COMB_PD_SITE1_UNIT3_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT3_VT1_CONF1_REG (DR_REG_PVT_BASE + 0xb4)
/** PVT_MONITOR_EN_VT1_PD_SITE1_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT3_M  (PVT_MONITOR_EN_VT1_PD_SITE1_UNIT3_V << PVT_MONITOR_EN_VT1_PD_SITE1_UNIT3_S)
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE1_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE1_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT3_M  (PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT3_V << PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT3_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE1_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT3_M  (PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT3_V << PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT3_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE1_UNIT3_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE1_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_VT1_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_VT1_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE1_UNIT3_S  31

/** PVT_COMB_PD_SITE1_UNIT0_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT0_VT2_CONF1_REG (DR_REG_PVT_BASE + 0xb8)
/** PVT_MONITOR_EN_VT2_PD_SITE1_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT0_M  (PVT_MONITOR_EN_VT2_PD_SITE1_UNIT0_V << PVT_MONITOR_EN_VT2_PD_SITE1_UNIT0_S)
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT0_M  (PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT0_V << PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT0_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT0_M  (PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT0_V << PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT0_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT0_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE1_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_VT2_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_VT2_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT0_S  31

/** PVT_COMB_PD_SITE1_UNIT1_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT1_VT2_CONF1_REG (DR_REG_PVT_BASE + 0xbc)
/** PVT_MONITOR_EN_VT2_PD_SITE1_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT1_M  (PVT_MONITOR_EN_VT2_PD_SITE1_UNIT1_V << PVT_MONITOR_EN_VT2_PD_SITE1_UNIT1_S)
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT1_M  (PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT1_V << PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT1_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT1_M  (PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT1_V << PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT1_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT1_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE1_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_VT2_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_VT2_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT1_S  31

/** PVT_COMB_PD_SITE1_UNIT2_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT2_VT2_CONF1_REG (DR_REG_PVT_BASE + 0xc0)
/** PVT_MONITOR_EN_VT2_PD_SITE1_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT2_M  (PVT_MONITOR_EN_VT2_PD_SITE1_UNIT2_V << PVT_MONITOR_EN_VT2_PD_SITE1_UNIT2_S)
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT2_M  (PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT2_V << PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT2_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT2_M  (PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT2_V << PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT2_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT2_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE1_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_VT2_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_VT2_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT2_S  31

/** PVT_COMB_PD_SITE1_UNIT3_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT3_VT2_CONF1_REG (DR_REG_PVT_BASE + 0xc4)
/** PVT_MONITOR_EN_VT2_PD_SITE1_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT3_M  (PVT_MONITOR_EN_VT2_PD_SITE1_UNIT3_V << PVT_MONITOR_EN_VT2_PD_SITE1_UNIT3_S)
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE1_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE1_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT3_M  (PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT3_V << PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT3_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE1_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT3_M  (PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT3_V << PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT3_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE1_UNIT3_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE1_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_VT2_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_VT2_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE1_UNIT3_S  31

/** PVT_COMB_PD_SITE2_UNIT0_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT0_VT0_CONF1_REG (DR_REG_PVT_BASE + 0xc8)
/** PVT_MONITOR_EN_VT0_PD_SITE2_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT0_M  (PVT_MONITOR_EN_VT0_PD_SITE2_UNIT0_V << PVT_MONITOR_EN_VT0_PD_SITE2_UNIT0_S)
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT0_M  (PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT0_V << PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT0_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT0_M  (PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT0_V << PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT0_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT0_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE2_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_VT0_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_VT0_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT0_S  31

/** PVT_COMB_PD_SITE2_UNIT1_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT1_VT0_CONF1_REG (DR_REG_PVT_BASE + 0xcc)
/** PVT_MONITOR_EN_VT0_PD_SITE2_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT1_M  (PVT_MONITOR_EN_VT0_PD_SITE2_UNIT1_V << PVT_MONITOR_EN_VT0_PD_SITE2_UNIT1_S)
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT1_M  (PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT1_V << PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT1_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT1_M  (PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT1_V << PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT1_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT1_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE2_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_VT0_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_VT0_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT1_S  31

/** PVT_COMB_PD_SITE2_UNIT2_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT2_VT0_CONF1_REG (DR_REG_PVT_BASE + 0xd0)
/** PVT_MONITOR_EN_VT0_PD_SITE2_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT2_M  (PVT_MONITOR_EN_VT0_PD_SITE2_UNIT2_V << PVT_MONITOR_EN_VT0_PD_SITE2_UNIT2_S)
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT2_M  (PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT2_V << PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT2_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT2_M  (PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT2_V << PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT2_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT2_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE2_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_VT0_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_VT0_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT2_S  31

/** PVT_COMB_PD_SITE2_UNIT3_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT3_VT0_CONF1_REG (DR_REG_PVT_BASE + 0xd4)
/** PVT_MONITOR_EN_VT0_PD_SITE2_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT3_M  (PVT_MONITOR_EN_VT0_PD_SITE2_UNIT3_V << PVT_MONITOR_EN_VT0_PD_SITE2_UNIT3_S)
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE2_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE2_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT3_M  (PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT3_V << PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT3_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE2_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT3_M  (PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT3_V << PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT3_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE2_UNIT3_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE2_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_VT0_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_VT0_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE2_UNIT3_S  31

/** PVT_COMB_PD_SITE2_UNIT0_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT0_VT1_CONF1_REG (DR_REG_PVT_BASE + 0xd8)
/** PVT_MONITOR_EN_VT1_PD_SITE2_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT0_M  (PVT_MONITOR_EN_VT1_PD_SITE2_UNIT0_V << PVT_MONITOR_EN_VT1_PD_SITE2_UNIT0_S)
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT0_M  (PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT0_V << PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT0_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT0_M  (PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT0_V << PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT0_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT0_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE2_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_VT1_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_VT1_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT0_S  31

/** PVT_COMB_PD_SITE2_UNIT1_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT1_VT1_CONF1_REG (DR_REG_PVT_BASE + 0xdc)
/** PVT_MONITOR_EN_VT1_PD_SITE2_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT1_M  (PVT_MONITOR_EN_VT1_PD_SITE2_UNIT1_V << PVT_MONITOR_EN_VT1_PD_SITE2_UNIT1_S)
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT1_M  (PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT1_V << PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT1_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT1_M  (PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT1_V << PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT1_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT1_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE2_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_VT1_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_VT1_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT1_S  31

/** PVT_COMB_PD_SITE2_UNIT2_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT2_VT1_CONF1_REG (DR_REG_PVT_BASE + 0xe0)
/** PVT_MONITOR_EN_VT1_PD_SITE2_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT2_M  (PVT_MONITOR_EN_VT1_PD_SITE2_UNIT2_V << PVT_MONITOR_EN_VT1_PD_SITE2_UNIT2_S)
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT2_M  (PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT2_V << PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT2_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT2_M  (PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT2_V << PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT2_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT2_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE2_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_VT1_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_VT1_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT2_S  31

/** PVT_COMB_PD_SITE2_UNIT3_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT3_VT1_CONF1_REG (DR_REG_PVT_BASE + 0xe4)
/** PVT_MONITOR_EN_VT1_PD_SITE2_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT3_M  (PVT_MONITOR_EN_VT1_PD_SITE2_UNIT3_V << PVT_MONITOR_EN_VT1_PD_SITE2_UNIT3_S)
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE2_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE2_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT3_M  (PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT3_V << PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT3_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE2_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT3_M  (PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT3_V << PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT3_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE2_UNIT3_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE2_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_VT1_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_VT1_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE2_UNIT3_S  31

/** PVT_COMB_PD_SITE2_UNIT0_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT0_VT2_CONF1_REG (DR_REG_PVT_BASE + 0xe8)
/** PVT_MONITOR_EN_VT2_PD_SITE2_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT0_M  (PVT_MONITOR_EN_VT2_PD_SITE2_UNIT0_V << PVT_MONITOR_EN_VT2_PD_SITE2_UNIT0_S)
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT0_M  (PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT0_V << PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT0_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT0_M  (PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT0_V << PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT0_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT0_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE2_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_VT2_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_VT2_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT0_S  31

/** PVT_COMB_PD_SITE2_UNIT1_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT1_VT2_CONF1_REG (DR_REG_PVT_BASE + 0xec)
/** PVT_MONITOR_EN_VT2_PD_SITE2_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT1_M  (PVT_MONITOR_EN_VT2_PD_SITE2_UNIT1_V << PVT_MONITOR_EN_VT2_PD_SITE2_UNIT1_S)
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT1_M  (PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT1_V << PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT1_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT1_M  (PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT1_V << PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT1_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT1_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE2_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_VT2_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_VT2_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT1_S  31

/** PVT_COMB_PD_SITE2_UNIT2_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT2_VT2_CONF1_REG (DR_REG_PVT_BASE + 0xf0)
/** PVT_MONITOR_EN_VT2_PD_SITE2_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT2_M  (PVT_MONITOR_EN_VT2_PD_SITE2_UNIT2_V << PVT_MONITOR_EN_VT2_PD_SITE2_UNIT2_S)
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT2_M  (PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT2_V << PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT2_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT2_M  (PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT2_V << PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT2_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT2_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE2_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_VT2_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_VT2_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT2_S  31

/** PVT_COMB_PD_SITE2_UNIT3_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT3_VT2_CONF1_REG (DR_REG_PVT_BASE + 0xf4)
/** PVT_MONITOR_EN_VT2_PD_SITE2_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT3_M  (PVT_MONITOR_EN_VT2_PD_SITE2_UNIT3_V << PVT_MONITOR_EN_VT2_PD_SITE2_UNIT3_S)
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE2_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE2_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT3_M  (PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT3_V << PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT3_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE2_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT3_M  (PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT3_V << PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT3_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE2_UNIT3_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE2_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_VT2_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_VT2_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE2_UNIT3_S  31

/** PVT_COMB_PD_SITE3_UNIT0_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT0_VT0_CONF1_REG (DR_REG_PVT_BASE + 0xf8)
/** PVT_MONITOR_EN_VT0_PD_SITE3_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT0_M  (PVT_MONITOR_EN_VT0_PD_SITE3_UNIT0_V << PVT_MONITOR_EN_VT0_PD_SITE3_UNIT0_S)
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT0_M  (PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT0_V << PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT0_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT0_M  (PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT0_V << PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT0_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT0_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE3_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_VT0_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_VT0_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT0_S  31

/** PVT_COMB_PD_SITE3_UNIT1_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT1_VT0_CONF1_REG (DR_REG_PVT_BASE + 0xfc)
/** PVT_MONITOR_EN_VT0_PD_SITE3_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT1_M  (PVT_MONITOR_EN_VT0_PD_SITE3_UNIT1_V << PVT_MONITOR_EN_VT0_PD_SITE3_UNIT1_S)
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT1_M  (PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT1_V << PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT1_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT1_M  (PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT1_V << PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT1_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT1_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE3_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_VT0_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_VT0_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT1_S  31

/** PVT_COMB_PD_SITE3_UNIT2_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT2_VT0_CONF1_REG (DR_REG_PVT_BASE + 0x100)
/** PVT_MONITOR_EN_VT0_PD_SITE3_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT2_M  (PVT_MONITOR_EN_VT0_PD_SITE3_UNIT2_V << PVT_MONITOR_EN_VT0_PD_SITE3_UNIT2_S)
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT2_M  (PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT2_V << PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT2_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT2_M  (PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT2_V << PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT2_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT2_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE3_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_VT0_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_VT0_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT2_S  31

/** PVT_COMB_PD_SITE3_UNIT3_VT0_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT3_VT0_CONF1_REG (DR_REG_PVT_BASE + 0x104)
/** PVT_MONITOR_EN_VT0_PD_SITE3_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT3_M  (PVT_MONITOR_EN_VT0_PD_SITE3_UNIT3_V << PVT_MONITOR_EN_VT0_PD_SITE3_UNIT3_S)
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT0_PD_SITE3_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT0_PD_SITE3_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT3_M  (PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT3_V << PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT3_S)
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT0_PD_SITE3_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT3_M  (PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT3_V << PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT3_S)
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT0_PD_SITE3_UNIT3_S  23
/** PVT_TIMING_ERR_VT0_PD_SITE3_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_VT0_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_VT0_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT0_PD_SITE3_UNIT3_S  31

/** PVT_COMB_PD_SITE3_UNIT0_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT0_VT1_CONF1_REG (DR_REG_PVT_BASE + 0x108)
/** PVT_MONITOR_EN_VT1_PD_SITE3_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT0_M  (PVT_MONITOR_EN_VT1_PD_SITE3_UNIT0_V << PVT_MONITOR_EN_VT1_PD_SITE3_UNIT0_S)
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT0_M  (PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT0_V << PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT0_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT0_M  (PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT0_V << PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT0_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT0_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE3_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_VT1_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_VT1_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT0_S  31

/** PVT_COMB_PD_SITE3_UNIT1_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT1_VT1_CONF1_REG (DR_REG_PVT_BASE + 0x10c)
/** PVT_MONITOR_EN_VT1_PD_SITE3_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT1_M  (PVT_MONITOR_EN_VT1_PD_SITE3_UNIT1_V << PVT_MONITOR_EN_VT1_PD_SITE3_UNIT1_S)
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT1_M  (PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT1_V << PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT1_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT1_M  (PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT1_V << PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT1_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT1_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE3_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_VT1_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_VT1_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT1_S  31

/** PVT_COMB_PD_SITE3_UNIT2_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT2_VT1_CONF1_REG (DR_REG_PVT_BASE + 0x110)
/** PVT_MONITOR_EN_VT1_PD_SITE3_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT2_M  (PVT_MONITOR_EN_VT1_PD_SITE3_UNIT2_V << PVT_MONITOR_EN_VT1_PD_SITE3_UNIT2_S)
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT2_M  (PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT2_V << PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT2_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT2_M  (PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT2_V << PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT2_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT2_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE3_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_VT1_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_VT1_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT2_S  31

/** PVT_COMB_PD_SITE3_UNIT3_VT1_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT3_VT1_CONF1_REG (DR_REG_PVT_BASE + 0x114)
/** PVT_MONITOR_EN_VT1_PD_SITE3_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT3_M  (PVT_MONITOR_EN_VT1_PD_SITE3_UNIT3_V << PVT_MONITOR_EN_VT1_PD_SITE3_UNIT3_S)
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT1_PD_SITE3_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT1_PD_SITE3_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT3_M  (PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT3_V << PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT3_S)
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT1_PD_SITE3_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT3_M  (PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT3_V << PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT3_S)
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT1_PD_SITE3_UNIT3_S  23
/** PVT_TIMING_ERR_VT1_PD_SITE3_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_VT1_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_VT1_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT1_PD_SITE3_UNIT3_S  31

/** PVT_COMB_PD_SITE3_UNIT0_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT0_VT2_CONF1_REG (DR_REG_PVT_BASE + 0x118)
/** PVT_MONITOR_EN_VT2_PD_SITE3_UNIT0 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT0    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT0_M  (PVT_MONITOR_EN_VT2_PD_SITE3_UNIT0_V << PVT_MONITOR_EN_VT2_PD_SITE3_UNIT0_S)
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT0_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT0 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT0    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT0_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT0 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT0    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT0_M  (PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT0_V << PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT0_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT0_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT0_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT0 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT0    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT0_M  (PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT0_V << PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT0_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT0_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT0_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE3_UNIT0 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT0    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_VT2_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_VT2_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT0_S  31

/** PVT_COMB_PD_SITE3_UNIT1_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT1_VT2_CONF1_REG (DR_REG_PVT_BASE + 0x11c)
/** PVT_MONITOR_EN_VT2_PD_SITE3_UNIT1 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT1    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT1_M  (PVT_MONITOR_EN_VT2_PD_SITE3_UNIT1_V << PVT_MONITOR_EN_VT2_PD_SITE3_UNIT1_S)
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT1_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT1 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT1    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT1_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT1 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT1    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT1_M  (PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT1_V << PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT1_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT1_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT1_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT1 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT1    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT1_M  (PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT1_V << PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT1_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT1_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT1_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE3_UNIT1 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT1    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_VT2_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_VT2_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT1_S  31

/** PVT_COMB_PD_SITE3_UNIT2_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT2_VT2_CONF1_REG (DR_REG_PVT_BASE + 0x120)
/** PVT_MONITOR_EN_VT2_PD_SITE3_UNIT2 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT2    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT2_M  (PVT_MONITOR_EN_VT2_PD_SITE3_UNIT2_V << PVT_MONITOR_EN_VT2_PD_SITE3_UNIT2_S)
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT2_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT2 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT2    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT2_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT2 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT2    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT2_M  (PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT2_V << PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT2_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT2_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT2_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT2 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT2    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT2_M  (PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT2_V << PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT2_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT2_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT2_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE3_UNIT2 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT2    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_VT2_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_VT2_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT2_S  31

/** PVT_COMB_PD_SITE3_UNIT3_VT2_CONF1_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT3_VT2_CONF1_REG (DR_REG_PVT_BASE + 0x124)
/** PVT_MONITOR_EN_VT2_PD_SITE3_UNIT3 : R/W; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT3    (BIT(0))
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT3_M  (PVT_MONITOR_EN_VT2_PD_SITE3_UNIT3_V << PVT_MONITOR_EN_VT2_PD_SITE3_UNIT3_S)
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_MONITOR_EN_VT2_PD_SITE3_UNIT3_S  0
/** PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT3 : WT; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT3    (BIT(1))
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_CNT_CLR_VT2_PD_SITE3_UNIT3_S  1
/** PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT3 : R/W; bitpos: [9:2]; default: 20;
 *  needs field desc
 */
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT3    0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT3_M  (PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT3_V << PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT3_S)
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT3_V  0x000000FFU
#define PVT_DELAY_LIMIT_VT2_PD_SITE3_UNIT3_S  2
/** PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT3 : RO; bitpos: [30:23]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT3    0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT3_M  (PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT3_V << PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT3_S)
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT3_V  0x000000FFU
#define PVT_DELAY_NUM_O_VT2_PD_SITE3_UNIT3_S  23
/** PVT_TIMING_ERR_VT2_PD_SITE3_UNIT3 : RO; bitpos: [31]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT3    (BIT(31))
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_VT2_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_VT2_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_TIMING_ERR_VT2_PD_SITE3_UNIT3_S  31

/** PVT_COMB_PD_SITE0_UNIT0_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT0_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x128)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT0_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT0_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE0_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT0_M  (PVT_DELAY_OVF_VT0_PD_SITE0_UNIT0_V << PVT_DELAY_OVF_VT0_PD_SITE0_UNIT0_S)
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT0_S  16

/** PVT_COMB_PD_SITE0_UNIT1_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT1_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x12c)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT1_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT1_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE0_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT1_M  (PVT_DELAY_OVF_VT0_PD_SITE0_UNIT1_V << PVT_DELAY_OVF_VT0_PD_SITE0_UNIT1_S)
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT1_S  16

/** PVT_COMB_PD_SITE0_UNIT2_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT2_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x130)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT2_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT2_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE0_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT2_M  (PVT_DELAY_OVF_VT0_PD_SITE0_UNIT2_V << PVT_DELAY_OVF_VT0_PD_SITE0_UNIT2_S)
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT2_S  16

/** PVT_COMB_PD_SITE0_UNIT3_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT3_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x134)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT3_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE0_UNIT3_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE0_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT3_M  (PVT_DELAY_OVF_VT0_PD_SITE0_UNIT3_V << PVT_DELAY_OVF_VT0_PD_SITE0_UNIT3_S)
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE0_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE0_UNIT3_S  16

/** PVT_COMB_PD_SITE0_UNIT0_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT0_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x138)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT0_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT0_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE0_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT0_M  (PVT_DELAY_OVF_VT1_PD_SITE0_UNIT0_V << PVT_DELAY_OVF_VT1_PD_SITE0_UNIT0_S)
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT0_S  16

/** PVT_COMB_PD_SITE0_UNIT1_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT1_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x13c)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT1_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT1_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE0_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT1_M  (PVT_DELAY_OVF_VT1_PD_SITE0_UNIT1_V << PVT_DELAY_OVF_VT1_PD_SITE0_UNIT1_S)
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT1_S  16

/** PVT_COMB_PD_SITE0_UNIT2_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT2_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x140)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT2_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT2_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE0_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT2_M  (PVT_DELAY_OVF_VT1_PD_SITE0_UNIT2_V << PVT_DELAY_OVF_VT1_PD_SITE0_UNIT2_S)
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT2_S  16

/** PVT_COMB_PD_SITE0_UNIT3_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT3_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x144)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT3_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE0_UNIT3_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE0_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT3_M  (PVT_DELAY_OVF_VT1_PD_SITE0_UNIT3_V << PVT_DELAY_OVF_VT1_PD_SITE0_UNIT3_S)
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE0_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE0_UNIT3_S  16

/** PVT_COMB_PD_SITE0_UNIT0_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT0_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x148)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT0_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT0_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE0_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT0_M  (PVT_DELAY_OVF_VT2_PD_SITE0_UNIT0_V << PVT_DELAY_OVF_VT2_PD_SITE0_UNIT0_S)
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT0_S  16

/** PVT_COMB_PD_SITE0_UNIT1_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT1_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x14c)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT1_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT1_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE0_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT1_M  (PVT_DELAY_OVF_VT2_PD_SITE0_UNIT1_V << PVT_DELAY_OVF_VT2_PD_SITE0_UNIT1_S)
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT1_S  16

/** PVT_COMB_PD_SITE0_UNIT2_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT2_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x150)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT2_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT2_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE0_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT2_M  (PVT_DELAY_OVF_VT2_PD_SITE0_UNIT2_V << PVT_DELAY_OVF_VT2_PD_SITE0_UNIT2_S)
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT2_S  16

/** PVT_COMB_PD_SITE0_UNIT3_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE0_UNIT3_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x154)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT3_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE0_UNIT3_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE0_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT3_M  (PVT_DELAY_OVF_VT2_PD_SITE0_UNIT3_V << PVT_DELAY_OVF_VT2_PD_SITE0_UNIT3_S)
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE0_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE0_UNIT3_S  16

/** PVT_COMB_PD_SITE1_UNIT0_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT0_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x158)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT0_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT0_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE1_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT0_M  (PVT_DELAY_OVF_VT0_PD_SITE1_UNIT0_V << PVT_DELAY_OVF_VT0_PD_SITE1_UNIT0_S)
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT0_S  16

/** PVT_COMB_PD_SITE1_UNIT1_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT1_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x15c)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT1_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT1_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE1_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT1_M  (PVT_DELAY_OVF_VT0_PD_SITE1_UNIT1_V << PVT_DELAY_OVF_VT0_PD_SITE1_UNIT1_S)
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT1_S  16

/** PVT_COMB_PD_SITE1_UNIT2_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT2_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x160)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT2_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT2_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE1_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT2_M  (PVT_DELAY_OVF_VT0_PD_SITE1_UNIT2_V << PVT_DELAY_OVF_VT0_PD_SITE1_UNIT2_S)
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT2_S  16

/** PVT_COMB_PD_SITE1_UNIT3_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT3_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x164)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT3_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE1_UNIT3_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE1_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT3_M  (PVT_DELAY_OVF_VT0_PD_SITE1_UNIT3_V << PVT_DELAY_OVF_VT0_PD_SITE1_UNIT3_S)
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE1_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE1_UNIT3_S  16

/** PVT_COMB_PD_SITE1_UNIT0_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT0_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x168)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT0_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT0_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE1_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT0_M  (PVT_DELAY_OVF_VT1_PD_SITE1_UNIT0_V << PVT_DELAY_OVF_VT1_PD_SITE1_UNIT0_S)
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT0_S  16

/** PVT_COMB_PD_SITE1_UNIT1_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT1_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x16c)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT1_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT1_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE1_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT1_M  (PVT_DELAY_OVF_VT1_PD_SITE1_UNIT1_V << PVT_DELAY_OVF_VT1_PD_SITE1_UNIT1_S)
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT1_S  16

/** PVT_COMB_PD_SITE1_UNIT2_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT2_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x170)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT2_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT2_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE1_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT2_M  (PVT_DELAY_OVF_VT1_PD_SITE1_UNIT2_V << PVT_DELAY_OVF_VT1_PD_SITE1_UNIT2_S)
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT2_S  16

/** PVT_COMB_PD_SITE1_UNIT3_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT3_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x174)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT3_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE1_UNIT3_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE1_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT3_M  (PVT_DELAY_OVF_VT1_PD_SITE1_UNIT3_V << PVT_DELAY_OVF_VT1_PD_SITE1_UNIT3_S)
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE1_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE1_UNIT3_S  16

/** PVT_COMB_PD_SITE1_UNIT0_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT0_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x178)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT0_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT0_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE1_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT0_M  (PVT_DELAY_OVF_VT2_PD_SITE1_UNIT0_V << PVT_DELAY_OVF_VT2_PD_SITE1_UNIT0_S)
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT0_S  16

/** PVT_COMB_PD_SITE1_UNIT1_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT1_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x17c)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT1_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT1_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE1_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT1_M  (PVT_DELAY_OVF_VT2_PD_SITE1_UNIT1_V << PVT_DELAY_OVF_VT2_PD_SITE1_UNIT1_S)
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT1_S  16

/** PVT_COMB_PD_SITE1_UNIT2_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT2_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x180)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT2_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT2_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE1_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT2_M  (PVT_DELAY_OVF_VT2_PD_SITE1_UNIT2_V << PVT_DELAY_OVF_VT2_PD_SITE1_UNIT2_S)
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT2_S  16

/** PVT_COMB_PD_SITE1_UNIT3_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE1_UNIT3_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x184)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT3_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE1_UNIT3_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE1_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT3_M  (PVT_DELAY_OVF_VT2_PD_SITE1_UNIT3_V << PVT_DELAY_OVF_VT2_PD_SITE1_UNIT3_S)
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE1_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE1_UNIT3_S  16

/** PVT_COMB_PD_SITE2_UNIT0_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT0_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x188)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT0_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT0_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE2_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT0_M  (PVT_DELAY_OVF_VT0_PD_SITE2_UNIT0_V << PVT_DELAY_OVF_VT0_PD_SITE2_UNIT0_S)
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT0_S  16

/** PVT_COMB_PD_SITE2_UNIT1_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT1_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x18c)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT1_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT1_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE2_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT1_M  (PVT_DELAY_OVF_VT0_PD_SITE2_UNIT1_V << PVT_DELAY_OVF_VT0_PD_SITE2_UNIT1_S)
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT1_S  16

/** PVT_COMB_PD_SITE2_UNIT2_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT2_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x190)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT2_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT2_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE2_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT2_M  (PVT_DELAY_OVF_VT0_PD_SITE2_UNIT2_V << PVT_DELAY_OVF_VT0_PD_SITE2_UNIT2_S)
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT2_S  16

/** PVT_COMB_PD_SITE2_UNIT3_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT3_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x194)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT3_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE2_UNIT3_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE2_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT3_M  (PVT_DELAY_OVF_VT0_PD_SITE2_UNIT3_V << PVT_DELAY_OVF_VT0_PD_SITE2_UNIT3_S)
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE2_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE2_UNIT3_S  16

/** PVT_COMB_PD_SITE2_UNIT0_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT0_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x198)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT0_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT0_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE2_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT0_M  (PVT_DELAY_OVF_VT1_PD_SITE2_UNIT0_V << PVT_DELAY_OVF_VT1_PD_SITE2_UNIT0_S)
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT0_S  16

/** PVT_COMB_PD_SITE2_UNIT1_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT1_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x19c)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT1_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT1_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE2_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT1_M  (PVT_DELAY_OVF_VT1_PD_SITE2_UNIT1_V << PVT_DELAY_OVF_VT1_PD_SITE2_UNIT1_S)
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT1_S  16

/** PVT_COMB_PD_SITE2_UNIT2_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT2_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x1a0)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT2_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT2_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE2_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT2_M  (PVT_DELAY_OVF_VT1_PD_SITE2_UNIT2_V << PVT_DELAY_OVF_VT1_PD_SITE2_UNIT2_S)
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT2_S  16

/** PVT_COMB_PD_SITE2_UNIT3_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT3_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x1a4)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT3_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE2_UNIT3_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE2_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT3_M  (PVT_DELAY_OVF_VT1_PD_SITE2_UNIT3_V << PVT_DELAY_OVF_VT1_PD_SITE2_UNIT3_S)
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE2_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE2_UNIT3_S  16

/** PVT_COMB_PD_SITE2_UNIT0_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT0_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x1a8)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT0_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT0_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE2_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT0_M  (PVT_DELAY_OVF_VT2_PD_SITE2_UNIT0_V << PVT_DELAY_OVF_VT2_PD_SITE2_UNIT0_S)
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT0_S  16

/** PVT_COMB_PD_SITE2_UNIT1_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT1_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x1ac)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT1_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT1_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE2_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT1_M  (PVT_DELAY_OVF_VT2_PD_SITE2_UNIT1_V << PVT_DELAY_OVF_VT2_PD_SITE2_UNIT1_S)
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT1_S  16

/** PVT_COMB_PD_SITE2_UNIT2_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT2_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x1b0)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT2_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT2_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE2_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT2_M  (PVT_DELAY_OVF_VT2_PD_SITE2_UNIT2_V << PVT_DELAY_OVF_VT2_PD_SITE2_UNIT2_S)
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT2_S  16

/** PVT_COMB_PD_SITE2_UNIT3_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE2_UNIT3_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x1b4)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT3_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE2_UNIT3_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE2_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT3_M  (PVT_DELAY_OVF_VT2_PD_SITE2_UNIT3_V << PVT_DELAY_OVF_VT2_PD_SITE2_UNIT3_S)
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE2_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE2_UNIT3_S  16

/** PVT_COMB_PD_SITE3_UNIT0_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT0_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x1b8)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT0_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT0_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE3_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT0_M  (PVT_DELAY_OVF_VT0_PD_SITE3_UNIT0_V << PVT_DELAY_OVF_VT0_PD_SITE3_UNIT0_S)
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT0_S  16

/** PVT_COMB_PD_SITE3_UNIT1_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT1_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x1bc)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT1_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT1_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE3_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT1_M  (PVT_DELAY_OVF_VT0_PD_SITE3_UNIT1_V << PVT_DELAY_OVF_VT0_PD_SITE3_UNIT1_S)
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT1_S  16

/** PVT_COMB_PD_SITE3_UNIT2_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT2_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x1c0)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT2_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT2_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE3_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT2_M  (PVT_DELAY_OVF_VT0_PD_SITE3_UNIT2_V << PVT_DELAY_OVF_VT0_PD_SITE3_UNIT2_S)
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT2_S  16

/** PVT_COMB_PD_SITE3_UNIT3_VT0_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT3_VT0_CONF2_REG (DR_REG_PVT_BASE + 0x1c4)
/** PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT3_V << PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT0_PD_SITE3_UNIT3_S  0
/** PVT_DELAY_OVF_VT0_PD_SITE3_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT3_M  (PVT_DELAY_OVF_VT0_PD_SITE3_UNIT3_V << PVT_DELAY_OVF_VT0_PD_SITE3_UNIT3_S)
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT0_PD_SITE3_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT0_PD_SITE3_UNIT3_S  16

/** PVT_COMB_PD_SITE3_UNIT0_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT0_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x1c8)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT0_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT0_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE3_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT0_M  (PVT_DELAY_OVF_VT1_PD_SITE3_UNIT0_V << PVT_DELAY_OVF_VT1_PD_SITE3_UNIT0_S)
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT0_S  16

/** PVT_COMB_PD_SITE3_UNIT1_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT1_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x1cc)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT1_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT1_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE3_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT1_M  (PVT_DELAY_OVF_VT1_PD_SITE3_UNIT1_V << PVT_DELAY_OVF_VT1_PD_SITE3_UNIT1_S)
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT1_S  16

/** PVT_COMB_PD_SITE3_UNIT2_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT2_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x1d0)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT2_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT2_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE3_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT2_M  (PVT_DELAY_OVF_VT1_PD_SITE3_UNIT2_V << PVT_DELAY_OVF_VT1_PD_SITE3_UNIT2_S)
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT2_S  16

/** PVT_COMB_PD_SITE3_UNIT3_VT1_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT3_VT1_CONF2_REG (DR_REG_PVT_BASE + 0x1d4)
/** PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT3_V << PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT1_PD_SITE3_UNIT3_S  0
/** PVT_DELAY_OVF_VT1_PD_SITE3_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT3_M  (PVT_DELAY_OVF_VT1_PD_SITE3_UNIT3_V << PVT_DELAY_OVF_VT1_PD_SITE3_UNIT3_S)
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT1_PD_SITE3_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT1_PD_SITE3_UNIT3_S  16

/** PVT_COMB_PD_SITE3_UNIT0_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT0_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x1d8)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT0 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT0    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT0_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT0_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT0_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT0_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT0_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE3_UNIT0 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT0    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT0_M  (PVT_DELAY_OVF_VT2_PD_SITE3_UNIT0_V << PVT_DELAY_OVF_VT2_PD_SITE3_UNIT0_S)
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT0_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT0_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT0 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT0    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT0_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT0_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT0_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT0_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT0_S  16

/** PVT_COMB_PD_SITE3_UNIT1_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT1_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x1dc)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT1 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT1    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT1_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT1_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT1_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT1_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT1_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE3_UNIT1 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT1    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT1_M  (PVT_DELAY_OVF_VT2_PD_SITE3_UNIT1_V << PVT_DELAY_OVF_VT2_PD_SITE3_UNIT1_S)
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT1_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT1_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT1 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT1    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT1_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT1_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT1_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT1_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT1_S  16

/** PVT_COMB_PD_SITE3_UNIT2_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT2_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x1e0)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT2 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT2    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT2_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT2_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT2_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT2_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT2_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE3_UNIT2 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT2    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT2_M  (PVT_DELAY_OVF_VT2_PD_SITE3_UNIT2_V << PVT_DELAY_OVF_VT2_PD_SITE3_UNIT2_S)
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT2_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT2_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT2 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT2    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT2_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT2_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT2_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT2_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT2_S  16

/** PVT_COMB_PD_SITE3_UNIT3_VT2_CONF2_REG register
 *  needs desc
 */
#define PVT_COMB_PD_SITE3_UNIT3_VT2_CONF2_REG (DR_REG_PVT_BASE + 0x1e4)
/** PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT3 : R/W; bitpos: [1:0]; default: 0;
 *  needs field desc
 */
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT3    0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT3_M  (PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT3_V << PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT3_S)
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT3_V  0x00000003U
#define PVT_MONITOR_EDG_MOD_VT2_PD_SITE3_UNIT3_S  0
/** PVT_DELAY_OVF_VT2_PD_SITE3_UNIT3 : RO; bitpos: [15]; default: 0;
 *  needs field desc
 */
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT3    (BIT(15))
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT3_M  (PVT_DELAY_OVF_VT2_PD_SITE3_UNIT3_V << PVT_DELAY_OVF_VT2_PD_SITE3_UNIT3_S)
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT3_V  0x00000001U
#define PVT_DELAY_OVF_VT2_PD_SITE3_UNIT3_S  15
/** PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT3 : RO; bitpos: [31:16]; default: 0;
 *  needs field desc
 */
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT3    0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT3_M  (PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT3_V << PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT3_S)
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT3_V  0x0000FFFFU
#define PVT_TIMING_ERR_CNT_O_VT2_PD_SITE3_UNIT3_S  16

/** PVT_VALUE_UPDATE_REG register
 *  needs field desc
 */
#define PVT_VALUE_UPDATE_REG (DR_REG_PVT_BASE + 0x1e8)
/** PVT_VALUE_UPDATE : WT; bitpos: [0]; default: 0;
 *  needs field desc
 */
#define PVT_VALUE_UPDATE    (BIT(0))
#define PVT_VALUE_UPDATE_M  (PVT_VALUE_UPDATE_V << PVT_VALUE_UPDATE_S)
#define PVT_VALUE_UPDATE_V  0x00000001U
#define PVT_VALUE_UPDATE_S  0
/** PVT_VALUE_UPDATE_BYPASS : R/W; bitpos: [1]; default: 0;
 *  needs field desc
 */
#define PVT_VALUE_UPDATE_BYPASS    (BIT(1))
#define PVT_VALUE_UPDATE_BYPASS_M  (PVT_VALUE_UPDATE_BYPASS_V << PVT_VALUE_UPDATE_BYPASS_S)
#define PVT_VALUE_UPDATE_BYPASS_V  0x00000001U
#define PVT_VALUE_UPDATE_BYPASS_S  1

/** PVT_DATE_REG register
 *  version register
 */
#define PVT_DATE_REG (DR_REG_PVT_BASE + 0xffc)
/** PVT_DATE : R/W; bitpos: [31:0]; default: 34677040;
 *  version register
 */
#define PVT_DATE    0xFFFFFFFFU
#define PVT_DATE_M  (PVT_DATE_V << PVT_DATE_S)
#define PVT_DATE_V  0xFFFFFFFFU
#define PVT_DATE_S  0

#ifdef __cplusplus
}
#endif
