/**
 * SPDX-FileCopyrightText: 2023-2024 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** LP_ANALOG_PERI_BOD_MODE0_CNTL_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_CNTL_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x0)
/** LP_ANALOG_PERI_BOD_MODE0_CLOSE_FLASH_ENA : R/W; bitpos: [6]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_CLOSE_FLASH_ENA    (BIT(6))
#define LP_ANALOG_PERI_BOD_MODE0_CLOSE_FLASH_ENA_M  (LP_ANALOG_PERI_BOD_MODE0_CLOSE_FLASH_ENA_V << LP_ANALOG_PERI_BOD_MODE0_CLOSE_FLASH_ENA_S)
#define LP_ANALOG_PERI_BOD_MODE0_CLOSE_FLASH_ENA_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_CLOSE_FLASH_ENA_S  6
/** LP_ANALOG_PERI_BOD_MODE0_PD_RF_ENA : R/W; bitpos: [7]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_PD_RF_ENA    (BIT(7))
#define LP_ANALOG_PERI_BOD_MODE0_PD_RF_ENA_M  (LP_ANALOG_PERI_BOD_MODE0_PD_RF_ENA_V << LP_ANALOG_PERI_BOD_MODE0_PD_RF_ENA_S)
#define LP_ANALOG_PERI_BOD_MODE0_PD_RF_ENA_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_PD_RF_ENA_S  7
/** LP_ANALOG_PERI_BOD_MODE0_INTR_WAIT : R/W; bitpos: [17:8]; default: 1;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_INTR_WAIT    0x000003FFU
#define LP_ANALOG_PERI_BOD_MODE0_INTR_WAIT_M  (LP_ANALOG_PERI_BOD_MODE0_INTR_WAIT_V << LP_ANALOG_PERI_BOD_MODE0_INTR_WAIT_S)
#define LP_ANALOG_PERI_BOD_MODE0_INTR_WAIT_V  0x000003FFU
#define LP_ANALOG_PERI_BOD_MODE0_INTR_WAIT_S  8
/** LP_ANALOG_PERI_BOD_MODE0_RESET_WAIT : R/W; bitpos: [27:18]; default: 1023;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_RESET_WAIT    0x000003FFU
#define LP_ANALOG_PERI_BOD_MODE0_RESET_WAIT_M  (LP_ANALOG_PERI_BOD_MODE0_RESET_WAIT_V << LP_ANALOG_PERI_BOD_MODE0_RESET_WAIT_S)
#define LP_ANALOG_PERI_BOD_MODE0_RESET_WAIT_V  0x000003FFU
#define LP_ANALOG_PERI_BOD_MODE0_RESET_WAIT_S  18
/** LP_ANALOG_PERI_BOD_MODE0_CNT_CLR : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_CNT_CLR    (BIT(28))
#define LP_ANALOG_PERI_BOD_MODE0_CNT_CLR_M  (LP_ANALOG_PERI_BOD_MODE0_CNT_CLR_V << LP_ANALOG_PERI_BOD_MODE0_CNT_CLR_S)
#define LP_ANALOG_PERI_BOD_MODE0_CNT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_CNT_CLR_S  28
/** LP_ANALOG_PERI_BOD_MODE0_INTR_ENA : R/W; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_INTR_ENA    (BIT(29))
#define LP_ANALOG_PERI_BOD_MODE0_INTR_ENA_M  (LP_ANALOG_PERI_BOD_MODE0_INTR_ENA_V << LP_ANALOG_PERI_BOD_MODE0_INTR_ENA_S)
#define LP_ANALOG_PERI_BOD_MODE0_INTR_ENA_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_INTR_ENA_S  29
/** LP_ANALOG_PERI_BOD_MODE0_RESET_SEL : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_RESET_SEL    (BIT(30))
#define LP_ANALOG_PERI_BOD_MODE0_RESET_SEL_M  (LP_ANALOG_PERI_BOD_MODE0_RESET_SEL_V << LP_ANALOG_PERI_BOD_MODE0_RESET_SEL_S)
#define LP_ANALOG_PERI_BOD_MODE0_RESET_SEL_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_RESET_SEL_S  30
/** LP_ANALOG_PERI_BOD_MODE0_RESET_ENA : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_RESET_ENA    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_RESET_ENA_M  (LP_ANALOG_PERI_BOD_MODE0_RESET_ENA_V << LP_ANALOG_PERI_BOD_MODE0_RESET_ENA_S)
#define LP_ANALOG_PERI_BOD_MODE0_RESET_ENA_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_RESET_ENA_S  31

/** LP_ANALOG_PERI_BOD_MODE1_CNTL_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE1_CNTL_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x4)
/** LP_ANALOG_PERI_BOD_MODE1_RESET_ENA : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE1_RESET_ENA    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE1_RESET_ENA_M  (LP_ANALOG_PERI_BOD_MODE1_RESET_ENA_V << LP_ANALOG_PERI_BOD_MODE1_RESET_ENA_S)
#define LP_ANALOG_PERI_BOD_MODE1_RESET_ENA_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE1_RESET_ENA_S  31

/** LP_ANALOG_PERI_VDD_SOURCE_CNTL_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_VDD_SOURCE_CNTL_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x8)
/** LP_ANALOG_PERI_DETMODE_SEL : R/W; bitpos: [7:0]; default: 255;
 *  need_des
 */
#define LP_ANALOG_PERI_DETMODE_SEL    0x000000FFU
#define LP_ANALOG_PERI_DETMODE_SEL_M  (LP_ANALOG_PERI_DETMODE_SEL_V << LP_ANALOG_PERI_DETMODE_SEL_S)
#define LP_ANALOG_PERI_DETMODE_SEL_V  0x000000FFU
#define LP_ANALOG_PERI_DETMODE_SEL_S  0
/** LP_ANALOG_PERI_VGOOD_EVENT_RECORD : RO; bitpos: [15:8]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VGOOD_EVENT_RECORD    0x000000FFU
#define LP_ANALOG_PERI_VGOOD_EVENT_RECORD_M  (LP_ANALOG_PERI_VGOOD_EVENT_RECORD_V << LP_ANALOG_PERI_VGOOD_EVENT_RECORD_S)
#define LP_ANALOG_PERI_VGOOD_EVENT_RECORD_V  0x000000FFU
#define LP_ANALOG_PERI_VGOOD_EVENT_RECORD_S  8
/** LP_ANALOG_PERI_VBAT_EVENT_RECORD_CLR : WT; bitpos: [23:16]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VBAT_EVENT_RECORD_CLR    0x000000FFU
#define LP_ANALOG_PERI_VBAT_EVENT_RECORD_CLR_M  (LP_ANALOG_PERI_VBAT_EVENT_RECORD_CLR_V << LP_ANALOG_PERI_VBAT_EVENT_RECORD_CLR_S)
#define LP_ANALOG_PERI_VBAT_EVENT_RECORD_CLR_V  0x000000FFU
#define LP_ANALOG_PERI_VBAT_EVENT_RECORD_CLR_S  16
/** LP_ANALOG_PERI_BOD_SOURCE_ENA : R/W; bitpos: [31:24]; default: 4;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_SOURCE_ENA    0x000000FFU
#define LP_ANALOG_PERI_BOD_SOURCE_ENA_M  (LP_ANALOG_PERI_BOD_SOURCE_ENA_V << LP_ANALOG_PERI_BOD_SOURCE_ENA_S)
#define LP_ANALOG_PERI_BOD_SOURCE_ENA_V  0x000000FFU
#define LP_ANALOG_PERI_BOD_SOURCE_ENA_S  24

/** LP_ANALOG_PERI_VDDBAT_BOD_CNTL_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_BOD_CNTL_REG (DR_REG_LP_ANALOG_PERI_BASE + 0xc)
/** LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_FLAG : RO; bitpos: [0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_FLAG    (BIT(0))
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_FLAG_M  (LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_FLAG_V << LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_FLAG_S)
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_FLAG_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_FLAG_S  0
/** LP_ANALOG_PERI_VDDBAT_CHARGER : R/W; bitpos: [10]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGER    (BIT(10))
#define LP_ANALOG_PERI_VDDBAT_CHARGER_M  (LP_ANALOG_PERI_VDDBAT_CHARGER_V << LP_ANALOG_PERI_VDDBAT_CHARGER_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGER_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGER_S  10
/** LP_ANALOG_PERI_VDDBAT_CNT_CLR : R/W; bitpos: [11]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CNT_CLR    (BIT(11))
#define LP_ANALOG_PERI_VDDBAT_CNT_CLR_M  (LP_ANALOG_PERI_VDDBAT_CNT_CLR_V << LP_ANALOG_PERI_VDDBAT_CNT_CLR_S)
#define LP_ANALOG_PERI_VDDBAT_CNT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CNT_CLR_S  11
/** LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_TARGET : R/W; bitpos: [21:12]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_TARGET    0x000003FFU
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_TARGET_M  (LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_TARGET_V << LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_TARGET_S)
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_TARGET_V  0x000003FFU
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_TARGET_S  12
/** LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_TARGET : R/W; bitpos: [31:22]; default: 1023;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_TARGET    0x000003FFU
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_TARGET_M  (LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_TARGET_V << LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_TARGET_S)
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_TARGET_V  0x000003FFU
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_TARGET_S  22

/** LP_ANALOG_PERI_VDDBAT_CHARGE_CNTL_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CNTL_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x10)
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_FLAG : RO; bitpos: [0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_FLAG    (BIT(0))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_FLAG_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_FLAG_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_FLAG_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_FLAG_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_FLAG_S  0
/** LP_ANALOG_PERI_VDDBAT_CHARGE_CHARGER : R/W; bitpos: [10]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CHARGER    (BIT(10))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CHARGER_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_CHARGER_V << LP_ANALOG_PERI_VDDBAT_CHARGE_CHARGER_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CHARGER_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CHARGER_S  10
/** LP_ANALOG_PERI_VDDBAT_CHARGE_CNT_CLR : R/W; bitpos: [11]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CNT_CLR    (BIT(11))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CNT_CLR_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_CNT_CLR_V << LP_ANALOG_PERI_VDDBAT_CHARGE_CNT_CLR_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CNT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_CNT_CLR_S  11
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_TARGET : R/W; bitpos: [21:12]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_TARGET    0x000003FFU
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_TARGET_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_TARGET_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_TARGET_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_TARGET_V  0x000003FFU
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_TARGET_S  12
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_TARGET : R/W; bitpos: [31:22]; default: 1023;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_TARGET    0x000003FFU
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_TARGET_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_TARGET_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_TARGET_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_TARGET_V  0x000003FFU
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_TARGET_S  22

/** LP_ANALOG_PERI_PG_GLITCH_CNTL_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_PG_GLITCH_CNTL_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x18)
/** LP_ANALOG_PERI_POWER_GLITCH_RESET_ENA : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_POWER_GLITCH_RESET_ENA    (BIT(31))
#define LP_ANALOG_PERI_POWER_GLITCH_RESET_ENA_M  (LP_ANALOG_PERI_POWER_GLITCH_RESET_ENA_V << LP_ANALOG_PERI_POWER_GLITCH_RESET_ENA_S)
#define LP_ANALOG_PERI_POWER_GLITCH_RESET_ENA_V  0x00000001U
#define LP_ANALOG_PERI_POWER_GLITCH_RESET_ENA_S  31

/** LP_ANALOG_PERI_FIB_ENABLE_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_FIB_ENABLE_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1c)
/** LP_ANALOG_PERI_ANA_FIB_ENA : R/W; bitpos: [31:0]; default: 4294967295;
 *  need_des
 */
#define LP_ANALOG_PERI_ANA_FIB_ENA    0xFFFFFFFFU
#define LP_ANALOG_PERI_ANA_FIB_ENA_M  (LP_ANALOG_PERI_ANA_FIB_ENA_V << LP_ANALOG_PERI_ANA_FIB_ENA_S)
#define LP_ANALOG_PERI_ANA_FIB_ENA_V  0xFFFFFFFFU
#define LP_ANALOG_PERI_ANA_FIB_ENA_S  0

#define LP_ANALOG_PERI_LP_ANA_FIB_BOD_RST BIT(1)

/** LP_ANALOG_PERI_INT_RAW_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_INT_RAW_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x20)
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_RAW : R/WTC/SS; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_RAW    (BIT(27))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_RAW_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_RAW_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_RAW_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_RAW_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_RAW_S  27
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_RAW : R/WTC/SS; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_RAW    (BIT(28))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_RAW_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_RAW_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_RAW_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_RAW_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_RAW_S  28
/** LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_RAW : R/WTC/SS; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_RAW    (BIT(29))
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_RAW_M  (LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_RAW_V << LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_RAW_S)
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_RAW_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_RAW_S  29
/** LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_RAW : R/WTC/SS; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_RAW    (BIT(30))
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_RAW_M  (LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_RAW_V << LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_RAW_S)
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_RAW_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_RAW_S  30
/** LP_ANALOG_PERI_BOD_MODE0_INT_RAW : R/WTC/SS; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_INT_RAW    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_INT_RAW_M  (LP_ANALOG_PERI_BOD_MODE0_INT_RAW_V << LP_ANALOG_PERI_BOD_MODE0_INT_RAW_S)
#define LP_ANALOG_PERI_BOD_MODE0_INT_RAW_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_INT_RAW_S  31

/** LP_ANALOG_PERI_INT_ST_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_INT_ST_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x24)
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ST : RO; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ST    (BIT(27))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ST_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ST_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ST_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ST_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ST_S  27
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ST : RO; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ST    (BIT(28))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ST_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ST_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ST_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ST_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ST_S  28
/** LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ST : RO; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ST    (BIT(29))
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ST_M  (LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ST_V << LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ST_S)
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ST_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ST_S  29
/** LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ST : RO; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ST    (BIT(30))
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ST_M  (LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ST_V << LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ST_S)
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ST_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ST_S  30
/** LP_ANALOG_PERI_BOD_MODE0_INT_ST : RO; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_INT_ST    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_INT_ST_M  (LP_ANALOG_PERI_BOD_MODE0_INT_ST_V << LP_ANALOG_PERI_BOD_MODE0_INT_ST_S)
#define LP_ANALOG_PERI_BOD_MODE0_INT_ST_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_INT_ST_S  31

/** LP_ANALOG_PERI_INT_ENA_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_INT_ENA_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x28)
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ENA : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ENA    (BIT(27))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ENA_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ENA_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ENA_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ENA_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_ENA_S  27
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ENA : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ENA    (BIT(28))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ENA_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ENA_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ENA_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ENA_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_ENA_S  28
/** LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ENA : R/W; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ENA    (BIT(29))
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ENA_M  (LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ENA_V << LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ENA_S)
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ENA_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_ENA_S  29
/** LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ENA : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ENA    (BIT(30))
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ENA_M  (LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ENA_V << LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ENA_S)
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ENA_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_ENA_S  30
/** LP_ANALOG_PERI_BOD_MODE0_INT_ENA : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_INT_ENA    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_INT_ENA_M  (LP_ANALOG_PERI_BOD_MODE0_INT_ENA_V << LP_ANALOG_PERI_BOD_MODE0_INT_ENA_S)
#define LP_ANALOG_PERI_BOD_MODE0_INT_ENA_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_INT_ENA_S  31

/** LP_ANALOG_PERI_INT_CLR_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_INT_CLR_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x2c)
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_CLR : WT; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_CLR    (BIT(27))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_CLR_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_CLR_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_CLR_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UPVOLTAGE_INT_CLR_S  27
/** LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_CLR : WT; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_CLR    (BIT(28))
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_CLR_M  (LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_CLR_V << LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_CLR_S)
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_CHARGE_UNDERVOLTAGE_INT_CLR_S  28
/** LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_CLR : WT; bitpos: [29]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_CLR    (BIT(29))
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_CLR_M  (LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_CLR_V << LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_CLR_S)
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UPVOLTAGE_INT_CLR_S  29
/** LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_CLR : WT; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_CLR    (BIT(30))
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_CLR_M  (LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_CLR_V << LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_CLR_S)
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_VDDBAT_UNDERVOLTAGE_INT_CLR_S  30
/** LP_ANALOG_PERI_BOD_MODE0_INT_CLR : WT; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_INT_CLR    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_INT_CLR_M  (LP_ANALOG_PERI_BOD_MODE0_INT_CLR_V << LP_ANALOG_PERI_BOD_MODE0_INT_CLR_S)
#define LP_ANALOG_PERI_BOD_MODE0_INT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_INT_CLR_S  31

/** LP_ANALOG_PERI_LP_INT_RAW_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_LP_INT_RAW_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x30)
/** LP_ANALOG_PERI_BOD_MODE0_LP_INT_RAW : R/WTC/SS; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_RAW    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_RAW_M  (LP_ANALOG_PERI_BOD_MODE0_LP_INT_RAW_V << LP_ANALOG_PERI_BOD_MODE0_LP_INT_RAW_S)
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_RAW_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_RAW_S  31

/** LP_ANALOG_PERI_LP_INT_ST_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_LP_INT_ST_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x34)
/** LP_ANALOG_PERI_BOD_MODE0_LP_INT_ST : RO; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_ST    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_ST_M  (LP_ANALOG_PERI_BOD_MODE0_LP_INT_ST_V << LP_ANALOG_PERI_BOD_MODE0_LP_INT_ST_S)
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_ST_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_ST_S  31

/** LP_ANALOG_PERI_LP_INT_ENA_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_LP_INT_ENA_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x38)
/** LP_ANALOG_PERI_BOD_MODE0_LP_INT_ENA : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_ENA    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_ENA_M  (LP_ANALOG_PERI_BOD_MODE0_LP_INT_ENA_V << LP_ANALOG_PERI_BOD_MODE0_LP_INT_ENA_S)
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_ENA_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_ENA_S  31

/** LP_ANALOG_PERI_LP_INT_CLR_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_LP_INT_CLR_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x3c)
/** LP_ANALOG_PERI_BOD_MODE0_LP_INT_CLR : WT; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_CLR    (BIT(31))
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_CLR_M  (LP_ANALOG_PERI_BOD_MODE0_LP_INT_CLR_V << LP_ANALOG_PERI_BOD_MODE0_LP_INT_CLR_S)
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_CLR_V  0x00000001U
#define LP_ANALOG_PERI_BOD_MODE0_LP_INT_CLR_S  31

/** LP_ANALOG_PERI_TOUCH_APPROACH_WORK_MEAS_NUM_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_WORK_MEAS_NUM_REG (DR_REG_LP_ANALOG_PERI_BASE + 0xfc)
/** LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM2 : R/W; bitpos: [9:0]; default: 100;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM2    0x000003FFU
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM2_M  (LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM2_V << LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM2_S)
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM2_V  0x000003FFU
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM2_S  0
/** LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM1 : R/W; bitpos: [19:10]; default: 100;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM1    0x000003FFU
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM1_M  (LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM1_V << LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM1_S)
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM1_V  0x000003FFU
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM1_S  10
/** LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM0 : R/W; bitpos: [29:20]; default: 100;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM0    0x000003FFU
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM0_M  (LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM0_V << LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM0_S)
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM0_V  0x000003FFU
#define LP_ANALOG_PERI_TOUCH_APPROACH_MEAS_NUM0_S  20

/** LP_ANALOG_PERI_TOUCH_SCAN_CTRL1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SCAN_CTRL1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x100)
/** LP_ANALOG_PERI_TOUCH_SHIELD_PAD_EN : R/W; bitpos: [0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SHIELD_PAD_EN    (BIT(0))
#define LP_ANALOG_PERI_TOUCH_SHIELD_PAD_EN_M  (LP_ANALOG_PERI_TOUCH_SHIELD_PAD_EN_V << LP_ANALOG_PERI_TOUCH_SHIELD_PAD_EN_S)
#define LP_ANALOG_PERI_TOUCH_SHIELD_PAD_EN_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_SHIELD_PAD_EN_S  0
/** LP_ANALOG_PERI_TOUCH_INACTIVE_CONNECTION : R/W; bitpos: [1]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_INACTIVE_CONNECTION    (BIT(1))
#define LP_ANALOG_PERI_TOUCH_INACTIVE_CONNECTION_M  (LP_ANALOG_PERI_TOUCH_INACTIVE_CONNECTION_V << LP_ANALOG_PERI_TOUCH_INACTIVE_CONNECTION_S)
#define LP_ANALOG_PERI_TOUCH_INACTIVE_CONNECTION_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_INACTIVE_CONNECTION_S  1
/** LP_ANALOG_PERI_TOUCH_SCAN_PAD_MAP : R/W; bitpos: [16:2]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SCAN_PAD_MAP    0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_SCAN_PAD_MAP_M  (LP_ANALOG_PERI_TOUCH_SCAN_PAD_MAP_V << LP_ANALOG_PERI_TOUCH_SCAN_PAD_MAP_S)
#define LP_ANALOG_PERI_TOUCH_SCAN_PAD_MAP_V  0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_SCAN_PAD_MAP_S  2
/** LP_ANALOG_PERI_TOUCH_XPD_WAIT : R/W; bitpos: [31:17]; default: 4;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_XPD_WAIT    0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_XPD_WAIT_M  (LP_ANALOG_PERI_TOUCH_XPD_WAIT_V << LP_ANALOG_PERI_TOUCH_XPD_WAIT_S)
#define LP_ANALOG_PERI_TOUCH_XPD_WAIT_V  0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_XPD_WAIT_S  17

/** LP_ANALOG_PERI_TOUCH_SCAN_CTRL2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SCAN_CTRL2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x104)
/** LP_ANALOG_PERI_TOUCH_TIMEOUT_NUM : R/W; bitpos: [21:6]; default: 65535;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_TIMEOUT_NUM    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_TIMEOUT_NUM_M  (LP_ANALOG_PERI_TOUCH_TIMEOUT_NUM_V << LP_ANALOG_PERI_TOUCH_TIMEOUT_NUM_S)
#define LP_ANALOG_PERI_TOUCH_TIMEOUT_NUM_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_TIMEOUT_NUM_S  6
/** LP_ANALOG_PERI_TOUCH_TIMEOUT_EN : R/W; bitpos: [22]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_TIMEOUT_EN    (BIT(22))
#define LP_ANALOG_PERI_TOUCH_TIMEOUT_EN_M  (LP_ANALOG_PERI_TOUCH_TIMEOUT_EN_V << LP_ANALOG_PERI_TOUCH_TIMEOUT_EN_S)
#define LP_ANALOG_PERI_TOUCH_TIMEOUT_EN_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_TIMEOUT_EN_S  22
/** LP_ANALOG_PERI_TOUCH_OUT_RING : R/W; bitpos: [26:23]; default: 15;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_OUT_RING    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_OUT_RING_M  (LP_ANALOG_PERI_TOUCH_OUT_RING_V << LP_ANALOG_PERI_TOUCH_OUT_RING_S)
#define LP_ANALOG_PERI_TOUCH_OUT_RING_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_OUT_RING_S  23
/** LP_ANALOG_PERI_FREQ_SCAN_EN : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_FREQ_SCAN_EN    (BIT(27))
#define LP_ANALOG_PERI_FREQ_SCAN_EN_M  (LP_ANALOG_PERI_FREQ_SCAN_EN_V << LP_ANALOG_PERI_FREQ_SCAN_EN_S)
#define LP_ANALOG_PERI_FREQ_SCAN_EN_V  0x00000001U
#define LP_ANALOG_PERI_FREQ_SCAN_EN_S  27
/** LP_ANALOG_PERI_FREQ_SCAN_CNT_LIMIT : R/W; bitpos: [29:28]; default: 3;
 *  need_des
 */
#define LP_ANALOG_PERI_FREQ_SCAN_CNT_LIMIT    0x00000003U
#define LP_ANALOG_PERI_FREQ_SCAN_CNT_LIMIT_M  (LP_ANALOG_PERI_FREQ_SCAN_CNT_LIMIT_V << LP_ANALOG_PERI_FREQ_SCAN_CNT_LIMIT_S)
#define LP_ANALOG_PERI_FREQ_SCAN_CNT_LIMIT_V  0x00000003U
#define LP_ANALOG_PERI_FREQ_SCAN_CNT_LIMIT_S  28

/** LP_ANALOG_PERI_TOUCH_WORK_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_WORK_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x108)
/** LP_ANALOG_PERI_DIV_NUM2 : R/W; bitpos: [18:16]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_DIV_NUM2    0x00000007U
#define LP_ANALOG_PERI_DIV_NUM2_M  (LP_ANALOG_PERI_DIV_NUM2_V << LP_ANALOG_PERI_DIV_NUM2_S)
#define LP_ANALOG_PERI_DIV_NUM2_V  0x00000007U
#define LP_ANALOG_PERI_DIV_NUM2_S  16
/** LP_ANALOG_PERI_DIV_NUM1 : R/W; bitpos: [21:19]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_DIV_NUM1    0x00000007U
#define LP_ANALOG_PERI_DIV_NUM1_M  (LP_ANALOG_PERI_DIV_NUM1_V << LP_ANALOG_PERI_DIV_NUM1_S)
#define LP_ANALOG_PERI_DIV_NUM1_V  0x00000007U
#define LP_ANALOG_PERI_DIV_NUM1_S  19
/** LP_ANALOG_PERI_DIV_NUM0 : R/W; bitpos: [24:22]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_DIV_NUM0    0x00000007U
#define LP_ANALOG_PERI_DIV_NUM0_M  (LP_ANALOG_PERI_DIV_NUM0_V << LP_ANALOG_PERI_DIV_NUM0_S)
#define LP_ANALOG_PERI_DIV_NUM0_V  0x00000007U
#define LP_ANALOG_PERI_DIV_NUM0_S  22
/** LP_ANALOG_PERI_TOUCH_OUT_SEL : R/W; bitpos: [25]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_OUT_SEL    (BIT(25))
#define LP_ANALOG_PERI_TOUCH_OUT_SEL_M  (LP_ANALOG_PERI_TOUCH_OUT_SEL_V << LP_ANALOG_PERI_TOUCH_OUT_SEL_S)
#define LP_ANALOG_PERI_TOUCH_OUT_SEL_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_OUT_SEL_S  25
/** LP_ANALOG_PERI_TOUCH_OUT_RESET : WT; bitpos: [26]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_OUT_RESET    (BIT(26))
#define LP_ANALOG_PERI_TOUCH_OUT_RESET_M  (LP_ANALOG_PERI_TOUCH_OUT_RESET_V << LP_ANALOG_PERI_TOUCH_OUT_RESET_S)
#define LP_ANALOG_PERI_TOUCH_OUT_RESET_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_OUT_RESET_S  26
/** LP_ANALOG_PERI_TOUCH_OUT_GATE : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_OUT_GATE    (BIT(27))
#define LP_ANALOG_PERI_TOUCH_OUT_GATE_M  (LP_ANALOG_PERI_TOUCH_OUT_GATE_V << LP_ANALOG_PERI_TOUCH_OUT_GATE_S)
#define LP_ANALOG_PERI_TOUCH_OUT_GATE_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_OUT_GATE_S  27

/** LP_ANALOG_PERI_TOUCH_WORK_MEAS_NUM_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_WORK_MEAS_NUM_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x10c)
/** LP_ANALOG_PERI_TOUCH_MEAS_NUM2 : R/W; bitpos: [9:0]; default: 100;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM2    0x000003FFU
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM2_M  (LP_ANALOG_PERI_TOUCH_MEAS_NUM2_V << LP_ANALOG_PERI_TOUCH_MEAS_NUM2_S)
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM2_V  0x000003FFU
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM2_S  0
/** LP_ANALOG_PERI_TOUCH_MEAS_NUM1 : R/W; bitpos: [19:10]; default: 100;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM1    0x000003FFU
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM1_M  (LP_ANALOG_PERI_TOUCH_MEAS_NUM1_V << LP_ANALOG_PERI_TOUCH_MEAS_NUM1_S)
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM1_V  0x000003FFU
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM1_S  10
/** LP_ANALOG_PERI_TOUCH_MEAS_NUM0 : R/W; bitpos: [29:20]; default: 100;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM0    0x000003FFU
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM0_M  (LP_ANALOG_PERI_TOUCH_MEAS_NUM0_V << LP_ANALOG_PERI_TOUCH_MEAS_NUM0_S)
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM0_V  0x000003FFU
#define LP_ANALOG_PERI_TOUCH_MEAS_NUM0_S  20

/** LP_ANALOG_PERI_TOUCH_FILTER1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FILTER1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x110)
/** LP_ANALOG_PERI_TOUCH_NN_DISUPDATE_BENCHMARK_EN : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_NN_DISUPDATE_BENCHMARK_EN    (BIT(0))
#define LP_ANALOG_PERI_TOUCH_NN_DISUPDATE_BENCHMARK_EN_M  (LP_ANALOG_PERI_TOUCH_NN_DISUPDATE_BENCHMARK_EN_V << LP_ANALOG_PERI_TOUCH_NN_DISUPDATE_BENCHMARK_EN_S)
#define LP_ANALOG_PERI_TOUCH_NN_DISUPDATE_BENCHMARK_EN_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_NN_DISUPDATE_BENCHMARK_EN_S  0
/** LP_ANALOG_PERI_TOUCH_HYSTERESIS : R/W; bitpos: [2:1]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_HYSTERESIS    0x00000003U
#define LP_ANALOG_PERI_TOUCH_HYSTERESIS_M  (LP_ANALOG_PERI_TOUCH_HYSTERESIS_V << LP_ANALOG_PERI_TOUCH_HYSTERESIS_S)
#define LP_ANALOG_PERI_TOUCH_HYSTERESIS_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_HYSTERESIS_S  1
/** LP_ANALOG_PERI_TOUCH_NN_THRES : R/W; bitpos: [4:3]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_NN_THRES    0x00000003U
#define LP_ANALOG_PERI_TOUCH_NN_THRES_M  (LP_ANALOG_PERI_TOUCH_NN_THRES_V << LP_ANALOG_PERI_TOUCH_NN_THRES_S)
#define LP_ANALOG_PERI_TOUCH_NN_THRES_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_NN_THRES_S  3
/** LP_ANALOG_PERI_TOUCH_NOISE_THRES : R/W; bitpos: [6:5]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_NOISE_THRES    0x00000003U
#define LP_ANALOG_PERI_TOUCH_NOISE_THRES_M  (LP_ANALOG_PERI_TOUCH_NOISE_THRES_V << LP_ANALOG_PERI_TOUCH_NOISE_THRES_S)
#define LP_ANALOG_PERI_TOUCH_NOISE_THRES_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_NOISE_THRES_S  5
/** LP_ANALOG_PERI_TOUCH_SMOOTH_LVL : R/W; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SMOOTH_LVL    0x00000003U
#define LP_ANALOG_PERI_TOUCH_SMOOTH_LVL_M  (LP_ANALOG_PERI_TOUCH_SMOOTH_LVL_V << LP_ANALOG_PERI_TOUCH_SMOOTH_LVL_S)
#define LP_ANALOG_PERI_TOUCH_SMOOTH_LVL_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_SMOOTH_LVL_S  7
/** LP_ANALOG_PERI_TOUCH_JITTER_STEP : R/W; bitpos: [12:9]; default: 1;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_JITTER_STEP    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_JITTER_STEP_M  (LP_ANALOG_PERI_TOUCH_JITTER_STEP_V << LP_ANALOG_PERI_TOUCH_JITTER_STEP_S)
#define LP_ANALOG_PERI_TOUCH_JITTER_STEP_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_JITTER_STEP_S  9
/** LP_ANALOG_PERI_TOUCH_FILTER_MODE : R/W; bitpos: [15:13]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FILTER_MODE    0x00000007U
#define LP_ANALOG_PERI_TOUCH_FILTER_MODE_M  (LP_ANALOG_PERI_TOUCH_FILTER_MODE_V << LP_ANALOG_PERI_TOUCH_FILTER_MODE_S)
#define LP_ANALOG_PERI_TOUCH_FILTER_MODE_V  0x00000007U
#define LP_ANALOG_PERI_TOUCH_FILTER_MODE_S  13
/** LP_ANALOG_PERI_TOUCH_FILTER_EN : R/W; bitpos: [16]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FILTER_EN    (BIT(16))
#define LP_ANALOG_PERI_TOUCH_FILTER_EN_M  (LP_ANALOG_PERI_TOUCH_FILTER_EN_V << LP_ANALOG_PERI_TOUCH_FILTER_EN_S)
#define LP_ANALOG_PERI_TOUCH_FILTER_EN_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_FILTER_EN_S  16
/** LP_ANALOG_PERI_TOUCH_NN_LIMIT : R/W; bitpos: [20:17]; default: 5;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_NN_LIMIT    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_NN_LIMIT_M  (LP_ANALOG_PERI_TOUCH_NN_LIMIT_V << LP_ANALOG_PERI_TOUCH_NN_LIMIT_S)
#define LP_ANALOG_PERI_TOUCH_NN_LIMIT_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_NN_LIMIT_S  17
/** LP_ANALOG_PERI_TOUCH_APPROACH_LIMIT : R/W; bitpos: [28:21]; default: 80;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_LIMIT    0x000000FFU
#define LP_ANALOG_PERI_TOUCH_APPROACH_LIMIT_M  (LP_ANALOG_PERI_TOUCH_APPROACH_LIMIT_V << LP_ANALOG_PERI_TOUCH_APPROACH_LIMIT_S)
#define LP_ANALOG_PERI_TOUCH_APPROACH_LIMIT_V  0x000000FFU
#define LP_ANALOG_PERI_TOUCH_APPROACH_LIMIT_S  21
/** LP_ANALOG_PERI_TOUCH_DEBOUNCE_LIMIT : R/W; bitpos: [31:29]; default: 3;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_DEBOUNCE_LIMIT    0x00000007U
#define LP_ANALOG_PERI_TOUCH_DEBOUNCE_LIMIT_M  (LP_ANALOG_PERI_TOUCH_DEBOUNCE_LIMIT_V << LP_ANALOG_PERI_TOUCH_DEBOUNCE_LIMIT_S)
#define LP_ANALOG_PERI_TOUCH_DEBOUNCE_LIMIT_V  0x00000007U
#define LP_ANALOG_PERI_TOUCH_DEBOUNCE_LIMIT_S  29

/** LP_ANALOG_PERI_TOUCH_FILTER2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FILTER2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x114)
/** LP_ANALOG_PERI_TOUCH_OUTEN : R/W; bitpos: [29:15]; default: 16383;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_OUTEN    0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_OUTEN_M  (LP_ANALOG_PERI_TOUCH_OUTEN_V << LP_ANALOG_PERI_TOUCH_OUTEN_S)
#define LP_ANALOG_PERI_TOUCH_OUTEN_V  0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_OUTEN_S  15
/** LP_ANALOG_PERI_TOUCH_BYPASS_NOISE_THRES : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_BYPASS_NOISE_THRES    (BIT(30))
#define LP_ANALOG_PERI_TOUCH_BYPASS_NOISE_THRES_M  (LP_ANALOG_PERI_TOUCH_BYPASS_NOISE_THRES_V << LP_ANALOG_PERI_TOUCH_BYPASS_NOISE_THRES_S)
#define LP_ANALOG_PERI_TOUCH_BYPASS_NOISE_THRES_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_BYPASS_NOISE_THRES_S  30
/** LP_ANALOG_PERI_TOUCH_BYPASS_NN_THRES : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_BYPASS_NN_THRES    (BIT(31))
#define LP_ANALOG_PERI_TOUCH_BYPASS_NN_THRES_M  (LP_ANALOG_PERI_TOUCH_BYPASS_NN_THRES_V << LP_ANALOG_PERI_TOUCH_BYPASS_NN_THRES_S)
#define LP_ANALOG_PERI_TOUCH_BYPASS_NN_THRES_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_BYPASS_NN_THRES_S  31

/** LP_ANALOG_PERI_TOUCH_FILTER3_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FILTER3_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x118)
/** LP_ANALOG_PERI_TOUCH_BENCHMARK_SW : R/W; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_BENCHMARK_SW    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_BENCHMARK_SW_M  (LP_ANALOG_PERI_TOUCH_BENCHMARK_SW_V << LP_ANALOG_PERI_TOUCH_BENCHMARK_SW_S)
#define LP_ANALOG_PERI_TOUCH_BENCHMARK_SW_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_BENCHMARK_SW_S  0
/** LP_ANALOG_PERI_TOUCH_UPDATE_BENCHMARK_SW : WT; bitpos: [16]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_UPDATE_BENCHMARK_SW    (BIT(16))
#define LP_ANALOG_PERI_TOUCH_UPDATE_BENCHMARK_SW_M  (LP_ANALOG_PERI_TOUCH_UPDATE_BENCHMARK_SW_V << LP_ANALOG_PERI_TOUCH_UPDATE_BENCHMARK_SW_S)
#define LP_ANALOG_PERI_TOUCH_UPDATE_BENCHMARK_SW_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_UPDATE_BENCHMARK_SW_S  16

/** LP_ANALOG_PERI_TOUCH_SLP0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SLP0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x11c)
/** LP_ANALOG_PERI_TOUCH_SLP_TH0 : R/W; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SLP_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_SLP_TH0_M  (LP_ANALOG_PERI_TOUCH_SLP_TH0_V << LP_ANALOG_PERI_TOUCH_SLP_TH0_S)
#define LP_ANALOG_PERI_TOUCH_SLP_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_SLP_TH0_S  0
/** LP_ANALOG_PERI_TOUCH_SLP_CHANNEL_CLR : WT; bitpos: [16]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SLP_CHANNEL_CLR    (BIT(16))
#define LP_ANALOG_PERI_TOUCH_SLP_CHANNEL_CLR_M  (LP_ANALOG_PERI_TOUCH_SLP_CHANNEL_CLR_V << LP_ANALOG_PERI_TOUCH_SLP_CHANNEL_CLR_S)
#define LP_ANALOG_PERI_TOUCH_SLP_CHANNEL_CLR_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_SLP_CHANNEL_CLR_S  16
/** LP_ANALOG_PERI_TOUCH_SLP_PAD : R/W; bitpos: [20:17]; default: 15;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SLP_PAD    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_SLP_PAD_M  (LP_ANALOG_PERI_TOUCH_SLP_PAD_V << LP_ANALOG_PERI_TOUCH_SLP_PAD_S)
#define LP_ANALOG_PERI_TOUCH_SLP_PAD_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_SLP_PAD_S  17

/** LP_ANALOG_PERI_TOUCH_SLP1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SLP1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x120)
/** LP_ANALOG_PERI_TOUCH_SLP_TH2 : R/W; bitpos: [15:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SLP_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_SLP_TH2_M  (LP_ANALOG_PERI_TOUCH_SLP_TH2_V << LP_ANALOG_PERI_TOUCH_SLP_TH2_S)
#define LP_ANALOG_PERI_TOUCH_SLP_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_SLP_TH2_S  0
/** LP_ANALOG_PERI_TOUCH_SLP_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SLP_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_SLP_TH1_M  (LP_ANALOG_PERI_TOUCH_SLP_TH1_V << LP_ANALOG_PERI_TOUCH_SLP_TH1_S)
#define LP_ANALOG_PERI_TOUCH_SLP_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_SLP_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_CLR_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_CLR_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x124)
/** LP_ANALOG_PERI_TOUCH_CHANNEL_CLR : WT; bitpos: [14:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_CHANNEL_CLR    0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_CHANNEL_CLR_M  (LP_ANALOG_PERI_TOUCH_CHANNEL_CLR_V << LP_ANALOG_PERI_TOUCH_CHANNEL_CLR_S)
#define LP_ANALOG_PERI_TOUCH_CHANNEL_CLR_V  0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_CHANNEL_CLR_S  0
/** LP_ANALOG_PERI_TOUCH_STATUS_CLR : WT; bitpos: [15]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_STATUS_CLR    (BIT(15))
#define LP_ANALOG_PERI_TOUCH_STATUS_CLR_M  (LP_ANALOG_PERI_TOUCH_STATUS_CLR_V << LP_ANALOG_PERI_TOUCH_STATUS_CLR_S)
#define LP_ANALOG_PERI_TOUCH_STATUS_CLR_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_STATUS_CLR_S  15

/** LP_ANALOG_PERI_TOUCH_APPROACH_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x128)
/** LP_ANALOG_PERI_TOUCH_APPROACH_PAD0 : R/W; bitpos: [3:0]; default: 15;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD0    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD0_M  (LP_ANALOG_PERI_TOUCH_APPROACH_PAD0_V << LP_ANALOG_PERI_TOUCH_APPROACH_PAD0_S)
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD0_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD0_S  0
/** LP_ANALOG_PERI_TOUCH_APPROACH_PAD1 : R/W; bitpos: [7:4]; default: 15;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD1    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD1_M  (LP_ANALOG_PERI_TOUCH_APPROACH_PAD1_V << LP_ANALOG_PERI_TOUCH_APPROACH_PAD1_S)
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD1_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD1_S  4
/** LP_ANALOG_PERI_TOUCH_APPROACH_PAD2 : R/W; bitpos: [11:8]; default: 15;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD2    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD2_M  (LP_ANALOG_PERI_TOUCH_APPROACH_PAD2_V << LP_ANALOG_PERI_TOUCH_APPROACH_PAD2_S)
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD2_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_APPROACH_PAD2_S  8
/** LP_ANALOG_PERI_TOUCH_SLP_APPROACH_EN : R/W; bitpos: [12]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_SLP_APPROACH_EN    (BIT(12))
#define LP_ANALOG_PERI_TOUCH_SLP_APPROACH_EN_M  (LP_ANALOG_PERI_TOUCH_SLP_APPROACH_EN_V << LP_ANALOG_PERI_TOUCH_SLP_APPROACH_EN_S)
#define LP_ANALOG_PERI_TOUCH_SLP_APPROACH_EN_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_SLP_APPROACH_EN_S  12

/** LP_ANALOG_PERI_TOUCH_FREQ0_SCAN_PARA_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ0_SCAN_PARA_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x12c)
/** LP_ANALOG_PERI_TOUCH_FREQ0_DCAP_LPF : R/W; bitpos: [6:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ0_DCAP_LPF    0x0000007FU
#define LP_ANALOG_PERI_TOUCH_FREQ0_DCAP_LPF_M  (LP_ANALOG_PERI_TOUCH_FREQ0_DCAP_LPF_V << LP_ANALOG_PERI_TOUCH_FREQ0_DCAP_LPF_S)
#define LP_ANALOG_PERI_TOUCH_FREQ0_DCAP_LPF_V  0x0000007FU
#define LP_ANALOG_PERI_TOUCH_FREQ0_DCAP_LPF_S  0
/** LP_ANALOG_PERI_TOUCH_FREQ0_DRES_LPF : R/W; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRES_LPF    0x00000003U
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRES_LPF_M  (LP_ANALOG_PERI_TOUCH_FREQ0_DRES_LPF_V << LP_ANALOG_PERI_TOUCH_FREQ0_DRES_LPF_S)
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRES_LPF_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRES_LPF_S  7
/** LP_ANALOG_PERI_TOUCH_FREQ0_DRV_LS : R/W; bitpos: [12:9]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRV_LS    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRV_LS_M  (LP_ANALOG_PERI_TOUCH_FREQ0_DRV_LS_V << LP_ANALOG_PERI_TOUCH_FREQ0_DRV_LS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRV_LS_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRV_LS_S  9
/** LP_ANALOG_PERI_TOUCH_FREQ0_DRV_HS : R/W; bitpos: [17:13]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRV_HS    0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRV_HS_M  (LP_ANALOG_PERI_TOUCH_FREQ0_DRV_HS_V << LP_ANALOG_PERI_TOUCH_FREQ0_DRV_HS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRV_HS_V  0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ0_DRV_HS_S  13
/** LP_ANALOG_PERI_TOUCH_FREQ0_DBIAS : R/W; bitpos: [22:18]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ0_DBIAS    0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ0_DBIAS_M  (LP_ANALOG_PERI_TOUCH_FREQ0_DBIAS_V << LP_ANALOG_PERI_TOUCH_FREQ0_DBIAS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ0_DBIAS_V  0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ0_DBIAS_S  18

/** LP_ANALOG_PERI_TOUCH_FREQ1_SCAN_PARA_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ1_SCAN_PARA_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x130)
/** LP_ANALOG_PERI_TOUCH_FREQ1_DCAP_LPF : R/W; bitpos: [6:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ1_DCAP_LPF    0x0000007FU
#define LP_ANALOG_PERI_TOUCH_FREQ1_DCAP_LPF_M  (LP_ANALOG_PERI_TOUCH_FREQ1_DCAP_LPF_V << LP_ANALOG_PERI_TOUCH_FREQ1_DCAP_LPF_S)
#define LP_ANALOG_PERI_TOUCH_FREQ1_DCAP_LPF_V  0x0000007FU
#define LP_ANALOG_PERI_TOUCH_FREQ1_DCAP_LPF_S  0
/** LP_ANALOG_PERI_TOUCH_FREQ1_DRES_LPF : R/W; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRES_LPF    0x00000003U
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRES_LPF_M  (LP_ANALOG_PERI_TOUCH_FREQ1_DRES_LPF_V << LP_ANALOG_PERI_TOUCH_FREQ1_DRES_LPF_S)
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRES_LPF_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRES_LPF_S  7
/** LP_ANALOG_PERI_TOUCH_FREQ1_DRV_LS : R/W; bitpos: [12:9]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRV_LS    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRV_LS_M  (LP_ANALOG_PERI_TOUCH_FREQ1_DRV_LS_V << LP_ANALOG_PERI_TOUCH_FREQ1_DRV_LS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRV_LS_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRV_LS_S  9
/** LP_ANALOG_PERI_TOUCH_FREQ1_DRV_HS : R/W; bitpos: [17:13]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRV_HS    0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRV_HS_M  (LP_ANALOG_PERI_TOUCH_FREQ1_DRV_HS_V << LP_ANALOG_PERI_TOUCH_FREQ1_DRV_HS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRV_HS_V  0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ1_DRV_HS_S  13
/** LP_ANALOG_PERI_TOUCH_FREQ1_DBIAS : R/W; bitpos: [22:18]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ1_DBIAS    0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ1_DBIAS_M  (LP_ANALOG_PERI_TOUCH_FREQ1_DBIAS_V << LP_ANALOG_PERI_TOUCH_FREQ1_DBIAS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ1_DBIAS_V  0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ1_DBIAS_S  18

/** LP_ANALOG_PERI_TOUCH_FREQ2_SCAN_PARA_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ2_SCAN_PARA_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x134)
/** LP_ANALOG_PERI_TOUCH_FREQ2_DCAP_LPF : R/W; bitpos: [6:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ2_DCAP_LPF    0x0000007FU
#define LP_ANALOG_PERI_TOUCH_FREQ2_DCAP_LPF_M  (LP_ANALOG_PERI_TOUCH_FREQ2_DCAP_LPF_V << LP_ANALOG_PERI_TOUCH_FREQ2_DCAP_LPF_S)
#define LP_ANALOG_PERI_TOUCH_FREQ2_DCAP_LPF_V  0x0000007FU
#define LP_ANALOG_PERI_TOUCH_FREQ2_DCAP_LPF_S  0
/** LP_ANALOG_PERI_TOUCH_FREQ2_DRES_LPF : R/W; bitpos: [8:7]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRES_LPF    0x00000003U
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRES_LPF_M  (LP_ANALOG_PERI_TOUCH_FREQ2_DRES_LPF_V << LP_ANALOG_PERI_TOUCH_FREQ2_DRES_LPF_S)
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRES_LPF_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRES_LPF_S  7
/** LP_ANALOG_PERI_TOUCH_FREQ2_DRV_LS : R/W; bitpos: [12:9]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRV_LS    0x0000000FU
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRV_LS_M  (LP_ANALOG_PERI_TOUCH_FREQ2_DRV_LS_V << LP_ANALOG_PERI_TOUCH_FREQ2_DRV_LS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRV_LS_V  0x0000000FU
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRV_LS_S  9
/** LP_ANALOG_PERI_TOUCH_FREQ2_DRV_HS : R/W; bitpos: [17:13]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRV_HS    0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRV_HS_M  (LP_ANALOG_PERI_TOUCH_FREQ2_DRV_HS_V << LP_ANALOG_PERI_TOUCH_FREQ2_DRV_HS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRV_HS_V  0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ2_DRV_HS_S  13
/** LP_ANALOG_PERI_TOUCH_FREQ2_DBIAS : R/W; bitpos: [22:18]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ2_DBIAS    0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ2_DBIAS_M  (LP_ANALOG_PERI_TOUCH_FREQ2_DBIAS_V << LP_ANALOG_PERI_TOUCH_FREQ2_DBIAS_S)
#define LP_ANALOG_PERI_TOUCH_FREQ2_DBIAS_V  0x0000001FU
#define LP_ANALOG_PERI_TOUCH_FREQ2_DBIAS_S  18

/** LP_ANALOG_PERI_TOUCH_ANA_PARA_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_ANA_PARA_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x138)
/** LP_ANALOG_PERI_TOUCH_TOUCH_BUF_DRV : R/W; bitpos: [2:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_TOUCH_BUF_DRV    0x00000007U
#define LP_ANALOG_PERI_TOUCH_TOUCH_BUF_DRV_M  (LP_ANALOG_PERI_TOUCH_TOUCH_BUF_DRV_V << LP_ANALOG_PERI_TOUCH_TOUCH_BUF_DRV_S)
#define LP_ANALOG_PERI_TOUCH_TOUCH_BUF_DRV_V  0x00000007U
#define LP_ANALOG_PERI_TOUCH_TOUCH_BUF_DRV_S  0
/** LP_ANALOG_PERI_TOUCH_TOUCH_EN_CAL : R/W; bitpos: [3]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_TOUCH_EN_CAL    (BIT(3))
#define LP_ANALOG_PERI_TOUCH_TOUCH_EN_CAL_M  (LP_ANALOG_PERI_TOUCH_TOUCH_EN_CAL_V << LP_ANALOG_PERI_TOUCH_TOUCH_EN_CAL_S)
#define LP_ANALOG_PERI_TOUCH_TOUCH_EN_CAL_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_TOUCH_EN_CAL_S  3
/** LP_ANALOG_PERI_TOUCH_TOUCH_DCAP_CAL : R/W; bitpos: [10:4]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_TOUCH_DCAP_CAL    0x0000007FU
#define LP_ANALOG_PERI_TOUCH_TOUCH_DCAP_CAL_M  (LP_ANALOG_PERI_TOUCH_TOUCH_DCAP_CAL_V << LP_ANALOG_PERI_TOUCH_TOUCH_DCAP_CAL_S)
#define LP_ANALOG_PERI_TOUCH_TOUCH_DCAP_CAL_V  0x0000007FU
#define LP_ANALOG_PERI_TOUCH_TOUCH_DCAP_CAL_S  4

/** LP_ANALOG_PERI_TOUCH_MUX0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_MUX0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x13c)
/** LP_ANALOG_PERI_TOUCH_DATA_SEL : R/W; bitpos: [9:8]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_DATA_SEL    0x00000003U
#define LP_ANALOG_PERI_TOUCH_DATA_SEL_M  (LP_ANALOG_PERI_TOUCH_DATA_SEL_V << LP_ANALOG_PERI_TOUCH_DATA_SEL_S)
#define LP_ANALOG_PERI_TOUCH_DATA_SEL_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_DATA_SEL_S  8
/** LP_ANALOG_PERI_TOUCH_FREQ_SEL : R/W; bitpos: [11:10]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FREQ_SEL    0x00000003U
#define LP_ANALOG_PERI_TOUCH_FREQ_SEL_M  (LP_ANALOG_PERI_TOUCH_FREQ_SEL_V << LP_ANALOG_PERI_TOUCH_FREQ_SEL_S)
#define LP_ANALOG_PERI_TOUCH_FREQ_SEL_V  0x00000003U
#define LP_ANALOG_PERI_TOUCH_FREQ_SEL_S  10
/** LP_ANALOG_PERI_TOUCH_BUFSEL : R/W; bitpos: [26:12]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_BUFSEL    0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_BUFSEL_M  (LP_ANALOG_PERI_TOUCH_BUFSEL_V << LP_ANALOG_PERI_TOUCH_BUFSEL_S)
#define LP_ANALOG_PERI_TOUCH_BUFSEL_V  0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_BUFSEL_S  12
/** LP_ANALOG_PERI_TOUCH_DONE_EN : R/W; bitpos: [27]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_DONE_EN    (BIT(27))
#define LP_ANALOG_PERI_TOUCH_DONE_EN_M  (LP_ANALOG_PERI_TOUCH_DONE_EN_V << LP_ANALOG_PERI_TOUCH_DONE_EN_S)
#define LP_ANALOG_PERI_TOUCH_DONE_EN_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_DONE_EN_S  27
/** LP_ANALOG_PERI_TOUCH_DONE_FORCE : R/W; bitpos: [28]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_DONE_FORCE    (BIT(28))
#define LP_ANALOG_PERI_TOUCH_DONE_FORCE_M  (LP_ANALOG_PERI_TOUCH_DONE_FORCE_V << LP_ANALOG_PERI_TOUCH_DONE_FORCE_S)
#define LP_ANALOG_PERI_TOUCH_DONE_FORCE_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_DONE_FORCE_S  28
/** LP_ANALOG_PERI_TOUCH_FSM_EN : R/W; bitpos: [29]; default: 1;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_FSM_EN    (BIT(29))
#define LP_ANALOG_PERI_TOUCH_FSM_EN_M  (LP_ANALOG_PERI_TOUCH_FSM_EN_V << LP_ANALOG_PERI_TOUCH_FSM_EN_S)
#define LP_ANALOG_PERI_TOUCH_FSM_EN_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_FSM_EN_S  29
/** LP_ANALOG_PERI_TOUCH_START_EN : R/W; bitpos: [30]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_START_EN    (BIT(30))
#define LP_ANALOG_PERI_TOUCH_START_EN_M  (LP_ANALOG_PERI_TOUCH_START_EN_V << LP_ANALOG_PERI_TOUCH_START_EN_S)
#define LP_ANALOG_PERI_TOUCH_START_EN_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_START_EN_S  30
/** LP_ANALOG_PERI_TOUCH_START_FORCE : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_START_FORCE    (BIT(31))
#define LP_ANALOG_PERI_TOUCH_START_FORCE_M  (LP_ANALOG_PERI_TOUCH_START_FORCE_V << LP_ANALOG_PERI_TOUCH_START_FORCE_S)
#define LP_ANALOG_PERI_TOUCH_START_FORCE_V  0x00000001U
#define LP_ANALOG_PERI_TOUCH_START_FORCE_S  31

/** LP_ANALOG_PERI_TOUCH_MUX1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_MUX1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x140)
/** LP_ANALOG_PERI_TOUCH_START : R/W; bitpos: [14:0]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_START    0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_START_M  (LP_ANALOG_PERI_TOUCH_START_V << LP_ANALOG_PERI_TOUCH_START_S)
#define LP_ANALOG_PERI_TOUCH_START_V  0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_START_S  0
/** LP_ANALOG_PERI_TOUCH_XPD : R/W; bitpos: [29:15]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_XPD    0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_XPD_M  (LP_ANALOG_PERI_TOUCH_XPD_V << LP_ANALOG_PERI_TOUCH_XPD_S)
#define LP_ANALOG_PERI_TOUCH_XPD_V  0x00007FFFU
#define LP_ANALOG_PERI_TOUCH_XPD_S  15

/** LP_ANALOG_PERI_TOUCH_PAD0_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD0_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x144)
/** LP_ANALOG_PERI_TOUCH_PAD0_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD0_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD0_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD0_TH0_V << LP_ANALOG_PERI_TOUCH_PAD0_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD0_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD0_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD0_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD0_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x148)
/** LP_ANALOG_PERI_TOUCH_PAD0_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD0_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD0_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD0_TH1_V << LP_ANALOG_PERI_TOUCH_PAD0_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD0_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD0_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD0_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD0_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x14c)
/** LP_ANALOG_PERI_TOUCH_PAD0_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD0_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD0_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD0_TH2_V << LP_ANALOG_PERI_TOUCH_PAD0_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD0_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD0_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD1_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD1_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x150)
/** LP_ANALOG_PERI_TOUCH_PAD1_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD1_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD1_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD1_TH0_V << LP_ANALOG_PERI_TOUCH_PAD1_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD1_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD1_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD1_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD1_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x154)
/** LP_ANALOG_PERI_TOUCH_PAD1_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD1_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD1_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD1_TH1_V << LP_ANALOG_PERI_TOUCH_PAD1_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD1_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD1_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD1_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD1_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x158)
/** LP_ANALOG_PERI_TOUCH_PAD1_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD1_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD1_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD1_TH2_V << LP_ANALOG_PERI_TOUCH_PAD1_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD1_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD1_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD2_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD2_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x15c)
/** LP_ANALOG_PERI_TOUCH_PAD2_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD2_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD2_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD2_TH0_V << LP_ANALOG_PERI_TOUCH_PAD2_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD2_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD2_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD2_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD2_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x160)
/** LP_ANALOG_PERI_TOUCH_PAD2_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD2_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD2_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD2_TH1_V << LP_ANALOG_PERI_TOUCH_PAD2_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD2_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD2_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD2_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD2_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x164)
/** LP_ANALOG_PERI_TOUCH_PAD2_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD2_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD2_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD2_TH2_V << LP_ANALOG_PERI_TOUCH_PAD2_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD2_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD2_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD3_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD3_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x168)
/** LP_ANALOG_PERI_TOUCH_PAD3_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD3_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD3_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD3_TH0_V << LP_ANALOG_PERI_TOUCH_PAD3_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD3_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD3_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD3_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD3_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x16c)
/** LP_ANALOG_PERI_TOUCH_PAD3_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD3_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD3_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD3_TH1_V << LP_ANALOG_PERI_TOUCH_PAD3_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD3_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD3_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD3_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD3_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x170)
/** LP_ANALOG_PERI_TOUCH_PAD3_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD3_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD3_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD3_TH2_V << LP_ANALOG_PERI_TOUCH_PAD3_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD3_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD3_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD4_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD4_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x174)
/** LP_ANALOG_PERI_TOUCH_PAD4_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD4_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD4_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD4_TH0_V << LP_ANALOG_PERI_TOUCH_PAD4_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD4_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD4_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD4_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD4_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x178)
/** LP_ANALOG_PERI_TOUCH_PAD4_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD4_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD4_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD4_TH1_V << LP_ANALOG_PERI_TOUCH_PAD4_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD4_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD4_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD4_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD4_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x17c)
/** LP_ANALOG_PERI_TOUCH_PAD4_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD4_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD4_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD4_TH2_V << LP_ANALOG_PERI_TOUCH_PAD4_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD4_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD4_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD5_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD5_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x180)
/** LP_ANALOG_PERI_TOUCH_PAD5_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD5_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD5_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD5_TH0_V << LP_ANALOG_PERI_TOUCH_PAD5_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD5_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD5_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD5_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD5_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x184)
/** LP_ANALOG_PERI_TOUCH_PAD5_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD5_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD5_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD5_TH1_V << LP_ANALOG_PERI_TOUCH_PAD5_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD5_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD5_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD5_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD5_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x188)
/** LP_ANALOG_PERI_TOUCH_PAD5_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD5_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD5_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD5_TH2_V << LP_ANALOG_PERI_TOUCH_PAD5_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD5_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD5_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD6_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD6_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x18c)
/** LP_ANALOG_PERI_TOUCH_PAD6_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD6_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD6_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD6_TH0_V << LP_ANALOG_PERI_TOUCH_PAD6_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD6_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD6_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD6_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD6_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x190)
/** LP_ANALOG_PERI_TOUCH_PAD6_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD6_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD6_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD6_TH1_V << LP_ANALOG_PERI_TOUCH_PAD6_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD6_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD6_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD6_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD6_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x194)
/** LP_ANALOG_PERI_TOUCH_PAD6_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD6_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD6_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD6_TH2_V << LP_ANALOG_PERI_TOUCH_PAD6_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD6_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD6_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD7_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD7_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x198)
/** LP_ANALOG_PERI_TOUCH_PAD7_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD7_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD7_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD7_TH0_V << LP_ANALOG_PERI_TOUCH_PAD7_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD7_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD7_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD7_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD7_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x19c)
/** LP_ANALOG_PERI_TOUCH_PAD7_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD7_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD7_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD7_TH1_V << LP_ANALOG_PERI_TOUCH_PAD7_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD7_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD7_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD7_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD7_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1a0)
/** LP_ANALOG_PERI_TOUCH_PAD7_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD7_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD7_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD7_TH2_V << LP_ANALOG_PERI_TOUCH_PAD7_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD7_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD7_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD8_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD8_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1a4)
/** LP_ANALOG_PERI_TOUCH_PAD8_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD8_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD8_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD8_TH0_V << LP_ANALOG_PERI_TOUCH_PAD8_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD8_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD8_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD8_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD8_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1a8)
/** LP_ANALOG_PERI_TOUCH_PAD8_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD8_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD8_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD8_TH1_V << LP_ANALOG_PERI_TOUCH_PAD8_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD8_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD8_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD8_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD8_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1ac)
/** LP_ANALOG_PERI_TOUCH_PAD8_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD8_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD8_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD8_TH2_V << LP_ANALOG_PERI_TOUCH_PAD8_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD8_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD8_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD9_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD9_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1b0)
/** LP_ANALOG_PERI_TOUCH_PAD9_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD9_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD9_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD9_TH0_V << LP_ANALOG_PERI_TOUCH_PAD9_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD9_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD9_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD9_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD9_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1b4)
/** LP_ANALOG_PERI_TOUCH_PAD9_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD9_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD9_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD9_TH1_V << LP_ANALOG_PERI_TOUCH_PAD9_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD9_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD9_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD9_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD9_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1b8)
/** LP_ANALOG_PERI_TOUCH_PAD9_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD9_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD9_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD9_TH2_V << LP_ANALOG_PERI_TOUCH_PAD9_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD9_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD9_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD10_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD10_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1bc)
/** LP_ANALOG_PERI_TOUCH_PAD10_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD10_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD10_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD10_TH0_V << LP_ANALOG_PERI_TOUCH_PAD10_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD10_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD10_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD10_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD10_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1c0)
/** LP_ANALOG_PERI_TOUCH_PAD10_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD10_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD10_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD10_TH1_V << LP_ANALOG_PERI_TOUCH_PAD10_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD10_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD10_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD10_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD10_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1c4)
/** LP_ANALOG_PERI_TOUCH_PAD10_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD10_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD10_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD10_TH2_V << LP_ANALOG_PERI_TOUCH_PAD10_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD10_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD10_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD11_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD11_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1c8)
/** LP_ANALOG_PERI_TOUCH_PAD11_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD11_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD11_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD11_TH0_V << LP_ANALOG_PERI_TOUCH_PAD11_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD11_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD11_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD11_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD11_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1cc)
/** LP_ANALOG_PERI_TOUCH_PAD11_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD11_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD11_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD11_TH1_V << LP_ANALOG_PERI_TOUCH_PAD11_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD11_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD11_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD11_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD11_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1d0)
/** LP_ANALOG_PERI_TOUCH_PAD11_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD11_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD11_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD11_TH2_V << LP_ANALOG_PERI_TOUCH_PAD11_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD11_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD11_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD12_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD12_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1d4)
/** LP_ANALOG_PERI_TOUCH_PAD12_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD12_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD12_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD12_TH0_V << LP_ANALOG_PERI_TOUCH_PAD12_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD12_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD12_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD12_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD12_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1d8)
/** LP_ANALOG_PERI_TOUCH_PAD12_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD12_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD12_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD12_TH1_V << LP_ANALOG_PERI_TOUCH_PAD12_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD12_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD12_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD12_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD12_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1dc)
/** LP_ANALOG_PERI_TOUCH_PAD12_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD12_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD12_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD12_TH2_V << LP_ANALOG_PERI_TOUCH_PAD12_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD12_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD12_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD13_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD13_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1e0)
/** LP_ANALOG_PERI_TOUCH_PAD13_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD13_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD13_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD13_TH0_V << LP_ANALOG_PERI_TOUCH_PAD13_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD13_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD13_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD13_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD13_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1e4)
/** LP_ANALOG_PERI_TOUCH_PAD13_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD13_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD13_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD13_TH1_V << LP_ANALOG_PERI_TOUCH_PAD13_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD13_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD13_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD13_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD13_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1e8)
/** LP_ANALOG_PERI_TOUCH_PAD13_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD13_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD13_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD13_TH2_V << LP_ANALOG_PERI_TOUCH_PAD13_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD13_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD13_TH2_S  16

/** LP_ANALOG_PERI_TOUCH_PAD14_TH0_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD14_TH0_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1ec)
/** LP_ANALOG_PERI_TOUCH_PAD14_TH0 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD14_TH0    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD14_TH0_M  (LP_ANALOG_PERI_TOUCH_PAD14_TH0_V << LP_ANALOG_PERI_TOUCH_PAD14_TH0_S)
#define LP_ANALOG_PERI_TOUCH_PAD14_TH0_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD14_TH0_S  16

/** LP_ANALOG_PERI_TOUCH_PAD14_TH1_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD14_TH1_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1f0)
/** LP_ANALOG_PERI_TOUCH_PAD14_TH1 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD14_TH1    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD14_TH1_M  (LP_ANALOG_PERI_TOUCH_PAD14_TH1_V << LP_ANALOG_PERI_TOUCH_PAD14_TH1_S)
#define LP_ANALOG_PERI_TOUCH_PAD14_TH1_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD14_TH1_S  16

/** LP_ANALOG_PERI_TOUCH_PAD14_TH2_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_TOUCH_PAD14_TH2_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x1f4)
/** LP_ANALOG_PERI_TOUCH_PAD14_TH2 : R/W; bitpos: [31:16]; default: 0;
 *  Reserved
 */
#define LP_ANALOG_PERI_TOUCH_PAD14_TH2    0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD14_TH2_M  (LP_ANALOG_PERI_TOUCH_PAD14_TH2_V << LP_ANALOG_PERI_TOUCH_PAD14_TH2_S)
#define LP_ANALOG_PERI_TOUCH_PAD14_TH2_V  0x0000FFFFU
#define LP_ANALOG_PERI_TOUCH_PAD14_TH2_S  16

/** LP_ANALOG_PERI_DATE_REG register
 *  need_des
 */
#define LP_ANALOG_PERI_DATE_REG (DR_REG_LP_ANALOG_PERI_BASE + 0x3fc)
/** LP_ANALOG_PERI_LP_ANALOG_PERI_DATE : R/W; bitpos: [30:0]; default: 2294816;
 *  need_des
 */
#define LP_ANALOG_PERI_LP_ANALOG_PERI_DATE    0x7FFFFFFFU
#define LP_ANALOG_PERI_LP_ANALOG_PERI_DATE_M  (LP_ANALOG_PERI_LP_ANALOG_PERI_DATE_V << LP_ANALOG_PERI_LP_ANALOG_PERI_DATE_S)
#define LP_ANALOG_PERI_LP_ANALOG_PERI_DATE_V  0x7FFFFFFFU
#define LP_ANALOG_PERI_LP_ANALOG_PERI_DATE_S  0
/** LP_ANALOG_PERI_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  need_des
 */
#define LP_ANALOG_PERI_CLK_EN    (BIT(31))
#define LP_ANALOG_PERI_CLK_EN_M  (LP_ANALOG_PERI_CLK_EN_V << LP_ANALOG_PERI_CLK_EN_S)
#define LP_ANALOG_PERI_CLK_EN_V  0x00000001U
#define LP_ANALOG_PERI_CLK_EN_S  31

#ifdef __cplusplus
}
#endif
