/**
 * SPDX-FileCopyrightText: 2023-2024 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** ICM_VERID_FILEDS_REG register
 *  NA
 */
#define ICM_VERID_FILEDS_REG (DR_REG_AXI_ICM_QOS_BASE + 0x0)
/** ICM_REG_VERID : RO; bitpos: [31:0]; default: 875574314;
 *  NA
 */
#define ICM_REG_VERID    0xFFFFFFFFU
#define ICM_REG_VERID_M  (ICM_REG_VERID_V << ICM_REG_VERID_S)
#define ICM_REG_VERID_V  0xFFFFFFFFU
#define ICM_REG_VERID_S  0

/** ICM_HW_CFG_REG_REG register
 *  NA
 */
#define ICM_HW_CFG_REG_REG (DR_REG_AXI_ICM_QOS_BASE + 0x4)
/** ICM_REG_AXI_HWCFG_QOS_SUPPORT : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_QOS_SUPPORT    (BIT(0))
#define ICM_REG_AXI_HWCFG_QOS_SUPPORT_M  (ICM_REG_AXI_HWCFG_QOS_SUPPORT_V << ICM_REG_AXI_HWCFG_QOS_SUPPORT_S)
#define ICM_REG_AXI_HWCFG_QOS_SUPPORT_V  0x00000001U
#define ICM_REG_AXI_HWCFG_QOS_SUPPORT_S  0
/** ICM_REG_AXI_HWCFG_APB3_SUPPORT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_APB3_SUPPORT    (BIT(1))
#define ICM_REG_AXI_HWCFG_APB3_SUPPORT_M  (ICM_REG_AXI_HWCFG_APB3_SUPPORT_V << ICM_REG_AXI_HWCFG_APB3_SUPPORT_S)
#define ICM_REG_AXI_HWCFG_APB3_SUPPORT_V  0x00000001U
#define ICM_REG_AXI_HWCFG_APB3_SUPPORT_S  1
/** ICM_REG_AXI_HWCFG_AXI4_SUPPORT : RO; bitpos: [2]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_AXI4_SUPPORT    (BIT(2))
#define ICM_REG_AXI_HWCFG_AXI4_SUPPORT_M  (ICM_REG_AXI_HWCFG_AXI4_SUPPORT_V << ICM_REG_AXI_HWCFG_AXI4_SUPPORT_S)
#define ICM_REG_AXI_HWCFG_AXI4_SUPPORT_V  0x00000001U
#define ICM_REG_AXI_HWCFG_AXI4_SUPPORT_S  2
/** ICM_REG_AXI_HWCFG_LOCK_EN : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_LOCK_EN    (BIT(3))
#define ICM_REG_AXI_HWCFG_LOCK_EN_M  (ICM_REG_AXI_HWCFG_LOCK_EN_V << ICM_REG_AXI_HWCFG_LOCK_EN_S)
#define ICM_REG_AXI_HWCFG_LOCK_EN_V  0x00000001U
#define ICM_REG_AXI_HWCFG_LOCK_EN_S  3
/** ICM_REG_AXI_HWCFG_TRUST_ZONE_EN : RO; bitpos: [4]; default: 1;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_TRUST_ZONE_EN    (BIT(4))
#define ICM_REG_AXI_HWCFG_TRUST_ZONE_EN_M  (ICM_REG_AXI_HWCFG_TRUST_ZONE_EN_V << ICM_REG_AXI_HWCFG_TRUST_ZONE_EN_S)
#define ICM_REG_AXI_HWCFG_TRUST_ZONE_EN_V  0x00000001U
#define ICM_REG_AXI_HWCFG_TRUST_ZONE_EN_S  4
/** ICM_REG_AXI_HWCFG_DECODER_TYPE : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_DECODER_TYPE    (BIT(5))
#define ICM_REG_AXI_HWCFG_DECODER_TYPE_M  (ICM_REG_AXI_HWCFG_DECODER_TYPE_V << ICM_REG_AXI_HWCFG_DECODER_TYPE_S)
#define ICM_REG_AXI_HWCFG_DECODER_TYPE_V  0x00000001U
#define ICM_REG_AXI_HWCFG_DECODER_TYPE_S  5
/** ICM_REG_AXI_HWCFG_REMAP_EN : RO; bitpos: [6]; default: 1;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_REMAP_EN    (BIT(6))
#define ICM_REG_AXI_HWCFG_REMAP_EN_M  (ICM_REG_AXI_HWCFG_REMAP_EN_V << ICM_REG_AXI_HWCFG_REMAP_EN_S)
#define ICM_REG_AXI_HWCFG_REMAP_EN_V  0x00000001U
#define ICM_REG_AXI_HWCFG_REMAP_EN_S  6
/** ICM_REG_AXI_HWCFG_BI_DIR_CMD_EN : RO; bitpos: [7]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_BI_DIR_CMD_EN    (BIT(7))
#define ICM_REG_AXI_HWCFG_BI_DIR_CMD_EN_M  (ICM_REG_AXI_HWCFG_BI_DIR_CMD_EN_V << ICM_REG_AXI_HWCFG_BI_DIR_CMD_EN_S)
#define ICM_REG_AXI_HWCFG_BI_DIR_CMD_EN_V  0x00000001U
#define ICM_REG_AXI_HWCFG_BI_DIR_CMD_EN_S  7
/** ICM_REG_AXI_HWCFG_LOW_POWER_INF_EN : RO; bitpos: [8]; default: 1;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_LOW_POWER_INF_EN    (BIT(8))
#define ICM_REG_AXI_HWCFG_LOW_POWER_INF_EN_M  (ICM_REG_AXI_HWCFG_LOW_POWER_INF_EN_V << ICM_REG_AXI_HWCFG_LOW_POWER_INF_EN_S)
#define ICM_REG_AXI_HWCFG_LOW_POWER_INF_EN_V  0x00000001U
#define ICM_REG_AXI_HWCFG_LOW_POWER_INF_EN_S  8
/** ICM_REG_AXI_HWCFG_AXI_NUM_MASTERS : RO; bitpos: [16:12]; default: 13;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_AXI_NUM_MASTERS    0x0000001FU
#define ICM_REG_AXI_HWCFG_AXI_NUM_MASTERS_M  (ICM_REG_AXI_HWCFG_AXI_NUM_MASTERS_V << ICM_REG_AXI_HWCFG_AXI_NUM_MASTERS_S)
#define ICM_REG_AXI_HWCFG_AXI_NUM_MASTERS_V  0x0000001FU
#define ICM_REG_AXI_HWCFG_AXI_NUM_MASTERS_S  12
/** ICM_REG_AXI_HWCFG_AXI_NUM_SLAVES : RO; bitpos: [24:20]; default: 7;
 *  NA
 */
#define ICM_REG_AXI_HWCFG_AXI_NUM_SLAVES    0x0000001FU
#define ICM_REG_AXI_HWCFG_AXI_NUM_SLAVES_M  (ICM_REG_AXI_HWCFG_AXI_NUM_SLAVES_V << ICM_REG_AXI_HWCFG_AXI_NUM_SLAVES_S)
#define ICM_REG_AXI_HWCFG_AXI_NUM_SLAVES_V  0x0000001FU
#define ICM_REG_AXI_HWCFG_AXI_NUM_SLAVES_S  20

/** ICM_CMD_REG register
 *  NA
 */
#define ICM_CMD_REG (DR_REG_AXI_ICM_QOS_BASE + 0x8)
/** ICM_REG_AXI_CMD : R/W; bitpos: [2:0]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_CMD    0x00000007U
#define ICM_REG_AXI_CMD_M  (ICM_REG_AXI_CMD_V << ICM_REG_AXI_CMD_S)
#define ICM_REG_AXI_CMD_V  0x00000007U
#define ICM_REG_AXI_CMD_S  0
/** ICM_REG_RD_WR_CHAN : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define ICM_REG_RD_WR_CHAN    (BIT(7))
#define ICM_REG_RD_WR_CHAN_M  (ICM_REG_RD_WR_CHAN_V << ICM_REG_RD_WR_CHAN_S)
#define ICM_REG_RD_WR_CHAN_V  0x00000001U
#define ICM_REG_RD_WR_CHAN_S  7
/** ICM_REG_AXI_MASTER_PORT : R/W; bitpos: [11:8]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_MASTER_PORT    0x0000000FU
#define ICM_REG_AXI_MASTER_PORT_M  (ICM_REG_AXI_MASTER_PORT_V << ICM_REG_AXI_MASTER_PORT_S)
#define ICM_REG_AXI_MASTER_PORT_V  0x0000000FU
#define ICM_REG_AXI_MASTER_PORT_S  8
/** ICM_REG_AXI_ERR_BIT : RO; bitpos: [28]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_ERR_BIT    (BIT(28))
#define ICM_REG_AXI_ERR_BIT_M  (ICM_REG_AXI_ERR_BIT_V << ICM_REG_AXI_ERR_BIT_S)
#define ICM_REG_AXI_ERR_BIT_V  0x00000001U
#define ICM_REG_AXI_ERR_BIT_S  28
/** ICM_REG_AXI_SOFT_RESET_BIT : R/W; bitpos: [29]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_SOFT_RESET_BIT    (BIT(29))
#define ICM_REG_AXI_SOFT_RESET_BIT_M  (ICM_REG_AXI_SOFT_RESET_BIT_V << ICM_REG_AXI_SOFT_RESET_BIT_S)
#define ICM_REG_AXI_SOFT_RESET_BIT_V  0x00000001U
#define ICM_REG_AXI_SOFT_RESET_BIT_S  29
/** ICM_REG_AXI_RD_WR_CMD : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_RD_WR_CMD    (BIT(30))
#define ICM_REG_AXI_RD_WR_CMD_M  (ICM_REG_AXI_RD_WR_CMD_V << ICM_REG_AXI_RD_WR_CMD_S)
#define ICM_REG_AXI_RD_WR_CMD_V  0x00000001U
#define ICM_REG_AXI_RD_WR_CMD_S  30
/** ICM_REG_AXI_CMD_EN : R/W; bitpos: [31]; default: 0;
 *  NA
 */
#define ICM_REG_AXI_CMD_EN    (BIT(31))
#define ICM_REG_AXI_CMD_EN_M  (ICM_REG_AXI_CMD_EN_V << ICM_REG_AXI_CMD_EN_S)
#define ICM_REG_AXI_CMD_EN_V  0x00000001U
#define ICM_REG_AXI_CMD_EN_S  31

/** ICM_DATA_REG register
 *  NA
 */
#define ICM_DATA_REG (DR_REG_AXI_ICM_QOS_BASE + 0xc)
/** ICM_REG_DATA : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define ICM_REG_DATA    0xFFFFFFFFU
#define ICM_REG_DATA_M  (ICM_REG_DATA_V << ICM_REG_DATA_S)
#define ICM_REG_DATA_V  0xFFFFFFFFU
#define ICM_REG_DATA_S  0

#ifdef __cplusplus
}
#endif
