/**
 * SPDX-FileCopyrightText: 2023-2024 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** HP_SYS_CLKRST_CLK_EN0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_CLK_EN0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x0)
/** HP_SYS_CLKRST_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CLK_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_CLK_EN_M  (HP_SYS_CLKRST_REG_CLK_EN_V << HP_SYS_CLKRST_REG_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CLK_EN_S  0

/** HP_SYS_CLKRST_ROOT_CLK_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_ROOT_CLK_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x4)
/** HP_SYS_CLKRST_REG_CPUICM_DELAY_NUM : R/W; bitpos: [3:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CPUICM_DELAY_NUM    0x0000000FU
#define HP_SYS_CLKRST_REG_CPUICM_DELAY_NUM_M  (HP_SYS_CLKRST_REG_CPUICM_DELAY_NUM_V << HP_SYS_CLKRST_REG_CPUICM_DELAY_NUM_S)
#define HP_SYS_CLKRST_REG_CPUICM_DELAY_NUM_V  0x0000000FU
#define HP_SYS_CLKRST_REG_CPUICM_DELAY_NUM_S  0
/** HP_SYS_CLKRST_REG_SOC_CLK_DIV_UPDATE : WT; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SOC_CLK_DIV_UPDATE    (BIT(4))
#define HP_SYS_CLKRST_REG_SOC_CLK_DIV_UPDATE_M  (HP_SYS_CLKRST_REG_SOC_CLK_DIV_UPDATE_V << HP_SYS_CLKRST_REG_SOC_CLK_DIV_UPDATE_S)
#define HP_SYS_CLKRST_REG_SOC_CLK_DIV_UPDATE_V  0x00000001U
#define HP_SYS_CLKRST_REG_SOC_CLK_DIV_UPDATE_S  4
/** HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUM : R/W; bitpos: [12:5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUM_S  5
/** HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUMERATOR : R/W; bitpos: [20:13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_NUMERATOR_S  13
/** HP_SYS_CLKRST_REG_CPU_CLK_DIV_DENOMINATOR : R/W; bitpos: [28:21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_CPU_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_CPU_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_CLK_DIV_DENOMINATOR_S  21

/** HP_SYS_CLKRST_ROOT_CLK_CTRL1_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_ROOT_CLK_CTRL1_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x8)
/** HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_MEM_CLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_MEM_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_MEM_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_MEM_CLK_DIV_DENOMINATOR_S  16
/** HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUM : R/W; bitpos: [31:24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUM_S  24

/** HP_SYS_CLKRST_ROOT_CLK_CTRL2_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_ROOT_CLK_CTRL2_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xc)
/** HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUMERATOR : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_NUMERATOR_S  0
/** HP_SYS_CLKRST_REG_SYS_CLK_DIV_DENOMINATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_SYS_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_SYS_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_SYS_CLK_DIV_DENOMINATOR_S  8
/** HP_SYS_CLKRST_REG_APB_CLK_DIV_NUM : R/W; bitpos: [23:16]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_APB_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_APB_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_NUM_S  16
/** HP_SYS_CLKRST_REG_APB_CLK_DIV_NUMERATOR : R/W; bitpos: [31:24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_APB_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_APB_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_NUMERATOR_S  24

/** HP_SYS_CLKRST_ROOT_CLK_CTRL3_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_ROOT_CLK_CTRL3_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x10)
/** HP_SYS_CLKRST_REG_APB_CLK_DIV_DENOMINATOR : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_APB_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_APB_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_APB_CLK_DIV_DENOMINATOR_S  0

/** HP_SYS_CLKRST_SOC_CLK_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_SOC_CLK_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x14)
/** HP_SYS_CLKRST_REG_CORE0_CLIC_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CORE0_CLIC_CLK_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_CORE0_CLIC_CLK_EN_M  (HP_SYS_CLKRST_REG_CORE0_CLIC_CLK_EN_V << HP_SYS_CLKRST_REG_CORE0_CLIC_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CORE0_CLIC_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CORE0_CLIC_CLK_EN_S  0
/** HP_SYS_CLKRST_REG_CORE1_CLIC_CLK_EN : R/W; bitpos: [1]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CORE1_CLIC_CLK_EN    (BIT(1))
#define HP_SYS_CLKRST_REG_CORE1_CLIC_CLK_EN_M  (HP_SYS_CLKRST_REG_CORE1_CLIC_CLK_EN_V << HP_SYS_CLKRST_REG_CORE1_CLIC_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CORE1_CLIC_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CORE1_CLIC_CLK_EN_S  1
/** HP_SYS_CLKRST_REG_MISC_CPU_CLK_EN : R/W; bitpos: [2]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MISC_CPU_CLK_EN    (BIT(2))
#define HP_SYS_CLKRST_REG_MISC_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_MISC_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_MISC_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_MISC_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MISC_CPU_CLK_EN_S  2
/** HP_SYS_CLKRST_REG_CORE0_CPU_CLK_EN : R/W; bitpos: [3]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CORE0_CPU_CLK_EN    (BIT(3))
#define HP_SYS_CLKRST_REG_CORE0_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_CORE0_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_CORE0_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CORE0_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CORE0_CPU_CLK_EN_S  3
/** HP_SYS_CLKRST_REG_CORE1_CPU_CLK_EN : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CORE1_CPU_CLK_EN    (BIT(4))
#define HP_SYS_CLKRST_REG_CORE1_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_CORE1_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_CORE1_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CORE1_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CORE1_CPU_CLK_EN_S  4
/** HP_SYS_CLKRST_REG_TCM_CPU_CLK_EN : R/W; bitpos: [5]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TCM_CPU_CLK_EN    (BIT(5))
#define HP_SYS_CLKRST_REG_TCM_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_TCM_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_TCM_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TCM_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TCM_CPU_CLK_EN_S  5
/** HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_EN : R/W; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_EN    (BIT(6))
#define HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_EN_S  6
/** HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_EN : R/W; bitpos: [7]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_EN    (BIT(7))
#define HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_EN_S  7
/** HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_EN : R/W; bitpos: [8]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_EN    (BIT(8))
#define HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_EN_S  8
/** HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_EN : R/W; bitpos: [9]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_EN    (BIT(9))
#define HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_EN_S  9
/** HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_EN : R/W; bitpos: [10]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_EN    (BIT(10))
#define HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_EN_S  10
/** HP_SYS_CLKRST_REG_TRACE_CPU_CLK_EN : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TRACE_CPU_CLK_EN    (BIT(11))
#define HP_SYS_CLKRST_REG_TRACE_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_TRACE_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_TRACE_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TRACE_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TRACE_CPU_CLK_EN_S  11
/** HP_SYS_CLKRST_REG_ICM_CPU_CLK_EN : R/W; bitpos: [12]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ICM_CPU_CLK_EN    (BIT(12))
#define HP_SYS_CLKRST_REG_ICM_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_ICM_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_ICM_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ICM_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ICM_CPU_CLK_EN_S  12
/** HP_SYS_CLKRST_REG_GDMA_CPU_CLK_EN : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GDMA_CPU_CLK_EN    (BIT(13))
#define HP_SYS_CLKRST_REG_GDMA_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_GDMA_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_GDMA_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GDMA_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GDMA_CPU_CLK_EN_S  13
/** HP_SYS_CLKRST_REG_VPU_CPU_CLK_EN : R/W; bitpos: [14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_VPU_CPU_CLK_EN    (BIT(14))
#define HP_SYS_CLKRST_REG_VPU_CPU_CLK_EN_M  (HP_SYS_CLKRST_REG_VPU_CPU_CLK_EN_V << HP_SYS_CLKRST_REG_VPU_CPU_CLK_EN_S)
#define HP_SYS_CLKRST_REG_VPU_CPU_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_VPU_CPU_CLK_EN_S  14
/** HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_EN : R/W; bitpos: [15]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_EN    (BIT(15))
#define HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_EN_M  (HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_EN_V << HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_EN_S  15
/** HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_EN : R/W; bitpos: [16]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_EN    (BIT(16))
#define HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_EN_M  (HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_EN_V << HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_EN_S  16
/** HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_EN : R/W; bitpos: [17]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_EN    (BIT(17))
#define HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_EN_M  (HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_EN_V << HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_EN_S  17
/** HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_EN : R/W; bitpos: [18]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_EN    (BIT(18))
#define HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_EN_M  (HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_EN_V << HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_EN_S  18
/** HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_EN : R/W; bitpos: [19]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_EN    (BIT(19))
#define HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_EN_M  (HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_EN_V << HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_EN_S  19
/** HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_EN : R/W; bitpos: [20]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_EN    (BIT(20))
#define HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_EN_M  (HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_EN_V << HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_EN_S  20
/** HP_SYS_CLKRST_REG_L2MEMMON_MEM_CLK_EN : R/W; bitpos: [21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L2MEMMON_MEM_CLK_EN    (BIT(21))
#define HP_SYS_CLKRST_REG_L2MEMMON_MEM_CLK_EN_M  (HP_SYS_CLKRST_REG_L2MEMMON_MEM_CLK_EN_V << HP_SYS_CLKRST_REG_L2MEMMON_MEM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L2MEMMON_MEM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L2MEMMON_MEM_CLK_EN_S  21
/** HP_SYS_CLKRST_REG_ICM_MEM_CLK_EN : R/W; bitpos: [22]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ICM_MEM_CLK_EN    (BIT(22))
#define HP_SYS_CLKRST_REG_ICM_MEM_CLK_EN_M  (HP_SYS_CLKRST_REG_ICM_MEM_CLK_EN_V << HP_SYS_CLKRST_REG_ICM_MEM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ICM_MEM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ICM_MEM_CLK_EN_S  22
/** HP_SYS_CLKRST_REG_MISC_SYS_CLK_EN : R/W; bitpos: [23]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MISC_SYS_CLK_EN    (BIT(23))
#define HP_SYS_CLKRST_REG_MISC_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_MISC_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_MISC_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_MISC_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MISC_SYS_CLK_EN_S  23
/** HP_SYS_CLKRST_REG_TRACE_SYS_CLK_EN : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TRACE_SYS_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_TRACE_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_TRACE_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_TRACE_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TRACE_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TRACE_SYS_CLK_EN_S  24
/** HP_SYS_CLKRST_REG_L2CACHE_SYS_CLK_EN : R/W; bitpos: [25]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L2CACHE_SYS_CLK_EN    (BIT(25))
#define HP_SYS_CLKRST_REG_L2CACHE_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_L2CACHE_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_L2CACHE_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L2CACHE_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L2CACHE_SYS_CLK_EN_S  25
/** HP_SYS_CLKRST_REG_L2MEM_SYS_CLK_EN : R/W; bitpos: [26]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L2MEM_SYS_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_L2MEM_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_L2MEM_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_L2MEM_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L2MEM_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L2MEM_SYS_CLK_EN_S  26
/** HP_SYS_CLKRST_REG_L2MEMMON_SYS_CLK_EN : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L2MEMMON_SYS_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_L2MEMMON_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_L2MEMMON_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_L2MEMMON_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_L2MEMMON_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_L2MEMMON_SYS_CLK_EN_S  27
/** HP_SYS_CLKRST_REG_TCMMON_SYS_CLK_EN : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TCMMON_SYS_CLK_EN    (BIT(28))
#define HP_SYS_CLKRST_REG_TCMMON_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_TCMMON_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_TCMMON_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TCMMON_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TCMMON_SYS_CLK_EN_S  28
/** HP_SYS_CLKRST_REG_ICM_SYS_CLK_EN : R/W; bitpos: [29]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ICM_SYS_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_ICM_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_ICM_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_ICM_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ICM_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ICM_SYS_CLK_EN_S  29
/** HP_SYS_CLKRST_REG_FLASH_SYS_CLK_EN : R/W; bitpos: [30]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FLASH_SYS_CLK_EN    (BIT(30))
#define HP_SYS_CLKRST_REG_FLASH_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_FLASH_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_FLASH_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_FLASH_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_FLASH_SYS_CLK_EN_S  30
/** HP_SYS_CLKRST_REG_PSRAM_SYS_CLK_EN : R/W; bitpos: [31]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PSRAM_SYS_CLK_EN    (BIT(31))
#define HP_SYS_CLKRST_REG_PSRAM_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_PSRAM_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_PSRAM_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PSRAM_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PSRAM_SYS_CLK_EN_S  31

/** HP_SYS_CLKRST_SOC_CLK_CTRL1_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_SOC_CLK_CTRL1_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x18)
/** HP_SYS_CLKRST_REG_GPSPI2_SYS_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI2_SYS_CLK_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_GPSPI2_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_GPSPI2_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_GPSPI2_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GPSPI2_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GPSPI2_SYS_CLK_EN_S  0
/** HP_SYS_CLKRST_REG_GPSPI3_SYS_CLK_EN : R/W; bitpos: [1]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI3_SYS_CLK_EN    (BIT(1))
#define HP_SYS_CLKRST_REG_GPSPI3_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_GPSPI3_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_GPSPI3_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GPSPI3_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GPSPI3_SYS_CLK_EN_S  1
/** HP_SYS_CLKRST_REG_REGDMA_SYS_CLK_EN : R/W; bitpos: [2]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REGDMA_SYS_CLK_EN    (BIT(2))
#define HP_SYS_CLKRST_REG_REGDMA_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_REGDMA_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_REGDMA_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_REGDMA_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_REGDMA_SYS_CLK_EN_S  2
/** HP_SYS_CLKRST_REG_AHB_PDMA_SYS_CLK_EN : R/W; bitpos: [3]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_AHB_PDMA_SYS_CLK_EN    (BIT(3))
#define HP_SYS_CLKRST_REG_AHB_PDMA_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_AHB_PDMA_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_AHB_PDMA_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_AHB_PDMA_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_AHB_PDMA_SYS_CLK_EN_S  3
/** HP_SYS_CLKRST_REG_AXI_PDMA_SYS_CLK_EN : R/W; bitpos: [4]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_AXI_PDMA_SYS_CLK_EN    (BIT(4))
#define HP_SYS_CLKRST_REG_AXI_PDMA_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_AXI_PDMA_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_AXI_PDMA_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_AXI_PDMA_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_AXI_PDMA_SYS_CLK_EN_S  4
/** HP_SYS_CLKRST_REG_GDMA_SYS_CLK_EN : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GDMA_SYS_CLK_EN    (BIT(5))
#define HP_SYS_CLKRST_REG_GDMA_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_GDMA_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_GDMA_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GDMA_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GDMA_SYS_CLK_EN_S  5
/** HP_SYS_CLKRST_REG_DMA2D_SYS_CLK_EN : R/W; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_DMA2D_SYS_CLK_EN    (BIT(6))
#define HP_SYS_CLKRST_REG_DMA2D_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_DMA2D_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_DMA2D_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_DMA2D_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_DMA2D_SYS_CLK_EN_S  6
/** HP_SYS_CLKRST_REG_VPU_SYS_CLK_EN : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_VPU_SYS_CLK_EN    (BIT(7))
#define HP_SYS_CLKRST_REG_VPU_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_VPU_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_VPU_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_VPU_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_VPU_SYS_CLK_EN_S  7
/** HP_SYS_CLKRST_REG_JPEG_SYS_CLK_EN : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_JPEG_SYS_CLK_EN    (BIT(8))
#define HP_SYS_CLKRST_REG_JPEG_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_JPEG_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_JPEG_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_JPEG_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_JPEG_SYS_CLK_EN_S  8
/** HP_SYS_CLKRST_REG_PPA_SYS_CLK_EN : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PPA_SYS_CLK_EN    (BIT(9))
#define HP_SYS_CLKRST_REG_PPA_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_PPA_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_PPA_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PPA_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PPA_SYS_CLK_EN_S  9
/** HP_SYS_CLKRST_REG_CSI_BRG_SYS_CLK_EN : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CSI_BRG_SYS_CLK_EN    (BIT(10))
#define HP_SYS_CLKRST_REG_CSI_BRG_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_CSI_BRG_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_CSI_BRG_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CSI_BRG_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CSI_BRG_SYS_CLK_EN_S  10
/** HP_SYS_CLKRST_REG_CSI_HOST_SYS_CLK_EN : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CSI_HOST_SYS_CLK_EN    (BIT(11))
#define HP_SYS_CLKRST_REG_CSI_HOST_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_CSI_HOST_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_CSI_HOST_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CSI_HOST_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CSI_HOST_SYS_CLK_EN_S  11
/** HP_SYS_CLKRST_REG_DSI_SYS_CLK_EN : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_DSI_SYS_CLK_EN    (BIT(12))
#define HP_SYS_CLKRST_REG_DSI_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_DSI_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_DSI_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_DSI_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_DSI_SYS_CLK_EN_S  12
/** HP_SYS_CLKRST_REG_EMAC_SYS_CLK_EN : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_SYS_CLK_EN    (BIT(13))
#define HP_SYS_CLKRST_REG_EMAC_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_EMAC_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_EMAC_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_EMAC_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_SYS_CLK_EN_S  13
/** HP_SYS_CLKRST_REG_SDMMC_SYS_CLK_EN : R/W; bitpos: [14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDMMC_SYS_CLK_EN    (BIT(14))
#define HP_SYS_CLKRST_REG_SDMMC_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_SDMMC_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_SDMMC_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_SDMMC_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDMMC_SYS_CLK_EN_S  14
/** HP_SYS_CLKRST_REG_USB_OTG11_SYS_CLK_EN : R/W; bitpos: [15]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_USB_OTG11_SYS_CLK_EN    (BIT(15))
#define HP_SYS_CLKRST_REG_USB_OTG11_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_USB_OTG11_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_USB_OTG11_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_USB_OTG11_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_USB_OTG11_SYS_CLK_EN_S  15
/** HP_SYS_CLKRST_REG_USB_OTG20_SYS_CLK_EN : R/W; bitpos: [16]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_USB_OTG20_SYS_CLK_EN    (BIT(16))
#define HP_SYS_CLKRST_REG_USB_OTG20_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_USB_OTG20_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_USB_OTG20_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_USB_OTG20_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_USB_OTG20_SYS_CLK_EN_S  16
/** HP_SYS_CLKRST_REG_UHCI_SYS_CLK_EN : R/W; bitpos: [17]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UHCI_SYS_CLK_EN    (BIT(17))
#define HP_SYS_CLKRST_REG_UHCI_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_UHCI_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_UHCI_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UHCI_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UHCI_SYS_CLK_EN_S  17
/** HP_SYS_CLKRST_REG_UART0_SYS_CLK_EN : R/W; bitpos: [18]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART0_SYS_CLK_EN    (BIT(18))
#define HP_SYS_CLKRST_REG_UART0_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_UART0_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_UART0_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART0_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART0_SYS_CLK_EN_S  18
/** HP_SYS_CLKRST_REG_UART1_SYS_CLK_EN : R/W; bitpos: [19]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART1_SYS_CLK_EN    (BIT(19))
#define HP_SYS_CLKRST_REG_UART1_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_UART1_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_UART1_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART1_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART1_SYS_CLK_EN_S  19
/** HP_SYS_CLKRST_REG_UART2_SYS_CLK_EN : R/W; bitpos: [20]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART2_SYS_CLK_EN    (BIT(20))
#define HP_SYS_CLKRST_REG_UART2_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_UART2_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_UART2_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART2_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART2_SYS_CLK_EN_S  20
/** HP_SYS_CLKRST_REG_UART3_SYS_CLK_EN : R/W; bitpos: [21]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART3_SYS_CLK_EN    (BIT(21))
#define HP_SYS_CLKRST_REG_UART3_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_UART3_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_UART3_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART3_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART3_SYS_CLK_EN_S  21
/** HP_SYS_CLKRST_REG_UART4_SYS_CLK_EN : R/W; bitpos: [22]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART4_SYS_CLK_EN    (BIT(22))
#define HP_SYS_CLKRST_REG_UART4_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_UART4_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_UART4_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART4_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART4_SYS_CLK_EN_S  22
/** HP_SYS_CLKRST_REG_PARLIO_SYS_CLK_EN : R/W; bitpos: [23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_SYS_CLK_EN    (BIT(23))
#define HP_SYS_CLKRST_REG_PARLIO_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_PARLIO_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_PARLIO_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PARLIO_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PARLIO_SYS_CLK_EN_S  23
/** HP_SYS_CLKRST_REG_ETM_SYS_CLK_EN : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ETM_SYS_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_ETM_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_ETM_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_ETM_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ETM_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ETM_SYS_CLK_EN_S  24
/** HP_SYS_CLKRST_REG_PVT_SYS_CLK_EN : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PVT_SYS_CLK_EN    (BIT(25))
#define HP_SYS_CLKRST_REG_PVT_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_PVT_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_PVT_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PVT_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PVT_SYS_CLK_EN_S  25
/** HP_SYS_CLKRST_REG_CRYPTO_SYS_CLK_EN : R/W; bitpos: [26]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_SYS_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_CRYPTO_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_SYS_CLK_EN_S  26
/** HP_SYS_CLKRST_REG_KEY_MANAGER_SYS_CLK_EN : R/W; bitpos: [27]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_KEY_MANAGER_SYS_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_KEY_MANAGER_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_KEY_MANAGER_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_KEY_MANAGER_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_KEY_MANAGER_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_KEY_MANAGER_SYS_CLK_EN_S  27
/** HP_SYS_CLKRST_REG_BITSCRAMBLER_SYS_CLK_EN : R/W; bitpos: [28]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_SYS_CLK_EN    (BIT(28))
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_BITSCRAMBLER_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_BITSCRAMBLER_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_SYS_CLK_EN_S  28
/** HP_SYS_CLKRST_REG_BITSCRAMBLER_RX_SYS_CLK_EN : R/W; bitpos: [29]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_RX_SYS_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_RX_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_BITSCRAMBLER_RX_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_BITSCRAMBLER_RX_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_RX_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_RX_SYS_CLK_EN_S  29
/** HP_SYS_CLKRST_REG_BITSCRAMBLER_TX_SYS_CLK_EN : R/W; bitpos: [30]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_TX_SYS_CLK_EN    (BIT(30))
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_TX_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_BITSCRAMBLER_TX_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_BITSCRAMBLER_TX_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_TX_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_BITSCRAMBLER_TX_SYS_CLK_EN_S  30
/** HP_SYS_CLKRST_REG_H264_SYS_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_H264_SYS_CLK_EN    (BIT(31))
#define HP_SYS_CLKRST_REG_H264_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_H264_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_H264_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_H264_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_H264_SYS_CLK_EN_S  31

/** HP_SYS_CLKRST_SOC_CLK_CTRL2_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_SOC_CLK_CTRL2_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x1c)
/** HP_SYS_CLKRST_REG_RMT_SYS_CLK_EN : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RMT_SYS_CLK_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_RMT_SYS_CLK_EN_M  (HP_SYS_CLKRST_REG_RMT_SYS_CLK_EN_V << HP_SYS_CLKRST_REG_RMT_SYS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_RMT_SYS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_RMT_SYS_CLK_EN_S  0
/** HP_SYS_CLKRST_REG_HP_CLKRST_APB_CLK_EN : R/W; bitpos: [1]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_HP_CLKRST_APB_CLK_EN    (BIT(1))
#define HP_SYS_CLKRST_REG_HP_CLKRST_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_HP_CLKRST_APB_CLK_EN_V << HP_SYS_CLKRST_REG_HP_CLKRST_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_HP_CLKRST_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_HP_CLKRST_APB_CLK_EN_S  1
/** HP_SYS_CLKRST_REG_SYSREG_APB_CLK_EN : R/W; bitpos: [2]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYSREG_APB_CLK_EN    (BIT(2))
#define HP_SYS_CLKRST_REG_SYSREG_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_SYSREG_APB_CLK_EN_V << HP_SYS_CLKRST_REG_SYSREG_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_SYSREG_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_SYSREG_APB_CLK_EN_S  2
/** HP_SYS_CLKRST_REG_ICM_APB_CLK_EN : R/W; bitpos: [3]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ICM_APB_CLK_EN    (BIT(3))
#define HP_SYS_CLKRST_REG_ICM_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_ICM_APB_CLK_EN_V << HP_SYS_CLKRST_REG_ICM_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ICM_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ICM_APB_CLK_EN_S  3
/** HP_SYS_CLKRST_REG_INTRMTX_APB_CLK_EN : R/W; bitpos: [4]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_INTRMTX_APB_CLK_EN    (BIT(4))
#define HP_SYS_CLKRST_REG_INTRMTX_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_INTRMTX_APB_CLK_EN_V << HP_SYS_CLKRST_REG_INTRMTX_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_INTRMTX_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_INTRMTX_APB_CLK_EN_S  4
/** HP_SYS_CLKRST_REG_ADC_APB_CLK_EN : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ADC_APB_CLK_EN    (BIT(5))
#define HP_SYS_CLKRST_REG_ADC_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_ADC_APB_CLK_EN_V << HP_SYS_CLKRST_REG_ADC_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ADC_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ADC_APB_CLK_EN_S  5
/** HP_SYS_CLKRST_REG_UHCI_APB_CLK_EN : R/W; bitpos: [6]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UHCI_APB_CLK_EN    (BIT(6))
#define HP_SYS_CLKRST_REG_UHCI_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_UHCI_APB_CLK_EN_V << HP_SYS_CLKRST_REG_UHCI_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UHCI_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UHCI_APB_CLK_EN_S  6
/** HP_SYS_CLKRST_REG_UART0_APB_CLK_EN : R/W; bitpos: [7]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART0_APB_CLK_EN    (BIT(7))
#define HP_SYS_CLKRST_REG_UART0_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_UART0_APB_CLK_EN_V << HP_SYS_CLKRST_REG_UART0_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART0_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART0_APB_CLK_EN_S  7
/** HP_SYS_CLKRST_REG_UART1_APB_CLK_EN : R/W; bitpos: [8]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART1_APB_CLK_EN    (BIT(8))
#define HP_SYS_CLKRST_REG_UART1_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_UART1_APB_CLK_EN_V << HP_SYS_CLKRST_REG_UART1_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART1_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART1_APB_CLK_EN_S  8
/** HP_SYS_CLKRST_REG_UART2_APB_CLK_EN : R/W; bitpos: [9]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART2_APB_CLK_EN    (BIT(9))
#define HP_SYS_CLKRST_REG_UART2_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_UART2_APB_CLK_EN_V << HP_SYS_CLKRST_REG_UART2_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART2_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART2_APB_CLK_EN_S  9
/** HP_SYS_CLKRST_REG_UART3_APB_CLK_EN : R/W; bitpos: [10]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART3_APB_CLK_EN    (BIT(10))
#define HP_SYS_CLKRST_REG_UART3_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_UART3_APB_CLK_EN_V << HP_SYS_CLKRST_REG_UART3_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART3_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART3_APB_CLK_EN_S  10
/** HP_SYS_CLKRST_REG_UART4_APB_CLK_EN : R/W; bitpos: [11]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART4_APB_CLK_EN    (BIT(11))
#define HP_SYS_CLKRST_REG_UART4_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_UART4_APB_CLK_EN_V << HP_SYS_CLKRST_REG_UART4_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART4_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART4_APB_CLK_EN_S  11
/** HP_SYS_CLKRST_REG_I2C0_APB_CLK_EN : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C0_APB_CLK_EN    (BIT(12))
#define HP_SYS_CLKRST_REG_I2C0_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_I2C0_APB_CLK_EN_V << HP_SYS_CLKRST_REG_I2C0_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2C0_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2C0_APB_CLK_EN_S  12
/** HP_SYS_CLKRST_REG_I2C1_APB_CLK_EN : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C1_APB_CLK_EN    (BIT(13))
#define HP_SYS_CLKRST_REG_I2C1_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_I2C1_APB_CLK_EN_V << HP_SYS_CLKRST_REG_I2C1_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2C1_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2C1_APB_CLK_EN_S  13
/** HP_SYS_CLKRST_REG_I2S0_APB_CLK_EN : R/W; bitpos: [14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_APB_CLK_EN    (BIT(14))
#define HP_SYS_CLKRST_REG_I2S0_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S0_APB_CLK_EN_V << HP_SYS_CLKRST_REG_I2S0_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S0_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S0_APB_CLK_EN_S  14
/** HP_SYS_CLKRST_REG_I2S1_APB_CLK_EN : R/W; bitpos: [15]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_APB_CLK_EN    (BIT(15))
#define HP_SYS_CLKRST_REG_I2S1_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S1_APB_CLK_EN_V << HP_SYS_CLKRST_REG_I2S1_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S1_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S1_APB_CLK_EN_S  15
/** HP_SYS_CLKRST_REG_I2S2_APB_CLK_EN : R/W; bitpos: [16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_APB_CLK_EN    (BIT(16))
#define HP_SYS_CLKRST_REG_I2S2_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S2_APB_CLK_EN_V << HP_SYS_CLKRST_REG_I2S2_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S2_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S2_APB_CLK_EN_S  16
/** HP_SYS_CLKRST_REG_I3C_MST_APB_CLK_EN : R/W; bitpos: [17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I3C_MST_APB_CLK_EN    (BIT(17))
#define HP_SYS_CLKRST_REG_I3C_MST_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_I3C_MST_APB_CLK_EN_V << HP_SYS_CLKRST_REG_I3C_MST_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I3C_MST_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I3C_MST_APB_CLK_EN_S  17
/** HP_SYS_CLKRST_REG_I3C_SLV_APB_CLK_EN : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I3C_SLV_APB_CLK_EN    (BIT(18))
#define HP_SYS_CLKRST_REG_I3C_SLV_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_I3C_SLV_APB_CLK_EN_V << HP_SYS_CLKRST_REG_I3C_SLV_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I3C_SLV_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I3C_SLV_APB_CLK_EN_S  18
/** HP_SYS_CLKRST_REG_GPSPI2_APB_CLK_EN : R/W; bitpos: [19]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI2_APB_CLK_EN    (BIT(19))
#define HP_SYS_CLKRST_REG_GPSPI2_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_GPSPI2_APB_CLK_EN_V << HP_SYS_CLKRST_REG_GPSPI2_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GPSPI2_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GPSPI2_APB_CLK_EN_S  19
/** HP_SYS_CLKRST_REG_GPSPI3_APB_CLK_EN : R/W; bitpos: [20]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI3_APB_CLK_EN    (BIT(20))
#define HP_SYS_CLKRST_REG_GPSPI3_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_GPSPI3_APB_CLK_EN_V << HP_SYS_CLKRST_REG_GPSPI3_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GPSPI3_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GPSPI3_APB_CLK_EN_S  20
/** HP_SYS_CLKRST_REG_TIMERGRP0_APB_CLK_EN : R/W; bitpos: [21]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_APB_CLK_EN    (BIT(21))
#define HP_SYS_CLKRST_REG_TIMERGRP0_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP0_APB_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP0_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP0_APB_CLK_EN_S  21
/** HP_SYS_CLKRST_REG_TIMERGRP1_APB_CLK_EN : R/W; bitpos: [22]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP1_APB_CLK_EN    (BIT(22))
#define HP_SYS_CLKRST_REG_TIMERGRP1_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP1_APB_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP1_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP1_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP1_APB_CLK_EN_S  22
/** HP_SYS_CLKRST_REG_SYSTIMER_APB_CLK_EN : R/W; bitpos: [23]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYSTIMER_APB_CLK_EN    (BIT(23))
#define HP_SYS_CLKRST_REG_SYSTIMER_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_SYSTIMER_APB_CLK_EN_V << HP_SYS_CLKRST_REG_SYSTIMER_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_SYSTIMER_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_SYSTIMER_APB_CLK_EN_S  23
/** HP_SYS_CLKRST_REG_TWAI0_APB_CLK_EN : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI0_APB_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_TWAI0_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_TWAI0_APB_CLK_EN_V << HP_SYS_CLKRST_REG_TWAI0_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TWAI0_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI0_APB_CLK_EN_S  24
/** HP_SYS_CLKRST_REG_TWAI1_APB_CLK_EN : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI1_APB_CLK_EN    (BIT(25))
#define HP_SYS_CLKRST_REG_TWAI1_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_TWAI1_APB_CLK_EN_V << HP_SYS_CLKRST_REG_TWAI1_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TWAI1_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI1_APB_CLK_EN_S  25
/** HP_SYS_CLKRST_REG_TWAI2_APB_CLK_EN : R/W; bitpos: [26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI2_APB_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_TWAI2_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_TWAI2_APB_CLK_EN_V << HP_SYS_CLKRST_REG_TWAI2_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TWAI2_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI2_APB_CLK_EN_S  26
/** HP_SYS_CLKRST_REG_MCPWM0_APB_CLK_EN : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MCPWM0_APB_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_MCPWM0_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_MCPWM0_APB_CLK_EN_V << HP_SYS_CLKRST_REG_MCPWM0_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_MCPWM0_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MCPWM0_APB_CLK_EN_S  27
/** HP_SYS_CLKRST_REG_MCPWM1_APB_CLK_EN : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MCPWM1_APB_CLK_EN    (BIT(28))
#define HP_SYS_CLKRST_REG_MCPWM1_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_MCPWM1_APB_CLK_EN_V << HP_SYS_CLKRST_REG_MCPWM1_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_MCPWM1_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MCPWM1_APB_CLK_EN_S  28
/** HP_SYS_CLKRST_REG_USB_DEVICE_APB_CLK_EN : R/W; bitpos: [29]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_USB_DEVICE_APB_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_USB_DEVICE_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_USB_DEVICE_APB_CLK_EN_V << HP_SYS_CLKRST_REG_USB_DEVICE_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_USB_DEVICE_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_USB_DEVICE_APB_CLK_EN_S  29
/** HP_SYS_CLKRST_REG_PCNT_APB_CLK_EN : R/W; bitpos: [30]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PCNT_APB_CLK_EN    (BIT(30))
#define HP_SYS_CLKRST_REG_PCNT_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_PCNT_APB_CLK_EN_V << HP_SYS_CLKRST_REG_PCNT_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PCNT_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PCNT_APB_CLK_EN_S  30
/** HP_SYS_CLKRST_REG_PARLIO_APB_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_APB_CLK_EN    (BIT(31))
#define HP_SYS_CLKRST_REG_PARLIO_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_PARLIO_APB_CLK_EN_V << HP_SYS_CLKRST_REG_PARLIO_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PARLIO_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PARLIO_APB_CLK_EN_S  31

/** HP_SYS_CLKRST_SOC_CLK_CTRL3_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_SOC_CLK_CTRL3_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x20)
/** HP_SYS_CLKRST_REG_LEDC_APB_CLK_EN : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LEDC_APB_CLK_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_LEDC_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_LEDC_APB_CLK_EN_V << HP_SYS_CLKRST_REG_LEDC_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_LEDC_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_LEDC_APB_CLK_EN_S  0
/** HP_SYS_CLKRST_REG_LCDCAM_APB_CLK_EN : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LCDCAM_APB_CLK_EN    (BIT(1))
#define HP_SYS_CLKRST_REG_LCDCAM_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_LCDCAM_APB_CLK_EN_V << HP_SYS_CLKRST_REG_LCDCAM_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_LCDCAM_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_LCDCAM_APB_CLK_EN_S  1
/** HP_SYS_CLKRST_REG_ETM_APB_CLK_EN : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ETM_APB_CLK_EN    (BIT(2))
#define HP_SYS_CLKRST_REG_ETM_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_ETM_APB_CLK_EN_V << HP_SYS_CLKRST_REG_ETM_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ETM_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ETM_APB_CLK_EN_S  2
/** HP_SYS_CLKRST_REG_IOMUX_APB_CLK_EN : R/W; bitpos: [3]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_IOMUX_APB_CLK_EN    (BIT(3))
#define HP_SYS_CLKRST_REG_IOMUX_APB_CLK_EN_M  (HP_SYS_CLKRST_REG_IOMUX_APB_CLK_EN_V << HP_SYS_CLKRST_REG_IOMUX_APB_CLK_EN_S)
#define HP_SYS_CLKRST_REG_IOMUX_APB_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_IOMUX_APB_CLK_EN_S  3

/** HP_SYS_CLKRST_REF_CLK_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_REF_CLK_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x24)
/** HP_SYS_CLKRST_REG_REF_50M_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 9;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_50M_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_REF_50M_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_REF_50M_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_REF_50M_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_REF_50M_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_REF_50M_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_REF_25M_CLK_DIV_NUM : R/W; bitpos: [15:8]; default: 19;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_25M_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_REF_25M_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_REF_25M_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_REF_25M_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_REF_25M_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_REF_25M_CLK_DIV_NUM_S  8
/** HP_SYS_CLKRST_REG_REF_240M_CLK_DIV_NUM : R/W; bitpos: [23:16]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_240M_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_REF_240M_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_REF_240M_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_REF_240M_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_REF_240M_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_REF_240M_CLK_DIV_NUM_S  16
/** HP_SYS_CLKRST_REG_REF_160M_CLK_DIV_NUM : R/W; bitpos: [31:24]; default: 2;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_160M_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_REF_160M_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_REF_160M_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_REF_160M_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_REF_160M_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_REF_160M_CLK_DIV_NUM_S  24

/** HP_SYS_CLKRST_REF_CLK_CTRL1_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_REF_CLK_CTRL1_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x28)
/** HP_SYS_CLKRST_REG_REF_120M_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 3;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_120M_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_REF_120M_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_REF_120M_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_REF_120M_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_REF_120M_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_REF_120M_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_REF_80M_CLK_DIV_NUM : R/W; bitpos: [15:8]; default: 5;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_80M_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_REF_80M_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_REF_80M_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_REF_80M_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_REF_80M_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_REF_80M_CLK_DIV_NUM_S  8
/** HP_SYS_CLKRST_REG_REF_20M_CLK_DIV_NUM : R/W; bitpos: [23:16]; default: 23;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_20M_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_REF_20M_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_REF_20M_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_REF_20M_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_REF_20M_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_REF_20M_CLK_DIV_NUM_S  16
/** HP_SYS_CLKRST_REG_TM_400M_CLK_EN : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_400M_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_TM_400M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_400M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_400M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_400M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_400M_CLK_EN_S  24
/** HP_SYS_CLKRST_REG_TM_200M_CLK_EN : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_200M_CLK_EN    (BIT(25))
#define HP_SYS_CLKRST_REG_TM_200M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_200M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_200M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_200M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_200M_CLK_EN_S  25
/** HP_SYS_CLKRST_REG_TM_100M_CLK_EN : R/W; bitpos: [26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_100M_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_TM_100M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_100M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_100M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_100M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_100M_CLK_EN_S  26
/** HP_SYS_CLKRST_REG_REF_50M_CLK_EN : R/W; bitpos: [27]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_50M_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_REF_50M_CLK_EN_M  (HP_SYS_CLKRST_REG_REF_50M_CLK_EN_V << HP_SYS_CLKRST_REG_REF_50M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_REF_50M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_REF_50M_CLK_EN_S  27
/** HP_SYS_CLKRST_REG_REF_25M_CLK_EN : R/W; bitpos: [28]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_25M_CLK_EN    (BIT(28))
#define HP_SYS_CLKRST_REG_REF_25M_CLK_EN_M  (HP_SYS_CLKRST_REG_REF_25M_CLK_EN_V << HP_SYS_CLKRST_REG_REF_25M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_REF_25M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_REF_25M_CLK_EN_S  28
/** HP_SYS_CLKRST_REG_TM_480M_CLK_EN : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_480M_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_TM_480M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_480M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_480M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_480M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_480M_CLK_EN_S  29
/** HP_SYS_CLKRST_REG_REF_240M_CLK_EN : R/W; bitpos: [30]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_240M_CLK_EN    (BIT(30))
#define HP_SYS_CLKRST_REG_REF_240M_CLK_EN_M  (HP_SYS_CLKRST_REG_REF_240M_CLK_EN_V << HP_SYS_CLKRST_REG_REF_240M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_REF_240M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_REF_240M_CLK_EN_S  30
/** HP_SYS_CLKRST_REG_TM_240M_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_240M_CLK_EN    (BIT(31))
#define HP_SYS_CLKRST_REG_TM_240M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_240M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_240M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_240M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_240M_CLK_EN_S  31

/** HP_SYS_CLKRST_REF_CLK_CTRL2_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_REF_CLK_CTRL2_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x2c)
/** HP_SYS_CLKRST_REG_REF_160M_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_160M_CLK_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_REF_160M_CLK_EN_M  (HP_SYS_CLKRST_REG_REF_160M_CLK_EN_V << HP_SYS_CLKRST_REG_REF_160M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_REF_160M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_REF_160M_CLK_EN_S  0
/** HP_SYS_CLKRST_REG_TM_160M_CLK_EN : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_160M_CLK_EN    (BIT(1))
#define HP_SYS_CLKRST_REG_TM_160M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_160M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_160M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_160M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_160M_CLK_EN_S  1
/** HP_SYS_CLKRST_REG_REF_120M_CLK_EN : R/W; bitpos: [2]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_120M_CLK_EN    (BIT(2))
#define HP_SYS_CLKRST_REG_REF_120M_CLK_EN_M  (HP_SYS_CLKRST_REG_REF_120M_CLK_EN_V << HP_SYS_CLKRST_REG_REF_120M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_REF_120M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_REF_120M_CLK_EN_S  2
/** HP_SYS_CLKRST_REG_TM_120M_CLK_EN : R/W; bitpos: [3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_120M_CLK_EN    (BIT(3))
#define HP_SYS_CLKRST_REG_TM_120M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_120M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_120M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_120M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_120M_CLK_EN_S  3
/** HP_SYS_CLKRST_REG_REF_80M_CLK_EN : R/W; bitpos: [4]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_80M_CLK_EN    (BIT(4))
#define HP_SYS_CLKRST_REG_REF_80M_CLK_EN_M  (HP_SYS_CLKRST_REG_REF_80M_CLK_EN_V << HP_SYS_CLKRST_REG_REF_80M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_REF_80M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_REF_80M_CLK_EN_S  4
/** HP_SYS_CLKRST_REG_TM_80M_CLK_EN : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_80M_CLK_EN    (BIT(5))
#define HP_SYS_CLKRST_REG_TM_80M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_80M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_80M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_80M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_80M_CLK_EN_S  5
/** HP_SYS_CLKRST_REG_TM_60M_CLK_EN : R/W; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_60M_CLK_EN    (BIT(6))
#define HP_SYS_CLKRST_REG_TM_60M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_60M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_60M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_60M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_60M_CLK_EN_S  6
/** HP_SYS_CLKRST_REG_TM_48M_CLK_EN : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_48M_CLK_EN    (BIT(7))
#define HP_SYS_CLKRST_REG_TM_48M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_48M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_48M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_48M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_48M_CLK_EN_S  7
/** HP_SYS_CLKRST_REG_REF_20M_CLK_EN : R/W; bitpos: [8]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_REF_20M_CLK_EN    (BIT(8))
#define HP_SYS_CLKRST_REG_REF_20M_CLK_EN_M  (HP_SYS_CLKRST_REG_REF_20M_CLK_EN_V << HP_SYS_CLKRST_REG_REF_20M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_REF_20M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_REF_20M_CLK_EN_S  8
/** HP_SYS_CLKRST_REG_TM_20M_CLK_EN : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TM_20M_CLK_EN    (BIT(9))
#define HP_SYS_CLKRST_REG_TM_20M_CLK_EN_M  (HP_SYS_CLKRST_REG_TM_20M_CLK_EN_V << HP_SYS_CLKRST_REG_TM_20M_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TM_20M_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TM_20M_CLK_EN_S  9

/** HP_SYS_CLKRST_PERI_CLK_CTRL00_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL00_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x30)
/** HP_SYS_CLKRST_REG_FLASH_CLK_SRC_SEL : R/W; bitpos: [1:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FLASH_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_FLASH_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_FLASH_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_FLASH_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_FLASH_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_FLASH_CLK_SRC_SEL_S  0
/** HP_SYS_CLKRST_REG_FLASH_PLL_CLK_EN : R/W; bitpos: [2]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FLASH_PLL_CLK_EN    (BIT(2))
#define HP_SYS_CLKRST_REG_FLASH_PLL_CLK_EN_M  (HP_SYS_CLKRST_REG_FLASH_PLL_CLK_EN_V << HP_SYS_CLKRST_REG_FLASH_PLL_CLK_EN_S)
#define HP_SYS_CLKRST_REG_FLASH_PLL_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_FLASH_PLL_CLK_EN_S  2
/** HP_SYS_CLKRST_REG_FLASH_CORE_CLK_EN : R/W; bitpos: [3]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FLASH_CORE_CLK_EN    (BIT(3))
#define HP_SYS_CLKRST_REG_FLASH_CORE_CLK_EN_M  (HP_SYS_CLKRST_REG_FLASH_CORE_CLK_EN_V << HP_SYS_CLKRST_REG_FLASH_CORE_CLK_EN_S)
#define HP_SYS_CLKRST_REG_FLASH_CORE_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_FLASH_CORE_CLK_EN_S  3
/** HP_SYS_CLKRST_REG_FLASH_CORE_CLK_DIV_NUM : R/W; bitpos: [11:4]; default: 3;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FLASH_CORE_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_FLASH_CORE_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_FLASH_CORE_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_FLASH_CORE_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_FLASH_CORE_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_FLASH_CORE_CLK_DIV_NUM_S  4
/** HP_SYS_CLKRST_REG_PSRAM_CLK_SRC_SEL : R/W; bitpos: [13:12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PSRAM_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_PSRAM_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_PSRAM_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_PSRAM_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_PSRAM_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_PSRAM_CLK_SRC_SEL_S  12
/** HP_SYS_CLKRST_REG_PSRAM_PLL_CLK_EN : R/W; bitpos: [14]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PSRAM_PLL_CLK_EN    (BIT(14))
#define HP_SYS_CLKRST_REG_PSRAM_PLL_CLK_EN_M  (HP_SYS_CLKRST_REG_PSRAM_PLL_CLK_EN_V << HP_SYS_CLKRST_REG_PSRAM_PLL_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PSRAM_PLL_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PSRAM_PLL_CLK_EN_S  14
/** HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_EN : R/W; bitpos: [15]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_EN    (BIT(15))
#define HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_EN_M  (HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_EN_V << HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_EN_S  15
/** HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_DIV_NUM : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PSRAM_CORE_CLK_DIV_NUM_S  16
/** HP_SYS_CLKRST_REG_PAD_EMAC_REF_CLK_EN : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PAD_EMAC_REF_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_PAD_EMAC_REF_CLK_EN_M  (HP_SYS_CLKRST_REG_PAD_EMAC_REF_CLK_EN_V << HP_SYS_CLKRST_REG_PAD_EMAC_REF_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PAD_EMAC_REF_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PAD_EMAC_REF_CLK_EN_S  24
/** HP_SYS_CLKRST_REG_EMAC_RMII_CLK_SRC_SEL : R/W; bitpos: [26:25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_RMII_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_EMAC_RMII_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_EMAC_RMII_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_EMAC_RMII_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_EMAC_RMII_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_EMAC_RMII_CLK_SRC_SEL_S  25
/** HP_SYS_CLKRST_REG_EMAC_RMII_CLK_EN : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_RMII_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_EMAC_RMII_CLK_EN_M  (HP_SYS_CLKRST_REG_EMAC_RMII_CLK_EN_V << HP_SYS_CLKRST_REG_EMAC_RMII_CLK_EN_S)
#define HP_SYS_CLKRST_REG_EMAC_RMII_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_RMII_CLK_EN_S  27
/** HP_SYS_CLKRST_REG_EMAC_RX_CLK_SRC_SEL : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_SRC_SEL    (BIT(28))
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_EMAC_RX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_EMAC_RX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_SRC_SEL_S  28
/** HP_SYS_CLKRST_REG_EMAC_RX_CLK_EN : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_EN_M  (HP_SYS_CLKRST_REG_EMAC_RX_CLK_EN_V << HP_SYS_CLKRST_REG_EMAC_RX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_EN_S  29

/** HP_SYS_CLKRST_PERI_CLK_CTRL01_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL01_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x34)
/** HP_SYS_CLKRST_REG_EMAC_RX_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_EMAC_RX_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_EMAC_RX_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_EMAC_RX_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_EMAC_TX_CLK_SRC_SEL : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_SRC_SEL    (BIT(8))
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_EMAC_TX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_EMAC_TX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_SRC_SEL_S  8
/** HP_SYS_CLKRST_REG_EMAC_TX_CLK_EN : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_EN    (BIT(9))
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_EN_M  (HP_SYS_CLKRST_REG_EMAC_TX_CLK_EN_V << HP_SYS_CLKRST_REG_EMAC_TX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_EN_S  9
/** HP_SYS_CLKRST_REG_EMAC_TX_CLK_DIV_NUM : R/W; bitpos: [17:10]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_EMAC_TX_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_EMAC_TX_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_EMAC_TX_CLK_DIV_NUM_S  10
/** HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_SRC_SEL : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_SRC_SEL    (BIT(18))
#define HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_SRC_SEL_S  18
/** HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_EN : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_EN    (BIT(19))
#define HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_EN_M  (HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_EN_V << HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_EN_S)
#define HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_PTP_REF_CLK_EN_S  19
/** HP_SYS_CLKRST_REG_EMAC_UNUSED0_CLK_EN : R/W; bitpos: [20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_UNUSED0_CLK_EN    (BIT(20))
#define HP_SYS_CLKRST_REG_EMAC_UNUSED0_CLK_EN_M  (HP_SYS_CLKRST_REG_EMAC_UNUSED0_CLK_EN_V << HP_SYS_CLKRST_REG_EMAC_UNUSED0_CLK_EN_S)
#define HP_SYS_CLKRST_REG_EMAC_UNUSED0_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_UNUSED0_CLK_EN_S  20
/** HP_SYS_CLKRST_REG_EMAC_UNUSED1_CLK_EN : R/W; bitpos: [21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_EMAC_UNUSED1_CLK_EN    (BIT(21))
#define HP_SYS_CLKRST_REG_EMAC_UNUSED1_CLK_EN_M  (HP_SYS_CLKRST_REG_EMAC_UNUSED1_CLK_EN_V << HP_SYS_CLKRST_REG_EMAC_UNUSED1_CLK_EN_S)
#define HP_SYS_CLKRST_REG_EMAC_UNUSED1_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_EMAC_UNUSED1_CLK_EN_S  21
/** HP_SYS_CLKRST_REG_SDIO_HS_MODE : R/W; bitpos: [22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_HS_MODE    (BIT(22))
#define HP_SYS_CLKRST_REG_SDIO_HS_MODE_M  (HP_SYS_CLKRST_REG_SDIO_HS_MODE_V << HP_SYS_CLKRST_REG_SDIO_HS_MODE_S)
#define HP_SYS_CLKRST_REG_SDIO_HS_MODE_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_HS_MODE_S  22
/** HP_SYS_CLKRST_REG_SDIO_LS_CLK_SRC_SEL : R/W; bitpos: [23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_SRC_SEL    (BIT(23))
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_SDIO_LS_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_SDIO_LS_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_SRC_SEL_S  23
/** HP_SYS_CLKRST_REG_SDIO_LS_CLK_EN : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EN_M  (HP_SYS_CLKRST_REG_SDIO_LS_CLK_EN_V << HP_SYS_CLKRST_REG_SDIO_LS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EN_S  24

/** HP_SYS_CLKRST_PERI_CLK_CTRL02_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL02_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x38)
/** HP_SYS_CLKRST_REG_SDIO_LS_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_SDIO_LS_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_SDIO_LS_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_CFG_UPDATE : WT; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_CFG_UPDATE    (BIT(8))
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_CFG_UPDATE_M  (HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_CFG_UPDATE_V << HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_CFG_UPDATE_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_CFG_UPDATE_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_CFG_UPDATE_S  8
/** HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_L : R/W; bitpos: [12:9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_L    0x0000000FU
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_L_M  (HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_L_V << HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_L_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_L_V  0x0000000FU
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_L_S  9
/** HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_H : R/W; bitpos: [16:13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_H    0x0000000FU
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_H_M  (HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_H_V << HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_H_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_H_V  0x0000000FU
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_H_S  13
/** HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_N : R/W; bitpos: [20:17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_N    0x0000000FU
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_N_M  (HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_N_V << HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_N_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_N_V  0x0000000FU
#define HP_SYS_CLKRST_REG_SDIO_LS_CLK_EDGE_N_S  17
/** HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EDGE_SEL : R/W; bitpos: [22:21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EDGE_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EDGE_SEL_M  (HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EDGE_SEL_V << HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EDGE_SEL_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EDGE_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EDGE_SEL_S  21
/** HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EDGE_SEL : R/W; bitpos: [24:23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EDGE_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EDGE_SEL_M  (HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EDGE_SEL_V << HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EDGE_SEL_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EDGE_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EDGE_SEL_S  23
/** HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EDGE_SEL : R/W; bitpos: [26:25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EDGE_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EDGE_SEL_M  (HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EDGE_SEL_V << HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EDGE_SEL_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EDGE_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EDGE_SEL_S  25
/** HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EN : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EN_M  (HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EN_V << HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EN_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_LS_SLF_CLK_EN_S  27
/** HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EN : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EN    (BIT(28))
#define HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EN_M  (HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EN_V << HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EN_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_LS_DRV_CLK_EN_S  28
/** HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EN : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EN_M  (HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EN_V << HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_LS_SAM_CLK_EN_S  29
/** HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CLK_SRC_SEL : R/W; bitpos: [31:30]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CLK_SRC_SEL_S  30

/** HP_SYS_CLKRST_PERI_CLK_CTRL03_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL03_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x3c)
/** HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CFG_CLK_EN : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CFG_CLK_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CFG_CLK_EN_M  (HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CFG_CLK_EN_V << HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CFG_CLK_EN_S)
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CFG_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_CFG_CLK_EN_S  0
/** HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_PLL_REFCLK_EN : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_PLL_REFCLK_EN    (BIT(1))
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_PLL_REFCLK_EN_M  (HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_PLL_REFCLK_EN_V << HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_PLL_REFCLK_EN_S)
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_PLL_REFCLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPHY_PLL_REFCLK_EN_S  1
/** HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CLK_SRC_SEL : R/W; bitpos: [3:2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CLK_SRC_SEL_S  2
/** HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CFG_CLK_EN : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CFG_CLK_EN    (BIT(4))
#define HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CFG_CLK_EN_M  (HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CFG_CLK_EN_V << HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CFG_CLK_EN_S)
#define HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CFG_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MIPI_CSI_DPHY_CFG_CLK_EN_S  4
/** HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_SRC_SEL : R/W; bitpos: [6:5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_SRC_SEL_V << HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_SRC_SEL_S  5
/** HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_EN : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_EN    (BIT(7))
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_EN_M  (HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_EN_V << HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_EN_S)
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_EN_S  7
/** HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_DIV_NUM : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_DIV_NUM_V << HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_MIPI_DSI_DPICLK_DIV_NUM_S  8

/** HP_SYS_CLKRST_PERI_CLK_CTRL10_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL10_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x40)
/** HP_SYS_CLKRST_REG_I2C0_CLK_SRC_SEL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C0_CLK_SRC_SEL    (BIT(0))
#define HP_SYS_CLKRST_REG_I2C0_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I2C0_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I2C0_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I2C0_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2C0_CLK_SRC_SEL_S  0
/** HP_SYS_CLKRST_REG_I2C0_CLK_EN : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C0_CLK_EN    (BIT(1))
#define HP_SYS_CLKRST_REG_I2C0_CLK_EN_M  (HP_SYS_CLKRST_REG_I2C0_CLK_EN_V << HP_SYS_CLKRST_REG_I2C0_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2C0_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2C0_CLK_EN_S  1
/** HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUM : R/W; bitpos: [9:2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUM_S  2
/** HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUMERATOR : R/W; bitpos: [17:10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_NUMERATOR_S  10
/** HP_SYS_CLKRST_REG_I2C0_CLK_DIV_DENOMINATOR : R/W; bitpos: [25:18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_I2C0_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_I2C0_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2C0_CLK_DIV_DENOMINATOR_S  18
/** HP_SYS_CLKRST_REG_I2C1_CLK_SRC_SEL : R/W; bitpos: [26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C1_CLK_SRC_SEL    (BIT(26))
#define HP_SYS_CLKRST_REG_I2C1_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I2C1_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I2C1_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I2C1_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2C1_CLK_SRC_SEL_S  26
/** HP_SYS_CLKRST_REG_I2C1_CLK_EN : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C1_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_I2C1_CLK_EN_M  (HP_SYS_CLKRST_REG_I2C1_CLK_EN_V << HP_SYS_CLKRST_REG_I2C1_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2C1_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2C1_CLK_EN_S  27

/** HP_SYS_CLKRST_PERI_CLK_CTRL11_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL11_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x44)
/** HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_I2C1_CLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_I2C1_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_I2C1_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2C1_CLK_DIV_DENOMINATOR_S  16
/** HP_SYS_CLKRST_REG_I2S0_RX_CLK_EN : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_RX_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_I2S0_RX_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S0_RX_CLK_EN_V << HP_SYS_CLKRST_REG_I2S0_RX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S0_RX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S0_RX_CLK_EN_S  24
/** HP_SYS_CLKRST_REG_I2S0_RX_CLK_SRC_SEL : R/W; bitpos: [26:25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_RX_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_I2S0_RX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I2S0_RX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I2S0_RX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I2S0_RX_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_I2S0_RX_CLK_SRC_SEL_S  25

/** HP_SYS_CLKRST_PERI_CLK_CTRL12_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL12_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x48)
/** HP_SYS_CLKRST_REG_I2S0_RX_DIV_N : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_N    0x000000FFU
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_N_M  (HP_SYS_CLKRST_REG_I2S0_RX_DIV_N_V << HP_SYS_CLKRST_REG_I2S0_RX_DIV_N_S)
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_N_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_N_S  0
/** HP_SYS_CLKRST_REG_I2S0_RX_DIV_X : R/W; bitpos: [16:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_X    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_X_M  (HP_SYS_CLKRST_REG_I2S0_RX_DIV_X_V << HP_SYS_CLKRST_REG_I2S0_RX_DIV_X_S)
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_X_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_X_S  8
/** HP_SYS_CLKRST_REG_I2S0_RX_DIV_Y : R/W; bitpos: [25:17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_Y    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_Y_M  (HP_SYS_CLKRST_REG_I2S0_RX_DIV_Y_V << HP_SYS_CLKRST_REG_I2S0_RX_DIV_Y_S)
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_Y_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_Y_S  17

/** HP_SYS_CLKRST_PERI_CLK_CTRL13_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL13_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x4c)
/** HP_SYS_CLKRST_REG_I2S0_RX_DIV_Z : R/W; bitpos: [8:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_Z    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_Z_M  (HP_SYS_CLKRST_REG_I2S0_RX_DIV_Z_V << HP_SYS_CLKRST_REG_I2S0_RX_DIV_Z_S)
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_Z_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_Z_S  0
/** HP_SYS_CLKRST_REG_I2S0_RX_DIV_YN1 : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_YN1    (BIT(9))
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_YN1_M  (HP_SYS_CLKRST_REG_I2S0_RX_DIV_YN1_V << HP_SYS_CLKRST_REG_I2S0_RX_DIV_YN1_S)
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_YN1_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S0_RX_DIV_YN1_S  9
/** HP_SYS_CLKRST_REG_I2S0_TX_CLK_EN : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_TX_CLK_EN    (BIT(10))
#define HP_SYS_CLKRST_REG_I2S0_TX_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S0_TX_CLK_EN_V << HP_SYS_CLKRST_REG_I2S0_TX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S0_TX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S0_TX_CLK_EN_S  10
/** HP_SYS_CLKRST_REG_I2S0_TX_CLK_SRC_SEL : R/W; bitpos: [12:11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_TX_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_I2S0_TX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I2S0_TX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I2S0_TX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I2S0_TX_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_I2S0_TX_CLK_SRC_SEL_S  11
/** HP_SYS_CLKRST_REG_I2S0_TX_DIV_N : R/W; bitpos: [20:13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_N    0x000000FFU
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_N_M  (HP_SYS_CLKRST_REG_I2S0_TX_DIV_N_V << HP_SYS_CLKRST_REG_I2S0_TX_DIV_N_S)
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_N_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_N_S  13
/** HP_SYS_CLKRST_REG_I2S0_TX_DIV_X : R/W; bitpos: [29:21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_X    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_X_M  (HP_SYS_CLKRST_REG_I2S0_TX_DIV_X_V << HP_SYS_CLKRST_REG_I2S0_TX_DIV_X_S)
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_X_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_X_S  21

/** HP_SYS_CLKRST_PERI_CLK_CTRL14_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL14_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x50)
/** HP_SYS_CLKRST_REG_I2S0_TX_DIV_Y : R/W; bitpos: [8:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_Y    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_Y_M  (HP_SYS_CLKRST_REG_I2S0_TX_DIV_Y_V << HP_SYS_CLKRST_REG_I2S0_TX_DIV_Y_S)
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_Y_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_Y_S  0
/** HP_SYS_CLKRST_REG_I2S0_TX_DIV_Z : R/W; bitpos: [17:9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_Z    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_Z_M  (HP_SYS_CLKRST_REG_I2S0_TX_DIV_Z_V << HP_SYS_CLKRST_REG_I2S0_TX_DIV_Z_S)
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_Z_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_Z_S  9
/** HP_SYS_CLKRST_REG_I2S0_TX_DIV_YN1 : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_YN1    (BIT(18))
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_YN1_M  (HP_SYS_CLKRST_REG_I2S0_TX_DIV_YN1_V << HP_SYS_CLKRST_REG_I2S0_TX_DIV_YN1_S)
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_YN1_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S0_TX_DIV_YN1_S  18
/** HP_SYS_CLKRST_REG_I2S0_MST_CLK_SEL : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S0_MST_CLK_SEL    (BIT(19))
#define HP_SYS_CLKRST_REG_I2S0_MST_CLK_SEL_M  (HP_SYS_CLKRST_REG_I2S0_MST_CLK_SEL_V << HP_SYS_CLKRST_REG_I2S0_MST_CLK_SEL_S)
#define HP_SYS_CLKRST_REG_I2S0_MST_CLK_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S0_MST_CLK_SEL_S  19
/** HP_SYS_CLKRST_REG_I2S1_RX_CLK_EN : R/W; bitpos: [20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_RX_CLK_EN    (BIT(20))
#define HP_SYS_CLKRST_REG_I2S1_RX_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S1_RX_CLK_EN_V << HP_SYS_CLKRST_REG_I2S1_RX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S1_RX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S1_RX_CLK_EN_S  20
/** HP_SYS_CLKRST_REG_I2S1_RX_CLK_SRC_SEL : R/W; bitpos: [22:21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_RX_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_I2S1_RX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I2S1_RX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I2S1_RX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I2S1_RX_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_I2S1_RX_CLK_SRC_SEL_S  21
/** HP_SYS_CLKRST_REG_I2S1_RX_DIV_N : R/W; bitpos: [30:23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_N    0x000000FFU
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_N_M  (HP_SYS_CLKRST_REG_I2S1_RX_DIV_N_V << HP_SYS_CLKRST_REG_I2S1_RX_DIV_N_S)
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_N_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_N_S  23

/** HP_SYS_CLKRST_PERI_CLK_CTRL15_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL15_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x54)
/** HP_SYS_CLKRST_REG_I2S1_RX_DIV_X : R/W; bitpos: [8:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_X    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_X_M  (HP_SYS_CLKRST_REG_I2S1_RX_DIV_X_V << HP_SYS_CLKRST_REG_I2S1_RX_DIV_X_S)
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_X_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_X_S  0
/** HP_SYS_CLKRST_REG_I2S1_RX_DIV_Y : R/W; bitpos: [17:9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_Y    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_Y_M  (HP_SYS_CLKRST_REG_I2S1_RX_DIV_Y_V << HP_SYS_CLKRST_REG_I2S1_RX_DIV_Y_S)
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_Y_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_Y_S  9
/** HP_SYS_CLKRST_REG_I2S1_RX_DIV_Z : R/W; bitpos: [26:18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_Z    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_Z_M  (HP_SYS_CLKRST_REG_I2S1_RX_DIV_Z_V << HP_SYS_CLKRST_REG_I2S1_RX_DIV_Z_S)
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_Z_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_Z_S  18
/** HP_SYS_CLKRST_REG_I2S1_RX_DIV_YN1 : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_YN1    (BIT(27))
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_YN1_M  (HP_SYS_CLKRST_REG_I2S1_RX_DIV_YN1_V << HP_SYS_CLKRST_REG_I2S1_RX_DIV_YN1_S)
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_YN1_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S1_RX_DIV_YN1_S  27
/** HP_SYS_CLKRST_REG_I2S1_TX_CLK_EN : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_TX_CLK_EN    (BIT(28))
#define HP_SYS_CLKRST_REG_I2S1_TX_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S1_TX_CLK_EN_V << HP_SYS_CLKRST_REG_I2S1_TX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S1_TX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S1_TX_CLK_EN_S  28
/** HP_SYS_CLKRST_REG_I2S1_TX_CLK_SRC_SEL : R/W; bitpos: [30:29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_TX_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_I2S1_TX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I2S1_TX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I2S1_TX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I2S1_TX_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_I2S1_TX_CLK_SRC_SEL_S  29

/** HP_SYS_CLKRST_PERI_CLK_CTRL16_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL16_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x58)
/** HP_SYS_CLKRST_REG_I2S1_TX_DIV_N : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_N    0x000000FFU
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_N_M  (HP_SYS_CLKRST_REG_I2S1_TX_DIV_N_V << HP_SYS_CLKRST_REG_I2S1_TX_DIV_N_S)
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_N_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_N_S  0
/** HP_SYS_CLKRST_REG_I2S1_TX_DIV_X : R/W; bitpos: [16:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_X    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_X_M  (HP_SYS_CLKRST_REG_I2S1_TX_DIV_X_V << HP_SYS_CLKRST_REG_I2S1_TX_DIV_X_S)
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_X_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_X_S  8
/** HP_SYS_CLKRST_REG_I2S1_TX_DIV_Y : R/W; bitpos: [25:17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_Y    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_Y_M  (HP_SYS_CLKRST_REG_I2S1_TX_DIV_Y_V << HP_SYS_CLKRST_REG_I2S1_TX_DIV_Y_S)
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_Y_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_Y_S  17

/** HP_SYS_CLKRST_PERI_CLK_CTRL17_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL17_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x5c)
/** HP_SYS_CLKRST_REG_I2S1_TX_DIV_Z : R/W; bitpos: [8:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_Z    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_Z_M  (HP_SYS_CLKRST_REG_I2S1_TX_DIV_Z_V << HP_SYS_CLKRST_REG_I2S1_TX_DIV_Z_S)
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_Z_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_Z_S  0
/** HP_SYS_CLKRST_REG_I2S1_TX_DIV_YN1 : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_YN1    (BIT(9))
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_YN1_M  (HP_SYS_CLKRST_REG_I2S1_TX_DIV_YN1_V << HP_SYS_CLKRST_REG_I2S1_TX_DIV_YN1_S)
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_YN1_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S1_TX_DIV_YN1_S  9
/** HP_SYS_CLKRST_REG_I2S1_MST_CLK_SEL : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S1_MST_CLK_SEL    (BIT(10))
#define HP_SYS_CLKRST_REG_I2S1_MST_CLK_SEL_M  (HP_SYS_CLKRST_REG_I2S1_MST_CLK_SEL_V << HP_SYS_CLKRST_REG_I2S1_MST_CLK_SEL_S)
#define HP_SYS_CLKRST_REG_I2S1_MST_CLK_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S1_MST_CLK_SEL_S  10
/** HP_SYS_CLKRST_REG_I2S2_RX_CLK_EN : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_RX_CLK_EN    (BIT(11))
#define HP_SYS_CLKRST_REG_I2S2_RX_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S2_RX_CLK_EN_V << HP_SYS_CLKRST_REG_I2S2_RX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S2_RX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S2_RX_CLK_EN_S  11
/** HP_SYS_CLKRST_REG_I2S2_RX_CLK_SRC_SEL : R/W; bitpos: [13:12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_RX_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_I2S2_RX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I2S2_RX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I2S2_RX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I2S2_RX_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_I2S2_RX_CLK_SRC_SEL_S  12
/** HP_SYS_CLKRST_REG_I2S2_RX_DIV_N : R/W; bitpos: [21:14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_N    0x000000FFU
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_N_M  (HP_SYS_CLKRST_REG_I2S2_RX_DIV_N_V << HP_SYS_CLKRST_REG_I2S2_RX_DIV_N_S)
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_N_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_N_S  14
/** HP_SYS_CLKRST_REG_I2S2_RX_DIV_X : R/W; bitpos: [30:22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_X    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_X_M  (HP_SYS_CLKRST_REG_I2S2_RX_DIV_X_V << HP_SYS_CLKRST_REG_I2S2_RX_DIV_X_S)
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_X_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_X_S  22

/** HP_SYS_CLKRST_PERI_CLK_CTRL18_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL18_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x60)
/** HP_SYS_CLKRST_REG_I2S2_RX_DIV_Y : R/W; bitpos: [8:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_Y    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_Y_M  (HP_SYS_CLKRST_REG_I2S2_RX_DIV_Y_V << HP_SYS_CLKRST_REG_I2S2_RX_DIV_Y_S)
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_Y_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_Y_S  0
/** HP_SYS_CLKRST_REG_I2S2_RX_DIV_Z : R/W; bitpos: [17:9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_Z    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_Z_M  (HP_SYS_CLKRST_REG_I2S2_RX_DIV_Z_V << HP_SYS_CLKRST_REG_I2S2_RX_DIV_Z_S)
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_Z_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_Z_S  9
/** HP_SYS_CLKRST_REG_I2S2_RX_DIV_YN1 : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_YN1    (BIT(18))
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_YN1_M  (HP_SYS_CLKRST_REG_I2S2_RX_DIV_YN1_V << HP_SYS_CLKRST_REG_I2S2_RX_DIV_YN1_S)
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_YN1_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S2_RX_DIV_YN1_S  18
/** HP_SYS_CLKRST_REG_I2S2_TX_CLK_EN : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_TX_CLK_EN    (BIT(19))
#define HP_SYS_CLKRST_REG_I2S2_TX_CLK_EN_M  (HP_SYS_CLKRST_REG_I2S2_TX_CLK_EN_V << HP_SYS_CLKRST_REG_I2S2_TX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I2S2_TX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S2_TX_CLK_EN_S  19
/** HP_SYS_CLKRST_REG_I2S2_TX_CLK_SRC_SEL : R/W; bitpos: [21:20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_TX_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_I2S2_TX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I2S2_TX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I2S2_TX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I2S2_TX_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_I2S2_TX_CLK_SRC_SEL_S  20
/** HP_SYS_CLKRST_REG_I2S2_TX_DIV_N : R/W; bitpos: [29:22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_N    0x000000FFU
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_N_M  (HP_SYS_CLKRST_REG_I2S2_TX_DIV_N_V << HP_SYS_CLKRST_REG_I2S2_TX_DIV_N_S)
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_N_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_N_S  22

/** HP_SYS_CLKRST_PERI_CLK_CTRL19_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL19_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x64)
/** HP_SYS_CLKRST_REG_I2S2_TX_DIV_X : R/W; bitpos: [8:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_X    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_X_M  (HP_SYS_CLKRST_REG_I2S2_TX_DIV_X_V << HP_SYS_CLKRST_REG_I2S2_TX_DIV_X_S)
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_X_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_X_S  0
/** HP_SYS_CLKRST_REG_I2S2_TX_DIV_Y : R/W; bitpos: [17:9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_Y    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_Y_M  (HP_SYS_CLKRST_REG_I2S2_TX_DIV_Y_V << HP_SYS_CLKRST_REG_I2S2_TX_DIV_Y_S)
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_Y_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_Y_S  9
/** HP_SYS_CLKRST_REG_I2S2_TX_DIV_Z : R/W; bitpos: [26:18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_Z    0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_Z_M  (HP_SYS_CLKRST_REG_I2S2_TX_DIV_Z_V << HP_SYS_CLKRST_REG_I2S2_TX_DIV_Z_S)
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_Z_V  0x000001FFU
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_Z_S  18
/** HP_SYS_CLKRST_REG_I2S2_TX_DIV_YN1 : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_YN1    (BIT(27))
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_YN1_M  (HP_SYS_CLKRST_REG_I2S2_TX_DIV_YN1_V << HP_SYS_CLKRST_REG_I2S2_TX_DIV_YN1_S)
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_YN1_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S2_TX_DIV_YN1_S  27
/** HP_SYS_CLKRST_REG_I2S2_MST_CLK_SEL : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I2S2_MST_CLK_SEL    (BIT(28))
#define HP_SYS_CLKRST_REG_I2S2_MST_CLK_SEL_M  (HP_SYS_CLKRST_REG_I2S2_MST_CLK_SEL_V << HP_SYS_CLKRST_REG_I2S2_MST_CLK_SEL_S)
#define HP_SYS_CLKRST_REG_I2S2_MST_CLK_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_I2S2_MST_CLK_SEL_S  28
/** HP_SYS_CLKRST_REG_LCD_CLK_SRC_SEL : R/W; bitpos: [30:29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LCD_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_LCD_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_LCD_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_LCD_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_LCD_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_LCD_CLK_SRC_SEL_S  29
/** HP_SYS_CLKRST_REG_LCD_CLK_EN : R/W; bitpos: [31]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LCD_CLK_EN    (BIT(31))
#define HP_SYS_CLKRST_REG_LCD_CLK_EN_M  (HP_SYS_CLKRST_REG_LCD_CLK_EN_V << HP_SYS_CLKRST_REG_LCD_CLK_EN_S)
#define HP_SYS_CLKRST_REG_LCD_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_LCD_CLK_EN_S  31

/** HP_SYS_CLKRST_PERI_CLK_CTRL110_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL110_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x68)
/** HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_LCD_CLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_LCD_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_LCD_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_LCD_CLK_DIV_DENOMINATOR_S  16
/** HP_SYS_CLKRST_REG_UART0_CLK_SRC_SEL : R/W; bitpos: [25:24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART0_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_UART0_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_UART0_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_UART0_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_UART0_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_UART0_CLK_SRC_SEL_S  24
/** HP_SYS_CLKRST_REG_UART0_CLK_EN : R/W; bitpos: [26]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART0_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_UART0_CLK_EN_M  (HP_SYS_CLKRST_REG_UART0_CLK_EN_V << HP_SYS_CLKRST_REG_UART0_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART0_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART0_CLK_EN_S  26

/** HP_SYS_CLKRST_PERI_CLK_CTRL111_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL111_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x6c)
/** HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUM_V << HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_UART0_SCLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_UART0_SCLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_UART0_SCLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART0_SCLK_DIV_DENOMINATOR_S  16
/** HP_SYS_CLKRST_REG_UART1_CLK_SRC_SEL : R/W; bitpos: [25:24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART1_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_UART1_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_UART1_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_UART1_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_UART1_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_UART1_CLK_SRC_SEL_S  24
/** HP_SYS_CLKRST_REG_UART1_CLK_EN : R/W; bitpos: [26]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART1_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_UART1_CLK_EN_M  (HP_SYS_CLKRST_REG_UART1_CLK_EN_V << HP_SYS_CLKRST_REG_UART1_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART1_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART1_CLK_EN_S  26

/** HP_SYS_CLKRST_PERI_CLK_CTRL112_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL112_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x70)
/** HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUM_V << HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_UART1_SCLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_UART1_SCLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_UART1_SCLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART1_SCLK_DIV_DENOMINATOR_S  16
/** HP_SYS_CLKRST_REG_UART2_CLK_SRC_SEL : R/W; bitpos: [25:24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART2_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_UART2_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_UART2_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_UART2_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_UART2_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_UART2_CLK_SRC_SEL_S  24
/** HP_SYS_CLKRST_REG_UART2_CLK_EN : R/W; bitpos: [26]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART2_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_UART2_CLK_EN_M  (HP_SYS_CLKRST_REG_UART2_CLK_EN_V << HP_SYS_CLKRST_REG_UART2_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART2_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART2_CLK_EN_S  26

/** HP_SYS_CLKRST_PERI_CLK_CTRL113_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL113_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x74)
/** HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUM_V << HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_UART2_SCLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_UART2_SCLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_UART2_SCLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART2_SCLK_DIV_DENOMINATOR_S  16
/** HP_SYS_CLKRST_REG_UART3_CLK_SRC_SEL : R/W; bitpos: [25:24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART3_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_UART3_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_UART3_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_UART3_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_UART3_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_UART3_CLK_SRC_SEL_S  24
/** HP_SYS_CLKRST_REG_UART3_CLK_EN : R/W; bitpos: [26]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART3_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_UART3_CLK_EN_M  (HP_SYS_CLKRST_REG_UART3_CLK_EN_V << HP_SYS_CLKRST_REG_UART3_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART3_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART3_CLK_EN_S  26

/** HP_SYS_CLKRST_PERI_CLK_CTRL114_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL114_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x78)
/** HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUM_V << HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_UART3_SCLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_UART3_SCLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_UART3_SCLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART3_SCLK_DIV_DENOMINATOR_S  16
/** HP_SYS_CLKRST_REG_UART4_CLK_SRC_SEL : R/W; bitpos: [25:24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART4_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_UART4_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_UART4_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_UART4_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_UART4_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_UART4_CLK_SRC_SEL_S  24
/** HP_SYS_CLKRST_REG_UART4_CLK_EN : R/W; bitpos: [26]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART4_CLK_EN    (BIT(26))
#define HP_SYS_CLKRST_REG_UART4_CLK_EN_M  (HP_SYS_CLKRST_REG_UART4_CLK_EN_V << HP_SYS_CLKRST_REG_UART4_CLK_EN_S)
#define HP_SYS_CLKRST_REG_UART4_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_UART4_CLK_EN_S  26

/** HP_SYS_CLKRST_PERI_CLK_CTRL115_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL115_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x7c)
/** HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUM_V << HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_UART4_SCLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_UART4_SCLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_UART4_SCLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_UART4_SCLK_DIV_DENOMINATOR_S  16
/** HP_SYS_CLKRST_REG_TWAI0_CLK_SRC_SEL : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI0_CLK_SRC_SEL    (BIT(24))
#define HP_SYS_CLKRST_REG_TWAI0_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_TWAI0_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_TWAI0_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TWAI0_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI0_CLK_SRC_SEL_S  24
/** HP_SYS_CLKRST_REG_TWAI0_CLK_EN : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI0_CLK_EN    (BIT(25))
#define HP_SYS_CLKRST_REG_TWAI0_CLK_EN_M  (HP_SYS_CLKRST_REG_TWAI0_CLK_EN_V << HP_SYS_CLKRST_REG_TWAI0_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TWAI0_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI0_CLK_EN_S  25
/** HP_SYS_CLKRST_REG_TWAI1_CLK_SRC_SEL : R/W; bitpos: [26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI1_CLK_SRC_SEL    (BIT(26))
#define HP_SYS_CLKRST_REG_TWAI1_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_TWAI1_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_TWAI1_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TWAI1_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI1_CLK_SRC_SEL_S  26
/** HP_SYS_CLKRST_REG_TWAI1_CLK_EN : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI1_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_TWAI1_CLK_EN_M  (HP_SYS_CLKRST_REG_TWAI1_CLK_EN_V << HP_SYS_CLKRST_REG_TWAI1_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TWAI1_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI1_CLK_EN_S  27
/** HP_SYS_CLKRST_REG_TWAI2_CLK_SRC_SEL : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI2_CLK_SRC_SEL    (BIT(28))
#define HP_SYS_CLKRST_REG_TWAI2_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_TWAI2_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_TWAI2_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TWAI2_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI2_CLK_SRC_SEL_S  28
/** HP_SYS_CLKRST_REG_TWAI2_CLK_EN : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TWAI2_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_TWAI2_CLK_EN_M  (HP_SYS_CLKRST_REG_TWAI2_CLK_EN_V << HP_SYS_CLKRST_REG_TWAI2_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TWAI2_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TWAI2_CLK_EN_S  29

/** HP_SYS_CLKRST_PERI_CLK_CTRL116_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL116_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x80)
/** HP_SYS_CLKRST_REG_GPSPI2_CLK_SRC_SEL : R/W; bitpos: [2:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI2_CLK_SRC_SEL    0x00000007U
#define HP_SYS_CLKRST_REG_GPSPI2_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_GPSPI2_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_GPSPI2_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_GPSPI2_CLK_SRC_SEL_V  0x00000007U
#define HP_SYS_CLKRST_REG_GPSPI2_CLK_SRC_SEL_S  0
/** HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_EN : R/W; bitpos: [3]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_EN    (BIT(3))
#define HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_EN_M  (HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_EN_V << HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_EN_S  3
/** HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_DIV_NUM : R/W; bitpos: [11:4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_GPSPI2_HS_CLK_DIV_NUM_S  4
/** HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_DIV_NUM : R/W; bitpos: [19:12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_DIV_NUM_S  12
/** HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_EN : R/W; bitpos: [20]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_EN    (BIT(20))
#define HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_EN_M  (HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_EN_V << HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GPSPI2_MST_CLK_EN_S  20
/** HP_SYS_CLKRST_REG_GPSPI3_CLK_SRC_SEL : R/W; bitpos: [23:21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI3_CLK_SRC_SEL    0x00000007U
#define HP_SYS_CLKRST_REG_GPSPI3_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_GPSPI3_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_GPSPI3_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_GPSPI3_CLK_SRC_SEL_V  0x00000007U
#define HP_SYS_CLKRST_REG_GPSPI3_CLK_SRC_SEL_S  21
/** HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_EN : R/W; bitpos: [24]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_EN_M  (HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_EN_V << HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_EN_S  24

/** HP_SYS_CLKRST_PERI_CLK_CTRL117_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL117_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x84)
/** HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_GPSPI3_HS_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_DIV_NUM : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_DIV_NUM_S  8
/** HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_EN : R/W; bitpos: [16]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_EN    (BIT(16))
#define HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_EN_M  (HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_EN_V << HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_EN_S)
#define HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_GPSPI3_MST_CLK_EN_S  16
/** HP_SYS_CLKRST_REG_PARLIO_RX_CLK_SRC_SEL : R/W; bitpos: [18:17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_PARLIO_RX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_PARLIO_RX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_SRC_SEL_S  17
/** HP_SYS_CLKRST_REG_PARLIO_RX_CLK_EN : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_EN    (BIT(19))
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_EN_M  (HP_SYS_CLKRST_REG_PARLIO_RX_CLK_EN_V << HP_SYS_CLKRST_REG_PARLIO_RX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_EN_S  19
/** HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUM : R/W; bitpos: [27:20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUM_S  20

/** HP_SYS_CLKRST_PERI_CLK_CTRL118_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL118_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x88)
/** HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUMERATOR : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_NUMERATOR_S  0
/** HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_DENOMINATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_RX_CLK_DIV_DENOMINATOR_S  8
/** HP_SYS_CLKRST_REG_PARLIO_TX_CLK_SRC_SEL : R/W; bitpos: [17:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_PARLIO_TX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_PARLIO_TX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_SRC_SEL_S  16
/** HP_SYS_CLKRST_REG_PARLIO_TX_CLK_EN : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_EN    (BIT(18))
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_EN_M  (HP_SYS_CLKRST_REG_PARLIO_TX_CLK_EN_V << HP_SYS_CLKRST_REG_PARLIO_TX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_EN_S  18
/** HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUM : R/W; bitpos: [26:19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUM_S  19

/** HP_SYS_CLKRST_PERI_CLK_CTRL119_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL119_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x8c)
/** HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUMERATOR : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_NUMERATOR_S  0
/** HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_DENOMINATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PARLIO_TX_CLK_DIV_DENOMINATOR_S  8
/** HP_SYS_CLKRST_REG_I3C_MST_CLK_SRC_SEL : R/W; bitpos: [17:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_I3C_MST_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_I3C_MST_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_SRC_SEL_S  16
/** HP_SYS_CLKRST_REG_I3C_MST_CLK_EN : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_EN    (BIT(18))
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_EN_M  (HP_SYS_CLKRST_REG_I3C_MST_CLK_EN_V << HP_SYS_CLKRST_REG_I3C_MST_CLK_EN_S)
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_EN_S  18
/** HP_SYS_CLKRST_REG_I3C_MST_CLK_DIV_NUM : R/W; bitpos: [26:19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_I3C_MST_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_I3C_MST_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_I3C_MST_CLK_DIV_NUM_S  19
/** HP_SYS_CLKRST_REG_CAM_CLK_SRC_SEL : R/W; bitpos: [28:27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CAM_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_CAM_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_CAM_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_CAM_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_CAM_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_CAM_CLK_SRC_SEL_S  27
/** HP_SYS_CLKRST_REG_CAM_CLK_EN : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CAM_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_CAM_CLK_EN_M  (HP_SYS_CLKRST_REG_CAM_CLK_EN_V << HP_SYS_CLKRST_REG_CAM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CAM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CAM_CLK_EN_S  29

/** HP_SYS_CLKRST_PERI_CLK_CTRL120_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL120_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x90)
/** HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUMERATOR : R/W; bitpos: [15:8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_NUMERATOR_S  8
/** HP_SYS_CLKRST_REG_CAM_CLK_DIV_DENOMINATOR : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_CAM_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_CAM_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CAM_CLK_DIV_DENOMINATOR_S  16

/** HP_SYS_CLKRST_PERI_CLK_CTRL20_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL20_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x94)
/** HP_SYS_CLKRST_REG_MCPWM0_CLK_SRC_SEL : R/W; bitpos: [1:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_MCPWM0_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_MCPWM0_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_SRC_SEL_S  0
/** HP_SYS_CLKRST_REG_MCPWM0_CLK_EN : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_EN    (BIT(2))
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_EN_M  (HP_SYS_CLKRST_REG_MCPWM0_CLK_EN_V << HP_SYS_CLKRST_REG_MCPWM0_CLK_EN_S)
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_EN_S  2
/** HP_SYS_CLKRST_REG_MCPWM0_CLK_DIV_NUM : R/W; bitpos: [10:3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_MCPWM0_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_MCPWM0_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_MCPWM0_CLK_DIV_NUM_S  3
/** HP_SYS_CLKRST_REG_MCPWM1_CLK_SRC_SEL : R/W; bitpos: [12:11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_MCPWM1_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_MCPWM1_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_SRC_SEL_S  11
/** HP_SYS_CLKRST_REG_MCPWM1_CLK_EN : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_EN    (BIT(13))
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_EN_M  (HP_SYS_CLKRST_REG_MCPWM1_CLK_EN_V << HP_SYS_CLKRST_REG_MCPWM1_CLK_EN_S)
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_EN_S  13
/** HP_SYS_CLKRST_REG_MCPWM1_CLK_DIV_NUM : R/W; bitpos: [21:14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_MCPWM1_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_MCPWM1_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_MCPWM1_CLK_DIV_NUM_S  14
/** HP_SYS_CLKRST_REG_TIMERGRP0_T0_SRC_SEL : R/W; bitpos: [23:22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_T0_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP0_T0_SRC_SEL_M  (HP_SYS_CLKRST_REG_TIMERGRP0_T0_SRC_SEL_V << HP_SYS_CLKRST_REG_TIMERGRP0_T0_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_T0_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP0_T0_SRC_SEL_S  22
/** HP_SYS_CLKRST_REG_TIMERGRP0_T0_CLK_EN : R/W; bitpos: [24]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_T0_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_TIMERGRP0_T0_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP0_T0_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP0_T0_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_T0_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP0_T0_CLK_EN_S  24
/** HP_SYS_CLKRST_REG_TIMERGRP0_T1_SRC_SEL : R/W; bitpos: [26:25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_T1_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP0_T1_SRC_SEL_M  (HP_SYS_CLKRST_REG_TIMERGRP0_T1_SRC_SEL_V << HP_SYS_CLKRST_REG_TIMERGRP0_T1_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_T1_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP0_T1_SRC_SEL_S  25
/** HP_SYS_CLKRST_REG_TIMERGRP0_T1_CLK_EN : R/W; bitpos: [27]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_T1_CLK_EN    (BIT(27))
#define HP_SYS_CLKRST_REG_TIMERGRP0_T1_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP0_T1_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP0_T1_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_T1_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP0_T1_CLK_EN_S  27
/** HP_SYS_CLKRST_REG_TIMERGRP0_WDT_SRC_SEL : R/W; bitpos: [29:28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_WDT_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP0_WDT_SRC_SEL_M  (HP_SYS_CLKRST_REG_TIMERGRP0_WDT_SRC_SEL_V << HP_SYS_CLKRST_REG_TIMERGRP0_WDT_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_WDT_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP0_WDT_SRC_SEL_S  28
/** HP_SYS_CLKRST_REG_TIMERGRP0_WDT_CLK_EN : R/W; bitpos: [30]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_WDT_CLK_EN    (BIT(30))
#define HP_SYS_CLKRST_REG_TIMERGRP0_WDT_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP0_WDT_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP0_WDT_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_WDT_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP0_WDT_CLK_EN_S  30
/** HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_EN : R/W; bitpos: [31]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_EN    (BIT(31))
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_EN_S  31

/** HP_SYS_CLKRST_PERI_CLK_CTRL21_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL21_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x98)
/** HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_SRC_SEL : R/W; bitpos: [3:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_SRC_SEL    0x0000000FU
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_SRC_SEL_V  0x0000000FU
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_SRC_SEL_S  0
/** HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_DIV_NUM : R/W; bitpos: [19:4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_DIV_NUM    0x0000FFFFU
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_DIV_NUM_V  0x0000FFFFU
#define HP_SYS_CLKRST_REG_TIMERGRP0_TGRT_CLK_DIV_NUM_S  4
/** HP_SYS_CLKRST_REG_TIMERGRP1_T0_SRC_SEL : R/W; bitpos: [21:20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP1_T0_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP1_T0_SRC_SEL_M  (HP_SYS_CLKRST_REG_TIMERGRP1_T0_SRC_SEL_V << HP_SYS_CLKRST_REG_TIMERGRP1_T0_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TIMERGRP1_T0_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP1_T0_SRC_SEL_S  20
/** HP_SYS_CLKRST_REG_TIMERGRP1_T0_CLK_EN : R/W; bitpos: [22]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP1_T0_CLK_EN    (BIT(22))
#define HP_SYS_CLKRST_REG_TIMERGRP1_T0_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP1_T0_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP1_T0_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP1_T0_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP1_T0_CLK_EN_S  22
/** HP_SYS_CLKRST_REG_TIMERGRP1_T1_SRC_SEL : R/W; bitpos: [24:23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP1_T1_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP1_T1_SRC_SEL_M  (HP_SYS_CLKRST_REG_TIMERGRP1_T1_SRC_SEL_V << HP_SYS_CLKRST_REG_TIMERGRP1_T1_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TIMERGRP1_T1_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP1_T1_SRC_SEL_S  23
/** HP_SYS_CLKRST_REG_TIMERGRP1_T1_CLK_EN : R/W; bitpos: [25]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP1_T1_CLK_EN    (BIT(25))
#define HP_SYS_CLKRST_REG_TIMERGRP1_T1_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP1_T1_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP1_T1_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP1_T1_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP1_T1_CLK_EN_S  25
/** HP_SYS_CLKRST_REG_TIMERGRP1_WDT_SRC_SEL : R/W; bitpos: [27:26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP1_WDT_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP1_WDT_SRC_SEL_M  (HP_SYS_CLKRST_REG_TIMERGRP1_WDT_SRC_SEL_V << HP_SYS_CLKRST_REG_TIMERGRP1_WDT_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_TIMERGRP1_WDT_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_TIMERGRP1_WDT_SRC_SEL_S  26
/** HP_SYS_CLKRST_REG_TIMERGRP1_WDT_CLK_EN : R/W; bitpos: [28]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TIMERGRP1_WDT_CLK_EN    (BIT(28))
#define HP_SYS_CLKRST_REG_TIMERGRP1_WDT_CLK_EN_M  (HP_SYS_CLKRST_REG_TIMERGRP1_WDT_CLK_EN_V << HP_SYS_CLKRST_REG_TIMERGRP1_WDT_CLK_EN_S)
#define HP_SYS_CLKRST_REG_TIMERGRP1_WDT_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_TIMERGRP1_WDT_CLK_EN_S  28
/** HP_SYS_CLKRST_REG_SYSTIMER_CLK_SRC_SEL : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYSTIMER_CLK_SRC_SEL    (BIT(29))
#define HP_SYS_CLKRST_REG_SYSTIMER_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_SYSTIMER_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_SYSTIMER_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_SYSTIMER_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_SYSTIMER_CLK_SRC_SEL_S  29
/** HP_SYS_CLKRST_REG_SYSTIMER_CLK_EN : R/W; bitpos: [30]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYSTIMER_CLK_EN    (BIT(30))
#define HP_SYS_CLKRST_REG_SYSTIMER_CLK_EN_M  (HP_SYS_CLKRST_REG_SYSTIMER_CLK_EN_V << HP_SYS_CLKRST_REG_SYSTIMER_CLK_EN_S)
#define HP_SYS_CLKRST_REG_SYSTIMER_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_SYSTIMER_CLK_EN_S  30

/** HP_SYS_CLKRST_PERI_CLK_CTRL22_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL22_REG (DR_REG_HP_SYS_CLKRST_BASE + 0x9c)
/** HP_SYS_CLKRST_REG_LEDC_CLK_SRC_SEL : R/W; bitpos: [1:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LEDC_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_LEDC_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_LEDC_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_LEDC_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_LEDC_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_LEDC_CLK_SRC_SEL_S  0
/** HP_SYS_CLKRST_REG_LEDC_CLK_EN : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_LEDC_CLK_EN    (BIT(2))
#define HP_SYS_CLKRST_REG_LEDC_CLK_EN_M  (HP_SYS_CLKRST_REG_LEDC_CLK_EN_V << HP_SYS_CLKRST_REG_LEDC_CLK_EN_S)
#define HP_SYS_CLKRST_REG_LEDC_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_LEDC_CLK_EN_S  2
/** HP_SYS_CLKRST_REG_RMT_CLK_SRC_SEL : R/W; bitpos: [4:3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RMT_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_RMT_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_RMT_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_RMT_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_RMT_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_RMT_CLK_SRC_SEL_S  3
/** HP_SYS_CLKRST_REG_RMT_CLK_EN : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RMT_CLK_EN    (BIT(5))
#define HP_SYS_CLKRST_REG_RMT_CLK_EN_M  (HP_SYS_CLKRST_REG_RMT_CLK_EN_V << HP_SYS_CLKRST_REG_RMT_CLK_EN_S)
#define HP_SYS_CLKRST_REG_RMT_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_RMT_CLK_EN_S  5
/** HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUM : R/W; bitpos: [13:6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUM_S  6
/** HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUMERATOR : R/W; bitpos: [21:14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_NUMERATOR_S  14
/** HP_SYS_CLKRST_REG_RMT_CLK_DIV_DENOMINATOR : R/W; bitpos: [29:22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_RMT_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_RMT_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_RMT_CLK_DIV_DENOMINATOR_S  22
/** HP_SYS_CLKRST_REG_ADC_CLK_SRC_SEL : R/W; bitpos: [31:30]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ADC_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_ADC_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_ADC_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_ADC_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_ADC_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_ADC_CLK_SRC_SEL_S  30

/** HP_SYS_CLKRST_PERI_CLK_CTRL23_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL23_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xa0)
/** HP_SYS_CLKRST_REG_ADC_CLK_EN : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ADC_CLK_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_ADC_CLK_EN_M  (HP_SYS_CLKRST_REG_ADC_CLK_EN_V << HP_SYS_CLKRST_REG_ADC_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ADC_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ADC_CLK_EN_S  0
/** HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUM : R/W; bitpos: [8:1]; default: 4;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUM_S  1
/** HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUMERATOR : R/W; bitpos: [16:9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUMERATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUMERATOR_M  (HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUMERATOR_V << HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUMERATOR_S)
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUMERATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_NUMERATOR_S  9
/** HP_SYS_CLKRST_REG_ADC_CLK_DIV_DENOMINATOR : R/W; bitpos: [24:17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_DENOMINATOR    0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_DENOMINATOR_M  (HP_SYS_CLKRST_REG_ADC_CLK_DIV_DENOMINATOR_V << HP_SYS_CLKRST_REG_ADC_CLK_DIV_DENOMINATOR_S)
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_DENOMINATOR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_CLK_DIV_DENOMINATOR_S  17

/** HP_SYS_CLKRST_PERI_CLK_CTRL24_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL24_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xa4)
/** HP_SYS_CLKRST_REG_ADC_SAR1_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 4;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ADC_SAR1_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_SAR1_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_ADC_SAR1_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_ADC_SAR1_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_ADC_SAR1_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_SAR1_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_ADC_SAR2_CLK_DIV_NUM : R/W; bitpos: [15:8]; default: 4;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ADC_SAR2_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_SAR2_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_ADC_SAR2_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_ADC_SAR2_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_ADC_SAR2_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_ADC_SAR2_CLK_DIV_NUM_S  8
/** HP_SYS_CLKRST_REG_PVT_CLK_DIV_NUM : R/W; bitpos: [23:16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PVT_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_PVT_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_PVT_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_PVT_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_PVT_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PVT_CLK_DIV_NUM_S  16
/** HP_SYS_CLKRST_REG_PVT_CLK_EN : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PVT_CLK_EN    (BIT(24))
#define HP_SYS_CLKRST_REG_PVT_CLK_EN_M  (HP_SYS_CLKRST_REG_PVT_CLK_EN_V << HP_SYS_CLKRST_REG_PVT_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PVT_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PVT_CLK_EN_S  24

/** HP_SYS_CLKRST_PERI_CLK_CTRL25_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL25_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xa8)
/** HP_SYS_CLKRST_REG_PVT_PERI_GROUP_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_PVT_PERI_GROUP_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_PVT_PERI_GROUP_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_PVT_PERI_GROUP1_CLK_EN : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP1_CLK_EN    (BIT(8))
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP1_CLK_EN_M  (HP_SYS_CLKRST_REG_PVT_PERI_GROUP1_CLK_EN_V << HP_SYS_CLKRST_REG_PVT_PERI_GROUP1_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP1_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP1_CLK_EN_S  8
/** HP_SYS_CLKRST_REG_PVT_PERI_GROUP2_CLK_EN : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP2_CLK_EN    (BIT(9))
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP2_CLK_EN_M  (HP_SYS_CLKRST_REG_PVT_PERI_GROUP2_CLK_EN_V << HP_SYS_CLKRST_REG_PVT_PERI_GROUP2_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP2_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP2_CLK_EN_S  9
/** HP_SYS_CLKRST_REG_PVT_PERI_GROUP3_CLK_EN : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP3_CLK_EN    (BIT(10))
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP3_CLK_EN_M  (HP_SYS_CLKRST_REG_PVT_PERI_GROUP3_CLK_EN_V << HP_SYS_CLKRST_REG_PVT_PERI_GROUP3_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP3_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP3_CLK_EN_S  10
/** HP_SYS_CLKRST_REG_PVT_PERI_GROUP4_CLK_EN : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP4_CLK_EN    (BIT(11))
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP4_CLK_EN_M  (HP_SYS_CLKRST_REG_PVT_PERI_GROUP4_CLK_EN_V << HP_SYS_CLKRST_REG_PVT_PERI_GROUP4_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP4_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PVT_PERI_GROUP4_CLK_EN_S  11
/** HP_SYS_CLKRST_REG_CRYPTO_CLK_SRC_SEL : R/W; bitpos: [13:12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_CRYPTO_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_CRYPTO_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_CRYPTO_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_CRYPTO_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_CRYPTO_CLK_SRC_SEL_S  12
/** HP_SYS_CLKRST_REG_CRYPTO_AES_CLK_EN : R/W; bitpos: [14]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_AES_CLK_EN    (BIT(14))
#define HP_SYS_CLKRST_REG_CRYPTO_AES_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_AES_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_AES_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_AES_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_AES_CLK_EN_S  14
/** HP_SYS_CLKRST_REG_CRYPTO_DS_CLK_EN : R/W; bitpos: [15]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_DS_CLK_EN    (BIT(15))
#define HP_SYS_CLKRST_REG_CRYPTO_DS_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_DS_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_DS_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_DS_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_DS_CLK_EN_S  15
/** HP_SYS_CLKRST_REG_CRYPTO_ECC_CLK_EN : R/W; bitpos: [16]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_ECC_CLK_EN    (BIT(16))
#define HP_SYS_CLKRST_REG_CRYPTO_ECC_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_ECC_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_ECC_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_ECC_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_ECC_CLK_EN_S  16
/** HP_SYS_CLKRST_REG_CRYPTO_HMAC_CLK_EN : R/W; bitpos: [17]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_HMAC_CLK_EN    (BIT(17))
#define HP_SYS_CLKRST_REG_CRYPTO_HMAC_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_HMAC_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_HMAC_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_HMAC_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_HMAC_CLK_EN_S  17
/** HP_SYS_CLKRST_REG_CRYPTO_RSA_CLK_EN : R/W; bitpos: [18]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_RSA_CLK_EN    (BIT(18))
#define HP_SYS_CLKRST_REG_CRYPTO_RSA_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_RSA_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_RSA_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_RSA_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_RSA_CLK_EN_S  18
/** HP_SYS_CLKRST_REG_CRYPTO_SEC_CLK_EN : R/W; bitpos: [19]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_SEC_CLK_EN    (BIT(19))
#define HP_SYS_CLKRST_REG_CRYPTO_SEC_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_SEC_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_SEC_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_SEC_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_SEC_CLK_EN_S  19
/** HP_SYS_CLKRST_REG_CRYPTO_SHA_CLK_EN : R/W; bitpos: [20]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_SHA_CLK_EN    (BIT(20))
#define HP_SYS_CLKRST_REG_CRYPTO_SHA_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_SHA_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_SHA_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_SHA_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_SHA_CLK_EN_S  20
/** HP_SYS_CLKRST_REG_CRYPTO_ECDSA_CLK_EN : R/W; bitpos: [21]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_ECDSA_CLK_EN    (BIT(21))
#define HP_SYS_CLKRST_REG_CRYPTO_ECDSA_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_ECDSA_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_ECDSA_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_ECDSA_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_ECDSA_CLK_EN_S  21
/** HP_SYS_CLKRST_REG_CRYPTO_KM_CLK_EN : R/W; bitpos: [22]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CRYPTO_KM_CLK_EN    (BIT(22))
#define HP_SYS_CLKRST_REG_CRYPTO_KM_CLK_EN_M  (HP_SYS_CLKRST_REG_CRYPTO_KM_CLK_EN_V << HP_SYS_CLKRST_REG_CRYPTO_KM_CLK_EN_S)
#define HP_SYS_CLKRST_REG_CRYPTO_KM_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_CRYPTO_KM_CLK_EN_S  22
/** HP_SYS_CLKRST_REG_ISP_CLK_SRC_SEL : R/W; bitpos: [24:23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ISP_CLK_SRC_SEL    0x00000003U
#define HP_SYS_CLKRST_REG_ISP_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_ISP_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_ISP_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_ISP_CLK_SRC_SEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_ISP_CLK_SRC_SEL_S  23
/** HP_SYS_CLKRST_REG_ISP_CLK_EN : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ISP_CLK_EN    (BIT(25))
#define HP_SYS_CLKRST_REG_ISP_CLK_EN_M  (HP_SYS_CLKRST_REG_ISP_CLK_EN_V << HP_SYS_CLKRST_REG_ISP_CLK_EN_S)
#define HP_SYS_CLKRST_REG_ISP_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_ISP_CLK_EN_S  25

/** HP_SYS_CLKRST_PERI_CLK_CTRL26_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL26_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xac)
/** HP_SYS_CLKRST_REG_ISP_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_ISP_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_ISP_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_ISP_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_ISP_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_ISP_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_ISP_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_IOMUX_CLK_SRC_SEL : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_IOMUX_CLK_SRC_SEL    (BIT(8))
#define HP_SYS_CLKRST_REG_IOMUX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_IOMUX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_IOMUX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_IOMUX_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_IOMUX_CLK_SRC_SEL_S  8
/** HP_SYS_CLKRST_REG_IOMUX_CLK_EN : R/W; bitpos: [9]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_IOMUX_CLK_EN    (BIT(9))
#define HP_SYS_CLKRST_REG_IOMUX_CLK_EN_M  (HP_SYS_CLKRST_REG_IOMUX_CLK_EN_V << HP_SYS_CLKRST_REG_IOMUX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_IOMUX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_IOMUX_CLK_EN_S  9
/** HP_SYS_CLKRST_REG_IOMUX_CLK_DIV_NUM : R/W; bitpos: [17:10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_IOMUX_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_IOMUX_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_IOMUX_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_IOMUX_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_IOMUX_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_IOMUX_CLK_DIV_NUM_S  10
/** HP_SYS_CLKRST_REG_H264_CLK_SRC_SEL : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_H264_CLK_SRC_SEL    (BIT(18))
#define HP_SYS_CLKRST_REG_H264_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_H264_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_H264_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_H264_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_H264_CLK_SRC_SEL_S  18
/** HP_SYS_CLKRST_REG_H264_CLK_EN : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_H264_CLK_EN    (BIT(19))
#define HP_SYS_CLKRST_REG_H264_CLK_EN_M  (HP_SYS_CLKRST_REG_H264_CLK_EN_V << HP_SYS_CLKRST_REG_H264_CLK_EN_S)
#define HP_SYS_CLKRST_REG_H264_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_H264_CLK_EN_S  19
/** HP_SYS_CLKRST_REG_H264_CLK_DIV_NUM : R/W; bitpos: [27:20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_H264_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_H264_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_H264_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_H264_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_H264_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_H264_CLK_DIV_NUM_S  20
/** HP_SYS_CLKRST_REG_PADBIST_RX_CLK_SRC_SEL : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_SRC_SEL    (BIT(28))
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_PADBIST_RX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_PADBIST_RX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_SRC_SEL_S  28
/** HP_SYS_CLKRST_REG_PADBIST_RX_CLK_EN : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_EN    (BIT(29))
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_EN_M  (HP_SYS_CLKRST_REG_PADBIST_RX_CLK_EN_V << HP_SYS_CLKRST_REG_PADBIST_RX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_EN_S  29

/** HP_SYS_CLKRST_PERI_CLK_CTRL27_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_PERI_CLK_CTRL27_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xb0)
/** HP_SYS_CLKRST_REG_PADBIST_RX_CLK_DIV_NUM : R/W; bitpos: [7:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_PADBIST_RX_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_PADBIST_RX_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PADBIST_RX_CLK_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_PADBIST_TX_CLK_SRC_SEL : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_SRC_SEL    (BIT(8))
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_SRC_SEL_M  (HP_SYS_CLKRST_REG_PADBIST_TX_CLK_SRC_SEL_V << HP_SYS_CLKRST_REG_PADBIST_TX_CLK_SRC_SEL_S)
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_SRC_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_SRC_SEL_S  8
/** HP_SYS_CLKRST_REG_PADBIST_TX_CLK_EN : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_EN    (BIT(9))
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_EN_M  (HP_SYS_CLKRST_REG_PADBIST_TX_CLK_EN_V << HP_SYS_CLKRST_REG_PADBIST_TX_CLK_EN_S)
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_EN_S  9
/** HP_SYS_CLKRST_REG_PADBIST_TX_CLK_DIV_NUM : R/W; bitpos: [17:10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_DIV_NUM_M  (HP_SYS_CLKRST_REG_PADBIST_TX_CLK_DIV_NUM_V << HP_SYS_CLKRST_REG_PADBIST_TX_CLK_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_PADBIST_TX_CLK_DIV_NUM_S  10

/** HP_SYS_CLKRST_CLK_FORCE_ON_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_CLK_FORCE_ON_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xb4)
/** HP_SYS_CLKRST_REG_CPUICM_GATED_CLK_FORCE_ON : R/W; bitpos: [0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CPUICM_GATED_CLK_FORCE_ON    (BIT(0))
#define HP_SYS_CLKRST_REG_CPUICM_GATED_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_CPUICM_GATED_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_CPUICM_GATED_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_CPUICM_GATED_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_CPUICM_GATED_CLK_FORCE_ON_S  0
/** HP_SYS_CLKRST_REG_TCM_CPU_CLK_FORCE_ON : R/W; bitpos: [1]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TCM_CPU_CLK_FORCE_ON    (BIT(1))
#define HP_SYS_CLKRST_REG_TCM_CPU_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_TCM_CPU_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_TCM_CPU_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_TCM_CPU_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_TCM_CPU_CLK_FORCE_ON_S  1
/** HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_FORCE_ON : R/W; bitpos: [2]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_FORCE_ON    (BIT(2))
#define HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_BUSMON_CPU_CLK_FORCE_ON_S  2
/** HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_FORCE_ON : R/W; bitpos: [3]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_FORCE_ON    (BIT(3))
#define HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_CPU_CLK_FORCE_ON_S  3
/** HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_FORCE_ON : R/W; bitpos: [4]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_FORCE_ON    (BIT(4))
#define HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_D_CPU_CLK_FORCE_ON_S  4
/** HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_FORCE_ON : R/W; bitpos: [5]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_FORCE_ON    (BIT(5))
#define HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_I0_CPU_CLK_FORCE_ON_S  5
/** HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_FORCE_ON : R/W; bitpos: [6]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_FORCE_ON    (BIT(6))
#define HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_I1_CPU_CLK_FORCE_ON_S  6
/** HP_SYS_CLKRST_REG_TRACE_CPU_CLK_FORCE_ON : R/W; bitpos: [7]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TRACE_CPU_CLK_FORCE_ON    (BIT(7))
#define HP_SYS_CLKRST_REG_TRACE_CPU_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_TRACE_CPU_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_TRACE_CPU_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_TRACE_CPU_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_TRACE_CPU_CLK_FORCE_ON_S  7
/** HP_SYS_CLKRST_REG_TRACE_SYS_CLK_FORCE_ON : R/W; bitpos: [8]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_TRACE_SYS_CLK_FORCE_ON    (BIT(8))
#define HP_SYS_CLKRST_REG_TRACE_SYS_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_TRACE_SYS_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_TRACE_SYS_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_TRACE_SYS_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_TRACE_SYS_CLK_FORCE_ON_S  8
/** HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_FORCE_ON : R/W; bitpos: [9]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_FORCE_ON    (BIT(9))
#define HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_MEM_CLK_FORCE_ON_S  9
/** HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_FORCE_ON : R/W; bitpos: [10]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_FORCE_ON    (BIT(10))
#define HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_D_MEM_CLK_FORCE_ON_S  10
/** HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_FORCE_ON : R/W; bitpos: [11]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_FORCE_ON    (BIT(11))
#define HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_I0_MEM_CLK_FORCE_ON_S  11
/** HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_FORCE_ON : R/W; bitpos: [12]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_FORCE_ON    (BIT(12))
#define HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L1CACHE_I1_MEM_CLK_FORCE_ON_S  12
/** HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_FORCE_ON : R/W; bitpos: [13]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_FORCE_ON    (BIT(13))
#define HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L2CACHE_MEM_CLK_FORCE_ON_S  13
/** HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_FORCE_ON : R/W; bitpos: [14]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_FORCE_ON    (BIT(14))
#define HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_L2MEM_MEM_CLK_FORCE_ON_S  14
/** HP_SYS_CLKRST_REG_SAR1_CLK_FORCE_ON : R/W; bitpos: [15]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SAR1_CLK_FORCE_ON    (BIT(15))
#define HP_SYS_CLKRST_REG_SAR1_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_SAR1_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_SAR1_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_SAR1_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_SAR1_CLK_FORCE_ON_S  15
/** HP_SYS_CLKRST_REG_SAR2_CLK_FORCE_ON : R/W; bitpos: [16]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SAR2_CLK_FORCE_ON    (BIT(16))
#define HP_SYS_CLKRST_REG_SAR2_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_SAR2_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_SAR2_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_SAR2_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_SAR2_CLK_FORCE_ON_S  16
/** HP_SYS_CLKRST_REG_GMAC_TX_CLK_FORCE_ON : R/W; bitpos: [17]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_GMAC_TX_CLK_FORCE_ON    (BIT(17))
#define HP_SYS_CLKRST_REG_GMAC_TX_CLK_FORCE_ON_M  (HP_SYS_CLKRST_REG_GMAC_TX_CLK_FORCE_ON_V << HP_SYS_CLKRST_REG_GMAC_TX_CLK_FORCE_ON_S)
#define HP_SYS_CLKRST_REG_GMAC_TX_CLK_FORCE_ON_V  0x00000001U
#define HP_SYS_CLKRST_REG_GMAC_TX_CLK_FORCE_ON_S  17

/** HP_SYS_CLKRST_DPA_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_DPA_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xb8)
/** HP_SYS_CLKRST_REG_SEC_DPA_LEVEL : R/W; bitpos: [1:0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SEC_DPA_LEVEL    0x00000003U
#define HP_SYS_CLKRST_REG_SEC_DPA_LEVEL_M  (HP_SYS_CLKRST_REG_SEC_DPA_LEVEL_V << HP_SYS_CLKRST_REG_SEC_DPA_LEVEL_S)
#define HP_SYS_CLKRST_REG_SEC_DPA_LEVEL_V  0x00000003U
#define HP_SYS_CLKRST_REG_SEC_DPA_LEVEL_S  0
/** HP_SYS_CLKRST_REG_SEC_DPA_CFG_SEL : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SEC_DPA_CFG_SEL    (BIT(2))
#define HP_SYS_CLKRST_REG_SEC_DPA_CFG_SEL_M  (HP_SYS_CLKRST_REG_SEC_DPA_CFG_SEL_V << HP_SYS_CLKRST_REG_SEC_DPA_CFG_SEL_S)
#define HP_SYS_CLKRST_REG_SEC_DPA_CFG_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_SEC_DPA_CFG_SEL_S  2

/** HP_SYS_CLKRST_ANA_PLL_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_ANA_PLL_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xbc)
/** HP_SYS_CLKRST_REG_PLLA_CAL_END : RO; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PLLA_CAL_END    (BIT(0))
#define HP_SYS_CLKRST_REG_PLLA_CAL_END_M  (HP_SYS_CLKRST_REG_PLLA_CAL_END_V << HP_SYS_CLKRST_REG_PLLA_CAL_END_S)
#define HP_SYS_CLKRST_REG_PLLA_CAL_END_V  0x00000001U
#define HP_SYS_CLKRST_REG_PLLA_CAL_END_S  0
/** HP_SYS_CLKRST_REG_PLLA_CAL_STOP : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_PLLA_CAL_STOP    (BIT(1))
#define HP_SYS_CLKRST_REG_PLLA_CAL_STOP_M  (HP_SYS_CLKRST_REG_PLLA_CAL_STOP_V << HP_SYS_CLKRST_REG_PLLA_CAL_STOP_S)
#define HP_SYS_CLKRST_REG_PLLA_CAL_STOP_V  0x00000001U
#define HP_SYS_CLKRST_REG_PLLA_CAL_STOP_S  1
/** HP_SYS_CLKRST_REG_CPU_PLL_CAL_END : RO; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CPU_PLL_CAL_END    (BIT(2))
#define HP_SYS_CLKRST_REG_CPU_PLL_CAL_END_M  (HP_SYS_CLKRST_REG_CPU_PLL_CAL_END_V << HP_SYS_CLKRST_REG_CPU_PLL_CAL_END_S)
#define HP_SYS_CLKRST_REG_CPU_PLL_CAL_END_V  0x00000001U
#define HP_SYS_CLKRST_REG_CPU_PLL_CAL_END_S  2
/** HP_SYS_CLKRST_REG_CPU_PLL_CAL_STOP : R/W; bitpos: [3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_CPU_PLL_CAL_STOP    (BIT(3))
#define HP_SYS_CLKRST_REG_CPU_PLL_CAL_STOP_M  (HP_SYS_CLKRST_REG_CPU_PLL_CAL_STOP_V << HP_SYS_CLKRST_REG_CPU_PLL_CAL_STOP_S)
#define HP_SYS_CLKRST_REG_CPU_PLL_CAL_STOP_V  0x00000001U
#define HP_SYS_CLKRST_REG_CPU_PLL_CAL_STOP_S  3
/** HP_SYS_CLKRST_REG_SDIO_PLL_CAL_END : RO; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_PLL_CAL_END    (BIT(4))
#define HP_SYS_CLKRST_REG_SDIO_PLL_CAL_END_M  (HP_SYS_CLKRST_REG_SDIO_PLL_CAL_END_V << HP_SYS_CLKRST_REG_SDIO_PLL_CAL_END_S)
#define HP_SYS_CLKRST_REG_SDIO_PLL_CAL_END_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_PLL_CAL_END_S  4
/** HP_SYS_CLKRST_REG_SDIO_PLL_CAL_STOP : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SDIO_PLL_CAL_STOP    (BIT(5))
#define HP_SYS_CLKRST_REG_SDIO_PLL_CAL_STOP_M  (HP_SYS_CLKRST_REG_SDIO_PLL_CAL_STOP_V << HP_SYS_CLKRST_REG_SDIO_PLL_CAL_STOP_S)
#define HP_SYS_CLKRST_REG_SDIO_PLL_CAL_STOP_V  0x00000001U
#define HP_SYS_CLKRST_REG_SDIO_PLL_CAL_STOP_S  5
/** HP_SYS_CLKRST_REG_SYS_PLL_CAL_END : RO; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYS_PLL_CAL_END    (BIT(6))
#define HP_SYS_CLKRST_REG_SYS_PLL_CAL_END_M  (HP_SYS_CLKRST_REG_SYS_PLL_CAL_END_V << HP_SYS_CLKRST_REG_SYS_PLL_CAL_END_S)
#define HP_SYS_CLKRST_REG_SYS_PLL_CAL_END_V  0x00000001U
#define HP_SYS_CLKRST_REG_SYS_PLL_CAL_END_S  6
/** HP_SYS_CLKRST_REG_SYS_PLL_CAL_STOP : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_SYS_PLL_CAL_STOP    (BIT(7))
#define HP_SYS_CLKRST_REG_SYS_PLL_CAL_STOP_M  (HP_SYS_CLKRST_REG_SYS_PLL_CAL_STOP_V << HP_SYS_CLKRST_REG_SYS_PLL_CAL_STOP_S)
#define HP_SYS_CLKRST_REG_SYS_PLL_CAL_STOP_V  0x00000001U
#define HP_SYS_CLKRST_REG_SYS_PLL_CAL_STOP_S  7
/** HP_SYS_CLKRST_REG_MSPI_CAL_END : RO; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MSPI_CAL_END    (BIT(8))
#define HP_SYS_CLKRST_REG_MSPI_CAL_END_M  (HP_SYS_CLKRST_REG_MSPI_CAL_END_V << HP_SYS_CLKRST_REG_MSPI_CAL_END_S)
#define HP_SYS_CLKRST_REG_MSPI_CAL_END_V  0x00000001U
#define HP_SYS_CLKRST_REG_MSPI_CAL_END_S  8
/** HP_SYS_CLKRST_REG_MSPI_CAL_STOP : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_MSPI_CAL_STOP    (BIT(9))
#define HP_SYS_CLKRST_REG_MSPI_CAL_STOP_M  (HP_SYS_CLKRST_REG_MSPI_CAL_STOP_V << HP_SYS_CLKRST_REG_MSPI_CAL_STOP_S)
#define HP_SYS_CLKRST_REG_MSPI_CAL_STOP_V  0x00000001U
#define HP_SYS_CLKRST_REG_MSPI_CAL_STOP_S  9

/** HP_SYS_CLKRST_HP_RST_EN0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_HP_RST_EN0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xc0)
/** HP_SYS_CLKRST_REG_RST_EN_CORECTRL : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_CORECTRL    (BIT(0))
#define HP_SYS_CLKRST_REG_RST_EN_CORECTRL_M  (HP_SYS_CLKRST_REG_RST_EN_CORECTRL_V << HP_SYS_CLKRST_REG_RST_EN_CORECTRL_S)
#define HP_SYS_CLKRST_REG_RST_EN_CORECTRL_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_CORECTRL_S  0
/** HP_SYS_CLKRST_REG_RST_EN_PVT_TOP : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PVT_TOP    (BIT(1))
#define HP_SYS_CLKRST_REG_RST_EN_PVT_TOP_M  (HP_SYS_CLKRST_REG_RST_EN_PVT_TOP_V << HP_SYS_CLKRST_REG_RST_EN_PVT_TOP_S)
#define HP_SYS_CLKRST_REG_RST_EN_PVT_TOP_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PVT_TOP_S  1
/** HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP1 : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP1    (BIT(2))
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP1_M  (HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP1_V << HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP1_S)
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP1_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP1_S  2
/** HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP2 : R/W; bitpos: [3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP2    (BIT(3))
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP2_M  (HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP2_V << HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP2_S)
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP2_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP2_S  3
/** HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP3 : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP3    (BIT(4))
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP3_M  (HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP3_V << HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP3_S)
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP3_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP3_S  4
/** HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP4 : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP4    (BIT(5))
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP4_M  (HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP4_V << HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP4_S)
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP4_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PVT_PERI_GROUP4_S  5
/** HP_SYS_CLKRST_REG_RST_EN_REGDMA : R/W; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_REGDMA    (BIT(6))
#define HP_SYS_CLKRST_REG_RST_EN_REGDMA_M  (HP_SYS_CLKRST_REG_RST_EN_REGDMA_V << HP_SYS_CLKRST_REG_RST_EN_REGDMA_S)
#define HP_SYS_CLKRST_REG_RST_EN_REGDMA_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_REGDMA_S  6
/** HP_SYS_CLKRST_REG_RST_EN_CORE0_GLOBAL : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_CORE0_GLOBAL    (BIT(7))
#define HP_SYS_CLKRST_REG_RST_EN_CORE0_GLOBAL_M  (HP_SYS_CLKRST_REG_RST_EN_CORE0_GLOBAL_V << HP_SYS_CLKRST_REG_RST_EN_CORE0_GLOBAL_S)
#define HP_SYS_CLKRST_REG_RST_EN_CORE0_GLOBAL_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_CORE0_GLOBAL_S  7
/** HP_SYS_CLKRST_REG_RST_EN_CORE1_GLOBAL : R/W; bitpos: [8]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_CORE1_GLOBAL    (BIT(8))
#define HP_SYS_CLKRST_REG_RST_EN_CORE1_GLOBAL_M  (HP_SYS_CLKRST_REG_RST_EN_CORE1_GLOBAL_V << HP_SYS_CLKRST_REG_RST_EN_CORE1_GLOBAL_S)
#define HP_SYS_CLKRST_REG_RST_EN_CORE1_GLOBAL_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_CORE1_GLOBAL_S  8
/** HP_SYS_CLKRST_REG_RST_EN_CORETRACE0 : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_CORETRACE0    (BIT(9))
#define HP_SYS_CLKRST_REG_RST_EN_CORETRACE0_M  (HP_SYS_CLKRST_REG_RST_EN_CORETRACE0_V << HP_SYS_CLKRST_REG_RST_EN_CORETRACE0_S)
#define HP_SYS_CLKRST_REG_RST_EN_CORETRACE0_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_CORETRACE0_S  9
/** HP_SYS_CLKRST_REG_RST_EN_CORETRACE1 : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_CORETRACE1    (BIT(10))
#define HP_SYS_CLKRST_REG_RST_EN_CORETRACE1_M  (HP_SYS_CLKRST_REG_RST_EN_CORETRACE1_V << HP_SYS_CLKRST_REG_RST_EN_CORETRACE1_S)
#define HP_SYS_CLKRST_REG_RST_EN_CORETRACE1_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_CORETRACE1_S  10
/** HP_SYS_CLKRST_REG_RST_EN_HP_TCM : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_HP_TCM    (BIT(11))
#define HP_SYS_CLKRST_REG_RST_EN_HP_TCM_M  (HP_SYS_CLKRST_REG_RST_EN_HP_TCM_V << HP_SYS_CLKRST_REG_RST_EN_HP_TCM_S)
#define HP_SYS_CLKRST_REG_RST_EN_HP_TCM_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_HP_TCM_S  11
/** HP_SYS_CLKRST_REG_RST_EN_HP_CACHE : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_HP_CACHE    (BIT(12))
#define HP_SYS_CLKRST_REG_RST_EN_HP_CACHE_M  (HP_SYS_CLKRST_REG_RST_EN_HP_CACHE_V << HP_SYS_CLKRST_REG_RST_EN_HP_CACHE_S)
#define HP_SYS_CLKRST_REG_RST_EN_HP_CACHE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_HP_CACHE_S  12
/** HP_SYS_CLKRST_REG_RST_EN_L1_I0_CACHE : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_L1_I0_CACHE    (BIT(13))
#define HP_SYS_CLKRST_REG_RST_EN_L1_I0_CACHE_M  (HP_SYS_CLKRST_REG_RST_EN_L1_I0_CACHE_V << HP_SYS_CLKRST_REG_RST_EN_L1_I0_CACHE_S)
#define HP_SYS_CLKRST_REG_RST_EN_L1_I0_CACHE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_L1_I0_CACHE_S  13
/** HP_SYS_CLKRST_REG_RST_EN_L1_I1_CACHE : R/W; bitpos: [14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_L1_I1_CACHE    (BIT(14))
#define HP_SYS_CLKRST_REG_RST_EN_L1_I1_CACHE_M  (HP_SYS_CLKRST_REG_RST_EN_L1_I1_CACHE_V << HP_SYS_CLKRST_REG_RST_EN_L1_I1_CACHE_S)
#define HP_SYS_CLKRST_REG_RST_EN_L1_I1_CACHE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_L1_I1_CACHE_S  14
/** HP_SYS_CLKRST_REG_RST_EN_L1_D_CACHE : R/W; bitpos: [15]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_L1_D_CACHE    (BIT(15))
#define HP_SYS_CLKRST_REG_RST_EN_L1_D_CACHE_M  (HP_SYS_CLKRST_REG_RST_EN_L1_D_CACHE_V << HP_SYS_CLKRST_REG_RST_EN_L1_D_CACHE_S)
#define HP_SYS_CLKRST_REG_RST_EN_L1_D_CACHE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_L1_D_CACHE_S  15
/** HP_SYS_CLKRST_REG_RST_EN_L2_CACHE : R/W; bitpos: [16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_L2_CACHE    (BIT(16))
#define HP_SYS_CLKRST_REG_RST_EN_L2_CACHE_M  (HP_SYS_CLKRST_REG_RST_EN_L2_CACHE_V << HP_SYS_CLKRST_REG_RST_EN_L2_CACHE_S)
#define HP_SYS_CLKRST_REG_RST_EN_L2_CACHE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_L2_CACHE_S  16
/** HP_SYS_CLKRST_REG_RST_EN_L2_MEM : R/W; bitpos: [17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_L2_MEM    (BIT(17))
#define HP_SYS_CLKRST_REG_RST_EN_L2_MEM_M  (HP_SYS_CLKRST_REG_RST_EN_L2_MEM_V << HP_SYS_CLKRST_REG_RST_EN_L2_MEM_S)
#define HP_SYS_CLKRST_REG_RST_EN_L2_MEM_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_L2_MEM_S  17
/** HP_SYS_CLKRST_REG_RST_EN_L2MEMMON : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_L2MEMMON    (BIT(18))
#define HP_SYS_CLKRST_REG_RST_EN_L2MEMMON_M  (HP_SYS_CLKRST_REG_RST_EN_L2MEMMON_V << HP_SYS_CLKRST_REG_RST_EN_L2MEMMON_S)
#define HP_SYS_CLKRST_REG_RST_EN_L2MEMMON_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_L2MEMMON_S  18
/** HP_SYS_CLKRST_REG_RST_EN_TCMMON : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_TCMMON    (BIT(19))
#define HP_SYS_CLKRST_REG_RST_EN_TCMMON_M  (HP_SYS_CLKRST_REG_RST_EN_TCMMON_V << HP_SYS_CLKRST_REG_RST_EN_TCMMON_S)
#define HP_SYS_CLKRST_REG_RST_EN_TCMMON_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_TCMMON_S  19
/** HP_SYS_CLKRST_REG_RST_EN_PVT_APB : R/W; bitpos: [20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PVT_APB    (BIT(20))
#define HP_SYS_CLKRST_REG_RST_EN_PVT_APB_M  (HP_SYS_CLKRST_REG_RST_EN_PVT_APB_V << HP_SYS_CLKRST_REG_RST_EN_PVT_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_PVT_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PVT_APB_S  20
/** HP_SYS_CLKRST_REG_RST_EN_GDMA : R/W; bitpos: [21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_GDMA    (BIT(21))
#define HP_SYS_CLKRST_REG_RST_EN_GDMA_M  (HP_SYS_CLKRST_REG_RST_EN_GDMA_V << HP_SYS_CLKRST_REG_RST_EN_GDMA_S)
#define HP_SYS_CLKRST_REG_RST_EN_GDMA_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_GDMA_S  21
/** HP_SYS_CLKRST_REG_RST_EN_MSPI_AXI : R/W; bitpos: [22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_MSPI_AXI    (BIT(22))
#define HP_SYS_CLKRST_REG_RST_EN_MSPI_AXI_M  (HP_SYS_CLKRST_REG_RST_EN_MSPI_AXI_V << HP_SYS_CLKRST_REG_RST_EN_MSPI_AXI_S)
#define HP_SYS_CLKRST_REG_RST_EN_MSPI_AXI_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_MSPI_AXI_S  22
/** HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_AXI : R/W; bitpos: [23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_AXI    (BIT(23))
#define HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_AXI_M  (HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_AXI_V << HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_AXI_S)
#define HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_AXI_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_AXI_S  23
/** HP_SYS_CLKRST_REG_RST_EN_MSPI_APB : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_MSPI_APB    (BIT(24))
#define HP_SYS_CLKRST_REG_RST_EN_MSPI_APB_M  (HP_SYS_CLKRST_REG_RST_EN_MSPI_APB_V << HP_SYS_CLKRST_REG_RST_EN_MSPI_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_MSPI_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_MSPI_APB_S  24
/** HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_APB : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_APB    (BIT(25))
#define HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_APB_M  (HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_APB_V << HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_DUAL_MSPI_APB_S  25
/** HP_SYS_CLKRST_REG_RST_EN_DSI_BRG : R/W; bitpos: [26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_DSI_BRG    (BIT(26))
#define HP_SYS_CLKRST_REG_RST_EN_DSI_BRG_M  (HP_SYS_CLKRST_REG_RST_EN_DSI_BRG_V << HP_SYS_CLKRST_REG_RST_EN_DSI_BRG_S)
#define HP_SYS_CLKRST_REG_RST_EN_DSI_BRG_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_DSI_BRG_S  26
/** HP_SYS_CLKRST_REG_RST_EN_CSI_HOST : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_CSI_HOST    (BIT(27))
#define HP_SYS_CLKRST_REG_RST_EN_CSI_HOST_M  (HP_SYS_CLKRST_REG_RST_EN_CSI_HOST_V << HP_SYS_CLKRST_REG_RST_EN_CSI_HOST_S)
#define HP_SYS_CLKRST_REG_RST_EN_CSI_HOST_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_CSI_HOST_S  27
/** HP_SYS_CLKRST_REG_RST_EN_CSI_BRG : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_CSI_BRG    (BIT(28))
#define HP_SYS_CLKRST_REG_RST_EN_CSI_BRG_M  (HP_SYS_CLKRST_REG_RST_EN_CSI_BRG_V << HP_SYS_CLKRST_REG_RST_EN_CSI_BRG_S)
#define HP_SYS_CLKRST_REG_RST_EN_CSI_BRG_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_CSI_BRG_S  28
/** HP_SYS_CLKRST_REG_RST_EN_ISP : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_ISP    (BIT(29))
#define HP_SYS_CLKRST_REG_RST_EN_ISP_M  (HP_SYS_CLKRST_REG_RST_EN_ISP_V << HP_SYS_CLKRST_REG_RST_EN_ISP_S)
#define HP_SYS_CLKRST_REG_RST_EN_ISP_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_ISP_S  29
/** HP_SYS_CLKRST_REG_RST_EN_JPEG : R/W; bitpos: [30]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_JPEG    (BIT(30))
#define HP_SYS_CLKRST_REG_RST_EN_JPEG_M  (HP_SYS_CLKRST_REG_RST_EN_JPEG_V << HP_SYS_CLKRST_REG_RST_EN_JPEG_S)
#define HP_SYS_CLKRST_REG_RST_EN_JPEG_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_JPEG_S  30
/** HP_SYS_CLKRST_REG_RST_EN_DMA2D : R/W; bitpos: [31]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_DMA2D    (BIT(31))
#define HP_SYS_CLKRST_REG_RST_EN_DMA2D_M  (HP_SYS_CLKRST_REG_RST_EN_DMA2D_V << HP_SYS_CLKRST_REG_RST_EN_DMA2D_S)
#define HP_SYS_CLKRST_REG_RST_EN_DMA2D_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_DMA2D_S  31

/** HP_SYS_CLKRST_HP_RST_EN1_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_HP_RST_EN1_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xc4)
/** HP_SYS_CLKRST_REG_RST_EN_PPA : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PPA    (BIT(0))
#define HP_SYS_CLKRST_REG_RST_EN_PPA_M  (HP_SYS_CLKRST_REG_RST_EN_PPA_V << HP_SYS_CLKRST_REG_RST_EN_PPA_S)
#define HP_SYS_CLKRST_REG_RST_EN_PPA_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PPA_S  0
/** HP_SYS_CLKRST_REG_RST_EN_AHB_PDMA : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_AHB_PDMA    (BIT(1))
#define HP_SYS_CLKRST_REG_RST_EN_AHB_PDMA_M  (HP_SYS_CLKRST_REG_RST_EN_AHB_PDMA_V << HP_SYS_CLKRST_REG_RST_EN_AHB_PDMA_S)
#define HP_SYS_CLKRST_REG_RST_EN_AHB_PDMA_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_AHB_PDMA_S  1
/** HP_SYS_CLKRST_REG_RST_EN_AXI_PDMA : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_AXI_PDMA    (BIT(2))
#define HP_SYS_CLKRST_REG_RST_EN_AXI_PDMA_M  (HP_SYS_CLKRST_REG_RST_EN_AXI_PDMA_V << HP_SYS_CLKRST_REG_RST_EN_AXI_PDMA_S)
#define HP_SYS_CLKRST_REG_RST_EN_AXI_PDMA_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_AXI_PDMA_S  2
/** HP_SYS_CLKRST_REG_RST_EN_IOMUX : R/W; bitpos: [3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_IOMUX    (BIT(3))
#define HP_SYS_CLKRST_REG_RST_EN_IOMUX_M  (HP_SYS_CLKRST_REG_RST_EN_IOMUX_V << HP_SYS_CLKRST_REG_RST_EN_IOMUX_S)
#define HP_SYS_CLKRST_REG_RST_EN_IOMUX_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_IOMUX_S  3
/** HP_SYS_CLKRST_REG_RST_EN_PADBIST : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PADBIST    (BIT(4))
#define HP_SYS_CLKRST_REG_RST_EN_PADBIST_M  (HP_SYS_CLKRST_REG_RST_EN_PADBIST_V << HP_SYS_CLKRST_REG_RST_EN_PADBIST_S)
#define HP_SYS_CLKRST_REG_RST_EN_PADBIST_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PADBIST_S  4
/** HP_SYS_CLKRST_REG_RST_EN_STIMER : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_STIMER    (BIT(5))
#define HP_SYS_CLKRST_REG_RST_EN_STIMER_M  (HP_SYS_CLKRST_REG_RST_EN_STIMER_V << HP_SYS_CLKRST_REG_RST_EN_STIMER_S)
#define HP_SYS_CLKRST_REG_RST_EN_STIMER_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_STIMER_S  5
/** HP_SYS_CLKRST_REG_RST_EN_TIMERGRP0 : R/W; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_TIMERGRP0    (BIT(6))
#define HP_SYS_CLKRST_REG_RST_EN_TIMERGRP0_M  (HP_SYS_CLKRST_REG_RST_EN_TIMERGRP0_V << HP_SYS_CLKRST_REG_RST_EN_TIMERGRP0_S)
#define HP_SYS_CLKRST_REG_RST_EN_TIMERGRP0_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_TIMERGRP0_S  6
/** HP_SYS_CLKRST_REG_RST_EN_TIMERGRP1 : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_TIMERGRP1    (BIT(7))
#define HP_SYS_CLKRST_REG_RST_EN_TIMERGRP1_M  (HP_SYS_CLKRST_REG_RST_EN_TIMERGRP1_V << HP_SYS_CLKRST_REG_RST_EN_TIMERGRP1_S)
#define HP_SYS_CLKRST_REG_RST_EN_TIMERGRP1_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_TIMERGRP1_S  7
/** HP_SYS_CLKRST_REG_RST_EN_UART0_CORE : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART0_CORE    (BIT(8))
#define HP_SYS_CLKRST_REG_RST_EN_UART0_CORE_M  (HP_SYS_CLKRST_REG_RST_EN_UART0_CORE_V << HP_SYS_CLKRST_REG_RST_EN_UART0_CORE_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART0_CORE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART0_CORE_S  8
/** HP_SYS_CLKRST_REG_RST_EN_UART1_CORE : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART1_CORE    (BIT(9))
#define HP_SYS_CLKRST_REG_RST_EN_UART1_CORE_M  (HP_SYS_CLKRST_REG_RST_EN_UART1_CORE_V << HP_SYS_CLKRST_REG_RST_EN_UART1_CORE_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART1_CORE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART1_CORE_S  9
/** HP_SYS_CLKRST_REG_RST_EN_UART2_CORE : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART2_CORE    (BIT(10))
#define HP_SYS_CLKRST_REG_RST_EN_UART2_CORE_M  (HP_SYS_CLKRST_REG_RST_EN_UART2_CORE_V << HP_SYS_CLKRST_REG_RST_EN_UART2_CORE_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART2_CORE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART2_CORE_S  10
/** HP_SYS_CLKRST_REG_RST_EN_UART3_CORE : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART3_CORE    (BIT(11))
#define HP_SYS_CLKRST_REG_RST_EN_UART3_CORE_M  (HP_SYS_CLKRST_REG_RST_EN_UART3_CORE_V << HP_SYS_CLKRST_REG_RST_EN_UART3_CORE_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART3_CORE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART3_CORE_S  11
/** HP_SYS_CLKRST_REG_RST_EN_UART4_CORE : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART4_CORE    (BIT(12))
#define HP_SYS_CLKRST_REG_RST_EN_UART4_CORE_M  (HP_SYS_CLKRST_REG_RST_EN_UART4_CORE_V << HP_SYS_CLKRST_REG_RST_EN_UART4_CORE_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART4_CORE_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART4_CORE_S  12
/** HP_SYS_CLKRST_REG_RST_EN_UART0_APB : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART0_APB    (BIT(13))
#define HP_SYS_CLKRST_REG_RST_EN_UART0_APB_M  (HP_SYS_CLKRST_REG_RST_EN_UART0_APB_V << HP_SYS_CLKRST_REG_RST_EN_UART0_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART0_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART0_APB_S  13
/** HP_SYS_CLKRST_REG_RST_EN_UART1_APB : R/W; bitpos: [14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART1_APB    (BIT(14))
#define HP_SYS_CLKRST_REG_RST_EN_UART1_APB_M  (HP_SYS_CLKRST_REG_RST_EN_UART1_APB_V << HP_SYS_CLKRST_REG_RST_EN_UART1_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART1_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART1_APB_S  14
/** HP_SYS_CLKRST_REG_RST_EN_UART2_APB : R/W; bitpos: [15]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART2_APB    (BIT(15))
#define HP_SYS_CLKRST_REG_RST_EN_UART2_APB_M  (HP_SYS_CLKRST_REG_RST_EN_UART2_APB_V << HP_SYS_CLKRST_REG_RST_EN_UART2_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART2_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART2_APB_S  15
/** HP_SYS_CLKRST_REG_RST_EN_UART3_APB : R/W; bitpos: [16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART3_APB    (BIT(16))
#define HP_SYS_CLKRST_REG_RST_EN_UART3_APB_M  (HP_SYS_CLKRST_REG_RST_EN_UART3_APB_V << HP_SYS_CLKRST_REG_RST_EN_UART3_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART3_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART3_APB_S  16
/** HP_SYS_CLKRST_REG_RST_EN_UART4_APB : R/W; bitpos: [17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UART4_APB    (BIT(17))
#define HP_SYS_CLKRST_REG_RST_EN_UART4_APB_M  (HP_SYS_CLKRST_REG_RST_EN_UART4_APB_V << HP_SYS_CLKRST_REG_RST_EN_UART4_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_UART4_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UART4_APB_S  17
/** HP_SYS_CLKRST_REG_RST_EN_UHCI : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_UHCI    (BIT(18))
#define HP_SYS_CLKRST_REG_RST_EN_UHCI_M  (HP_SYS_CLKRST_REG_RST_EN_UHCI_V << HP_SYS_CLKRST_REG_RST_EN_UHCI_S)
#define HP_SYS_CLKRST_REG_RST_EN_UHCI_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_UHCI_S  18
/** HP_SYS_CLKRST_REG_RST_EN_I3CMST : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_I3CMST    (BIT(19))
#define HP_SYS_CLKRST_REG_RST_EN_I3CMST_M  (HP_SYS_CLKRST_REG_RST_EN_I3CMST_V << HP_SYS_CLKRST_REG_RST_EN_I3CMST_S)
#define HP_SYS_CLKRST_REG_RST_EN_I3CMST_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_I3CMST_S  19
/** HP_SYS_CLKRST_REG_RST_EN_I3CSLV : R/W; bitpos: [20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_I3CSLV    (BIT(20))
#define HP_SYS_CLKRST_REG_RST_EN_I3CSLV_M  (HP_SYS_CLKRST_REG_RST_EN_I3CSLV_V << HP_SYS_CLKRST_REG_RST_EN_I3CSLV_S)
#define HP_SYS_CLKRST_REG_RST_EN_I3CSLV_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_I3CSLV_S  20
/** HP_SYS_CLKRST_REG_RST_EN_I2C1 : R/W; bitpos: [21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_I2C1    (BIT(21))
#define HP_SYS_CLKRST_REG_RST_EN_I2C1_M  (HP_SYS_CLKRST_REG_RST_EN_I2C1_V << HP_SYS_CLKRST_REG_RST_EN_I2C1_S)
#define HP_SYS_CLKRST_REG_RST_EN_I2C1_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_I2C1_S  21
/** HP_SYS_CLKRST_REG_RST_EN_I2C0 : R/W; bitpos: [22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_I2C0    (BIT(22))
#define HP_SYS_CLKRST_REG_RST_EN_I2C0_M  (HP_SYS_CLKRST_REG_RST_EN_I2C0_V << HP_SYS_CLKRST_REG_RST_EN_I2C0_S)
#define HP_SYS_CLKRST_REG_RST_EN_I2C0_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_I2C0_S  22
/** HP_SYS_CLKRST_REG_RST_EN_RMT : R/W; bitpos: [23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_RMT    (BIT(23))
#define HP_SYS_CLKRST_REG_RST_EN_RMT_M  (HP_SYS_CLKRST_REG_RST_EN_RMT_V << HP_SYS_CLKRST_REG_RST_EN_RMT_S)
#define HP_SYS_CLKRST_REG_RST_EN_RMT_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_RMT_S  23
/** HP_SYS_CLKRST_REG_RST_EN_PWM0 : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PWM0    (BIT(24))
#define HP_SYS_CLKRST_REG_RST_EN_PWM0_M  (HP_SYS_CLKRST_REG_RST_EN_PWM0_V << HP_SYS_CLKRST_REG_RST_EN_PWM0_S)
#define HP_SYS_CLKRST_REG_RST_EN_PWM0_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PWM0_S  24
/** HP_SYS_CLKRST_REG_RST_EN_PWM1 : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PWM1    (BIT(25))
#define HP_SYS_CLKRST_REG_RST_EN_PWM1_M  (HP_SYS_CLKRST_REG_RST_EN_PWM1_V << HP_SYS_CLKRST_REG_RST_EN_PWM1_S)
#define HP_SYS_CLKRST_REG_RST_EN_PWM1_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PWM1_S  25
/** HP_SYS_CLKRST_REG_RST_EN_TWAI0 : R/W; bitpos: [26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_TWAI0    (BIT(26))
#define HP_SYS_CLKRST_REG_RST_EN_TWAI0_M  (HP_SYS_CLKRST_REG_RST_EN_TWAI0_V << HP_SYS_CLKRST_REG_RST_EN_TWAI0_S)
#define HP_SYS_CLKRST_REG_RST_EN_TWAI0_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_TWAI0_S  26
/** HP_SYS_CLKRST_REG_RST_EN_TWAI1 : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_TWAI1    (BIT(27))
#define HP_SYS_CLKRST_REG_RST_EN_TWAI1_M  (HP_SYS_CLKRST_REG_RST_EN_TWAI1_V << HP_SYS_CLKRST_REG_RST_EN_TWAI1_S)
#define HP_SYS_CLKRST_REG_RST_EN_TWAI1_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_TWAI1_S  27
/** HP_SYS_CLKRST_REG_RST_EN_TWAI2 : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_TWAI2    (BIT(28))
#define HP_SYS_CLKRST_REG_RST_EN_TWAI2_M  (HP_SYS_CLKRST_REG_RST_EN_TWAI2_V << HP_SYS_CLKRST_REG_RST_EN_TWAI2_S)
#define HP_SYS_CLKRST_REG_RST_EN_TWAI2_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_TWAI2_S  28
/** HP_SYS_CLKRST_REG_RST_EN_LEDC : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_LEDC    (BIT(29))
#define HP_SYS_CLKRST_REG_RST_EN_LEDC_M  (HP_SYS_CLKRST_REG_RST_EN_LEDC_V << HP_SYS_CLKRST_REG_RST_EN_LEDC_S)
#define HP_SYS_CLKRST_REG_RST_EN_LEDC_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_LEDC_S  29
/** HP_SYS_CLKRST_REG_RST_EN_PCNT : R/W; bitpos: [30]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PCNT    (BIT(30))
#define HP_SYS_CLKRST_REG_RST_EN_PCNT_M  (HP_SYS_CLKRST_REG_RST_EN_PCNT_V << HP_SYS_CLKRST_REG_RST_EN_PCNT_S)
#define HP_SYS_CLKRST_REG_RST_EN_PCNT_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PCNT_S  30
/** HP_SYS_CLKRST_REG_RST_EN_ETM : R/W; bitpos: [31]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_ETM    (BIT(31))
#define HP_SYS_CLKRST_REG_RST_EN_ETM_M  (HP_SYS_CLKRST_REG_RST_EN_ETM_V << HP_SYS_CLKRST_REG_RST_EN_ETM_S)
#define HP_SYS_CLKRST_REG_RST_EN_ETM_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_ETM_S  31

/** HP_SYS_CLKRST_HP_RST_EN2_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_HP_RST_EN2_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xc8)
/** HP_SYS_CLKRST_REG_RST_EN_INTRMTX : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_INTRMTX    (BIT(0))
#define HP_SYS_CLKRST_REG_RST_EN_INTRMTX_M  (HP_SYS_CLKRST_REG_RST_EN_INTRMTX_V << HP_SYS_CLKRST_REG_RST_EN_INTRMTX_S)
#define HP_SYS_CLKRST_REG_RST_EN_INTRMTX_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_INTRMTX_S  0
/** HP_SYS_CLKRST_REG_RST_EN_PARLIO : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO    (BIT(1))
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_M  (HP_SYS_CLKRST_REG_RST_EN_PARLIO_V << HP_SYS_CLKRST_REG_RST_EN_PARLIO_S)
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_S  1
/** HP_SYS_CLKRST_REG_RST_EN_PARLIO_RX : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_RX    (BIT(2))
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_RX_M  (HP_SYS_CLKRST_REG_RST_EN_PARLIO_RX_V << HP_SYS_CLKRST_REG_RST_EN_PARLIO_RX_S)
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_RX_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_RX_S  2
/** HP_SYS_CLKRST_REG_RST_EN_PARLIO_TX : R/W; bitpos: [3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_TX    (BIT(3))
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_TX_M  (HP_SYS_CLKRST_REG_RST_EN_PARLIO_TX_V << HP_SYS_CLKRST_REG_RST_EN_PARLIO_TX_S)
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_TX_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_PARLIO_TX_S  3
/** HP_SYS_CLKRST_REG_RST_EN_I2S0_APB : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_I2S0_APB    (BIT(4))
#define HP_SYS_CLKRST_REG_RST_EN_I2S0_APB_M  (HP_SYS_CLKRST_REG_RST_EN_I2S0_APB_V << HP_SYS_CLKRST_REG_RST_EN_I2S0_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_I2S0_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_I2S0_APB_S  4
/** HP_SYS_CLKRST_REG_RST_EN_I2S1_APB : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_I2S1_APB    (BIT(5))
#define HP_SYS_CLKRST_REG_RST_EN_I2S1_APB_M  (HP_SYS_CLKRST_REG_RST_EN_I2S1_APB_V << HP_SYS_CLKRST_REG_RST_EN_I2S1_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_I2S1_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_I2S1_APB_S  5
/** HP_SYS_CLKRST_REG_RST_EN_I2S2_APB : R/W; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_I2S2_APB    (BIT(6))
#define HP_SYS_CLKRST_REG_RST_EN_I2S2_APB_M  (HP_SYS_CLKRST_REG_RST_EN_I2S2_APB_V << HP_SYS_CLKRST_REG_RST_EN_I2S2_APB_S)
#define HP_SYS_CLKRST_REG_RST_EN_I2S2_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_I2S2_APB_S  6
/** HP_SYS_CLKRST_REG_RST_EN_SPI2 : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_SPI2    (BIT(7))
#define HP_SYS_CLKRST_REG_RST_EN_SPI2_M  (HP_SYS_CLKRST_REG_RST_EN_SPI2_V << HP_SYS_CLKRST_REG_RST_EN_SPI2_S)
#define HP_SYS_CLKRST_REG_RST_EN_SPI2_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_SPI2_S  7
/** HP_SYS_CLKRST_REG_RST_EN_SPI3 : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_SPI3    (BIT(8))
#define HP_SYS_CLKRST_REG_RST_EN_SPI3_M  (HP_SYS_CLKRST_REG_RST_EN_SPI3_V << HP_SYS_CLKRST_REG_RST_EN_SPI3_S)
#define HP_SYS_CLKRST_REG_RST_EN_SPI3_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_SPI3_S  8
/** HP_SYS_CLKRST_REG_RST_EN_LCDCAM : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_LCDCAM    (BIT(9))
#define HP_SYS_CLKRST_REG_RST_EN_LCDCAM_M  (HP_SYS_CLKRST_REG_RST_EN_LCDCAM_V << HP_SYS_CLKRST_REG_RST_EN_LCDCAM_S)
#define HP_SYS_CLKRST_REG_RST_EN_LCDCAM_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_LCDCAM_S  9
/** HP_SYS_CLKRST_REG_RST_EN_ADC : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_ADC    (BIT(10))
#define HP_SYS_CLKRST_REG_RST_EN_ADC_M  (HP_SYS_CLKRST_REG_RST_EN_ADC_V << HP_SYS_CLKRST_REG_RST_EN_ADC_S)
#define HP_SYS_CLKRST_REG_RST_EN_ADC_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_ADC_S  10
/** HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER    (BIT(11))
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_M  (HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_V << HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_S)
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_S  11
/** HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_RX : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_RX    (BIT(12))
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_RX_M  (HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_RX_V << HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_RX_S)
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_RX_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_RX_S  12
/** HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_TX : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_TX    (BIT(13))
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_TX_M  (HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_TX_V << HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_TX_S)
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_TX_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_BITSCRAMBLER_TX_S  13
/** HP_SYS_CLKRST_REG_RST_EN_CRYPTO : R/W; bitpos: [14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_CRYPTO    (BIT(14))
#define HP_SYS_CLKRST_REG_RST_EN_CRYPTO_M  (HP_SYS_CLKRST_REG_RST_EN_CRYPTO_V << HP_SYS_CLKRST_REG_RST_EN_CRYPTO_S)
#define HP_SYS_CLKRST_REG_RST_EN_CRYPTO_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_CRYPTO_S  14
/** HP_SYS_CLKRST_REG_RST_EN_SEC : R/W; bitpos: [15]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_SEC    (BIT(15))
#define HP_SYS_CLKRST_REG_RST_EN_SEC_M  (HP_SYS_CLKRST_REG_RST_EN_SEC_V << HP_SYS_CLKRST_REG_RST_EN_SEC_S)
#define HP_SYS_CLKRST_REG_RST_EN_SEC_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_SEC_S  15
/** HP_SYS_CLKRST_REG_RST_EN_AES : R/W; bitpos: [16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_AES    (BIT(16))
#define HP_SYS_CLKRST_REG_RST_EN_AES_M  (HP_SYS_CLKRST_REG_RST_EN_AES_V << HP_SYS_CLKRST_REG_RST_EN_AES_S)
#define HP_SYS_CLKRST_REG_RST_EN_AES_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_AES_S  16
/** HP_SYS_CLKRST_REG_RST_EN_DS : R/W; bitpos: [17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_DS    (BIT(17))
#define HP_SYS_CLKRST_REG_RST_EN_DS_M  (HP_SYS_CLKRST_REG_RST_EN_DS_V << HP_SYS_CLKRST_REG_RST_EN_DS_S)
#define HP_SYS_CLKRST_REG_RST_EN_DS_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_DS_S  17
/** HP_SYS_CLKRST_REG_RST_EN_SHA : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_SHA    (BIT(18))
#define HP_SYS_CLKRST_REG_RST_EN_SHA_M  (HP_SYS_CLKRST_REG_RST_EN_SHA_V << HP_SYS_CLKRST_REG_RST_EN_SHA_S)
#define HP_SYS_CLKRST_REG_RST_EN_SHA_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_SHA_S  18
/** HP_SYS_CLKRST_REG_RST_EN_HMAC : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_HMAC    (BIT(19))
#define HP_SYS_CLKRST_REG_RST_EN_HMAC_M  (HP_SYS_CLKRST_REG_RST_EN_HMAC_V << HP_SYS_CLKRST_REG_RST_EN_HMAC_S)
#define HP_SYS_CLKRST_REG_RST_EN_HMAC_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_HMAC_S  19
/** HP_SYS_CLKRST_REG_RST_EN_ECDSA : R/W; bitpos: [20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_ECDSA    (BIT(20))
#define HP_SYS_CLKRST_REG_RST_EN_ECDSA_M  (HP_SYS_CLKRST_REG_RST_EN_ECDSA_V << HP_SYS_CLKRST_REG_RST_EN_ECDSA_S)
#define HP_SYS_CLKRST_REG_RST_EN_ECDSA_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_ECDSA_S  20
/** HP_SYS_CLKRST_REG_RST_EN_RSA : R/W; bitpos: [21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_RSA    (BIT(21))
#define HP_SYS_CLKRST_REG_RST_EN_RSA_M  (HP_SYS_CLKRST_REG_RST_EN_RSA_V << HP_SYS_CLKRST_REG_RST_EN_RSA_S)
#define HP_SYS_CLKRST_REG_RST_EN_RSA_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_RSA_S  21
/** HP_SYS_CLKRST_REG_RST_EN_ECC : R/W; bitpos: [22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_ECC    (BIT(22))
#define HP_SYS_CLKRST_REG_RST_EN_ECC_M  (HP_SYS_CLKRST_REG_RST_EN_ECC_V << HP_SYS_CLKRST_REG_RST_EN_ECC_S)
#define HP_SYS_CLKRST_REG_RST_EN_ECC_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_ECC_S  22
/** HP_SYS_CLKRST_REG_RST_EN_KM : R/W; bitpos: [23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_KM    (BIT(23))
#define HP_SYS_CLKRST_REG_RST_EN_KM_M  (HP_SYS_CLKRST_REG_RST_EN_KM_V << HP_SYS_CLKRST_REG_RST_EN_KM_S)
#define HP_SYS_CLKRST_REG_RST_EN_KM_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_KM_S  23
/** HP_SYS_CLKRST_REG_RST_EN_H264 : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_RST_EN_H264    (BIT(24))
#define HP_SYS_CLKRST_REG_RST_EN_H264_M  (HP_SYS_CLKRST_REG_RST_EN_H264_V << HP_SYS_CLKRST_REG_RST_EN_H264_S)
#define HP_SYS_CLKRST_REG_RST_EN_H264_V  0x00000001U
#define HP_SYS_CLKRST_REG_RST_EN_H264_S  24

/** HP_SYS_CLKRST_HP_FORCE_NORST0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_HP_FORCE_NORST0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xcc)
/** HP_SYS_CLKRST_REG_FORCE_NORST_CORE0 : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORE0    (BIT(0))
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORE0_M  (HP_SYS_CLKRST_REG_FORCE_NORST_CORE0_V << HP_SYS_CLKRST_REG_FORCE_NORST_CORE0_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORE0_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORE0_S  0
/** HP_SYS_CLKRST_REG_FORCE_NORST_CORE1 : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORE1    (BIT(1))
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORE1_M  (HP_SYS_CLKRST_REG_FORCE_NORST_CORE1_V << HP_SYS_CLKRST_REG_FORCE_NORST_CORE1_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORE1_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORE1_S  1
/** HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE0 : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE0    (BIT(2))
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE0_M  (HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE0_V << HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE0_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE0_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE0_S  2
/** HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE1 : R/W; bitpos: [3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE1    (BIT(3))
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE1_M  (HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE1_V << HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE1_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE1_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_CORETRACE1_S  3
/** HP_SYS_CLKRST_REG_FORCE_NORST_L2MEMMON : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_L2MEMMON    (BIT(4))
#define HP_SYS_CLKRST_REG_FORCE_NORST_L2MEMMON_M  (HP_SYS_CLKRST_REG_FORCE_NORST_L2MEMMON_V << HP_SYS_CLKRST_REG_FORCE_NORST_L2MEMMON_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_L2MEMMON_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_L2MEMMON_S  4
/** HP_SYS_CLKRST_REG_FORCE_NORST_TCMMON : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_TCMMON    (BIT(5))
#define HP_SYS_CLKRST_REG_FORCE_NORST_TCMMON_M  (HP_SYS_CLKRST_REG_FORCE_NORST_TCMMON_V << HP_SYS_CLKRST_REG_FORCE_NORST_TCMMON_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_TCMMON_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_TCMMON_S  5
/** HP_SYS_CLKRST_REG_FORCE_NORST_GDMA : R/W; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_GDMA    (BIT(6))
#define HP_SYS_CLKRST_REG_FORCE_NORST_GDMA_M  (HP_SYS_CLKRST_REG_FORCE_NORST_GDMA_V << HP_SYS_CLKRST_REG_FORCE_NORST_GDMA_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_GDMA_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_GDMA_S  6
/** HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_AXI : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_AXI    (BIT(7))
#define HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_AXI_M  (HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_AXI_V << HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_AXI_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_AXI_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_AXI_S  7
/** HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_AXI : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_AXI    (BIT(8))
#define HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_AXI_M  (HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_AXI_V << HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_AXI_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_AXI_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_AXI_S  8
/** HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_APB : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_APB    (BIT(9))
#define HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_APB_M  (HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_APB_V << HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_APB_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_MSPI_APB_S  9
/** HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_APB : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_APB    (BIT(10))
#define HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_APB_M  (HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_APB_V << HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_APB_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_APB_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_DUAL_MSPI_APB_S  10
/** HP_SYS_CLKRST_REG_FORCE_NORST_DSI_BRG : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_DSI_BRG    (BIT(11))
#define HP_SYS_CLKRST_REG_FORCE_NORST_DSI_BRG_M  (HP_SYS_CLKRST_REG_FORCE_NORST_DSI_BRG_V << HP_SYS_CLKRST_REG_FORCE_NORST_DSI_BRG_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_DSI_BRG_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_DSI_BRG_S  11
/** HP_SYS_CLKRST_REG_FORCE_NORST_CSI_HOST : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_CSI_HOST    (BIT(12))
#define HP_SYS_CLKRST_REG_FORCE_NORST_CSI_HOST_M  (HP_SYS_CLKRST_REG_FORCE_NORST_CSI_HOST_V << HP_SYS_CLKRST_REG_FORCE_NORST_CSI_HOST_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_CSI_HOST_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_CSI_HOST_S  12
/** HP_SYS_CLKRST_REG_FORCE_NORST_CSI_BRG : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_CSI_BRG    (BIT(13))
#define HP_SYS_CLKRST_REG_FORCE_NORST_CSI_BRG_M  (HP_SYS_CLKRST_REG_FORCE_NORST_CSI_BRG_V << HP_SYS_CLKRST_REG_FORCE_NORST_CSI_BRG_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_CSI_BRG_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_CSI_BRG_S  13
/** HP_SYS_CLKRST_REG_FORCE_NORST_ISP : R/W; bitpos: [14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_ISP    (BIT(14))
#define HP_SYS_CLKRST_REG_FORCE_NORST_ISP_M  (HP_SYS_CLKRST_REG_FORCE_NORST_ISP_V << HP_SYS_CLKRST_REG_FORCE_NORST_ISP_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_ISP_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_ISP_S  14
/** HP_SYS_CLKRST_REG_FORCE_NORST_JPEG : R/W; bitpos: [15]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_JPEG    (BIT(15))
#define HP_SYS_CLKRST_REG_FORCE_NORST_JPEG_M  (HP_SYS_CLKRST_REG_FORCE_NORST_JPEG_V << HP_SYS_CLKRST_REG_FORCE_NORST_JPEG_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_JPEG_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_JPEG_S  15
/** HP_SYS_CLKRST_REG_FORCE_NORST_DMA2D : R/W; bitpos: [16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_DMA2D    (BIT(16))
#define HP_SYS_CLKRST_REG_FORCE_NORST_DMA2D_M  (HP_SYS_CLKRST_REG_FORCE_NORST_DMA2D_V << HP_SYS_CLKRST_REG_FORCE_NORST_DMA2D_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_DMA2D_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_DMA2D_S  16
/** HP_SYS_CLKRST_REG_FORCE_NORST_PPA : R/W; bitpos: [17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_PPA    (BIT(17))
#define HP_SYS_CLKRST_REG_FORCE_NORST_PPA_M  (HP_SYS_CLKRST_REG_FORCE_NORST_PPA_V << HP_SYS_CLKRST_REG_FORCE_NORST_PPA_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_PPA_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_PPA_S  17
/** HP_SYS_CLKRST_REG_FORCE_NORST_AHB_PDMA : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_AHB_PDMA    (BIT(18))
#define HP_SYS_CLKRST_REG_FORCE_NORST_AHB_PDMA_M  (HP_SYS_CLKRST_REG_FORCE_NORST_AHB_PDMA_V << HP_SYS_CLKRST_REG_FORCE_NORST_AHB_PDMA_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_AHB_PDMA_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_AHB_PDMA_S  18
/** HP_SYS_CLKRST_REG_FORCE_NORST_AXI_PDMA : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_AXI_PDMA    (BIT(19))
#define HP_SYS_CLKRST_REG_FORCE_NORST_AXI_PDMA_M  (HP_SYS_CLKRST_REG_FORCE_NORST_AXI_PDMA_V << HP_SYS_CLKRST_REG_FORCE_NORST_AXI_PDMA_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_AXI_PDMA_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_AXI_PDMA_S  19
/** HP_SYS_CLKRST_REG_FORCE_NORST_IOMUX : R/W; bitpos: [20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_IOMUX    (BIT(20))
#define HP_SYS_CLKRST_REG_FORCE_NORST_IOMUX_M  (HP_SYS_CLKRST_REG_FORCE_NORST_IOMUX_V << HP_SYS_CLKRST_REG_FORCE_NORST_IOMUX_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_IOMUX_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_IOMUX_S  20
/** HP_SYS_CLKRST_REG_FORCE_NORST_PADBIST : R/W; bitpos: [21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_PADBIST    (BIT(21))
#define HP_SYS_CLKRST_REG_FORCE_NORST_PADBIST_M  (HP_SYS_CLKRST_REG_FORCE_NORST_PADBIST_V << HP_SYS_CLKRST_REG_FORCE_NORST_PADBIST_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_PADBIST_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_PADBIST_S  21
/** HP_SYS_CLKRST_REG_FORCE_NORST_STIMER : R/W; bitpos: [22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_STIMER    (BIT(22))
#define HP_SYS_CLKRST_REG_FORCE_NORST_STIMER_M  (HP_SYS_CLKRST_REG_FORCE_NORST_STIMER_V << HP_SYS_CLKRST_REG_FORCE_NORST_STIMER_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_STIMER_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_STIMER_S  22
/** HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP0 : R/W; bitpos: [23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP0    (BIT(23))
#define HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP0_M  (HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP0_V << HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP0_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP0_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP0_S  23
/** HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP1 : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP1    (BIT(24))
#define HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP1_M  (HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP1_V << HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP1_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP1_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_TIMERGRP1_S  24
/** HP_SYS_CLKRST_REG_FORCE_NORST_UART0 : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART0    (BIT(25))
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART0_M  (HP_SYS_CLKRST_REG_FORCE_NORST_UART0_V << HP_SYS_CLKRST_REG_FORCE_NORST_UART0_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART0_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART0_S  25
/** HP_SYS_CLKRST_REG_FORCE_NORST_UART1 : R/W; bitpos: [26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART1    (BIT(26))
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART1_M  (HP_SYS_CLKRST_REG_FORCE_NORST_UART1_V << HP_SYS_CLKRST_REG_FORCE_NORST_UART1_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART1_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART1_S  26
/** HP_SYS_CLKRST_REG_FORCE_NORST_UART2 : R/W; bitpos: [27]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART2    (BIT(27))
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART2_M  (HP_SYS_CLKRST_REG_FORCE_NORST_UART2_V << HP_SYS_CLKRST_REG_FORCE_NORST_UART2_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART2_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART2_S  27
/** HP_SYS_CLKRST_REG_FORCE_NORST_UART3 : R/W; bitpos: [28]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART3    (BIT(28))
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART3_M  (HP_SYS_CLKRST_REG_FORCE_NORST_UART3_V << HP_SYS_CLKRST_REG_FORCE_NORST_UART3_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART3_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART3_S  28
/** HP_SYS_CLKRST_REG_FORCE_NORST_UART4 : R/W; bitpos: [29]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART4    (BIT(29))
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART4_M  (HP_SYS_CLKRST_REG_FORCE_NORST_UART4_V << HP_SYS_CLKRST_REG_FORCE_NORST_UART4_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART4_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_UART4_S  29
/** HP_SYS_CLKRST_REG_FORCE_NORST_UHCI : R/W; bitpos: [30]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_UHCI    (BIT(30))
#define HP_SYS_CLKRST_REG_FORCE_NORST_UHCI_M  (HP_SYS_CLKRST_REG_FORCE_NORST_UHCI_V << HP_SYS_CLKRST_REG_FORCE_NORST_UHCI_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_UHCI_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_UHCI_S  30
/** HP_SYS_CLKRST_REG_FORCE_NORST_I3CMST : R/W; bitpos: [31]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_I3CMST    (BIT(31))
#define HP_SYS_CLKRST_REG_FORCE_NORST_I3CMST_M  (HP_SYS_CLKRST_REG_FORCE_NORST_I3CMST_V << HP_SYS_CLKRST_REG_FORCE_NORST_I3CMST_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_I3CMST_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_I3CMST_S  31

/** HP_SYS_CLKRST_HP_FORCE_NORST1_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_HP_FORCE_NORST1_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xd0)
/** HP_SYS_CLKRST_REG_FORCE_NORST_I3CSLV : R/W; bitpos: [0]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_I3CSLV    (BIT(0))
#define HP_SYS_CLKRST_REG_FORCE_NORST_I3CSLV_M  (HP_SYS_CLKRST_REG_FORCE_NORST_I3CSLV_V << HP_SYS_CLKRST_REG_FORCE_NORST_I3CSLV_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_I3CSLV_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_I3CSLV_S  0
/** HP_SYS_CLKRST_REG_FORCE_NORST_I2C1 : R/W; bitpos: [1]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2C1    (BIT(1))
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2C1_M  (HP_SYS_CLKRST_REG_FORCE_NORST_I2C1_V << HP_SYS_CLKRST_REG_FORCE_NORST_I2C1_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2C1_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2C1_S  1
/** HP_SYS_CLKRST_REG_FORCE_NORST_I2C0 : R/W; bitpos: [2]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2C0    (BIT(2))
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2C0_M  (HP_SYS_CLKRST_REG_FORCE_NORST_I2C0_V << HP_SYS_CLKRST_REG_FORCE_NORST_I2C0_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2C0_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2C0_S  2
/** HP_SYS_CLKRST_REG_FORCE_NORST_RMT : R/W; bitpos: [3]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_RMT    (BIT(3))
#define HP_SYS_CLKRST_REG_FORCE_NORST_RMT_M  (HP_SYS_CLKRST_REG_FORCE_NORST_RMT_V << HP_SYS_CLKRST_REG_FORCE_NORST_RMT_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_RMT_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_RMT_S  3
/** HP_SYS_CLKRST_REG_FORCE_NORST_PWM0 : R/W; bitpos: [4]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_PWM0    (BIT(4))
#define HP_SYS_CLKRST_REG_FORCE_NORST_PWM0_M  (HP_SYS_CLKRST_REG_FORCE_NORST_PWM0_V << HP_SYS_CLKRST_REG_FORCE_NORST_PWM0_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_PWM0_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_PWM0_S  4
/** HP_SYS_CLKRST_REG_FORCE_NORST_PWM1 : R/W; bitpos: [5]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_PWM1    (BIT(5))
#define HP_SYS_CLKRST_REG_FORCE_NORST_PWM1_M  (HP_SYS_CLKRST_REG_FORCE_NORST_PWM1_V << HP_SYS_CLKRST_REG_FORCE_NORST_PWM1_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_PWM1_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_PWM1_S  5
/** HP_SYS_CLKRST_REG_FORCE_NORST_TWAI0 : R/W; bitpos: [6]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI0    (BIT(6))
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI0_M  (HP_SYS_CLKRST_REG_FORCE_NORST_TWAI0_V << HP_SYS_CLKRST_REG_FORCE_NORST_TWAI0_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI0_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI0_S  6
/** HP_SYS_CLKRST_REG_FORCE_NORST_TWAI1 : R/W; bitpos: [7]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI1    (BIT(7))
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI1_M  (HP_SYS_CLKRST_REG_FORCE_NORST_TWAI1_V << HP_SYS_CLKRST_REG_FORCE_NORST_TWAI1_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI1_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI1_S  7
/** HP_SYS_CLKRST_REG_FORCE_NORST_TWAI2 : R/W; bitpos: [8]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI2    (BIT(8))
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI2_M  (HP_SYS_CLKRST_REG_FORCE_NORST_TWAI2_V << HP_SYS_CLKRST_REG_FORCE_NORST_TWAI2_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI2_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_TWAI2_S  8
/** HP_SYS_CLKRST_REG_FORCE_NORST_LEDC : R/W; bitpos: [9]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_LEDC    (BIT(9))
#define HP_SYS_CLKRST_REG_FORCE_NORST_LEDC_M  (HP_SYS_CLKRST_REG_FORCE_NORST_LEDC_V << HP_SYS_CLKRST_REG_FORCE_NORST_LEDC_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_LEDC_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_LEDC_S  9
/** HP_SYS_CLKRST_REG_FORCE_NORST_PCNT : R/W; bitpos: [10]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_PCNT    (BIT(10))
#define HP_SYS_CLKRST_REG_FORCE_NORST_PCNT_M  (HP_SYS_CLKRST_REG_FORCE_NORST_PCNT_V << HP_SYS_CLKRST_REG_FORCE_NORST_PCNT_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_PCNT_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_PCNT_S  10
/** HP_SYS_CLKRST_REG_FORCE_NORST_ETM : R/W; bitpos: [11]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_ETM    (BIT(11))
#define HP_SYS_CLKRST_REG_FORCE_NORST_ETM_M  (HP_SYS_CLKRST_REG_FORCE_NORST_ETM_V << HP_SYS_CLKRST_REG_FORCE_NORST_ETM_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_ETM_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_ETM_S  11
/** HP_SYS_CLKRST_REG_FORCE_NORST_INTRMTX : R/W; bitpos: [12]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_INTRMTX    (BIT(12))
#define HP_SYS_CLKRST_REG_FORCE_NORST_INTRMTX_M  (HP_SYS_CLKRST_REG_FORCE_NORST_INTRMTX_V << HP_SYS_CLKRST_REG_FORCE_NORST_INTRMTX_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_INTRMTX_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_INTRMTX_S  12
/** HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO : R/W; bitpos: [13]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO    (BIT(13))
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_M  (HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_V << HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_S  13
/** HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_RX : R/W; bitpos: [14]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_RX    (BIT(14))
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_RX_M  (HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_RX_V << HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_RX_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_RX_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_RX_S  14
/** HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_TX : R/W; bitpos: [15]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_TX    (BIT(15))
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_TX_M  (HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_TX_V << HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_TX_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_TX_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_PARLIO_TX_S  15
/** HP_SYS_CLKRST_REG_FORCE_NORST_I2S0 : R/W; bitpos: [16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S0    (BIT(16))
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S0_M  (HP_SYS_CLKRST_REG_FORCE_NORST_I2S0_V << HP_SYS_CLKRST_REG_FORCE_NORST_I2S0_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S0_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S0_S  16
/** HP_SYS_CLKRST_REG_FORCE_NORST_I2S1 : R/W; bitpos: [17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S1    (BIT(17))
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S1_M  (HP_SYS_CLKRST_REG_FORCE_NORST_I2S1_V << HP_SYS_CLKRST_REG_FORCE_NORST_I2S1_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S1_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S1_S  17
/** HP_SYS_CLKRST_REG_FORCE_NORST_I2S2 : R/W; bitpos: [18]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S2    (BIT(18))
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S2_M  (HP_SYS_CLKRST_REG_FORCE_NORST_I2S2_V << HP_SYS_CLKRST_REG_FORCE_NORST_I2S2_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S2_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_I2S2_S  18
/** HP_SYS_CLKRST_REG_FORCE_NORST_SPI2 : R/W; bitpos: [19]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_SPI2    (BIT(19))
#define HP_SYS_CLKRST_REG_FORCE_NORST_SPI2_M  (HP_SYS_CLKRST_REG_FORCE_NORST_SPI2_V << HP_SYS_CLKRST_REG_FORCE_NORST_SPI2_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_SPI2_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_SPI2_S  19
/** HP_SYS_CLKRST_REG_FORCE_NORST_SPI3 : R/W; bitpos: [20]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_SPI3    (BIT(20))
#define HP_SYS_CLKRST_REG_FORCE_NORST_SPI3_M  (HP_SYS_CLKRST_REG_FORCE_NORST_SPI3_V << HP_SYS_CLKRST_REG_FORCE_NORST_SPI3_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_SPI3_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_SPI3_S  20
/** HP_SYS_CLKRST_REG_FORCE_NORST_LCDCAM : R/W; bitpos: [21]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_LCDCAM    (BIT(21))
#define HP_SYS_CLKRST_REG_FORCE_NORST_LCDCAM_M  (HP_SYS_CLKRST_REG_FORCE_NORST_LCDCAM_V << HP_SYS_CLKRST_REG_FORCE_NORST_LCDCAM_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_LCDCAM_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_LCDCAM_S  21
/** HP_SYS_CLKRST_REG_FORCE_NORST_ADC : R/W; bitpos: [22]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_ADC    (BIT(22))
#define HP_SYS_CLKRST_REG_FORCE_NORST_ADC_M  (HP_SYS_CLKRST_REG_FORCE_NORST_ADC_V << HP_SYS_CLKRST_REG_FORCE_NORST_ADC_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_ADC_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_ADC_S  22
/** HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER : R/W; bitpos: [23]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER    (BIT(23))
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_M  (HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_V << HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_S  23
/** HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_RX : R/W; bitpos: [24]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_RX    (BIT(24))
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_RX_M  (HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_RX_V << HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_RX_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_RX_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_RX_S  24
/** HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_TX : R/W; bitpos: [25]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_TX    (BIT(25))
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_TX_M  (HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_TX_V << HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_TX_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_TX_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_BITSCRAMBLER_TX_S  25
/** HP_SYS_CLKRST_REG_FORCE_NORST_H264 : R/W; bitpos: [26]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_FORCE_NORST_H264    (BIT(26))
#define HP_SYS_CLKRST_REG_FORCE_NORST_H264_M  (HP_SYS_CLKRST_REG_FORCE_NORST_H264_V << HP_SYS_CLKRST_REG_FORCE_NORST_H264_S)
#define HP_SYS_CLKRST_REG_FORCE_NORST_H264_V  0x00000001U
#define HP_SYS_CLKRST_REG_FORCE_NORST_H264_S  26

/** HP_SYS_CLKRST_HPWDT_CORE0_RST_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_HPWDT_CORE0_RST_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xd4)
/** HP_SYS_CLKRST_REG_HPCORE0_STALL_EN : R/W; bitpos: [0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_HPCORE0_STALL_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_HPCORE0_STALL_EN_M  (HP_SYS_CLKRST_REG_HPCORE0_STALL_EN_V << HP_SYS_CLKRST_REG_HPCORE0_STALL_EN_S)
#define HP_SYS_CLKRST_REG_HPCORE0_STALL_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_HPCORE0_STALL_EN_S  0
/** HP_SYS_CLKRST_REG_HPCORE0_STALL_WAIT_NUM : R/W; bitpos: [8:1]; default: 8;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_HPCORE0_STALL_WAIT_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_HPCORE0_STALL_WAIT_NUM_M  (HP_SYS_CLKRST_REG_HPCORE0_STALL_WAIT_NUM_V << HP_SYS_CLKRST_REG_HPCORE0_STALL_WAIT_NUM_S)
#define HP_SYS_CLKRST_REG_HPCORE0_STALL_WAIT_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_HPCORE0_STALL_WAIT_NUM_S  1
/** HP_SYS_CLKRST_REG_WDT_HPCORE0_RST_LEN : R/W; bitpos: [16:9]; default: 8;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_WDT_HPCORE0_RST_LEN    0x000000FFU
#define HP_SYS_CLKRST_REG_WDT_HPCORE0_RST_LEN_M  (HP_SYS_CLKRST_REG_WDT_HPCORE0_RST_LEN_V << HP_SYS_CLKRST_REG_WDT_HPCORE0_RST_LEN_S)
#define HP_SYS_CLKRST_REG_WDT_HPCORE0_RST_LEN_V  0x000000FFU
#define HP_SYS_CLKRST_REG_WDT_HPCORE0_RST_LEN_S  9

/** HP_SYS_CLKRST_HPWDT_CORE1_RST_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_HPWDT_CORE1_RST_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xd8)
/** HP_SYS_CLKRST_REG_HPCORE1_STALL_EN : R/W; bitpos: [0]; default: 1;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_HPCORE1_STALL_EN    (BIT(0))
#define HP_SYS_CLKRST_REG_HPCORE1_STALL_EN_M  (HP_SYS_CLKRST_REG_HPCORE1_STALL_EN_V << HP_SYS_CLKRST_REG_HPCORE1_STALL_EN_S)
#define HP_SYS_CLKRST_REG_HPCORE1_STALL_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_HPCORE1_STALL_EN_S  0
/** HP_SYS_CLKRST_REG_HPCORE1_STALL_WAIT_NUM : R/W; bitpos: [8:1]; default: 8;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_HPCORE1_STALL_WAIT_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_HPCORE1_STALL_WAIT_NUM_M  (HP_SYS_CLKRST_REG_HPCORE1_STALL_WAIT_NUM_V << HP_SYS_CLKRST_REG_HPCORE1_STALL_WAIT_NUM_S)
#define HP_SYS_CLKRST_REG_HPCORE1_STALL_WAIT_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_HPCORE1_STALL_WAIT_NUM_S  1
/** HP_SYS_CLKRST_REG_WDT_HPCORE1_RST_LEN : R/W; bitpos: [16:9]; default: 8;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_WDT_HPCORE1_RST_LEN    0x000000FFU
#define HP_SYS_CLKRST_REG_WDT_HPCORE1_RST_LEN_M  (HP_SYS_CLKRST_REG_WDT_HPCORE1_RST_LEN_V << HP_SYS_CLKRST_REG_WDT_HPCORE1_RST_LEN_S)
#define HP_SYS_CLKRST_REG_WDT_HPCORE1_RST_LEN_V  0x000000FFU
#define HP_SYS_CLKRST_REG_WDT_HPCORE1_RST_LEN_S  9

/** HP_SYS_CLKRST_CPU_SRC_FREQ0_REG register
 *  CPU Source Frequency
 */
#define HP_SYS_CLKRST_CPU_SRC_FREQ0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xdc)
/** HP_SYS_CLKRST_REG_CPU_SRC_FREQ : RO; bitpos: [31:0]; default: 0;
 *  cpu source clock frequency, step by 0.25MHz
 */
#define HP_SYS_CLKRST_REG_CPU_SRC_FREQ    0xFFFFFFFFU
#define HP_SYS_CLKRST_REG_CPU_SRC_FREQ_M  (HP_SYS_CLKRST_REG_CPU_SRC_FREQ_V << HP_SYS_CLKRST_REG_CPU_SRC_FREQ_S)
#define HP_SYS_CLKRST_REG_CPU_SRC_FREQ_V  0xFFFFFFFFU
#define HP_SYS_CLKRST_REG_CPU_SRC_FREQ_S  0

/** HP_SYS_CLKRST_CPU_CLK_STATUS0_REG register
 *  CPU Clock Status
 */
#define HP_SYS_CLKRST_CPU_CLK_STATUS0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xe0)
/** HP_SYS_CLKRST_REG_ASIC_OR_FPGA : RO; bitpos: [0]; default: 0;
 *  0: ASIC mode, 1: FPGA mode
 */
#define HP_SYS_CLKRST_REG_ASIC_OR_FPGA    (BIT(0))
#define HP_SYS_CLKRST_REG_ASIC_OR_FPGA_M  (HP_SYS_CLKRST_REG_ASIC_OR_FPGA_V << HP_SYS_CLKRST_REG_ASIC_OR_FPGA_S)
#define HP_SYS_CLKRST_REG_ASIC_OR_FPGA_V  0x00000001U
#define HP_SYS_CLKRST_REG_ASIC_OR_FPGA_S  0
/** HP_SYS_CLKRST_REG_CPU_DIV_EFFECT : RO; bitpos: [1]; default: 0;
 *  0: Divider bypass, 1: Divider takes effect
 */
#define HP_SYS_CLKRST_REG_CPU_DIV_EFFECT    (BIT(1))
#define HP_SYS_CLKRST_REG_CPU_DIV_EFFECT_M  (HP_SYS_CLKRST_REG_CPU_DIV_EFFECT_V << HP_SYS_CLKRST_REG_CPU_DIV_EFFECT_S)
#define HP_SYS_CLKRST_REG_CPU_DIV_EFFECT_V  0x00000001U
#define HP_SYS_CLKRST_REG_CPU_DIV_EFFECT_S  1
/** HP_SYS_CLKRST_REG_CPU_SRC_IS_CPLL : RO; bitpos: [2]; default: 0;
 *  0: CPU source isn't cpll_400m, 1: CPU Source is cll_400m
 */
#define HP_SYS_CLKRST_REG_CPU_SRC_IS_CPLL    (BIT(2))
#define HP_SYS_CLKRST_REG_CPU_SRC_IS_CPLL_M  (HP_SYS_CLKRST_REG_CPU_SRC_IS_CPLL_V << HP_SYS_CLKRST_REG_CPU_SRC_IS_CPLL_S)
#define HP_SYS_CLKRST_REG_CPU_SRC_IS_CPLL_V  0x00000001U
#define HP_SYS_CLKRST_REG_CPU_SRC_IS_CPLL_S  2
/** HP_SYS_CLKRST_REG_CPU_DIV_NUM_CUR : RO; bitpos: [10:3]; default: 0;
 *  cpu current div number
 */
#define HP_SYS_CLKRST_REG_CPU_DIV_NUM_CUR    0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_DIV_NUM_CUR_M  (HP_SYS_CLKRST_REG_CPU_DIV_NUM_CUR_V << HP_SYS_CLKRST_REG_CPU_DIV_NUM_CUR_S)
#define HP_SYS_CLKRST_REG_CPU_DIV_NUM_CUR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_DIV_NUM_CUR_S  3
/** HP_SYS_CLKRST_REG_CPU_DIV_NUMERATOR_CUR : RO; bitpos: [18:11]; default: 0;
 *  cpu current div numerator
 */
#define HP_SYS_CLKRST_REG_CPU_DIV_NUMERATOR_CUR    0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_DIV_NUMERATOR_CUR_M  (HP_SYS_CLKRST_REG_CPU_DIV_NUMERATOR_CUR_V << HP_SYS_CLKRST_REG_CPU_DIV_NUMERATOR_CUR_S)
#define HP_SYS_CLKRST_REG_CPU_DIV_NUMERATOR_CUR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_DIV_NUMERATOR_CUR_S  11
/** HP_SYS_CLKRST_REG_CPU_DIV_DENOMINATOR_CUR : RO; bitpos: [26:19]; default: 0;
 *  cpu current div denominator
 */
#define HP_SYS_CLKRST_REG_CPU_DIV_DENOMINATOR_CUR    0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_DIV_DENOMINATOR_CUR_M  (HP_SYS_CLKRST_REG_CPU_DIV_DENOMINATOR_CUR_V << HP_SYS_CLKRST_REG_CPU_DIV_DENOMINATOR_CUR_S)
#define HP_SYS_CLKRST_REG_CPU_DIV_DENOMINATOR_CUR_V  0x000000FFU
#define HP_SYS_CLKRST_REG_CPU_DIV_DENOMINATOR_CUR_S  19

/** HP_SYS_CLKRST_DBG_CLK_CTRL0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_DBG_CLK_CTRL0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xe4)
/** HP_SYS_CLKRST_REG_DBG_CH0_SEL : R/W; bitpos: [7:0]; default: 255;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_DBG_CH0_SEL    0x000000FFU
#define HP_SYS_CLKRST_REG_DBG_CH0_SEL_M  (HP_SYS_CLKRST_REG_DBG_CH0_SEL_V << HP_SYS_CLKRST_REG_DBG_CH0_SEL_S)
#define HP_SYS_CLKRST_REG_DBG_CH0_SEL_V  0x000000FFU
#define HP_SYS_CLKRST_REG_DBG_CH0_SEL_S  0
/** HP_SYS_CLKRST_REG_DBG_CH1_SEL : R/W; bitpos: [15:8]; default: 255;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_DBG_CH1_SEL    0x000000FFU
#define HP_SYS_CLKRST_REG_DBG_CH1_SEL_M  (HP_SYS_CLKRST_REG_DBG_CH1_SEL_V << HP_SYS_CLKRST_REG_DBG_CH1_SEL_S)
#define HP_SYS_CLKRST_REG_DBG_CH1_SEL_V  0x000000FFU
#define HP_SYS_CLKRST_REG_DBG_CH1_SEL_S  8
/** HP_SYS_CLKRST_REG_DBG_CH0_DIV_NUM : R/W; bitpos: [31:24]; default: 3;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_DBG_CH0_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_DBG_CH0_DIV_NUM_M  (HP_SYS_CLKRST_REG_DBG_CH0_DIV_NUM_V << HP_SYS_CLKRST_REG_DBG_CH0_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_DBG_CH0_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_DBG_CH0_DIV_NUM_S  24

/** HP_SYS_CLKRST_DBG_CLK_CTRL1_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_DBG_CLK_CTRL1_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xe8)
/** HP_SYS_CLKRST_REG_DBG_CH1_DIV_NUM : R/W; bitpos: [7:0]; default: 3;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_DBG_CH1_DIV_NUM    0x000000FFU
#define HP_SYS_CLKRST_REG_DBG_CH1_DIV_NUM_M  (HP_SYS_CLKRST_REG_DBG_CH1_DIV_NUM_V << HP_SYS_CLKRST_REG_DBG_CH1_DIV_NUM_S)
#define HP_SYS_CLKRST_REG_DBG_CH1_DIV_NUM_V  0x000000FFU
#define HP_SYS_CLKRST_REG_DBG_CH1_DIV_NUM_S  0
/** HP_SYS_CLKRST_REG_DBG_CH0_EN : R/W; bitpos: [16]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_DBG_CH0_EN    (BIT(16))
#define HP_SYS_CLKRST_REG_DBG_CH0_EN_M  (HP_SYS_CLKRST_REG_DBG_CH0_EN_V << HP_SYS_CLKRST_REG_DBG_CH0_EN_S)
#define HP_SYS_CLKRST_REG_DBG_CH0_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_DBG_CH0_EN_S  16
/** HP_SYS_CLKRST_REG_DBG_CH1_EN : R/W; bitpos: [17]; default: 0;
 *  Reserved
 */
#define HP_SYS_CLKRST_REG_DBG_CH1_EN    (BIT(17))
#define HP_SYS_CLKRST_REG_DBG_CH1_EN_M  (HP_SYS_CLKRST_REG_DBG_CH1_EN_V << HP_SYS_CLKRST_REG_DBG_CH1_EN_S)
#define HP_SYS_CLKRST_REG_DBG_CH1_EN_V  0x00000001U
#define HP_SYS_CLKRST_REG_DBG_CH1_EN_S  17

/** HP_SYS_CLKRST_HPCORE_WDT_RESET_SOURCE0_REG register
 *  Reserved
 */
#define HP_SYS_CLKRST_HPCORE_WDT_RESET_SOURCE0_REG (DR_REG_HP_SYS_CLKRST_BASE + 0xec)
/** HP_SYS_CLKRST_REG_HPCORE0_WDT_RESET_SOURCE_SEL : R/W; bitpos: [0]; default: 0;
 *  1'b0: use wdt0 to reset hpcore0, 1'b1: use wdt1 to reset hpcore0
 */
#define HP_SYS_CLKRST_REG_HPCORE0_WDT_RESET_SOURCE_SEL    (BIT(0))
#define HP_SYS_CLKRST_REG_HPCORE0_WDT_RESET_SOURCE_SEL_M  (HP_SYS_CLKRST_REG_HPCORE0_WDT_RESET_SOURCE_SEL_V << HP_SYS_CLKRST_REG_HPCORE0_WDT_RESET_SOURCE_SEL_S)
#define HP_SYS_CLKRST_REG_HPCORE0_WDT_RESET_SOURCE_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_HPCORE0_WDT_RESET_SOURCE_SEL_S  0
/** HP_SYS_CLKRST_REG_HPCORE1_WDT_RESET_SOURCE_SEL : R/W; bitpos: [1]; default: 1;
 *  1'b0: use wdt0 to reset hpcore1, 1'b1: use wdt1 to reset hpcore1
 */
#define HP_SYS_CLKRST_REG_HPCORE1_WDT_RESET_SOURCE_SEL    (BIT(1))
#define HP_SYS_CLKRST_REG_HPCORE1_WDT_RESET_SOURCE_SEL_M  (HP_SYS_CLKRST_REG_HPCORE1_WDT_RESET_SOURCE_SEL_V << HP_SYS_CLKRST_REG_HPCORE1_WDT_RESET_SOURCE_SEL_S)
#define HP_SYS_CLKRST_REG_HPCORE1_WDT_RESET_SOURCE_SEL_V  0x00000001U
#define HP_SYS_CLKRST_REG_HPCORE1_WDT_RESET_SOURCE_SEL_S  1

#ifdef __cplusplus
}
#endif
