/**
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** APB_SARADC_CTRL_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_CTRL_REG (DR_REG_APB_SARADC_BASE + 0x0)
/** APB_SARADC_SARADC_START_FORCE : R/W; bitpos: [0]; default: 0;
 *  select software enable saradc sample
 */
#define APB_SARADC_SARADC_START_FORCE    (BIT(0))
#define APB_SARADC_SARADC_START_FORCE_M  (APB_SARADC_SARADC_START_FORCE_V << APB_SARADC_SARADC_START_FORCE_S)
#define APB_SARADC_SARADC_START_FORCE_V  0x00000001U
#define APB_SARADC_SARADC_START_FORCE_S  0
/** APB_SARADC_SARADC_START : R/W; bitpos: [1]; default: 0;
 *  software enable saradc sample
 */
#define APB_SARADC_SARADC_START    (BIT(1))
#define APB_SARADC_SARADC_START_M  (APB_SARADC_SARADC_START_V << APB_SARADC_SARADC_START_S)
#define APB_SARADC_SARADC_START_V  0x00000001U
#define APB_SARADC_SARADC_START_S  1
/** APB_SARADC_SARADC_SAR_CLK_GATED : R/W; bitpos: [6]; default: 1;
 *  SAR clock gated
 */
#define APB_SARADC_SARADC_SAR_CLK_GATED    (BIT(6))
#define APB_SARADC_SARADC_SAR_CLK_GATED_M  (APB_SARADC_SARADC_SAR_CLK_GATED_V << APB_SARADC_SARADC_SAR_CLK_GATED_S)
#define APB_SARADC_SARADC_SAR_CLK_GATED_V  0x00000001U
#define APB_SARADC_SARADC_SAR_CLK_GATED_S  6
/** APB_SARADC_SARADC_SAR_CLK_DIV : R/W; bitpos: [14:7]; default: 4;
 *  SAR clock divider
 */
#define APB_SARADC_SARADC_SAR_CLK_DIV    0x000000FFU
#define APB_SARADC_SARADC_SAR_CLK_DIV_M  (APB_SARADC_SARADC_SAR_CLK_DIV_V << APB_SARADC_SARADC_SAR_CLK_DIV_S)
#define APB_SARADC_SARADC_SAR_CLK_DIV_V  0x000000FFU
#define APB_SARADC_SARADC_SAR_CLK_DIV_S  7
/** APB_SARADC_SARADC_SAR_PATT_LEN : R/W; bitpos: [17:15]; default: 7;
 *  0 ~ 15 means length 1 ~ 16
 */
#define APB_SARADC_SARADC_SAR_PATT_LEN    0x00000007U
#define APB_SARADC_SARADC_SAR_PATT_LEN_M  (APB_SARADC_SARADC_SAR_PATT_LEN_V << APB_SARADC_SARADC_SAR_PATT_LEN_S)
#define APB_SARADC_SARADC_SAR_PATT_LEN_V  0x00000007U
#define APB_SARADC_SARADC_SAR_PATT_LEN_S  15
/** APB_SARADC_SARADC_SAR_PATT_P_CLEAR : R/W; bitpos: [23]; default: 0;
 *  clear the pointer of pattern table for DIG ADC1 CTRL
 */
#define APB_SARADC_SARADC_SAR_PATT_P_CLEAR    (BIT(23))
#define APB_SARADC_SARADC_SAR_PATT_P_CLEAR_M  (APB_SARADC_SARADC_SAR_PATT_P_CLEAR_V << APB_SARADC_SARADC_SAR_PATT_P_CLEAR_S)
#define APB_SARADC_SARADC_SAR_PATT_P_CLEAR_V  0x00000001U
#define APB_SARADC_SARADC_SAR_PATT_P_CLEAR_S  23
/** APB_SARADC_SARADC_XPD_SAR_FORCE : R/W; bitpos: [28:27]; default: 0;
 *  force option to xpd sar blocks
 */
#define APB_SARADC_SARADC_XPD_SAR_FORCE    0x00000003U
#define APB_SARADC_SARADC_XPD_SAR_FORCE_M  (APB_SARADC_SARADC_XPD_SAR_FORCE_V << APB_SARADC_SARADC_XPD_SAR_FORCE_S)
#define APB_SARADC_SARADC_XPD_SAR_FORCE_V  0x00000003U
#define APB_SARADC_SARADC_XPD_SAR_FORCE_S  27
/** APB_SARADC_SARADC2_PWDET_DRV : R/W; bitpos: [29]; default: 0;
 *  enable saradc2 power detect driven func.
 */
#define APB_SARADC_SARADC2_PWDET_DRV    (BIT(29))
#define APB_SARADC_SARADC2_PWDET_DRV_M  (APB_SARADC_SARADC2_PWDET_DRV_V << APB_SARADC_SARADC2_PWDET_DRV_S)
#define APB_SARADC_SARADC2_PWDET_DRV_V  0x00000001U
#define APB_SARADC_SARADC2_PWDET_DRV_S  29
/** APB_SARADC_SARADC_WAIT_ARB_CYCLE : R/W; bitpos: [31:30]; default: 1;
 *  wait arbit signal stable after sar_done
 */
#define APB_SARADC_SARADC_WAIT_ARB_CYCLE    0x00000003U
#define APB_SARADC_SARADC_WAIT_ARB_CYCLE_M  (APB_SARADC_SARADC_WAIT_ARB_CYCLE_V << APB_SARADC_SARADC_WAIT_ARB_CYCLE_S)
#define APB_SARADC_SARADC_WAIT_ARB_CYCLE_V  0x00000003U
#define APB_SARADC_SARADC_WAIT_ARB_CYCLE_S  30

/** APB_SARADC_CTRL2_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_CTRL2_REG (DR_REG_APB_SARADC_BASE + 0x4)
/** APB_SARADC_SARADC_MEAS_NUM_LIMIT : R/W; bitpos: [0]; default: 0;
 *  enable max meas num
 */
#define APB_SARADC_SARADC_MEAS_NUM_LIMIT    (BIT(0))
#define APB_SARADC_SARADC_MEAS_NUM_LIMIT_M  (APB_SARADC_SARADC_MEAS_NUM_LIMIT_V << APB_SARADC_SARADC_MEAS_NUM_LIMIT_S)
#define APB_SARADC_SARADC_MEAS_NUM_LIMIT_V  0x00000001U
#define APB_SARADC_SARADC_MEAS_NUM_LIMIT_S  0
/** APB_SARADC_SARADC_MAX_MEAS_NUM : R/W; bitpos: [8:1]; default: 255;
 *  max conversion number
 */
#define APB_SARADC_SARADC_MAX_MEAS_NUM    0x000000FFU
#define APB_SARADC_SARADC_MAX_MEAS_NUM_M  (APB_SARADC_SARADC_MAX_MEAS_NUM_V << APB_SARADC_SARADC_MAX_MEAS_NUM_S)
#define APB_SARADC_SARADC_MAX_MEAS_NUM_V  0x000000FFU
#define APB_SARADC_SARADC_MAX_MEAS_NUM_S  1
/** APB_SARADC_SARADC_SAR1_INV : R/W; bitpos: [9]; default: 0;
 *  1: data to DIG ADC1 CTRL is inverted, otherwise not
 */
#define APB_SARADC_SARADC_SAR1_INV    (BIT(9))
#define APB_SARADC_SARADC_SAR1_INV_M  (APB_SARADC_SARADC_SAR1_INV_V << APB_SARADC_SARADC_SAR1_INV_S)
#define APB_SARADC_SARADC_SAR1_INV_V  0x00000001U
#define APB_SARADC_SARADC_SAR1_INV_S  9
/** APB_SARADC_SARADC_SAR2_INV : R/W; bitpos: [10]; default: 0;
 *  1: data to DIG ADC2 CTRL is inverted, otherwise not
 */
#define APB_SARADC_SARADC_SAR2_INV    (BIT(10))
#define APB_SARADC_SARADC_SAR2_INV_M  (APB_SARADC_SARADC_SAR2_INV_V << APB_SARADC_SARADC_SAR2_INV_S)
#define APB_SARADC_SARADC_SAR2_INV_V  0x00000001U
#define APB_SARADC_SARADC_SAR2_INV_S  10
/** APB_SARADC_SARADC_TIMER_TARGET : R/W; bitpos: [23:12]; default: 10;
 *  to set saradc timer target
 */
#define APB_SARADC_SARADC_TIMER_TARGET    0x00000FFFU
#define APB_SARADC_SARADC_TIMER_TARGET_M  (APB_SARADC_SARADC_TIMER_TARGET_V << APB_SARADC_SARADC_TIMER_TARGET_S)
#define APB_SARADC_SARADC_TIMER_TARGET_V  0x00000FFFU
#define APB_SARADC_SARADC_TIMER_TARGET_S  12
/** APB_SARADC_SARADC_TIMER_EN : R/W; bitpos: [24]; default: 0;
 *  to enable saradc timer trigger
 */
#define APB_SARADC_SARADC_TIMER_EN    (BIT(24))
#define APB_SARADC_SARADC_TIMER_EN_M  (APB_SARADC_SARADC_TIMER_EN_V << APB_SARADC_SARADC_TIMER_EN_S)
#define APB_SARADC_SARADC_TIMER_EN_V  0x00000001U
#define APB_SARADC_SARADC_TIMER_EN_S  24

/** APB_SARADC_FILTER_CTRL1_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_FILTER_CTRL1_REG (DR_REG_APB_SARADC_BASE + 0x8)
/** APB_SARADC_APB_SARADC_FILTER_FACTOR1 : R/W; bitpos: [28:26]; default: 0;
 *  Factor of saradc filter1
 */
#define APB_SARADC_APB_SARADC_FILTER_FACTOR1    0x00000007U
#define APB_SARADC_APB_SARADC_FILTER_FACTOR1_M  (APB_SARADC_APB_SARADC_FILTER_FACTOR1_V << APB_SARADC_APB_SARADC_FILTER_FACTOR1_S)
#define APB_SARADC_APB_SARADC_FILTER_FACTOR1_V  0x00000007U
#define APB_SARADC_APB_SARADC_FILTER_FACTOR1_S  26
/** APB_SARADC_APB_SARADC_FILTER_FACTOR0 : R/W; bitpos: [31:29]; default: 0;
 *  Factor of saradc filter0
 */
#define APB_SARADC_APB_SARADC_FILTER_FACTOR0    0x00000007U
#define APB_SARADC_APB_SARADC_FILTER_FACTOR0_M  (APB_SARADC_APB_SARADC_FILTER_FACTOR0_V << APB_SARADC_APB_SARADC_FILTER_FACTOR0_S)
#define APB_SARADC_APB_SARADC_FILTER_FACTOR0_V  0x00000007U
#define APB_SARADC_APB_SARADC_FILTER_FACTOR0_S  29

/** APB_SARADC_SAR_PATT_TAB1_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_SAR_PATT_TAB1_REG (DR_REG_APB_SARADC_BASE + 0x18)
/** APB_SARADC_SARADC_SAR_PATT_TAB1 : R/W; bitpos: [23:0]; default: 16777215;
 *  item 0 ~ 3 for pattern table 1 (each item one byte)
 */
#define APB_SARADC_SARADC_SAR_PATT_TAB1    0x00FFFFFFU
#define APB_SARADC_SARADC_SAR_PATT_TAB1_M  (APB_SARADC_SARADC_SAR_PATT_TAB1_V << APB_SARADC_SARADC_SAR_PATT_TAB1_S)
#define APB_SARADC_SARADC_SAR_PATT_TAB1_V  0x00FFFFFFU
#define APB_SARADC_SARADC_SAR_PATT_TAB1_S  0

/** APB_SARADC_SAR_PATT_TAB2_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_SAR_PATT_TAB2_REG (DR_REG_APB_SARADC_BASE + 0x1c)
/** APB_SARADC_SARADC_SAR_PATT_TAB2 : R/W; bitpos: [23:0]; default: 16777215;
 *  Item 4 ~ 7 for pattern table 1 (each item one byte)
 */
#define APB_SARADC_SARADC_SAR_PATT_TAB2    0x00FFFFFFU
#define APB_SARADC_SARADC_SAR_PATT_TAB2_M  (APB_SARADC_SARADC_SAR_PATT_TAB2_V << APB_SARADC_SARADC_SAR_PATT_TAB2_S)
#define APB_SARADC_SARADC_SAR_PATT_TAB2_V  0x00FFFFFFU
#define APB_SARADC_SARADC_SAR_PATT_TAB2_S  0

/** APB_SARADC_ONETIME_SAMPLE_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_ONETIME_SAMPLE_REG (DR_REG_APB_SARADC_BASE + 0x20)
/** APB_SARADC_SARADC_ONETIME_ATTEN : R/W; bitpos: [24:23]; default: 0;
 *  configure onetime atten
 */
#define APB_SARADC_SARADC_ONETIME_ATTEN    0x00000003U
#define APB_SARADC_SARADC_ONETIME_ATTEN_M  (APB_SARADC_SARADC_ONETIME_ATTEN_V << APB_SARADC_SARADC_ONETIME_ATTEN_S)
#define APB_SARADC_SARADC_ONETIME_ATTEN_V  0x00000003U
#define APB_SARADC_SARADC_ONETIME_ATTEN_S  23
/** APB_SARADC_SARADC_ONETIME_CHANNEL : R/W; bitpos: [28:25]; default: 13;
 *  configure onetime channel
 */
#define APB_SARADC_SARADC_ONETIME_CHANNEL    0x0000000FU
#define APB_SARADC_SARADC_ONETIME_CHANNEL_M  (APB_SARADC_SARADC_ONETIME_CHANNEL_V << APB_SARADC_SARADC_ONETIME_CHANNEL_S)
#define APB_SARADC_SARADC_ONETIME_CHANNEL_V  0x0000000FU
#define APB_SARADC_SARADC_ONETIME_CHANNEL_S  25
/** APB_SARADC_SARADC_ONETIME_START : R/W; bitpos: [29]; default: 0;
 *  trigger adc onetime sample
 */
#define APB_SARADC_SARADC_ONETIME_START    (BIT(29))
#define APB_SARADC_SARADC_ONETIME_START_M  (APB_SARADC_SARADC_ONETIME_START_V << APB_SARADC_SARADC_ONETIME_START_S)
#define APB_SARADC_SARADC_ONETIME_START_V  0x00000001U
#define APB_SARADC_SARADC_ONETIME_START_S  29
/** APB_SARADC_SARADC2_ONETIME_SAMPLE : R/W; bitpos: [30]; default: 0;
 *  enable adc2 onetime sample
 */
#define APB_SARADC_SARADC2_ONETIME_SAMPLE    (BIT(30))
#define APB_SARADC_SARADC2_ONETIME_SAMPLE_M  (APB_SARADC_SARADC2_ONETIME_SAMPLE_V << APB_SARADC_SARADC2_ONETIME_SAMPLE_S)
#define APB_SARADC_SARADC2_ONETIME_SAMPLE_V  0x00000001U
#define APB_SARADC_SARADC2_ONETIME_SAMPLE_S  30
/** APB_SARADC_SARADC1_ONETIME_SAMPLE : R/W; bitpos: [31]; default: 0;
 *  enable adc1 onetime sample
 */
#define APB_SARADC_SARADC1_ONETIME_SAMPLE    (BIT(31))
#define APB_SARADC_SARADC1_ONETIME_SAMPLE_M  (APB_SARADC_SARADC1_ONETIME_SAMPLE_V << APB_SARADC_SARADC1_ONETIME_SAMPLE_S)
#define APB_SARADC_SARADC1_ONETIME_SAMPLE_V  0x00000001U
#define APB_SARADC_SARADC1_ONETIME_SAMPLE_S  31

/** APB_SARADC_ARB_CTRL_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_ARB_CTRL_REG (DR_REG_APB_SARADC_BASE + 0x24)
/** APB_SARADC_ADC_ARB_APB_FORCE : R/W; bitpos: [2]; default: 0;
 *  adc2 arbiter force to enableapb controller
 */
#define APB_SARADC_ADC_ARB_APB_FORCE    (BIT(2))
#define APB_SARADC_ADC_ARB_APB_FORCE_M  (APB_SARADC_ADC_ARB_APB_FORCE_V << APB_SARADC_ADC_ARB_APB_FORCE_S)
#define APB_SARADC_ADC_ARB_APB_FORCE_V  0x00000001U
#define APB_SARADC_ADC_ARB_APB_FORCE_S  2
/** APB_SARADC_ADC_ARB_RTC_FORCE : R/W; bitpos: [3]; default: 0;
 *  adc2 arbiter force to enable rtc controller
 */
#define APB_SARADC_ADC_ARB_RTC_FORCE    (BIT(3))
#define APB_SARADC_ADC_ARB_RTC_FORCE_M  (APB_SARADC_ADC_ARB_RTC_FORCE_V << APB_SARADC_ADC_ARB_RTC_FORCE_S)
#define APB_SARADC_ADC_ARB_RTC_FORCE_V  0x00000001U
#define APB_SARADC_ADC_ARB_RTC_FORCE_S  3
/** APB_SARADC_ADC_ARB_WIFI_FORCE : R/W; bitpos: [4]; default: 0;
 *  adc2 arbiter force to enable wifi controller
 */
#define APB_SARADC_ADC_ARB_WIFI_FORCE    (BIT(4))
#define APB_SARADC_ADC_ARB_WIFI_FORCE_M  (APB_SARADC_ADC_ARB_WIFI_FORCE_V << APB_SARADC_ADC_ARB_WIFI_FORCE_S)
#define APB_SARADC_ADC_ARB_WIFI_FORCE_V  0x00000001U
#define APB_SARADC_ADC_ARB_WIFI_FORCE_S  4
/** APB_SARADC_ADC_ARB_GRANT_FORCE : R/W; bitpos: [5]; default: 0;
 *  adc2 arbiter force grant
 */
#define APB_SARADC_ADC_ARB_GRANT_FORCE    (BIT(5))
#define APB_SARADC_ADC_ARB_GRANT_FORCE_M  (APB_SARADC_ADC_ARB_GRANT_FORCE_V << APB_SARADC_ADC_ARB_GRANT_FORCE_S)
#define APB_SARADC_ADC_ARB_GRANT_FORCE_V  0x00000001U
#define APB_SARADC_ADC_ARB_GRANT_FORCE_S  5
/** APB_SARADC_ADC_ARB_APB_PRIORITY : R/W; bitpos: [7:6]; default: 0;
 *  Set adc2 arbiterapb priority
 */
#define APB_SARADC_ADC_ARB_APB_PRIORITY    0x00000003U
#define APB_SARADC_ADC_ARB_APB_PRIORITY_M  (APB_SARADC_ADC_ARB_APB_PRIORITY_V << APB_SARADC_ADC_ARB_APB_PRIORITY_S)
#define APB_SARADC_ADC_ARB_APB_PRIORITY_V  0x00000003U
#define APB_SARADC_ADC_ARB_APB_PRIORITY_S  6
/** APB_SARADC_ADC_ARB_RTC_PRIORITY : R/W; bitpos: [9:8]; default: 1;
 *  Set adc2 arbiter rtc priority
 */
#define APB_SARADC_ADC_ARB_RTC_PRIORITY    0x00000003U
#define APB_SARADC_ADC_ARB_RTC_PRIORITY_M  (APB_SARADC_ADC_ARB_RTC_PRIORITY_V << APB_SARADC_ADC_ARB_RTC_PRIORITY_S)
#define APB_SARADC_ADC_ARB_RTC_PRIORITY_V  0x00000003U
#define APB_SARADC_ADC_ARB_RTC_PRIORITY_S  8
/** APB_SARADC_ADC_ARB_WIFI_PRIORITY : R/W; bitpos: [11:10]; default: 2;
 *  Set adc2 arbiter wifi priority
 */
#define APB_SARADC_ADC_ARB_WIFI_PRIORITY    0x00000003U
#define APB_SARADC_ADC_ARB_WIFI_PRIORITY_M  (APB_SARADC_ADC_ARB_WIFI_PRIORITY_V << APB_SARADC_ADC_ARB_WIFI_PRIORITY_S)
#define APB_SARADC_ADC_ARB_WIFI_PRIORITY_V  0x00000003U
#define APB_SARADC_ADC_ARB_WIFI_PRIORITY_S  10
/** APB_SARADC_ADC_ARB_FIX_PRIORITY : R/W; bitpos: [12]; default: 0;
 *  adc2 arbiter uses fixed priority
 */
#define APB_SARADC_ADC_ARB_FIX_PRIORITY    (BIT(12))
#define APB_SARADC_ADC_ARB_FIX_PRIORITY_M  (APB_SARADC_ADC_ARB_FIX_PRIORITY_V << APB_SARADC_ADC_ARB_FIX_PRIORITY_S)
#define APB_SARADC_ADC_ARB_FIX_PRIORITY_V  0x00000001U
#define APB_SARADC_ADC_ARB_FIX_PRIORITY_S  12

/** APB_SARADC_FILTER_CTRL0_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_FILTER_CTRL0_REG (DR_REG_APB_SARADC_BASE + 0x28)
/** APB_SARADC_APB_SARADC_FILTER_CHANNEL1 : R/W; bitpos: [21:18]; default: 13;
 *  configure filter1 to adc channel
 */
#define APB_SARADC_APB_SARADC_FILTER_CHANNEL1    0x0000000FU
#define APB_SARADC_APB_SARADC_FILTER_CHANNEL1_M  (APB_SARADC_APB_SARADC_FILTER_CHANNEL1_V << APB_SARADC_APB_SARADC_FILTER_CHANNEL1_S)
#define APB_SARADC_APB_SARADC_FILTER_CHANNEL1_V  0x0000000FU
#define APB_SARADC_APB_SARADC_FILTER_CHANNEL1_S  18
/** APB_SARADC_APB_SARADC_FILTER_CHANNEL0 : R/W; bitpos: [25:22]; default: 13;
 *  configure filter0 to adc channel
 */
#define APB_SARADC_APB_SARADC_FILTER_CHANNEL0    0x0000000FU
#define APB_SARADC_APB_SARADC_FILTER_CHANNEL0_M  (APB_SARADC_APB_SARADC_FILTER_CHANNEL0_V << APB_SARADC_APB_SARADC_FILTER_CHANNEL0_S)
#define APB_SARADC_APB_SARADC_FILTER_CHANNEL0_V  0x0000000FU
#define APB_SARADC_APB_SARADC_FILTER_CHANNEL0_S  22
/** APB_SARADC_APB_SARADC_FILTER_RESET : R/W; bitpos: [31]; default: 0;
 *  enable apb_adc1_filter
 */
#define APB_SARADC_APB_SARADC_FILTER_RESET    (BIT(31))
#define APB_SARADC_APB_SARADC_FILTER_RESET_M  (APB_SARADC_APB_SARADC_FILTER_RESET_V << APB_SARADC_APB_SARADC_FILTER_RESET_S)
#define APB_SARADC_APB_SARADC_FILTER_RESET_V  0x00000001U
#define APB_SARADC_APB_SARADC_FILTER_RESET_S  31

/** APB_SARADC_SAR1DATA_STATUS_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_SAR1DATA_STATUS_REG (DR_REG_APB_SARADC_BASE + 0x2c)
/** APB_SARADC_APB_SARADC1_DATA : RO; bitpos: [16:0]; default: 0;
 *  saradc1 data
 */
#define APB_SARADC_APB_SARADC1_DATA    0x0001FFFFU
#define APB_SARADC_APB_SARADC1_DATA_M  (APB_SARADC_APB_SARADC1_DATA_V << APB_SARADC_APB_SARADC1_DATA_S)
#define APB_SARADC_APB_SARADC1_DATA_V  0x0001FFFFU
#define APB_SARADC_APB_SARADC1_DATA_S  0

/** APB_SARADC_SAR2DATA_STATUS_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_SAR2DATA_STATUS_REG (DR_REG_APB_SARADC_BASE + 0x30)
/** APB_SARADC_APB_SARADC2_DATA : RO; bitpos: [16:0]; default: 0;
 *  saradc2 data
 */
#define APB_SARADC_APB_SARADC2_DATA    0x0001FFFFU
#define APB_SARADC_APB_SARADC2_DATA_M  (APB_SARADC_APB_SARADC2_DATA_V << APB_SARADC_APB_SARADC2_DATA_S)
#define APB_SARADC_APB_SARADC2_DATA_V  0x0001FFFFU
#define APB_SARADC_APB_SARADC2_DATA_S  0

/** APB_SARADC_THRES0_CTRL_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_THRES0_CTRL_REG (DR_REG_APB_SARADC_BASE + 0x34)
/** APB_SARADC_APB_SARADC_THRES0_CHANNEL : R/W; bitpos: [3:0]; default: 13;
 *  configure thres0 to adc channel
 */
#define APB_SARADC_APB_SARADC_THRES0_CHANNEL    0x0000000FU
#define APB_SARADC_APB_SARADC_THRES0_CHANNEL_M  (APB_SARADC_APB_SARADC_THRES0_CHANNEL_V << APB_SARADC_APB_SARADC_THRES0_CHANNEL_S)
#define APB_SARADC_APB_SARADC_THRES0_CHANNEL_V  0x0000000FU
#define APB_SARADC_APB_SARADC_THRES0_CHANNEL_S  0
/** APB_SARADC_APB_SARADC_THRES0_HIGH : R/W; bitpos: [17:5]; default: 8191;
 *  saradc thres0 monitor thres
 */
#define APB_SARADC_APB_SARADC_THRES0_HIGH    0x00001FFFU
#define APB_SARADC_APB_SARADC_THRES0_HIGH_M  (APB_SARADC_APB_SARADC_THRES0_HIGH_V << APB_SARADC_APB_SARADC_THRES0_HIGH_S)
#define APB_SARADC_APB_SARADC_THRES0_HIGH_V  0x00001FFFU
#define APB_SARADC_APB_SARADC_THRES0_HIGH_S  5
/** APB_SARADC_APB_SARADC_THRES0_LOW : R/W; bitpos: [30:18]; default: 0;
 *  saradc thres0 monitor thres
 */
#define APB_SARADC_APB_SARADC_THRES0_LOW    0x00001FFFU
#define APB_SARADC_APB_SARADC_THRES0_LOW_M  (APB_SARADC_APB_SARADC_THRES0_LOW_V << APB_SARADC_APB_SARADC_THRES0_LOW_S)
#define APB_SARADC_APB_SARADC_THRES0_LOW_V  0x00001FFFU
#define APB_SARADC_APB_SARADC_THRES0_LOW_S  18

/** APB_SARADC_THRES1_CTRL_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_THRES1_CTRL_REG (DR_REG_APB_SARADC_BASE + 0x38)
/** APB_SARADC_APB_SARADC_THRES1_CHANNEL : R/W; bitpos: [3:0]; default: 13;
 *  configure thres1 to adc channel
 */
#define APB_SARADC_APB_SARADC_THRES1_CHANNEL    0x0000000FU
#define APB_SARADC_APB_SARADC_THRES1_CHANNEL_M  (APB_SARADC_APB_SARADC_THRES1_CHANNEL_V << APB_SARADC_APB_SARADC_THRES1_CHANNEL_S)
#define APB_SARADC_APB_SARADC_THRES1_CHANNEL_V  0x0000000FU
#define APB_SARADC_APB_SARADC_THRES1_CHANNEL_S  0
/** APB_SARADC_APB_SARADC_THRES1_HIGH : R/W; bitpos: [17:5]; default: 8191;
 *  saradc thres1 monitor thres
 */
#define APB_SARADC_APB_SARADC_THRES1_HIGH    0x00001FFFU
#define APB_SARADC_APB_SARADC_THRES1_HIGH_M  (APB_SARADC_APB_SARADC_THRES1_HIGH_V << APB_SARADC_APB_SARADC_THRES1_HIGH_S)
#define APB_SARADC_APB_SARADC_THRES1_HIGH_V  0x00001FFFU
#define APB_SARADC_APB_SARADC_THRES1_HIGH_S  5
/** APB_SARADC_APB_SARADC_THRES1_LOW : R/W; bitpos: [30:18]; default: 0;
 *  saradc thres1 monitor thres
 */
#define APB_SARADC_APB_SARADC_THRES1_LOW    0x00001FFFU
#define APB_SARADC_APB_SARADC_THRES1_LOW_M  (APB_SARADC_APB_SARADC_THRES1_LOW_V << APB_SARADC_APB_SARADC_THRES1_LOW_S)
#define APB_SARADC_APB_SARADC_THRES1_LOW_V  0x00001FFFU
#define APB_SARADC_APB_SARADC_THRES1_LOW_S  18

/** APB_SARADC_THRES_CTRL_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_THRES_CTRL_REG (DR_REG_APB_SARADC_BASE + 0x3c)
/** APB_SARADC_APB_SARADC_THRES_ALL_EN : R/W; bitpos: [27]; default: 0;
 *  enable thres to all channel
 */
#define APB_SARADC_APB_SARADC_THRES_ALL_EN    (BIT(27))
#define APB_SARADC_APB_SARADC_THRES_ALL_EN_M  (APB_SARADC_APB_SARADC_THRES_ALL_EN_V << APB_SARADC_APB_SARADC_THRES_ALL_EN_S)
#define APB_SARADC_APB_SARADC_THRES_ALL_EN_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES_ALL_EN_S  27
/** APB_SARADC_APB_SARADC_THRES1_EN : R/W; bitpos: [30]; default: 0;
 *  enable thres1
 */
#define APB_SARADC_APB_SARADC_THRES1_EN    (BIT(30))
#define APB_SARADC_APB_SARADC_THRES1_EN_M  (APB_SARADC_APB_SARADC_THRES1_EN_V << APB_SARADC_APB_SARADC_THRES1_EN_S)
#define APB_SARADC_APB_SARADC_THRES1_EN_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_EN_S  30
/** APB_SARADC_APB_SARADC_THRES0_EN : R/W; bitpos: [31]; default: 0;
 *  enable thres0
 */
#define APB_SARADC_APB_SARADC_THRES0_EN    (BIT(31))
#define APB_SARADC_APB_SARADC_THRES0_EN_M  (APB_SARADC_APB_SARADC_THRES0_EN_V << APB_SARADC_APB_SARADC_THRES0_EN_S)
#define APB_SARADC_APB_SARADC_THRES0_EN_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_EN_S  31

/** APB_SARADC_INT_ENA_REG register
 *  digital saradc int register
 */
#define APB_SARADC_INT_ENA_REG (DR_REG_APB_SARADC_BASE + 0x40)
/** APB_SARADC_APB_SARADC_TSENS_INT_ENA : R/W; bitpos: [25]; default: 0;
 *  tsens low  interrupt enable
 */
#define APB_SARADC_APB_SARADC_TSENS_INT_ENA    (BIT(25))
#define APB_SARADC_APB_SARADC_TSENS_INT_ENA_M  (APB_SARADC_APB_SARADC_TSENS_INT_ENA_V << APB_SARADC_APB_SARADC_TSENS_INT_ENA_S)
#define APB_SARADC_APB_SARADC_TSENS_INT_ENA_V  0x00000001U
#define APB_SARADC_APB_SARADC_TSENS_INT_ENA_S  25
/** APB_SARADC_APB_SARADC_THRES1_LOW_INT_ENA : R/W; bitpos: [26]; default: 0;
 *  saradc thres1 low  interrupt enable
 */
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_ENA    (BIT(26))
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_ENA_M  (APB_SARADC_APB_SARADC_THRES1_LOW_INT_ENA_V << APB_SARADC_APB_SARADC_THRES1_LOW_INT_ENA_S)
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_ENA_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_ENA_S  26
/** APB_SARADC_APB_SARADC_THRES0_LOW_INT_ENA : R/W; bitpos: [27]; default: 0;
 *  saradc thres0 low interrupt enable
 */
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_ENA    (BIT(27))
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_ENA_M  (APB_SARADC_APB_SARADC_THRES0_LOW_INT_ENA_V << APB_SARADC_APB_SARADC_THRES0_LOW_INT_ENA_S)
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_ENA_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_ENA_S  27
/** APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ENA : R/W; bitpos: [28]; default: 0;
 *  saradc thres1 high interrupt enable
 */
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ENA    (BIT(28))
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ENA_M  (APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ENA_V << APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ENA_S)
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ENA_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ENA_S  28
/** APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ENA : R/W; bitpos: [29]; default: 0;
 *  saradc thres0 high interrupt enable
 */
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ENA    (BIT(29))
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ENA_M  (APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ENA_V << APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ENA_S)
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ENA_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ENA_S  29
/** APB_SARADC_APB_SARADC2_DONE_INT_ENA : R/W; bitpos: [30]; default: 0;
 *  saradc2 done interrupt enable
 */
#define APB_SARADC_APB_SARADC2_DONE_INT_ENA    (BIT(30))
#define APB_SARADC_APB_SARADC2_DONE_INT_ENA_M  (APB_SARADC_APB_SARADC2_DONE_INT_ENA_V << APB_SARADC_APB_SARADC2_DONE_INT_ENA_S)
#define APB_SARADC_APB_SARADC2_DONE_INT_ENA_V  0x00000001U
#define APB_SARADC_APB_SARADC2_DONE_INT_ENA_S  30
/** APB_SARADC_APB_SARADC1_DONE_INT_ENA : R/W; bitpos: [31]; default: 0;
 *  saradc1 done interrupt enable
 */
#define APB_SARADC_APB_SARADC1_DONE_INT_ENA    (BIT(31))
#define APB_SARADC_APB_SARADC1_DONE_INT_ENA_M  (APB_SARADC_APB_SARADC1_DONE_INT_ENA_V << APB_SARADC_APB_SARADC1_DONE_INT_ENA_S)
#define APB_SARADC_APB_SARADC1_DONE_INT_ENA_V  0x00000001U
#define APB_SARADC_APB_SARADC1_DONE_INT_ENA_S  31

/** APB_SARADC_INT_RAW_REG register
 *  digital saradc int register
 */
#define APB_SARADC_INT_RAW_REG (DR_REG_APB_SARADC_BASE + 0x44)
/** APB_SARADC_APB_SARADC_TSENS_INT_RAW : R/WTC/SS; bitpos: [25]; default: 0;
 *  saradc tsens  interrupt raw
 */
#define APB_SARADC_APB_SARADC_TSENS_INT_RAW    (BIT(25))
#define APB_SARADC_APB_SARADC_TSENS_INT_RAW_M  (APB_SARADC_APB_SARADC_TSENS_INT_RAW_V << APB_SARADC_APB_SARADC_TSENS_INT_RAW_S)
#define APB_SARADC_APB_SARADC_TSENS_INT_RAW_V  0x00000001U
#define APB_SARADC_APB_SARADC_TSENS_INT_RAW_S  25
/** APB_SARADC_APB_SARADC_THRES1_LOW_INT_RAW : R/WTC/SS; bitpos: [26]; default: 0;
 *  saradc thres1 low  interrupt raw
 */
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_RAW    (BIT(26))
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_RAW_M  (APB_SARADC_APB_SARADC_THRES1_LOW_INT_RAW_V << APB_SARADC_APB_SARADC_THRES1_LOW_INT_RAW_S)
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_RAW_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_RAW_S  26
/** APB_SARADC_APB_SARADC_THRES0_LOW_INT_RAW : R/WTC/SS; bitpos: [27]; default: 0;
 *  saradc thres0 low interrupt raw
 */
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_RAW    (BIT(27))
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_RAW_M  (APB_SARADC_APB_SARADC_THRES0_LOW_INT_RAW_V << APB_SARADC_APB_SARADC_THRES0_LOW_INT_RAW_S)
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_RAW_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_RAW_S  27
/** APB_SARADC_APB_SARADC_THRES1_HIGH_INT_RAW : R/WTC/SS; bitpos: [28]; default: 0;
 *  saradc thres1 high interrupt raw
 */
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_RAW    (BIT(28))
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_RAW_M  (APB_SARADC_APB_SARADC_THRES1_HIGH_INT_RAW_V << APB_SARADC_APB_SARADC_THRES1_HIGH_INT_RAW_S)
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_RAW_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_RAW_S  28
/** APB_SARADC_APB_SARADC_THRES0_HIGH_INT_RAW : R/WTC/SS; bitpos: [29]; default: 0;
 *  saradc thres0 high interrupt raw
 */
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_RAW    (BIT(29))
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_RAW_M  (APB_SARADC_APB_SARADC_THRES0_HIGH_INT_RAW_V << APB_SARADC_APB_SARADC_THRES0_HIGH_INT_RAW_S)
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_RAW_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_RAW_S  29
/** APB_SARADC_APB_SARADC2_DONE_INT_RAW : R/WTC/SS; bitpos: [30]; default: 0;
 *  saradc2 done interrupt raw
 */
#define APB_SARADC_APB_SARADC2_DONE_INT_RAW    (BIT(30))
#define APB_SARADC_APB_SARADC2_DONE_INT_RAW_M  (APB_SARADC_APB_SARADC2_DONE_INT_RAW_V << APB_SARADC_APB_SARADC2_DONE_INT_RAW_S)
#define APB_SARADC_APB_SARADC2_DONE_INT_RAW_V  0x00000001U
#define APB_SARADC_APB_SARADC2_DONE_INT_RAW_S  30
/** APB_SARADC_APB_SARADC1_DONE_INT_RAW : R/WTC/SS; bitpos: [31]; default: 0;
 *  saradc1 done interrupt raw
 */
#define APB_SARADC_APB_SARADC1_DONE_INT_RAW    (BIT(31))
#define APB_SARADC_APB_SARADC1_DONE_INT_RAW_M  (APB_SARADC_APB_SARADC1_DONE_INT_RAW_V << APB_SARADC_APB_SARADC1_DONE_INT_RAW_S)
#define APB_SARADC_APB_SARADC1_DONE_INT_RAW_V  0x00000001U
#define APB_SARADC_APB_SARADC1_DONE_INT_RAW_S  31

/** APB_SARADC_INT_ST_REG register
 *  digital saradc int register
 */
#define APB_SARADC_INT_ST_REG (DR_REG_APB_SARADC_BASE + 0x48)
/** APB_SARADC_APB_SARADC_TSENS_INT_ST : RO; bitpos: [25]; default: 0;
 *  saradc tsens  interrupt state
 */
#define APB_SARADC_APB_SARADC_TSENS_INT_ST    (BIT(25))
#define APB_SARADC_APB_SARADC_TSENS_INT_ST_M  (APB_SARADC_APB_SARADC_TSENS_INT_ST_V << APB_SARADC_APB_SARADC_TSENS_INT_ST_S)
#define APB_SARADC_APB_SARADC_TSENS_INT_ST_V  0x00000001U
#define APB_SARADC_APB_SARADC_TSENS_INT_ST_S  25
/** APB_SARADC_APB_SARADC_THRES1_LOW_INT_ST : RO; bitpos: [26]; default: 0;
 *  saradc thres1 low  interrupt state
 */
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_ST    (BIT(26))
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_ST_M  (APB_SARADC_APB_SARADC_THRES1_LOW_INT_ST_V << APB_SARADC_APB_SARADC_THRES1_LOW_INT_ST_S)
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_ST_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_ST_S  26
/** APB_SARADC_APB_SARADC_THRES0_LOW_INT_ST : RO; bitpos: [27]; default: 0;
 *  saradc thres0 low interrupt state
 */
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_ST    (BIT(27))
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_ST_M  (APB_SARADC_APB_SARADC_THRES0_LOW_INT_ST_V << APB_SARADC_APB_SARADC_THRES0_LOW_INT_ST_S)
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_ST_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_ST_S  27
/** APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ST : RO; bitpos: [28]; default: 0;
 *  saradc thres1 high interrupt state
 */
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ST    (BIT(28))
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ST_M  (APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ST_V << APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ST_S)
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ST_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_ST_S  28
/** APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ST : RO; bitpos: [29]; default: 0;
 *  saradc thres0 high interrupt state
 */
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ST    (BIT(29))
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ST_M  (APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ST_V << APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ST_S)
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ST_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_ST_S  29
/** APB_SARADC_APB_SARADC2_DONE_INT_ST : RO; bitpos: [30]; default: 0;
 *  saradc2 done interrupt state
 */
#define APB_SARADC_APB_SARADC2_DONE_INT_ST    (BIT(30))
#define APB_SARADC_APB_SARADC2_DONE_INT_ST_M  (APB_SARADC_APB_SARADC2_DONE_INT_ST_V << APB_SARADC_APB_SARADC2_DONE_INT_ST_S)
#define APB_SARADC_APB_SARADC2_DONE_INT_ST_V  0x00000001U
#define APB_SARADC_APB_SARADC2_DONE_INT_ST_S  30
/** APB_SARADC_APB_SARADC1_DONE_INT_ST : RO; bitpos: [31]; default: 0;
 *  saradc1 done interrupt state
 */
#define APB_SARADC_APB_SARADC1_DONE_INT_ST    (BIT(31))
#define APB_SARADC_APB_SARADC1_DONE_INT_ST_M  (APB_SARADC_APB_SARADC1_DONE_INT_ST_V << APB_SARADC_APB_SARADC1_DONE_INT_ST_S)
#define APB_SARADC_APB_SARADC1_DONE_INT_ST_V  0x00000001U
#define APB_SARADC_APB_SARADC1_DONE_INT_ST_S  31

/** APB_SARADC_INT_CLR_REG register
 *  digital saradc int register
 */
#define APB_SARADC_INT_CLR_REG (DR_REG_APB_SARADC_BASE + 0x4c)
/** APB_SARADC_APB_SARADC_TSENS_INT_CLR : WT; bitpos: [25]; default: 0;
 *  saradc tsens  interrupt clear
 */
#define APB_SARADC_APB_SARADC_TSENS_INT_CLR    (BIT(25))
#define APB_SARADC_APB_SARADC_TSENS_INT_CLR_M  (APB_SARADC_APB_SARADC_TSENS_INT_CLR_V << APB_SARADC_APB_SARADC_TSENS_INT_CLR_S)
#define APB_SARADC_APB_SARADC_TSENS_INT_CLR_V  0x00000001U
#define APB_SARADC_APB_SARADC_TSENS_INT_CLR_S  25
/** APB_SARADC_APB_SARADC_THRES1_LOW_INT_CLR : WT; bitpos: [26]; default: 0;
 *  saradc thres1 low  interrupt clear
 */
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_CLR    (BIT(26))
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_CLR_M  (APB_SARADC_APB_SARADC_THRES1_LOW_INT_CLR_V << APB_SARADC_APB_SARADC_THRES1_LOW_INT_CLR_S)
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_CLR_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_LOW_INT_CLR_S  26
/** APB_SARADC_APB_SARADC_THRES0_LOW_INT_CLR : WT; bitpos: [27]; default: 0;
 *  saradc thres0 low interrupt clear
 */
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_CLR    (BIT(27))
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_CLR_M  (APB_SARADC_APB_SARADC_THRES0_LOW_INT_CLR_V << APB_SARADC_APB_SARADC_THRES0_LOW_INT_CLR_S)
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_CLR_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_LOW_INT_CLR_S  27
/** APB_SARADC_APB_SARADC_THRES1_HIGH_INT_CLR : WT; bitpos: [28]; default: 0;
 *  saradc thres1 high interrupt clear
 */
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_CLR    (BIT(28))
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_CLR_M  (APB_SARADC_APB_SARADC_THRES1_HIGH_INT_CLR_V << APB_SARADC_APB_SARADC_THRES1_HIGH_INT_CLR_S)
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_CLR_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES1_HIGH_INT_CLR_S  28
/** APB_SARADC_APB_SARADC_THRES0_HIGH_INT_CLR : WT; bitpos: [29]; default: 0;
 *  saradc thres0 high interrupt clear
 */
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_CLR    (BIT(29))
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_CLR_M  (APB_SARADC_APB_SARADC_THRES0_HIGH_INT_CLR_V << APB_SARADC_APB_SARADC_THRES0_HIGH_INT_CLR_S)
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_CLR_V  0x00000001U
#define APB_SARADC_APB_SARADC_THRES0_HIGH_INT_CLR_S  29
/** APB_SARADC_APB_SARADC2_DONE_INT_CLR : WT; bitpos: [30]; default: 0;
 *  saradc2 done interrupt clear
 */
#define APB_SARADC_APB_SARADC2_DONE_INT_CLR    (BIT(30))
#define APB_SARADC_APB_SARADC2_DONE_INT_CLR_M  (APB_SARADC_APB_SARADC2_DONE_INT_CLR_V << APB_SARADC_APB_SARADC2_DONE_INT_CLR_S)
#define APB_SARADC_APB_SARADC2_DONE_INT_CLR_V  0x00000001U
#define APB_SARADC_APB_SARADC2_DONE_INT_CLR_S  30
/** APB_SARADC_APB_SARADC1_DONE_INT_CLR : WT; bitpos: [31]; default: 0;
 *  saradc1 done interrupt clear
 */
#define APB_SARADC_APB_SARADC1_DONE_INT_CLR    (BIT(31))
#define APB_SARADC_APB_SARADC1_DONE_INT_CLR_M  (APB_SARADC_APB_SARADC1_DONE_INT_CLR_V << APB_SARADC_APB_SARADC1_DONE_INT_CLR_S)
#define APB_SARADC_APB_SARADC1_DONE_INT_CLR_V  0x00000001U
#define APB_SARADC_APB_SARADC1_DONE_INT_CLR_S  31

/** APB_SARADC_DMA_CONF_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_DMA_CONF_REG (DR_REG_APB_SARADC_BASE + 0x50)
/** APB_SARADC_APB_ADC_EOF_NUM : R/W; bitpos: [15:0]; default: 255;
 *  the dma_in_suc_eof gen when sample cnt = spi_eof_num
 */
#define APB_SARADC_APB_ADC_EOF_NUM    0x0000FFFFU
#define APB_SARADC_APB_ADC_EOF_NUM_M  (APB_SARADC_APB_ADC_EOF_NUM_V << APB_SARADC_APB_ADC_EOF_NUM_S)
#define APB_SARADC_APB_ADC_EOF_NUM_V  0x0000FFFFU
#define APB_SARADC_APB_ADC_EOF_NUM_S  0
/** APB_SARADC_APB_ADC_RESET_FSM : R/W; bitpos: [30]; default: 0;
 *  reset_apb_adc_state
 */
#define APB_SARADC_APB_ADC_RESET_FSM    (BIT(30))
#define APB_SARADC_APB_ADC_RESET_FSM_M  (APB_SARADC_APB_ADC_RESET_FSM_V << APB_SARADC_APB_ADC_RESET_FSM_S)
#define APB_SARADC_APB_ADC_RESET_FSM_V  0x00000001U
#define APB_SARADC_APB_ADC_RESET_FSM_S  30
/** APB_SARADC_APB_ADC_TRANS : R/W; bitpos: [31]; default: 0;
 *  enable apb_adc use spi_dma
 */
#define APB_SARADC_APB_ADC_TRANS    (BIT(31))
#define APB_SARADC_APB_ADC_TRANS_M  (APB_SARADC_APB_ADC_TRANS_V << APB_SARADC_APB_ADC_TRANS_S)
#define APB_SARADC_APB_ADC_TRANS_V  0x00000001U
#define APB_SARADC_APB_ADC_TRANS_S  31

/** APB_SARADC_CLKM_CONF_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_CLKM_CONF_REG (DR_REG_APB_SARADC_BASE + 0x54)
/** APB_SARADC_CLKM_DIV_NUM : R/W; bitpos: [7:0]; default: 4;
 *  Integral I2S clock divider value
 */
#define APB_SARADC_CLKM_DIV_NUM    0x000000FFU
#define APB_SARADC_CLKM_DIV_NUM_M  (APB_SARADC_CLKM_DIV_NUM_V << APB_SARADC_CLKM_DIV_NUM_S)
#define APB_SARADC_CLKM_DIV_NUM_V  0x000000FFU
#define APB_SARADC_CLKM_DIV_NUM_S  0
/** APB_SARADC_CLKM_DIV_B : R/W; bitpos: [13:8]; default: 0;
 *  Fractional clock divider numerator value
 */
#define APB_SARADC_CLKM_DIV_B    0x0000003FU
#define APB_SARADC_CLKM_DIV_B_M  (APB_SARADC_CLKM_DIV_B_V << APB_SARADC_CLKM_DIV_B_S)
#define APB_SARADC_CLKM_DIV_B_V  0x0000003FU
#define APB_SARADC_CLKM_DIV_B_S  8
/** APB_SARADC_CLKM_DIV_A : R/W; bitpos: [19:14]; default: 0;
 *  Fractional clock divider denominator value
 */
#define APB_SARADC_CLKM_DIV_A    0x0000003FU
#define APB_SARADC_CLKM_DIV_A_M  (APB_SARADC_CLKM_DIV_A_V << APB_SARADC_CLKM_DIV_A_S)
#define APB_SARADC_CLKM_DIV_A_V  0x0000003FU
#define APB_SARADC_CLKM_DIV_A_S  14
/** APB_SARADC_CLK_EN : R/W; bitpos: [20]; default: 0;
 *  reg clk en
 */
#define APB_SARADC_CLK_EN    (BIT(20))
#define APB_SARADC_CLK_EN_M  (APB_SARADC_CLK_EN_V << APB_SARADC_CLK_EN_S)
#define APB_SARADC_CLK_EN_V  0x00000001U
#define APB_SARADC_CLK_EN_S  20
/** APB_SARADC_CLK_SEL : R/W; bitpos: [22:21]; default: 0;
 *  Set this bit to enable clk_apll
 */
#define APB_SARADC_CLK_SEL    0x00000003U
#define APB_SARADC_CLK_SEL_M  (APB_SARADC_CLK_SEL_V << APB_SARADC_CLK_SEL_S)
#define APB_SARADC_CLK_SEL_V  0x00000003U
#define APB_SARADC_CLK_SEL_S  21

/** APB_SARADC_APB_TSENS_CTRL_REG register
 *  digital tsens configure register
 */
#define APB_SARADC_APB_TSENS_CTRL_REG (DR_REG_APB_SARADC_BASE + 0x58)
/** APB_SARADC_TSENS_OUT : RO; bitpos: [7:0]; default: 128;
 *  temperature sensor data out
 */
#define APB_SARADC_TSENS_OUT    0x000000FFU
#define APB_SARADC_TSENS_OUT_M  (APB_SARADC_TSENS_OUT_V << APB_SARADC_TSENS_OUT_S)
#define APB_SARADC_TSENS_OUT_V  0x000000FFU
#define APB_SARADC_TSENS_OUT_S  0
/** APB_SARADC_TSENS_IN_INV : R/W; bitpos: [13]; default: 0;
 *  invert temperature sensor data
 */
#define APB_SARADC_TSENS_IN_INV    (BIT(13))
#define APB_SARADC_TSENS_IN_INV_M  (APB_SARADC_TSENS_IN_INV_V << APB_SARADC_TSENS_IN_INV_S)
#define APB_SARADC_TSENS_IN_INV_V  0x00000001U
#define APB_SARADC_TSENS_IN_INV_S  13
/** APB_SARADC_TSENS_CLK_DIV : R/W; bitpos: [21:14]; default: 6;
 *  temperature sensor clock divider
 */
#define APB_SARADC_TSENS_CLK_DIV    0x000000FFU
#define APB_SARADC_TSENS_CLK_DIV_M  (APB_SARADC_TSENS_CLK_DIV_V << APB_SARADC_TSENS_CLK_DIV_S)
#define APB_SARADC_TSENS_CLK_DIV_V  0x000000FFU
#define APB_SARADC_TSENS_CLK_DIV_S  14
/** APB_SARADC_TSENS_PU : R/W; bitpos: [22]; default: 0;
 *  temperature sensor power up
 */
#define APB_SARADC_TSENS_PU    (BIT(22))
#define APB_SARADC_TSENS_PU_M  (APB_SARADC_TSENS_PU_V << APB_SARADC_TSENS_PU_S)
#define APB_SARADC_TSENS_PU_V  0x00000001U
#define APB_SARADC_TSENS_PU_S  22

/** APB_SARADC_TSENS_CTRL2_REG register
 *  digital tsens configure register
 */
#define APB_SARADC_TSENS_CTRL2_REG (DR_REG_APB_SARADC_BASE + 0x5c)
/** APB_SARADC_TSENS_CLK_SEL : R/W; bitpos: [15]; default: 0;
 *  tsens clk select
 */
#define APB_SARADC_TSENS_CLK_SEL    (BIT(15))
#define APB_SARADC_TSENS_CLK_SEL_M  (APB_SARADC_TSENS_CLK_SEL_V << APB_SARADC_TSENS_CLK_SEL_S)
#define APB_SARADC_TSENS_CLK_SEL_V  0x00000001U
#define APB_SARADC_TSENS_CLK_SEL_S  15

/** APB_SARADC_CALI_REG register
 *  digital saradc configure register
 */
#define APB_SARADC_CALI_REG (DR_REG_APB_SARADC_BASE + 0x60)
/** APB_SARADC_APB_SARADC_CALI_CFG : R/W; bitpos: [16:0]; default: 32768;
 *  saradc cali factor
 */
#define APB_SARADC_APB_SARADC_CALI_CFG    0x0001FFFFU
#define APB_SARADC_APB_SARADC_CALI_CFG_M  (APB_SARADC_APB_SARADC_CALI_CFG_V << APB_SARADC_APB_SARADC_CALI_CFG_S)
#define APB_SARADC_APB_SARADC_CALI_CFG_V  0x0001FFFFU
#define APB_SARADC_APB_SARADC_CALI_CFG_S  0

/** APB_TSENS_WAKE_REG register
 *  digital tsens configure register
 */
#define APB_TSENS_WAKE_REG (DR_REG_APB_SARADC_BASE + 0x64)
/** APB_SARADC_WAKEUP_TH_LOW : R/W; bitpos: [7:0]; default: 0;
 *  reg_wakeup_th_low
 */
#define APB_SARADC_WAKEUP_TH_LOW    0x000000FFU
#define APB_SARADC_WAKEUP_TH_LOW_M  (APB_SARADC_WAKEUP_TH_LOW_V << APB_SARADC_WAKEUP_TH_LOW_S)
#define APB_SARADC_WAKEUP_TH_LOW_V  0x000000FFU
#define APB_SARADC_WAKEUP_TH_LOW_S  0
/** APB_SARADC_WAKEUP_TH_HIGH : R/W; bitpos: [15:8]; default: 255;
 *  reg_wakeup_th_high
 */
#define APB_SARADC_WAKEUP_TH_HIGH    0x000000FFU
#define APB_SARADC_WAKEUP_TH_HIGH_M  (APB_SARADC_WAKEUP_TH_HIGH_V << APB_SARADC_WAKEUP_TH_HIGH_S)
#define APB_SARADC_WAKEUP_TH_HIGH_V  0x000000FFU
#define APB_SARADC_WAKEUP_TH_HIGH_S  8
/** APB_SARADC_WAKEUP_OVER_UPPER_TH : RO; bitpos: [16]; default: 0;
 *  reg_wakeup_over_upper_th
 */
#define APB_SARADC_WAKEUP_OVER_UPPER_TH    (BIT(16))
#define APB_SARADC_WAKEUP_OVER_UPPER_TH_M  (APB_SARADC_WAKEUP_OVER_UPPER_TH_V << APB_SARADC_WAKEUP_OVER_UPPER_TH_S)
#define APB_SARADC_WAKEUP_OVER_UPPER_TH_V  0x00000001U
#define APB_SARADC_WAKEUP_OVER_UPPER_TH_S  16
/** APB_SARADC_WAKEUP_MODE : R/W; bitpos: [17]; default: 0;
 *  reg_wakeup_mode
 */
#define APB_SARADC_WAKEUP_MODE    (BIT(17))
#define APB_SARADC_WAKEUP_MODE_M  (APB_SARADC_WAKEUP_MODE_V << APB_SARADC_WAKEUP_MODE_S)
#define APB_SARADC_WAKEUP_MODE_V  0x00000001U
#define APB_SARADC_WAKEUP_MODE_S  17
/** APB_SARADC_WAKEUP_EN : R/W; bitpos: [18]; default: 0;
 *  reg_wakeup_en
 */
#define APB_SARADC_WAKEUP_EN    (BIT(18))
#define APB_SARADC_WAKEUP_EN_M  (APB_SARADC_WAKEUP_EN_V << APB_SARADC_WAKEUP_EN_S)
#define APB_SARADC_WAKEUP_EN_V  0x00000001U
#define APB_SARADC_WAKEUP_EN_S  18

/** APB_TSENS_SAMPLE_REG register
 *  digital tsens configure register
 */
#define APB_TSENS_SAMPLE_REG (DR_REG_APB_SARADC_BASE + 0x68)
/** APB_SARADC_TSENS_SAMPLE_RATE : R/W; bitpos: [15:0]; default: 20;
 *  HW sample rate
 */
#define APB_SARADC_TSENS_SAMPLE_RATE    0x0000FFFFU
#define APB_SARADC_TSENS_SAMPLE_RATE_M  (APB_SARADC_TSENS_SAMPLE_RATE_V << APB_SARADC_TSENS_SAMPLE_RATE_S)
#define APB_SARADC_TSENS_SAMPLE_RATE_V  0x0000FFFFU
#define APB_SARADC_TSENS_SAMPLE_RATE_S  0
/** APB_SARADC_TSENS_SAMPLE_EN : R/W; bitpos: [16]; default: 0;
 *  HW sample en
 */
#define APB_SARADC_TSENS_SAMPLE_EN    (BIT(16))
#define APB_SARADC_TSENS_SAMPLE_EN_M  (APB_SARADC_TSENS_SAMPLE_EN_V << APB_SARADC_TSENS_SAMPLE_EN_S)
#define APB_SARADC_TSENS_SAMPLE_EN_V  0x00000001U
#define APB_SARADC_TSENS_SAMPLE_EN_S  16

/** APB_SARADC_CTRL_DATE_REG register
 *  version
 */
#define APB_SARADC_CTRL_DATE_REG (DR_REG_APB_SARADC_BASE + 0x3fc)
/** APB_SARADC_DATE : R/W; bitpos: [31:0]; default: 35676736;
 *  version
 */
#define APB_SARADC_DATE    0xFFFFFFFFU
#define APB_SARADC_DATE_M  (APB_SARADC_DATE_V << APB_SARADC_DATE_S)
#define APB_SARADC_DATE_V  0xFFFFFFFFU
#define APB_SARADC_DATE_S  0

#ifdef __cplusplus
}
#endif
