/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdint.h>

#ifdef __cplusplus
extern "C"
{
#endif

//Interrupt hardware source table
//This table is decided by hardware, don't touch this.
typedef enum {
    ETS_WIFI_MAC_INTR_SOURCE,
    ETS_WIFI_MAC_NMI_SOURCE,
    ETS_WIFI_PWR_INTR_SOURCE,
    ETS_WIFI_BB_INTR_SOURCE,
    ETS_BT_MAC_INTR_SOURCE,
    ETS_BT_BB_INTR_SOURCE,
    ETS_BT_BB_NMI_SOURCE,
    ETS_LP_TIMER_INTR_SOURCE,
    ETS_COEX_INTR_SOURCE,
    ETS_BLE_TIMER_INTR_SOURCE,
    ETS_BLE_SEC_INTR_SOURCE,
    ETS_I2C_MST_INTR_SOURCE,
    ETS_ZB_MAC_INTR_SOURCE,
    ETS_MODEM_APB_TIMEOUT_INTR_SOURCE,
    ETS_BT_MAC_INT1_SOURCE,
    ETS_PMU_INTR_SOURCE,
    ETS_EFUSE_INTR_SOURCE,
    ETS_LP_RTC_TIMER_INTR_SOURCE,
    ETS_LP_RTC_BLE_TIMER_INTR_SOURCE,
    ETS_LP_WDT_INTR_SOURCE,
    ETS_TOUCH_INTR_SOURCE,
    ETS_HUK_INTR_SOURCE,
    ETS_CPU_INTR_FROM_CPU_0_SOURCE,
    ETS_CPU_INTR_FROM_CPU_1_SOURCE,
    ETS_CPU_INTR_FROM_CPU_2_SOURCE,
    ETS_CPU_INTR_FROM_CPU_3_SOURCE,
    ETS_BUS_MONITOR_INTR_SOURCE,
    ETS_CORE0_TRACE_INTR_SOURCE,
    ETS_CORE1_TRACE_INTR_SOURCE,
    ETS_CACHE_INTR_SOURCE,
    ETS_CPU_PERI_TIMEOUT_INTR_SOURCE,
    ETS_GPIO_INTERRUPT_PRO_SOURCE,
    ETS_GPIO_INTERRUPT_2_SOURCE,
    ETS_PAU_INTR_SOURCE,
    ETS_HP_PERI_TIMEOUT_INTR_SOURCE,
    ETS_HP_APM_M0_INTR_SOURCE,
    ETS_HP_APM_M1_INTR_SOURCE,
    ETS_HP_APM_M2_INTR_SOURCE,
    ETS_HP_APM_M3_INTR_SOURCE,
    ETS_HP_APM_M4_INTR_SOURCE,
    ETS_CPU_APM_M0_INTR_SOURCE,
    ETS_CPU_APM_M1_INTR_SOURCE,
    ETS_CPU_APM_M2_INTR_SOURCE,
    ETS_CPU_APM_M3_INTR_SOURCE,
    ETS_MSPI_INTR_SOURCE,
    ETS_I2S_INTR_SOURCE,
    ETS_UHCI0_INTR_SOURCE,
    ETS_UART0_INTR_SOURCE,
    ETS_UART1_INTR_SOURCE,
    ETS_LEDC_INTR_SOURCE,
    ETS_TWAI0_INTR_SOURCE,
    ETS_TWAI0_TIMER_INTR_SOURCE,
    ETS_USB_SERIAL_JTAG_INTR_SOURCE,
    ETS_RMT_INTR_SOURCE,
    ETS_I2C_EXT0_INTR_SOURCE,
    ETS_I2C_EXT1_INTR_SOURCE,
    ETS_TG0_T0_INTR_SOURCE,
    ETS_TG0_WDT_INTR_SOURCE,
    ETS_TG1_T0_INTR_SOURCE,
    ETS_TG1_WDT_INTR_SOURCE,
    ETS_SYSTIMER_TARGET0_INTR_SOURCE,
    ETS_SYSTIMER_TARGET1_INTR_SOURCE,
    ETS_SYSTIMER_TARGET2_INTR_SOURCE,
    ETS_APB_ADC_INTR_SOURCE,
    ETS_PWM0_INTR_SOURCE,
    ETS_PWM1_INTR_SOURCE,
    ETS_PCNT_INTR_SOURCE,
    ETS_PARL_IO_TX_INTR_SOURCE,
    ETS_PARL_IO_RX_INTR_SOURCE,
    ETS_USB_OTG11_INTR_SOURCE,
    ETS_ASRC_CHNL0_INTR_SOURCE,
    ETS_ASRC_CHNL1_INTR_SOURCE,
    ETS_ZERO_DET_INTR_SOURCE,
    ETS_DMA_IN_CH0_INTR_SOURCE,
    ETS_DMA_IN_CH1_INTR_SOURCE,
    ETS_DMA_IN_CH2_INTR_SOURCE,
    ETS_DMA_IN_CH3_INTR_SOURCE,
    ETS_DMA_IN_CH4_INTR_SOURCE,
    ETS_DMA_OUT_CH0_INTR_SOURCE,
    ETS_DMA_OUT_CH1_INTR_SOURCE,
    ETS_DMA_OUT_CH2_INTR_SOURCE,
    ETS_DMA_OUT_CH3_INTR_SOURCE,
    ETS_DMA_OUT_CH4_INTR_SOURCE,
    ETS_GPSPI2_INTR_SOURCE,
    ETS_GPSPI3_INTR_SOURCE,
    ETS_AES_INTR_SOURCE,
    ETS_SHA_INTR_SOURCE,
    ETS_ECC_INTR_SOURCE,
    ETS_ECDSA_INTR_SOURCE,
    ETS_KM_INTR_SOURCE,
    ETS_MAX_INTR_SOURCE,
} periph_interrput_t;

extern const char * const esp_isr_names[ETS_MAX_INTR_SOURCE];

#ifdef __cplusplus
}
#endif
