/**
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** INTMTX_CORE0_PMU_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_PMU_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x0)
/** INTMTX_CORE0_PMU_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_PMU_INTR mapping register
 */
#define INTMTX_CORE0_PMU_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_PMU_INTR_MAP_M  (INTMTX_CORE0_PMU_INTR_MAP_V << INTMTX_CORE0_PMU_INTR_MAP_S)
#define INTMTX_CORE0_PMU_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_PMU_INTR_MAP_S  0

/** INTMTX_CORE0_EFUSE_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_EFUSE_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x4)
/** INTMTX_CORE0_EFUSE_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_EFUSE_INTR mapping register
 */
#define INTMTX_CORE0_EFUSE_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_EFUSE_INTR_MAP_M  (INTMTX_CORE0_EFUSE_INTR_MAP_V << INTMTX_CORE0_EFUSE_INTR_MAP_S)
#define INTMTX_CORE0_EFUSE_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_EFUSE_INTR_MAP_S  0

/** INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x8)
/** INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_LP_RTC_TIMER_INTR mapping register
 */
#define INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP_M  (INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP_V << INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP_S)
#define INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_LP_RTC_TIMER_INTR_MAP_S  0

/** INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xc)
/** INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_LP_BLE_TIMER_INTR mapping register
 */
#define INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP_M  (INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP_V << INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP_S)
#define INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_LP_BLE_TIMER_INTR_MAP_S  0

/** INTMTX_CORE0_LP_WDT_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_LP_WDT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x10)
/** INTMTX_CORE0_LP_WDT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_LP_WDT_INTR mapping register
 */
#define INTMTX_CORE0_LP_WDT_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_LP_WDT_INTR_MAP_M  (INTMTX_CORE0_LP_WDT_INTR_MAP_V << INTMTX_CORE0_LP_WDT_INTR_MAP_S)
#define INTMTX_CORE0_LP_WDT_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_LP_WDT_INTR_MAP_S  0

/** INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x14)
/** INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_LP_PERI_TIMEOUT_INTR mapping register
 */
#define INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP_M  (INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP_V << INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP_S)
#define INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_LP_PERI_TIMEOUT_INTR_MAP_S  0

/** INTMTX_CORE0_LP_APM_M0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_LP_APM_M0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x18)
/** INTMTX_CORE0_LP_APM_M0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_LP_APM_M0_INTR mapping register
 */
#define INTMTX_CORE0_LP_APM_M0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_LP_APM_M0_INTR_MAP_M  (INTMTX_CORE0_LP_APM_M0_INTR_MAP_V << INTMTX_CORE0_LP_APM_M0_INTR_MAP_S)
#define INTMTX_CORE0_LP_APM_M0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_LP_APM_M0_INTR_MAP_S  0

/** INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP_REG (DR_REG_INTMTX_BASE + 0x1c)
/** INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_CPU_INTR_FROM_CPU_0 mapping register
 */
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP    0x0000001FU
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP_M  (INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP_V << INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP_S)
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP_V  0x0000001FU
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_0_MAP_S  0

/** INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP_REG (DR_REG_INTMTX_BASE + 0x20)
/** INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_CPU_INTR_FROM_CPU_1 mapping register
 */
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP    0x0000001FU
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP_M  (INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP_V << INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP_S)
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP_V  0x0000001FU
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_1_MAP_S  0

/** INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP_REG (DR_REG_INTMTX_BASE + 0x24)
/** INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_CPU_INTR_FROM_CPU_2 mapping register
 */
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP    0x0000001FU
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP_M  (INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP_V << INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP_S)
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP_V  0x0000001FU
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_2_MAP_S  0

/** INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP_REG (DR_REG_INTMTX_BASE + 0x28)
/** INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_CPU_INTR_FROM_CPU_3 mapping register
 */
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP    0x0000001FU
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP_M  (INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP_V << INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP_S)
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP_V  0x0000001FU
#define INTMTX_CORE0_CPU_INTR_FROM_CPU_3_MAP_S  0

/** INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x2c)
/** INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_ASSIST_DEBUG_INTR mapping register
 */
#define INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP_M  (INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP_V << INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP_S)
#define INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_ASSIST_DEBUG_INTR_MAP_S  0

/** INTMTX_CORE0_TRACE_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_TRACE_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x30)
/** INTMTX_CORE0_TRACE_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_TRACE_INTR mapping register
 */
#define INTMTX_CORE0_TRACE_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_TRACE_INTR_MAP_M  (INTMTX_CORE0_TRACE_INTR_MAP_V << INTMTX_CORE0_TRACE_INTR_MAP_S)
#define INTMTX_CORE0_TRACE_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_TRACE_INTR_MAP_S  0

/** INTMTX_CORE0_CACHE_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_CACHE_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x34)
/** INTMTX_CORE0_CACHE_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_CACHE_INTR mapping register
 */
#define INTMTX_CORE0_CACHE_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_CACHE_INTR_MAP_M  (INTMTX_CORE0_CACHE_INTR_MAP_V << INTMTX_CORE0_CACHE_INTR_MAP_S)
#define INTMTX_CORE0_CACHE_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_CACHE_INTR_MAP_S  0

/** INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x38)
/** INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_CPU_PERI_TIMEOUT_INTR mapping register
 */
#define INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_M  (INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_V << INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_S)
#define INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_CPU_PERI_TIMEOUT_INTR_MAP_S  0

/** INTMTX_CORE0_BT_MAC_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_BT_MAC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x3c)
/** INTMTX_CORE0_BT_MAC_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_BT_MAC_INTR mapping register
 */
#define INTMTX_CORE0_BT_MAC_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_BT_MAC_INTR_MAP_M  (INTMTX_CORE0_BT_MAC_INTR_MAP_V << INTMTX_CORE0_BT_MAC_INTR_MAP_S)
#define INTMTX_CORE0_BT_MAC_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_BT_MAC_INTR_MAP_S  0

/** INTMTX_CORE0_BT_BB_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_BT_BB_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x40)
/** INTMTX_CORE0_BT_BB_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_BT_BB_INTR mapping register
 */
#define INTMTX_CORE0_BT_BB_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_BT_BB_INTR_MAP_M  (INTMTX_CORE0_BT_BB_INTR_MAP_V << INTMTX_CORE0_BT_BB_INTR_MAP_S)
#define INTMTX_CORE0_BT_BB_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_BT_BB_INTR_MAP_S  0

/** INTMTX_CORE0_BT_BB_NMI_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_BT_BB_NMI_MAP_REG (DR_REG_INTMTX_BASE + 0x44)
/** INTMTX_CORE0_BT_BB_NMI_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_BT_BB_NMI mapping register
 */
#define INTMTX_CORE0_BT_BB_NMI_MAP    0x0000001FU
#define INTMTX_CORE0_BT_BB_NMI_MAP_M  (INTMTX_CORE0_BT_BB_NMI_MAP_V << INTMTX_CORE0_BT_BB_NMI_MAP_S)
#define INTMTX_CORE0_BT_BB_NMI_MAP_V  0x0000001FU
#define INTMTX_CORE0_BT_BB_NMI_MAP_S  0

/** INTMTX_CORE0_COEX_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_COEX_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x48)
/** INTMTX_CORE0_COEX_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_COEX_INTR mapping register
 */
#define INTMTX_CORE0_COEX_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_COEX_INTR_MAP_M  (INTMTX_CORE0_COEX_INTR_MAP_V << INTMTX_CORE0_COEX_INTR_MAP_S)
#define INTMTX_CORE0_COEX_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_COEX_INTR_MAP_S  0

/** INTMTX_CORE0_BLE_TIMER_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_BLE_TIMER_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x4c)
/** INTMTX_CORE0_BLE_TIMER_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_BLE_TIMER_INTR mapping register
 */
#define INTMTX_CORE0_BLE_TIMER_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_BLE_TIMER_INTR_MAP_M  (INTMTX_CORE0_BLE_TIMER_INTR_MAP_V << INTMTX_CORE0_BLE_TIMER_INTR_MAP_S)
#define INTMTX_CORE0_BLE_TIMER_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_BLE_TIMER_INTR_MAP_S  0

/** INTMTX_CORE0_BLE_SEC_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_BLE_SEC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x50)
/** INTMTX_CORE0_BLE_SEC_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_BLE_SEC_INTR mapping register
 */
#define INTMTX_CORE0_BLE_SEC_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_BLE_SEC_INTR_MAP_M  (INTMTX_CORE0_BLE_SEC_INTR_MAP_V << INTMTX_CORE0_BLE_SEC_INTR_MAP_S)
#define INTMTX_CORE0_BLE_SEC_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_BLE_SEC_INTR_MAP_S  0

/** INTMTX_CORE0_ZB_MAC_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_ZB_MAC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x54)
/** INTMTX_CORE0_ZB_MAC_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_ZB_MAC_INTR mapping register
 */
#define INTMTX_CORE0_ZB_MAC_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_ZB_MAC_INTR_MAP_M  (INTMTX_CORE0_ZB_MAC_INTR_MAP_V << INTMTX_CORE0_ZB_MAC_INTR_MAP_S)
#define INTMTX_CORE0_ZB_MAC_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_ZB_MAC_INTR_MAP_S  0

/** INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP_REG (DR_REG_INTMTX_BASE + 0x58)
/** INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_GPIO_INTERRUPT_PRO mapping register
 */
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP    0x0000001FU
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP_M  (INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP_V << INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP_S)
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP_V  0x0000001FU
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_MAP_S  0

/** INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_REG (DR_REG_INTMTX_BASE + 0x5c)
/** INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_GPIO_INTERRUPT_PRO_NMI mapping register
 */
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP    0x0000001FU
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_M  (INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_V << INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_S)
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_V  0x0000001FU
#define INTMTX_CORE0_GPIO_INTERRUPT_PRO_NMI_MAP_S  0

/** INTMTX_CORE0_PAU_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_PAU_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x60)
/** INTMTX_CORE0_PAU_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_PAU_INTR mapping register
 */
#define INTMTX_CORE0_PAU_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_PAU_INTR_MAP_M  (INTMTX_CORE0_PAU_INTR_MAP_V << INTMTX_CORE0_PAU_INTR_MAP_S)
#define INTMTX_CORE0_PAU_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_PAU_INTR_MAP_S  0

/** INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x64)
/** INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_HP_PERI_TIMEOUT_INTR mapping register
 */
#define INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP_M  (INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP_V << INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP_S)
#define INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_HP_PERI_TIMEOUT_INTR_MAP_S  0

/** INTMTX_CORE0_HP_APM_M0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_HP_APM_M0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x68)
/** INTMTX_CORE0_HP_APM_M0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_HP_APM_M0_INTR mapping register
 */
#define INTMTX_CORE0_HP_APM_M0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_HP_APM_M0_INTR_MAP_M  (INTMTX_CORE0_HP_APM_M0_INTR_MAP_V << INTMTX_CORE0_HP_APM_M0_INTR_MAP_S)
#define INTMTX_CORE0_HP_APM_M0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_HP_APM_M0_INTR_MAP_S  0

/** INTMTX_CORE0_HP_APM_M1_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_HP_APM_M1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x6c)
/** INTMTX_CORE0_HP_APM_M1_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_HP_APM_M1_INTR mapping register
 */
#define INTMTX_CORE0_HP_APM_M1_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_HP_APM_M1_INTR_MAP_M  (INTMTX_CORE0_HP_APM_M1_INTR_MAP_V << INTMTX_CORE0_HP_APM_M1_INTR_MAP_S)
#define INTMTX_CORE0_HP_APM_M1_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_HP_APM_M1_INTR_MAP_S  0

/** INTMTX_CORE0_HP_APM_M2_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_HP_APM_M2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x70)
/** INTMTX_CORE0_HP_APM_M2_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_HP_APM_M2_INTR mapping register
 */
#define INTMTX_CORE0_HP_APM_M2_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_HP_APM_M2_INTR_MAP_M  (INTMTX_CORE0_HP_APM_M2_INTR_MAP_V << INTMTX_CORE0_HP_APM_M2_INTR_MAP_S)
#define INTMTX_CORE0_HP_APM_M2_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_HP_APM_M2_INTR_MAP_S  0

/** INTMTX_CORE0_HP_APM_M3_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_HP_APM_M3_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x74)
/** INTMTX_CORE0_HP_APM_M3_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_HP_APM_M3_INTR mapping register
 */
#define INTMTX_CORE0_HP_APM_M3_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_HP_APM_M3_INTR_MAP_M  (INTMTX_CORE0_HP_APM_M3_INTR_MAP_V << INTMTX_CORE0_HP_APM_M3_INTR_MAP_S)
#define INTMTX_CORE0_HP_APM_M3_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_HP_APM_M3_INTR_MAP_S  0

/** INTMTX_CORE0_MSPI_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_MSPI_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x78)
/** INTMTX_CORE0_MSPI_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_MSPI_INTR mapping register
 */
#define INTMTX_CORE0_MSPI_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_MSPI_INTR_MAP_M  (INTMTX_CORE0_MSPI_INTR_MAP_V << INTMTX_CORE0_MSPI_INTR_MAP_S)
#define INTMTX_CORE0_MSPI_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_MSPI_INTR_MAP_S  0

/** INTMTX_CORE0_I2S1_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_I2S1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x7c)
/** INTMTX_CORE0_I2S1_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_I2S1_INTR mapping register
 */
#define INTMTX_CORE0_I2S1_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_I2S1_INTR_MAP_M  (INTMTX_CORE0_I2S1_INTR_MAP_V << INTMTX_CORE0_I2S1_INTR_MAP_S)
#define INTMTX_CORE0_I2S1_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_I2S1_INTR_MAP_S  0

/** INTMTX_CORE0_UHCI0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_UHCI0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x80)
/** INTMTX_CORE0_UHCI0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_UHCI0_INTR mapping register
 */
#define INTMTX_CORE0_UHCI0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_UHCI0_INTR_MAP_M  (INTMTX_CORE0_UHCI0_INTR_MAP_V << INTMTX_CORE0_UHCI0_INTR_MAP_S)
#define INTMTX_CORE0_UHCI0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_UHCI0_INTR_MAP_S  0

/** INTMTX_CORE0_UART0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_UART0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x84)
/** INTMTX_CORE0_UART0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_UART0_INTR mapping register
 */
#define INTMTX_CORE0_UART0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_UART0_INTR_MAP_M  (INTMTX_CORE0_UART0_INTR_MAP_V << INTMTX_CORE0_UART0_INTR_MAP_S)
#define INTMTX_CORE0_UART0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_UART0_INTR_MAP_S  0

/** INTMTX_CORE0_UART1_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_UART1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x88)
/** INTMTX_CORE0_UART1_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_UART1_INTR mapping register
 */
#define INTMTX_CORE0_UART1_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_UART1_INTR_MAP_M  (INTMTX_CORE0_UART1_INTR_MAP_V << INTMTX_CORE0_UART1_INTR_MAP_S)
#define INTMTX_CORE0_UART1_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_UART1_INTR_MAP_S  0

/** INTMTX_CORE0_LEDC_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_LEDC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x8c)
/** INTMTX_CORE0_LEDC_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_LEDC_INTR mapping register
 */
#define INTMTX_CORE0_LEDC_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_LEDC_INTR_MAP_M  (INTMTX_CORE0_LEDC_INTR_MAP_V << INTMTX_CORE0_LEDC_INTR_MAP_S)
#define INTMTX_CORE0_LEDC_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_LEDC_INTR_MAP_S  0

/** INTMTX_CORE0_CAN0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_CAN0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x90)
/** INTMTX_CORE0_CAN0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_CAN0_INTR mapping register
 */
#define INTMTX_CORE0_CAN0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_CAN0_INTR_MAP_M  (INTMTX_CORE0_CAN0_INTR_MAP_V << INTMTX_CORE0_CAN0_INTR_MAP_S)
#define INTMTX_CORE0_CAN0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_CAN0_INTR_MAP_S  0

/** INTMTX_CORE0_USB_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_USB_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x94)
/** INTMTX_CORE0_USB_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_USB_INTR mapping register
 */
#define INTMTX_CORE0_USB_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_USB_INTR_MAP_M  (INTMTX_CORE0_USB_INTR_MAP_V << INTMTX_CORE0_USB_INTR_MAP_S)
#define INTMTX_CORE0_USB_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_USB_INTR_MAP_S  0

/** INTMTX_CORE0_RMT_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_RMT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x98)
/** INTMTX_CORE0_RMT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_RMT_INTR mapping register
 */
#define INTMTX_CORE0_RMT_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_RMT_INTR_MAP_M  (INTMTX_CORE0_RMT_INTR_MAP_V << INTMTX_CORE0_RMT_INTR_MAP_S)
#define INTMTX_CORE0_RMT_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_RMT_INTR_MAP_S  0

/** INTMTX_CORE0_I2C_EXT0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_I2C_EXT0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x9c)
/** INTMTX_CORE0_I2C_EXT0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_I2C_EXT0_INTR mapping register
 */
#define INTMTX_CORE0_I2C_EXT0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_I2C_EXT0_INTR_MAP_M  (INTMTX_CORE0_I2C_EXT0_INTR_MAP_V << INTMTX_CORE0_I2C_EXT0_INTR_MAP_S)
#define INTMTX_CORE0_I2C_EXT0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_I2C_EXT0_INTR_MAP_S  0

/** INTMTX_CORE0_I2C_EXT1_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_I2C_EXT1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xa0)
/** INTMTX_CORE0_I2C_EXT1_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_I2C_EXT1_INTR mapping register
 */
#define INTMTX_CORE0_I2C_EXT1_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_I2C_EXT1_INTR_MAP_M  (INTMTX_CORE0_I2C_EXT1_INTR_MAP_V << INTMTX_CORE0_I2C_EXT1_INTR_MAP_S)
#define INTMTX_CORE0_I2C_EXT1_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_I2C_EXT1_INTR_MAP_S  0

/** INTMTX_CORE0_TG0_T0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_TG0_T0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xa4)
/** INTMTX_CORE0_TG0_T0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_TG0_T0_INTR mapping register
 */
#define INTMTX_CORE0_TG0_T0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_TG0_T0_INTR_MAP_M  (INTMTX_CORE0_TG0_T0_INTR_MAP_V << INTMTX_CORE0_TG0_T0_INTR_MAP_S)
#define INTMTX_CORE0_TG0_T0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_TG0_T0_INTR_MAP_S  0

/** INTMTX_CORE0_TG0_WDT_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_TG0_WDT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xa8)
/** INTMTX_CORE0_TG0_WDT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_TG0_WDT_INTR mapping register
 */
#define INTMTX_CORE0_TG0_WDT_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_TG0_WDT_INTR_MAP_M  (INTMTX_CORE0_TG0_WDT_INTR_MAP_V << INTMTX_CORE0_TG0_WDT_INTR_MAP_S)
#define INTMTX_CORE0_TG0_WDT_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_TG0_WDT_INTR_MAP_S  0

/** INTMTX_CORE0_TG1_T0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_TG1_T0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xac)
/** INTMTX_CORE0_TG1_T0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_TG1_T0_INTR mapping register
 */
#define INTMTX_CORE0_TG1_T0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_TG1_T0_INTR_MAP_M  (INTMTX_CORE0_TG1_T0_INTR_MAP_V << INTMTX_CORE0_TG1_T0_INTR_MAP_S)
#define INTMTX_CORE0_TG1_T0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_TG1_T0_INTR_MAP_S  0

/** INTMTX_CORE0_TG1_WDT_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_TG1_WDT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xb0)
/** INTMTX_CORE0_TG1_WDT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_TG1_WDT_INTR mapping register
 */
#define INTMTX_CORE0_TG1_WDT_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_TG1_WDT_INTR_MAP_M  (INTMTX_CORE0_TG1_WDT_INTR_MAP_V << INTMTX_CORE0_TG1_WDT_INTR_MAP_S)
#define INTMTX_CORE0_TG1_WDT_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_TG1_WDT_INTR_MAP_S  0

/** INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xb4)
/** INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_SYSTIMER_TARGET0_INTR mapping register
 */
#define INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP_M  (INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP_V << INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP_S)
#define INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_SYSTIMER_TARGET0_INTR_MAP_S  0

/** INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xb8)
/** INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_SYSTIMER_TARGET1_INTR mapping register
 */
#define INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP_M  (INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP_V << INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP_S)
#define INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_SYSTIMER_TARGET1_INTR_MAP_S  0

/** INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xbc)
/** INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_SYSTIMER_TARGET2_INTR mapping register
 */
#define INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP_M  (INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP_V << INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP_S)
#define INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_SYSTIMER_TARGET2_INTR_MAP_S  0

/** INTMTX_CORE0_APB_ADC_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_APB_ADC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xc0)
/** INTMTX_CORE0_APB_ADC_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_APB_ADC_INTR mapping register
 */
#define INTMTX_CORE0_APB_ADC_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_APB_ADC_INTR_MAP_M  (INTMTX_CORE0_APB_ADC_INTR_MAP_V << INTMTX_CORE0_APB_ADC_INTR_MAP_S)
#define INTMTX_CORE0_APB_ADC_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_APB_ADC_INTR_MAP_S  0

/** INTMTX_CORE0_PWM_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_PWM_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xc4)
/** INTMTX_CORE0_PWM_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_PWM_INTR mapping register
 */
#define INTMTX_CORE0_PWM_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_PWM_INTR_MAP_M  (INTMTX_CORE0_PWM_INTR_MAP_V << INTMTX_CORE0_PWM_INTR_MAP_S)
#define INTMTX_CORE0_PWM_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_PWM_INTR_MAP_S  0

/** INTMTX_CORE0_PCNT_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_PCNT_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xc8)
/** INTMTX_CORE0_PCNT_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_PCNT_INTR mapping register
 */
#define INTMTX_CORE0_PCNT_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_PCNT_INTR_MAP_M  (INTMTX_CORE0_PCNT_INTR_MAP_V << INTMTX_CORE0_PCNT_INTR_MAP_S)
#define INTMTX_CORE0_PCNT_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_PCNT_INTR_MAP_S  0

/** INTMTX_CORE0_PARL_IO_TX_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_PARL_IO_TX_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xcc)
/** INTMTX_CORE0_PARL_IO_TX_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_PARL_IO_TX_INTR mapping register
 */
#define INTMTX_CORE0_PARL_IO_TX_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_PARL_IO_TX_INTR_MAP_M  (INTMTX_CORE0_PARL_IO_TX_INTR_MAP_V << INTMTX_CORE0_PARL_IO_TX_INTR_MAP_S)
#define INTMTX_CORE0_PARL_IO_TX_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_PARL_IO_TX_INTR_MAP_S  0

/** INTMTX_CORE0_PARL_IO_RX_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_PARL_IO_RX_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xd0)
/** INTMTX_CORE0_PARL_IO_RX_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_PARL_IO_RX_INTR mapping register
 */
#define INTMTX_CORE0_PARL_IO_RX_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_PARL_IO_RX_INTR_MAP_M  (INTMTX_CORE0_PARL_IO_RX_INTR_MAP_V << INTMTX_CORE0_PARL_IO_RX_INTR_MAP_S)
#define INTMTX_CORE0_PARL_IO_RX_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_PARL_IO_RX_INTR_MAP_S  0

/** INTMTX_CORE0_DMA_IN_CH0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_DMA_IN_CH0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xd4)
/** INTMTX_CORE0_DMA_IN_CH0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_DMA_IN_CH0_INTR mapping register
 */
#define INTMTX_CORE0_DMA_IN_CH0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_DMA_IN_CH0_INTR_MAP_M  (INTMTX_CORE0_DMA_IN_CH0_INTR_MAP_V << INTMTX_CORE0_DMA_IN_CH0_INTR_MAP_S)
#define INTMTX_CORE0_DMA_IN_CH0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_DMA_IN_CH0_INTR_MAP_S  0

/** INTMTX_CORE0_DMA_IN_CH1_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_DMA_IN_CH1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xd8)
/** INTMTX_CORE0_DMA_IN_CH1_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_DMA_IN_CH1_INTR mapping register
 */
#define INTMTX_CORE0_DMA_IN_CH1_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_DMA_IN_CH1_INTR_MAP_M  (INTMTX_CORE0_DMA_IN_CH1_INTR_MAP_V << INTMTX_CORE0_DMA_IN_CH1_INTR_MAP_S)
#define INTMTX_CORE0_DMA_IN_CH1_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_DMA_IN_CH1_INTR_MAP_S  0

/** INTMTX_CORE0_DMA_IN_CH2_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_DMA_IN_CH2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xdc)
/** INTMTX_CORE0_DMA_IN_CH2_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_DMA_IN_CH2_INTR mapping register
 */
#define INTMTX_CORE0_DMA_IN_CH2_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_DMA_IN_CH2_INTR_MAP_M  (INTMTX_CORE0_DMA_IN_CH2_INTR_MAP_V << INTMTX_CORE0_DMA_IN_CH2_INTR_MAP_S)
#define INTMTX_CORE0_DMA_IN_CH2_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_DMA_IN_CH2_INTR_MAP_S  0

/** INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xe0)
/** INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_DMA_OUT_CH0_INTR mapping register
 */
#define INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP_M  (INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP_V << INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP_S)
#define INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_DMA_OUT_CH0_INTR_MAP_S  0

/** INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xe4)
/** INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_DMA_OUT_CH1_INTR mapping register
 */
#define INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP_M  (INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP_V << INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP_S)
#define INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_DMA_OUT_CH1_INTR_MAP_S  0

/** INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xe8)
/** INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_DMA_OUT_CH2_INTR mapping register
 */
#define INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP_M  (INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP_V << INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP_S)
#define INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_DMA_OUT_CH2_INTR_MAP_S  0

/** INTMTX_CORE0_GPSPI2_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_GPSPI2_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xec)
/** INTMTX_CORE0_GPSPI2_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_GPSPI2_INTR mapping register
 */
#define INTMTX_CORE0_GPSPI2_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_GPSPI2_INTR_MAP_M  (INTMTX_CORE0_GPSPI2_INTR_MAP_V << INTMTX_CORE0_GPSPI2_INTR_MAP_S)
#define INTMTX_CORE0_GPSPI2_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_GPSPI2_INTR_MAP_S  0

/** INTMTX_CORE0_AES_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_AES_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xf0)
/** INTMTX_CORE0_AES_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_AES_INTR mapping register
 */
#define INTMTX_CORE0_AES_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_AES_INTR_MAP_M  (INTMTX_CORE0_AES_INTR_MAP_V << INTMTX_CORE0_AES_INTR_MAP_S)
#define INTMTX_CORE0_AES_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_AES_INTR_MAP_S  0

/** INTMTX_CORE0_SHA_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_SHA_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xf4)
/** INTMTX_CORE0_SHA_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_SHA_INTR mapping register
 */
#define INTMTX_CORE0_SHA_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_SHA_INTR_MAP_M  (INTMTX_CORE0_SHA_INTR_MAP_V << INTMTX_CORE0_SHA_INTR_MAP_S)
#define INTMTX_CORE0_SHA_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_SHA_INTR_MAP_S  0

/** INTMTX_CORE0_RSA_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_RSA_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xf8)
/** INTMTX_CORE0_RSA_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_RSA_INTR mapping register
 */
#define INTMTX_CORE0_RSA_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_RSA_INTR_MAP_M  (INTMTX_CORE0_RSA_INTR_MAP_V << INTMTX_CORE0_RSA_INTR_MAP_S)
#define INTMTX_CORE0_RSA_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_RSA_INTR_MAP_S  0

/** INTMTX_CORE0_ECC_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_ECC_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0xfc)
/** INTMTX_CORE0_ECC_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_ECC_INTR mapping register
 */
#define INTMTX_CORE0_ECC_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_ECC_INTR_MAP_M  (INTMTX_CORE0_ECC_INTR_MAP_V << INTMTX_CORE0_ECC_INTR_MAP_S)
#define INTMTX_CORE0_ECC_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_ECC_INTR_MAP_S  0

/** INTMTX_CORE0_ECDSA_INTR_MAP_REG register
 *  register description
 */
#define INTMTX_CORE0_ECDSA_INTR_MAP_REG (DR_REG_INTMTX_BASE + 0x100)
/** INTMTX_CORE0_ECDSA_INTR_MAP : R/W; bitpos: [4:0]; default: 0;
 *  CORE0_ECDSA_INTR mapping register
 */
#define INTMTX_CORE0_ECDSA_INTR_MAP    0x0000001FU
#define INTMTX_CORE0_ECDSA_INTR_MAP_M  (INTMTX_CORE0_ECDSA_INTR_MAP_V << INTMTX_CORE0_ECDSA_INTR_MAP_S)
#define INTMTX_CORE0_ECDSA_INTR_MAP_V  0x0000001FU
#define INTMTX_CORE0_ECDSA_INTR_MAP_S  0

/** INTMTX_CORE0_INT_STATUS_REG_0_REG register
 *  register description
 */
#define INTMTX_CORE0_INT_STATUS_REG_0_REG (DR_REG_INTMTX_BASE + 0x104)
/** INTMTX_CORE0_INT_STATUS_0 : RO; bitpos: [31:0]; default: 0;
 *  Status register for interrupt sources 0~31 mapping register
 */
#define INTMTX_CORE0_INT_STATUS_0    0xFFFFFFFFU
#define INTMTX_CORE0_INT_STATUS_0_M  (INTMTX_CORE0_INT_STATUS_0_V << INTMTX_CORE0_INT_STATUS_0_S)
#define INTMTX_CORE0_INT_STATUS_0_V  0xFFFFFFFFU
#define INTMTX_CORE0_INT_STATUS_0_S  0

/** INTMTX_CORE0_INT_STATUS_REG_1_REG register
 *  register description
 */
#define INTMTX_CORE0_INT_STATUS_REG_1_REG (DR_REG_INTMTX_BASE + 0x108)
/** INTMTX_CORE0_INT_STATUS_1 : RO; bitpos: [31:0]; default: 0;
 *  Status register for interrupt sources 32~63 mapping register
 */
#define INTMTX_CORE0_INT_STATUS_1    0xFFFFFFFFU
#define INTMTX_CORE0_INT_STATUS_1_M  (INTMTX_CORE0_INT_STATUS_1_V << INTMTX_CORE0_INT_STATUS_1_S)
#define INTMTX_CORE0_INT_STATUS_1_V  0xFFFFFFFFU
#define INTMTX_CORE0_INT_STATUS_1_S  0

/** INTMTX_CORE0_INT_STATUS_REG_2_REG register
 *  register description
 */
#define INTMTX_CORE0_INT_STATUS_REG_2_REG (DR_REG_INTMTX_BASE + 0x10c)
/** INTMTX_CORE0_INT_STATUS_2 : RO; bitpos: [31:0]; default: 0;
 *  Status register for interrupt sources 64~95 mapping register
 */
#define INTMTX_CORE0_INT_STATUS_2    0xFFFFFFFFU
#define INTMTX_CORE0_INT_STATUS_2_M  (INTMTX_CORE0_INT_STATUS_2_V << INTMTX_CORE0_INT_STATUS_2_S)
#define INTMTX_CORE0_INT_STATUS_2_V  0xFFFFFFFFU
#define INTMTX_CORE0_INT_STATUS_2_S  0

/** INTMTX_CORE0_CLOCK_GATE_REG register
 *  register description
 */
#define INTMTX_CORE0_CLOCK_GATE_REG (DR_REG_INTMTX_BASE + 0x110)
/** INTMTX_CORE0_REG_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  Clock register
 */
#define INTMTX_CORE0_REG_CLK_EN    (BIT(0))
#define INTMTX_CORE0_REG_CLK_EN_M  (INTMTX_CORE0_REG_CLK_EN_V << INTMTX_CORE0_REG_CLK_EN_S)
#define INTMTX_CORE0_REG_CLK_EN_V  0x00000001U
#define INTMTX_CORE0_REG_CLK_EN_S  0

/** INTMTX_CORE0_INTERRUPT_REG_DATE_REG register
 *  register description
 */
#define INTMTX_CORE0_INTERRUPT_REG_DATE_REG (DR_REG_INTMTX_BASE + 0x7fc)
/** INTMTX_CORE0_INTERRUPT_REG_DATE : R/W; bitpos: [27:0]; default: 35688784;
 *  Version control register
 */
#define INTMTX_CORE0_INTERRUPT_REG_DATE    0x0FFFFFFFU
#define INTMTX_CORE0_INTERRUPT_REG_DATE_M  (INTMTX_CORE0_INTERRUPT_REG_DATE_V << INTMTX_CORE0_INTERRUPT_REG_DATE_S)
#define INTMTX_CORE0_INTERRUPT_REG_DATE_V  0x0FFFFFFFU
#define INTMTX_CORE0_INTERRUPT_REG_DATE_S  0

#ifdef __cplusplus
}
#endif
