/*
 *  Copyright (c) 2020, The OpenThread Authors.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the copyright holder nor the
 *     names of its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 *  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @file
 *   This file includes definitions for Multicast Listener Registration states of multicast addresses.
 */

#ifndef MLR_TYPES_HPP_
#define MLR_TYPES_HPP_

#include "openthread-core-config.h"

namespace ot {

/**
 * @addtogroup core-mlr
 *
 * @{
 */

#if OPENTHREAD_CONFIG_MLR_ENABLE || (OPENTHREAD_FTD && OPENTHREAD_CONFIG_TMF_PROXY_MLR_ENABLE)

/**
 * Multicast Listener Registration state for multicast addresses.
 */
enum MlrState : uint8_t
{
    kMlrStateToRegister,  ///< The multicast address is to be registered.
    kMlrStateRegistering, ///< The multicast address is being registered.
    kMlrStateRegistered,  ///< The multicast address is registered.
};

#endif // OPENTHREAD_CONFIG_MLR_ENABLE || (OPENTHREAD_FTD && OPENTHREAD_CONFIG_TMF_PROXY_MLR_ENABLE)

/**
 * Multicast Listener Registration (MLR) Status values.
 */
enum MlrStatus
{
    kMlrSuccess        = 0, ///< Successful (de)registration of all IPv6 addresses.
    kMlrInvalid        = 2, ///< Invalid IPv6 address(es) in request.
    kMlrNoPersistent   = 3, ///< This device does not support persistent registrations.
    kMlrNoResources    = 4, ///< BBR resource shortage.
    kMlrBbrNotPrimary  = 5, ///< BBR is not Primary at this moment.
    kMlrGeneralFailure = 6, ///< Reason(s) for failure are not further specified.
    kMlrStatusMax      = 6, ///< Max MLR status.
};

} // namespace ot

#endif // MLR_TYPES_HPP_
