/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stddef.h>
#include <stdint.h>
#include <stdbool.h>
#include "hal/assert.h"
#include "soc/hp_system_struct.h"
#include "soc/pcr_struct.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief Set arbitration priority for GDMA master port
 *
 * @param priority Arbitration priority for GDMA master port
 */
static inline void axi_icm_ll_set_gdma_arbiter_prio(uint8_t priority)
{
    HAL_ASSERT(priority < 2); // Ensure priority is within valid range (0-1)
    HP_SYSTEM.system_axi_mst_pri.system_dma_priority = priority;
}

/**
 * @brief Set arbitration priority for Cache master port
 *
 * @param priority Arbitration priority for Cache master port
 */
static inline void axi_icm_ll_set_cache_arbiter_prio(uint8_t priority)
{
    HAL_ASSERT(priority < 2); // Ensure priority is within valid range (0-1)
    HP_SYSTEM.system_axi_mst_pri.system_cache_priority = priority;
}

/**
 * @brief Reset system bus with soc core reset.
 * @param reset_with_core_reset True to reset system bus with soc core reset.
 */
static inline void axi_icm_ll_reset_with_core_reset(bool reset_with_core_reset)
{
    PCR.reset_event_bypass.reset_event_bypass = !reset_with_core_reset;
}

#ifdef __cplusplus
}
#endif
