/*
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#include "phy_init_data.h"
#include "sdkconfig.h"

const char phy_init_magic_pre[] = PHY_INIT_MAGIC;

/**
 * @brief Structure containing default recommended PHY initialization parameters.
 */
const esp_phy_init_data_t phy_init_data= { {
        3,
        3,
        0x05,
        0x09,
        0x06,
        0x05,
        0x03,
        0x06,
        0x05,
        0x04,
        0x06,
        0x04,
        0x05,
        0x00,
        0x00,
        0x00,
        0x00,
        0x05,
        0x09,
        0x06,
        0x05,
        0x03,
        0x06,
        0x05,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0xfc,
        0xfc,
        0xfe,
        0xf0,
        0xf0,
        0xf0,
        0xe0,
        0xe0,
        0xe0,
        0x18,
        0x18,
        0x18,
        LIMIT(CONFIG_ESP_PHY_MAX_TX_POWER * 4, 40, 78),
        LIMIT(CONFIG_ESP_PHY_MAX_TX_POWER * 4, 40, 72),
        LIMIT(CONFIG_ESP_PHY_MAX_TX_POWER * 4, 40, 66),
        LIMIT(CONFIG_ESP_PHY_MAX_TX_POWER * 4, 40, 60),
        LIMIT(CONFIG_ESP_PHY_MAX_TX_POWER * 4, 40, 56),
        LIMIT(CONFIG_ESP_PHY_MAX_TX_POWER * 4, 40, 52),
        0,
        1,
        1,
        2,
        2,
        3,
        4,
        5,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
} };

const char phy_init_magic_post[] = PHY_INIT_MAGIC;
