## BLE Log Compression Scheme (Preview)

### 一、Overview

This scheme scans the code of BLE stack-related components during the compilation phase, converting formatted strings and parameters in log statements into pure binary data. This improves log output efficiency and reduces the Flash footprint of the protocol stack.

Currently, the scheme supports log compression for both `BLE-MESH` and `BLE-HOST-BLUEDROID` components.

---

### 二、How to Use
This feature requires additional Python libraries. Please follow the steps below to set up the environment.

### Step 1: Verify ESP-IDF Virtual Environment
Ensure all subsequent steps are performed within the ESP-IDF Python virtual environment.

Verify activation by running:
```bash
idf.py --version
```

If the output shows `idf.py: command not found`, the virtual environment is not active.

Refer to the official documentation to configure and activate the environment:
[ESP-IDF Setup Guide](https://docs.espressif.com/projects/esp-idf/en/latest/esp32/get-started/linux-macos-setup.html)

After activation, run `idf.py --version` again. A version number confirms successful setup.

### Step 2: Check Python Version

Within the virtual environment, check the Python version:
```bash
python --version
```
If the version is lower than 3.8, upgrade Python by following the same official guide:
[Python Upgrade Guide](https://docs.espressif.com/projects/esp-idf/en/latest/esp32/get-started/linux-macos-setup.html)

### Step 3: Install Log Compression Dependencies

Choose the appropriate command below based on your operating system and terminal environment to install the required dependencies:
If you are using Linux or macos, please use the following command:
- **Linux or macOS**：
  ```bash
  pip install -r $IDF_PATH/components/bt/common/ble_log/log_compression/scripts/requirements.txt
  ```
- **Windows (PowerShell)**:
    ```ps
    pip install -r $Env:IDF_PATH\components\bt\common\ble_log\log_compression\scripts\requirements.txt
    ```
- **Windows (Command Prompt - Cmd)**:
    ```bat
    pip install -r %IDF_PATH%\components\bt\common\ble_log\log_compression\scripts\requirements.txt
    ```

#### Step 4: Clean Build Cache
After installing the dependencies, it is recommended to delete the existing build folder (if any) and rebuild the application to ensure a clean environment.


### Step 5: Configure via Menuconfig

> 

Run `idf.py menuconfig` and navigate to the following path to enable `BLE-MESH` log compression:

```(Top) -> Component config -> Bluetooth -> Common Options -> BLE Log -> Enable BLE log compression(Preview, Please read help information)->Enable BLE Mesh log compression(Preview)```.

There are three configuration items under this submenu:

- Mesh log buffer length: Sets the maximum length of a single log entry.

- Maximum number of tasks that can generate BLE mesh logs: Sets the maximum number of tasks that can output BLE-MESH logs (the default is recommended; avoid modifying this).


### Step 6: Build the Application

After configuration, build the application with:
```bash
idf.py build
```

Watch for any warnings during the build process. For example:
```txt
CMake Warning at esp/esp-idf/components/bt/common/ble_log/log_compression/CMakeLists.txt:46 (message):
  tree_sitter import failed, please check whether the package is installed
  correctly,Please refer to the
  file: esp/esp-idf/components/bt/common/ble_log/log_compression/README
  for installation instructions.
```
This indicates that the dependencies were not installed correctly, and log compression has failed—falling back to a normal build. Please repeat Steps 1–4.

If log compression is successful, you will see output similar to:
```
[0/1285] Log compression is being performed, please wait...
Log compression underway, please wait...
Found module BLE_MESH for compression
Found 111 source files in module BLE_MESH requiring compression
3055 ble log(s) compressed
Header file for compressed logs generated
```
After a successful build, the following structure will be generated under `build/ble_log/`:
```
build/ble_log/
├── ble_log_database
│   └── BLE_MESH_logs.json
├── ble_script_log_{timestamp}.log
├── .compressed_srcs
│   └── esp_ble_mesh
├── include
│   └── mesh_log_index.h
└── module_info.yml
```
- `.compressed_srcs`: Compressed C source files.
- `mesh_log_index.h`: Generated header file containing log macros.
- `BLE_MESH_logs.json`: Detailed information for each log entry.
- `ble_script_log_{timestamp}.log`: Log generated by the compression script.
- `module_info.yml`: Configuration file for compressed logging across modules.

**Do not modify these auto-generated files.**

### Step 7: Receive Logs
With log compression enabled and under the default configuration, all log levels except ERR and WARN generated by the compressed component will be redirected to the compression-log interface for output. Please refer to the BLE Log module’s documentation for how to receive these logs:  [BLE Log module](../../README.md).

## Frequently Asked Questions
1. If encoded logs cause compilation errors or missing macro definitions, delete the build folder and rebuild. If the issue persists, please report it to the Espressif BLE team.