# Wi-Fi Examples

This directory contains a range of examples ESP-IDF projects. These are intended to demonstrate the Wi-Fi functionality, and to provide code that you can copy and adapt into your own projects.

# Example Layout

The examples are grouped into sub-directories by category. Each category directory contains one or more example projects:

* `espnow` is the connectionless Wi-Fi communication protocol.
* `fast_scan` shows how to use fast scan while connecting to an AP.
* `ftm` is a how to use FTM (Fine Timing Measurement) feature to calculate distance between devices.
* `getting_started` contains the basic examples for using Wi-Fi in STA and AP mode.
* `iperf` shows the common performance measurements for two ESP running this example.
* `power_save` contains a how to use power save mode of Wi-Fi.
* `roaming` contains a example using 802.11k and 802.11v APIs.
* `scan` shows how to scan for all the available APs.
* `smart_config` shows how ESP connects to a target AP with ESPTOUCH.
* `wifi_eap_fast` shows how ESP connects to AP with Wi-Fi enterprise encryption using the EAP-FAST method.
* `wifi_easy_connect` shows how to configure an ESP device as an enrollee using Device Provisioning Protocol (DPP).
* `wpa2_enterprise` shows how ESP connects to AP with WPA2 enterprise encryption.
* `wps` contains a how to use the Wi-Fi Protected Setup protocol.

# More

See the [README.md](../README.md) file in the upper level [examples](../) directory for more information about examples.
