| Supported Targets | ESP32 | ESP32-C2 | ESP32-C3 | ESP32-C6 | ESP32-S2 | ESP32-S3 |
| ----------------- | ----- | -------- | -------- | -------- | -------- | -------- |

# Encrypted Binary OTA

This example demonstrates OTA updates with pre-encrypted binary using `esp_encrypted_img` component's APIs and tool.

Pre-encrypted firmware binary must be hosted on OTA update server.
This firmware will be fetched and then decrypted on device before being flashed.
This allows firmware to remain `confidential` on the OTA update channel irrespective of underlying transport (e.g., non-TLS).

## ESP Encrypted Image Abstraction Layer

This example uses `esp_encrypted_img` component hosted at [idf-extra-components/esp_encrypted_img](https://github.com/espressif/idf-extra-components/blob/master/esp_encrypted_img) and available though the [IDF component manager](https://components.espressif.com/component/espressif/esp_encrypted_img).

Please refer to its documentation [here](https://github.com/espressif/idf-extra-components/blob/master/esp_encrypted_img/README.md) for more details.


## How to use the example

To create self-signed certificate and key, refer to README.md in upper level 'examples' directory. This certificate should be flashed with binary as it will be used for connection with server.

### Creating RSA key for encryption

You can generate a public and private RSA key pair using following commands:

`openssl genrsa -out rsa_key/private.pem 3072`

This generates a 3072-bit RSA key pair, and writes them to a file.

Private key is required for decryption process and is used as input to the `esp_encrypted_img` component. Private key can either be embedded into the firmware or stored in NVS.

Encrypted image generation tool will derive public key (from private key) and use it for encryption purpose.

* **NOTE:** We highly recommend the use of flash encryption or NVS encryption to protect the RSA Private Key on the device.
* **NOTE:** RSA key provided in the example is for demonstration purpose only. We recommend to create a new key for production applications.

## Build and Flash example

```
idf.py build flash
```

* An encrypted image is automatically generated by build system. Upload the generated encrypted image (`build/pre_encrypted_ota_secure.bin`) to a server for performing OTA update.


## Configuration

Refer the README.md in the parent directory for the setup details.
