# Provisioning Application Examples

This primarily consists of a single unified example wifi_prov_mgr

* wifi_prov_mgr
    Abstracts out most of the complexity of Wi-Fi provisioning and allows easy switching between the SoftAP (using HTTP) and BLE transports. It also demonstrates how applications can register and use additional custom data endpoints.

Provisioning applications are available for various platforms:

* Android:
    - [BLE Provisioning app on Play Store](https://play.google.com/store/apps/details?id=com.espressif.provble).
    - [SoftAP Provisioning app on Play Store](https://play.google.com/store/apps/details?id=com.espressif.provsoftap).
    - Source code on GitHub: [esp-idf-provisioning-android](https://github.com/espressif/esp-idf-provisioning-android).
* iOS:
    - [BLE Provisioning app on app store](https://apps.apple.com/in/app/esp-ble-provisioning/id1473590141)
    - [SoftAP Provisioning app on app Store](https://apps.apple.com/in/app/esp-softap-provisioning/id1474040630)
    - Source code on GitHub: [esp-idf-provisioning-ios](https://github.com/espressif/esp-idf-provisioning-ios)
* For all other platforms a python based command line tool is provided under "$IDF_PATH/tools/esp_prov"

The Android and iOS provisioning applications allow the user to configure the device manually or by scanning a QR code. QR codes can be generated by any online QR code generator. QR code payload is encoded with a JSON string containing the device name, proof-of-possession key (if used) and transport type (BLE or softAP), for example:

```
{"ver":"v1","name":"PROV_000318","pop":"a1000318","transport":"softap"}
```

The more details about QR code format, you can refer to [QR Code Scan](https://github.com/espressif/esp-idf-provisioning-android#qr-code-scan).
