
.. _auto-suspend:

当使能 flash 擦除的自动暂停
--------------------------------------

.. important:

    您使用的 flash 需要有 suspend/resume 功能，而且不是所有具备 suspend/resume 的 flash 都可以在 {IDF_TARGET_NAME} 上使用自动暂停功能。如果您在不支持自动暂停的 flash 上使用该功能，可能会造成严重的程序崩溃。因此，我们强烈建议您在使用前阅读对应的 flash 的数据手册，确保您的 flash 可以满足如下条件, 即使这样，我们也建议您对 flash 做完整的测试：

    1. flash 状态寄存器中的 SUS bit 应当位于 SR2 bit7 ( 或者是 SR bit15 )(这是当前软件的实现限制)。
    2. 暂停的命令是 75H，恢复的命令是 7AH(这是当前软件的实现限制)。
    3. 当 flash 芯片成功暂停之后，除了正在被擦除的段或块外的任何 flash 地址中的的内容，都可以被正确的读取。恢复命令也可以在这种状态下立即下达。
    4. 当 flash 已经从暂停的模式恢复后，另一个暂停命令可以立即下达。

当使能 flash 擦除的自动暂停，访问 SPI1 时（如擦除、写入、读取主 flash ） cache 便无需被禁用。硬件会负责仲裁二者的访问。

当 SPI1 操作较短时（如读取操作）， CPU 和 cache 会等待直到 SPI1 的操作结束。然而对于一个擦除操作，自动暂停会发生并打断擦除操作，允许 CPU 能够在有限时间内从 cache 读取数据。

因此，部分的代码及变量便可以放入 flash / PSRAM 而非 IRAM / DRAM ，同时仍然能够在 flash 擦除期间被执行。这样就减少了 IRAM / DRAM 的消耗。

请注意这个功能会带来 flash 暂停及恢复时的额外开销。如果被频繁打断， flash 的擦除时间可能异常的长。为了确保 flash 擦除操作在一个合理的时间内完成，请调整 FreeRTOS 任务优先级，这样仅有那些高于擦除任务优先级的任务，会在擦除进行过程中会被执行。

换句话说，代码可以分为以下三类：

1. 关键代码：放置在 IRAM / DRAM 中。这类代码通常有较高的性能要求，与 cache / flash / PSRAM 相关，或者被频繁调用。
2. cache 访问的代码：放置在 flash / PSRAM中。这类代码的性能要求较低，或者较少被调用。他们会在 flash 擦除的时候被执行，带来一定的开销。
3. 低优先级代码：放置在 flash / PSRAM 中，并且在 flash 擦除的期间被禁止运行。这类代码的任务优先级应被设置的低于擦除任务，从而避免影响 flash 擦除的速度。
