/**
 * SPDX-FileCopyrightText: 2022 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "modem/reg_base.h"
#ifdef __cplusplus
extern "C" {
#endif

#define MODEM_LPCON_TEST_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x0)
/* MODEM_LPCON_CLK_EN : R/W; bitpos: [0]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_EN    (BIT(0))
#define MODEM_LPCON_CLK_EN_M  (MODEM_LPCON_CLK_EN_V << MODEM_LPCON_CLK_EN_S)
#define MODEM_LPCON_CLK_EN_V  0x00000001U
#define MODEM_LPCON_CLK_EN_S  0
/* MODEM_LPCON_CLK_DEBUG_ENA : R/W; bitpos: [1]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_DEBUG_ENA    (BIT(1))
#define MODEM_LPCON_CLK_DEBUG_ENA_M  (MODEM_LPCON_CLK_DEBUG_ENA_V << MODEM_LPCON_CLK_DEBUG_ENA_S)
#define MODEM_LPCON_CLK_DEBUG_ENA_V  0x00000001U
#define MODEM_LPCON_CLK_DEBUG_ENA_S  1

#define MODEM_LPCON_LP_TIMER_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x4)
/* MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW : R/W; bitpos: [0]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW    (BIT(0))
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_M  (MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_V << MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_S)
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_SLOW_S  0
/* MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST : R/W; bitpos: [1]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST    (BIT(1))
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_M  (MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_V << MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_S)
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_SEL_OSC_FAST_S  1
/* MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL : R/W; bitpos: [2]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL    (BIT(2))
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_M  (MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_V << MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_S)
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL_S  2
/* MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K : R/W; bitpos: [3]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K    (BIT(3))
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_M  (MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_V << MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_S)
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_SEL_XTAL32K_S  3
/* MODEM_LPCON_CLK_LP_TIMER_DIV_NUM : R/W; bitpos: [15:4]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_LP_TIMER_DIV_NUM    0x00000FFFU
#define MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_M  (MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_V << MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_S)
#define MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_V  0x00000FFFU
#define MODEM_LPCON_CLK_LP_TIMER_DIV_NUM_S  4

#define MODEM_LPCON_COEX_LP_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x8)
/* MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW : R/W; bitpos: [0]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW    (BIT(0))
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_M  (MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_V << MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_S)
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_SLOW_S  0
/* MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST : R/W; bitpos: [1]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST    (BIT(1))
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_M  (MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_V << MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_S)
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_LP_SEL_OSC_FAST_S  1
/* MODEM_LPCON_CLK_COEX_LP_SEL_XTAL : R/W; bitpos: [2]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL    (BIT(2))
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_M  (MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_V << MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_S)
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL_S  2
/* MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K : R/W; bitpos: [3]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K    (BIT(3))
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_M  (MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_V << MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_S)
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_LP_SEL_XTAL32K_S  3
/* MODEM_LPCON_CLK_COEX_LP_DIV_NUM : R/W; bitpos: [15:4]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_COEX_LP_DIV_NUM    0x00000FFFU
#define MODEM_LPCON_CLK_COEX_LP_DIV_NUM_M  (MODEM_LPCON_CLK_COEX_LP_DIV_NUM_V << MODEM_LPCON_CLK_COEX_LP_DIV_NUM_S)
#define MODEM_LPCON_CLK_COEX_LP_DIV_NUM_V  0x00000FFFU
#define MODEM_LPCON_CLK_COEX_LP_DIV_NUM_S  4

#define MODEM_LPCON_WIFI_LP_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0xc)
/* MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW : R/W; bitpos: [0]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW    (BIT(0))
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_M  (MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_V << MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_SLOW_S  0
/* MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST : R/W; bitpos: [1]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST    (BIT(1))
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_M  (MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_V << MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_OSC_FAST_S  1
/* MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL : R/W; bitpos: [2]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL    (BIT(2))
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_M  (MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_V << MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL_S  2
/* MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K : R/W; bitpos: [3]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K    (BIT(3))
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_M  (MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_V << MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_LP_SEL_XTAL32K_S  3
/* MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM : R/W; bitpos: [15:4]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM    0x00000FFFU
#define MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_M  (MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_V << MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_S)
#define MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_V  0x00000FFFU
#define MODEM_LPCON_CLK_WIFIPWR_LP_DIV_NUM_S  4

#define MODEM_LPCON_I2C_MST_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x10)
/* MODEM_LPCON_CLK_I2C_MST_SEL_160M : R/W; bitpos: [0]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_I2C_MST_SEL_160M    (BIT(0))
#define MODEM_LPCON_CLK_I2C_MST_SEL_160M_M  (MODEM_LPCON_CLK_I2C_MST_SEL_160M_V << MODEM_LPCON_CLK_I2C_MST_SEL_160M_S)
#define MODEM_LPCON_CLK_I2C_MST_SEL_160M_V  0x00000001U
#define MODEM_LPCON_CLK_I2C_MST_SEL_160M_S  0

#define MODEM_LPCON_MODEM_32K_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x14)
/* MODEM_LPCON_CLK_MODEM_32K_SEL : R/W; bitpos: [1:0]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_MODEM_32K_SEL    0x00000003U
#define MODEM_LPCON_CLK_MODEM_32K_SEL_M  (MODEM_LPCON_CLK_MODEM_32K_SEL_V << MODEM_LPCON_CLK_MODEM_32K_SEL_S)
#define MODEM_LPCON_CLK_MODEM_32K_SEL_V  0x00000003U
#define MODEM_LPCON_CLK_MODEM_32K_SEL_S  0

#define MODEM_LPCON_CLK_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x18)
/* MODEM_LPCON_CLK_WIFIPWR_EN : R/W; bitpos: [0]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_WIFIPWR_EN    (BIT(0))
#define MODEM_LPCON_CLK_WIFIPWR_EN_M  (MODEM_LPCON_CLK_WIFIPWR_EN_V << MODEM_LPCON_CLK_WIFIPWR_EN_S)
#define MODEM_LPCON_CLK_WIFIPWR_EN_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_EN_S  0
/* MODEM_LPCON_CLK_COEX_EN : R/W; bitpos: [1]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_COEX_EN    (BIT(1))
#define MODEM_LPCON_CLK_COEX_EN_M  (MODEM_LPCON_CLK_COEX_EN_V << MODEM_LPCON_CLK_COEX_EN_S)
#define MODEM_LPCON_CLK_COEX_EN_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_EN_S  1
/* MODEM_LPCON_CLK_I2C_MST_EN : R/W; bitpos: [2]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_I2C_MST_EN    (BIT(2))
#define MODEM_LPCON_CLK_I2C_MST_EN_M  (MODEM_LPCON_CLK_I2C_MST_EN_V << MODEM_LPCON_CLK_I2C_MST_EN_S)
#define MODEM_LPCON_CLK_I2C_MST_EN_V  0x00000001U
#define MODEM_LPCON_CLK_I2C_MST_EN_S  2
/* MODEM_LPCON_CLK_LP_TIMER_EN : R/W; bitpos: [3]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_LP_TIMER_EN    (BIT(3))
#define MODEM_LPCON_CLK_LP_TIMER_EN_M  (MODEM_LPCON_CLK_LP_TIMER_EN_V << MODEM_LPCON_CLK_LP_TIMER_EN_S)
#define MODEM_LPCON_CLK_LP_TIMER_EN_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_EN_S  3

#define MODEM_LPCON_CLK_CONF_FORCE_ON_REG (DR_REG_MODEM_LPCON_BASE + 0x1c)
/* MODEM_LPCON_CLK_WIFIPWR_FO : R/W; bitpos: [0]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_WIFIPWR_FO    (BIT(0))
#define MODEM_LPCON_CLK_WIFIPWR_FO_M  (MODEM_LPCON_CLK_WIFIPWR_FO_V << MODEM_LPCON_CLK_WIFIPWR_FO_S)
#define MODEM_LPCON_CLK_WIFIPWR_FO_V  0x00000001U
#define MODEM_LPCON_CLK_WIFIPWR_FO_S  0
/* MODEM_LPCON_CLK_COEX_FO : R/W; bitpos: [1]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_COEX_FO    (BIT(1))
#define MODEM_LPCON_CLK_COEX_FO_M  (MODEM_LPCON_CLK_COEX_FO_V << MODEM_LPCON_CLK_COEX_FO_S)
#define MODEM_LPCON_CLK_COEX_FO_V  0x00000001U
#define MODEM_LPCON_CLK_COEX_FO_S  1
/* MODEM_LPCON_CLK_I2C_MST_FO : R/W; bitpos: [2]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_I2C_MST_FO    (BIT(2))
#define MODEM_LPCON_CLK_I2C_MST_FO_M  (MODEM_LPCON_CLK_I2C_MST_FO_V << MODEM_LPCON_CLK_I2C_MST_FO_S)
#define MODEM_LPCON_CLK_I2C_MST_FO_V  0x00000001U
#define MODEM_LPCON_CLK_I2C_MST_FO_S  2
/* MODEM_LPCON_CLK_LP_TIMER_FO : R/W; bitpos: [3]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_LP_TIMER_FO    (BIT(3))
#define MODEM_LPCON_CLK_LP_TIMER_FO_M  (MODEM_LPCON_CLK_LP_TIMER_FO_V << MODEM_LPCON_CLK_LP_TIMER_FO_S)
#define MODEM_LPCON_CLK_LP_TIMER_FO_V  0x00000001U
#define MODEM_LPCON_CLK_LP_TIMER_FO_S  3
/* MODEM_LPCON_CLK_BCMEM_FO : R/W; bitpos: [4]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_BCMEM_FO    (BIT(4))
#define MODEM_LPCON_CLK_BCMEM_FO_M  (MODEM_LPCON_CLK_BCMEM_FO_V << MODEM_LPCON_CLK_BCMEM_FO_S)
#define MODEM_LPCON_CLK_BCMEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_BCMEM_FO_S  4
/* MODEM_LPCON_CLK_I2C_MST_MEM_FO : R/W; bitpos: [5]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_I2C_MST_MEM_FO    (BIT(5))
#define MODEM_LPCON_CLK_I2C_MST_MEM_FO_M  (MODEM_LPCON_CLK_I2C_MST_MEM_FO_V << MODEM_LPCON_CLK_I2C_MST_MEM_FO_S)
#define MODEM_LPCON_CLK_I2C_MST_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_I2C_MST_MEM_FO_S  5
/* MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO : R/W; bitpos: [6]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO    (BIT(6))
#define MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_M  (MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_V << MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_S)
#define MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_CHAN_FREQ_MEM_FO_S  6
/* MODEM_LPCON_CLK_PBUS_MEM_FO : R/W; bitpos: [7]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_PBUS_MEM_FO    (BIT(7))
#define MODEM_LPCON_CLK_PBUS_MEM_FO_M  (MODEM_LPCON_CLK_PBUS_MEM_FO_V << MODEM_LPCON_CLK_PBUS_MEM_FO_S)
#define MODEM_LPCON_CLK_PBUS_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_PBUS_MEM_FO_S  7
/* MODEM_LPCON_CLK_AGC_MEM_FO : R/W; bitpos: [8]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_AGC_MEM_FO    (BIT(8))
#define MODEM_LPCON_CLK_AGC_MEM_FO_M  (MODEM_LPCON_CLK_AGC_MEM_FO_V << MODEM_LPCON_CLK_AGC_MEM_FO_S)
#define MODEM_LPCON_CLK_AGC_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_AGC_MEM_FO_S  8
/* MODEM_LPCON_CLK_DC_MEM_FO : R/W; bitpos: [9]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_DC_MEM_FO    (BIT(9))
#define MODEM_LPCON_CLK_DC_MEM_FO_M  (MODEM_LPCON_CLK_DC_MEM_FO_V << MODEM_LPCON_CLK_DC_MEM_FO_S)
#define MODEM_LPCON_CLK_DC_MEM_FO_V  0x00000001U
#define MODEM_LPCON_CLK_DC_MEM_FO_S  9

#define MODEM_LPCON_CLK_CONF_POWER_ST_REG (DR_REG_MODEM_LPCON_BASE + 0x20)
/* MODEM_LPCON_CLK_WIFIPWR_ST_MAP : R/W; bitpos: [19:16]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_WIFIPWR_ST_MAP    0x0000000FU
#define MODEM_LPCON_CLK_WIFIPWR_ST_MAP_M  (MODEM_LPCON_CLK_WIFIPWR_ST_MAP_V << MODEM_LPCON_CLK_WIFIPWR_ST_MAP_S)
#define MODEM_LPCON_CLK_WIFIPWR_ST_MAP_V  0x0000000FU
#define MODEM_LPCON_CLK_WIFIPWR_ST_MAP_S  16
/* MODEM_LPCON_CLK_COEX_ST_MAP : R/W; bitpos: [23:20]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_COEX_ST_MAP    0x0000000FU
#define MODEM_LPCON_CLK_COEX_ST_MAP_M  (MODEM_LPCON_CLK_COEX_ST_MAP_V << MODEM_LPCON_CLK_COEX_ST_MAP_S)
#define MODEM_LPCON_CLK_COEX_ST_MAP_V  0x0000000FU
#define MODEM_LPCON_CLK_COEX_ST_MAP_S  20
/* MODEM_LPCON_CLK_I2C_MST_ST_MAP : R/W; bitpos: [27:24]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_I2C_MST_ST_MAP    0x0000000FU
#define MODEM_LPCON_CLK_I2C_MST_ST_MAP_M  (MODEM_LPCON_CLK_I2C_MST_ST_MAP_V << MODEM_LPCON_CLK_I2C_MST_ST_MAP_S)
#define MODEM_LPCON_CLK_I2C_MST_ST_MAP_V  0x0000000FU
#define MODEM_LPCON_CLK_I2C_MST_ST_MAP_S  24
/* MODEM_LPCON_CLK_LP_APB_ST_MAP : R/W; bitpos: [31:28]; default: 0; */
/*description: */
#define MODEM_LPCON_CLK_LP_APB_ST_MAP    0x0000000FU
#define MODEM_LPCON_CLK_LP_APB_ST_MAP_M  (MODEM_LPCON_CLK_LP_APB_ST_MAP_V << MODEM_LPCON_CLK_LP_APB_ST_MAP_S)
#define MODEM_LPCON_CLK_LP_APB_ST_MAP_V  0x0000000FU
#define MODEM_LPCON_CLK_LP_APB_ST_MAP_S  28

#define MODEM_LPCON_RST_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x24)
/* MODEM_LPCON_RST_WIFIPWR : WO; bitpos: [0]; default: 0; */
/*description: */
#define MODEM_LPCON_RST_WIFIPWR    (BIT(0))
#define MODEM_LPCON_RST_WIFIPWR_M  (MODEM_LPCON_RST_WIFIPWR_V << MODEM_LPCON_RST_WIFIPWR_S)
#define MODEM_LPCON_RST_WIFIPWR_V  0x00000001U
#define MODEM_LPCON_RST_WIFIPWR_S  0
/* MODEM_LPCON_RST_COEX : WO; bitpos: [1]; default: 0; */
/*description: */
#define MODEM_LPCON_RST_COEX    (BIT(1))
#define MODEM_LPCON_RST_COEX_M  (MODEM_LPCON_RST_COEX_V << MODEM_LPCON_RST_COEX_S)
#define MODEM_LPCON_RST_COEX_V  0x00000001U
#define MODEM_LPCON_RST_COEX_S  1
/* MODEM_LPCON_RST_I2C_MST : WO; bitpos: [2]; default: 0; */
/*description: */
#define MODEM_LPCON_RST_I2C_MST    (BIT(2))
#define MODEM_LPCON_RST_I2C_MST_M  (MODEM_LPCON_RST_I2C_MST_V << MODEM_LPCON_RST_I2C_MST_S)
#define MODEM_LPCON_RST_I2C_MST_V  0x00000001U
#define MODEM_LPCON_RST_I2C_MST_S  2
/* MODEM_LPCON_RST_LP_TIMER : WO; bitpos: [3]; default: 0; */
/*description: */
#define MODEM_LPCON_RST_LP_TIMER    (BIT(3))
#define MODEM_LPCON_RST_LP_TIMER_M  (MODEM_LPCON_RST_LP_TIMER_V << MODEM_LPCON_RST_LP_TIMER_S)
#define MODEM_LPCON_RST_LP_TIMER_V  0x00000001U
#define MODEM_LPCON_RST_LP_TIMER_S  3

#define MODEM_LPCON_MEM_CONF_REG (DR_REG_MODEM_LPCON_BASE + 0x28)
/* MODEM_LPCON_DC_MEM_FORCE_PU : R/W; bitpos: [0]; default: 1; */
/*description: */
#define MODEM_LPCON_DC_MEM_FORCE_PU    (BIT(0))
#define MODEM_LPCON_DC_MEM_FORCE_PU_M  (MODEM_LPCON_DC_MEM_FORCE_PU_V << MODEM_LPCON_DC_MEM_FORCE_PU_S)
#define MODEM_LPCON_DC_MEM_FORCE_PU_V  0x00000001U
#define MODEM_LPCON_DC_MEM_FORCE_PU_S  0
/* MODEM_LPCON_DC_MEM_FORCE_PD : R/W; bitpos: [1]; default: 0; */
/*description: */
#define MODEM_LPCON_DC_MEM_FORCE_PD    (BIT(1))
#define MODEM_LPCON_DC_MEM_FORCE_PD_M  (MODEM_LPCON_DC_MEM_FORCE_PD_V << MODEM_LPCON_DC_MEM_FORCE_PD_S)
#define MODEM_LPCON_DC_MEM_FORCE_PD_V  0x00000001U
#define MODEM_LPCON_DC_MEM_FORCE_PD_S  1
/* MODEM_LPCON_AGC_MEM_FORCE_PU : R/W; bitpos: [2]; default: 1; */
/*description: */
#define MODEM_LPCON_AGC_MEM_FORCE_PU    (BIT(2))
#define MODEM_LPCON_AGC_MEM_FORCE_PU_M  (MODEM_LPCON_AGC_MEM_FORCE_PU_V << MODEM_LPCON_AGC_MEM_FORCE_PU_S)
#define MODEM_LPCON_AGC_MEM_FORCE_PU_V  0x00000001U
#define MODEM_LPCON_AGC_MEM_FORCE_PU_S  2
/* MODEM_LPCON_AGC_MEM_FORCE_PD : R/W; bitpos: [3]; default: 0; */
/*description: */
#define MODEM_LPCON_AGC_MEM_FORCE_PD    (BIT(3))
#define MODEM_LPCON_AGC_MEM_FORCE_PD_M  (MODEM_LPCON_AGC_MEM_FORCE_PD_V << MODEM_LPCON_AGC_MEM_FORCE_PD_S)
#define MODEM_LPCON_AGC_MEM_FORCE_PD_V  0x00000001U
#define MODEM_LPCON_AGC_MEM_FORCE_PD_S  3
/* MODEM_LPCON_PBUS_MEM_FORCE_PU : R/W; bitpos: [4]; default: 1; */
/*description: */
#define MODEM_LPCON_PBUS_MEM_FORCE_PU    (BIT(4))
#define MODEM_LPCON_PBUS_MEM_FORCE_PU_M  (MODEM_LPCON_PBUS_MEM_FORCE_PU_V << MODEM_LPCON_PBUS_MEM_FORCE_PU_S)
#define MODEM_LPCON_PBUS_MEM_FORCE_PU_V  0x00000001U
#define MODEM_LPCON_PBUS_MEM_FORCE_PU_S  4
/* MODEM_LPCON_PBUS_MEM_FORCE_PD : R/W; bitpos: [5]; default: 0; */
/*description: */
#define MODEM_LPCON_PBUS_MEM_FORCE_PD    (BIT(5))
#define MODEM_LPCON_PBUS_MEM_FORCE_PD_M  (MODEM_LPCON_PBUS_MEM_FORCE_PD_V << MODEM_LPCON_PBUS_MEM_FORCE_PD_S)
#define MODEM_LPCON_PBUS_MEM_FORCE_PD_V  0x00000001U
#define MODEM_LPCON_PBUS_MEM_FORCE_PD_S  5
/* MODEM_LPCON_BC_MEM_FORCE_PU : R/W; bitpos: [6]; default: 0; */
/*description: */
#define MODEM_LPCON_BC_MEM_FORCE_PU    (BIT(6))
#define MODEM_LPCON_BC_MEM_FORCE_PU_M  (MODEM_LPCON_BC_MEM_FORCE_PU_V << MODEM_LPCON_BC_MEM_FORCE_PU_S)
#define MODEM_LPCON_BC_MEM_FORCE_PU_V  0x00000001U
#define MODEM_LPCON_BC_MEM_FORCE_PU_S  6
/* MODEM_LPCON_BC_MEM_FORCE_PD : R/W; bitpos: [7]; default: 0; */
/*description: */
#define MODEM_LPCON_BC_MEM_FORCE_PD    (BIT(7))
#define MODEM_LPCON_BC_MEM_FORCE_PD_M  (MODEM_LPCON_BC_MEM_FORCE_PD_V << MODEM_LPCON_BC_MEM_FORCE_PD_S)
#define MODEM_LPCON_BC_MEM_FORCE_PD_V  0x00000001U
#define MODEM_LPCON_BC_MEM_FORCE_PD_S  7
/* MODEM_LPCON_I2C_MST_MEM_FORCE_PU : R/W; bitpos: [8]; default: 0; */
/*description: */
#define MODEM_LPCON_I2C_MST_MEM_FORCE_PU    (BIT(8))
#define MODEM_LPCON_I2C_MST_MEM_FORCE_PU_M  (MODEM_LPCON_I2C_MST_MEM_FORCE_PU_V << MODEM_LPCON_I2C_MST_MEM_FORCE_PU_S)
#define MODEM_LPCON_I2C_MST_MEM_FORCE_PU_V  0x00000001U
#define MODEM_LPCON_I2C_MST_MEM_FORCE_PU_S  8
/* MODEM_LPCON_I2C_MST_MEM_FORCE_PD : R/W; bitpos: [9]; default: 0; */
/*description: */
#define MODEM_LPCON_I2C_MST_MEM_FORCE_PD    (BIT(9))
#define MODEM_LPCON_I2C_MST_MEM_FORCE_PD_M  (MODEM_LPCON_I2C_MST_MEM_FORCE_PD_V << MODEM_LPCON_I2C_MST_MEM_FORCE_PD_S)
#define MODEM_LPCON_I2C_MST_MEM_FORCE_PD_V  0x00000001U
#define MODEM_LPCON_I2C_MST_MEM_FORCE_PD_S  9
/* MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PU : R/W; bitpos: [10]; default: 0; */
/*description: */
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PU    (BIT(10))
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PU_M  (MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PU_V << MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PU_S)
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PU_V  0x00000001U
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PU_S  10
/* MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PD : R/W; bitpos: [11]; default: 0; */
/*description: */
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PD    (BIT(11))
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PD_M  (MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PD_V << MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PD_S)
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PD_V  0x00000001U
#define MODEM_LPCON_CHAN_FREQ_MEM_FORCE_PD_S  11
/* MODEM_LPCON_MODEM_PWR_MEM_WP : R/W; bitpos: [14:12]; default: 0; */
/*description: */
#define MODEM_LPCON_MODEM_PWR_MEM_WP    0x00000007U
#define MODEM_LPCON_MODEM_PWR_MEM_WP_M  (MODEM_LPCON_MODEM_PWR_MEM_WP_V << MODEM_LPCON_MODEM_PWR_MEM_WP_S)
#define MODEM_LPCON_MODEM_PWR_MEM_WP_V  0x00000007U
#define MODEM_LPCON_MODEM_PWR_MEM_WP_S  12
/* MODEM_LPCON_MODEM_PWR_MEM_WA : R/W; bitpos: [17:15]; default: 4; */
/*description: */
#define MODEM_LPCON_MODEM_PWR_MEM_WA    0x00000007U
#define MODEM_LPCON_MODEM_PWR_MEM_WA_M  (MODEM_LPCON_MODEM_PWR_MEM_WA_V << MODEM_LPCON_MODEM_PWR_MEM_WA_S)
#define MODEM_LPCON_MODEM_PWR_MEM_WA_V  0x00000007U
#define MODEM_LPCON_MODEM_PWR_MEM_WA_S  15
/* MODEM_LPCON_MODEM_PWR_MEM_RA : R/W; bitpos: [19:18]; default: 0; */
/*description: */
#define MODEM_LPCON_MODEM_PWR_MEM_RA    0x00000003U
#define MODEM_LPCON_MODEM_PWR_MEM_RA_M  (MODEM_LPCON_MODEM_PWR_MEM_RA_V << MODEM_LPCON_MODEM_PWR_MEM_RA_S)
#define MODEM_LPCON_MODEM_PWR_MEM_RA_V  0x00000003U
#define MODEM_LPCON_MODEM_PWR_MEM_RA_S  18

#define MODEM_LPCON_DATE_REG (DR_REG_MODEM_LPCON_BASE + 0x2c)
/* MODEM_LPCON_DATE : R/W; bitpos: [27:0]; default: 35676736; */
/*description: */
#define MODEM_LPCON_DATE    0x0FFFFFFFU
#define MODEM_LPCON_DATE_M  (MODEM_LPCON_DATE_V << MODEM_LPCON_DATE_S)
#define MODEM_LPCON_DATE_V  0x0FFFFFFFU
#define MODEM_LPCON_DATE_S  0

#ifdef __cplusplus
}
#endif
