# SPDX-FileCopyrightText: 2022-2025 Espressif Systems (Shanghai) CO LTD
# SPDX-License-Identifier: Unlicense OR CC0-1.0
import pytest
from pytest_embedded_idf.unity_tester import CaseTester


@pytest.mark.esp32
@pytest.mark.esp32c3
@pytest.mark.esp32s3
@pytest.mark.two_duts
@pytest.mark.parametrize('count', [2], indirect=True)
def test_wifi_connect_cases(case_tester: CaseTester) -> None:  # type: ignore
    case_tester.run_all_cases()


@pytest.mark.esp32c2
@pytest.mark.two_duts
@pytest.mark.xtal_26mhz
@pytest.mark.parametrize(
    'count, config, baud',
    [
        (2, 'esp32c2_xtal26m', '74880'),
    ],
    indirect=True,
)
def test_wifi_connect_cases_esp32c2_xtal26m(case_tester: CaseTester) -> None:
    case_tester.run_all_cases()


@pytest.mark.esp32c2
@pytest.mark.two_duts_eco
@pytest.mark.xtal_26mhz
@pytest.mark.parametrize(
    'count, config, baud, ',
    [
        (2, 'esp32c2eco4_xtal26m', '74880',),
    ],
    indirect=True,
)
def test_wifi_connect_cases_esp32c2eco4_xtal26m(case_tester: CaseTester) -> None:
    case_tester.run_all_cases()


@pytest.mark.two_duts_eco
@pytest.mark.esp32c3
@pytest.mark.parametrize(
    'count, config,',
    [
        (2, 'esp32c3eco7',),
    ],
    indirect=True,
)
def test_wifi_connect_cases_esp32c3eco7(case_tester: CaseTester) -> None:
    case_tester.run_all_cases()
