// Copyright 2018 Espressif Systems (Shanghai) PTE LTD
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <string.h>
#include "esp_event.h"

ESP_EVENT_DEFINE_BASE(MESH_EVENT);

esp_err_t esp_mesh_send_event_internal(int32_t event_id, void* event_data, size_t event_data_size)
{
    return esp_event_post(MESH_EVENT, event_id, event_data, event_data_size, 0);
}
