| Supported Targets | ESP32-C3 | ESP32-S3 |
| ----------------- | -------- | -------- |

# I2S Basic TDM Mode Example

(See the README.md file in the upper level 'examples' directory for more information about examples.)

This example is going to show how to use the TDM mode in simplex mode or full-duplex mode.

## How to Use Example

### Hardware Required

* A development board with any one of ESP32-C3 or ESP32-S3 SoC
* A USB cable for power supply and programming

### Configure the Project

There are simplex mode and duplex mode can be chosen in this example, setting `EXAMPLE_I2S_DUPLEX_MODE` to `0` will adopt the simplex mode, otherwise it will adopt the full-duplex mode.

### Build and Flash

Build the project and flash it to the board, then run monitor tool to view serial output:

```
idf.py -p PORT build flash monitor
```

(To exit the serial monitor, type ``Ctrl-]``.)

See the Getting Started Guide for full steps to configure and use ESP-IDF to build projects.

## Example Output

While `EXAMPLE_I2S_DUPLEX_MODE` is set to `1`, then you can see the following log:

```
Write Task: i2s write 2048 bytes
Read Task: i2s read 2048 bytes
-----------------------------------
[0] 12 [1] 34 [2] 56 [3] 78
[4] 9a [5] bc [6] de [7] f0

Write Task: i2s write 2048 bytes
Read Task: i2s read 2048 bytes
-----------------------------------
[0] 12 [1] 34 [2] 56 [3] 78
[4] 9a [5] bc [6] de [7] f0
...
```

While `EXAMPLE_I2S_DUPLEX_MODE` is set to `0`, you can see the receiving data is always `0` because no signal inputted:

```
Write Task: i2s write 2048 bytes
Read Task: i2s read 2048 bytes
-----------------------------------
[0] 0 [1] 0 [2] 0 [3] 0
[4] 0 [5] 0 [6] 0 [7] 0

Write Task: i2s write 2048 bytes
Read Task: i2s read 2048 bytes
-----------------------------------
[0] 0 [1] 0 [2] 0 [3] 0
[4] 0 [5] 0 [6] 0 [7] 0
...
```

## Troubleshooting

For any technical queries, please open an [issue](https://github.com/espressif/esp-idf/issues) on GitHub. We will get back to you soon.

