/**
 * SPDX-FileCopyrightText: 2021 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** SYSCON_WIFI_BB_CFG_REG register
 *  register description
 */
#define SYSCON_WIFI_BB_CFG_REG (DR_REG_SYSCON_BASE + 0xc)
/** SYSCON_WIFI_BB_CFG : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_WIFI_BB_CFG    0xFFFFFFFFU
#define SYSCON_WIFI_BB_CFG_M  (SYSCON_WIFI_BB_CFG_V << SYSCON_WIFI_BB_CFG_S)
#define SYSCON_WIFI_BB_CFG_V  0xFFFFFFFFU
#define SYSCON_WIFI_BB_CFG_S  0

/** SYSCON_WIFI_BB_CFG_2_REG register
 *  register description
 */
#define SYSCON_WIFI_BB_CFG_2_REG (DR_REG_SYSCON_BASE + 0x10)
/** SYSCON_WIFI_BB_CFG_2 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_WIFI_BB_CFG_2    0xFFFFFFFFU
#define SYSCON_WIFI_BB_CFG_2_M  (SYSCON_WIFI_BB_CFG_2_V << SYSCON_WIFI_BB_CFG_2_S)
#define SYSCON_WIFI_BB_CFG_2_V  0xFFFFFFFFU
#define SYSCON_WIFI_BB_CFG_2_S  0

/** SYSCON_HOST_INF_SEL_REG register
 *  register description
 */
#define SYSCON_HOST_INF_SEL_REG (DR_REG_SYSCON_BASE + 0x1c)
/** SYSCON_PERI_IO_SWAP : R/W; bitpos: [7:0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_IO_SWAP    0x000000FFU
#define SYSCON_PERI_IO_SWAP_M  (SYSCON_PERI_IO_SWAP_V << SYSCON_PERI_IO_SWAP_S)
#define SYSCON_PERI_IO_SWAP_V  0x000000FFU
#define SYSCON_PERI_IO_SWAP_S  0

/** SYSCON_EXT_MEM_PMS_LOCK_REG register
 *  register description
 */
#define SYSCON_EXT_MEM_PMS_LOCK_REG (DR_REG_SYSCON_BASE + 0x20)
/** SYSCON_EXT_MEM_PMS_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SYSCON_EXT_MEM_PMS_LOCK    (BIT(0))
#define SYSCON_EXT_MEM_PMS_LOCK_M  (SYSCON_EXT_MEM_PMS_LOCK_V << SYSCON_EXT_MEM_PMS_LOCK_S)
#define SYSCON_EXT_MEM_PMS_LOCK_V  0x00000001U
#define SYSCON_EXT_MEM_PMS_LOCK_S  0

/** SYSCON_FLASH_ACE0_ATTR_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE0_ATTR_REG (DR_REG_SYSCON_BASE + 0x28)
/** SYSCON_FLASH_ACE0_ATTR : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SYSCON_FLASH_ACE0_ATTR    0x00000003U
#define SYSCON_FLASH_ACE0_ATTR_M  (SYSCON_FLASH_ACE0_ATTR_V << SYSCON_FLASH_ACE0_ATTR_S)
#define SYSCON_FLASH_ACE0_ATTR_V  0x00000003U
#define SYSCON_FLASH_ACE0_ATTR_S  0

/** SYSCON_FLASH_ACE1_ATTR_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE1_ATTR_REG (DR_REG_SYSCON_BASE + 0x2c)
/** SYSCON_FLASH_ACE1_ATTR : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SYSCON_FLASH_ACE1_ATTR    0x00000003U
#define SYSCON_FLASH_ACE1_ATTR_M  (SYSCON_FLASH_ACE1_ATTR_V << SYSCON_FLASH_ACE1_ATTR_S)
#define SYSCON_FLASH_ACE1_ATTR_V  0x00000003U
#define SYSCON_FLASH_ACE1_ATTR_S  0

/** SYSCON_FLASH_ACE2_ATTR_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE2_ATTR_REG (DR_REG_SYSCON_BASE + 0x30)
/** SYSCON_FLASH_ACE2_ATTR : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SYSCON_FLASH_ACE2_ATTR    0x00000003U
#define SYSCON_FLASH_ACE2_ATTR_M  (SYSCON_FLASH_ACE2_ATTR_V << SYSCON_FLASH_ACE2_ATTR_S)
#define SYSCON_FLASH_ACE2_ATTR_V  0x00000003U
#define SYSCON_FLASH_ACE2_ATTR_S  0

/** SYSCON_FLASH_ACE3_ATTR_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE3_ATTR_REG (DR_REG_SYSCON_BASE + 0x34)
/** SYSCON_FLASH_ACE3_ATTR : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SYSCON_FLASH_ACE3_ATTR    0x00000003U
#define SYSCON_FLASH_ACE3_ATTR_M  (SYSCON_FLASH_ACE3_ATTR_V << SYSCON_FLASH_ACE3_ATTR_S)
#define SYSCON_FLASH_ACE3_ATTR_V  0x00000003U
#define SYSCON_FLASH_ACE3_ATTR_S  0

/** SYSCON_FLASH_ACE0_ADDR_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE0_ADDR_REG (DR_REG_SYSCON_BASE + 0x38)
/** SYSCON_FLASH_ACE0_ADDR_S : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_FLASH_ACE0_ADDR_S    0xFFFFFFFFU
#define SYSCON_FLASH_ACE0_ADDR_S_M  (SYSCON_FLASH_ACE0_ADDR_S_V << SYSCON_FLASH_ACE0_ADDR_S_S)
#define SYSCON_FLASH_ACE0_ADDR_S_V  0xFFFFFFFFU
#define SYSCON_FLASH_ACE0_ADDR_S_S  0

/** SYSCON_FLASH_ACE1_ADDR_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE1_ADDR_REG (DR_REG_SYSCON_BASE + 0x3c)
/** SYSCON_FLASH_ACE1_ADDR_S : R/W; bitpos: [31:0]; default: 4194304;
 *  Need add description
 */
#define SYSCON_FLASH_ACE1_ADDR_S    0xFFFFFFFFU
#define SYSCON_FLASH_ACE1_ADDR_S_M  (SYSCON_FLASH_ACE1_ADDR_S_V << SYSCON_FLASH_ACE1_ADDR_S_S)
#define SYSCON_FLASH_ACE1_ADDR_S_V  0xFFFFFFFFU
#define SYSCON_FLASH_ACE1_ADDR_S_S  0

/** SYSCON_FLASH_ACE2_ADDR_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE2_ADDR_REG (DR_REG_SYSCON_BASE + 0x40)
/** SYSCON_FLASH_ACE2_ADDR_S : R/W; bitpos: [31:0]; default: 8388608;
 *  Need add description
 */
#define SYSCON_FLASH_ACE2_ADDR_S    0xFFFFFFFFU
#define SYSCON_FLASH_ACE2_ADDR_S_M  (SYSCON_FLASH_ACE2_ADDR_S_V << SYSCON_FLASH_ACE2_ADDR_S_S)
#define SYSCON_FLASH_ACE2_ADDR_S_V  0xFFFFFFFFU
#define SYSCON_FLASH_ACE2_ADDR_S_S  0

/** SYSCON_FLASH_ACE3_ADDR_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE3_ADDR_REG (DR_REG_SYSCON_BASE + 0x44)
/** SYSCON_FLASH_ACE3_ADDR_S : R/W; bitpos: [31:0]; default: 12582912;
 *  Need add description
 */
#define SYSCON_FLASH_ACE3_ADDR_S    0xFFFFFFFFU
#define SYSCON_FLASH_ACE3_ADDR_S_M  (SYSCON_FLASH_ACE3_ADDR_S_V << SYSCON_FLASH_ACE3_ADDR_S_S)
#define SYSCON_FLASH_ACE3_ADDR_S_V  0xFFFFFFFFU
#define SYSCON_FLASH_ACE3_ADDR_S_S  0

/** SYSCON_FLASH_ACE0_SIZE_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE0_SIZE_REG (DR_REG_SYSCON_BASE + 0x48)
/** SYSCON_FLASH_ACE0_SIZE : R/W; bitpos: [12:0]; default: 1024;
 *  Need add description
 */
#define SYSCON_FLASH_ACE0_SIZE    0x00001FFFU
#define SYSCON_FLASH_ACE0_SIZE_M  (SYSCON_FLASH_ACE0_SIZE_V << SYSCON_FLASH_ACE0_SIZE_S)
#define SYSCON_FLASH_ACE0_SIZE_V  0x00001FFFU
#define SYSCON_FLASH_ACE0_SIZE_S  0

/** SYSCON_FLASH_ACE1_SIZE_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE1_SIZE_REG (DR_REG_SYSCON_BASE + 0x4c)
/** SYSCON_FLASH_ACE1_SIZE : R/W; bitpos: [12:0]; default: 1024;
 *  Need add description
 */
#define SYSCON_FLASH_ACE1_SIZE    0x00001FFFU
#define SYSCON_FLASH_ACE1_SIZE_M  (SYSCON_FLASH_ACE1_SIZE_V << SYSCON_FLASH_ACE1_SIZE_S)
#define SYSCON_FLASH_ACE1_SIZE_V  0x00001FFFU
#define SYSCON_FLASH_ACE1_SIZE_S  0

/** SYSCON_FLASH_ACE2_SIZE_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE2_SIZE_REG (DR_REG_SYSCON_BASE + 0x50)
/** SYSCON_FLASH_ACE2_SIZE : R/W; bitpos: [12:0]; default: 1024;
 *  Need add description
 */
#define SYSCON_FLASH_ACE2_SIZE    0x00001FFFU
#define SYSCON_FLASH_ACE2_SIZE_M  (SYSCON_FLASH_ACE2_SIZE_V << SYSCON_FLASH_ACE2_SIZE_S)
#define SYSCON_FLASH_ACE2_SIZE_V  0x00001FFFU
#define SYSCON_FLASH_ACE2_SIZE_S  0

/** SYSCON_FLASH_ACE3_SIZE_REG register
 *  register description
 */
#define SYSCON_FLASH_ACE3_SIZE_REG (DR_REG_SYSCON_BASE + 0x54)
/** SYSCON_FLASH_ACE3_SIZE : R/W; bitpos: [12:0]; default: 1024;
 *  Need add description
 */
#define SYSCON_FLASH_ACE3_SIZE    0x00001FFFU
#define SYSCON_FLASH_ACE3_SIZE_M  (SYSCON_FLASH_ACE3_SIZE_V << SYSCON_FLASH_ACE3_SIZE_S)
#define SYSCON_FLASH_ACE3_SIZE_V  0x00001FFFU
#define SYSCON_FLASH_ACE3_SIZE_S  0

/** SYSCON_SPI_MEM_PMS_CTRL_REG register
 *  register description
 */
#define SYSCON_SPI_MEM_PMS_CTRL_REG (DR_REG_SYSCON_BASE + 0x88)
/** SYSCON_SPI_MEM_REJECT_INT : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SYSCON_SPI_MEM_REJECT_INT    (BIT(0))
#define SYSCON_SPI_MEM_REJECT_INT_M  (SYSCON_SPI_MEM_REJECT_INT_V << SYSCON_SPI_MEM_REJECT_INT_S)
#define SYSCON_SPI_MEM_REJECT_INT_V  0x00000001U
#define SYSCON_SPI_MEM_REJECT_INT_S  0
/** SYSCON_SPI_MEM_REJECT_CLR : WOD; bitpos: [1]; default: 0;
 *  Need add description
 */
#define SYSCON_SPI_MEM_REJECT_CLR    (BIT(1))
#define SYSCON_SPI_MEM_REJECT_CLR_M  (SYSCON_SPI_MEM_REJECT_CLR_V << SYSCON_SPI_MEM_REJECT_CLR_S)
#define SYSCON_SPI_MEM_REJECT_CLR_V  0x00000001U
#define SYSCON_SPI_MEM_REJECT_CLR_S  1
/** SYSCON_SPI_MEM_REJECT_CDE : RO; bitpos: [6:2]; default: 0;
 *  Need add description
 */
#define SYSCON_SPI_MEM_REJECT_CDE    0x0000001FU
#define SYSCON_SPI_MEM_REJECT_CDE_M  (SYSCON_SPI_MEM_REJECT_CDE_V << SYSCON_SPI_MEM_REJECT_CDE_S)
#define SYSCON_SPI_MEM_REJECT_CDE_V  0x0000001FU
#define SYSCON_SPI_MEM_REJECT_CDE_S  2

/** SYSCON_SPI_MEM_REJECT_ADDR_REG register
 *  register description
 */
#define SYSCON_SPI_MEM_REJECT_ADDR_REG (DR_REG_SYSCON_BASE + 0x8c)
/** SYSCON_SPI_MEM_REJECT_ADDR : RO; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_SPI_MEM_REJECT_ADDR    0xFFFFFFFFU
#define SYSCON_SPI_MEM_REJECT_ADDR_M  (SYSCON_SPI_MEM_REJECT_ADDR_V << SYSCON_SPI_MEM_REJECT_ADDR_S)
#define SYSCON_SPI_MEM_REJECT_ADDR_V  0xFFFFFFFFU
#define SYSCON_SPI_MEM_REJECT_ADDR_S  0

/** SYSCON_SYSCON_SDIO_CTRL_REG register
 *  register description
 */
#define SYSCON_SYSCON_SDIO_CTRL_REG (DR_REG_SYSCON_BASE + 0x90)
/** SYSCON_SDIO_WIN_ACCESS_EN : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SYSCON_SDIO_WIN_ACCESS_EN    (BIT(0))
#define SYSCON_SDIO_WIN_ACCESS_EN_M  (SYSCON_SDIO_WIN_ACCESS_EN_V << SYSCON_SDIO_WIN_ACCESS_EN_S)
#define SYSCON_SDIO_WIN_ACCESS_EN_V  0x00000001U
#define SYSCON_SDIO_WIN_ACCESS_EN_S  0

/** SYSCON_REDCY_SIG0_REG register
 *  register description
 */
#define SYSCON_REDCY_SIG0_REG (DR_REG_SYSCON_BASE + 0x94)
/** SYSCON_REDCY_SIG0 : R/W; bitpos: [30:0]; default: 0;
 *  Need add description
 */
#define SYSCON_REDCY_SIG0    0x7FFFFFFFU
#define SYSCON_REDCY_SIG0_M  (SYSCON_REDCY_SIG0_V << SYSCON_REDCY_SIG0_S)
#define SYSCON_REDCY_SIG0_V  0x7FFFFFFFU
#define SYSCON_REDCY_SIG0_S  0
/** SYSCON_REDCY_ANDOR : RO; bitpos: [31]; default: 0;
 *  Need add description
 */
#define SYSCON_REDCY_ANDOR    (BIT(31))
#define SYSCON_REDCY_ANDOR_M  (SYSCON_REDCY_ANDOR_V << SYSCON_REDCY_ANDOR_S)
#define SYSCON_REDCY_ANDOR_V  0x00000001U
#define SYSCON_REDCY_ANDOR_S  31

/** SYSCON_REDCY_SIG1_REG register
 *  register description
 */
#define SYSCON_REDCY_SIG1_REG (DR_REG_SYSCON_BASE + 0x98)
/** SYSCON_REDCY_SIG1 : R/W; bitpos: [30:0]; default: 0;
 *  Need add description
 */
#define SYSCON_REDCY_SIG1    0x7FFFFFFFU
#define SYSCON_REDCY_SIG1_M  (SYSCON_REDCY_SIG1_V << SYSCON_REDCY_SIG1_S)
#define SYSCON_REDCY_SIG1_V  0x7FFFFFFFU
#define SYSCON_REDCY_SIG1_S  0
/** SYSCON_REDCY_NANDOR : RO; bitpos: [31]; default: 0;
 *  Need add description
 */
#define SYSCON_REDCY_NANDOR    (BIT(31))
#define SYSCON_REDCY_NANDOR_M  (SYSCON_REDCY_NANDOR_V << SYSCON_REDCY_NANDOR_S)
#define SYSCON_REDCY_NANDOR_V  0x00000001U
#define SYSCON_REDCY_NANDOR_S  31

/** SYSCON_FRONT_END_MEM_PD_REG register
 *  register description
 */
#define SYSCON_FRONT_END_MEM_PD_REG (DR_REG_SYSCON_BASE + 0x9c)
/** SYSCON_AGC_MEM_FORCE_PU : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SYSCON_AGC_MEM_FORCE_PU    (BIT(0))
#define SYSCON_AGC_MEM_FORCE_PU_M  (SYSCON_AGC_MEM_FORCE_PU_V << SYSCON_AGC_MEM_FORCE_PU_S)
#define SYSCON_AGC_MEM_FORCE_PU_V  0x00000001U
#define SYSCON_AGC_MEM_FORCE_PU_S  0
/** SYSCON_AGC_MEM_FORCE_PD : R/W; bitpos: [1]; default: 0;
 *  Need add description
 */
#define SYSCON_AGC_MEM_FORCE_PD    (BIT(1))
#define SYSCON_AGC_MEM_FORCE_PD_M  (SYSCON_AGC_MEM_FORCE_PD_V << SYSCON_AGC_MEM_FORCE_PD_S)
#define SYSCON_AGC_MEM_FORCE_PD_V  0x00000001U
#define SYSCON_AGC_MEM_FORCE_PD_S  1
/** SYSCON_PBUS_MEM_FORCE_PU : R/W; bitpos: [2]; default: 1;
 *  Need add description
 */
#define SYSCON_PBUS_MEM_FORCE_PU    (BIT(2))
#define SYSCON_PBUS_MEM_FORCE_PU_M  (SYSCON_PBUS_MEM_FORCE_PU_V << SYSCON_PBUS_MEM_FORCE_PU_S)
#define SYSCON_PBUS_MEM_FORCE_PU_V  0x00000001U
#define SYSCON_PBUS_MEM_FORCE_PU_S  2
/** SYSCON_PBUS_MEM_FORCE_PD : R/W; bitpos: [3]; default: 0;
 *  Need add description
 */
#define SYSCON_PBUS_MEM_FORCE_PD    (BIT(3))
#define SYSCON_PBUS_MEM_FORCE_PD_M  (SYSCON_PBUS_MEM_FORCE_PD_V << SYSCON_PBUS_MEM_FORCE_PD_S)
#define SYSCON_PBUS_MEM_FORCE_PD_V  0x00000001U
#define SYSCON_PBUS_MEM_FORCE_PD_S  3
/** SYSCON_DC_MEM_FORCE_PU : R/W; bitpos: [4]; default: 1;
 *  Need add description
 */
#define SYSCON_DC_MEM_FORCE_PU    (BIT(4))
#define SYSCON_DC_MEM_FORCE_PU_M  (SYSCON_DC_MEM_FORCE_PU_V << SYSCON_DC_MEM_FORCE_PU_S)
#define SYSCON_DC_MEM_FORCE_PU_V  0x00000001U
#define SYSCON_DC_MEM_FORCE_PU_S  4
/** SYSCON_DC_MEM_FORCE_PD : R/W; bitpos: [5]; default: 0;
 *  Need add description
 */
#define SYSCON_DC_MEM_FORCE_PD    (BIT(5))
#define SYSCON_DC_MEM_FORCE_PD_M  (SYSCON_DC_MEM_FORCE_PD_V << SYSCON_DC_MEM_FORCE_PD_S)
#define SYSCON_DC_MEM_FORCE_PD_V  0x00000001U
#define SYSCON_DC_MEM_FORCE_PD_S  5

/** SYSCON_RETENTION_CTRL_REG register
 *  register description
 */
#define SYSCON_RETENTION_CTRL_REG (DR_REG_SYSCON_BASE + 0xa0)
/** SYSCON_NOBYPASS_CPU_ISO_RST : R/W; bitpos: [27]; default: 0;
 *  Need add description
 */
#define SYSCON_NOBYPASS_CPU_ISO_RST    (BIT(27))
#define SYSCON_NOBYPASS_CPU_ISO_RST_M  (SYSCON_NOBYPASS_CPU_ISO_RST_V << SYSCON_NOBYPASS_CPU_ISO_RST_S)
#define SYSCON_NOBYPASS_CPU_ISO_RST_V  0x00000001U
#define SYSCON_NOBYPASS_CPU_ISO_RST_S  27

/** SYSCON_CLKGATE_FORCE_ON_REG register
 *  register description
 */
#define SYSCON_CLKGATE_FORCE_ON_REG (DR_REG_SYSCON_BASE + 0xa4)
/** SYSCON_ROM_CLKGATE_FORCE_ON : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SYSCON_ROM_CLKGATE_FORCE_ON    0x00000003U
#define SYSCON_ROM_CLKGATE_FORCE_ON_M  (SYSCON_ROM_CLKGATE_FORCE_ON_V << SYSCON_ROM_CLKGATE_FORCE_ON_S)
#define SYSCON_ROM_CLKGATE_FORCE_ON_V  0x00000003U
#define SYSCON_ROM_CLKGATE_FORCE_ON_S  0
/** SYSCON_SRAM_CLKGATE_FORCE_ON : R/W; bitpos: [5:2]; default: 15;
 *  Need add description
 */
#define SYSCON_SRAM_CLKGATE_FORCE_ON    0x0000000FU
#define SYSCON_SRAM_CLKGATE_FORCE_ON_M  (SYSCON_SRAM_CLKGATE_FORCE_ON_V << SYSCON_SRAM_CLKGATE_FORCE_ON_S)
#define SYSCON_SRAM_CLKGATE_FORCE_ON_V  0x0000000FU
#define SYSCON_SRAM_CLKGATE_FORCE_ON_S  2

/** SYSCON_MEM_POWER_DOWN_REG register
 *  register description
 */
#define SYSCON_MEM_POWER_DOWN_REG (DR_REG_SYSCON_BASE + 0xa8)
/** SYSCON_ROM_POWER_DOWN : R/W; bitpos: [1:0]; default: 0;
 *  Need add description
 */
#define SYSCON_ROM_POWER_DOWN    0x00000003U
#define SYSCON_ROM_POWER_DOWN_M  (SYSCON_ROM_POWER_DOWN_V << SYSCON_ROM_POWER_DOWN_S)
#define SYSCON_ROM_POWER_DOWN_V  0x00000003U
#define SYSCON_ROM_POWER_DOWN_S  0
/** SYSCON_SRAM_POWER_DOWN : R/W; bitpos: [5:2]; default: 0;
 *  Need add description
 */
#define SYSCON_SRAM_POWER_DOWN    0x0000000FU
#define SYSCON_SRAM_POWER_DOWN_M  (SYSCON_SRAM_POWER_DOWN_V << SYSCON_SRAM_POWER_DOWN_S)
#define SYSCON_SRAM_POWER_DOWN_V  0x0000000FU
#define SYSCON_SRAM_POWER_DOWN_S  2

/** SYSCON_MEM_POWER_UP_REG register
 *  register description
 */
#define SYSCON_MEM_POWER_UP_REG (DR_REG_SYSCON_BASE + 0xac)
/** SYSCON_ROM_POWER_UP : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SYSCON_ROM_POWER_UP    0x00000003U
#define SYSCON_ROM_POWER_UP_M  (SYSCON_ROM_POWER_UP_V << SYSCON_ROM_POWER_UP_S)
#define SYSCON_ROM_POWER_UP_V  0x00000003U
#define SYSCON_ROM_POWER_UP_S  0
/** SYSCON_SRAM_POWER_UP : R/W; bitpos: [5:2]; default: 15;
 *  Need add description
 */
#define SYSCON_SRAM_POWER_UP    0x0000000FU
#define SYSCON_SRAM_POWER_UP_M  (SYSCON_SRAM_POWER_UP_V << SYSCON_SRAM_POWER_UP_S)
#define SYSCON_SRAM_POWER_UP_V  0x0000000FU
#define SYSCON_SRAM_POWER_UP_S  2

/** SYSCON_RND_DATA_REG register
 *  register description
 */
#define SYSCON_RND_DATA_REG (DR_REG_SYSCON_BASE + 0xb0)
/** SYSCON_RND_DATA : RO; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_RND_DATA    0xFFFFFFFFU
#define SYSCON_RND_DATA_M  (SYSCON_RND_DATA_V << SYSCON_RND_DATA_S)
#define SYSCON_RND_DATA_V  0xFFFFFFFFU
#define SYSCON_RND_DATA_S  0

/** SYSCON_PERI_BACKUP_CONFIG_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_CONFIG_REG (DR_REG_SYSCON_BASE + 0xb4)
/** SYSCON_PERI_BACKUP_FLOW_ERR : RO; bitpos: [2:0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_FLOW_ERR    0x00000007U
#define SYSCON_PERI_BACKUP_FLOW_ERR_M  (SYSCON_PERI_BACKUP_FLOW_ERR_V << SYSCON_PERI_BACKUP_FLOW_ERR_S)
#define SYSCON_PERI_BACKUP_FLOW_ERR_V  0x00000007U
#define SYSCON_PERI_BACKUP_FLOW_ERR_S  0
/** SYSCON_PERI_BACKUP_ADDR_MAP_MODE : R/W; bitpos: [3]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_ADDR_MAP_MODE    (BIT(3))
#define SYSCON_PERI_BACKUP_ADDR_MAP_MODE_M  (SYSCON_PERI_BACKUP_ADDR_MAP_MODE_V << SYSCON_PERI_BACKUP_ADDR_MAP_MODE_S)
#define SYSCON_PERI_BACKUP_ADDR_MAP_MODE_V  0x00000001U
#define SYSCON_PERI_BACKUP_ADDR_MAP_MODE_S  3
/** SYSCON_PERI_BACKUP_BURST_LIMIT : R/W; bitpos: [8:4]; default: 8;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_BURST_LIMIT    0x0000001FU
#define SYSCON_PERI_BACKUP_BURST_LIMIT_M  (SYSCON_PERI_BACKUP_BURST_LIMIT_V << SYSCON_PERI_BACKUP_BURST_LIMIT_S)
#define SYSCON_PERI_BACKUP_BURST_LIMIT_V  0x0000001FU
#define SYSCON_PERI_BACKUP_BURST_LIMIT_S  4
/** SYSCON_PERI_BACKUP_TOUT_THRES : R/W; bitpos: [18:9]; default: 50;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_TOUT_THRES    0x000003FFU
#define SYSCON_PERI_BACKUP_TOUT_THRES_M  (SYSCON_PERI_BACKUP_TOUT_THRES_V << SYSCON_PERI_BACKUP_TOUT_THRES_S)
#define SYSCON_PERI_BACKUP_TOUT_THRES_V  0x000003FFU
#define SYSCON_PERI_BACKUP_TOUT_THRES_S  9
/** SYSCON_PERI_BACKUP_SIZE : R/W; bitpos: [28:19]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_SIZE    0x000003FFU
#define SYSCON_PERI_BACKUP_SIZE_M  (SYSCON_PERI_BACKUP_SIZE_V << SYSCON_PERI_BACKUP_SIZE_S)
#define SYSCON_PERI_BACKUP_SIZE_V  0x000003FFU
#define SYSCON_PERI_BACKUP_SIZE_S  19
/** SYSCON_PERI_BACKUP_START : WO; bitpos: [29]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_START    (BIT(29))
#define SYSCON_PERI_BACKUP_START_M  (SYSCON_PERI_BACKUP_START_V << SYSCON_PERI_BACKUP_START_S)
#define SYSCON_PERI_BACKUP_START_V  0x00000001U
#define SYSCON_PERI_BACKUP_START_S  29
/** SYSCON_PERI_BACKUP_TO_MEM : R/W; bitpos: [30]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_TO_MEM    (BIT(30))
#define SYSCON_PERI_BACKUP_TO_MEM_M  (SYSCON_PERI_BACKUP_TO_MEM_V << SYSCON_PERI_BACKUP_TO_MEM_S)
#define SYSCON_PERI_BACKUP_TO_MEM_V  0x00000001U
#define SYSCON_PERI_BACKUP_TO_MEM_S  30
/** SYSCON_PERI_BACKUP_ENA : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_ENA    (BIT(31))
#define SYSCON_PERI_BACKUP_ENA_M  (SYSCON_PERI_BACKUP_ENA_V << SYSCON_PERI_BACKUP_ENA_S)
#define SYSCON_PERI_BACKUP_ENA_V  0x00000001U
#define SYSCON_PERI_BACKUP_ENA_S  31

/** SYSCON_PERI_BACKUP_APB_ADDR_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_APB_ADDR_REG (DR_REG_SYSCON_BASE + 0xb8)
/** SYSCON_PERI_BACKUP_APB_START_ADDR : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_APB_START_ADDR    0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_APB_START_ADDR_M  (SYSCON_PERI_BACKUP_APB_START_ADDR_V << SYSCON_PERI_BACKUP_APB_START_ADDR_S)
#define SYSCON_PERI_BACKUP_APB_START_ADDR_V  0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_APB_START_ADDR_S  0

/** SYSCON_PERI_BACKUP_MEM_ADDR_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_MEM_ADDR_REG (DR_REG_SYSCON_BASE + 0xbc)
/** SYSCON_PERI_BACKUP_MEM_START_ADDR : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_MEM_START_ADDR    0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_MEM_START_ADDR_M  (SYSCON_PERI_BACKUP_MEM_START_ADDR_V << SYSCON_PERI_BACKUP_MEM_START_ADDR_S)
#define SYSCON_PERI_BACKUP_MEM_START_ADDR_V  0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_MEM_START_ADDR_S  0

/** SYSCON_PERI_BACKUP_REG_MAP0_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_REG_MAP0_REG (DR_REG_SYSCON_BASE + 0xc0)
/** SYSCON_PERI_BACKUP_REG_MAP0 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_REG_MAP0    0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_REG_MAP0_M  (SYSCON_PERI_BACKUP_REG_MAP0_V << SYSCON_PERI_BACKUP_REG_MAP0_S)
#define SYSCON_PERI_BACKUP_REG_MAP0_V  0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_REG_MAP0_S  0

/** SYSCON_PERI_BACKUP_REG_MAP1_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_REG_MAP1_REG (DR_REG_SYSCON_BASE + 0xc4)
/** SYSCON_PERI_BACKUP_REG_MAP1 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_REG_MAP1    0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_REG_MAP1_M  (SYSCON_PERI_BACKUP_REG_MAP1_V << SYSCON_PERI_BACKUP_REG_MAP1_S)
#define SYSCON_PERI_BACKUP_REG_MAP1_V  0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_REG_MAP1_S  0

/** SYSCON_PERI_BACKUP_REG_MAP2_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_REG_MAP2_REG (DR_REG_SYSCON_BASE + 0xc8)
/** SYSCON_PERI_BACKUP_REG_MAP2 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_REG_MAP2    0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_REG_MAP2_M  (SYSCON_PERI_BACKUP_REG_MAP2_V << SYSCON_PERI_BACKUP_REG_MAP2_S)
#define SYSCON_PERI_BACKUP_REG_MAP2_V  0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_REG_MAP2_S  0

/** SYSCON_PERI_BACKUP_REG_MAP3_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_REG_MAP3_REG (DR_REG_SYSCON_BASE + 0xcc)
/** SYSCON_PERI_BACKUP_REG_MAP3 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_REG_MAP3    0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_REG_MAP3_M  (SYSCON_PERI_BACKUP_REG_MAP3_V << SYSCON_PERI_BACKUP_REG_MAP3_S)
#define SYSCON_PERI_BACKUP_REG_MAP3_V  0xFFFFFFFFU
#define SYSCON_PERI_BACKUP_REG_MAP3_S  0

/** SYSCON_PERI_BACKUP_INT_RAW_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_INT_RAW_REG (DR_REG_SYSCON_BASE + 0xd0)
/** SYSCON_PERI_BACKUP_DONE_INT_RAW : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_DONE_INT_RAW    (BIT(0))
#define SYSCON_PERI_BACKUP_DONE_INT_RAW_M  (SYSCON_PERI_BACKUP_DONE_INT_RAW_V << SYSCON_PERI_BACKUP_DONE_INT_RAW_S)
#define SYSCON_PERI_BACKUP_DONE_INT_RAW_V  0x00000001U
#define SYSCON_PERI_BACKUP_DONE_INT_RAW_S  0
/** SYSCON_PERI_BACKUP_ERR_INT_RAW : RO; bitpos: [1]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_ERR_INT_RAW    (BIT(1))
#define SYSCON_PERI_BACKUP_ERR_INT_RAW_M  (SYSCON_PERI_BACKUP_ERR_INT_RAW_V << SYSCON_PERI_BACKUP_ERR_INT_RAW_S)
#define SYSCON_PERI_BACKUP_ERR_INT_RAW_V  0x00000001U
#define SYSCON_PERI_BACKUP_ERR_INT_RAW_S  1

/** SYSCON_PERI_BACKUP_INT_ST_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_INT_ST_REG (DR_REG_SYSCON_BASE + 0xd4)
/** SYSCON_PERI_BACKUP_DONE_INT_ST : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_DONE_INT_ST    (BIT(0))
#define SYSCON_PERI_BACKUP_DONE_INT_ST_M  (SYSCON_PERI_BACKUP_DONE_INT_ST_V << SYSCON_PERI_BACKUP_DONE_INT_ST_S)
#define SYSCON_PERI_BACKUP_DONE_INT_ST_V  0x00000001U
#define SYSCON_PERI_BACKUP_DONE_INT_ST_S  0
/** SYSCON_PERI_BACKUP_ERR_INT_ST : RO; bitpos: [1]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_ERR_INT_ST    (BIT(1))
#define SYSCON_PERI_BACKUP_ERR_INT_ST_M  (SYSCON_PERI_BACKUP_ERR_INT_ST_V << SYSCON_PERI_BACKUP_ERR_INT_ST_S)
#define SYSCON_PERI_BACKUP_ERR_INT_ST_V  0x00000001U
#define SYSCON_PERI_BACKUP_ERR_INT_ST_S  1

/** SYSCON_PERI_BACKUP_INT_ENA_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_INT_ENA_REG (DR_REG_SYSCON_BASE + 0xd8)
/** SYSCON_PERI_BACKUP_DONE_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_DONE_INT_ENA    (BIT(0))
#define SYSCON_PERI_BACKUP_DONE_INT_ENA_M  (SYSCON_PERI_BACKUP_DONE_INT_ENA_V << SYSCON_PERI_BACKUP_DONE_INT_ENA_S)
#define SYSCON_PERI_BACKUP_DONE_INT_ENA_V  0x00000001U
#define SYSCON_PERI_BACKUP_DONE_INT_ENA_S  0
/** SYSCON_PERI_BACKUP_ERR_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_ERR_INT_ENA    (BIT(1))
#define SYSCON_PERI_BACKUP_ERR_INT_ENA_M  (SYSCON_PERI_BACKUP_ERR_INT_ENA_V << SYSCON_PERI_BACKUP_ERR_INT_ENA_S)
#define SYSCON_PERI_BACKUP_ERR_INT_ENA_V  0x00000001U
#define SYSCON_PERI_BACKUP_ERR_INT_ENA_S  1

/** SYSCON_PERI_BACKUP_INT_CLR_REG register
 *  register description
 */
#define SYSCON_PERI_BACKUP_INT_CLR_REG (DR_REG_SYSCON_BASE + 0xdc)
/** SYSCON_PERI_BACKUP_DONE_INT_CLR : WO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_DONE_INT_CLR    (BIT(0))
#define SYSCON_PERI_BACKUP_DONE_INT_CLR_M  (SYSCON_PERI_BACKUP_DONE_INT_CLR_V << SYSCON_PERI_BACKUP_DONE_INT_CLR_S)
#define SYSCON_PERI_BACKUP_DONE_INT_CLR_V  0x00000001U
#define SYSCON_PERI_BACKUP_DONE_INT_CLR_S  0
/** SYSCON_PERI_BACKUP_ERR_INT_CLR : WO; bitpos: [1]; default: 0;
 *  Need add description
 */
#define SYSCON_PERI_BACKUP_ERR_INT_CLR    (BIT(1))
#define SYSCON_PERI_BACKUP_ERR_INT_CLR_M  (SYSCON_PERI_BACKUP_ERR_INT_CLR_V << SYSCON_PERI_BACKUP_ERR_INT_CLR_S)
#define SYSCON_PERI_BACKUP_ERR_INT_CLR_V  0x00000001U
#define SYSCON_PERI_BACKUP_ERR_INT_CLR_S  1

/** SYSCON_SYSCON_REGCLK_CONF_REG register
 *  register description
 */
#define SYSCON_SYSCON_REGCLK_CONF_REG (DR_REG_SYSCON_BASE + 0xe0)
/** SYSCON_CLK_EN : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SYSCON_CLK_EN    (BIT(0))
#define SYSCON_CLK_EN_M  (SYSCON_CLK_EN_V << SYSCON_CLK_EN_S)
#define SYSCON_CLK_EN_V  0x00000001U
#define SYSCON_CLK_EN_S  0

/** SYSCON_SYSCON_DATE_REG register
 *  register description
 */
#define SYSCON_SYSCON_DATE_REG (DR_REG_SYSCON_BASE + 0x3fc)
/** SYSCON_SYSCON_DATE : R/W; bitpos: [31:0]; default: 34607184;
 *  Version control
 */
#define SYSCON_SYSCON_DATE    0xFFFFFFFFU
#define SYSCON_SYSCON_DATE_M  (SYSCON_SYSCON_DATE_V << SYSCON_SYSCON_DATE_S)
#define SYSCON_SYSCON_DATE_V  0xFFFFFFFFU
#define SYSCON_SYSCON_DATE_S  0

#ifdef __cplusplus
}
#endif
