/**
 * SPDX-FileCopyrightText: 2021 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** SENSITIVE_ROM_TABLE_LOCK_REG register
 *  register description
 */
#define SENSITIVE_ROM_TABLE_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x0)
/** SENSITIVE_ROM_TABLE_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_ROM_TABLE_LOCK    (BIT(0))
#define SENSITIVE_ROM_TABLE_LOCK_M  (SENSITIVE_ROM_TABLE_LOCK_V << SENSITIVE_ROM_TABLE_LOCK_S)
#define SENSITIVE_ROM_TABLE_LOCK_V  0x00000001U
#define SENSITIVE_ROM_TABLE_LOCK_S  0

/** SENSITIVE_ROM_TABLE_REG register
 *  register description
 */
#define SENSITIVE_ROM_TABLE_REG (DR_REG_SENSITIVE_BASE + 0x4)
/** SENSITIVE_ROM_TABLE : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_ROM_TABLE    0xFFFFFFFFU
#define SENSITIVE_ROM_TABLE_M  (SENSITIVE_ROM_TABLE_V << SENSITIVE_ROM_TABLE_S)
#define SENSITIVE_ROM_TABLE_V  0xFFFFFFFFU
#define SENSITIVE_ROM_TABLE_S  0

/** SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_REG register
 *  register description
 */
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_REG (DR_REG_SENSITIVE_BASE + 0x8)
/** SENSITIVE_PRIVILEGE_MODE_SEL_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK    (BIT(0))
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_M  (SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_V << SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_S)
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_V  0x00000001U
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_S  0

/** SENSITIVE_PRIVILEGE_MODE_SEL_REG register
 *  register description
 */
#define SENSITIVE_PRIVILEGE_MODE_SEL_REG (DR_REG_SENSITIVE_BASE + 0xc)
/** SENSITIVE_PRIVILEGE_MODE_SEL : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_PRIVILEGE_MODE_SEL    (BIT(0))
#define SENSITIVE_PRIVILEGE_MODE_SEL_M  (SENSITIVE_PRIVILEGE_MODE_SEL_V << SENSITIVE_PRIVILEGE_MODE_SEL_S)
#define SENSITIVE_PRIVILEGE_MODE_SEL_V  0x00000001U
#define SENSITIVE_PRIVILEGE_MODE_SEL_S  0

/** SENSITIVE_APB_PERIPHERAL_ACCESS_0_REG register
 *  register description
 */
#define SENSITIVE_APB_PERIPHERAL_ACCESS_0_REG (DR_REG_SENSITIVE_BASE + 0x10)
/** SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_M  (SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_V << SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_S)
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_V  0x00000001U
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_S  0

/** SENSITIVE_APB_PERIPHERAL_ACCESS_1_REG register
 *  register description
 */
#define SENSITIVE_APB_PERIPHERAL_ACCESS_1_REG (DR_REG_SENSITIVE_BASE + 0x14)
/** SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST    (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_M  (SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_V << SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_S)
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_V  0x00000001U
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_S  0

/** SENSITIVE_INTERNAL_SRAM_USAGE_0_REG register
 *  register description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_0_REG (DR_REG_SENSITIVE_BASE + 0x18)
/** SENSITIVE_INTERNAL_SRAM_USAGE_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK    (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_M  (SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_V << SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_S)
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_V  0x00000001U
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_S  0

/** SENSITIVE_INTERNAL_SRAM_USAGE_1_REG register
 *  register description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_1_REG (DR_REG_SENSITIVE_BASE + 0x1c)
/** SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE    (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE_M  (SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE_V << SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE_S)
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE_V  0x00000001U
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE_S  0
/** SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM : R/W; bitpos: [3:1]; default: 7;
 *  Need add description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM    0x00000007U
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_M  (SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_V << SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_S)
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_V  0x00000007U
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_S  1

/** SENSITIVE_INTERNAL_SRAM_USAGE_3_REG register
 *  register description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_3_REG (DR_REG_SENSITIVE_BASE + 0x20)
/** SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM : R/W; bitpos: [2:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM    0x00000007U
#define SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_M  (SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_V << SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_S)
#define SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_V  0x00000007U
#define SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_S  0
/** SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP : R/W; bitpos: [3]; default: 0;
 *  Need add description
 */
#define SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP    (BIT(3))
#define SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP_M  (SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP_V << SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP_S)
#define SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP_V  0x00000001U
#define SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP_S  3

/** SENSITIVE_INTERNAL_SRAM_USAGE_4_REG register
 *  register description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_4_REG (DR_REG_SENSITIVE_BASE + 0x24)
/** SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM    (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM_M  (SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM_V << SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM_S)
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM_V  0x00000001U
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM_S  0

/** SENSITIVE_CACHE_TAG_ACCESS_0_REG register
 *  register description
 */
#define SENSITIVE_CACHE_TAG_ACCESS_0_REG (DR_REG_SENSITIVE_BASE + 0x28)
/** SENSITIVE_CACHE_TAG_ACCESS_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_M  (SENSITIVE_CACHE_TAG_ACCESS_LOCK_V << SENSITIVE_CACHE_TAG_ACCESS_LOCK_S)
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_V  0x00000001U
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_S  0

/** SENSITIVE_CACHE_TAG_ACCESS_1_REG register
 *  register description
 */
#define SENSITIVE_CACHE_TAG_ACCESS_1_REG (DR_REG_SENSITIVE_BASE + 0x2c)
/** SENSITIVE_PRO_I_TAG_RD_ACS : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_PRO_I_TAG_RD_ACS    (BIT(0))
#define SENSITIVE_PRO_I_TAG_RD_ACS_M  (SENSITIVE_PRO_I_TAG_RD_ACS_V << SENSITIVE_PRO_I_TAG_RD_ACS_S)
#define SENSITIVE_PRO_I_TAG_RD_ACS_V  0x00000001U
#define SENSITIVE_PRO_I_TAG_RD_ACS_S  0
/** SENSITIVE_PRO_I_TAG_WR_ACS : R/W; bitpos: [1]; default: 1;
 *  Need add description
 */
#define SENSITIVE_PRO_I_TAG_WR_ACS    (BIT(1))
#define SENSITIVE_PRO_I_TAG_WR_ACS_M  (SENSITIVE_PRO_I_TAG_WR_ACS_V << SENSITIVE_PRO_I_TAG_WR_ACS_S)
#define SENSITIVE_PRO_I_TAG_WR_ACS_V  0x00000001U
#define SENSITIVE_PRO_I_TAG_WR_ACS_S  1
/** SENSITIVE_PRO_D_TAG_RD_ACS : R/W; bitpos: [2]; default: 1;
 *  Need add description
 */
#define SENSITIVE_PRO_D_TAG_RD_ACS    (BIT(2))
#define SENSITIVE_PRO_D_TAG_RD_ACS_M  (SENSITIVE_PRO_D_TAG_RD_ACS_V << SENSITIVE_PRO_D_TAG_RD_ACS_S)
#define SENSITIVE_PRO_D_TAG_RD_ACS_V  0x00000001U
#define SENSITIVE_PRO_D_TAG_RD_ACS_S  2
/** SENSITIVE_PRO_D_TAG_WR_ACS : R/W; bitpos: [3]; default: 1;
 *  Need add description
 */
#define SENSITIVE_PRO_D_TAG_WR_ACS    (BIT(3))
#define SENSITIVE_PRO_D_TAG_WR_ACS_M  (SENSITIVE_PRO_D_TAG_WR_ACS_V << SENSITIVE_PRO_D_TAG_WR_ACS_S)
#define SENSITIVE_PRO_D_TAG_WR_ACS_V  0x00000001U
#define SENSITIVE_PRO_D_TAG_WR_ACS_S  3

/** SENSITIVE_CACHE_MMU_ACCESS_0_REG register
 *  register description
 */
#define SENSITIVE_CACHE_MMU_ACCESS_0_REG (DR_REG_SENSITIVE_BASE + 0x30)
/** SENSITIVE_CACHE_MMU_ACCESS_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK    (BIT(0))
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_M  (SENSITIVE_CACHE_MMU_ACCESS_LOCK_V << SENSITIVE_CACHE_MMU_ACCESS_LOCK_S)
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_V  0x00000001U
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_S  0

/** SENSITIVE_CACHE_MMU_ACCESS_1_REG register
 *  register description
 */
#define SENSITIVE_CACHE_MMU_ACCESS_1_REG (DR_REG_SENSITIVE_BASE + 0x34)
/** SENSITIVE_PRO_MMU_RD_ACS : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_PRO_MMU_RD_ACS    (BIT(0))
#define SENSITIVE_PRO_MMU_RD_ACS_M  (SENSITIVE_PRO_MMU_RD_ACS_V << SENSITIVE_PRO_MMU_RD_ACS_S)
#define SENSITIVE_PRO_MMU_RD_ACS_V  0x00000001U
#define SENSITIVE_PRO_MMU_RD_ACS_S  0
/** SENSITIVE_PRO_MMU_WR_ACS : R/W; bitpos: [1]; default: 1;
 *  Need add description
 */
#define SENSITIVE_PRO_MMU_WR_ACS    (BIT(1))
#define SENSITIVE_PRO_MMU_WR_ACS_M  (SENSITIVE_PRO_MMU_WR_ACS_V << SENSITIVE_PRO_MMU_WR_ACS_S)
#define SENSITIVE_PRO_MMU_WR_ACS_V  0x00000001U
#define SENSITIVE_PRO_MMU_WR_ACS_S  1

/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x38)
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x3c)
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos: [17:16];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x40)
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x44)
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos:
 *  [13:12]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos:
 *  [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos:
 *  [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos:
 *  [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x48)
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x4c)
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos: [17:16];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x50)
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x54)
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos: [17:16];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x58)
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x5c)
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos:
 *  [13:12]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos:
 *  [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos:
 *  [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos:
 *  [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x60)
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x64)
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos: [17:16];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x68)
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x6c)
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos: [17:16];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x70)
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x74)
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos: [17:16];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x78)
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x7c)
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos:
 *  [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos:
 *  [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos:
 *  [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos:
 *  [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos:
 *  [13:12]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos:
 *  [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos:
 *  [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos:
 *  [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x80)
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x84)
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos:
 *  [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos:
 *  [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos:
 *  [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos:
 *  [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos:
 *  [13:12]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos:
 *  [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos:
 *  [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos:
 *  [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x88)
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x8c)
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos:
 *  [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos:
 *  [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos:
 *  [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos:
 *  [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos:
 *  [13:12]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos:
 *  [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos:
 *  [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos:
 *  [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x90)
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x94)
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos:
 *  [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos:
 *  [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos:
 *  [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos:
 *  [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos:
 *  [13:12]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos:
 *  [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos:
 *  [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos:
 *  [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18

/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_0_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0x98)
/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_S  0

/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_1_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0x9c)
/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_S  0
/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default: 1;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_S  1

/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_2_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0xa0)
/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_S  0
/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO; bitpos: [2:1];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003U
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x00000003U
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  1
/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO; bitpos: [26:3];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x00FFFFFFU
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x00FFFFFFU
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  3

/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_3_REG register
 *  register description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0xa4)
/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x00000001U
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_S  0
/** SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO; bitpos: [4:1];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN    0x0000000FU
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  (SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V << SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S)
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0x0000000FU
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1

/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xa8)
/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK : R/W; bitpos: [0];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_S  0

/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0xac)
/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0 : R/W; bitpos: [1:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_S  0
/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1 : R/W; bitpos: [3:2]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_S  2
/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2 : R/W; bitpos: [5:4]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_S  4
/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR : R/W; bitpos: [21:14]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR    0x000000FFU
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_M  (SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_V << SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_S)
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_V  0x000000FFU
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_S  14

/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_2_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0xb0)
/** SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0 : R/W; bitpos: [1:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_S  0
/** SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1 : R/W; bitpos: [3:2]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_S  2
/** SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2 : R/W; bitpos: [5:4]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_S  4
/** SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR : R/W; bitpos: [21:14]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR    0x000000FFU
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_V  0x000000FFU
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_S  14

/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_3_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0xb4)
/** SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0 : R/W; bitpos: [1:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_S  0
/** SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1 : R/W; bitpos: [3:2]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_S  2
/** SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2 : R/W; bitpos: [5:4]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2    0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_V  0x00000003U
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_S  4
/** SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR : R/W; bitpos: [21:14]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR    0x000000FFU
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_M  (SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_V << SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_S)
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_V  0x000000FFU
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_S  14

/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_4_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0xb8)
/** SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0 : R/W; bitpos: [1:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_S  0
/** SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1 : R/W; bitpos: [3:2]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_S  2
/** SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2 : R/W; bitpos: [5:4]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_S  4
/** SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR : R/W; bitpos: [21:14]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR    0x000000FFU
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_V  0x000000FFU
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_S  14

/** SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_5_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0xbc)
/** SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0 : R/W; bitpos: [1:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_S  0
/** SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1 : R/W; bitpos: [3:2]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_S  2
/** SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2 : R/W; bitpos: [5:4]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_S  4
/** SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR : R/W; bitpos: [21:14]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR    0x000000FFU
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_M  (SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_V << SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_S)
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_V  0x000000FFU
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_S  14

/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xc0)
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0xc4)
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos: [2:0];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  0
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos: [5:3];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  3
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos: [8:6];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  6
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos: [11:9];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  9
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0 : R/W;
 *  bitpos: [14:12]; default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S  12
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS : R/W; bitpos: [20:18];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S  18

/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_2_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0xc8)
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [2:0];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [5:3];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  3
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [8:6];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  6
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [11:9];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  9
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0 : R/W;
 *  bitpos: [14:12]; default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S  12
/** SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS : R/W; bitpos: [20:18];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS    0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_M  (SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V << SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S)
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V  0x00000007U
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S  18

/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_0_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0xcc)
/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_V  0x00000001U
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_S  0

/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_1_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0xd0)
/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x00000001U
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_S  0
/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_V  0x00000001U
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_S  1

/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_2_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0xd4)
/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x00000001U
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_S  0
/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO; bitpos: [1]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x00000001U
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  1
/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE : RO; bitpos: [2];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE    (BIT(2))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V  0x00000001U
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S  2
/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO; bitpos: [4:3];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003U
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x00000003U
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  3
/** SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO; bitpos: [28:5];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x00FFFFFFU
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  (SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V << SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S)
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x00FFFFFFU
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  5

/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xd8)
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0xdc)
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W; bitpos: [1:0];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W; bitpos: [17:16];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS : R/W; bitpos: [25:24];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S  24
/** SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS : R/W; bitpos: [27:26];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS    0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_M  (SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V << SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S)
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V  0x00000003U
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S  26

/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_0_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0xe0)
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_V  0x00000001U
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_S  0

/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_1_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0xe4)
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x00000001U
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_S  0
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_V  0x00000001U
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_S  1

/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_2_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0xe8)
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x00000001U
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_S  0
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK : RO; bitpos: [1]; default:
 *  0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK    (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V  0x00000001U
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S  1
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO; bitpos: [3:2];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD    0x00000003U
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x00000003U
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  2
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO; bitpos: [27:4];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR    0x00FFFFFFU
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0x00FFFFFFU
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  4

/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_3_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0xec)
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR    (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x00000001U
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  0
/** SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO; bitpos: [4:1];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN    0x0000000FU
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  (SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V << SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S)
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0x0000000FU
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0xf0)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0xf4)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1 : R/W; bitpos: [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S  2
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0 : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_S  10
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S  14
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX : R/W; bitpos: [17:16]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S  16
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG : R/W; bitpos: [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_S  18
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC : R/W; bitpos: [25:24]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S  24
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C : R/W; bitpos: [27:26]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S  26
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1 : R/W; bitpos: [31:30]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S  30

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_2_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0xf8)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0 : R/W; bitpos: [5:4]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0 : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S  10
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S  16
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE : R/W; bitpos: [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_S  18
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP : R/W; bitpos: [27:26];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S  26
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1 : R/W; bitpos: [29:28];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S  28
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER : R/W; bitpos: [31:30];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S  30

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_3_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0xfc)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2 : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL : R/W; bitpos: [5:4]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_S  10
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1 : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S  14
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT : R/W; bitpos: [23:22]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S  22

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_4_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0x100)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC : R/W; bitpos: [9:8]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S  8
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S  14
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_S  16
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_S  18
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC : R/W; bitpos: [21:20]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_S  20
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC : R/W; bitpos: [23:22];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_S  22
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX : R/W; bitpos: [27:26]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_S  26
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR : R/W; bitpos: [29:28];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_S  28
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST : R/W; bitpos: [31:30]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_S  30

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_5_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0x104)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MODEM_WIDGETS : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MODEM_WIDGETS    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MODEM_WIDGETS_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MODEM_WIDGETS_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MODEM_WIDGETS_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MODEM_WIDGETS_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MODEM_WIDGETS_S  2
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE : R/W; bitpos: [7:6]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT : R/W; bitpos: [9:8]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S  8
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY : R/W; bitpos: [11:10];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S  10
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S  12
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_S  14
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S  16
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S  18

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_6_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_6_REG (DR_REG_SENSITIVE_BASE + 0x108)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1 : R/W; bitpos: [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S  2
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0 : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_S  10
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S  14
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX : R/W; bitpos: [17:16]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S  16
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG : R/W; bitpos: [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_S  18
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC : R/W; bitpos: [25:24]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S  24
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C : R/W; bitpos: [27:26]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S  26
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1 : R/W; bitpos: [31:30]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S  30

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_7_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_7_REG (DR_REG_SENSITIVE_BASE + 0x10c)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0 : R/W; bitpos: [5:4]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0 : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S  10
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S  16
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE : R/W; bitpos: [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_S  18
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP : R/W; bitpos: [27:26];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S  26
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1 : R/W; bitpos: [29:28];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S  28
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER : R/W; bitpos: [31:30];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S  30

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_8_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_8_REG (DR_REG_SENSITIVE_BASE + 0x110)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2 : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL : R/W; bitpos: [5:4]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_S  10
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1 : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S  14
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT : R/W; bitpos: [23:22]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S  22

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_9_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_9_REG (DR_REG_SENSITIVE_BASE + 0x114)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI : R/W; bitpos: [5:4];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA : R/W; bitpos: [7:6];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC : R/W; bitpos: [9:8]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S  8
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE : R/W; bitpos: [15:14];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S  14
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_S  16
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3 : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_S  18
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC : R/W; bitpos: [21:20]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_S  20
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC : R/W; bitpos: [23:22];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_S  22
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX : R/W; bitpos: [27:26]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_S  26
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR : R/W; bitpos: [29:28];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_S  28
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST : R/W; bitpos: [31:30]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_S  30

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_10_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_10_REG (DR_REG_SENSITIVE_BASE + 0x118)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MODEM_WIDGETS : R/W; bitpos: [3:2];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MODEM_WIDGETS    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MODEM_WIDGETS_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MODEM_WIDGETS_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MODEM_WIDGETS_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MODEM_WIDGETS_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MODEM_WIDGETS_S  2
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S  4
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE : R/W; bitpos: [7:6]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT : R/W; bitpos: [9:8]; default:
 *  3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S  8
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY : R/W; bitpos: [11:10];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S  10
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG : R/W; bitpos: [13:12];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S  12
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_S  14
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S  16
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER : R/W; bitpos: [19:18];
 *  default: 3;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S  18

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_11_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_11_REG (DR_REG_SENSITIVE_BASE + 0x11c)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0 : R/W; bitpos: [10:0];
 *  default: 2047;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0    0x000007FFU
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V  0x000007FFU
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1 : R/W; bitpos: [21:11];
 *  default: 2047;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1    0x000007FFU
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V  0x000007FFU
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S  11

/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_12_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_12_REG (DR_REG_SENSITIVE_BASE + 0x120)
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L : R/W; bitpos: [2:0]; default:
 *  7;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L    0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V  0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S  0
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H : R/W; bitpos: [5:3]; default:
 *  7;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H    0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V  0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S  3
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L : R/W; bitpos: [8:6]; default:
 *  7;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L    0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V  0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S  6
/** SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H : R/W; bitpos: [11:9];
 *  default: 7;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H    0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_M  (SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V << SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S)
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V  0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S  9

/** SENSITIVE_REGION_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x124)
/** SENSITIVE_REGION_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_REGION_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_REGION_PMS_CONSTRAIN_LOCK_V << SENSITIVE_REGION_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_REGION_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_REGION_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x128)
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0 : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S  0
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1 : R/W; bitpos: [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S  2
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2 : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S  4
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3 : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S  6
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4 : R/W; bitpos: [9:8]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S  8
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5 : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S  10
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6 : R/W; bitpos: [13:12]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S  12

/** SENSITIVE_REGION_PMS_CONSTRAIN_2_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0x12c)
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0 : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S  0
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1 : R/W; bitpos: [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S  2
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2 : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S  4
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3 : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S  6
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4 : R/W; bitpos: [9:8]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S  8
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5 : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S  10
/** SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6 : R/W; bitpos: [13:12]; default: 3;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6    0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_M  (SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V << SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V  0x00000003U
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S  12

/** SENSITIVE_REGION_PMS_CONSTRAIN_3_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0x130)
/** SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0 : R/W; bitpos: [29:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0    0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_M  (SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_V << SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_V  0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_S  0

/** SENSITIVE_REGION_PMS_CONSTRAIN_4_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0x134)
/** SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1 : R/W; bitpos: [29:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1    0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_M  (SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_V << SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_V  0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_S  0

/** SENSITIVE_REGION_PMS_CONSTRAIN_5_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0x138)
/** SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2 : R/W; bitpos: [29:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2    0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_M  (SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_V << SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_V  0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_S  0

/** SENSITIVE_REGION_PMS_CONSTRAIN_6_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_6_REG (DR_REG_SENSITIVE_BASE + 0x13c)
/** SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3 : R/W; bitpos: [29:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3    0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_M  (SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_V << SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_V  0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_S  0

/** SENSITIVE_REGION_PMS_CONSTRAIN_7_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_7_REG (DR_REG_SENSITIVE_BASE + 0x140)
/** SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4 : R/W; bitpos: [29:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4    0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_M  (SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_V << SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_V  0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_S  0

/** SENSITIVE_REGION_PMS_CONSTRAIN_8_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_8_REG (DR_REG_SENSITIVE_BASE + 0x144)
/** SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5 : R/W; bitpos: [29:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5    0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_M  (SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_V << SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_V  0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_S  0

/** SENSITIVE_REGION_PMS_CONSTRAIN_9_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_9_REG (DR_REG_SENSITIVE_BASE + 0x148)
/** SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6 : R/W; bitpos: [29:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6    0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_M  (SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_V << SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_V  0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_S  0

/** SENSITIVE_REGION_PMS_CONSTRAIN_10_REG register
 *  register description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_10_REG (DR_REG_SENSITIVE_BASE + 0x14c)
/** SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7 : R/W; bitpos: [29:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7    0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_M  (SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_V << SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_S)
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_V  0x3FFFFFFFU
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_S  0

/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_0_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0x150)
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_S  0

/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_1_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0x154)
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_S  0
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_S  1

/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_2_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0x158)
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_S  0
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0 : RO; bitpos: [1]; default:
 *  0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S  1
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO; bitpos: [4:2]; default:
 *  0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE    0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x00000007U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  2
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO; bitpos: [5]; default:
 *  0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE    (BIT(5))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  5
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD : RO; bitpos: [7:6];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S  6

/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_3_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0x15c)
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR : RO; bitpos: [31:0];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR    0xFFFFFFFFU
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V  0xFFFFFFFFU
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S  0

/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_4_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_4_REG (DR_REG_SENSITIVE_BASE + 0x160)
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S  0
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN : R/W; bitpos: [1]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN    (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S  1

/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_5_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_5_REG (DR_REG_SENSITIVE_BASE + 0x164)
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V  0x00000001U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S  0
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE : RO; bitpos: [2:1];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S  1
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD : RO; bitpos: [4:3];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD    0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V  0x00000003U
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S  3

/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_6_REG register
 *  register description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_6_REG (DR_REG_SENSITIVE_BASE + 0x168)
/** SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR : RO; bitpos: [31:0];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR    0xFFFFFFFFU
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_M  (SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V << SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S)
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V  0xFFFFFFFFU
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S  0

/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_0_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_0_REG (DR_REG_SENSITIVE_BASE + 0x16c)
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_V  0x00000001U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_S  0

/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_1_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_1_REG (DR_REG_SENSITIVE_BASE + 0x170)
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_S  0
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1 : R/W; bitpos: [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_S  2
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0 : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_S  4
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_S  6
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_S  10
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_S  14
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_S  16
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG : R/W; bitpos: [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_S  18
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC : R/W; bitpos: [25:24]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_S  24
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C : R/W; bitpos: [27:26]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_S  26
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1 : R/W; bitpos: [31:30]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_S  30

/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_2_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_2_REG (DR_REG_SENSITIVE_BASE + 0x174)
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_S  0
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0 : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_S  4
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0 : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_S  6
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_S  10
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_S  16
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE : R/W; bitpos: [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_S  18
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP : R/W; bitpos: [27:26]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_S  26
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1 : R/W; bitpos: [29:28]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_S  28
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER : R/W; bitpos: [31:30]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_S  30

/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_3_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_3_REG (DR_REG_SENSITIVE_BASE + 0x178)
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2 : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_S  0
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_S  4
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI : R/W; bitpos: [11:10]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_S  10
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1 : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_S  14
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT : R/W; bitpos: [23:22]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_S  22

/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_4_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_4_REG (DR_REG_SENSITIVE_BASE + 0x17c)
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI : R/W; bitpos: [5:4]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_S  4
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA : R/W; bitpos: [7:6]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_S  6
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC : R/W; bitpos: [9:8]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_S  8
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE : R/W; bitpos: [15:14]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_S  14
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM : R/W; bitpos: [17:16]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_S  16
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3 : R/W; bitpos: [19:18]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_S  18
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC : R/W; bitpos: [21:20]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_S  20
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC : R/W; bitpos: [23:22]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_S  22
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX : R/W; bitpos: [27:26]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_S  26
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR : R/W; bitpos: [29:28]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_S  28
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST : R/W; bitpos: [31:30]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_S  30

/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_5_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_5_REG (DR_REG_SENSITIVE_BASE + 0x180)
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT : R/W; bitpos: [1:0]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_S  0
/** SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MODEM_WIDGETS : R/W; bitpos: [3:2]; default: 3;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MODEM_WIDGETS    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MODEM_WIDGETS_M  (SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MODEM_WIDGETS_V << SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MODEM_WIDGETS_S)
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MODEM_WIDGETS_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MODEM_WIDGETS_S  2

/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_0_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_0_REG (DR_REG_SENSITIVE_BASE + 0x184)
/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_V  0x00000001U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_S  0

/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_1_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_1_REG (DR_REG_SENSITIVE_BASE + 0x188)
/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_V  0x00000001U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_S  0
/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN : R/W; bitpos: [1]; default: 1;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN    (BIT(1))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_V  0x00000001U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_S  1

/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_2_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_2_REG (DR_REG_SENSITIVE_BASE + 0x18c)
/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR : RO; bitpos: [0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR    (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_V  0x00000001U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_S  0
/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS : RO; bitpos: [2:1];
 *  default: 0;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS    0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_V  0x00000003U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_S  1
/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO; bitpos: [5:3]; default:
 *  0;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE    0x00000007U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x00000007U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  3
/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO; bitpos: [6]; default:
 *  0;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE    (BIT(6))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x00000001U
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  6

/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_3_REG register
 *  register description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_3_REG (DR_REG_SENSITIVE_BASE + 0x190)
/** SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR : RO; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR    0xFFFFFFFFU
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_M  (SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_V << SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_S)
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_V  0xFFFFFFFFU
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_S  0

/** SENSITIVE_CLOCK_GATE_REG register
 *  register description
 */
#define SENSITIVE_CLOCK_GATE_REG (DR_REG_SENSITIVE_BASE + 0x194)
/** SENSITIVE_CLK_EN : R/W; bitpos: [0]; default: 1;
 *  Need add description
 */
#define SENSITIVE_CLK_EN    (BIT(0))
#define SENSITIVE_CLK_EN_M  (SENSITIVE_CLK_EN_V << SENSITIVE_CLK_EN_S)
#define SENSITIVE_CLK_EN_V  0x00000001U
#define SENSITIVE_CLK_EN_S  0

/** SENSITIVE_SENSITIVE_REG_DATE_REG register
 *  register description
 */
#define SENSITIVE_SENSITIVE_REG_DATE_REG (DR_REG_SENSITIVE_BASE + 0xffc)
/** SENSITIVE_SENSITIVE_REG_DATE : R/W; bitpos: [27:0]; default: 34636368;
 *  Need add description
 */
#define SENSITIVE_SENSITIVE_REG_DATE    0x0FFFFFFFU
#define SENSITIVE_SENSITIVE_REG_DATE_M  (SENSITIVE_SENSITIVE_REG_DATE_V << SENSITIVE_SENSITIVE_REG_DATE_S)
#define SENSITIVE_SENSITIVE_REG_DATE_V  0x0FFFFFFFU
#define SENSITIVE_SENSITIVE_REG_DATE_S  0

#ifdef __cplusplus
}
#endif
