/**
 * SPDX-FileCopyrightText: 2021-2022 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/* The value that needs to be written to RTC_CNTL_WDT_WKEY to write-enable the wdt registers */
#define RTC_CNTL_WDT_WKEY_VALUE 0x50D83AA1
/* The value that needs to be written to RTC_CNTL_SWD_WPROTECT_REG to write-enable the wdt registers */
#define RTC_CNTL_SWD_WKEY_VALUE 0x8F1D312A

/* Possible values for RTC_CNTL_WDT_CPU_RESET_LENGTH and RTC_CNTL_WDT_SYS_RESET_LENGTH */
#define RTC_WDT_RESET_LENGTH_100_NS    0
#define RTC_WDT_RESET_LENGTH_200_NS    1
#define RTC_WDT_RESET_LENGTH_300_NS    2
#define RTC_WDT_RESET_LENGTH_400_NS    3
#define RTC_WDT_RESET_LENGTH_500_NS    4
#define RTC_WDT_RESET_LENGTH_800_NS    5
#define RTC_WDT_RESET_LENGTH_1600_NS   6
#define RTC_WDT_RESET_LENGTH_3200_NS   7

#define RTC_CNTL_TIME0_REG		RTC_CNTL_TIME_LOW0_REG
#define RTC_CNTL_TIME1_REG		RTC_CNTL_TIME_HIGH0_REG

/** RTC_CNTL_OPTIONS0_REG register
 *  register description
 */
#define RTC_CNTL_OPTIONS0_REG (DR_REG_RTCCNTL_BASE + 0x0)
/** RTC_CNTL_SW_STALL_APPCPU_C0 : R/W; bitpos: [1:0]; default: 0;
 *  {reg_sw_stall_appcpu_c1[5:0],  reg_sw_stall_appcpu_c0[1:0]} == 0x86 will stall APP
 *  CPU
 */
#define RTC_CNTL_SW_STALL_APPCPU_C0    0x00000003U
#define RTC_CNTL_SW_STALL_APPCPU_C0_M  (RTC_CNTL_SW_STALL_APPCPU_C0_V << RTC_CNTL_SW_STALL_APPCPU_C0_S)
#define RTC_CNTL_SW_STALL_APPCPU_C0_V  0x00000003U
#define RTC_CNTL_SW_STALL_APPCPU_C0_S  0
/** RTC_CNTL_SW_STALL_PROCPU_C0 : R/W; bitpos: [3:2]; default: 0;
 *  {reg_sw_stall_procpu_c1[5:0],  reg_sw_stall_procpu_c0[1:0]} == 0x86 will stall PRO
 *  CPU
 */
#define RTC_CNTL_SW_STALL_PROCPU_C0    0x00000003U
#define RTC_CNTL_SW_STALL_PROCPU_C0_M  (RTC_CNTL_SW_STALL_PROCPU_C0_V << RTC_CNTL_SW_STALL_PROCPU_C0_S)
#define RTC_CNTL_SW_STALL_PROCPU_C0_V  0x00000003U
#define RTC_CNTL_SW_STALL_PROCPU_C0_S  2
/** RTC_CNTL_SW_APPCPU_RST : WO; bitpos: [4]; default: 0;
 *  APP CPU SW reset
 */
#define RTC_CNTL_SW_APPCPU_RST    (BIT(4))
#define RTC_CNTL_SW_APPCPU_RST_M  (RTC_CNTL_SW_APPCPU_RST_V << RTC_CNTL_SW_APPCPU_RST_S)
#define RTC_CNTL_SW_APPCPU_RST_V  0x00000001U
#define RTC_CNTL_SW_APPCPU_RST_S  4
/** RTC_CNTL_SW_PROCPU_RST : WO; bitpos: [5]; default: 0;
 *  PRO CPU SW reset
 */
#define RTC_CNTL_SW_PROCPU_RST    (BIT(5))
#define RTC_CNTL_SW_PROCPU_RST_M  (RTC_CNTL_SW_PROCPU_RST_V << RTC_CNTL_SW_PROCPU_RST_S)
#define RTC_CNTL_SW_PROCPU_RST_V  0x00000001U
#define RTC_CNTL_SW_PROCPU_RST_S  5
/** RTC_CNTL_BB_I2C_FORCE_PD : R/W; bitpos: [6]; default: 0;
 *  BB_I2C force power down
 */
#define RTC_CNTL_BB_I2C_FORCE_PD    (BIT(6))
#define RTC_CNTL_BB_I2C_FORCE_PD_M  (RTC_CNTL_BB_I2C_FORCE_PD_V << RTC_CNTL_BB_I2C_FORCE_PD_S)
#define RTC_CNTL_BB_I2C_FORCE_PD_V  0x00000001U
#define RTC_CNTL_BB_I2C_FORCE_PD_S  6
/** RTC_CNTL_BB_I2C_FORCE_PU : R/W; bitpos: [7]; default: 0;
 *  BB_I2C force power up
 */
#define RTC_CNTL_BB_I2C_FORCE_PU    (BIT(7))
#define RTC_CNTL_BB_I2C_FORCE_PU_M  (RTC_CNTL_BB_I2C_FORCE_PU_V << RTC_CNTL_BB_I2C_FORCE_PU_S)
#define RTC_CNTL_BB_I2C_FORCE_PU_V  0x00000001U
#define RTC_CNTL_BB_I2C_FORCE_PU_S  7
/** RTC_CNTL_BBPLL_I2C_FORCE_PD : R/W; bitpos: [8]; default: 0;
 *  BB_PLL _I2C force power down
 */
#define RTC_CNTL_BBPLL_I2C_FORCE_PD    (BIT(8))
#define RTC_CNTL_BBPLL_I2C_FORCE_PD_M  (RTC_CNTL_BBPLL_I2C_FORCE_PD_V << RTC_CNTL_BBPLL_I2C_FORCE_PD_S)
#define RTC_CNTL_BBPLL_I2C_FORCE_PD_V  0x00000001U
#define RTC_CNTL_BBPLL_I2C_FORCE_PD_S  8
/** RTC_CNTL_BBPLL_I2C_FORCE_PU : R/W; bitpos: [9]; default: 0;
 *  BB_PLL_I2C force power up
 */
#define RTC_CNTL_BBPLL_I2C_FORCE_PU    (BIT(9))
#define RTC_CNTL_BBPLL_I2C_FORCE_PU_M  (RTC_CNTL_BBPLL_I2C_FORCE_PU_V << RTC_CNTL_BBPLL_I2C_FORCE_PU_S)
#define RTC_CNTL_BBPLL_I2C_FORCE_PU_V  0x00000001U
#define RTC_CNTL_BBPLL_I2C_FORCE_PU_S  9
/** RTC_CNTL_BBPLL_FORCE_PD : R/W; bitpos: [10]; default: 0;
 *  BB_PLL force power down
 */
#define RTC_CNTL_BBPLL_FORCE_PD    (BIT(10))
#define RTC_CNTL_BBPLL_FORCE_PD_M  (RTC_CNTL_BBPLL_FORCE_PD_V << RTC_CNTL_BBPLL_FORCE_PD_S)
#define RTC_CNTL_BBPLL_FORCE_PD_V  0x00000001U
#define RTC_CNTL_BBPLL_FORCE_PD_S  10
/** RTC_CNTL_BBPLL_FORCE_PU : R/W; bitpos: [11]; default: 0;
 *  BB_PLL force power up
 */
#define RTC_CNTL_BBPLL_FORCE_PU    (BIT(11))
#define RTC_CNTL_BBPLL_FORCE_PU_M  (RTC_CNTL_BBPLL_FORCE_PU_V << RTC_CNTL_BBPLL_FORCE_PU_S)
#define RTC_CNTL_BBPLL_FORCE_PU_V  0x00000001U
#define RTC_CNTL_BBPLL_FORCE_PU_S  11
/** RTC_CNTL_XTL_FORCE_PD : R/W; bitpos: [12]; default: 0;
 *  crystall force power down
 */
#define RTC_CNTL_XTL_FORCE_PD    (BIT(12))
#define RTC_CNTL_XTL_FORCE_PD_M  (RTC_CNTL_XTL_FORCE_PD_V << RTC_CNTL_XTL_FORCE_PD_S)
#define RTC_CNTL_XTL_FORCE_PD_V  0x00000001U
#define RTC_CNTL_XTL_FORCE_PD_S  12
/** RTC_CNTL_XTL_FORCE_PU : R/W; bitpos: [13]; default: 1;
 *  crystall force power up
 */
#define RTC_CNTL_XTL_FORCE_PU    (BIT(13))
#define RTC_CNTL_XTL_FORCE_PU_M  (RTC_CNTL_XTL_FORCE_PU_V << RTC_CNTL_XTL_FORCE_PU_S)
#define RTC_CNTL_XTL_FORCE_PU_V  0x00000001U
#define RTC_CNTL_XTL_FORCE_PU_S  13
/** RTC_CNTL_XTL_EN_WAIT : R/W; bitpos: [17:14]; default: 2;
 *  wait bias_sleep and current source wakeup
 */
#define RTC_CNTL_XTL_EN_WAIT    0x0000000FU
#define RTC_CNTL_XTL_EN_WAIT_M  (RTC_CNTL_XTL_EN_WAIT_V << RTC_CNTL_XTL_EN_WAIT_S)
#define RTC_CNTL_XTL_EN_WAIT_V  0x0000000FU
#define RTC_CNTL_XTL_EN_WAIT_S  14
/** RTC_CNTL_XPD_RFPLL : R/W; bitpos: [18]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XPD_RFPLL    (BIT(18))
#define RTC_CNTL_XPD_RFPLL_M  (RTC_CNTL_XPD_RFPLL_V << RTC_CNTL_XPD_RFPLL_S)
#define RTC_CNTL_XPD_RFPLL_V  0x00000001U
#define RTC_CNTL_XPD_RFPLL_S  18
/** RTC_CNTL_XPD_RFPLL_FORCE : R/W; bitpos: [19]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XPD_RFPLL_FORCE    (BIT(19))
#define RTC_CNTL_XPD_RFPLL_FORCE_M  (RTC_CNTL_XPD_RFPLL_FORCE_V << RTC_CNTL_XPD_RFPLL_FORCE_S)
#define RTC_CNTL_XPD_RFPLL_FORCE_V  0x00000001U
#define RTC_CNTL_XPD_RFPLL_FORCE_S  19
/** RTC_CNTL_XTL_EXT_CTR_SEL : R/W; bitpos: [22:20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XTL_EXT_CTR_SEL    0x00000007U
#define RTC_CNTL_XTL_EXT_CTR_SEL_M  (RTC_CNTL_XTL_EXT_CTR_SEL_V << RTC_CNTL_XTL_EXT_CTR_SEL_S)
#define RTC_CNTL_XTL_EXT_CTR_SEL_V  0x00000007U
#define RTC_CNTL_XTL_EXT_CTR_SEL_S  20
/** RTC_CNTL_XTL_FORCE_ISO : R/W; bitpos: [23]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XTL_FORCE_ISO    (BIT(23))
#define RTC_CNTL_XTL_FORCE_ISO_M  (RTC_CNTL_XTL_FORCE_ISO_V << RTC_CNTL_XTL_FORCE_ISO_S)
#define RTC_CNTL_XTL_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_XTL_FORCE_ISO_S  23
/** RTC_CNTL_PLL_FORCE_ISO : R/W; bitpos: [24]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_PLL_FORCE_ISO    (BIT(24))
#define RTC_CNTL_PLL_FORCE_ISO_M  (RTC_CNTL_PLL_FORCE_ISO_V << RTC_CNTL_PLL_FORCE_ISO_S)
#define RTC_CNTL_PLL_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_PLL_FORCE_ISO_S  24
/** RTC_CNTL_ANALOG_FORCE_ISO : R/W; bitpos: [25]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_ANALOG_FORCE_ISO    (BIT(25))
#define RTC_CNTL_ANALOG_FORCE_ISO_M  (RTC_CNTL_ANALOG_FORCE_ISO_V << RTC_CNTL_ANALOG_FORCE_ISO_S)
#define RTC_CNTL_ANALOG_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_ANALOG_FORCE_ISO_S  25
/** RTC_CNTL_XTL_FORCE_NOISO : R/W; bitpos: [26]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_XTL_FORCE_NOISO    (BIT(26))
#define RTC_CNTL_XTL_FORCE_NOISO_M  (RTC_CNTL_XTL_FORCE_NOISO_V << RTC_CNTL_XTL_FORCE_NOISO_S)
#define RTC_CNTL_XTL_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_XTL_FORCE_NOISO_S  26
/** RTC_CNTL_PLL_FORCE_NOISO : R/W; bitpos: [27]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_PLL_FORCE_NOISO    (BIT(27))
#define RTC_CNTL_PLL_FORCE_NOISO_M  (RTC_CNTL_PLL_FORCE_NOISO_V << RTC_CNTL_PLL_FORCE_NOISO_S)
#define RTC_CNTL_PLL_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_PLL_FORCE_NOISO_S  27
/** RTC_CNTL_ANALOG_FORCE_NOISO : R/W; bitpos: [28]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_ANALOG_FORCE_NOISO    (BIT(28))
#define RTC_CNTL_ANALOG_FORCE_NOISO_M  (RTC_CNTL_ANALOG_FORCE_NOISO_V << RTC_CNTL_ANALOG_FORCE_NOISO_S)
#define RTC_CNTL_ANALOG_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_ANALOG_FORCE_NOISO_S  28
/** RTC_CNTL_DG_WRAP_FORCE_RST : R/W; bitpos: [29]; default: 0;
 *  digital wrap force reset in deep sleep
 */
#define RTC_CNTL_DG_WRAP_FORCE_RST    (BIT(29))
#define RTC_CNTL_DG_WRAP_FORCE_RST_M  (RTC_CNTL_DG_WRAP_FORCE_RST_V << RTC_CNTL_DG_WRAP_FORCE_RST_S)
#define RTC_CNTL_DG_WRAP_FORCE_RST_V  0x00000001U
#define RTC_CNTL_DG_WRAP_FORCE_RST_S  29
/** RTC_CNTL_DG_WRAP_FORCE_NORST : R/W; bitpos: [30]; default: 0;
 *  digital core force no reset in deep sleep
 */
#define RTC_CNTL_DG_WRAP_FORCE_NORST    (BIT(30))
#define RTC_CNTL_DG_WRAP_FORCE_NORST_M  (RTC_CNTL_DG_WRAP_FORCE_NORST_V << RTC_CNTL_DG_WRAP_FORCE_NORST_S)
#define RTC_CNTL_DG_WRAP_FORCE_NORST_V  0x00000001U
#define RTC_CNTL_DG_WRAP_FORCE_NORST_S  30
/** RTC_CNTL_SW_SYS_RST : WO; bitpos: [31]; default: 0;
 *  SW system  reset
 */
#define RTC_CNTL_SW_SYS_RST    (BIT(31))
#define RTC_CNTL_SW_SYS_RST_M  (RTC_CNTL_SW_SYS_RST_V << RTC_CNTL_SW_SYS_RST_S)
#define RTC_CNTL_SW_SYS_RST_V  0x00000001U
#define RTC_CNTL_SW_SYS_RST_S  31

/** RTC_CNTL_SLP_TIMER0_REG register
 *  register description
 */
#define RTC_CNTL_SLP_TIMER0_REG (DR_REG_RTCCNTL_BASE + 0x4)
/** RTC_CNTL_SLP_VAL_LO : R/W; bitpos: [31:0]; default: 0;
 *  RTC sleep timer low 32 bits
 */
#define RTC_CNTL_SLP_VAL_LO    0xFFFFFFFFU
#define RTC_CNTL_SLP_VAL_LO_M  (RTC_CNTL_SLP_VAL_LO_V << RTC_CNTL_SLP_VAL_LO_S)
#define RTC_CNTL_SLP_VAL_LO_V  0xFFFFFFFFU
#define RTC_CNTL_SLP_VAL_LO_S  0

/** RTC_CNTL_SLP_TIMER1_REG register
 *  register description
 */
#define RTC_CNTL_SLP_TIMER1_REG (DR_REG_RTCCNTL_BASE + 0x8)
/** RTC_CNTL_SLP_VAL_HI : R/W; bitpos: [15:0]; default: 0;
 *  RTC sleep timer high 16 bits
 */
#define RTC_CNTL_SLP_VAL_HI    0x0000FFFFU
#define RTC_CNTL_SLP_VAL_HI_M  (RTC_CNTL_SLP_VAL_HI_V << RTC_CNTL_SLP_VAL_HI_S)
#define RTC_CNTL_SLP_VAL_HI_V  0x0000FFFFU
#define RTC_CNTL_SLP_VAL_HI_S  0
/** RTC_CNTL_MAIN_TIMER_ALARM_EN : WO; bitpos: [16]; default: 0;
 *  timer alarm enable bit
 */
#define RTC_CNTL_MAIN_TIMER_ALARM_EN    (BIT(16))
#define RTC_CNTL_MAIN_TIMER_ALARM_EN_M  (RTC_CNTL_MAIN_TIMER_ALARM_EN_V << RTC_CNTL_MAIN_TIMER_ALARM_EN_S)
#define RTC_CNTL_MAIN_TIMER_ALARM_EN_V  0x00000001U
#define RTC_CNTL_MAIN_TIMER_ALARM_EN_S  16

/** RTC_CNTL_TIME_UPDATE_REG register
 *  register description
 */
#define RTC_CNTL_TIME_UPDATE_REG (DR_REG_RTCCNTL_BASE + 0xc)
/** RTC_CNTL_TIMER_SYS_STALL : R/W; bitpos: [27]; default: 0;
 *  Enable to record system stall time
 */
#define RTC_CNTL_TIMER_SYS_STALL    (BIT(27))
#define RTC_CNTL_TIMER_SYS_STALL_M  (RTC_CNTL_TIMER_SYS_STALL_V << RTC_CNTL_TIMER_SYS_STALL_S)
#define RTC_CNTL_TIMER_SYS_STALL_V  0x00000001U
#define RTC_CNTL_TIMER_SYS_STALL_S  27
/** RTC_CNTL_TIMER_XTL_OFF : R/W; bitpos: [28]; default: 0;
 *  Enable to record 40M XTAL OFF time
 */
#define RTC_CNTL_TIMER_XTL_OFF    (BIT(28))
#define RTC_CNTL_TIMER_XTL_OFF_M  (RTC_CNTL_TIMER_XTL_OFF_V << RTC_CNTL_TIMER_XTL_OFF_S)
#define RTC_CNTL_TIMER_XTL_OFF_V  0x00000001U
#define RTC_CNTL_TIMER_XTL_OFF_S  28
/** RTC_CNTL_TIMER_SYS_RST : R/W; bitpos: [29]; default: 0;
 *  enable to record system reset time
 */
#define RTC_CNTL_TIMER_SYS_RST    (BIT(29))
#define RTC_CNTL_TIMER_SYS_RST_M  (RTC_CNTL_TIMER_SYS_RST_V << RTC_CNTL_TIMER_SYS_RST_S)
#define RTC_CNTL_TIMER_SYS_RST_V  0x00000001U
#define RTC_CNTL_TIMER_SYS_RST_S  29
/** RTC_CNTL_TIME_UPDATE : WO; bitpos: [31]; default: 0;
 *  Set 1: to update register with RTC timer
 */
#define RTC_CNTL_TIME_UPDATE    (BIT(31))
#define RTC_CNTL_TIME_UPDATE_M  (RTC_CNTL_TIME_UPDATE_V << RTC_CNTL_TIME_UPDATE_S)
#define RTC_CNTL_TIME_UPDATE_V  0x00000001U
#define RTC_CNTL_TIME_UPDATE_S  31

/** RTC_CNTL_TIME_LOW0_REG register
 *  register description
 */
#define RTC_CNTL_TIME_LOW0_REG (DR_REG_RTCCNTL_BASE + 0x10)
/** RTC_CNTL_TIMER_VALUE0_LOW : RO; bitpos: [31:0]; default: 0;
 *  RTC timer low 32 bits
 */
#define RTC_CNTL_TIMER_VALUE0_LOW    0xFFFFFFFFU
#define RTC_CNTL_TIMER_VALUE0_LOW_M  (RTC_CNTL_TIMER_VALUE0_LOW_V << RTC_CNTL_TIMER_VALUE0_LOW_S)
#define RTC_CNTL_TIMER_VALUE0_LOW_V  0xFFFFFFFFU
#define RTC_CNTL_TIMER_VALUE0_LOW_S  0

/** RTC_CNTL_TIME_HIGH0_REG register
 *  register description
 */
#define RTC_CNTL_TIME_HIGH0_REG (DR_REG_RTCCNTL_BASE + 0x14)
/** RTC_CNTL_TIMER_VALUE0_HIGH : RO; bitpos: [15:0]; default: 0;
 *  RTC timer high 16 bits
 */
#define RTC_CNTL_TIMER_VALUE0_HIGH    0x0000FFFFU
#define RTC_CNTL_TIMER_VALUE0_HIGH_M  (RTC_CNTL_TIMER_VALUE0_HIGH_V << RTC_CNTL_TIMER_VALUE0_HIGH_S)
#define RTC_CNTL_TIMER_VALUE0_HIGH_V  0x0000FFFFU
#define RTC_CNTL_TIMER_VALUE0_HIGH_S  0

/** RTC_CNTL_STATE0_REG register
 *  register description
 */
#define RTC_CNTL_STATE0_REG (DR_REG_RTCCNTL_BASE + 0x18)
/** RTC_CNTL_SW_CPU_INT : WO; bitpos: [0]; default: 0;
 *  rtc software interrupt to main cpu
 */
#define RTC_CNTL_SW_CPU_INT    (BIT(0))
#define RTC_CNTL_SW_CPU_INT_M  (RTC_CNTL_SW_CPU_INT_V << RTC_CNTL_SW_CPU_INT_S)
#define RTC_CNTL_SW_CPU_INT_V  0x00000001U
#define RTC_CNTL_SW_CPU_INT_S  0
/** RTC_CNTL_SLP_REJECT_CAUSE_CLR : WO; bitpos: [1]; default: 0;
 *  clear rtc sleep reject cause
 */
#define RTC_CNTL_SLP_REJECT_CAUSE_CLR    (BIT(1))
#define RTC_CNTL_SLP_REJECT_CAUSE_CLR_M  (RTC_CNTL_SLP_REJECT_CAUSE_CLR_V << RTC_CNTL_SLP_REJECT_CAUSE_CLR_S)
#define RTC_CNTL_SLP_REJECT_CAUSE_CLR_V  0x00000001U
#define RTC_CNTL_SLP_REJECT_CAUSE_CLR_S  1
/** RTC_CNTL_APB2RTC_BRIDGE_SEL : R/W; bitpos: [22]; default: 0;
 *  1: APB to RTC using bridge,  0: APB to RTC using sync
 */
#define RTC_CNTL_APB2RTC_BRIDGE_SEL    (BIT(22))
#define RTC_CNTL_APB2RTC_BRIDGE_SEL_M  (RTC_CNTL_APB2RTC_BRIDGE_SEL_V << RTC_CNTL_APB2RTC_BRIDGE_SEL_S)
#define RTC_CNTL_APB2RTC_BRIDGE_SEL_V  0x00000001U
#define RTC_CNTL_APB2RTC_BRIDGE_SEL_S  22
/** RTC_CNTL_SDIO_ACTIVE_IND : RO; bitpos: [28]; default: 0;
 *  SDIO active indication
 */
#define RTC_CNTL_SDIO_ACTIVE_IND    (BIT(28))
#define RTC_CNTL_SDIO_ACTIVE_IND_M  (RTC_CNTL_SDIO_ACTIVE_IND_V << RTC_CNTL_SDIO_ACTIVE_IND_S)
#define RTC_CNTL_SDIO_ACTIVE_IND_V  0x00000001U
#define RTC_CNTL_SDIO_ACTIVE_IND_S  28
/** RTC_CNTL_SLP_WAKEUP : R/W; bitpos: [29]; default: 0;
 *  leep wakeup bit
 */
#define RTC_CNTL_SLP_WAKEUP    (BIT(29))
#define RTC_CNTL_SLP_WAKEUP_M  (RTC_CNTL_SLP_WAKEUP_V << RTC_CNTL_SLP_WAKEUP_S)
#define RTC_CNTL_SLP_WAKEUP_V  0x00000001U
#define RTC_CNTL_SLP_WAKEUP_S  29
/** RTC_CNTL_SLP_REJECT : R/W; bitpos: [30]; default: 0;
 *  leep reject bit
 */
#define RTC_CNTL_SLP_REJECT    (BIT(30))
#define RTC_CNTL_SLP_REJECT_M  (RTC_CNTL_SLP_REJECT_V << RTC_CNTL_SLP_REJECT_S)
#define RTC_CNTL_SLP_REJECT_V  0x00000001U
#define RTC_CNTL_SLP_REJECT_S  30
/** RTC_CNTL_SLEEP_EN : R/W; bitpos: [31]; default: 0;
 *  sleep enable bit
 */
#define RTC_CNTL_SLEEP_EN    (BIT(31))
#define RTC_CNTL_SLEEP_EN_M  (RTC_CNTL_SLEEP_EN_V << RTC_CNTL_SLEEP_EN_S)
#define RTC_CNTL_SLEEP_EN_V  0x00000001U
#define RTC_CNTL_SLEEP_EN_S  31

/** RTC_CNTL_TIMER1_REG register
 *  register description
 */
#define RTC_CNTL_TIMER1_REG (DR_REG_RTCCNTL_BASE + 0x1c)
/** RTC_CNTL_CPU_STALL_EN : R/W; bitpos: [0]; default: 1;
 *  CPU stall enable bit
 */
#define RTC_CNTL_CPU_STALL_EN    (BIT(0))
#define RTC_CNTL_CPU_STALL_EN_M  (RTC_CNTL_CPU_STALL_EN_V << RTC_CNTL_CPU_STALL_EN_S)
#define RTC_CNTL_CPU_STALL_EN_V  0x00000001U
#define RTC_CNTL_CPU_STALL_EN_S  0
/** RTC_CNTL_CPU_STALL_WAIT : R/W; bitpos: [5:1]; default: 1;
 *  CPU stall wait cycles in fast_clk_rtc
 */
#define RTC_CNTL_CPU_STALL_WAIT    0x0000001FU
#define RTC_CNTL_CPU_STALL_WAIT_M  (RTC_CNTL_CPU_STALL_WAIT_V << RTC_CNTL_CPU_STALL_WAIT_S)
#define RTC_CNTL_CPU_STALL_WAIT_V  0x0000001FU
#define RTC_CNTL_CPU_STALL_WAIT_S  1
/** RTC_CNTL_CK8M_WAIT : R/W; bitpos: [13:6]; default: 16;
 *  CK8M wait cycles in slow_clk_rtc
 */
#define RTC_CNTL_CK8M_WAIT    0x000000FFU
#define RTC_CNTL_CK8M_WAIT_M  (RTC_CNTL_CK8M_WAIT_V << RTC_CNTL_CK8M_WAIT_S)
#define RTC_CNTL_CK8M_WAIT_V  0x000000FFU
#define RTC_CNTL_CK8M_WAIT_S  6
/** RTC_CNTL_XTL_BUF_WAIT : R/W; bitpos: [23:14]; default: 80;
 *  XTAL wait cycles in slow_clk_rtc
 */
#define RTC_CNTL_XTL_BUF_WAIT    0x000003FFU
#define RTC_CNTL_XTL_BUF_WAIT_M  (RTC_CNTL_XTL_BUF_WAIT_V << RTC_CNTL_XTL_BUF_WAIT_S)
#define RTC_CNTL_XTL_BUF_WAIT_V  0x000003FFU
#define RTC_CNTL_XTL_BUF_WAIT_S  14
/** RTC_CNTL_PLL_BUF_WAIT : R/W; bitpos: [31:24]; default: 40;
 *  PLL wait cycles in slow_clk_rtc
 */
#define RTC_CNTL_PLL_BUF_WAIT    0x000000FFU
#define RTC_CNTL_PLL_BUF_WAIT_M  (RTC_CNTL_PLL_BUF_WAIT_V << RTC_CNTL_PLL_BUF_WAIT_S)
#define RTC_CNTL_PLL_BUF_WAIT_V  0x000000FFU
#define RTC_CNTL_PLL_BUF_WAIT_S  24

/** RTC_CNTL_TIMER2_REG register
 *  register description
 */
#define RTC_CNTL_TIMER2_REG (DR_REG_RTCCNTL_BASE + 0x20)
/** RTC_CNTL_MIN_TIME_CK8M_OFF : R/W; bitpos: [31:24]; default: 1;
 *  minimal cycles in slow_clk_rtc for CK8M in power down state
 */
#define RTC_CNTL_MIN_TIME_CK8M_OFF    0x000000FFU
#define RTC_CNTL_MIN_TIME_CK8M_OFF_M  (RTC_CNTL_MIN_TIME_CK8M_OFF_V << RTC_CNTL_MIN_TIME_CK8M_OFF_S)
#define RTC_CNTL_MIN_TIME_CK8M_OFF_V  0x000000FFU
#define RTC_CNTL_MIN_TIME_CK8M_OFF_S  24

/** RTC_CNTL_TIMER3_REG register
 *  register description
 */
#define RTC_CNTL_TIMER3_REG (DR_REG_RTCCNTL_BASE + 0x24)
/** RTC_CNTL_WIFI_WAIT_TIMER : R/W; bitpos: [8:0]; default: 8;
 *  Need add description
 */
#define RTC_CNTL_WIFI_WAIT_TIMER    0x000001FFU
#define RTC_CNTL_WIFI_WAIT_TIMER_M  (RTC_CNTL_WIFI_WAIT_TIMER_V << RTC_CNTL_WIFI_WAIT_TIMER_S)
#define RTC_CNTL_WIFI_WAIT_TIMER_V  0x000001FFU
#define RTC_CNTL_WIFI_WAIT_TIMER_S  0
/** RTC_CNTL_WIFI_POWERUP_TIMER : R/W; bitpos: [15:9]; default: 5;
 *  Need add description
 */
#define RTC_CNTL_WIFI_POWERUP_TIMER    0x0000007FU
#define RTC_CNTL_WIFI_POWERUP_TIMER_M  (RTC_CNTL_WIFI_POWERUP_TIMER_V << RTC_CNTL_WIFI_POWERUP_TIMER_S)
#define RTC_CNTL_WIFI_POWERUP_TIMER_V  0x0000007FU
#define RTC_CNTL_WIFI_POWERUP_TIMER_S  9
/** RTC_CNTL_BT_WAIT_TIMER : R/W; bitpos: [24:16]; default: 8;
 *  Need add description
 */
#define RTC_CNTL_BT_WAIT_TIMER    0x000001FFU
#define RTC_CNTL_BT_WAIT_TIMER_M  (RTC_CNTL_BT_WAIT_TIMER_V << RTC_CNTL_BT_WAIT_TIMER_S)
#define RTC_CNTL_BT_WAIT_TIMER_V  0x000001FFU
#define RTC_CNTL_BT_WAIT_TIMER_S  16
/** RTC_CNTL_BT_POWERUP_TIMER : R/W; bitpos: [31:25]; default: 5;
 *  Need add description
 */
#define RTC_CNTL_BT_POWERUP_TIMER    0x0000007FU
#define RTC_CNTL_BT_POWERUP_TIMER_M  (RTC_CNTL_BT_POWERUP_TIMER_V << RTC_CNTL_BT_POWERUP_TIMER_S)
#define RTC_CNTL_BT_POWERUP_TIMER_V  0x0000007FU
#define RTC_CNTL_BT_POWERUP_TIMER_S  25

/** RTC_CNTL_TIMER4_REG register
 *  register description
 */
#define RTC_CNTL_TIMER4_REG (DR_REG_RTCCNTL_BASE + 0x28)
/** RTC_CNTL_CPU_TOP_WAIT_TIMER : R/W; bitpos: [8:0]; default: 8;
 *  Need add description
 */
#define RTC_CNTL_CPU_TOP_WAIT_TIMER    0x000001FFU
#define RTC_CNTL_CPU_TOP_WAIT_TIMER_M  (RTC_CNTL_CPU_TOP_WAIT_TIMER_V << RTC_CNTL_CPU_TOP_WAIT_TIMER_S)
#define RTC_CNTL_CPU_TOP_WAIT_TIMER_V  0x000001FFU
#define RTC_CNTL_CPU_TOP_WAIT_TIMER_S  0
/** RTC_CNTL_CPU_TOP_POWERUP_TIMER : R/W; bitpos: [15:9]; default: 5;
 *  Need add description
 */
#define RTC_CNTL_CPU_TOP_POWERUP_TIMER    0x0000007FU
#define RTC_CNTL_CPU_TOP_POWERUP_TIMER_M  (RTC_CNTL_CPU_TOP_POWERUP_TIMER_V << RTC_CNTL_CPU_TOP_POWERUP_TIMER_S)
#define RTC_CNTL_CPU_TOP_POWERUP_TIMER_V  0x0000007FU
#define RTC_CNTL_CPU_TOP_POWERUP_TIMER_S  9
/** RTC_CNTL_DG_WRAP_WAIT_TIMER : R/W; bitpos: [24:16]; default: 32;
 *  Need add description
 */
#define RTC_CNTL_DG_WRAP_WAIT_TIMER    0x000001FFU
#define RTC_CNTL_DG_WRAP_WAIT_TIMER_M  (RTC_CNTL_DG_WRAP_WAIT_TIMER_V << RTC_CNTL_DG_WRAP_WAIT_TIMER_S)
#define RTC_CNTL_DG_WRAP_WAIT_TIMER_V  0x000001FFU
#define RTC_CNTL_DG_WRAP_WAIT_TIMER_S  16
/** RTC_CNTL_DG_WRAP_POWERUP_TIMER : R/W; bitpos: [31:25]; default: 8;
 *  Need add description
 */
#define RTC_CNTL_DG_WRAP_POWERUP_TIMER    0x0000007FU
#define RTC_CNTL_DG_WRAP_POWERUP_TIMER_M  (RTC_CNTL_DG_WRAP_POWERUP_TIMER_V << RTC_CNTL_DG_WRAP_POWERUP_TIMER_S)
#define RTC_CNTL_DG_WRAP_POWERUP_TIMER_V  0x0000007FU
#define RTC_CNTL_DG_WRAP_POWERUP_TIMER_S  25

/** RTC_CNTL_TIMER5_REG register
 *  register description
 */
#define RTC_CNTL_TIMER5_REG (DR_REG_RTCCNTL_BASE + 0x2c)
/** RTC_CNTL_MIN_SLP_VAL : R/W; bitpos: [15:8]; default: 128;
 *  minimal sleep cycles in slow_clk_rtc
 */
#define RTC_CNTL_MIN_SLP_VAL    0x000000FFU
#define RTC_CNTL_MIN_SLP_VAL_M  (RTC_CNTL_MIN_SLP_VAL_V << RTC_CNTL_MIN_SLP_VAL_S)
#define RTC_CNTL_MIN_SLP_VAL_V  0x000000FFU
#define RTC_CNTL_MIN_SLP_VAL_S  8

/** RTC_CNTL_TIMER6_REG register
 *  register description
 */
#define RTC_CNTL_TIMER6_REG (DR_REG_RTCCNTL_BASE + 0x30)
/** RTC_CNTL_DG_PERI_WAIT_TIMER : R/W; bitpos: [24:16]; default: 8;
 *  Need add description
 */
#define RTC_CNTL_DG_PERI_WAIT_TIMER    0x000001FFU
#define RTC_CNTL_DG_PERI_WAIT_TIMER_M  (RTC_CNTL_DG_PERI_WAIT_TIMER_V << RTC_CNTL_DG_PERI_WAIT_TIMER_S)
#define RTC_CNTL_DG_PERI_WAIT_TIMER_V  0x000001FFU
#define RTC_CNTL_DG_PERI_WAIT_TIMER_S  16
/** RTC_CNTL_DG_PERI_POWERUP_TIMER : R/W; bitpos: [31:25]; default: 5;
 *  Need add description
 */
#define RTC_CNTL_DG_PERI_POWERUP_TIMER    0x0000007FU
#define RTC_CNTL_DG_PERI_POWERUP_TIMER_M  (RTC_CNTL_DG_PERI_POWERUP_TIMER_V << RTC_CNTL_DG_PERI_POWERUP_TIMER_S)
#define RTC_CNTL_DG_PERI_POWERUP_TIMER_V  0x0000007FU
#define RTC_CNTL_DG_PERI_POWERUP_TIMER_S  25

/** RTC_CNTL_ANA_CONF_REG register
 *  register description
 */
#define RTC_CNTL_ANA_CONF_REG (DR_REG_RTCCNTL_BASE + 0x34)
/** RTC_CNTL_XPD_TRX_FORCE_PD : R/W; bitpos: [16]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XPD_TRX_FORCE_PD    (BIT(16))
#define RTC_CNTL_XPD_TRX_FORCE_PD_M  (RTC_CNTL_XPD_TRX_FORCE_PD_V << RTC_CNTL_XPD_TRX_FORCE_PD_S)
#define RTC_CNTL_XPD_TRX_FORCE_PD_V  0x00000001U
#define RTC_CNTL_XPD_TRX_FORCE_PD_S  16
/** RTC_CNTL_XPD_TRX_FORCE_PU : R/W; bitpos: [17]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_XPD_TRX_FORCE_PU    (BIT(17))
#define RTC_CNTL_XPD_TRX_FORCE_PU_M  (RTC_CNTL_XPD_TRX_FORCE_PU_V << RTC_CNTL_XPD_TRX_FORCE_PU_S)
#define RTC_CNTL_XPD_TRX_FORCE_PU_V  0x00000001U
#define RTC_CNTL_XPD_TRX_FORCE_PU_S  17
/** RTC_CNTL_I2C_RESET_POR_FORCE_PD : R/W; bitpos: [18]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_I2C_RESET_POR_FORCE_PD    (BIT(18))
#define RTC_CNTL_I2C_RESET_POR_FORCE_PD_M  (RTC_CNTL_I2C_RESET_POR_FORCE_PD_V << RTC_CNTL_I2C_RESET_POR_FORCE_PD_S)
#define RTC_CNTL_I2C_RESET_POR_FORCE_PD_V  0x00000001U
#define RTC_CNTL_I2C_RESET_POR_FORCE_PD_S  18
/** RTC_CNTL_I2C_RESET_POR_FORCE_PU : R/W; bitpos: [19]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_I2C_RESET_POR_FORCE_PU    (BIT(19))
#define RTC_CNTL_I2C_RESET_POR_FORCE_PU_M  (RTC_CNTL_I2C_RESET_POR_FORCE_PU_V << RTC_CNTL_I2C_RESET_POR_FORCE_PU_S)
#define RTC_CNTL_I2C_RESET_POR_FORCE_PU_V  0x00000001U
#define RTC_CNTL_I2C_RESET_POR_FORCE_PU_S  19
/** RTC_CNTL_GLITCH_RST_EN : R/W; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GLITCH_RST_EN    (BIT(20))
#define RTC_CNTL_GLITCH_RST_EN_M  (RTC_CNTL_GLITCH_RST_EN_V << RTC_CNTL_GLITCH_RST_EN_S)
#define RTC_CNTL_GLITCH_RST_EN_V  0x00000001U
#define RTC_CNTL_GLITCH_RST_EN_S  20
/** RTC_CNTL_PERI_I2C_PU : R/W; bitpos: [22]; default: 1;
 *  PLLA force power up
 */
#define RTC_CNTL_PERI_I2C_PU    (BIT(22))
#define RTC_CNTL_PERI_I2C_PU_M  (RTC_CNTL_PERI_I2C_PU_V << RTC_CNTL_PERI_I2C_PU_S)
#define RTC_CNTL_PERI_I2C_PU_V  0x00000001U
#define RTC_CNTL_PERI_I2C_PU_S  22

#define RTC_CNTL_SAR_I2C_PU     RTC_CNTL_PERI_I2C_PU
#define RTC_CNTL_SAR_I2C_PU_V   RTC_CNTL_PERI_I2C_PU_M
#define RTC_CNTL_SAR_I2C_PU_M   RTC_CNTL_PERI_I2C_PU_V
#define RTC_CNTL_SAR_I2C_PU_S   RTC_CNTL_PERI_I2C_PU_S
/** RTC_CNTL_PLLA_FORCE_PD : R/W; bitpos: [23]; default: 1;
 *  PLLA force power down
 */
#define RTC_CNTL_PLLA_FORCE_PD    (BIT(23))
#define RTC_CNTL_PLLA_FORCE_PD_M  (RTC_CNTL_PLLA_FORCE_PD_V << RTC_CNTL_PLLA_FORCE_PD_S)
#define RTC_CNTL_PLLA_FORCE_PD_V  0x00000001U
#define RTC_CNTL_PLLA_FORCE_PD_S  23
/** RTC_CNTL_PLLA_FORCE_PU : R/W; bitpos: [24]; default: 0;
 *  PLLA force power up
 */
#define RTC_CNTL_PLLA_FORCE_PU    (BIT(24))
#define RTC_CNTL_PLLA_FORCE_PU_M  (RTC_CNTL_PLLA_FORCE_PU_V << RTC_CNTL_PLLA_FORCE_PU_S)
#define RTC_CNTL_PLLA_FORCE_PU_V  0x00000001U
#define RTC_CNTL_PLLA_FORCE_PU_S  24
/** RTC_CNTL_BBPLL_CAL_SLP_START : R/W; bitpos: [25]; default: 0;
 *  start BBPLL calibration during sleep
 */
#define RTC_CNTL_BBPLL_CAL_SLP_START    (BIT(25))
#define RTC_CNTL_BBPLL_CAL_SLP_START_M  (RTC_CNTL_BBPLL_CAL_SLP_START_V << RTC_CNTL_BBPLL_CAL_SLP_START_S)
#define RTC_CNTL_BBPLL_CAL_SLP_START_V  0x00000001U
#define RTC_CNTL_BBPLL_CAL_SLP_START_S  25
/** RTC_CNTL_PVTMON_PU : R/W; bitpos: [26]; default: 0;
 *  1: PVTMON power up , otherwise power down
 */
#define RTC_CNTL_PVTMON_PU    (BIT(26))
#define RTC_CNTL_PVTMON_PU_M  (RTC_CNTL_PVTMON_PU_V << RTC_CNTL_PVTMON_PU_S)
#define RTC_CNTL_PVTMON_PU_V  0x00000001U
#define RTC_CNTL_PVTMON_PU_S  26
/** RTC_CNTL_TXRF_I2C_PU : R/W; bitpos: [27]; default: 0;
 *  1: TXRF_I2C power up , otherwise power down
 */
#define RTC_CNTL_TXRF_I2C_PU    (BIT(27))
#define RTC_CNTL_TXRF_I2C_PU_M  (RTC_CNTL_TXRF_I2C_PU_V << RTC_CNTL_TXRF_I2C_PU_S)
#define RTC_CNTL_TXRF_I2C_PU_V  0x00000001U
#define RTC_CNTL_TXRF_I2C_PU_S  27
/** RTC_CNTL_RFRX_PBUS_PU : R/W; bitpos: [28]; default: 0;
 *  1: RFRX_PBUS power up , otherwise power down
 */
#define RTC_CNTL_RFRX_PBUS_PU    (BIT(28))
#define RTC_CNTL_RFRX_PBUS_PU_M  (RTC_CNTL_RFRX_PBUS_PU_V << RTC_CNTL_RFRX_PBUS_PU_S)
#define RTC_CNTL_RFRX_PBUS_PU_V  0x00000001U
#define RTC_CNTL_RFRX_PBUS_PU_S  28
/** RTC_CNTL_CKGEN_I2C_PU : R/W; bitpos: [30]; default: 0;
 *  1: CKGEN_I2C power up , otherwise power down
 */
#define RTC_CNTL_CKGEN_I2C_PU    (BIT(30))
#define RTC_CNTL_CKGEN_I2C_PU_M  (RTC_CNTL_CKGEN_I2C_PU_V << RTC_CNTL_CKGEN_I2C_PU_S)
#define RTC_CNTL_CKGEN_I2C_PU_V  0x00000001U
#define RTC_CNTL_CKGEN_I2C_PU_S  30
/** RTC_CNTL_PLL_I2C_PU : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_PLL_I2C_PU    (BIT(31))
#define RTC_CNTL_PLL_I2C_PU_M  (RTC_CNTL_PLL_I2C_PU_V << RTC_CNTL_PLL_I2C_PU_S)
#define RTC_CNTL_PLL_I2C_PU_V  0x00000001U
#define RTC_CNTL_PLL_I2C_PU_S  31

/** RTC_CNTL_RESET_STATE_REG register
 *  register description
 */
#define RTC_CNTL_RESET_STATE_REG (DR_REG_RTCCNTL_BASE + 0x38)
/** RTC_CNTL_RESET_CAUSE_PROCPU : RO; bitpos: [5:0]; default: 0;
 *  reset cause of PRO CPU
 */
#define RTC_CNTL_RESET_CAUSE_PROCPU    0x0000003FU
#define RTC_CNTL_RESET_CAUSE_PROCPU_M  (RTC_CNTL_RESET_CAUSE_PROCPU_V << RTC_CNTL_RESET_CAUSE_PROCPU_S)
#define RTC_CNTL_RESET_CAUSE_PROCPU_V  0x0000003FU
#define RTC_CNTL_RESET_CAUSE_PROCPU_S  0
/** RTC_CNTL_RESET_CAUSE_APPCPU : RO; bitpos: [11:6]; default: 0;
 *  reset cause of APP CPU
 */
#define RTC_CNTL_RESET_CAUSE_APPCPU    0x0000003FU
#define RTC_CNTL_RESET_CAUSE_APPCPU_M  (RTC_CNTL_RESET_CAUSE_APPCPU_V << RTC_CNTL_RESET_CAUSE_APPCPU_S)
#define RTC_CNTL_RESET_CAUSE_APPCPU_V  0x0000003FU
#define RTC_CNTL_RESET_CAUSE_APPCPU_S  6
/** RTC_CNTL_STAT_VECTOR_SEL_APPCPU : R/W; bitpos: [12]; default: 1;
 *  APP CPU state vector sel
 */
#define RTC_CNTL_STAT_VECTOR_SEL_APPCPU    (BIT(12))
#define RTC_CNTL_STAT_VECTOR_SEL_APPCPU_M  (RTC_CNTL_STAT_VECTOR_SEL_APPCPU_V << RTC_CNTL_STAT_VECTOR_SEL_APPCPU_S)
#define RTC_CNTL_STAT_VECTOR_SEL_APPCPU_V  0x00000001U
#define RTC_CNTL_STAT_VECTOR_SEL_APPCPU_S  12
/** RTC_CNTL_STAT_VECTOR_SEL_PROCPU : R/W; bitpos: [13]; default: 1;
 *  PRO CPU state vector sel
 */
#define RTC_CNTL_STAT_VECTOR_SEL_PROCPU    (BIT(13))
#define RTC_CNTL_STAT_VECTOR_SEL_PROCPU_M  (RTC_CNTL_STAT_VECTOR_SEL_PROCPU_V << RTC_CNTL_STAT_VECTOR_SEL_PROCPU_S)
#define RTC_CNTL_STAT_VECTOR_SEL_PROCPU_V  0x00000001U
#define RTC_CNTL_STAT_VECTOR_SEL_PROCPU_S  13
/** RTC_CNTL_ALL_RESET_FLAG_PROCPU : RO; bitpos: [14]; default: 0;
 *  PRO CPU reset_flag
 */
#define RTC_CNTL_ALL_RESET_FLAG_PROCPU    (BIT(14))
#define RTC_CNTL_ALL_RESET_FLAG_PROCPU_M  (RTC_CNTL_ALL_RESET_FLAG_PROCPU_V << RTC_CNTL_ALL_RESET_FLAG_PROCPU_S)
#define RTC_CNTL_ALL_RESET_FLAG_PROCPU_V  0x00000001U
#define RTC_CNTL_ALL_RESET_FLAG_PROCPU_S  14
/** RTC_CNTL_ALL_RESET_FLAG_APPCPU : RO; bitpos: [15]; default: 0;
 *  APP CPU reset flag
 */
#define RTC_CNTL_ALL_RESET_FLAG_APPCPU    (BIT(15))
#define RTC_CNTL_ALL_RESET_FLAG_APPCPU_M  (RTC_CNTL_ALL_RESET_FLAG_APPCPU_V << RTC_CNTL_ALL_RESET_FLAG_APPCPU_S)
#define RTC_CNTL_ALL_RESET_FLAG_APPCPU_V  0x00000001U
#define RTC_CNTL_ALL_RESET_FLAG_APPCPU_S  15
/** RTC_CNTL_ALL_RESET_FLAG_CLR_PROCPU : WO; bitpos: [16]; default: 0;
 *  clear PRO CPU reset_flag
 */
#define RTC_CNTL_ALL_RESET_FLAG_CLR_PROCPU    (BIT(16))
#define RTC_CNTL_ALL_RESET_FLAG_CLR_PROCPU_M  (RTC_CNTL_ALL_RESET_FLAG_CLR_PROCPU_V << RTC_CNTL_ALL_RESET_FLAG_CLR_PROCPU_S)
#define RTC_CNTL_ALL_RESET_FLAG_CLR_PROCPU_V  0x00000001U
#define RTC_CNTL_ALL_RESET_FLAG_CLR_PROCPU_S  16
/** RTC_CNTL_ALL_RESET_FLAG_CLR_APPCPU : WO; bitpos: [17]; default: 0;
 *  clear APP CPU reset flag
 */
#define RTC_CNTL_ALL_RESET_FLAG_CLR_APPCPU    (BIT(17))
#define RTC_CNTL_ALL_RESET_FLAG_CLR_APPCPU_M  (RTC_CNTL_ALL_RESET_FLAG_CLR_APPCPU_V << RTC_CNTL_ALL_RESET_FLAG_CLR_APPCPU_S)
#define RTC_CNTL_ALL_RESET_FLAG_CLR_APPCPU_V  0x00000001U
#define RTC_CNTL_ALL_RESET_FLAG_CLR_APPCPU_S  17
/** RTC_CNTL_OCD_HALT_ON_RESET_APPCPU : R/W; bitpos: [18]; default: 0;
 *  APPCPU OcdHaltOnReset
 */
#define RTC_CNTL_OCD_HALT_ON_RESET_APPCPU    (BIT(18))
#define RTC_CNTL_OCD_HALT_ON_RESET_APPCPU_M  (RTC_CNTL_OCD_HALT_ON_RESET_APPCPU_V << RTC_CNTL_OCD_HALT_ON_RESET_APPCPU_S)
#define RTC_CNTL_OCD_HALT_ON_RESET_APPCPU_V  0x00000001U
#define RTC_CNTL_OCD_HALT_ON_RESET_APPCPU_S  18
/** RTC_CNTL_OCD_HALT_ON_RESET_PROCPU : R/W; bitpos: [19]; default: 0;
 *  PROCPU OcdHaltOnReset
 */
#define RTC_CNTL_OCD_HALT_ON_RESET_PROCPU    (BIT(19))
#define RTC_CNTL_OCD_HALT_ON_RESET_PROCPU_M  (RTC_CNTL_OCD_HALT_ON_RESET_PROCPU_V << RTC_CNTL_OCD_HALT_ON_RESET_PROCPU_S)
#define RTC_CNTL_OCD_HALT_ON_RESET_PROCPU_V  0x00000001U
#define RTC_CNTL_OCD_HALT_ON_RESET_PROCPU_S  19
/** RTC_CNTL_JTAG_RESET_FLAG_PROCPU : RO; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_JTAG_RESET_FLAG_PROCPU    (BIT(20))
#define RTC_CNTL_JTAG_RESET_FLAG_PROCPU_M  (RTC_CNTL_JTAG_RESET_FLAG_PROCPU_V << RTC_CNTL_JTAG_RESET_FLAG_PROCPU_S)
#define RTC_CNTL_JTAG_RESET_FLAG_PROCPU_V  0x00000001U
#define RTC_CNTL_JTAG_RESET_FLAG_PROCPU_S  20
/** RTC_CNTL_JTAG_RESET_FLAG_APPCPU : RO; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_JTAG_RESET_FLAG_APPCPU    (BIT(21))
#define RTC_CNTL_JTAG_RESET_FLAG_APPCPU_M  (RTC_CNTL_JTAG_RESET_FLAG_APPCPU_V << RTC_CNTL_JTAG_RESET_FLAG_APPCPU_S)
#define RTC_CNTL_JTAG_RESET_FLAG_APPCPU_V  0x00000001U
#define RTC_CNTL_JTAG_RESET_FLAG_APPCPU_S  21
/** RTC_CNTL_JTAG_RESET_FLAG_CLR_PROCPU : WO; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_JTAG_RESET_FLAG_CLR_PROCPU    (BIT(22))
#define RTC_CNTL_JTAG_RESET_FLAG_CLR_PROCPU_M  (RTC_CNTL_JTAG_RESET_FLAG_CLR_PROCPU_V << RTC_CNTL_JTAG_RESET_FLAG_CLR_PROCPU_S)
#define RTC_CNTL_JTAG_RESET_FLAG_CLR_PROCPU_V  0x00000001U
#define RTC_CNTL_JTAG_RESET_FLAG_CLR_PROCPU_S  22
/** RTC_CNTL_JTAG_RESET_FLAG_CLR_APPCPU : WO; bitpos: [23]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_JTAG_RESET_FLAG_CLR_APPCPU    (BIT(23))
#define RTC_CNTL_JTAG_RESET_FLAG_CLR_APPCPU_M  (RTC_CNTL_JTAG_RESET_FLAG_CLR_APPCPU_V << RTC_CNTL_JTAG_RESET_FLAG_CLR_APPCPU_S)
#define RTC_CNTL_JTAG_RESET_FLAG_CLR_APPCPU_V  0x00000001U
#define RTC_CNTL_JTAG_RESET_FLAG_CLR_APPCPU_S  23
/** RTC_CNTL_DRESET_MASK_APPCPU : R/W; bitpos: [24]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DRESET_MASK_APPCPU    (BIT(24))
#define RTC_CNTL_DRESET_MASK_APPCPU_M  (RTC_CNTL_DRESET_MASK_APPCPU_V << RTC_CNTL_DRESET_MASK_APPCPU_S)
#define RTC_CNTL_DRESET_MASK_APPCPU_V  0x00000001U
#define RTC_CNTL_DRESET_MASK_APPCPU_S  24
/** RTC_CNTL_DRESET_MASK_PROCPU : R/W; bitpos: [25]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DRESET_MASK_PROCPU    (BIT(25))
#define RTC_CNTL_DRESET_MASK_PROCPU_M  (RTC_CNTL_DRESET_MASK_PROCPU_V << RTC_CNTL_DRESET_MASK_PROCPU_S)
#define RTC_CNTL_DRESET_MASK_PROCPU_V  0x00000001U
#define RTC_CNTL_DRESET_MASK_PROCPU_S  25

/** RTC_CNTL_WAKEUP_STATE_REG register
 *  register description
 */
#define RTC_CNTL_WAKEUP_STATE_REG (DR_REG_RTCCNTL_BASE + 0x3c)
/** RTC_CNTL_WAKEUP_ENA : R/W; bitpos: [31:13]; default: 12;
 *  wakeup enable bitmap
 */
#define RTC_CNTL_WAKEUP_ENA    0x0007FFFFU
#define RTC_CNTL_WAKEUP_ENA_M  (RTC_CNTL_WAKEUP_ENA_V << RTC_CNTL_WAKEUP_ENA_S)
#define RTC_CNTL_WAKEUP_ENA_V  0x0007FFFFU
#define RTC_CNTL_WAKEUP_ENA_S  13

/** RTC_CNTL_INT_ENA_REG register
 *  register description
 */
#define RTC_CNTL_INT_ENA_REG (DR_REG_RTCCNTL_BASE + 0x40)
/** RTC_CNTL_SLP_WAKEUP_INT_ENA : R/W; bitpos: [0]; default: 0;
 *  enable sleep wakeup interrupt
 */
#define RTC_CNTL_SLP_WAKEUP_INT_ENA    (BIT(0))
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_M  (RTC_CNTL_SLP_WAKEUP_INT_ENA_V << RTC_CNTL_SLP_WAKEUP_INT_ENA_S)
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_V  0x00000001U
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_S  0
/** RTC_CNTL_SLP_REJECT_INT_ENA : R/W; bitpos: [1]; default: 0;
 *  enable sleep reject interrupt
 */
#define RTC_CNTL_SLP_REJECT_INT_ENA    (BIT(1))
#define RTC_CNTL_SLP_REJECT_INT_ENA_M  (RTC_CNTL_SLP_REJECT_INT_ENA_V << RTC_CNTL_SLP_REJECT_INT_ENA_S)
#define RTC_CNTL_SLP_REJECT_INT_ENA_V  0x00000001U
#define RTC_CNTL_SLP_REJECT_INT_ENA_S  1
/** RTC_CNTL_WDT_INT_ENA : R/W; bitpos: [3]; default: 0;
 *  enable RTC WDT interrupt
 */
#define RTC_CNTL_WDT_INT_ENA    (BIT(3))
#define RTC_CNTL_WDT_INT_ENA_M  (RTC_CNTL_WDT_INT_ENA_V << RTC_CNTL_WDT_INT_ENA_S)
#define RTC_CNTL_WDT_INT_ENA_V  0x00000001U
#define RTC_CNTL_WDT_INT_ENA_S  3
/** RTC_CNTL_BROWN_OUT_INT_ENA : R/W; bitpos: [9]; default: 0;
 *  enable brown out interrupt
 */
#define RTC_CNTL_BROWN_OUT_INT_ENA    (BIT(9))
#define RTC_CNTL_BROWN_OUT_INT_ENA_M  (RTC_CNTL_BROWN_OUT_INT_ENA_V << RTC_CNTL_BROWN_OUT_INT_ENA_S)
#define RTC_CNTL_BROWN_OUT_INT_ENA_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_INT_ENA_S  9
/** RTC_CNTL_MAIN_TIMER_INT_ENA : R/W; bitpos: [10]; default: 0;
 *  enable RTC main timer interrupt
 */
#define RTC_CNTL_MAIN_TIMER_INT_ENA    (BIT(10))
#define RTC_CNTL_MAIN_TIMER_INT_ENA_M  (RTC_CNTL_MAIN_TIMER_INT_ENA_V << RTC_CNTL_MAIN_TIMER_INT_ENA_S)
#define RTC_CNTL_MAIN_TIMER_INT_ENA_V  0x00000001U
#define RTC_CNTL_MAIN_TIMER_INT_ENA_S  10
/** RTC_CNTL_SWD_INT_ENA : R/W; bitpos: [15]; default: 0;
 *  enable super watch dog interrupt
 */
#define RTC_CNTL_SWD_INT_ENA    (BIT(15))
#define RTC_CNTL_SWD_INT_ENA_M  (RTC_CNTL_SWD_INT_ENA_V << RTC_CNTL_SWD_INT_ENA_S)
#define RTC_CNTL_SWD_INT_ENA_V  0x00000001U
#define RTC_CNTL_SWD_INT_ENA_S  15
/** RTC_CNTL_XTAL32K_DEAD_INT_ENA : R/W; bitpos: [16]; default: 0;
 *  enable xtal32k_dead  interrupt
 */
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA    (BIT(16))
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_M  (RTC_CNTL_XTAL32K_DEAD_INT_ENA_V << RTC_CNTL_XTAL32K_DEAD_INT_ENA_S)
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_V  0x00000001U
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_S  16
/** RTC_CNTL_GLITCH_DET_INT_ENA : R/W; bitpos: [19]; default: 0;
 *  enbale gitch det interrupt
 */
#define RTC_CNTL_GLITCH_DET_INT_ENA    (BIT(19))
#define RTC_CNTL_GLITCH_DET_INT_ENA_M  (RTC_CNTL_GLITCH_DET_INT_ENA_V << RTC_CNTL_GLITCH_DET_INT_ENA_S)
#define RTC_CNTL_GLITCH_DET_INT_ENA_V  0x00000001U
#define RTC_CNTL_GLITCH_DET_INT_ENA_S  19
/** RTC_CNTL_BBPLL_CAL_INT_ENA : R/W; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BBPLL_CAL_INT_ENA    (BIT(20))
#define RTC_CNTL_BBPLL_CAL_INT_ENA_M  (RTC_CNTL_BBPLL_CAL_INT_ENA_V << RTC_CNTL_BBPLL_CAL_INT_ENA_S)
#define RTC_CNTL_BBPLL_CAL_INT_ENA_V  0x00000001U
#define RTC_CNTL_BBPLL_CAL_INT_ENA_S  20
/** RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA : RW; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA    (BIT(21))
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_M  (RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_V << RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_S)
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_V  0x00000001U
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_S  21
/** RTC_CNTL_VSET_DCDC_DONE_INT_ENA : R/W; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA    (BIT(22))
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_M  (RTC_CNTL_VSET_DCDC_DONE_INT_ENA_V << RTC_CNTL_VSET_DCDC_DONE_INT_ENA_S)
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_S  22

/** RTC_CNTL_INT_RAW_REG register
 *  register description
 */
#define RTC_CNTL_INT_RAW_REG (DR_REG_RTCCNTL_BASE + 0x44)
/** RTC_CNTL_SLP_WAKEUP_INT_RAW : RO; bitpos: [0]; default: 0;
 *  sleep wakeup interrupt raw
 */
#define RTC_CNTL_SLP_WAKEUP_INT_RAW    (BIT(0))
#define RTC_CNTL_SLP_WAKEUP_INT_RAW_M  (RTC_CNTL_SLP_WAKEUP_INT_RAW_V << RTC_CNTL_SLP_WAKEUP_INT_RAW_S)
#define RTC_CNTL_SLP_WAKEUP_INT_RAW_V  0x00000001U
#define RTC_CNTL_SLP_WAKEUP_INT_RAW_S  0
/** RTC_CNTL_SLP_REJECT_INT_RAW : RO; bitpos: [1]; default: 0;
 *  sleep reject interrupt raw
 */
#define RTC_CNTL_SLP_REJECT_INT_RAW    (BIT(1))
#define RTC_CNTL_SLP_REJECT_INT_RAW_M  (RTC_CNTL_SLP_REJECT_INT_RAW_V << RTC_CNTL_SLP_REJECT_INT_RAW_S)
#define RTC_CNTL_SLP_REJECT_INT_RAW_V  0x00000001U
#define RTC_CNTL_SLP_REJECT_INT_RAW_S  1
/** RTC_CNTL_WDT_INT_RAW : RO; bitpos: [3]; default: 0;
 *  RTC WDT interrupt raw
 */
#define RTC_CNTL_WDT_INT_RAW    (BIT(3))
#define RTC_CNTL_WDT_INT_RAW_M  (RTC_CNTL_WDT_INT_RAW_V << RTC_CNTL_WDT_INT_RAW_S)
#define RTC_CNTL_WDT_INT_RAW_V  0x00000001U
#define RTC_CNTL_WDT_INT_RAW_S  3
/** RTC_CNTL_BROWN_OUT_INT_RAW : RO; bitpos: [9]; default: 0;
 *  brown out interrupt raw
 */
#define RTC_CNTL_BROWN_OUT_INT_RAW    (BIT(9))
#define RTC_CNTL_BROWN_OUT_INT_RAW_M  (RTC_CNTL_BROWN_OUT_INT_RAW_V << RTC_CNTL_BROWN_OUT_INT_RAW_S)
#define RTC_CNTL_BROWN_OUT_INT_RAW_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_INT_RAW_S  9
/** RTC_CNTL_MAIN_TIMER_INT_RAW : RO; bitpos: [10]; default: 0;
 *  RTC main timer interrupt raw
 */
#define RTC_CNTL_MAIN_TIMER_INT_RAW    (BIT(10))
#define RTC_CNTL_MAIN_TIMER_INT_RAW_M  (RTC_CNTL_MAIN_TIMER_INT_RAW_V << RTC_CNTL_MAIN_TIMER_INT_RAW_S)
#define RTC_CNTL_MAIN_TIMER_INT_RAW_V  0x00000001U
#define RTC_CNTL_MAIN_TIMER_INT_RAW_S  10
/** RTC_CNTL_SWD_INT_RAW : RO; bitpos: [15]; default: 0;
 *  super watch dog interrupt raw
 */
#define RTC_CNTL_SWD_INT_RAW    (BIT(15))
#define RTC_CNTL_SWD_INT_RAW_M  (RTC_CNTL_SWD_INT_RAW_V << RTC_CNTL_SWD_INT_RAW_S)
#define RTC_CNTL_SWD_INT_RAW_V  0x00000001U
#define RTC_CNTL_SWD_INT_RAW_S  15
/** RTC_CNTL_XTAL32K_DEAD_INT_RAW : RO; bitpos: [16]; default: 0;
 *  xtal32k dead detection interrupt raw
 */
#define RTC_CNTL_XTAL32K_DEAD_INT_RAW    (BIT(16))
#define RTC_CNTL_XTAL32K_DEAD_INT_RAW_M  (RTC_CNTL_XTAL32K_DEAD_INT_RAW_V << RTC_CNTL_XTAL32K_DEAD_INT_RAW_S)
#define RTC_CNTL_XTAL32K_DEAD_INT_RAW_V  0x00000001U
#define RTC_CNTL_XTAL32K_DEAD_INT_RAW_S  16
/** RTC_CNTL_GLITCH_DET_INT_RAW : RO; bitpos: [19]; default: 0;
 *  glitch_det_interrupt_raw
 */
#define RTC_CNTL_GLITCH_DET_INT_RAW    (BIT(19))
#define RTC_CNTL_GLITCH_DET_INT_RAW_M  (RTC_CNTL_GLITCH_DET_INT_RAW_V << RTC_CNTL_GLITCH_DET_INT_RAW_S)
#define RTC_CNTL_GLITCH_DET_INT_RAW_V  0x00000001U
#define RTC_CNTL_GLITCH_DET_INT_RAW_S  19
/** RTC_CNTL_BBPLL_CAL_INT_RAW : RO; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BBPLL_CAL_INT_RAW    (BIT(20))
#define RTC_CNTL_BBPLL_CAL_INT_RAW_M  (RTC_CNTL_BBPLL_CAL_INT_RAW_V << RTC_CNTL_BBPLL_CAL_INT_RAW_S)
#define RTC_CNTL_BBPLL_CAL_INT_RAW_V  0x00000001U
#define RTC_CNTL_BBPLL_CAL_INT_RAW_S  20
/** RTC_CNTL_BLE_COMPARE_WAKE_INT_RAW : RO; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_RAW    (BIT(21))
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_RAW_M  (RTC_CNTL_BLE_COMPARE_WAKE_INT_RAW_V << RTC_CNTL_BLE_COMPARE_WAKE_INT_RAW_S)
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_RAW_V  0x00000001U
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_RAW_S  21
/** RTC_CNTL_VSET_DCDC_DONE_INT_RAW : RO; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_DONE_INT_RAW    (BIT(22))
#define RTC_CNTL_VSET_DCDC_DONE_INT_RAW_M  (RTC_CNTL_VSET_DCDC_DONE_INT_RAW_V << RTC_CNTL_VSET_DCDC_DONE_INT_RAW_S)
#define RTC_CNTL_VSET_DCDC_DONE_INT_RAW_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_DONE_INT_RAW_S  22

/** RTC_CNTL_INT_ST_REG register
 *  register description
 */
#define RTC_CNTL_INT_ST_REG (DR_REG_RTCCNTL_BASE + 0x48)
/** RTC_CNTL_SLP_WAKEUP_INT_ST : RO; bitpos: [0]; default: 0;
 *  sleep wakeup interrupt state
 */
#define RTC_CNTL_SLP_WAKEUP_INT_ST    (BIT(0))
#define RTC_CNTL_SLP_WAKEUP_INT_ST_M  (RTC_CNTL_SLP_WAKEUP_INT_ST_V << RTC_CNTL_SLP_WAKEUP_INT_ST_S)
#define RTC_CNTL_SLP_WAKEUP_INT_ST_V  0x00000001U
#define RTC_CNTL_SLP_WAKEUP_INT_ST_S  0
/** RTC_CNTL_SLP_REJECT_INT_ST : RO; bitpos: [1]; default: 0;
 *  sleep reject interrupt state
 */
#define RTC_CNTL_SLP_REJECT_INT_ST    (BIT(1))
#define RTC_CNTL_SLP_REJECT_INT_ST_M  (RTC_CNTL_SLP_REJECT_INT_ST_V << RTC_CNTL_SLP_REJECT_INT_ST_S)
#define RTC_CNTL_SLP_REJECT_INT_ST_V  0x00000001U
#define RTC_CNTL_SLP_REJECT_INT_ST_S  1
/** RTC_CNTL_WDT_INT_ST : RO; bitpos: [3]; default: 0;
 *  RTC WDT interrupt state
 */
#define RTC_CNTL_WDT_INT_ST    (BIT(3))
#define RTC_CNTL_WDT_INT_ST_M  (RTC_CNTL_WDT_INT_ST_V << RTC_CNTL_WDT_INT_ST_S)
#define RTC_CNTL_WDT_INT_ST_V  0x00000001U
#define RTC_CNTL_WDT_INT_ST_S  3
/** RTC_CNTL_BROWN_OUT_INT_ST : RO; bitpos: [9]; default: 0;
 *  brown out interrupt state
 */
#define RTC_CNTL_BROWN_OUT_INT_ST    (BIT(9))
#define RTC_CNTL_BROWN_OUT_INT_ST_M  (RTC_CNTL_BROWN_OUT_INT_ST_V << RTC_CNTL_BROWN_OUT_INT_ST_S)
#define RTC_CNTL_BROWN_OUT_INT_ST_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_INT_ST_S  9
/** RTC_CNTL_MAIN_TIMER_INT_ST : RO; bitpos: [10]; default: 0;
 *  RTC main timer interrupt state
 */
#define RTC_CNTL_MAIN_TIMER_INT_ST    (BIT(10))
#define RTC_CNTL_MAIN_TIMER_INT_ST_M  (RTC_CNTL_MAIN_TIMER_INT_ST_V << RTC_CNTL_MAIN_TIMER_INT_ST_S)
#define RTC_CNTL_MAIN_TIMER_INT_ST_V  0x00000001U
#define RTC_CNTL_MAIN_TIMER_INT_ST_S  10
/** RTC_CNTL_SWD_INT_ST : RO; bitpos: [15]; default: 0;
 *  super watch dog interrupt state
 */
#define RTC_CNTL_SWD_INT_ST    (BIT(15))
#define RTC_CNTL_SWD_INT_ST_M  (RTC_CNTL_SWD_INT_ST_V << RTC_CNTL_SWD_INT_ST_S)
#define RTC_CNTL_SWD_INT_ST_V  0x00000001U
#define RTC_CNTL_SWD_INT_ST_S  15
/** RTC_CNTL_XTAL32K_DEAD_INT_ST : RO; bitpos: [16]; default: 0;
 *  xtal32k dead detection interrupt state
 */
#define RTC_CNTL_XTAL32K_DEAD_INT_ST    (BIT(16))
#define RTC_CNTL_XTAL32K_DEAD_INT_ST_M  (RTC_CNTL_XTAL32K_DEAD_INT_ST_V << RTC_CNTL_XTAL32K_DEAD_INT_ST_S)
#define RTC_CNTL_XTAL32K_DEAD_INT_ST_V  0x00000001U
#define RTC_CNTL_XTAL32K_DEAD_INT_ST_S  16
/** RTC_CNTL_GLITCH_DET_INT_ST : RO; bitpos: [19]; default: 0;
 *  glitch_det_interrupt state
 */
#define RTC_CNTL_GLITCH_DET_INT_ST    (BIT(19))
#define RTC_CNTL_GLITCH_DET_INT_ST_M  (RTC_CNTL_GLITCH_DET_INT_ST_V << RTC_CNTL_GLITCH_DET_INT_ST_S)
#define RTC_CNTL_GLITCH_DET_INT_ST_V  0x00000001U
#define RTC_CNTL_GLITCH_DET_INT_ST_S  19
/** RTC_CNTL_BBPLL_CAL_INT_ST : RO; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BBPLL_CAL_INT_ST    (BIT(20))
#define RTC_CNTL_BBPLL_CAL_INT_ST_M  (RTC_CNTL_BBPLL_CAL_INT_ST_V << RTC_CNTL_BBPLL_CAL_INT_ST_S)
#define RTC_CNTL_BBPLL_CAL_INT_ST_V  0x00000001U
#define RTC_CNTL_BBPLL_CAL_INT_ST_S  20
/** RTC_CNTL_BLE_COMPARE_WAKE_INT_ST : RO; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ST    (BIT(21))
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ST_M  (RTC_CNTL_BLE_COMPARE_WAKE_INT_ST_V << RTC_CNTL_BLE_COMPARE_WAKE_INT_ST_S)
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ST_V  0x00000001U
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ST_S  21
/** RTC_CNTL_VSET_DCDC_DONE_INT_ST : RO; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_DONE_INT_ST    (BIT(22))
#define RTC_CNTL_VSET_DCDC_DONE_INT_ST_M  (RTC_CNTL_VSET_DCDC_DONE_INT_ST_V << RTC_CNTL_VSET_DCDC_DONE_INT_ST_S)
#define RTC_CNTL_VSET_DCDC_DONE_INT_ST_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_DONE_INT_ST_S  22

/** RTC_CNTL_INT_CLR_REG register
 *  register description
 */
#define RTC_CNTL_INT_CLR_REG (DR_REG_RTCCNTL_BASE + 0x4c)
/** RTC_CNTL_SLP_WAKEUP_INT_CLR : WO; bitpos: [0]; default: 0;
 *  Clear sleep wakeup interrupt state
 */
#define RTC_CNTL_SLP_WAKEUP_INT_CLR    (BIT(0))
#define RTC_CNTL_SLP_WAKEUP_INT_CLR_M  (RTC_CNTL_SLP_WAKEUP_INT_CLR_V << RTC_CNTL_SLP_WAKEUP_INT_CLR_S)
#define RTC_CNTL_SLP_WAKEUP_INT_CLR_V  0x00000001U
#define RTC_CNTL_SLP_WAKEUP_INT_CLR_S  0
/** RTC_CNTL_SLP_REJECT_INT_CLR : WO; bitpos: [1]; default: 0;
 *  Clear sleep reject interrupt state
 */
#define RTC_CNTL_SLP_REJECT_INT_CLR    (BIT(1))
#define RTC_CNTL_SLP_REJECT_INT_CLR_M  (RTC_CNTL_SLP_REJECT_INT_CLR_V << RTC_CNTL_SLP_REJECT_INT_CLR_S)
#define RTC_CNTL_SLP_REJECT_INT_CLR_V  0x00000001U
#define RTC_CNTL_SLP_REJECT_INT_CLR_S  1
/** RTC_CNTL_WDT_INT_CLR : WO; bitpos: [3]; default: 0;
 *  Clear RTC WDT interrupt state
 */
#define RTC_CNTL_WDT_INT_CLR    (BIT(3))
#define RTC_CNTL_WDT_INT_CLR_M  (RTC_CNTL_WDT_INT_CLR_V << RTC_CNTL_WDT_INT_CLR_S)
#define RTC_CNTL_WDT_INT_CLR_V  0x00000001U
#define RTC_CNTL_WDT_INT_CLR_S  3
/** RTC_CNTL_BROWN_OUT_INT_CLR : WO; bitpos: [9]; default: 0;
 *  Clear brown out interrupt state
 */
#define RTC_CNTL_BROWN_OUT_INT_CLR    (BIT(9))
#define RTC_CNTL_BROWN_OUT_INT_CLR_M  (RTC_CNTL_BROWN_OUT_INT_CLR_V << RTC_CNTL_BROWN_OUT_INT_CLR_S)
#define RTC_CNTL_BROWN_OUT_INT_CLR_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_INT_CLR_S  9
/** RTC_CNTL_MAIN_TIMER_INT_CLR : WO; bitpos: [10]; default: 0;
 *  Clear RTC main timer interrupt state
 */
#define RTC_CNTL_MAIN_TIMER_INT_CLR    (BIT(10))
#define RTC_CNTL_MAIN_TIMER_INT_CLR_M  (RTC_CNTL_MAIN_TIMER_INT_CLR_V << RTC_CNTL_MAIN_TIMER_INT_CLR_S)
#define RTC_CNTL_MAIN_TIMER_INT_CLR_V  0x00000001U
#define RTC_CNTL_MAIN_TIMER_INT_CLR_S  10
/** RTC_CNTL_SWD_INT_CLR : WO; bitpos: [15]; default: 0;
 *  Clear super watch dog interrupt state
 */
#define RTC_CNTL_SWD_INT_CLR    (BIT(15))
#define RTC_CNTL_SWD_INT_CLR_M  (RTC_CNTL_SWD_INT_CLR_V << RTC_CNTL_SWD_INT_CLR_S)
#define RTC_CNTL_SWD_INT_CLR_V  0x00000001U
#define RTC_CNTL_SWD_INT_CLR_S  15
/** RTC_CNTL_XTAL32K_DEAD_INT_CLR : WO; bitpos: [16]; default: 0;
 *  Clear RTC WDT interrupt state
 */
#define RTC_CNTL_XTAL32K_DEAD_INT_CLR    (BIT(16))
#define RTC_CNTL_XTAL32K_DEAD_INT_CLR_M  (RTC_CNTL_XTAL32K_DEAD_INT_CLR_V << RTC_CNTL_XTAL32K_DEAD_INT_CLR_S)
#define RTC_CNTL_XTAL32K_DEAD_INT_CLR_V  0x00000001U
#define RTC_CNTL_XTAL32K_DEAD_INT_CLR_S  16
/** RTC_CNTL_GLITCH_DET_INT_CLR : WO; bitpos: [19]; default: 0;
 *  Clear glitch det interrupt state
 */
#define RTC_CNTL_GLITCH_DET_INT_CLR    (BIT(19))
#define RTC_CNTL_GLITCH_DET_INT_CLR_M  (RTC_CNTL_GLITCH_DET_INT_CLR_V << RTC_CNTL_GLITCH_DET_INT_CLR_S)
#define RTC_CNTL_GLITCH_DET_INT_CLR_V  0x00000001U
#define RTC_CNTL_GLITCH_DET_INT_CLR_S  19
/** RTC_CNTL_BBPLL_CAL_INT_CLR : WO; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BBPLL_CAL_INT_CLR    (BIT(20))
#define RTC_CNTL_BBPLL_CAL_INT_CLR_M  (RTC_CNTL_BBPLL_CAL_INT_CLR_V << RTC_CNTL_BBPLL_CAL_INT_CLR_S)
#define RTC_CNTL_BBPLL_CAL_INT_CLR_V  0x00000001U
#define RTC_CNTL_BBPLL_CAL_INT_CLR_S  20
/** RTC_CNTL_BLE_COMPARE_WAKE_INT_CLR : WO; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_CLR    (BIT(21))
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_CLR_M  (RTC_CNTL_BLE_COMPARE_WAKE_INT_CLR_V << RTC_CNTL_BLE_COMPARE_WAKE_INT_CLR_S)
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_CLR_V  0x00000001U
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_CLR_S  21
/** RTC_CNTL_VSET_DCDC_DONE_INT_CLR : WO; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_DONE_INT_CLR    (BIT(22))
#define RTC_CNTL_VSET_DCDC_DONE_INT_CLR_M  (RTC_CNTL_VSET_DCDC_DONE_INT_CLR_V << RTC_CNTL_VSET_DCDC_DONE_INT_CLR_S)
#define RTC_CNTL_VSET_DCDC_DONE_INT_CLR_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_DONE_INT_CLR_S  22

/** RTC_CNTL_STORE0_REG register
 *  register description
 */
#define RTC_CNTL_STORE0_REG (DR_REG_RTCCNTL_BASE + 0x50)
/** RTC_CNTL_SCRATCH0 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCRATCH0    0xFFFFFFFFU
#define RTC_CNTL_SCRATCH0_M  (RTC_CNTL_SCRATCH0_V << RTC_CNTL_SCRATCH0_S)
#define RTC_CNTL_SCRATCH0_V  0xFFFFFFFFU
#define RTC_CNTL_SCRATCH0_S  0

/** RTC_CNTL_STORE1_REG register
 *  register description
 */
#define RTC_CNTL_STORE1_REG (DR_REG_RTCCNTL_BASE + 0x54)
/** RTC_CNTL_SCRATCH1 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCRATCH1    0xFFFFFFFFU
#define RTC_CNTL_SCRATCH1_M  (RTC_CNTL_SCRATCH1_V << RTC_CNTL_SCRATCH1_S)
#define RTC_CNTL_SCRATCH1_V  0xFFFFFFFFU
#define RTC_CNTL_SCRATCH1_S  0

/** RTC_CNTL_STORE2_REG register
 *  register description
 */
#define RTC_CNTL_STORE2_REG (DR_REG_RTCCNTL_BASE + 0x58)
/** RTC_CNTL_SCRATCH2 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCRATCH2    0xFFFFFFFFU
#define RTC_CNTL_SCRATCH2_M  (RTC_CNTL_SCRATCH2_V << RTC_CNTL_SCRATCH2_S)
#define RTC_CNTL_SCRATCH2_V  0xFFFFFFFFU
#define RTC_CNTL_SCRATCH2_S  0

/** RTC_CNTL_STORE3_REG register
 *  register description
 */
#define RTC_CNTL_STORE3_REG (DR_REG_RTCCNTL_BASE + 0x5c)
/** RTC_CNTL_SCRATCH3 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCRATCH3    0xFFFFFFFFU
#define RTC_CNTL_SCRATCH3_M  (RTC_CNTL_SCRATCH3_V << RTC_CNTL_SCRATCH3_S)
#define RTC_CNTL_SCRATCH3_V  0xFFFFFFFFU
#define RTC_CNTL_SCRATCH3_S  0

/** RTC_CNTL_EXT_XTL_CONF_REG register
 *  register description
 */
#define RTC_CNTL_EXT_XTL_CONF_REG (DR_REG_RTCCNTL_BASE + 0x60)
/** RTC_CNTL_XTAL32K_WDT_EN : R/W; bitpos: [0]; default: 0;
 *  xtal 32k watch dog enable
 */
#define RTC_CNTL_XTAL32K_WDT_EN    (BIT(0))
#define RTC_CNTL_XTAL32K_WDT_EN_M  (RTC_CNTL_XTAL32K_WDT_EN_V << RTC_CNTL_XTAL32K_WDT_EN_S)
#define RTC_CNTL_XTAL32K_WDT_EN_V  0x00000001U
#define RTC_CNTL_XTAL32K_WDT_EN_S  0
/** RTC_CNTL_XTAL32K_WDT_CLK_FO : R/W; bitpos: [1]; default: 0;
 *  xtal 32k watch dog clock force on
 */
#define RTC_CNTL_XTAL32K_WDT_CLK_FO    (BIT(1))
#define RTC_CNTL_XTAL32K_WDT_CLK_FO_M  (RTC_CNTL_XTAL32K_WDT_CLK_FO_V << RTC_CNTL_XTAL32K_WDT_CLK_FO_S)
#define RTC_CNTL_XTAL32K_WDT_CLK_FO_V  0x00000001U
#define RTC_CNTL_XTAL32K_WDT_CLK_FO_S  1
/** RTC_CNTL_XTAL32K_WDT_RESET : R/W; bitpos: [2]; default: 0;
 *  xtal 32k watch dog sw reset
 */
#define RTC_CNTL_XTAL32K_WDT_RESET    (BIT(2))
#define RTC_CNTL_XTAL32K_WDT_RESET_M  (RTC_CNTL_XTAL32K_WDT_RESET_V << RTC_CNTL_XTAL32K_WDT_RESET_S)
#define RTC_CNTL_XTAL32K_WDT_RESET_V  0x00000001U
#define RTC_CNTL_XTAL32K_WDT_RESET_S  2
/** RTC_CNTL_XTAL32K_EXT_CLK_FO : R/W; bitpos: [3]; default: 0;
 *  xtal 32k external xtal clock force on
 */
#define RTC_CNTL_XTAL32K_EXT_CLK_FO    (BIT(3))
#define RTC_CNTL_XTAL32K_EXT_CLK_FO_M  (RTC_CNTL_XTAL32K_EXT_CLK_FO_V << RTC_CNTL_XTAL32K_EXT_CLK_FO_S)
#define RTC_CNTL_XTAL32K_EXT_CLK_FO_V  0x00000001U
#define RTC_CNTL_XTAL32K_EXT_CLK_FO_S  3
/** RTC_CNTL_XTAL32K_AUTO_BACKUP : R/W; bitpos: [4]; default: 0;
 *  xtal 32k switch to back up clock when xtal is dead
 */
#define RTC_CNTL_XTAL32K_AUTO_BACKUP    (BIT(4))
#define RTC_CNTL_XTAL32K_AUTO_BACKUP_M  (RTC_CNTL_XTAL32K_AUTO_BACKUP_V << RTC_CNTL_XTAL32K_AUTO_BACKUP_S)
#define RTC_CNTL_XTAL32K_AUTO_BACKUP_V  0x00000001U
#define RTC_CNTL_XTAL32K_AUTO_BACKUP_S  4
/** RTC_CNTL_XTAL32K_AUTO_RESTART : R/W; bitpos: [5]; default: 0;
 *  xtal 32k restart xtal when xtal is dead
 */
#define RTC_CNTL_XTAL32K_AUTO_RESTART    (BIT(5))
#define RTC_CNTL_XTAL32K_AUTO_RESTART_M  (RTC_CNTL_XTAL32K_AUTO_RESTART_V << RTC_CNTL_XTAL32K_AUTO_RESTART_S)
#define RTC_CNTL_XTAL32K_AUTO_RESTART_V  0x00000001U
#define RTC_CNTL_XTAL32K_AUTO_RESTART_S  5
/** RTC_CNTL_XTAL32K_AUTO_RETURN : R/W; bitpos: [6]; default: 0;
 *  xtal 32k switch back xtal when xtal is restarted
 */
#define RTC_CNTL_XTAL32K_AUTO_RETURN    (BIT(6))
#define RTC_CNTL_XTAL32K_AUTO_RETURN_M  (RTC_CNTL_XTAL32K_AUTO_RETURN_V << RTC_CNTL_XTAL32K_AUTO_RETURN_S)
#define RTC_CNTL_XTAL32K_AUTO_RETURN_V  0x00000001U
#define RTC_CNTL_XTAL32K_AUTO_RETURN_S  6
/** RTC_CNTL_XTAL32K_XPD_FORCE : R/W; bitpos: [7]; default: 1;
 *  Xtal 32k xpd control by sw or fsm
 */
#define RTC_CNTL_XTAL32K_XPD_FORCE    (BIT(7))
#define RTC_CNTL_XTAL32K_XPD_FORCE_M  (RTC_CNTL_XTAL32K_XPD_FORCE_V << RTC_CNTL_XTAL32K_XPD_FORCE_S)
#define RTC_CNTL_XTAL32K_XPD_FORCE_V  0x00000001U
#define RTC_CNTL_XTAL32K_XPD_FORCE_S  7
/** RTC_CNTL_ENCKINIT_XTAL_32K : R/W; bitpos: [8]; default: 0;
 *  apply an internal clock to help xtal 32k to start
 */
#define RTC_CNTL_ENCKINIT_XTAL_32K    (BIT(8))
#define RTC_CNTL_ENCKINIT_XTAL_32K_M  (RTC_CNTL_ENCKINIT_XTAL_32K_V << RTC_CNTL_ENCKINIT_XTAL_32K_S)
#define RTC_CNTL_ENCKINIT_XTAL_32K_V  0x00000001U
#define RTC_CNTL_ENCKINIT_XTAL_32K_S  8
/** RTC_CNTL_DBUF_XTAL_32K : R/W; bitpos: [9]; default: 0;
 *  0: single-end buffer 1: differential buffer
 */
#define RTC_CNTL_DBUF_XTAL_32K    (BIT(9))
#define RTC_CNTL_DBUF_XTAL_32K_M  (RTC_CNTL_DBUF_XTAL_32K_V << RTC_CNTL_DBUF_XTAL_32K_S)
#define RTC_CNTL_DBUF_XTAL_32K_V  0x00000001U
#define RTC_CNTL_DBUF_XTAL_32K_S  9
/** RTC_CNTL_DGM_XTAL_32K : R/W; bitpos: [12:10]; default: 3;
 *  xtal_32k gm control
 */
#define RTC_CNTL_DGM_XTAL_32K    0x00000007U
#define RTC_CNTL_DGM_XTAL_32K_M  (RTC_CNTL_DGM_XTAL_32K_V << RTC_CNTL_DGM_XTAL_32K_S)
#define RTC_CNTL_DGM_XTAL_32K_V  0x00000007U
#define RTC_CNTL_DGM_XTAL_32K_S  10
/** RTC_CNTL_DRES_XTAL_32K : R/W; bitpos: [15:13]; default: 3;
 *  DRES_XTAL_32K
 */
#define RTC_CNTL_DRES_XTAL_32K    0x00000007U
#define RTC_CNTL_DRES_XTAL_32K_M  (RTC_CNTL_DRES_XTAL_32K_V << RTC_CNTL_DRES_XTAL_32K_S)
#define RTC_CNTL_DRES_XTAL_32K_V  0x00000007U
#define RTC_CNTL_DRES_XTAL_32K_S  13
/** RTC_CNTL_XPD_XTAL_32K : R/W; bitpos: [16]; default: 0;
 *  XPD_XTAL_32K
 */
#define RTC_CNTL_XPD_XTAL_32K    (BIT(16))
#define RTC_CNTL_XPD_XTAL_32K_M  (RTC_CNTL_XPD_XTAL_32K_V << RTC_CNTL_XPD_XTAL_32K_S)
#define RTC_CNTL_XPD_XTAL_32K_V  0x00000001U
#define RTC_CNTL_XPD_XTAL_32K_S  16
/** RTC_CNTL_DAC_XTAL_32K : R/W; bitpos: [19:17]; default: 3;
 *  DAC_XTAL_32K
 */
#define RTC_CNTL_DAC_XTAL_32K    0x00000007U
#define RTC_CNTL_DAC_XTAL_32K_M  (RTC_CNTL_DAC_XTAL_32K_V << RTC_CNTL_DAC_XTAL_32K_S)
#define RTC_CNTL_DAC_XTAL_32K_V  0x00000007U
#define RTC_CNTL_DAC_XTAL_32K_S  17
/** RTC_CNTL_WDT_STATE : RO; bitpos: [22:20]; default: 0;
 *  state of 32k_wdt
 */
#define RTC_CNTL_WDT_STATE    0x00000007U
#define RTC_CNTL_WDT_STATE_M  (RTC_CNTL_WDT_STATE_V << RTC_CNTL_WDT_STATE_S)
#define RTC_CNTL_WDT_STATE_V  0x00000007U
#define RTC_CNTL_WDT_STATE_S  20
/** RTC_CNTL_XTAL32K_GPIO_SEL : R/W; bitpos: [23]; default: 0;
 *  XTAL_32K sel. 0: external XTAL_32K, 1: CLK from RTC pad X32P_C
 */
#define RTC_CNTL_XTAL32K_GPIO_SEL    (BIT(23))
#define RTC_CNTL_XTAL32K_GPIO_SEL_M  (RTC_CNTL_XTAL32K_GPIO_SEL_V << RTC_CNTL_XTAL32K_GPIO_SEL_S)
#define RTC_CNTL_XTAL32K_GPIO_SEL_V  0x00000001U
#define RTC_CNTL_XTAL32K_GPIO_SEL_S  23
/** RTC_CNTL_XTL_EXT_CTR_LV : R/W; bitpos: [30]; default: 0;
 *  0: power down XTAL at high level, 1: power down XTAL at low level
 */
#define RTC_CNTL_XTL_EXT_CTR_LV    (BIT(30))
#define RTC_CNTL_XTL_EXT_CTR_LV_M  (RTC_CNTL_XTL_EXT_CTR_LV_V << RTC_CNTL_XTL_EXT_CTR_LV_S)
#define RTC_CNTL_XTL_EXT_CTR_LV_V  0x00000001U
#define RTC_CNTL_XTL_EXT_CTR_LV_S  30
/** RTC_CNTL_XTL_EXT_CTR_EN : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XTL_EXT_CTR_EN    (BIT(31))
#define RTC_CNTL_XTL_EXT_CTR_EN_M  (RTC_CNTL_XTL_EXT_CTR_EN_V << RTC_CNTL_XTL_EXT_CTR_EN_S)
#define RTC_CNTL_XTL_EXT_CTR_EN_V  0x00000001U
#define RTC_CNTL_XTL_EXT_CTR_EN_S  31

/** RTC_CNTL_EXT_WAKEUP_CONF_REG register
 *  register description
 */
#define RTC_CNTL_EXT_WAKEUP_CONF_REG (DR_REG_RTCCNTL_BASE + 0x64)
/** RTC_CNTL_GPIO_WAKEUP_FILTER : R/W; bitpos: [31]; default: 0;
 *  enable filter for gpio wakeup event
 */
#define RTC_CNTL_GPIO_WAKEUP_FILTER    (BIT(31))
#define RTC_CNTL_GPIO_WAKEUP_FILTER_M  (RTC_CNTL_GPIO_WAKEUP_FILTER_V << RTC_CNTL_GPIO_WAKEUP_FILTER_S)
#define RTC_CNTL_GPIO_WAKEUP_FILTER_V  0x00000001U
#define RTC_CNTL_GPIO_WAKEUP_FILTER_S  31

/** RTC_CNTL_SLP_REJECT_CONF_REG register
 *  register description
 */
#define RTC_CNTL_SLP_REJECT_CONF_REG (DR_REG_RTCCNTL_BASE + 0x68)
/** RTC_CNTL_SLEEP_REJECT_ENA : R/W; bitpos: [29:11]; default: 0;
 *  sleep reject enable
 */
#define RTC_CNTL_SLEEP_REJECT_ENA    0x0007FFFFU
#define RTC_CNTL_SLEEP_REJECT_ENA_M  (RTC_CNTL_SLEEP_REJECT_ENA_V << RTC_CNTL_SLEEP_REJECT_ENA_S)
#define RTC_CNTL_SLEEP_REJECT_ENA_V  0x0007FFFFU
#define RTC_CNTL_SLEEP_REJECT_ENA_S  11
/** RTC_CNTL_LIGHT_SLP_REJECT_EN : R/W; bitpos: [30]; default: 0;
 *  enable reject for light sleep
 */
#define RTC_CNTL_LIGHT_SLP_REJECT_EN    (BIT(30))
#define RTC_CNTL_LIGHT_SLP_REJECT_EN_M  (RTC_CNTL_LIGHT_SLP_REJECT_EN_V << RTC_CNTL_LIGHT_SLP_REJECT_EN_S)
#define RTC_CNTL_LIGHT_SLP_REJECT_EN_V  0x00000001U
#define RTC_CNTL_LIGHT_SLP_REJECT_EN_S  30
/** RTC_CNTL_DEEP_SLP_REJECT_EN : R/W; bitpos: [31]; default: 0;
 *  enable reject for deep sleep
 */
#define RTC_CNTL_DEEP_SLP_REJECT_EN    (BIT(31))
#define RTC_CNTL_DEEP_SLP_REJECT_EN_M  (RTC_CNTL_DEEP_SLP_REJECT_EN_V << RTC_CNTL_DEEP_SLP_REJECT_EN_S)
#define RTC_CNTL_DEEP_SLP_REJECT_EN_V  0x00000001U
#define RTC_CNTL_DEEP_SLP_REJECT_EN_S  31

/** RTC_CNTL_CPU_PERIOD_CONF_REG register
 *  register description
 */
#define RTC_CNTL_CPU_PERIOD_CONF_REG (DR_REG_RTCCNTL_BASE + 0x6c)
/** RTC_CNTL_CPUSEL_CONF : R/W; bitpos: [29]; default: 0;
 *  CPU sel option
 */
#define RTC_CNTL_CPUSEL_CONF    (BIT(29))
#define RTC_CNTL_CPUSEL_CONF_M  (RTC_CNTL_CPUSEL_CONF_V << RTC_CNTL_CPUSEL_CONF_S)
#define RTC_CNTL_CPUSEL_CONF_V  0x00000001U
#define RTC_CNTL_CPUSEL_CONF_S  29
/** RTC_CNTL_CPUPERIOD_SEL : R/W; bitpos: [31:30]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_CPUPERIOD_SEL    0x00000003U
#define RTC_CNTL_CPUPERIOD_SEL_M  (RTC_CNTL_CPUPERIOD_SEL_V << RTC_CNTL_CPUPERIOD_SEL_S)
#define RTC_CNTL_CPUPERIOD_SEL_V  0x00000003U
#define RTC_CNTL_CPUPERIOD_SEL_S  30

/** RTC_CNTL_CLK_CONF_REG register
 *  register description
 */
#define RTC_CNTL_CLK_CONF_REG (DR_REG_RTCCNTL_BASE + 0x70)
/** RTC_CNTL_BLE_TMR_RST : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BLE_TMR_RST    (BIT(0))
#define RTC_CNTL_BLE_TMR_RST_M  (RTC_CNTL_BLE_TMR_RST_V << RTC_CNTL_BLE_TMR_RST_S)
#define RTC_CNTL_BLE_TMR_RST_V  0x00000001U
#define RTC_CNTL_BLE_TMR_RST_S  0
/** RTC_CNTL_EFUSE_CLK_FORCE_GATING : R/W; bitpos: [1]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_EFUSE_CLK_FORCE_GATING    (BIT(1))
#define RTC_CNTL_EFUSE_CLK_FORCE_GATING_M  (RTC_CNTL_EFUSE_CLK_FORCE_GATING_V << RTC_CNTL_EFUSE_CLK_FORCE_GATING_S)
#define RTC_CNTL_EFUSE_CLK_FORCE_GATING_V  0x00000001U
#define RTC_CNTL_EFUSE_CLK_FORCE_GATING_S  1
/** RTC_CNTL_EFUSE_CLK_FORCE_NOGATING : R/W; bitpos: [2]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_EFUSE_CLK_FORCE_NOGATING    (BIT(2))
#define RTC_CNTL_EFUSE_CLK_FORCE_NOGATING_M  (RTC_CNTL_EFUSE_CLK_FORCE_NOGATING_V << RTC_CNTL_EFUSE_CLK_FORCE_NOGATING_S)
#define RTC_CNTL_EFUSE_CLK_FORCE_NOGATING_V  0x00000001U
#define RTC_CNTL_EFUSE_CLK_FORCE_NOGATING_S  2
/** RTC_CNTL_CK8M_DIV_SEL_VLD : R/W; bitpos: [3]; default: 1;
 *  used to sync reg_ck8m_div_sel bus. Clear vld before set reg_ck8m_div_sel, then set
 *  vld to actually switch the clk
 */
#define RTC_CNTL_CK8M_DIV_SEL_VLD    (BIT(3))
#define RTC_CNTL_CK8M_DIV_SEL_VLD_M  (RTC_CNTL_CK8M_DIV_SEL_VLD_V << RTC_CNTL_CK8M_DIV_SEL_VLD_S)
#define RTC_CNTL_CK8M_DIV_SEL_VLD_V  0x00000001U
#define RTC_CNTL_CK8M_DIV_SEL_VLD_S  3
/** RTC_CNTL_DIG_XTAL32K_EN : R/W; bitpos: [4]; default: 0;
 *  enable CK_XTAL_32K for digital core (no relationship with RTC core)
 */
#define RTC_CNTL_DIG_XTAL32K_EN    (BIT(4))
#define RTC_CNTL_DIG_XTAL32K_EN_M  (RTC_CNTL_DIG_XTAL32K_EN_V << RTC_CNTL_DIG_XTAL32K_EN_S)
#define RTC_CNTL_DIG_XTAL32K_EN_V  0x00000001U
#define RTC_CNTL_DIG_XTAL32K_EN_S  4
/** RTC_CNTL_DIG_RC32K_EN : R/W; bitpos: [5]; default: 1;
 *  enable RC32K for digital core (no relationship with RTC core)
 */
#define RTC_CNTL_DIG_RC32K_EN    (BIT(5))
#define RTC_CNTL_DIG_RC32K_EN_M  (RTC_CNTL_DIG_RC32K_EN_V << RTC_CNTL_DIG_RC32K_EN_S)
#define RTC_CNTL_DIG_RC32K_EN_V  0x00000001U
#define RTC_CNTL_DIG_RC32K_EN_S  5
/** RTC_CNTL_DIG_CLK8M_EN : R/W; bitpos: [6]; default: 0;
 *  enable CK8M for digital core (no relationship with RTC core)
 */
#define RTC_CNTL_DIG_CLK8M_EN    (BIT(6))
#define RTC_CNTL_DIG_CLK8M_EN_M  (RTC_CNTL_DIG_CLK8M_EN_V << RTC_CNTL_DIG_CLK8M_EN_S)
#define RTC_CNTL_DIG_CLK8M_EN_V  0x00000001U
#define RTC_CNTL_DIG_CLK8M_EN_S  6
/** RTC_CNTL_BLE_TIMER_SEL : R/W; bitpos: [7]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BLE_TIMER_SEL    (BIT(7))
#define RTC_CNTL_BLE_TIMER_SEL_M  (RTC_CNTL_BLE_TIMER_SEL_V << RTC_CNTL_BLE_TIMER_SEL_S)
#define RTC_CNTL_BLE_TIMER_SEL_V  0x00000001U
#define RTC_CNTL_BLE_TIMER_SEL_S  7
/** RTC_CNTL_CK8M_DIV_SEL : R/W; bitpos: [12:10]; default: 3;
 *  divider = reg_ck8m_div_sel + 1
 */
#define RTC_CNTL_CK8M_DIV_SEL    0x00000007U
#define RTC_CNTL_CK8M_DIV_SEL_M  (RTC_CNTL_CK8M_DIV_SEL_V << RTC_CNTL_CK8M_DIV_SEL_S)
#define RTC_CNTL_CK8M_DIV_SEL_V  0x00000007U
#define RTC_CNTL_CK8M_DIV_SEL_S  10
/** RTC_CNTL_XTAL_FORCE_NOGATING : R/W; bitpos: [13]; default: 0;
 *  XTAL force no gating during sleep
 */
#define RTC_CNTL_XTAL_FORCE_NOGATING    (BIT(13))
#define RTC_CNTL_XTAL_FORCE_NOGATING_M  (RTC_CNTL_XTAL_FORCE_NOGATING_V << RTC_CNTL_XTAL_FORCE_NOGATING_S)
#define RTC_CNTL_XTAL_FORCE_NOGATING_V  0x00000001U
#define RTC_CNTL_XTAL_FORCE_NOGATING_S  13
/** RTC_CNTL_CK8M_FORCE_NOGATING : R/W; bitpos: [14]; default: 0;
 *  CK8M force no gating during sleep
 */
#define RTC_CNTL_CK8M_FORCE_NOGATING    (BIT(14))
#define RTC_CNTL_CK8M_FORCE_NOGATING_M  (RTC_CNTL_CK8M_FORCE_NOGATING_V << RTC_CNTL_CK8M_FORCE_NOGATING_S)
#define RTC_CNTL_CK8M_FORCE_NOGATING_V  0x00000001U
#define RTC_CNTL_CK8M_FORCE_NOGATING_S  14
/** RTC_CNTL_CK8M_DFREQ : R/W; bitpos: [24:15]; default: 600;
 *  CK8M_DFREQ
 */
#define RTC_CNTL_CK8M_DFREQ    0x000003FFU
#define RTC_CNTL_CK8M_DFREQ_M  (RTC_CNTL_CK8M_DFREQ_V << RTC_CNTL_CK8M_DFREQ_S)
#define RTC_CNTL_CK8M_DFREQ_V  0x000003FFU
#define RTC_CNTL_CK8M_DFREQ_S  15
/** RTC_CNTL_CK8M_FORCE_PD : R/W; bitpos: [25]; default: 0;
 *  CK8M force power down
 */
#define RTC_CNTL_CK8M_FORCE_PD    (BIT(25))
#define RTC_CNTL_CK8M_FORCE_PD_M  (RTC_CNTL_CK8M_FORCE_PD_V << RTC_CNTL_CK8M_FORCE_PD_S)
#define RTC_CNTL_CK8M_FORCE_PD_V  0x00000001U
#define RTC_CNTL_CK8M_FORCE_PD_S  25
/** RTC_CNTL_CK8M_FORCE_PU : R/W; bitpos: [26]; default: 0;
 *  CK8M force power up
 */
#define RTC_CNTL_CK8M_FORCE_PU    (BIT(26))
#define RTC_CNTL_CK8M_FORCE_PU_M  (RTC_CNTL_CK8M_FORCE_PU_V << RTC_CNTL_CK8M_FORCE_PU_S)
#define RTC_CNTL_CK8M_FORCE_PU_V  0x00000001U
#define RTC_CNTL_CK8M_FORCE_PU_S  26
/** RTC_CNTL_XTAL_GLOBAL_FORCE_GATING : R/W; bitpos: [27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XTAL_GLOBAL_FORCE_GATING    (BIT(27))
#define RTC_CNTL_XTAL_GLOBAL_FORCE_GATING_M  (RTC_CNTL_XTAL_GLOBAL_FORCE_GATING_V << RTC_CNTL_XTAL_GLOBAL_FORCE_GATING_S)
#define RTC_CNTL_XTAL_GLOBAL_FORCE_GATING_V  0x00000001U
#define RTC_CNTL_XTAL_GLOBAL_FORCE_GATING_S  27
/** RTC_CNTL_XTAL_GLOBAL_FORCE_NOGATING : R/W; bitpos: [28]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_XTAL_GLOBAL_FORCE_NOGATING    (BIT(28))
#define RTC_CNTL_XTAL_GLOBAL_FORCE_NOGATING_M  (RTC_CNTL_XTAL_GLOBAL_FORCE_NOGATING_V << RTC_CNTL_XTAL_GLOBAL_FORCE_NOGATING_S)
#define RTC_CNTL_XTAL_GLOBAL_FORCE_NOGATING_V  0x00000001U
#define RTC_CNTL_XTAL_GLOBAL_FORCE_NOGATING_S  28
/** RTC_CNTL_FAST_CLK_RTC_SEL : R/W; bitpos: [29]; default: 0;
 *  fast_clk_rtc sel. 0: XTAL div 2, 1: CK8M
 */
#define RTC_CNTL_FAST_CLK_RTC_SEL    (BIT(29))
#define RTC_CNTL_FAST_CLK_RTC_SEL_M  (RTC_CNTL_FAST_CLK_RTC_SEL_V << RTC_CNTL_FAST_CLK_RTC_SEL_S)
#define RTC_CNTL_FAST_CLK_RTC_SEL_V  0x00000001U
#define RTC_CNTL_FAST_CLK_RTC_SEL_S  29
/** RTC_CNTL_ANA_CLK_RTC_SEL : R/W; bitpos: [31:30]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_ANA_CLK_RTC_SEL    0x00000003U
#define RTC_CNTL_ANA_CLK_RTC_SEL_M  (RTC_CNTL_ANA_CLK_RTC_SEL_V << RTC_CNTL_ANA_CLK_RTC_SEL_S)
#define RTC_CNTL_ANA_CLK_RTC_SEL_V  0x00000003U
#define RTC_CNTL_ANA_CLK_RTC_SEL_S  30

/** RTC_CNTL_SLOW_CLK_CONF_REG register
 *  register description
 */
#define RTC_CNTL_SLOW_CLK_CONF_REG (DR_REG_RTCCNTL_BASE + 0x74)
/** RTC_CNTL_ANA_CLK_PD_SLP : R/W; bitpos: [19]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_ANA_CLK_PD_SLP    (BIT(19))
#define RTC_CNTL_ANA_CLK_PD_SLP_M  (RTC_CNTL_ANA_CLK_PD_SLP_V << RTC_CNTL_ANA_CLK_PD_SLP_S)
#define RTC_CNTL_ANA_CLK_PD_SLP_V  0x00000001U
#define RTC_CNTL_ANA_CLK_PD_SLP_S  19
/** RTC_CNTL_ANA_CLK_PD_MONITOR : R/W; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_ANA_CLK_PD_MONITOR    (BIT(20))
#define RTC_CNTL_ANA_CLK_PD_MONITOR_M  (RTC_CNTL_ANA_CLK_PD_MONITOR_V << RTC_CNTL_ANA_CLK_PD_MONITOR_S)
#define RTC_CNTL_ANA_CLK_PD_MONITOR_V  0x00000001U
#define RTC_CNTL_ANA_CLK_PD_MONITOR_S  20
/** RTC_CNTL_ANA_CLK_PD_IDLE : R/W; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_ANA_CLK_PD_IDLE    (BIT(21))
#define RTC_CNTL_ANA_CLK_PD_IDLE_M  (RTC_CNTL_ANA_CLK_PD_IDLE_V << RTC_CNTL_ANA_CLK_PD_IDLE_S)
#define RTC_CNTL_ANA_CLK_PD_IDLE_V  0x00000001U
#define RTC_CNTL_ANA_CLK_PD_IDLE_S  21
/** RTC_CNTL_ANA_CLK_DIV_VLD : R/W; bitpos: [22]; default: 1;
 *  used to sync div bus. clear vld before set reg_rtc_ana_clk_div, then set vld to
 *  actually switch the clk
 */
#define RTC_CNTL_ANA_CLK_DIV_VLD    (BIT(22))
#define RTC_CNTL_ANA_CLK_DIV_VLD_M  (RTC_CNTL_ANA_CLK_DIV_VLD_V << RTC_CNTL_ANA_CLK_DIV_VLD_S)
#define RTC_CNTL_ANA_CLK_DIV_VLD_V  0x00000001U
#define RTC_CNTL_ANA_CLK_DIV_VLD_S  22
/** RTC_CNTL_ANA_CLK_DIV : R/W; bitpos: [30:23]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_ANA_CLK_DIV    0x000000FFU
#define RTC_CNTL_ANA_CLK_DIV_M  (RTC_CNTL_ANA_CLK_DIV_V << RTC_CNTL_ANA_CLK_DIV_S)
#define RTC_CNTL_ANA_CLK_DIV_V  0x000000FFU
#define RTC_CNTL_ANA_CLK_DIV_S  23
/** RTC_CNTL_SLOW_CLK_NEXT_EDGE : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SLOW_CLK_NEXT_EDGE    (BIT(31))
#define RTC_CNTL_SLOW_CLK_NEXT_EDGE_M  (RTC_CNTL_SLOW_CLK_NEXT_EDGE_V << RTC_CNTL_SLOW_CLK_NEXT_EDGE_S)
#define RTC_CNTL_SLOW_CLK_NEXT_EDGE_V  0x00000001U
#define RTC_CNTL_SLOW_CLK_NEXT_EDGE_S  31

/** RTC_CNTL_SDIO_CONF_REG register
 *  register description
 */
#define RTC_CNTL_SDIO_CONF_REG (DR_REG_RTCCNTL_BASE + 0x78)
/** RTC_CNTL_SDIO_TIMER_TARGET : R/W; bitpos: [7:0]; default: 10;
 *  timer count to apply reg_sdio_dcap after sdio power on
 */
#define RTC_CNTL_SDIO_TIMER_TARGET    0x000000FFU
#define RTC_CNTL_SDIO_TIMER_TARGET_M  (RTC_CNTL_SDIO_TIMER_TARGET_V << RTC_CNTL_SDIO_TIMER_TARGET_S)
#define RTC_CNTL_SDIO_TIMER_TARGET_V  0x000000FFU
#define RTC_CNTL_SDIO_TIMER_TARGET_S  0
/** RTC_CNTL_SDIO_DTHDRV : R/W; bitpos: [10:9]; default: 3;
 *  Tieh = 1 mode drive ability. Initially set to 0 to limit charge current, set to 3
 *  after several us.
 */
#define RTC_CNTL_SDIO_DTHDRV    0x00000003U
#define RTC_CNTL_SDIO_DTHDRV_M  (RTC_CNTL_SDIO_DTHDRV_V << RTC_CNTL_SDIO_DTHDRV_S)
#define RTC_CNTL_SDIO_DTHDRV_V  0x00000003U
#define RTC_CNTL_SDIO_DTHDRV_S  9
/** RTC_CNTL_SDIO_DCAP : R/W; bitpos: [12:11]; default: 3;
 *  ability to prevent LDO from overshoot
 */
#define RTC_CNTL_SDIO_DCAP    0x00000003U
#define RTC_CNTL_SDIO_DCAP_M  (RTC_CNTL_SDIO_DCAP_V << RTC_CNTL_SDIO_DCAP_S)
#define RTC_CNTL_SDIO_DCAP_V  0x00000003U
#define RTC_CNTL_SDIO_DCAP_S  11
/** RTC_CNTL_SDIO_INITI : R/W; bitpos: [14:13]; default: 1;
 *  add resistor from ldo output to ground. 0: no res, 1: 6k, 2: 4k, 3: 2k
 */
#define RTC_CNTL_SDIO_INITI    0x00000003U
#define RTC_CNTL_SDIO_INITI_M  (RTC_CNTL_SDIO_INITI_V << RTC_CNTL_SDIO_INITI_S)
#define RTC_CNTL_SDIO_INITI_V  0x00000003U
#define RTC_CNTL_SDIO_INITI_S  13
/** RTC_CNTL_SDIO_EN_INITI : R/W; bitpos: [15]; default: 1;
 *  0 to set init[1:0]=0
 */
#define RTC_CNTL_SDIO_EN_INITI    (BIT(15))
#define RTC_CNTL_SDIO_EN_INITI_M  (RTC_CNTL_SDIO_EN_INITI_V << RTC_CNTL_SDIO_EN_INITI_S)
#define RTC_CNTL_SDIO_EN_INITI_V  0x00000001U
#define RTC_CNTL_SDIO_EN_INITI_S  15
/** RTC_CNTL_SDIO_DCURLIM : R/W; bitpos: [18:16]; default: 0;
 *  tune current limit threshold when tieh = 0. About 800mA/(8+d)
 */
#define RTC_CNTL_SDIO_DCURLIM    0x00000007U
#define RTC_CNTL_SDIO_DCURLIM_M  (RTC_CNTL_SDIO_DCURLIM_V << RTC_CNTL_SDIO_DCURLIM_S)
#define RTC_CNTL_SDIO_DCURLIM_V  0x00000007U
#define RTC_CNTL_SDIO_DCURLIM_S  16
/** RTC_CNTL_SDIO_MODECURLIM : R/W; bitpos: [19]; default: 0;
 *  select current limit mode
 */
#define RTC_CNTL_SDIO_MODECURLIM    (BIT(19))
#define RTC_CNTL_SDIO_MODECURLIM_M  (RTC_CNTL_SDIO_MODECURLIM_V << RTC_CNTL_SDIO_MODECURLIM_S)
#define RTC_CNTL_SDIO_MODECURLIM_V  0x00000001U
#define RTC_CNTL_SDIO_MODECURLIM_S  19
/** RTC_CNTL_SDIO_ENCURLIM : R/W; bitpos: [20]; default: 1;
 *  enable current limit
 */
#define RTC_CNTL_SDIO_ENCURLIM    (BIT(20))
#define RTC_CNTL_SDIO_ENCURLIM_M  (RTC_CNTL_SDIO_ENCURLIM_V << RTC_CNTL_SDIO_ENCURLIM_S)
#define RTC_CNTL_SDIO_ENCURLIM_V  0x00000001U
#define RTC_CNTL_SDIO_ENCURLIM_S  20
/** RTC_CNTL_SDIO_PD_EN : R/W; bitpos: [21]; default: 1;
 *  power down SDIO_REG in sleep. Only active when reg_sdio_force = 0
 */
#define RTC_CNTL_SDIO_PD_EN    (BIT(21))
#define RTC_CNTL_SDIO_PD_EN_M  (RTC_CNTL_SDIO_PD_EN_V << RTC_CNTL_SDIO_PD_EN_S)
#define RTC_CNTL_SDIO_PD_EN_V  0x00000001U
#define RTC_CNTL_SDIO_PD_EN_S  21
/** RTC_CNTL_SDIO_FORCE : R/W; bitpos: [22]; default: 0;
 *  1: use SW option to control SDIO_REG ,0: use state machine
 */
#define RTC_CNTL_SDIO_FORCE    (BIT(22))
#define RTC_CNTL_SDIO_FORCE_M  (RTC_CNTL_SDIO_FORCE_V << RTC_CNTL_SDIO_FORCE_S)
#define RTC_CNTL_SDIO_FORCE_V  0x00000001U
#define RTC_CNTL_SDIO_FORCE_S  22
/** RTC_CNTL_SDIO_TIEH : R/W; bitpos: [23]; default: 1;
 *  SW option for SDIO_TIEH. Only active when reg_sdio_force = 1
 */
#define RTC_CNTL_SDIO_TIEH    (BIT(23))
#define RTC_CNTL_SDIO_TIEH_M  (RTC_CNTL_SDIO_TIEH_V << RTC_CNTL_SDIO_TIEH_S)
#define RTC_CNTL_SDIO_TIEH_V  0x00000001U
#define RTC_CNTL_SDIO_TIEH_S  23
/** RTC_CNTL_REG1P8_READY : RO; bitpos: [24]; default: 0;
 *  read only register for REG1P8_READY
 */
#define RTC_CNTL_REG1P8_READY    (BIT(24))
#define RTC_CNTL_REG1P8_READY_M  (RTC_CNTL_REG1P8_READY_V << RTC_CNTL_REG1P8_READY_S)
#define RTC_CNTL_REG1P8_READY_V  0x00000001U
#define RTC_CNTL_REG1P8_READY_S  24
/** RTC_CNTL_DREFL_SDIO : R/W; bitpos: [26:25]; default: 1;
 *  SW option for DREFL_SDIO. Only active when reg_sdio_force = 1
 */
#define RTC_CNTL_DREFL_SDIO    0x00000003U
#define RTC_CNTL_DREFL_SDIO_M  (RTC_CNTL_DREFL_SDIO_V << RTC_CNTL_DREFL_SDIO_S)
#define RTC_CNTL_DREFL_SDIO_V  0x00000003U
#define RTC_CNTL_DREFL_SDIO_S  25
/** RTC_CNTL_DREFM_SDIO : R/W; bitpos: [28:27]; default: 1;
 *  SW option for DREFM_SDIO. Only active when reg_sdio_force = 1
 */
#define RTC_CNTL_DREFM_SDIO    0x00000003U
#define RTC_CNTL_DREFM_SDIO_M  (RTC_CNTL_DREFM_SDIO_V << RTC_CNTL_DREFM_SDIO_S)
#define RTC_CNTL_DREFM_SDIO_V  0x00000003U
#define RTC_CNTL_DREFM_SDIO_S  27
/** RTC_CNTL_DREFH_SDIO : R/W; bitpos: [30:29]; default: 0;
 *  SW option for DREFH_SDIO. Only active when reg_sdio_force = 1
 */
#define RTC_CNTL_DREFH_SDIO    0x00000003U
#define RTC_CNTL_DREFH_SDIO_M  (RTC_CNTL_DREFH_SDIO_V << RTC_CNTL_DREFH_SDIO_S)
#define RTC_CNTL_DREFH_SDIO_V  0x00000003U
#define RTC_CNTL_DREFH_SDIO_S  29
/** RTC_CNTL_XPD_SDIO_REG : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XPD_SDIO_REG    (BIT(31))
#define RTC_CNTL_XPD_SDIO_REG_M  (RTC_CNTL_XPD_SDIO_REG_V << RTC_CNTL_XPD_SDIO_REG_S)
#define RTC_CNTL_XPD_SDIO_REG_V  0x00000001U
#define RTC_CNTL_XPD_SDIO_REG_S  31

/** RTC_CNTL_BIAS_CONF_REG register
 *  register description
 */
#define RTC_CNTL_BIAS_CONF_REG (DR_REG_RTCCNTL_BASE + 0x7c)
/** RTC_CNTL_BIAS_BUF_IDLE : R/W; bitpos: [10]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BIAS_BUF_IDLE    (BIT(10))
#define RTC_CNTL_BIAS_BUF_IDLE_M  (RTC_CNTL_BIAS_BUF_IDLE_V << RTC_CNTL_BIAS_BUF_IDLE_S)
#define RTC_CNTL_BIAS_BUF_IDLE_V  0x00000001U
#define RTC_CNTL_BIAS_BUF_IDLE_S  10
/** RTC_CNTL_BIAS_BUF_WAKE : R/W; bitpos: [11]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_BIAS_BUF_WAKE    (BIT(11))
#define RTC_CNTL_BIAS_BUF_WAKE_M  (RTC_CNTL_BIAS_BUF_WAKE_V << RTC_CNTL_BIAS_BUF_WAKE_S)
#define RTC_CNTL_BIAS_BUF_WAKE_V  0x00000001U
#define RTC_CNTL_BIAS_BUF_WAKE_S  11
/** RTC_CNTL_BIAS_BUF_DEEP_SLP : R/W; bitpos: [12]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BIAS_BUF_DEEP_SLP    (BIT(12))
#define RTC_CNTL_BIAS_BUF_DEEP_SLP_M  (RTC_CNTL_BIAS_BUF_DEEP_SLP_V << RTC_CNTL_BIAS_BUF_DEEP_SLP_S)
#define RTC_CNTL_BIAS_BUF_DEEP_SLP_V  0x00000001U
#define RTC_CNTL_BIAS_BUF_DEEP_SLP_S  12
/** RTC_CNTL_BIAS_BUF_MONITOR : R/W; bitpos: [13]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BIAS_BUF_MONITOR    (BIT(13))
#define RTC_CNTL_BIAS_BUF_MONITOR_M  (RTC_CNTL_BIAS_BUF_MONITOR_V << RTC_CNTL_BIAS_BUF_MONITOR_S)
#define RTC_CNTL_BIAS_BUF_MONITOR_V  0x00000001U
#define RTC_CNTL_BIAS_BUF_MONITOR_S  13
/** RTC_CNTL_PD_CUR_DEEP_SLP : R/W; bitpos: [14]; default: 0;
 *  xpd cur when rtc in sleep_state
 */
#define RTC_CNTL_PD_CUR_DEEP_SLP    (BIT(14))
#define RTC_CNTL_PD_CUR_DEEP_SLP_M  (RTC_CNTL_PD_CUR_DEEP_SLP_V << RTC_CNTL_PD_CUR_DEEP_SLP_S)
#define RTC_CNTL_PD_CUR_DEEP_SLP_V  0x00000001U
#define RTC_CNTL_PD_CUR_DEEP_SLP_S  14
/** RTC_CNTL_PD_CUR_MONITOR : R/W; bitpos: [15]; default: 0;
 *  xpd cur when rtc in monitor state
 */
#define RTC_CNTL_PD_CUR_MONITOR    (BIT(15))
#define RTC_CNTL_PD_CUR_MONITOR_M  (RTC_CNTL_PD_CUR_MONITOR_V << RTC_CNTL_PD_CUR_MONITOR_S)
#define RTC_CNTL_PD_CUR_MONITOR_V  0x00000001U
#define RTC_CNTL_PD_CUR_MONITOR_S  15
/** RTC_CNTL_BIAS_SLEEP_DEEP_SLP : R/W; bitpos: [16]; default: 1;
 *  bias_sleep when rtc in sleep_state
 */
#define RTC_CNTL_BIAS_SLEEP_DEEP_SLP    (BIT(16))
#define RTC_CNTL_BIAS_SLEEP_DEEP_SLP_M  (RTC_CNTL_BIAS_SLEEP_DEEP_SLP_V << RTC_CNTL_BIAS_SLEEP_DEEP_SLP_S)
#define RTC_CNTL_BIAS_SLEEP_DEEP_SLP_V  0x00000001U
#define RTC_CNTL_BIAS_SLEEP_DEEP_SLP_S  16
/** RTC_CNTL_BIAS_SLEEP_MONITOR : R/W; bitpos: [17]; default: 0;
 *  bias_sleep when rtc in monitor state
 */
#define RTC_CNTL_BIAS_SLEEP_MONITOR    (BIT(17))
#define RTC_CNTL_BIAS_SLEEP_MONITOR_M  (RTC_CNTL_BIAS_SLEEP_MONITOR_V << RTC_CNTL_BIAS_SLEEP_MONITOR_S)
#define RTC_CNTL_BIAS_SLEEP_MONITOR_V  0x00000001U
#define RTC_CNTL_BIAS_SLEEP_MONITOR_S  17
/** RTC_CNTL_DBG_ATTEN_DEEP_SLP : R/W; bitpos: [21:18]; default: 0;
 *  DBG_ATTEN when rtc in sleep state
 */
#define RTC_CNTL_DBG_ATTEN_DEEP_SLP    0x0000000FU
#define RTC_CNTL_DBG_ATTEN_DEEP_SLP_M  (RTC_CNTL_DBG_ATTEN_DEEP_SLP_V << RTC_CNTL_DBG_ATTEN_DEEP_SLP_S)
#define RTC_CNTL_DBG_ATTEN_DEEP_SLP_V  0x0000000FU
#define RTC_CNTL_DBG_ATTEN_DEEP_SLP_S  18
/** RTC_CNTL_DBG_ATTEN_MONITOR : R/W; bitpos: [25:22]; default: 0;
 *  DBG_ATTEN when rtc in monitor state
 */
#define RTC_CNTL_DBG_ATTEN_MONITOR    0x0000000FU
#define RTC_CNTL_DBG_ATTEN_MONITOR_M  (RTC_CNTL_DBG_ATTEN_MONITOR_V << RTC_CNTL_DBG_ATTEN_MONITOR_S)
#define RTC_CNTL_DBG_ATTEN_MONITOR_V  0x0000000FU
#define RTC_CNTL_DBG_ATTEN_MONITOR_S  22
/** RTC_CNTL_XPD_DCDC_SLP : R/W; bitpos: [26]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_XPD_DCDC_SLP    (BIT(26))
#define RTC_CNTL_XPD_DCDC_SLP_M  (RTC_CNTL_XPD_DCDC_SLP_V << RTC_CNTL_XPD_DCDC_SLP_S)
#define RTC_CNTL_XPD_DCDC_SLP_V  0x00000001U
#define RTC_CNTL_XPD_DCDC_SLP_S  26
/** RTC_CNTL_XPD_DCDC_MONITOR : R/W; bitpos: [27]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_XPD_DCDC_MONITOR    (BIT(27))
#define RTC_CNTL_XPD_DCDC_MONITOR_M  (RTC_CNTL_XPD_DCDC_MONITOR_V << RTC_CNTL_XPD_DCDC_MONITOR_S)
#define RTC_CNTL_XPD_DCDC_MONITOR_V  0x00000001U
#define RTC_CNTL_XPD_DCDC_MONITOR_S  27
/** RTC_CNTL_XPD_DCDC_IDLE : R/W; bitpos: [28]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_XPD_DCDC_IDLE    (BIT(28))
#define RTC_CNTL_XPD_DCDC_IDLE_M  (RTC_CNTL_XPD_DCDC_IDLE_V << RTC_CNTL_XPD_DCDC_IDLE_S)
#define RTC_CNTL_XPD_DCDC_IDLE_V  0x00000001U
#define RTC_CNTL_XPD_DCDC_IDLE_S  28

/** RTC_CNTL_REGULATOR_REG register
 *  register description
 */
#define RTC_CNTL_REGULATOR_REG (DR_REG_RTCCNTL_BASE + 0x80)
/** RTC_CNTL_DBIAS_SWITCH_SLP : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DBIAS_SWITCH_SLP    (BIT(0))
#define RTC_CNTL_DBIAS_SWITCH_SLP_M  (RTC_CNTL_DBIAS_SWITCH_SLP_V << RTC_CNTL_DBIAS_SWITCH_SLP_S)
#define RTC_CNTL_DBIAS_SWITCH_SLP_V  0x00000001U
#define RTC_CNTL_DBIAS_SWITCH_SLP_S  0
/** RTC_CNTL_DBIAS_SWITCH_MONITOR : R/W; bitpos: [1]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DBIAS_SWITCH_MONITOR    (BIT(1))
#define RTC_CNTL_DBIAS_SWITCH_MONITOR_M  (RTC_CNTL_DBIAS_SWITCH_MONITOR_V << RTC_CNTL_DBIAS_SWITCH_MONITOR_S)
#define RTC_CNTL_DBIAS_SWITCH_MONITOR_V  0x00000001U
#define RTC_CNTL_DBIAS_SWITCH_MONITOR_S  1
/** RTC_CNTL_DBIAS_SWITCH_IDLE : R/W; bitpos: [2]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DBIAS_SWITCH_IDLE    (BIT(2))
#define RTC_CNTL_DBIAS_SWITCH_IDLE_M  (RTC_CNTL_DBIAS_SWITCH_IDLE_V << RTC_CNTL_DBIAS_SWITCH_IDLE_S)
#define RTC_CNTL_DBIAS_SWITCH_IDLE_V  0x00000001U
#define RTC_CNTL_DBIAS_SWITCH_IDLE_S  2
/** RTC_CNTL_DIG_REG_CAL_EN : R/W; bitpos: [3]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DIG_REG_CAL_EN    (BIT(3))
#define RTC_CNTL_DIG_REG_CAL_EN_M  (RTC_CNTL_DIG_REG_CAL_EN_V << RTC_CNTL_DIG_REG_CAL_EN_S)
#define RTC_CNTL_DIG_REG_CAL_EN_V  0x00000001U
#define RTC_CNTL_DIG_REG_CAL_EN_S  3
/** RTC_CNTL_SCK_DCAP : R/W; bitpos: [11:4]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCK_DCAP    0x000000FFU
#define RTC_CNTL_SCK_DCAP_M  (RTC_CNTL_SCK_DCAP_V << RTC_CNTL_SCK_DCAP_S)
#define RTC_CNTL_SCK_DCAP_V  0x000000FFU
#define RTC_CNTL_SCK_DCAP_S  4
/** RTC_CNTL_VDD_DRV_B_ACTIVE : R/W; bitpos: [20:15]; default: 0;
 *  SCK_DCAP
 */
#define RTC_CNTL_VDD_DRV_B_ACTIVE    0x0000003FU
#define RTC_CNTL_VDD_DRV_B_ACTIVE_M  (RTC_CNTL_VDD_DRV_B_ACTIVE_V << RTC_CNTL_VDD_DRV_B_ACTIVE_S)
#define RTC_CNTL_VDD_DRV_B_ACTIVE_V  0x0000003FU
#define RTC_CNTL_VDD_DRV_B_ACTIVE_S  15
/** RTC_CNTL_VDD_DRV_B_SLP : R/W; bitpos: [26:21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VDD_DRV_B_SLP    0x0000003FU
#define RTC_CNTL_VDD_DRV_B_SLP_M  (RTC_CNTL_VDD_DRV_B_SLP_V << RTC_CNTL_VDD_DRV_B_SLP_S)
#define RTC_CNTL_VDD_DRV_B_SLP_V  0x0000003FU
#define RTC_CNTL_VDD_DRV_B_SLP_S  21
/** RTC_CNTL_VDD_DRV_B_SLP_EN : R/W; bitpos: [27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VDD_DRV_B_SLP_EN    (BIT(27))
#define RTC_CNTL_VDD_DRV_B_SLP_EN_M  (RTC_CNTL_VDD_DRV_B_SLP_EN_V << RTC_CNTL_VDD_DRV_B_SLP_EN_S)
#define RTC_CNTL_VDD_DRV_B_SLP_EN_V  0x00000001U
#define RTC_CNTL_VDD_DRV_B_SLP_EN_S  27
/** RTC_CNTL_DBOOST_FORCE_PD : R/W; bitpos: [28]; default: 0;
 *  RTC_DBOOST force power down
 */
#define RTC_CNTL_DBOOST_FORCE_PD    (BIT(28))
#define RTC_CNTL_DBOOST_FORCE_PD_M  (RTC_CNTL_DBOOST_FORCE_PD_V << RTC_CNTL_DBOOST_FORCE_PD_S)
#define RTC_CNTL_DBOOST_FORCE_PD_V  0x00000001U
#define RTC_CNTL_DBOOST_FORCE_PD_S  28
/** RTC_CNTL_DBOOST_FORCE_PU : R/W; bitpos: [29]; default: 1;
 *  RTC_DBOOST force power up
 */
#define RTC_CNTL_DBOOST_FORCE_PU    (BIT(29))
#define RTC_CNTL_DBOOST_FORCE_PU_M  (RTC_CNTL_DBOOST_FORCE_PU_V << RTC_CNTL_DBOOST_FORCE_PU_S)
#define RTC_CNTL_DBOOST_FORCE_PU_V  0x00000001U
#define RTC_CNTL_DBOOST_FORCE_PU_S  29
/** RTC_CNTL_REGULATOR_FORCE_PD : R/W; bitpos: [30]; default: 0;
 *  RTC_REG force power down (for RTC_REG power down means decrease the voltage to 0.8v
 *  or lower )
 */
#define RTC_CNTL_REGULATOR_FORCE_PD    (BIT(30))
#define RTC_CNTL_REGULATOR_FORCE_PD_M  (RTC_CNTL_REGULATOR_FORCE_PD_V << RTC_CNTL_REGULATOR_FORCE_PD_S)
#define RTC_CNTL_REGULATOR_FORCE_PD_V  0x00000001U
#define RTC_CNTL_REGULATOR_FORCE_PD_S  30
/** RTC_CNTL_REGULATOR_FORCE_PU : R/W; bitpos: [31]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_REGULATOR_FORCE_PU    (BIT(31))
#define RTC_CNTL_REGULATOR_FORCE_PU_M  (RTC_CNTL_REGULATOR_FORCE_PU_V << RTC_CNTL_REGULATOR_FORCE_PU_S)
#define RTC_CNTL_REGULATOR_FORCE_PU_V  0x00000001U
#define RTC_CNTL_REGULATOR_FORCE_PU_S  31

/** RTC_CNTL_REGULATOR0_DBIAS_REG register
 *  register description
 */
#define RTC_CNTL_REGULATOR0_DBIAS_REG (DR_REG_RTCCNTL_BASE + 0x84)
/** RTC_CNTL_PVT_RTC_DBIAS : RO; bitpos: [19:15]; default: 20;
 *  get pvt dbias value
 */
#define RTC_CNTL_PVT_RTC_DBIAS    0x0000001FU
#define RTC_CNTL_PVT_RTC_DBIAS_M  (RTC_CNTL_PVT_RTC_DBIAS_V << RTC_CNTL_PVT_RTC_DBIAS_S)
#define RTC_CNTL_PVT_RTC_DBIAS_V  0x0000001FU
#define RTC_CNTL_PVT_RTC_DBIAS_S  15
/** RTC_CNTL_REGULATOR0_DBIAS_SLP : R/W; bitpos: [24:20]; default: 20;
 *  the rtc regulator0 dbias when chip in sleep state
 */
#define RTC_CNTL_REGULATOR0_DBIAS_SLP    0x0000001FU
#define RTC_CNTL_REGULATOR0_DBIAS_SLP_M  (RTC_CNTL_REGULATOR0_DBIAS_SLP_V << RTC_CNTL_REGULATOR0_DBIAS_SLP_S)
#define RTC_CNTL_REGULATOR0_DBIAS_SLP_V  0x0000001FU
#define RTC_CNTL_REGULATOR0_DBIAS_SLP_S  20
/** RTC_CNTL_REGULATOR0_DBIAS_ACTIVE : R/W; bitpos: [29:25]; default: 20;
 *  the rtc regulator0 dbias when chip in active state
 */
#define RTC_CNTL_REGULATOR0_DBIAS_ACTIVE    0x0000001FU
#define RTC_CNTL_REGULATOR0_DBIAS_ACTIVE_M  (RTC_CNTL_REGULATOR0_DBIAS_ACTIVE_V << RTC_CNTL_REGULATOR0_DBIAS_ACTIVE_S)
#define RTC_CNTL_REGULATOR0_DBIAS_ACTIVE_V  0x0000001FU
#define RTC_CNTL_REGULATOR0_DBIAS_ACTIVE_S  25
/** RTC_CNTL_REGULATOR0_DBIAS_SEL : R/W; bitpos: [31]; default: 1;
 *  1: select sw dbias_active 0: select pvt value
 */
#define RTC_CNTL_REGULATOR0_DBIAS_SEL    (BIT(31))
#define RTC_CNTL_REGULATOR0_DBIAS_SEL_M  (RTC_CNTL_REGULATOR0_DBIAS_SEL_V << RTC_CNTL_REGULATOR0_DBIAS_SEL_S)
#define RTC_CNTL_REGULATOR0_DBIAS_SEL_V  0x00000001U
#define RTC_CNTL_REGULATOR0_DBIAS_SEL_S  31

/** RTC_CNTL_REGULATOR1_DBIAS_REG register
 *  register description
 */
#define RTC_CNTL_REGULATOR1_DBIAS_REG (DR_REG_RTCCNTL_BASE + 0x88)
/** RTC_CNTL_REGULATOR1_DBIAS_SLP : R/W; bitpos: [23:20]; default: 8;
 *  the rtc regulator1 dbias when chip in sleep state
 */
#define RTC_CNTL_REGULATOR1_DBIAS_SLP    0x0000000FU
#define RTC_CNTL_REGULATOR1_DBIAS_SLP_M  (RTC_CNTL_REGULATOR1_DBIAS_SLP_V << RTC_CNTL_REGULATOR1_DBIAS_SLP_S)
#define RTC_CNTL_REGULATOR1_DBIAS_SLP_V  0x0000000FU
#define RTC_CNTL_REGULATOR1_DBIAS_SLP_S  20
/** RTC_CNTL_REGULATOR1_DBIAS_ACTIVE : R/W; bitpos: [28:25]; default: 8;
 *  the rtc regulator1 dbias when chip in active state
 */
#define RTC_CNTL_REGULATOR1_DBIAS_ACTIVE    0x0000000FU
#define RTC_CNTL_REGULATOR1_DBIAS_ACTIVE_M  (RTC_CNTL_REGULATOR1_DBIAS_ACTIVE_V << RTC_CNTL_REGULATOR1_DBIAS_ACTIVE_S)
#define RTC_CNTL_REGULATOR1_DBIAS_ACTIVE_V  0x0000000FU
#define RTC_CNTL_REGULATOR1_DBIAS_ACTIVE_S  25

/** RTC_CNTL_DIG_REGULATOR_REG register
 *  register description
 */
#define RTC_CNTL_DIG_REGULATOR_REG (DR_REG_RTCCNTL_BASE + 0x8c)
/** RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PD : R/W; bitpos: [1]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PD    (BIT(1))
#define RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PD_M  (RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PD_V << RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PD_S)
#define RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PD_V  0x00000001U
#define RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PD_S  1
/** RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PU : R/W; bitpos: [2]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PU    (BIT(2))
#define RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PU_M  (RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PU_V << RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PU_S)
#define RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PU_V  0x00000001U
#define RTC_CNTL_MEM_REGULATOR_SLP_FORCE_PU_S  2
/** RTC_CNTL_DG_VDD_DRV_B_SLP : R/W; bitpos: [26:3]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_VDD_DRV_B_SLP    0x00FFFFFFU
#define RTC_CNTL_DG_VDD_DRV_B_SLP_M  (RTC_CNTL_DG_VDD_DRV_B_SLP_V << RTC_CNTL_DG_VDD_DRV_B_SLP_S)
#define RTC_CNTL_DG_VDD_DRV_B_SLP_V  0x00FFFFFFU
#define RTC_CNTL_DG_VDD_DRV_B_SLP_S  3
/** RTC_CNTL_DG_VDD_DRV_B_SLP_EN : R/W; bitpos: [27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_VDD_DRV_B_SLP_EN    (BIT(27))
#define RTC_CNTL_DG_VDD_DRV_B_SLP_EN_M  (RTC_CNTL_DG_VDD_DRV_B_SLP_EN_V << RTC_CNTL_DG_VDD_DRV_B_SLP_EN_S)
#define RTC_CNTL_DG_VDD_DRV_B_SLP_EN_V  0x00000001U
#define RTC_CNTL_DG_VDD_DRV_B_SLP_EN_S  27
/** RTC_CNTL_DG_REGULATOR_SLP_FORCE_PD : R/W; bitpos: [28]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_REGULATOR_SLP_FORCE_PD    (BIT(28))
#define RTC_CNTL_DG_REGULATOR_SLP_FORCE_PD_M  (RTC_CNTL_DG_REGULATOR_SLP_FORCE_PD_V << RTC_CNTL_DG_REGULATOR_SLP_FORCE_PD_S)
#define RTC_CNTL_DG_REGULATOR_SLP_FORCE_PD_V  0x00000001U
#define RTC_CNTL_DG_REGULATOR_SLP_FORCE_PD_S  28
/** RTC_CNTL_DG_REGULATOR_SLP_FORCE_PU : R/W; bitpos: [29]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DG_REGULATOR_SLP_FORCE_PU    (BIT(29))
#define RTC_CNTL_DG_REGULATOR_SLP_FORCE_PU_M  (RTC_CNTL_DG_REGULATOR_SLP_FORCE_PU_V << RTC_CNTL_DG_REGULATOR_SLP_FORCE_PU_S)
#define RTC_CNTL_DG_REGULATOR_SLP_FORCE_PU_V  0x00000001U
#define RTC_CNTL_DG_REGULATOR_SLP_FORCE_PU_S  29
/** RTC_CNTL_DG_REGULATOR_FORCE_PD : R/W; bitpos: [30]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_REGULATOR_FORCE_PD    (BIT(30))
#define RTC_CNTL_DG_REGULATOR_FORCE_PD_M  (RTC_CNTL_DG_REGULATOR_FORCE_PD_V << RTC_CNTL_DG_REGULATOR_FORCE_PD_S)
#define RTC_CNTL_DG_REGULATOR_FORCE_PD_V  0x00000001U
#define RTC_CNTL_DG_REGULATOR_FORCE_PD_S  30
/** RTC_CNTL_DG_REGULATOR_FORCE_PU : R/W; bitpos: [31]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DG_REGULATOR_FORCE_PU    (BIT(31))
#define RTC_CNTL_DG_REGULATOR_FORCE_PU_M  (RTC_CNTL_DG_REGULATOR_FORCE_PU_V << RTC_CNTL_DG_REGULATOR_FORCE_PU_S)
#define RTC_CNTL_DG_REGULATOR_FORCE_PU_V  0x00000001U
#define RTC_CNTL_DG_REGULATOR_FORCE_PU_S  31

/** RTC_CNTL_DIG_REGULATOR_DRVB_REG register
 *  register description
 */
#define RTC_CNTL_DIG_REGULATOR_DRVB_REG (DR_REG_RTCCNTL_BASE + 0x90)
/** RTC_CNTL_DG_VDD_DRV_B_ACTIVE : R/W; bitpos: [23:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_VDD_DRV_B_ACTIVE    0x00FFFFFFU
#define RTC_CNTL_DG_VDD_DRV_B_ACTIVE_M  (RTC_CNTL_DG_VDD_DRV_B_ACTIVE_V << RTC_CNTL_DG_VDD_DRV_B_ACTIVE_S)
#define RTC_CNTL_DG_VDD_DRV_B_ACTIVE_V  0x00FFFFFFU
#define RTC_CNTL_DG_VDD_DRV_B_ACTIVE_S  0

/** RTC_CNTL_DIG_REGULATOR0_DBIAS_REG register
 *  register description
 */
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_REG (DR_REG_RTCCNTL_BASE + 0x94)
/** RTC_CNTL_PVT_DIG_DBIAS : RO; bitpos: [19:15]; default: 20;
 *  get pvt dbias value
 */
#define RTC_CNTL_PVT_DIG_DBIAS    0x0000001FU
#define RTC_CNTL_PVT_DIG_DBIAS_M  (RTC_CNTL_PVT_DIG_DBIAS_V << RTC_CNTL_PVT_DIG_DBIAS_S)
#define RTC_CNTL_PVT_DIG_DBIAS_V  0x0000001FU
#define RTC_CNTL_PVT_DIG_DBIAS_S  15
/** RTC_CNTL_DIG_REGULATOR0_DBIAS_SLP : R/W; bitpos: [24:20]; default: 20;
 *  the dig regulator0 dbias when chip in sleep state
 */
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_SLP    0x0000001FU
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_SLP_M  (RTC_CNTL_DIG_REGULATOR0_DBIAS_SLP_V << RTC_CNTL_DIG_REGULATOR0_DBIAS_SLP_S)
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_SLP_V  0x0000001FU
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_SLP_S  20
/** RTC_CNTL_DIG_REGULATOR0_DBIAS_ACTIVE : R/W; bitpos: [29:25]; default: 20;
 *  the dig regulator0 dbias when chip in active state
 */
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_ACTIVE    0x0000001FU
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_ACTIVE_M  (RTC_CNTL_DIG_REGULATOR0_DBIAS_ACTIVE_V << RTC_CNTL_DIG_REGULATOR0_DBIAS_ACTIVE_S)
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_ACTIVE_V  0x0000001FU
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_ACTIVE_S  25
/** RTC_CNTL_DIG_REGULATOR0_DBIAS_INIT : WO; bitpos: [30]; default: 0;
 *  initial pvt dbias value
 */
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_INIT    (BIT(30))
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_INIT_M  (RTC_CNTL_DIG_REGULATOR0_DBIAS_INIT_V << RTC_CNTL_DIG_REGULATOR0_DBIAS_INIT_S)
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_INIT_V  0x00000001U
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_INIT_S  30
/** RTC_CNTL_DIG_REGULATOR0_DBIAS_SEL : R/W; bitpos: [31]; default: 1;
 *  1: select sw dbias_active 0: select pvt value
 */
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_SEL    (BIT(31))
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_SEL_M  (RTC_CNTL_DIG_REGULATOR0_DBIAS_SEL_V << RTC_CNTL_DIG_REGULATOR0_DBIAS_SEL_S)
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_SEL_V  0x00000001U
#define RTC_CNTL_DIG_REGULATOR0_DBIAS_SEL_S  31

/** RTC_CNTL_DIG_REGULATOR1_DBIAS_REG register
 *  register description
 */
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_REG (DR_REG_RTCCNTL_BASE + 0x98)
/** RTC_CNTL_MEM_REGULATOR1_DBIAS_SLP : R/W; bitpos: [15:12]; default: 8;
 *  Need add description
 */
#define RTC_CNTL_MEM_REGULATOR1_DBIAS_SLP    0x0000000FU
#define RTC_CNTL_MEM_REGULATOR1_DBIAS_SLP_M  (RTC_CNTL_MEM_REGULATOR1_DBIAS_SLP_V << RTC_CNTL_MEM_REGULATOR1_DBIAS_SLP_S)
#define RTC_CNTL_MEM_REGULATOR1_DBIAS_SLP_V  0x0000000FU
#define RTC_CNTL_MEM_REGULATOR1_DBIAS_SLP_S  12
/** RTC_CNTL_MEM_REGULATOR1_DBIAS_ACTIVE : R/W; bitpos: [19:16]; default: 8;
 *  Need add description
 */
#define RTC_CNTL_MEM_REGULATOR1_DBIAS_ACTIVE    0x0000000FU
#define RTC_CNTL_MEM_REGULATOR1_DBIAS_ACTIVE_M  (RTC_CNTL_MEM_REGULATOR1_DBIAS_ACTIVE_V << RTC_CNTL_MEM_REGULATOR1_DBIAS_ACTIVE_S)
#define RTC_CNTL_MEM_REGULATOR1_DBIAS_ACTIVE_V  0x0000000FU
#define RTC_CNTL_MEM_REGULATOR1_DBIAS_ACTIVE_S  16
/** RTC_CNTL_DIG_REGULATOR1_DBIAS_SLP : R/W; bitpos: [23:20]; default: 8;
 *  the dig regulator1 dbias when chip in sleep state
 */
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_SLP    0x0000000FU
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_SLP_M  (RTC_CNTL_DIG_REGULATOR1_DBIAS_SLP_V << RTC_CNTL_DIG_REGULATOR1_DBIAS_SLP_S)
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_SLP_V  0x0000000FU
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_SLP_S  20
/** RTC_CNTL_DIG_REGULATOR1_DBIAS_ACTIVE : R/W; bitpos: [28:25]; default: 8;
 *  the dig regulator1 dbias when chip in active state
 */
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_ACTIVE    0x0000000FU
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_ACTIVE_M  (RTC_CNTL_DIG_REGULATOR1_DBIAS_ACTIVE_V << RTC_CNTL_DIG_REGULATOR1_DBIAS_ACTIVE_S)
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_ACTIVE_V  0x0000000FU
#define RTC_CNTL_DIG_REGULATOR1_DBIAS_ACTIVE_S  25

/** RTC_CNTL_PWC_REG register
 *  register description
 */
#define RTC_CNTL_PWC_REG (DR_REG_RTCCNTL_BASE + 0x9c)
/** RTC_CNTL_PAD_FORCE_HOLD : R/W; bitpos: [21]; default: 0;
 *  rtc pad force hold
 */
#define RTC_CNTL_PAD_FORCE_HOLD    (BIT(21))
#define RTC_CNTL_PAD_FORCE_HOLD_M  (RTC_CNTL_PAD_FORCE_HOLD_V << RTC_CNTL_PAD_FORCE_HOLD_S)
#define RTC_CNTL_PAD_FORCE_HOLD_V  0x00000001U
#define RTC_CNTL_PAD_FORCE_HOLD_S  21

/** RTC_CNTL_DIG_PWC_REG register
 *  register description
 */
#define RTC_CNTL_DIG_PWC_REG (DR_REG_RTCCNTL_BASE + 0xa0)
/** RTC_CNTL_VDD_SPI_PWR_DRV : R/W; bitpos: [1:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VDD_SPI_PWR_DRV    0x00000003U
#define RTC_CNTL_VDD_SPI_PWR_DRV_M  (RTC_CNTL_VDD_SPI_PWR_DRV_V << RTC_CNTL_VDD_SPI_PWR_DRV_S)
#define RTC_CNTL_VDD_SPI_PWR_DRV_V  0x00000003U
#define RTC_CNTL_VDD_SPI_PWR_DRV_S  0
/** RTC_CNTL_VDD_SPI_PWR_FORCE : R/W; bitpos: [2]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VDD_SPI_PWR_FORCE    (BIT(2))
#define RTC_CNTL_VDD_SPI_PWR_FORCE_M  (RTC_CNTL_VDD_SPI_PWR_FORCE_V << RTC_CNTL_VDD_SPI_PWR_FORCE_S)
#define RTC_CNTL_VDD_SPI_PWR_FORCE_V  0x00000001U
#define RTC_CNTL_VDD_SPI_PWR_FORCE_S  2
/** RTC_CNTL_LSLP_MEM_FORCE_PD : R/W; bitpos: [3]; default: 0;
 *  memories in digital core force PD in sleep
 */
#define RTC_CNTL_LSLP_MEM_FORCE_PD    (BIT(3))
#define RTC_CNTL_LSLP_MEM_FORCE_PD_M  (RTC_CNTL_LSLP_MEM_FORCE_PD_V << RTC_CNTL_LSLP_MEM_FORCE_PD_S)
#define RTC_CNTL_LSLP_MEM_FORCE_PD_V  0x00000001U
#define RTC_CNTL_LSLP_MEM_FORCE_PD_S  3
/** RTC_CNTL_LSLP_MEM_FORCE_PU : R/W; bitpos: [4]; default: 1;
 *  memories in digital core force no PD in sleep
 */
#define RTC_CNTL_LSLP_MEM_FORCE_PU    (BIT(4))
#define RTC_CNTL_LSLP_MEM_FORCE_PU_M  (RTC_CNTL_LSLP_MEM_FORCE_PU_V << RTC_CNTL_LSLP_MEM_FORCE_PU_S)
#define RTC_CNTL_LSLP_MEM_FORCE_PU_V  0x00000001U
#define RTC_CNTL_LSLP_MEM_FORCE_PU_S  4
/** RTC_CNTL_DG_MEM_FORCE_PD : R/W; bitpos: [7]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_MEM_FORCE_PD    (BIT(7))
#define RTC_CNTL_DG_MEM_FORCE_PD_M  (RTC_CNTL_DG_MEM_FORCE_PD_V << RTC_CNTL_DG_MEM_FORCE_PD_S)
#define RTC_CNTL_DG_MEM_FORCE_PD_V  0x00000001U
#define RTC_CNTL_DG_MEM_FORCE_PD_S  7
/** RTC_CNTL_DG_MEM_FORCE_PU : R/W; bitpos: [8]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DG_MEM_FORCE_PU    (BIT(8))
#define RTC_CNTL_DG_MEM_FORCE_PU_M  (RTC_CNTL_DG_MEM_FORCE_PU_V << RTC_CNTL_DG_MEM_FORCE_PU_S)
#define RTC_CNTL_DG_MEM_FORCE_PU_V  0x00000001U
#define RTC_CNTL_DG_MEM_FORCE_PU_S  8
/** RTC_CNTL_DG_WRAP_FORCE_PD : R/W; bitpos: [9]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_WRAP_FORCE_PD    (BIT(9))
#define RTC_CNTL_DG_WRAP_FORCE_PD_M  (RTC_CNTL_DG_WRAP_FORCE_PD_V << RTC_CNTL_DG_WRAP_FORCE_PD_S)
#define RTC_CNTL_DG_WRAP_FORCE_PD_V  0x00000001U
#define RTC_CNTL_DG_WRAP_FORCE_PD_S  9
/** RTC_CNTL_DG_WRAP_FORCE_PU : R/W; bitpos: [10]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DG_WRAP_FORCE_PU    (BIT(10))
#define RTC_CNTL_DG_WRAP_FORCE_PU_M  (RTC_CNTL_DG_WRAP_FORCE_PU_V << RTC_CNTL_DG_WRAP_FORCE_PU_S)
#define RTC_CNTL_DG_WRAP_FORCE_PU_V  0x00000001U
#define RTC_CNTL_DG_WRAP_FORCE_PU_S  10
/** RTC_CNTL_BT_FORCE_PD : R/W; bitpos: [11]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BT_FORCE_PD    (BIT(11))
#define RTC_CNTL_BT_FORCE_PD_M  (RTC_CNTL_BT_FORCE_PD_V << RTC_CNTL_BT_FORCE_PD_S)
#define RTC_CNTL_BT_FORCE_PD_V  0x00000001U
#define RTC_CNTL_BT_FORCE_PD_S  11
/** RTC_CNTL_BT_FORCE_PU : R/W; bitpos: [12]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_BT_FORCE_PU    (BIT(12))
#define RTC_CNTL_BT_FORCE_PU_M  (RTC_CNTL_BT_FORCE_PU_V << RTC_CNTL_BT_FORCE_PU_S)
#define RTC_CNTL_BT_FORCE_PU_V  0x00000001U
#define RTC_CNTL_BT_FORCE_PU_S  12
/** RTC_CNTL_DG_PERI_FORCE_PD : R/W; bitpos: [13]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_PERI_FORCE_PD    (BIT(13))
#define RTC_CNTL_DG_PERI_FORCE_PD_M  (RTC_CNTL_DG_PERI_FORCE_PD_V << RTC_CNTL_DG_PERI_FORCE_PD_S)
#define RTC_CNTL_DG_PERI_FORCE_PD_V  0x00000001U
#define RTC_CNTL_DG_PERI_FORCE_PD_S  13
/** RTC_CNTL_DG_PERI_FORCE_PU : R/W; bitpos: [14]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DG_PERI_FORCE_PU    (BIT(14))
#define RTC_CNTL_DG_PERI_FORCE_PU_M  (RTC_CNTL_DG_PERI_FORCE_PU_V << RTC_CNTL_DG_PERI_FORCE_PU_S)
#define RTC_CNTL_DG_PERI_FORCE_PU_V  0x00000001U
#define RTC_CNTL_DG_PERI_FORCE_PU_S  14
/** RTC_CNTL_FASTMEM_FORCE_LPD : R/W; bitpos: [15]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_FASTMEM_FORCE_LPD    (BIT(15))
#define RTC_CNTL_FASTMEM_FORCE_LPD_M  (RTC_CNTL_FASTMEM_FORCE_LPD_V << RTC_CNTL_FASTMEM_FORCE_LPD_S)
#define RTC_CNTL_FASTMEM_FORCE_LPD_V  0x00000001U
#define RTC_CNTL_FASTMEM_FORCE_LPD_S  15
/** RTC_CNTL_FASTMEM_FORCE_LPU : R/W; bitpos: [16]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_FASTMEM_FORCE_LPU    (BIT(16))
#define RTC_CNTL_FASTMEM_FORCE_LPU_M  (RTC_CNTL_FASTMEM_FORCE_LPU_V << RTC_CNTL_FASTMEM_FORCE_LPU_S)
#define RTC_CNTL_FASTMEM_FORCE_LPU_V  0x00000001U
#define RTC_CNTL_FASTMEM_FORCE_LPU_S  16
/** RTC_CNTL_WIFI_FORCE_PD : R/W; bitpos: [17]; default: 0;
 *  wifi force power down
 */
#define RTC_CNTL_WIFI_FORCE_PD    (BIT(17))
#define RTC_CNTL_WIFI_FORCE_PD_M  (RTC_CNTL_WIFI_FORCE_PD_V << RTC_CNTL_WIFI_FORCE_PD_S)
#define RTC_CNTL_WIFI_FORCE_PD_V  0x00000001U
#define RTC_CNTL_WIFI_FORCE_PD_S  17
/** RTC_CNTL_WIFI_FORCE_PU : R/W; bitpos: [18]; default: 1;
 *  wifi force power up
 */
#define RTC_CNTL_WIFI_FORCE_PU    (BIT(18))
#define RTC_CNTL_WIFI_FORCE_PU_M  (RTC_CNTL_WIFI_FORCE_PU_V << RTC_CNTL_WIFI_FORCE_PU_S)
#define RTC_CNTL_WIFI_FORCE_PU_V  0x00000001U
#define RTC_CNTL_WIFI_FORCE_PU_S  18
/** RTC_CNTL_CPU_TOP_FORCE_PD : R/W; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_CPU_TOP_FORCE_PD    (BIT(21))
#define RTC_CNTL_CPU_TOP_FORCE_PD_M  (RTC_CNTL_CPU_TOP_FORCE_PD_V << RTC_CNTL_CPU_TOP_FORCE_PD_S)
#define RTC_CNTL_CPU_TOP_FORCE_PD_V  0x00000001U
#define RTC_CNTL_CPU_TOP_FORCE_PD_S  21
/** RTC_CNTL_CPU_TOP_FORCE_PU : R/W; bitpos: [22]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_CPU_TOP_FORCE_PU    (BIT(22))
#define RTC_CNTL_CPU_TOP_FORCE_PU_M  (RTC_CNTL_CPU_TOP_FORCE_PU_V << RTC_CNTL_CPU_TOP_FORCE_PU_S)
#define RTC_CNTL_CPU_TOP_FORCE_PU_V  0x00000001U
#define RTC_CNTL_CPU_TOP_FORCE_PU_S  22
/** RTC_CNTL_DG_WRAP_RET_PD_EN : R/W; bitpos: [26]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_WRAP_RET_PD_EN    (BIT(26))
#define RTC_CNTL_DG_WRAP_RET_PD_EN_M  (RTC_CNTL_DG_WRAP_RET_PD_EN_V << RTC_CNTL_DG_WRAP_RET_PD_EN_S)
#define RTC_CNTL_DG_WRAP_RET_PD_EN_V  0x00000001U
#define RTC_CNTL_DG_WRAP_RET_PD_EN_S  26
/** RTC_CNTL_BT_PD_EN : R/W; bitpos: [27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BT_PD_EN    (BIT(27))
#define RTC_CNTL_BT_PD_EN_M  (RTC_CNTL_BT_PD_EN_V << RTC_CNTL_BT_PD_EN_S)
#define RTC_CNTL_BT_PD_EN_V  0x00000001U
#define RTC_CNTL_BT_PD_EN_S  27
/** RTC_CNTL_DG_PERI_PD_EN : R/W; bitpos: [28]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_PERI_PD_EN    (BIT(28))
#define RTC_CNTL_DG_PERI_PD_EN_M  (RTC_CNTL_DG_PERI_PD_EN_V << RTC_CNTL_DG_PERI_PD_EN_S)
#define RTC_CNTL_DG_PERI_PD_EN_V  0x00000001U
#define RTC_CNTL_DG_PERI_PD_EN_S  28
/** RTC_CNTL_CPU_TOP_PD_EN : R/W; bitpos: [29]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_CPU_TOP_PD_EN    (BIT(29))
#define RTC_CNTL_CPU_TOP_PD_EN_M  (RTC_CNTL_CPU_TOP_PD_EN_V << RTC_CNTL_CPU_TOP_PD_EN_S)
#define RTC_CNTL_CPU_TOP_PD_EN_V  0x00000001U
#define RTC_CNTL_CPU_TOP_PD_EN_S  29
/** RTC_CNTL_WIFI_PD_EN : R/W; bitpos: [30]; default: 0;
 *  enable power down wifi in sleep
 */
#define RTC_CNTL_WIFI_PD_EN    (BIT(30))
#define RTC_CNTL_WIFI_PD_EN_M  (RTC_CNTL_WIFI_PD_EN_V << RTC_CNTL_WIFI_PD_EN_S)
#define RTC_CNTL_WIFI_PD_EN_V  0x00000001U
#define RTC_CNTL_WIFI_PD_EN_S  30
/** RTC_CNTL_DG_WRAP_PD_EN : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_WRAP_PD_EN    (BIT(31))
#define RTC_CNTL_DG_WRAP_PD_EN_M  (RTC_CNTL_DG_WRAP_PD_EN_V << RTC_CNTL_DG_WRAP_PD_EN_S)
#define RTC_CNTL_DG_WRAP_PD_EN_V  0x00000001U
#define RTC_CNTL_DG_WRAP_PD_EN_S  31

/** RTC_CNTL_DIG_POWER_SLAVE0_PD_REG register
 *  register description
 */
#define RTC_CNTL_DIG_POWER_SLAVE0_PD_REG (DR_REG_RTCCNTL_BASE + 0xa4)
/** RTC_CNTL_PD_DG_PERI_SWITCH_MASK : R/W; bitpos: [6:2]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_PD_DG_PERI_SWITCH_MASK    0x0000001FU
#define RTC_CNTL_PD_DG_PERI_SWITCH_MASK_M  (RTC_CNTL_PD_DG_PERI_SWITCH_MASK_V << RTC_CNTL_PD_DG_PERI_SWITCH_MASK_S)
#define RTC_CNTL_PD_DG_PERI_SWITCH_MASK_V  0x0000001FU
#define RTC_CNTL_PD_DG_PERI_SWITCH_MASK_S  2
/** RTC_CNTL_PD_DG_WRAP_SWITCH_MASK : R/W; bitpos: [11:7]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_PD_DG_WRAP_SWITCH_MASK    0x0000001FU
#define RTC_CNTL_PD_DG_WRAP_SWITCH_MASK_M  (RTC_CNTL_PD_DG_WRAP_SWITCH_MASK_V << RTC_CNTL_PD_DG_WRAP_SWITCH_MASK_S)
#define RTC_CNTL_PD_DG_WRAP_SWITCH_MASK_V  0x0000001FU
#define RTC_CNTL_PD_DG_WRAP_SWITCH_MASK_S  7
/** RTC_CNTL_PD_MEM_SWITCH_MASK : R/W; bitpos: [31:12]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_PD_MEM_SWITCH_MASK    0x000FFFFFU
#define RTC_CNTL_PD_MEM_SWITCH_MASK_M  (RTC_CNTL_PD_MEM_SWITCH_MASK_V << RTC_CNTL_PD_MEM_SWITCH_MASK_S)
#define RTC_CNTL_PD_MEM_SWITCH_MASK_V  0x000FFFFFU
#define RTC_CNTL_PD_MEM_SWITCH_MASK_S  12

/** RTC_CNTL_DIG_POWER_SLAVE1_PD_REG register
 *  register description
 */
#define RTC_CNTL_DIG_POWER_SLAVE1_PD_REG (DR_REG_RTCCNTL_BASE + 0xa8)
/** RTC_CNTL_PD_WIFI_SWITCH_MASK : R/W; bitpos: [26:22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_PD_WIFI_SWITCH_MASK    0x0000001FU
#define RTC_CNTL_PD_WIFI_SWITCH_MASK_M  (RTC_CNTL_PD_WIFI_SWITCH_MASK_V << RTC_CNTL_PD_WIFI_SWITCH_MASK_S)
#define RTC_CNTL_PD_WIFI_SWITCH_MASK_V  0x0000001FU
#define RTC_CNTL_PD_WIFI_SWITCH_MASK_S  22
/** RTC_CNTL_PD_CPU_SWITCH_MASK : R/W; bitpos: [31:27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_PD_CPU_SWITCH_MASK    0x0000001FU
#define RTC_CNTL_PD_CPU_SWITCH_MASK_M  (RTC_CNTL_PD_CPU_SWITCH_MASK_V << RTC_CNTL_PD_CPU_SWITCH_MASK_S)
#define RTC_CNTL_PD_CPU_SWITCH_MASK_V  0x0000001FU
#define RTC_CNTL_PD_CPU_SWITCH_MASK_S  27

/** RTC_CNTL_DIG_POWER_SLAVE0_FPU_REG register
 *  register description
 */
#define RTC_CNTL_DIG_POWER_SLAVE0_FPU_REG (DR_REG_RTCCNTL_BASE + 0xac)
/** RTC_CNTL_XPD_DG_PERI_SWITCH_MASK : R/W; bitpos: [6:2]; default: 31;
 *  Need add description
 */
#define RTC_CNTL_XPD_DG_PERI_SWITCH_MASK    0x0000001FU
#define RTC_CNTL_XPD_DG_PERI_SWITCH_MASK_M  (RTC_CNTL_XPD_DG_PERI_SWITCH_MASK_V << RTC_CNTL_XPD_DG_PERI_SWITCH_MASK_S)
#define RTC_CNTL_XPD_DG_PERI_SWITCH_MASK_V  0x0000001FU
#define RTC_CNTL_XPD_DG_PERI_SWITCH_MASK_S  2
/** RTC_CNTL_XPD_DG_WRAP_SWITCH_MASK : R/W; bitpos: [11:7]; default: 31;
 *  Need add description
 */
#define RTC_CNTL_XPD_DG_WRAP_SWITCH_MASK    0x0000001FU
#define RTC_CNTL_XPD_DG_WRAP_SWITCH_MASK_M  (RTC_CNTL_XPD_DG_WRAP_SWITCH_MASK_V << RTC_CNTL_XPD_DG_WRAP_SWITCH_MASK_S)
#define RTC_CNTL_XPD_DG_WRAP_SWITCH_MASK_V  0x0000001FU
#define RTC_CNTL_XPD_DG_WRAP_SWITCH_MASK_S  7
/** RTC_CNTL_XPD_MEM_SWITCH_MASK : R/W; bitpos: [31:12]; default: 1048575;
 *  Need add description
 */
#define RTC_CNTL_XPD_MEM_SWITCH_MASK    0x000FFFFFU
#define RTC_CNTL_XPD_MEM_SWITCH_MASK_M  (RTC_CNTL_XPD_MEM_SWITCH_MASK_V << RTC_CNTL_XPD_MEM_SWITCH_MASK_S)
#define RTC_CNTL_XPD_MEM_SWITCH_MASK_V  0x000FFFFFU
#define RTC_CNTL_XPD_MEM_SWITCH_MASK_S  12

/** RTC_CNTL_DIG_POWER_SLAVE1_FPU_REG register
 *  register description
 */
#define RTC_CNTL_DIG_POWER_SLAVE1_FPU_REG (DR_REG_RTCCNTL_BASE + 0xb0)
/** RTC_CNTL_XPD_WIFI_SWITCH_MASK : R/W; bitpos: [26:22]; default: 31;
 *  Need add description
 */
#define RTC_CNTL_XPD_WIFI_SWITCH_MASK    0x0000001FU
#define RTC_CNTL_XPD_WIFI_SWITCH_MASK_M  (RTC_CNTL_XPD_WIFI_SWITCH_MASK_V << RTC_CNTL_XPD_WIFI_SWITCH_MASK_S)
#define RTC_CNTL_XPD_WIFI_SWITCH_MASK_V  0x0000001FU
#define RTC_CNTL_XPD_WIFI_SWITCH_MASK_S  22
/** RTC_CNTL_XPD_CPU_SWITCH_MASK : R/W; bitpos: [31:27]; default: 31;
 *  Need add description
 */
#define RTC_CNTL_XPD_CPU_SWITCH_MASK    0x0000001FU
#define RTC_CNTL_XPD_CPU_SWITCH_MASK_M  (RTC_CNTL_XPD_CPU_SWITCH_MASK_V << RTC_CNTL_XPD_CPU_SWITCH_MASK_S)
#define RTC_CNTL_XPD_CPU_SWITCH_MASK_V  0x0000001FU
#define RTC_CNTL_XPD_CPU_SWITCH_MASK_S  27

/** RTC_CNTL_DIG_ISO_REG register
 *  register description
 */
#define RTC_CNTL_DIG_ISO_REG (DR_REG_RTCCNTL_BASE + 0xb4)
/** RTC_CNTL_DG_MEM_FORCE_NOISO : R/W; bitpos: [5]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DG_MEM_FORCE_NOISO    (BIT(5))
#define RTC_CNTL_DG_MEM_FORCE_NOISO_M  (RTC_CNTL_DG_MEM_FORCE_NOISO_V << RTC_CNTL_DG_MEM_FORCE_NOISO_S)
#define RTC_CNTL_DG_MEM_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_DG_MEM_FORCE_NOISO_S  5
/** RTC_CNTL_DG_MEM_FORCE_ISO : R/W; bitpos: [6]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_MEM_FORCE_ISO    (BIT(6))
#define RTC_CNTL_DG_MEM_FORCE_ISO_M  (RTC_CNTL_DG_MEM_FORCE_ISO_V << RTC_CNTL_DG_MEM_FORCE_ISO_S)
#define RTC_CNTL_DG_MEM_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_DG_MEM_FORCE_ISO_S  6
/** RTC_CNTL_DIG_ISO_FORCE_OFF : R/W; bitpos: [7]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DIG_ISO_FORCE_OFF    (BIT(7))
#define RTC_CNTL_DIG_ISO_FORCE_OFF_M  (RTC_CNTL_DIG_ISO_FORCE_OFF_V << RTC_CNTL_DIG_ISO_FORCE_OFF_S)
#define RTC_CNTL_DIG_ISO_FORCE_OFF_V  0x00000001U
#define RTC_CNTL_DIG_ISO_FORCE_OFF_S  7
/** RTC_CNTL_DIG_ISO_FORCE_ON : R/W; bitpos: [8]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DIG_ISO_FORCE_ON    (BIT(8))
#define RTC_CNTL_DIG_ISO_FORCE_ON_M  (RTC_CNTL_DIG_ISO_FORCE_ON_V << RTC_CNTL_DIG_ISO_FORCE_ON_S)
#define RTC_CNTL_DIG_ISO_FORCE_ON_V  0x00000001U
#define RTC_CNTL_DIG_ISO_FORCE_ON_S  8
/** RTC_CNTL_DG_PAD_AUTOHOLD : RO; bitpos: [9]; default: 0;
 *  read only register to indicate digital pad auto-hold status
 */
#define RTC_CNTL_DG_PAD_AUTOHOLD    (BIT(9))
#define RTC_CNTL_DG_PAD_AUTOHOLD_M  (RTC_CNTL_DG_PAD_AUTOHOLD_V << RTC_CNTL_DG_PAD_AUTOHOLD_S)
#define RTC_CNTL_DG_PAD_AUTOHOLD_V  0x00000001U
#define RTC_CNTL_DG_PAD_AUTOHOLD_S  9
/** RTC_CNTL_CLR_DG_PAD_AUTOHOLD : WO; bitpos: [10]; default: 0;
 *  wtite only register to clear digital pad auto-hold
 */
#define RTC_CNTL_CLR_DG_PAD_AUTOHOLD    (BIT(10))
#define RTC_CNTL_CLR_DG_PAD_AUTOHOLD_M  (RTC_CNTL_CLR_DG_PAD_AUTOHOLD_V << RTC_CNTL_CLR_DG_PAD_AUTOHOLD_S)
#define RTC_CNTL_CLR_DG_PAD_AUTOHOLD_V  0x00000001U
#define RTC_CNTL_CLR_DG_PAD_AUTOHOLD_S  10
/** RTC_CNTL_DG_PAD_AUTOHOLD_EN : R/W; bitpos: [11]; default: 0;
 *  digital pad enable auto-hold
 */
#define RTC_CNTL_DG_PAD_AUTOHOLD_EN    (BIT(11))
#define RTC_CNTL_DG_PAD_AUTOHOLD_EN_M  (RTC_CNTL_DG_PAD_AUTOHOLD_EN_V << RTC_CNTL_DG_PAD_AUTOHOLD_EN_S)
#define RTC_CNTL_DG_PAD_AUTOHOLD_EN_V  0x00000001U
#define RTC_CNTL_DG_PAD_AUTOHOLD_EN_S  11
/** RTC_CNTL_DG_PAD_FORCE_NOISO : R/W; bitpos: [12]; default: 1;
 *  digital pad force no ISO
 */
#define RTC_CNTL_DG_PAD_FORCE_NOISO    (BIT(12))
#define RTC_CNTL_DG_PAD_FORCE_NOISO_M  (RTC_CNTL_DG_PAD_FORCE_NOISO_V << RTC_CNTL_DG_PAD_FORCE_NOISO_S)
#define RTC_CNTL_DG_PAD_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_DG_PAD_FORCE_NOISO_S  12
/** RTC_CNTL_DG_PAD_FORCE_ISO : R/W; bitpos: [13]; default: 0;
 *  digital pad force ISO
 */
#define RTC_CNTL_DG_PAD_FORCE_ISO    (BIT(13))
#define RTC_CNTL_DG_PAD_FORCE_ISO_M  (RTC_CNTL_DG_PAD_FORCE_ISO_V << RTC_CNTL_DG_PAD_FORCE_ISO_S)
#define RTC_CNTL_DG_PAD_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_DG_PAD_FORCE_ISO_S  13
/** RTC_CNTL_DG_PAD_FORCE_UNHOLD : R/W; bitpos: [14]; default: 1;
 *  digital pad force un-hold
 */
#define RTC_CNTL_DG_PAD_FORCE_UNHOLD    (BIT(14))
#define RTC_CNTL_DG_PAD_FORCE_UNHOLD_M  (RTC_CNTL_DG_PAD_FORCE_UNHOLD_V << RTC_CNTL_DG_PAD_FORCE_UNHOLD_S)
#define RTC_CNTL_DG_PAD_FORCE_UNHOLD_V  0x00000001U
#define RTC_CNTL_DG_PAD_FORCE_UNHOLD_S  14
/** RTC_CNTL_DG_PAD_FORCE_HOLD : R/W; bitpos: [15]; default: 0;
 *  digital pad force hold
 */
#define RTC_CNTL_DG_PAD_FORCE_HOLD    (BIT(15))
#define RTC_CNTL_DG_PAD_FORCE_HOLD_M  (RTC_CNTL_DG_PAD_FORCE_HOLD_V << RTC_CNTL_DG_PAD_FORCE_HOLD_S)
#define RTC_CNTL_DG_PAD_FORCE_HOLD_V  0x00000001U
#define RTC_CNTL_DG_PAD_FORCE_HOLD_S  15
/** RTC_CNTL_BT_FORCE_ISO : R/W; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BT_FORCE_ISO    (BIT(22))
#define RTC_CNTL_BT_FORCE_ISO_M  (RTC_CNTL_BT_FORCE_ISO_V << RTC_CNTL_BT_FORCE_ISO_S)
#define RTC_CNTL_BT_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_BT_FORCE_ISO_S  22
/** RTC_CNTL_BT_FORCE_NOISO : R/W; bitpos: [23]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_BT_FORCE_NOISO    (BIT(23))
#define RTC_CNTL_BT_FORCE_NOISO_M  (RTC_CNTL_BT_FORCE_NOISO_V << RTC_CNTL_BT_FORCE_NOISO_S)
#define RTC_CNTL_BT_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_BT_FORCE_NOISO_S  23
/** RTC_CNTL_DG_PERI_FORCE_ISO : R/W; bitpos: [24]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DG_PERI_FORCE_ISO    (BIT(24))
#define RTC_CNTL_DG_PERI_FORCE_ISO_M  (RTC_CNTL_DG_PERI_FORCE_ISO_V << RTC_CNTL_DG_PERI_FORCE_ISO_S)
#define RTC_CNTL_DG_PERI_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_DG_PERI_FORCE_ISO_S  24
/** RTC_CNTL_DG_PERI_FORCE_NOISO : R/W; bitpos: [25]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DG_PERI_FORCE_NOISO    (BIT(25))
#define RTC_CNTL_DG_PERI_FORCE_NOISO_M  (RTC_CNTL_DG_PERI_FORCE_NOISO_V << RTC_CNTL_DG_PERI_FORCE_NOISO_S)
#define RTC_CNTL_DG_PERI_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_DG_PERI_FORCE_NOISO_S  25
/** RTC_CNTL_CPU_TOP_FORCE_ISO : R/W; bitpos: [26]; default: 0;
 *  cpu force ISO
 */
#define RTC_CNTL_CPU_TOP_FORCE_ISO    (BIT(26))
#define RTC_CNTL_CPU_TOP_FORCE_ISO_M  (RTC_CNTL_CPU_TOP_FORCE_ISO_V << RTC_CNTL_CPU_TOP_FORCE_ISO_S)
#define RTC_CNTL_CPU_TOP_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_CPU_TOP_FORCE_ISO_S  26
/** RTC_CNTL_CPU_TOP_FORCE_NOISO : R/W; bitpos: [27]; default: 1;
 *  cpu force no ISO
 */
#define RTC_CNTL_CPU_TOP_FORCE_NOISO    (BIT(27))
#define RTC_CNTL_CPU_TOP_FORCE_NOISO_M  (RTC_CNTL_CPU_TOP_FORCE_NOISO_V << RTC_CNTL_CPU_TOP_FORCE_NOISO_S)
#define RTC_CNTL_CPU_TOP_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_CPU_TOP_FORCE_NOISO_S  27
/** RTC_CNTL_WIFI_FORCE_ISO : R/W; bitpos: [28]; default: 0;
 *  wifi force ISO
 */
#define RTC_CNTL_WIFI_FORCE_ISO    (BIT(28))
#define RTC_CNTL_WIFI_FORCE_ISO_M  (RTC_CNTL_WIFI_FORCE_ISO_V << RTC_CNTL_WIFI_FORCE_ISO_S)
#define RTC_CNTL_WIFI_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_WIFI_FORCE_ISO_S  28
/** RTC_CNTL_WIFI_FORCE_NOISO : R/W; bitpos: [29]; default: 1;
 *  wifi force no ISO
 */
#define RTC_CNTL_WIFI_FORCE_NOISO    (BIT(29))
#define RTC_CNTL_WIFI_FORCE_NOISO_M  (RTC_CNTL_WIFI_FORCE_NOISO_V << RTC_CNTL_WIFI_FORCE_NOISO_S)
#define RTC_CNTL_WIFI_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_WIFI_FORCE_NOISO_S  29
/** RTC_CNTL_DG_WRAP_FORCE_ISO : R/W; bitpos: [30]; default: 0;
 *  digital core force ISO
 */
#define RTC_CNTL_DG_WRAP_FORCE_ISO    (BIT(30))
#define RTC_CNTL_DG_WRAP_FORCE_ISO_M  (RTC_CNTL_DG_WRAP_FORCE_ISO_V << RTC_CNTL_DG_WRAP_FORCE_ISO_S)
#define RTC_CNTL_DG_WRAP_FORCE_ISO_V  0x00000001U
#define RTC_CNTL_DG_WRAP_FORCE_ISO_S  30
/** RTC_CNTL_DG_WRAP_FORCE_NOISO : R/W; bitpos: [31]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_DG_WRAP_FORCE_NOISO    (BIT(31))
#define RTC_CNTL_DG_WRAP_FORCE_NOISO_M  (RTC_CNTL_DG_WRAP_FORCE_NOISO_V << RTC_CNTL_DG_WRAP_FORCE_NOISO_S)
#define RTC_CNTL_DG_WRAP_FORCE_NOISO_V  0x00000001U
#define RTC_CNTL_DG_WRAP_FORCE_NOISO_S  31

/** RTC_CNTL_WDTCONFIG0_REG register
 *  register description
 */
#define RTC_CNTL_WDTCONFIG0_REG (DR_REG_RTCCNTL_BASE + 0xb8)
/** RTC_CNTL_WDT_CHIP_RESET_WIDTH : R/W; bitpos: [7:0]; default: 20;
 *  chip reset siginal pulse width
 */
#define RTC_CNTL_WDT_CHIP_RESET_WIDTH    0x000000FFU
#define RTC_CNTL_WDT_CHIP_RESET_WIDTH_M  (RTC_CNTL_WDT_CHIP_RESET_WIDTH_V << RTC_CNTL_WDT_CHIP_RESET_WIDTH_S)
#define RTC_CNTL_WDT_CHIP_RESET_WIDTH_V  0x000000FFU
#define RTC_CNTL_WDT_CHIP_RESET_WIDTH_S  0
/** RTC_CNTL_WDT_CHIP_RESET_EN : R/W; bitpos: [8]; default: 0;
 *  wdt reset whole chip enable
 */
#define RTC_CNTL_WDT_CHIP_RESET_EN    (BIT(8))
#define RTC_CNTL_WDT_CHIP_RESET_EN_M  (RTC_CNTL_WDT_CHIP_RESET_EN_V << RTC_CNTL_WDT_CHIP_RESET_EN_S)
#define RTC_CNTL_WDT_CHIP_RESET_EN_V  0x00000001U
#define RTC_CNTL_WDT_CHIP_RESET_EN_S  8
/** RTC_CNTL_WDT_PAUSE_IN_SLP : R/W; bitpos: [9]; default: 1;
 *  pause WDT in sleep
 */
#define RTC_CNTL_WDT_PAUSE_IN_SLP    (BIT(9))
#define RTC_CNTL_WDT_PAUSE_IN_SLP_M  (RTC_CNTL_WDT_PAUSE_IN_SLP_V << RTC_CNTL_WDT_PAUSE_IN_SLP_S)
#define RTC_CNTL_WDT_PAUSE_IN_SLP_V  0x00000001U
#define RTC_CNTL_WDT_PAUSE_IN_SLP_S  9
/** RTC_CNTL_WDT_APPCPU_RESET_EN : R/W; bitpos: [10]; default: 0;
 *  enable WDT reset APP CPU
 */
#define RTC_CNTL_WDT_APPCPU_RESET_EN    (BIT(10))
#define RTC_CNTL_WDT_APPCPU_RESET_EN_M  (RTC_CNTL_WDT_APPCPU_RESET_EN_V << RTC_CNTL_WDT_APPCPU_RESET_EN_S)
#define RTC_CNTL_WDT_APPCPU_RESET_EN_V  0x00000001U
#define RTC_CNTL_WDT_APPCPU_RESET_EN_S  10
/** RTC_CNTL_WDT_PROCPU_RESET_EN : R/W; bitpos: [11]; default: 0;
 *  enable WDT reset PRO CPU
 */
#define RTC_CNTL_WDT_PROCPU_RESET_EN    (BIT(11))
#define RTC_CNTL_WDT_PROCPU_RESET_EN_M  (RTC_CNTL_WDT_PROCPU_RESET_EN_V << RTC_CNTL_WDT_PROCPU_RESET_EN_S)
#define RTC_CNTL_WDT_PROCPU_RESET_EN_V  0x00000001U
#define RTC_CNTL_WDT_PROCPU_RESET_EN_S  11
/** RTC_CNTL_WDT_FLASHBOOT_MOD_EN : R/W; bitpos: [12]; default: 1;
 *  enable WDT in flash boot
 */
#define RTC_CNTL_WDT_FLASHBOOT_MOD_EN    (BIT(12))
#define RTC_CNTL_WDT_FLASHBOOT_MOD_EN_M  (RTC_CNTL_WDT_FLASHBOOT_MOD_EN_V << RTC_CNTL_WDT_FLASHBOOT_MOD_EN_S)
#define RTC_CNTL_WDT_FLASHBOOT_MOD_EN_V  0x00000001U
#define RTC_CNTL_WDT_FLASHBOOT_MOD_EN_S  12
/** RTC_CNTL_WDT_SYS_RESET_LENGTH : R/W; bitpos: [15:13]; default: 1;
 *  system reset counter length
 */
#define RTC_CNTL_WDT_SYS_RESET_LENGTH    0x00000007U
#define RTC_CNTL_WDT_SYS_RESET_LENGTH_M  (RTC_CNTL_WDT_SYS_RESET_LENGTH_V << RTC_CNTL_WDT_SYS_RESET_LENGTH_S)
#define RTC_CNTL_WDT_SYS_RESET_LENGTH_V  0x00000007U
#define RTC_CNTL_WDT_SYS_RESET_LENGTH_S  13
/** RTC_CNTL_WDT_CPU_RESET_LENGTH : R/W; bitpos: [18:16]; default: 1;
 *  CPU reset counter length
 */
#define RTC_CNTL_WDT_CPU_RESET_LENGTH    0x00000007U
#define RTC_CNTL_WDT_CPU_RESET_LENGTH_M  (RTC_CNTL_WDT_CPU_RESET_LENGTH_V << RTC_CNTL_WDT_CPU_RESET_LENGTH_S)
#define RTC_CNTL_WDT_CPU_RESET_LENGTH_V  0x00000007U
#define RTC_CNTL_WDT_CPU_RESET_LENGTH_S  16
/* RTC_CNTL_WDT_STGX : */
/*description: stage action selection values */
#define RTC_WDT_STG_SEL_OFF             0
#define RTC_WDT_STG_SEL_INT             1
#define RTC_WDT_STG_SEL_RESET_CPU       2
#define RTC_WDT_STG_SEL_RESET_SYSTEM    3
#define RTC_WDT_STG_SEL_RESET_RTC       4
/** RTC_CNTL_WDT_STG3 : R/W; bitpos: [21:19]; default: 0;
 *  1: interrupt stage en, 2: CPU reset stage en, 3: system reset stage en, 4: RTC
 *  reset stage en
 */
#define RTC_CNTL_WDT_STG3    0x00000007U
#define RTC_CNTL_WDT_STG3_M  (RTC_CNTL_WDT_STG3_V << RTC_CNTL_WDT_STG3_S)
#define RTC_CNTL_WDT_STG3_V  0x00000007U
#define RTC_CNTL_WDT_STG3_S  19
/** RTC_CNTL_WDT_STG2 : R/W; bitpos: [24:22]; default: 0;
 *  1: interrupt stage en, 2: CPU reset stage en, 3: system reset stage en, 4: RTC
 *  reset stage en
 */
#define RTC_CNTL_WDT_STG2    0x00000007U
#define RTC_CNTL_WDT_STG2_M  (RTC_CNTL_WDT_STG2_V << RTC_CNTL_WDT_STG2_S)
#define RTC_CNTL_WDT_STG2_V  0x00000007U
#define RTC_CNTL_WDT_STG2_S  22
/** RTC_CNTL_WDT_STG1 : R/W; bitpos: [27:25]; default: 0;
 *  1: interrupt stage en, 2: CPU reset stage en, 3: system reset stage en, 4: RTC
 *  reset stage en
 */
#define RTC_CNTL_WDT_STG1    0x00000007U
#define RTC_CNTL_WDT_STG1_M  (RTC_CNTL_WDT_STG1_V << RTC_CNTL_WDT_STG1_S)
#define RTC_CNTL_WDT_STG1_V  0x00000007U
#define RTC_CNTL_WDT_STG1_S  25
/** RTC_CNTL_WDT_STG0 : R/W; bitpos: [30:28]; default: 0;
 *  1: interrupt stage en, 2: CPU reset stage en, 3: system reset stage en, 4: RTC
 *  reset stage en
 */
#define RTC_CNTL_WDT_STG0    0x00000007U
#define RTC_CNTL_WDT_STG0_M  (RTC_CNTL_WDT_STG0_V << RTC_CNTL_WDT_STG0_S)
#define RTC_CNTL_WDT_STG0_V  0x00000007U
#define RTC_CNTL_WDT_STG0_S  28
/** RTC_CNTL_WDT_EN : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_WDT_EN    (BIT(31))
#define RTC_CNTL_WDT_EN_M  (RTC_CNTL_WDT_EN_V << RTC_CNTL_WDT_EN_S)
#define RTC_CNTL_WDT_EN_V  0x00000001U
#define RTC_CNTL_WDT_EN_S  31

/** RTC_CNTL_WDTCONFIG1_REG register
 *  register description
 */
#define RTC_CNTL_WDTCONFIG1_REG (DR_REG_RTCCNTL_BASE + 0xbc)
/** RTC_CNTL_WDT_STG0_HOLD : R/W; bitpos: [31:0]; default: 200000;
 *  Need add description
 */
#define RTC_CNTL_WDT_STG0_HOLD    0xFFFFFFFFU
#define RTC_CNTL_WDT_STG0_HOLD_M  (RTC_CNTL_WDT_STG0_HOLD_V << RTC_CNTL_WDT_STG0_HOLD_S)
#define RTC_CNTL_WDT_STG0_HOLD_V  0xFFFFFFFFU
#define RTC_CNTL_WDT_STG0_HOLD_S  0

/** RTC_CNTL_WDTCONFIG2_REG register
 *  register description
 */
#define RTC_CNTL_WDTCONFIG2_REG (DR_REG_RTCCNTL_BASE + 0xc0)
/** RTC_CNTL_WDT_STG1_HOLD : R/W; bitpos: [31:0]; default: 80000;
 *  Need add description
 */
#define RTC_CNTL_WDT_STG1_HOLD    0xFFFFFFFFU
#define RTC_CNTL_WDT_STG1_HOLD_M  (RTC_CNTL_WDT_STG1_HOLD_V << RTC_CNTL_WDT_STG1_HOLD_S)
#define RTC_CNTL_WDT_STG1_HOLD_V  0xFFFFFFFFU
#define RTC_CNTL_WDT_STG1_HOLD_S  0

/** RTC_CNTL_WDTCONFIG3_REG register
 *  register description
 */
#define RTC_CNTL_WDTCONFIG3_REG (DR_REG_RTCCNTL_BASE + 0xc4)
/** RTC_CNTL_WDT_STG2_HOLD : R/W; bitpos: [31:0]; default: 4095;
 *  Need add description
 */
#define RTC_CNTL_WDT_STG2_HOLD    0xFFFFFFFFU
#define RTC_CNTL_WDT_STG2_HOLD_M  (RTC_CNTL_WDT_STG2_HOLD_V << RTC_CNTL_WDT_STG2_HOLD_S)
#define RTC_CNTL_WDT_STG2_HOLD_V  0xFFFFFFFFU
#define RTC_CNTL_WDT_STG2_HOLD_S  0

/** RTC_CNTL_WDTCONFIG4_REG register
 *  register description
 */
#define RTC_CNTL_WDTCONFIG4_REG (DR_REG_RTCCNTL_BASE + 0xc8)
/** RTC_CNTL_WDT_STG3_HOLD : R/W; bitpos: [31:0]; default: 4095;
 *  Need add description
 */
#define RTC_CNTL_WDT_STG3_HOLD    0xFFFFFFFFU
#define RTC_CNTL_WDT_STG3_HOLD_M  (RTC_CNTL_WDT_STG3_HOLD_V << RTC_CNTL_WDT_STG3_HOLD_S)
#define RTC_CNTL_WDT_STG3_HOLD_V  0xFFFFFFFFU
#define RTC_CNTL_WDT_STG3_HOLD_S  0

/** RTC_CNTL_WDTFEED_REG register
 *  register description
 */
#define RTC_CNTL_WDTFEED_REG (DR_REG_RTCCNTL_BASE + 0xcc)
/** RTC_CNTL_WDT_FEED : WO; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_WDT_FEED    (BIT(31))
#define RTC_CNTL_WDT_FEED_M  (RTC_CNTL_WDT_FEED_V << RTC_CNTL_WDT_FEED_S)
#define RTC_CNTL_WDT_FEED_V  0x00000001U
#define RTC_CNTL_WDT_FEED_S  31

/** RTC_CNTL_WDTWPROTECT_REG register
 *  register description
 */
#define RTC_CNTL_WDTWPROTECT_REG (DR_REG_RTCCNTL_BASE + 0xd0)
/** RTC_CNTL_WDT_WKEY : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_WDT_WKEY    0xFFFFFFFFU
#define RTC_CNTL_WDT_WKEY_M  (RTC_CNTL_WDT_WKEY_V << RTC_CNTL_WDT_WKEY_S)
#define RTC_CNTL_WDT_WKEY_V  0xFFFFFFFFU
#define RTC_CNTL_WDT_WKEY_S  0

/** RTC_CNTL_WDTRESET_CHIP_REG register
 *  register description
 */
#define RTC_CNTL_WDTRESET_CHIP_REG (DR_REG_RTCCNTL_BASE + 0xd4)
/** RTC_CNTL_RESET_CHIP_TARGET : R/W; bitpos: [23:16]; default: 165;
 *  Need add description
 */
#define RTC_CNTL_RESET_CHIP_TARGET    0x000000FFU
#define RTC_CNTL_RESET_CHIP_TARGET_M  (RTC_CNTL_RESET_CHIP_TARGET_V << RTC_CNTL_RESET_CHIP_TARGET_S)
#define RTC_CNTL_RESET_CHIP_TARGET_V  0x000000FFU
#define RTC_CNTL_RESET_CHIP_TARGET_S  16
/** RTC_CNTL_RESET_CHIP_KEY : R/W; bitpos: [31:24]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_RESET_CHIP_KEY    0x000000FFU
#define RTC_CNTL_RESET_CHIP_KEY_M  (RTC_CNTL_RESET_CHIP_KEY_V << RTC_CNTL_RESET_CHIP_KEY_S)
#define RTC_CNTL_RESET_CHIP_KEY_V  0x000000FFU
#define RTC_CNTL_RESET_CHIP_KEY_S  24

/** RTC_CNTL_SWD_CONF_REG register
 *  register description
 */
#define RTC_CNTL_SWD_CONF_REG (DR_REG_RTCCNTL_BASE + 0xd8)
/** RTC_CNTL_SWD_RESET_FLAG : RO; bitpos: [0]; default: 0;
 *  swd reset flag
 */
#define RTC_CNTL_SWD_RESET_FLAG    (BIT(0))
#define RTC_CNTL_SWD_RESET_FLAG_M  (RTC_CNTL_SWD_RESET_FLAG_V << RTC_CNTL_SWD_RESET_FLAG_S)
#define RTC_CNTL_SWD_RESET_FLAG_V  0x00000001U
#define RTC_CNTL_SWD_RESET_FLAG_S  0
/** RTC_CNTL_SWD_FEED_INT : RO; bitpos: [1]; default: 0;
 *  swd interrupt for feeding
 */
#define RTC_CNTL_SWD_FEED_INT    (BIT(1))
#define RTC_CNTL_SWD_FEED_INT_M  (RTC_CNTL_SWD_FEED_INT_V << RTC_CNTL_SWD_FEED_INT_S)
#define RTC_CNTL_SWD_FEED_INT_V  0x00000001U
#define RTC_CNTL_SWD_FEED_INT_S  1
/** RTC_CNTL_SWD_BYPASS_RST : R/W; bitpos: [17]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SWD_BYPASS_RST    (BIT(17))
#define RTC_CNTL_SWD_BYPASS_RST_M  (RTC_CNTL_SWD_BYPASS_RST_V << RTC_CNTL_SWD_BYPASS_RST_S)
#define RTC_CNTL_SWD_BYPASS_RST_V  0x00000001U
#define RTC_CNTL_SWD_BYPASS_RST_S  17
/** RTC_CNTL_SWD_SIGNAL_WIDTH : R/W; bitpos: [27:18]; default: 300;
 *  adjust signal width send to swd
 */
#define RTC_CNTL_SWD_SIGNAL_WIDTH    0x000003FFU
#define RTC_CNTL_SWD_SIGNAL_WIDTH_M  (RTC_CNTL_SWD_SIGNAL_WIDTH_V << RTC_CNTL_SWD_SIGNAL_WIDTH_S)
#define RTC_CNTL_SWD_SIGNAL_WIDTH_V  0x000003FFU
#define RTC_CNTL_SWD_SIGNAL_WIDTH_S  18
/** RTC_CNTL_SWD_RST_FLAG_CLR : WO; bitpos: [28]; default: 0;
 *  reset swd reset flag
 */
#define RTC_CNTL_SWD_RST_FLAG_CLR    (BIT(28))
#define RTC_CNTL_SWD_RST_FLAG_CLR_M  (RTC_CNTL_SWD_RST_FLAG_CLR_V << RTC_CNTL_SWD_RST_FLAG_CLR_S)
#define RTC_CNTL_SWD_RST_FLAG_CLR_V  0x00000001U
#define RTC_CNTL_SWD_RST_FLAG_CLR_S  28
/** RTC_CNTL_SWD_FEED : WO; bitpos: [29]; default: 0;
 *  Sw feed swd
 */
#define RTC_CNTL_SWD_FEED    (BIT(29))
#define RTC_CNTL_SWD_FEED_M  (RTC_CNTL_SWD_FEED_V << RTC_CNTL_SWD_FEED_S)
#define RTC_CNTL_SWD_FEED_V  0x00000001U
#define RTC_CNTL_SWD_FEED_S  29
/** RTC_CNTL_SWD_DISABLE : R/W; bitpos: [30]; default: 0;
 *  disabel SWD
 */
#define RTC_CNTL_SWD_DISABLE    (BIT(30))
#define RTC_CNTL_SWD_DISABLE_M  (RTC_CNTL_SWD_DISABLE_V << RTC_CNTL_SWD_DISABLE_S)
#define RTC_CNTL_SWD_DISABLE_V  0x00000001U
#define RTC_CNTL_SWD_DISABLE_S  30
/** RTC_CNTL_SWD_AUTO_FEED_EN : R/W; bitpos: [31]; default: 0;
 *  automatically feed swd when int comes
 */
#define RTC_CNTL_SWD_AUTO_FEED_EN    (BIT(31))
#define RTC_CNTL_SWD_AUTO_FEED_EN_M  (RTC_CNTL_SWD_AUTO_FEED_EN_V << RTC_CNTL_SWD_AUTO_FEED_EN_S)
#define RTC_CNTL_SWD_AUTO_FEED_EN_V  0x00000001U
#define RTC_CNTL_SWD_AUTO_FEED_EN_S  31

/** RTC_CNTL_SWD_WPROTECT_REG register
 *  register description
 */
#define RTC_CNTL_SWD_WPROTECT_REG (DR_REG_RTCCNTL_BASE + 0xdc)
/** RTC_CNTL_SWD_WKEY : R/W; bitpos: [31:0]; default: 0;
 *  swd write protect
 */
#define RTC_CNTL_SWD_WKEY    0xFFFFFFFFU
#define RTC_CNTL_SWD_WKEY_M  (RTC_CNTL_SWD_WKEY_V << RTC_CNTL_SWD_WKEY_S)
#define RTC_CNTL_SWD_WKEY_V  0xFFFFFFFFU
#define RTC_CNTL_SWD_WKEY_S  0

/** RTC_CNTL_SW_CPU_STALL_REG register
 *  register description
 */
#define RTC_CNTL_SW_CPU_STALL_REG (DR_REG_RTCCNTL_BASE + 0xe0)
/** RTC_CNTL_SW_STALL_APPCPU_C1 : R/W; bitpos: [25:20]; default: 0;
 *  {reg_sw_stall_appcpu_c1[5:0],  reg_sw_stall_appcpu_c0[1:0]} == 0x86 will stall APP
 *  CPU
 */
#define RTC_CNTL_SW_STALL_APPCPU_C1    0x0000003FU
#define RTC_CNTL_SW_STALL_APPCPU_C1_M  (RTC_CNTL_SW_STALL_APPCPU_C1_V << RTC_CNTL_SW_STALL_APPCPU_C1_S)
#define RTC_CNTL_SW_STALL_APPCPU_C1_V  0x0000003FU
#define RTC_CNTL_SW_STALL_APPCPU_C1_S  20
/** RTC_CNTL_SW_STALL_PROCPU_C1 : R/W; bitpos: [31:26]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SW_STALL_PROCPU_C1    0x0000003FU
#define RTC_CNTL_SW_STALL_PROCPU_C1_M  (RTC_CNTL_SW_STALL_PROCPU_C1_V << RTC_CNTL_SW_STALL_PROCPU_C1_S)
#define RTC_CNTL_SW_STALL_PROCPU_C1_V  0x0000003FU
#define RTC_CNTL_SW_STALL_PROCPU_C1_S  26

/** RTC_CNTL_STORE4_REG register
 *  register description
 */
#define RTC_CNTL_STORE4_REG (DR_REG_RTCCNTL_BASE + 0xe4)
/** RTC_CNTL_SCRATCH4 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCRATCH4    0xFFFFFFFFU
#define RTC_CNTL_SCRATCH4_M  (RTC_CNTL_SCRATCH4_V << RTC_CNTL_SCRATCH4_S)
#define RTC_CNTL_SCRATCH4_V  0xFFFFFFFFU
#define RTC_CNTL_SCRATCH4_S  0

/** RTC_CNTL_STORE5_REG register
 *  register description
 */
#define RTC_CNTL_STORE5_REG (DR_REG_RTCCNTL_BASE + 0xe8)
/** RTC_CNTL_SCRATCH5 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCRATCH5    0xFFFFFFFFU
#define RTC_CNTL_SCRATCH5_M  (RTC_CNTL_SCRATCH5_V << RTC_CNTL_SCRATCH5_S)
#define RTC_CNTL_SCRATCH5_V  0xFFFFFFFFU
#define RTC_CNTL_SCRATCH5_S  0

/** RTC_CNTL_STORE6_REG register
 *  register description
 */
#define RTC_CNTL_STORE6_REG (DR_REG_RTCCNTL_BASE + 0xec)
/** RTC_CNTL_SCRATCH6 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCRATCH6    0xFFFFFFFFU
#define RTC_CNTL_SCRATCH6_M  (RTC_CNTL_SCRATCH6_V << RTC_CNTL_SCRATCH6_S)
#define RTC_CNTL_SCRATCH6_V  0xFFFFFFFFU
#define RTC_CNTL_SCRATCH6_S  0

/** RTC_CNTL_STORE7_REG register
 *  register description
 */
#define RTC_CNTL_STORE7_REG (DR_REG_RTCCNTL_BASE + 0xf0)
/** RTC_CNTL_SCRATCH7 : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SCRATCH7    0xFFFFFFFFU
#define RTC_CNTL_SCRATCH7_M  (RTC_CNTL_SCRATCH7_V << RTC_CNTL_SCRATCH7_S)
#define RTC_CNTL_SCRATCH7_V  0xFFFFFFFFU
#define RTC_CNTL_SCRATCH7_S  0

/** RTC_CNTL_LOW_POWER_ST_REG register
 *  register description
 */
#define RTC_CNTL_LOW_POWER_ST_REG (DR_REG_RTCCNTL_BASE + 0xf4)
/** RTC_CNTL_XPD_ROM0 : RO; bitpos: [0]; default: 0;
 *  rom0 power down
 */
#define RTC_CNTL_XPD_ROM0    (BIT(0))
#define RTC_CNTL_XPD_ROM0_M  (RTC_CNTL_XPD_ROM0_V << RTC_CNTL_XPD_ROM0_S)
#define RTC_CNTL_XPD_ROM0_V  0x00000001U
#define RTC_CNTL_XPD_ROM0_S  0
/** RTC_CNTL_XPD_DIG_DCDC : RO; bitpos: [2]; default: 0;
 *  External DCDC power down
 */
#define RTC_CNTL_XPD_DIG_DCDC    (BIT(2))
#define RTC_CNTL_XPD_DIG_DCDC_M  (RTC_CNTL_XPD_DIG_DCDC_V << RTC_CNTL_XPD_DIG_DCDC_S)
#define RTC_CNTL_XPD_DIG_DCDC_V  0x00000001U
#define RTC_CNTL_XPD_DIG_DCDC_S  2
/** RTC_CNTL_PERI_ISO : RO; bitpos: [3]; default: 0;
 *  rtc peripheral iso
 */
#define RTC_CNTL_PERI_ISO    (BIT(3))
#define RTC_CNTL_PERI_ISO_M  (RTC_CNTL_PERI_ISO_V << RTC_CNTL_PERI_ISO_S)
#define RTC_CNTL_PERI_ISO_V  0x00000001U
#define RTC_CNTL_PERI_ISO_S  3
/** RTC_CNTL_XPD_RTC_PERI : RO; bitpos: [4]; default: 0;
 *  rtc peripheral power down
 */
#define RTC_CNTL_XPD_RTC_PERI    (BIT(4))
#define RTC_CNTL_XPD_RTC_PERI_M  (RTC_CNTL_XPD_RTC_PERI_V << RTC_CNTL_XPD_RTC_PERI_S)
#define RTC_CNTL_XPD_RTC_PERI_V  0x00000001U
#define RTC_CNTL_XPD_RTC_PERI_S  4
/** RTC_CNTL_WIFI_ISO : RO; bitpos: [5]; default: 0;
 *  wifi iso
 */
#define RTC_CNTL_WIFI_ISO    (BIT(5))
#define RTC_CNTL_WIFI_ISO_M  (RTC_CNTL_WIFI_ISO_V << RTC_CNTL_WIFI_ISO_S)
#define RTC_CNTL_WIFI_ISO_V  0x00000001U
#define RTC_CNTL_WIFI_ISO_S  5
/** RTC_CNTL_XPD_WIFI : RO; bitpos: [6]; default: 0;
 *  wifi wrap power down
 */
#define RTC_CNTL_XPD_WIFI    (BIT(6))
#define RTC_CNTL_XPD_WIFI_M  (RTC_CNTL_XPD_WIFI_V << RTC_CNTL_XPD_WIFI_S)
#define RTC_CNTL_XPD_WIFI_V  0x00000001U
#define RTC_CNTL_XPD_WIFI_S  6
/** RTC_CNTL_DIG_ISO : RO; bitpos: [7]; default: 0;
 *  digital wrap iso
 */
#define RTC_CNTL_DIG_ISO    (BIT(7))
#define RTC_CNTL_DIG_ISO_M  (RTC_CNTL_DIG_ISO_V << RTC_CNTL_DIG_ISO_S)
#define RTC_CNTL_DIG_ISO_V  0x00000001U
#define RTC_CNTL_DIG_ISO_S  7
/** RTC_CNTL_XPD_DIG : RO; bitpos: [8]; default: 0;
 *  digital wrap power down
 */
#define RTC_CNTL_XPD_DIG    (BIT(8))
#define RTC_CNTL_XPD_DIG_M  (RTC_CNTL_XPD_DIG_V << RTC_CNTL_XPD_DIG_S)
#define RTC_CNTL_XPD_DIG_V  0x00000001U
#define RTC_CNTL_XPD_DIG_S  8
/** RTC_CNTL_TOUCH_STATE_START : RO; bitpos: [9]; default: 0;
 *  touch should start to work
 */
#define RTC_CNTL_TOUCH_STATE_START    (BIT(9))
#define RTC_CNTL_TOUCH_STATE_START_M  (RTC_CNTL_TOUCH_STATE_START_V << RTC_CNTL_TOUCH_STATE_START_S)
#define RTC_CNTL_TOUCH_STATE_START_V  0x00000001U
#define RTC_CNTL_TOUCH_STATE_START_S  9
/** RTC_CNTL_TOUCH_STATE_SWITCH : RO; bitpos: [10]; default: 0;
 *  touch is about to working. Switch rtc main state
 */
#define RTC_CNTL_TOUCH_STATE_SWITCH    (BIT(10))
#define RTC_CNTL_TOUCH_STATE_SWITCH_M  (RTC_CNTL_TOUCH_STATE_SWITCH_V << RTC_CNTL_TOUCH_STATE_SWITCH_S)
#define RTC_CNTL_TOUCH_STATE_SWITCH_V  0x00000001U
#define RTC_CNTL_TOUCH_STATE_SWITCH_S  10
/** RTC_CNTL_TOUCH_STATE_SLP : RO; bitpos: [11]; default: 0;
 *  touch is in sleep state
 */
#define RTC_CNTL_TOUCH_STATE_SLP    (BIT(11))
#define RTC_CNTL_TOUCH_STATE_SLP_M  (RTC_CNTL_TOUCH_STATE_SLP_V << RTC_CNTL_TOUCH_STATE_SLP_S)
#define RTC_CNTL_TOUCH_STATE_SLP_V  0x00000001U
#define RTC_CNTL_TOUCH_STATE_SLP_S  11
/** RTC_CNTL_TOUCH_STATE_DONE : RO; bitpos: [12]; default: 0;
 *  touch is done
 */
#define RTC_CNTL_TOUCH_STATE_DONE    (BIT(12))
#define RTC_CNTL_TOUCH_STATE_DONE_M  (RTC_CNTL_TOUCH_STATE_DONE_V << RTC_CNTL_TOUCH_STATE_DONE_S)
#define RTC_CNTL_TOUCH_STATE_DONE_V  0x00000001U
#define RTC_CNTL_TOUCH_STATE_DONE_S  12
/** RTC_CNTL_COCPU_STATE_START : RO; bitpos: [13]; default: 0;
 *  ulp/cocpu should start to work
 */
#define RTC_CNTL_COCPU_STATE_START    (BIT(13))
#define RTC_CNTL_COCPU_STATE_START_M  (RTC_CNTL_COCPU_STATE_START_V << RTC_CNTL_COCPU_STATE_START_S)
#define RTC_CNTL_COCPU_STATE_START_V  0x00000001U
#define RTC_CNTL_COCPU_STATE_START_S  13
/** RTC_CNTL_COCPU_STATE_SWITCH : RO; bitpos: [14]; default: 0;
 *  ulp/cocpu is about to working. Switch rtc main state
 */
#define RTC_CNTL_COCPU_STATE_SWITCH    (BIT(14))
#define RTC_CNTL_COCPU_STATE_SWITCH_M  (RTC_CNTL_COCPU_STATE_SWITCH_V << RTC_CNTL_COCPU_STATE_SWITCH_S)
#define RTC_CNTL_COCPU_STATE_SWITCH_V  0x00000001U
#define RTC_CNTL_COCPU_STATE_SWITCH_S  14
/** RTC_CNTL_COCPU_STATE_SLP : RO; bitpos: [15]; default: 0;
 *  ulp/cocpu is in sleep state
 */
#define RTC_CNTL_COCPU_STATE_SLP    (BIT(15))
#define RTC_CNTL_COCPU_STATE_SLP_M  (RTC_CNTL_COCPU_STATE_SLP_V << RTC_CNTL_COCPU_STATE_SLP_S)
#define RTC_CNTL_COCPU_STATE_SLP_V  0x00000001U
#define RTC_CNTL_COCPU_STATE_SLP_S  15
/** RTC_CNTL_COCPU_STATE_DONE : RO; bitpos: [16]; default: 0;
 *  ulp/cocpu is done
 */
#define RTC_CNTL_COCPU_STATE_DONE    (BIT(16))
#define RTC_CNTL_COCPU_STATE_DONE_M  (RTC_CNTL_COCPU_STATE_DONE_V << RTC_CNTL_COCPU_STATE_DONE_S)
#define RTC_CNTL_COCPU_STATE_DONE_V  0x00000001U
#define RTC_CNTL_COCPU_STATE_DONE_S  16
/** RTC_CNTL_MAIN_STATE_XTAL_ISO : RO; bitpos: [17]; default: 0;
 *  no use any more
 */
#define RTC_CNTL_MAIN_STATE_XTAL_ISO    (BIT(17))
#define RTC_CNTL_MAIN_STATE_XTAL_ISO_M  (RTC_CNTL_MAIN_STATE_XTAL_ISO_V << RTC_CNTL_MAIN_STATE_XTAL_ISO_S)
#define RTC_CNTL_MAIN_STATE_XTAL_ISO_V  0x00000001U
#define RTC_CNTL_MAIN_STATE_XTAL_ISO_S  17
/** RTC_CNTL_MAIN_STATE_PLL_ON : RO; bitpos: [18]; default: 0;
 *  rtc main state machine is in states that pll should be running
 */
#define RTC_CNTL_MAIN_STATE_PLL_ON    (BIT(18))
#define RTC_CNTL_MAIN_STATE_PLL_ON_M  (RTC_CNTL_MAIN_STATE_PLL_ON_V << RTC_CNTL_MAIN_STATE_PLL_ON_S)
#define RTC_CNTL_MAIN_STATE_PLL_ON_V  0x00000001U
#define RTC_CNTL_MAIN_STATE_PLL_ON_S  18
/** RTC_CNTL_RDY_FOR_WAKEUP : RO; bitpos: [19]; default: 0;
 *  rtc is ready to receive wake up trigger from wake up source
 */
#define RTC_CNTL_RDY_FOR_WAKEUP    (BIT(19))
#define RTC_CNTL_RDY_FOR_WAKEUP_M  (RTC_CNTL_RDY_FOR_WAKEUP_V << RTC_CNTL_RDY_FOR_WAKEUP_S)
#define RTC_CNTL_RDY_FOR_WAKEUP_V  0x00000001U
#define RTC_CNTL_RDY_FOR_WAKEUP_S  19
/** RTC_CNTL_MAIN_STATE_WAIT_END : RO; bitpos: [20]; default: 0;
 *  rtc main state machine has been waited for some cycles
 */
#define RTC_CNTL_MAIN_STATE_WAIT_END    (BIT(20))
#define RTC_CNTL_MAIN_STATE_WAIT_END_M  (RTC_CNTL_MAIN_STATE_WAIT_END_V << RTC_CNTL_MAIN_STATE_WAIT_END_S)
#define RTC_CNTL_MAIN_STATE_WAIT_END_V  0x00000001U
#define RTC_CNTL_MAIN_STATE_WAIT_END_S  20
/** RTC_CNTL_IN_WAKEUP_STATE : RO; bitpos: [21]; default: 0;
 *  rtc main state machine is in the states of wakeup process
 */
#define RTC_CNTL_IN_WAKEUP_STATE    (BIT(21))
#define RTC_CNTL_IN_WAKEUP_STATE_M  (RTC_CNTL_IN_WAKEUP_STATE_V << RTC_CNTL_IN_WAKEUP_STATE_S)
#define RTC_CNTL_IN_WAKEUP_STATE_V  0x00000001U
#define RTC_CNTL_IN_WAKEUP_STATE_S  21
/** RTC_CNTL_IN_LOW_POWER_STATE : RO; bitpos: [22]; default: 0;
 *  rtc main state machine is in the states of low power
 */
#define RTC_CNTL_IN_LOW_POWER_STATE    (BIT(22))
#define RTC_CNTL_IN_LOW_POWER_STATE_M  (RTC_CNTL_IN_LOW_POWER_STATE_V << RTC_CNTL_IN_LOW_POWER_STATE_S)
#define RTC_CNTL_IN_LOW_POWER_STATE_V  0x00000001U
#define RTC_CNTL_IN_LOW_POWER_STATE_S  22
/** RTC_CNTL_MAIN_STATE_IN_WAIT_8M : RO; bitpos: [23]; default: 0;
 *  rtc main state machine is in wait 8m state
 */
#define RTC_CNTL_MAIN_STATE_IN_WAIT_8M    (BIT(23))
#define RTC_CNTL_MAIN_STATE_IN_WAIT_8M_M  (RTC_CNTL_MAIN_STATE_IN_WAIT_8M_V << RTC_CNTL_MAIN_STATE_IN_WAIT_8M_S)
#define RTC_CNTL_MAIN_STATE_IN_WAIT_8M_V  0x00000001U
#define RTC_CNTL_MAIN_STATE_IN_WAIT_8M_S  23
/** RTC_CNTL_MAIN_STATE_IN_WAIT_PLL : RO; bitpos: [24]; default: 0;
 *  rtc main state machine is in wait pll state
 */
#define RTC_CNTL_MAIN_STATE_IN_WAIT_PLL    (BIT(24))
#define RTC_CNTL_MAIN_STATE_IN_WAIT_PLL_M  (RTC_CNTL_MAIN_STATE_IN_WAIT_PLL_V << RTC_CNTL_MAIN_STATE_IN_WAIT_PLL_S)
#define RTC_CNTL_MAIN_STATE_IN_WAIT_PLL_V  0x00000001U
#define RTC_CNTL_MAIN_STATE_IN_WAIT_PLL_S  24
/** RTC_CNTL_MAIN_STATE_IN_WAIT_XTL : RO; bitpos: [25]; default: 0;
 *  rtc main state machine is in wait xtal state
 */
#define RTC_CNTL_MAIN_STATE_IN_WAIT_XTL    (BIT(25))
#define RTC_CNTL_MAIN_STATE_IN_WAIT_XTL_M  (RTC_CNTL_MAIN_STATE_IN_WAIT_XTL_V << RTC_CNTL_MAIN_STATE_IN_WAIT_XTL_S)
#define RTC_CNTL_MAIN_STATE_IN_WAIT_XTL_V  0x00000001U
#define RTC_CNTL_MAIN_STATE_IN_WAIT_XTL_S  25
/** RTC_CNTL_MAIN_STATE_IN_SLP : RO; bitpos: [26]; default: 0;
 *  rtc main state machine is in sleep state
 */
#define RTC_CNTL_MAIN_STATE_IN_SLP    (BIT(26))
#define RTC_CNTL_MAIN_STATE_IN_SLP_M  (RTC_CNTL_MAIN_STATE_IN_SLP_V << RTC_CNTL_MAIN_STATE_IN_SLP_S)
#define RTC_CNTL_MAIN_STATE_IN_SLP_V  0x00000001U
#define RTC_CNTL_MAIN_STATE_IN_SLP_S  26
/** RTC_CNTL_MAIN_STATE_IN_IDLE : RO; bitpos: [27]; default: 0;
 *  rtc main state machine is in idle state
 */
#define RTC_CNTL_MAIN_STATE_IN_IDLE    (BIT(27))
#define RTC_CNTL_MAIN_STATE_IN_IDLE_M  (RTC_CNTL_MAIN_STATE_IN_IDLE_V << RTC_CNTL_MAIN_STATE_IN_IDLE_S)
#define RTC_CNTL_MAIN_STATE_IN_IDLE_V  0x00000001U
#define RTC_CNTL_MAIN_STATE_IN_IDLE_S  27
/** RTC_CNTL_MAIN_STATE : RO; bitpos: [31:28]; default: 0;
 *  rtc main state machine status
 */
#define RTC_CNTL_MAIN_STATE    0x0000000FU
#define RTC_CNTL_MAIN_STATE_M  (RTC_CNTL_MAIN_STATE_V << RTC_CNTL_MAIN_STATE_S)
#define RTC_CNTL_MAIN_STATE_V  0x0000000FU
#define RTC_CNTL_MAIN_STATE_S  28

/** RTC_CNTL_DIAG0_REG register
 *  register description
 */
#define RTC_CNTL_DIAG0_REG (DR_REG_RTCCNTL_BASE + 0xf8)
/** RTC_CNTL_LOW_POWER_DIAG1 : RO; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_LOW_POWER_DIAG1    0xFFFFFFFFU
#define RTC_CNTL_LOW_POWER_DIAG1_M  (RTC_CNTL_LOW_POWER_DIAG1_V << RTC_CNTL_LOW_POWER_DIAG1_S)
#define RTC_CNTL_LOW_POWER_DIAG1_V  0xFFFFFFFFU
#define RTC_CNTL_LOW_POWER_DIAG1_S  0

/** RTC_CNTL_PAD_HOLD_REG register
 *  register description
 */
#define RTC_CNTL_PAD_HOLD_REG (DR_REG_RTCCNTL_BASE + 0xfc)
/** RTC_CNTL_GPIO_PIN0_HOLD : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN0_HOLD    (BIT(0))
#define RTC_CNTL_GPIO_PIN0_HOLD_M  (RTC_CNTL_GPIO_PIN0_HOLD_V << RTC_CNTL_GPIO_PIN0_HOLD_S)
#define RTC_CNTL_GPIO_PIN0_HOLD_V  0x00000001U
#define RTC_CNTL_GPIO_PIN0_HOLD_S  0
/** RTC_CNTL_GPIO_PIN1_HOLD : R/W; bitpos: [1]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN1_HOLD    (BIT(1))
#define RTC_CNTL_GPIO_PIN1_HOLD_M  (RTC_CNTL_GPIO_PIN1_HOLD_V << RTC_CNTL_GPIO_PIN1_HOLD_S)
#define RTC_CNTL_GPIO_PIN1_HOLD_V  0x00000001U
#define RTC_CNTL_GPIO_PIN1_HOLD_S  1
/** RTC_CNTL_GPIO_PIN2_HOLD : R/W; bitpos: [2]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN2_HOLD    (BIT(2))
#define RTC_CNTL_GPIO_PIN2_HOLD_M  (RTC_CNTL_GPIO_PIN2_HOLD_V << RTC_CNTL_GPIO_PIN2_HOLD_S)
#define RTC_CNTL_GPIO_PIN2_HOLD_V  0x00000001U
#define RTC_CNTL_GPIO_PIN2_HOLD_S  2
/** RTC_CNTL_GPIO_PIN3_HOLD : R/W; bitpos: [3]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN3_HOLD    (BIT(3))
#define RTC_CNTL_GPIO_PIN3_HOLD_M  (RTC_CNTL_GPIO_PIN3_HOLD_V << RTC_CNTL_GPIO_PIN3_HOLD_S)
#define RTC_CNTL_GPIO_PIN3_HOLD_V  0x00000001U
#define RTC_CNTL_GPIO_PIN3_HOLD_S  3
/** RTC_CNTL_GPIO_PIN4_HOLD : R/W; bitpos: [4]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN4_HOLD    (BIT(4))
#define RTC_CNTL_GPIO_PIN4_HOLD_M  (RTC_CNTL_GPIO_PIN4_HOLD_V << RTC_CNTL_GPIO_PIN4_HOLD_S)
#define RTC_CNTL_GPIO_PIN4_HOLD_V  0x00000001U
#define RTC_CNTL_GPIO_PIN4_HOLD_S  4
/** RTC_CNTL_GPIO_PIN5_HOLD : R/W; bitpos: [5]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN5_HOLD    (BIT(5))
#define RTC_CNTL_GPIO_PIN5_HOLD_M  (RTC_CNTL_GPIO_PIN5_HOLD_V << RTC_CNTL_GPIO_PIN5_HOLD_S)
#define RTC_CNTL_GPIO_PIN5_HOLD_V  0x00000001U
#define RTC_CNTL_GPIO_PIN5_HOLD_S  5

/** RTC_CNTL_DIG_PAD_HOLD_REG register
 *  register description
 */
#define RTC_CNTL_DIG_PAD_HOLD_REG (DR_REG_RTCCNTL_BASE + 0x100)
/** RTC_CNTL_DIG_PAD_HOLD : R/W; bitpos: [31:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DIG_PAD_HOLD    0xFFFFFFFFU
#define RTC_CNTL_DIG_PAD_HOLD_M  (RTC_CNTL_DIG_PAD_HOLD_V << RTC_CNTL_DIG_PAD_HOLD_S)
#define RTC_CNTL_DIG_PAD_HOLD_V  0xFFFFFFFFU
#define RTC_CNTL_DIG_PAD_HOLD_S  0

/** RTC_CNTL_DIG_PAD_HOLD1_REG register
 *  register description
 */
#define RTC_CNTL_DIG_PAD_HOLD1_REG (DR_REG_RTCCNTL_BASE + 0x104)
/** RTC_CNTL_DIG_PAD_HOLD1 : R/W; bitpos: [8:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DIG_PAD_HOLD1    0x000001FFU
#define RTC_CNTL_DIG_PAD_HOLD1_M  (RTC_CNTL_DIG_PAD_HOLD1_V << RTC_CNTL_DIG_PAD_HOLD1_S)
#define RTC_CNTL_DIG_PAD_HOLD1_V  0x000001FFU
#define RTC_CNTL_DIG_PAD_HOLD1_S  0

/** RTC_CNTL_BROWN_OUT_REG register
 *  register description
 */
#define RTC_CNTL_BROWN_OUT_REG (DR_REG_RTCCNTL_BASE + 0x108)
/** RTC_CNTL_BROWN_OUT_INT_WAIT : R/W; bitpos: [13:4]; default: 1;
 *  brown out interrupt wait cycles
 */
#define RTC_CNTL_BROWN_OUT_INT_WAIT    0x000003FFU
#define RTC_CNTL_BROWN_OUT_INT_WAIT_M  (RTC_CNTL_BROWN_OUT_INT_WAIT_V << RTC_CNTL_BROWN_OUT_INT_WAIT_S)
#define RTC_CNTL_BROWN_OUT_INT_WAIT_V  0x000003FFU
#define RTC_CNTL_BROWN_OUT_INT_WAIT_S  4
/** RTC_CNTL_BROWN_OUT_CLOSE_FLASH_ENA : R/W; bitpos: [14]; default: 0;
 *  enable close flash when brown out happens
 */
#define RTC_CNTL_BROWN_OUT_CLOSE_FLASH_ENA    (BIT(14))
#define RTC_CNTL_BROWN_OUT_CLOSE_FLASH_ENA_M  (RTC_CNTL_BROWN_OUT_CLOSE_FLASH_ENA_V << RTC_CNTL_BROWN_OUT_CLOSE_FLASH_ENA_S)
#define RTC_CNTL_BROWN_OUT_CLOSE_FLASH_ENA_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_CLOSE_FLASH_ENA_S  14
/** RTC_CNTL_BROWN_OUT_PD_RF_ENA : R/W; bitpos: [15]; default: 0;
 *  enable power down RF when brown out happens
 */
#define RTC_CNTL_BROWN_OUT_PD_RF_ENA    (BIT(15))
#define RTC_CNTL_BROWN_OUT_PD_RF_ENA_M  (RTC_CNTL_BROWN_OUT_PD_RF_ENA_V << RTC_CNTL_BROWN_OUT_PD_RF_ENA_S)
#define RTC_CNTL_BROWN_OUT_PD_RF_ENA_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_PD_RF_ENA_S  15
/** RTC_CNTL_BROWN_OUT_RST_WAIT : R/W; bitpos: [25:16]; default: 1023;
 *  brown out reset wait cycles
 */
#define RTC_CNTL_BROWN_OUT_RST_WAIT    0x000003FFU
#define RTC_CNTL_BROWN_OUT_RST_WAIT_M  (RTC_CNTL_BROWN_OUT_RST_WAIT_V << RTC_CNTL_BROWN_OUT_RST_WAIT_S)
#define RTC_CNTL_BROWN_OUT_RST_WAIT_V  0x000003FFU
#define RTC_CNTL_BROWN_OUT_RST_WAIT_S  16
/** RTC_CNTL_BROWN_OUT_RST_ENA : R/W; bitpos: [26]; default: 0;
 *  enable brown out reset
 */
#define RTC_CNTL_BROWN_OUT_RST_ENA    (BIT(26))
#define RTC_CNTL_BROWN_OUT_RST_ENA_M  (RTC_CNTL_BROWN_OUT_RST_ENA_V << RTC_CNTL_BROWN_OUT_RST_ENA_S)
#define RTC_CNTL_BROWN_OUT_RST_ENA_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_RST_ENA_S  26
/** RTC_CNTL_BROWN_OUT_RST_SEL : R/W; bitpos: [27]; default: 0;
 *  1:  4-pos reset,    0:  sys_reset
 */
#define RTC_CNTL_BROWN_OUT_RST_SEL    (BIT(27))
#define RTC_CNTL_BROWN_OUT_RST_SEL_M  (RTC_CNTL_BROWN_OUT_RST_SEL_V << RTC_CNTL_BROWN_OUT_RST_SEL_S)
#define RTC_CNTL_BROWN_OUT_RST_SEL_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_RST_SEL_S  27
/** RTC_CNTL_BROWN_OUT_ANA_RST_EN : R/W; bitpos: [28]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BROWN_OUT_ANA_RST_EN    (BIT(28))
#define RTC_CNTL_BROWN_OUT_ANA_RST_EN_M  (RTC_CNTL_BROWN_OUT_ANA_RST_EN_V << RTC_CNTL_BROWN_OUT_ANA_RST_EN_S)
#define RTC_CNTL_BROWN_OUT_ANA_RST_EN_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_ANA_RST_EN_S  28
/** RTC_CNTL_BROWN_OUT_CNT_CLR : WO; bitpos: [29]; default: 0;
 *  clear brown out counter
 */
#define RTC_CNTL_BROWN_OUT_CNT_CLR    (BIT(29))
#define RTC_CNTL_BROWN_OUT_CNT_CLR_M  (RTC_CNTL_BROWN_OUT_CNT_CLR_V << RTC_CNTL_BROWN_OUT_CNT_CLR_S)
#define RTC_CNTL_BROWN_OUT_CNT_CLR_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_CNT_CLR_S  29
/** RTC_CNTL_BROWN_OUT_ENA : R/W; bitpos: [30]; default: 1;
 *  enable brown out
 */
#define RTC_CNTL_BROWN_OUT_ENA    (BIT(30))
#define RTC_CNTL_BROWN_OUT_ENA_M  (RTC_CNTL_BROWN_OUT_ENA_V << RTC_CNTL_BROWN_OUT_ENA_S)
#define RTC_CNTL_BROWN_OUT_ENA_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_ENA_S  30
/** RTC_CNTL_BROWN_OUT_DET : RO; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BROWN_OUT_DET    (BIT(31))
#define RTC_CNTL_BROWN_OUT_DET_M  (RTC_CNTL_BROWN_OUT_DET_V << RTC_CNTL_BROWN_OUT_DET_S)
#define RTC_CNTL_BROWN_OUT_DET_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_DET_S  31

/** RTC_CNTL_TIME_LOW1_REG register
 *  register description
 */
#define RTC_CNTL_TIME_LOW1_REG (DR_REG_RTCCNTL_BASE + 0x10c)
/** RTC_CNTL_TIMER_VALUE1_LOW : RO; bitpos: [31:0]; default: 0;
 *  RTC timer low 32 bits
 */
#define RTC_CNTL_TIMER_VALUE1_LOW    0xFFFFFFFFU
#define RTC_CNTL_TIMER_VALUE1_LOW_M  (RTC_CNTL_TIMER_VALUE1_LOW_V << RTC_CNTL_TIMER_VALUE1_LOW_S)
#define RTC_CNTL_TIMER_VALUE1_LOW_V  0xFFFFFFFFU
#define RTC_CNTL_TIMER_VALUE1_LOW_S  0

/** RTC_CNTL_TIME_HIGH1_REG register
 *  register description
 */
#define RTC_CNTL_TIME_HIGH1_REG (DR_REG_RTCCNTL_BASE + 0x110)
/** RTC_CNTL_TIMER_VALUE1_HIGH : RO; bitpos: [15:0]; default: 0;
 *  RTC timer high 16 bits
 */
#define RTC_CNTL_TIMER_VALUE1_HIGH    0x0000FFFFU
#define RTC_CNTL_TIMER_VALUE1_HIGH_M  (RTC_CNTL_TIMER_VALUE1_HIGH_V << RTC_CNTL_TIMER_VALUE1_HIGH_S)
#define RTC_CNTL_TIMER_VALUE1_HIGH_V  0x0000FFFFU
#define RTC_CNTL_TIMER_VALUE1_HIGH_S  0

/** RTC_CNTL_XTAL32K_CLK_FACTOR_REG register
 *  register description
 */
#define RTC_CNTL_XTAL32K_CLK_FACTOR_REG (DR_REG_RTCCNTL_BASE + 0x114)
/** RTC_CNTL_XTAL32K_CLK_FACTOR : R/W; bitpos: [31:0]; default: 0;
 *  xtal 32k watch dog backup clock factor
 */
#define RTC_CNTL_XTAL32K_CLK_FACTOR    0xFFFFFFFFU
#define RTC_CNTL_XTAL32K_CLK_FACTOR_M  (RTC_CNTL_XTAL32K_CLK_FACTOR_V << RTC_CNTL_XTAL32K_CLK_FACTOR_S)
#define RTC_CNTL_XTAL32K_CLK_FACTOR_V  0xFFFFFFFFU
#define RTC_CNTL_XTAL32K_CLK_FACTOR_S  0

/** RTC_CNTL_XTAL32K_CONF_REG register
 *  register description
 */
#define RTC_CNTL_XTAL32K_CONF_REG (DR_REG_RTCCNTL_BASE + 0x118)
/** RTC_CNTL_XTAL32K_RETURN_WAIT : R/W; bitpos: [3:0]; default: 0;
 *  cycles to wait to return noral xtal 32k
 */
#define RTC_CNTL_XTAL32K_RETURN_WAIT    0x0000000FU
#define RTC_CNTL_XTAL32K_RETURN_WAIT_M  (RTC_CNTL_XTAL32K_RETURN_WAIT_V << RTC_CNTL_XTAL32K_RETURN_WAIT_S)
#define RTC_CNTL_XTAL32K_RETURN_WAIT_V  0x0000000FU
#define RTC_CNTL_XTAL32K_RETURN_WAIT_S  0
/** RTC_CNTL_XTAL32K_RESTART_WAIT : R/W; bitpos: [19:4]; default: 0;
 *  cycles to wait to repower on xtal 32k
 */
#define RTC_CNTL_XTAL32K_RESTART_WAIT    0x0000FFFFU
#define RTC_CNTL_XTAL32K_RESTART_WAIT_M  (RTC_CNTL_XTAL32K_RESTART_WAIT_V << RTC_CNTL_XTAL32K_RESTART_WAIT_S)
#define RTC_CNTL_XTAL32K_RESTART_WAIT_V  0x0000FFFFU
#define RTC_CNTL_XTAL32K_RESTART_WAIT_S  4
/** RTC_CNTL_XTAL32K_WDT_TIMEOUT : R/W; bitpos: [27:20]; default: 255;
 *  If no clock detected for this amount of time, 32k is regarded as dead
 */
#define RTC_CNTL_XTAL32K_WDT_TIMEOUT    0x000000FFU
#define RTC_CNTL_XTAL32K_WDT_TIMEOUT_M  (RTC_CNTL_XTAL32K_WDT_TIMEOUT_V << RTC_CNTL_XTAL32K_WDT_TIMEOUT_S)
#define RTC_CNTL_XTAL32K_WDT_TIMEOUT_V  0x000000FFU
#define RTC_CNTL_XTAL32K_WDT_TIMEOUT_S  20
/** RTC_CNTL_XTAL32K_STABLE_THRES : R/W; bitpos: [31:28]; default: 0;
 *  if restarted xtal32k period is smaller than this, it is regarded as stable
 */
#define RTC_CNTL_XTAL32K_STABLE_THRES    0x0000000FU
#define RTC_CNTL_XTAL32K_STABLE_THRES_M  (RTC_CNTL_XTAL32K_STABLE_THRES_V << RTC_CNTL_XTAL32K_STABLE_THRES_S)
#define RTC_CNTL_XTAL32K_STABLE_THRES_V  0x0000000FU
#define RTC_CNTL_XTAL32K_STABLE_THRES_S  28

/** RTC_CNTL_USB_CONF_REG register
 *  register description
 */
#define RTC_CNTL_USB_CONF_REG (DR_REG_RTCCNTL_BASE + 0x11c)
/** RTC_CNTL_IO_MUX_RESET_DISABLE : R/W; bitpos: [18]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_IO_MUX_RESET_DISABLE    (BIT(18))
#define RTC_CNTL_IO_MUX_RESET_DISABLE_M  (RTC_CNTL_IO_MUX_RESET_DISABLE_V << RTC_CNTL_IO_MUX_RESET_DISABLE_S)
#define RTC_CNTL_IO_MUX_RESET_DISABLE_V  0x00000001U
#define RTC_CNTL_IO_MUX_RESET_DISABLE_S  18

/** RTC_CNTL_SLP_REJECT_CAUSE_REG register
 *  register description
 */
#define RTC_CNTL_SLP_REJECT_CAUSE_REG (DR_REG_RTCCNTL_BASE + 0x120)
/** RTC_CNTL_REJECT_CAUSE : RO; bitpos: [18:0]; default: 0;
 *  sleep reject cause
 */
#define RTC_CNTL_REJECT_CAUSE    0x0007FFFFU
#define RTC_CNTL_REJECT_CAUSE_M  (RTC_CNTL_REJECT_CAUSE_V << RTC_CNTL_REJECT_CAUSE_S)
#define RTC_CNTL_REJECT_CAUSE_V  0x0007FFFFU
#define RTC_CNTL_REJECT_CAUSE_S  0

/** RTC_CNTL_OPTION1_REG register
 *  register description
 */
#define RTC_CNTL_OPTION1_REG (DR_REG_RTCCNTL_BASE + 0x124)
/** RTC_CNTL_FORCE_DOWNLOAD_BOOT : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_FORCE_DOWNLOAD_BOOT    (BIT(0))
#define RTC_CNTL_FORCE_DOWNLOAD_BOOT_M  (RTC_CNTL_FORCE_DOWNLOAD_BOOT_V << RTC_CNTL_FORCE_DOWNLOAD_BOOT_S)
#define RTC_CNTL_FORCE_DOWNLOAD_BOOT_V  0x00000001U
#define RTC_CNTL_FORCE_DOWNLOAD_BOOT_S  0

/** RTC_CNTL_SLP_WAKEUP_CAUSE_REG register
 *  register description
 */
#define RTC_CNTL_SLP_WAKEUP_CAUSE_REG (DR_REG_RTCCNTL_BASE + 0x128)
/** RTC_CNTL_WAKEUP_CAUSE : RO; bitpos: [18:0]; default: 0;
 *  sleep wakeup cause
 */
#define RTC_CNTL_WAKEUP_CAUSE    0x0007FFFFU
#define RTC_CNTL_WAKEUP_CAUSE_M  (RTC_CNTL_WAKEUP_CAUSE_V << RTC_CNTL_WAKEUP_CAUSE_S)
#define RTC_CNTL_WAKEUP_CAUSE_V  0x0007FFFFU
#define RTC_CNTL_WAKEUP_CAUSE_S  0

/** RTC_CNTL_ULP_CP_TIMER_1_REG register
 *  register description
 */
#define RTC_CNTL_ULP_CP_TIMER_1_REG (DR_REG_RTCCNTL_BASE + 0x12c)
/** RTC_CNTL_ULP_CP_TIMER_SLP_CYCLE : R/W; bitpos: [31:8]; default: 200;
 *  sleep cycles for ULP-coprocessor timer
 */
#define RTC_CNTL_ULP_CP_TIMER_SLP_CYCLE    0x00FFFFFFU
#define RTC_CNTL_ULP_CP_TIMER_SLP_CYCLE_M  (RTC_CNTL_ULP_CP_TIMER_SLP_CYCLE_V << RTC_CNTL_ULP_CP_TIMER_SLP_CYCLE_S)
#define RTC_CNTL_ULP_CP_TIMER_SLP_CYCLE_V  0x00FFFFFFU
#define RTC_CNTL_ULP_CP_TIMER_SLP_CYCLE_S  8

/** RTC_CNTL_INT_ENA_RTC_W1TS_REG register
 *  register description
 */
#define RTC_CNTL_INT_ENA_RTC_W1TS_REG (DR_REG_RTCCNTL_BASE + 0x130)
/** RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TS : WO; bitpos: [0]; default: 0;
 *  enable sleep wakeup interrupt
 */
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TS    (BIT(0))
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TS_M  (RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TS_V << RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TS_S)
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TS_S  0
/** RTC_CNTL_SLP_REJECT_INT_ENA_W1TS : WO; bitpos: [1]; default: 0;
 *  enable sleep reject interrupt
 */
#define RTC_CNTL_SLP_REJECT_INT_ENA_W1TS    (BIT(1))
#define RTC_CNTL_SLP_REJECT_INT_ENA_W1TS_M  (RTC_CNTL_SLP_REJECT_INT_ENA_W1TS_V << RTC_CNTL_SLP_REJECT_INT_ENA_W1TS_S)
#define RTC_CNTL_SLP_REJECT_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_SLP_REJECT_INT_ENA_W1TS_S  1
/** RTC_CNTL_WDT_INT_ENA_W1TS : WO; bitpos: [3]; default: 0;
 *  enable RTC WDT interrupt
 */
#define RTC_CNTL_WDT_INT_ENA_W1TS    (BIT(3))
#define RTC_CNTL_WDT_INT_ENA_W1TS_M  (RTC_CNTL_WDT_INT_ENA_W1TS_V << RTC_CNTL_WDT_INT_ENA_W1TS_S)
#define RTC_CNTL_WDT_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_WDT_INT_ENA_W1TS_S  3
/** RTC_CNTL_BROWN_OUT_INT_ENA_W1TS : WO; bitpos: [9]; default: 0;
 *  enable brown out interrupt
 */
#define RTC_CNTL_BROWN_OUT_INT_ENA_W1TS    (BIT(9))
#define RTC_CNTL_BROWN_OUT_INT_ENA_W1TS_M  (RTC_CNTL_BROWN_OUT_INT_ENA_W1TS_V << RTC_CNTL_BROWN_OUT_INT_ENA_W1TS_S)
#define RTC_CNTL_BROWN_OUT_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_INT_ENA_W1TS_S  9
/** RTC_CNTL_MAIN_TIMER_INT_ENA_W1TS : WO; bitpos: [10]; default: 0;
 *  enable RTC main timer interrupt
 */
#define RTC_CNTL_MAIN_TIMER_INT_ENA_W1TS    (BIT(10))
#define RTC_CNTL_MAIN_TIMER_INT_ENA_W1TS_M  (RTC_CNTL_MAIN_TIMER_INT_ENA_W1TS_V << RTC_CNTL_MAIN_TIMER_INT_ENA_W1TS_S)
#define RTC_CNTL_MAIN_TIMER_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_MAIN_TIMER_INT_ENA_W1TS_S  10
/** RTC_CNTL_SWD_INT_ENA_W1TS : WO; bitpos: [15]; default: 0;
 *  enable super watch dog interrupt
 */
#define RTC_CNTL_SWD_INT_ENA_W1TS    (BIT(15))
#define RTC_CNTL_SWD_INT_ENA_W1TS_M  (RTC_CNTL_SWD_INT_ENA_W1TS_V << RTC_CNTL_SWD_INT_ENA_W1TS_S)
#define RTC_CNTL_SWD_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_SWD_INT_ENA_W1TS_S  15
/** RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TS : WO; bitpos: [16]; default: 0;
 *  enable xtal32k_dead  interrupt
 */
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TS    (BIT(16))
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TS_M  (RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TS_V << RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TS_S)
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TS_S  16
/** RTC_CNTL_GLITCH_DET_INT_ENA_W1TS : WO; bitpos: [19]; default: 0;
 *  enbale gitch det interrupt
 */
#define RTC_CNTL_GLITCH_DET_INT_ENA_W1TS    (BIT(19))
#define RTC_CNTL_GLITCH_DET_INT_ENA_W1TS_M  (RTC_CNTL_GLITCH_DET_INT_ENA_W1TS_V << RTC_CNTL_GLITCH_DET_INT_ENA_W1TS_S)
#define RTC_CNTL_GLITCH_DET_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_GLITCH_DET_INT_ENA_W1TS_S  19
/** RTC_CNTL_BBPLL_CAL_INT_ENA_W1TS : WO; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BBPLL_CAL_INT_ENA_W1TS    (BIT(20))
#define RTC_CNTL_BBPLL_CAL_INT_ENA_W1TS_M  (RTC_CNTL_BBPLL_CAL_INT_ENA_W1TS_V << RTC_CNTL_BBPLL_CAL_INT_ENA_W1TS_S)
#define RTC_CNTL_BBPLL_CAL_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_BBPLL_CAL_INT_ENA_W1TS_S  20
/** RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TS : WO; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TS    (BIT(21))
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TS_M  (RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TS_V << RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TS_S)
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TS_S  21
/** RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TS : WO; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TS    (BIT(22))
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TS_M  (RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TS_V << RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TS_S)
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TS_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TS_S  22

/** RTC_CNTL_INT_ENA_RTC_W1TC_REG register
 *  register description
 */
#define RTC_CNTL_INT_ENA_RTC_W1TC_REG (DR_REG_RTCCNTL_BASE + 0x134)
/** RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TC : WO; bitpos: [0]; default: 0;
 *  enable sleep wakeup interrupt
 */
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TC    (BIT(0))
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TC_M  (RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TC_V << RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TC_S)
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_SLP_WAKEUP_INT_ENA_W1TC_S  0
/** RTC_CNTL_SLP_REJECT_INT_ENA_W1TC : WO; bitpos: [1]; default: 0;
 *  enable sleep reject interrupt
 */
#define RTC_CNTL_SLP_REJECT_INT_ENA_W1TC    (BIT(1))
#define RTC_CNTL_SLP_REJECT_INT_ENA_W1TC_M  (RTC_CNTL_SLP_REJECT_INT_ENA_W1TC_V << RTC_CNTL_SLP_REJECT_INT_ENA_W1TC_S)
#define RTC_CNTL_SLP_REJECT_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_SLP_REJECT_INT_ENA_W1TC_S  1
/** RTC_CNTL_WDT_INT_ENA_W1TC : WO; bitpos: [3]; default: 0;
 *  enable RTC WDT interrupt
 */
#define RTC_CNTL_WDT_INT_ENA_W1TC    (BIT(3))
#define RTC_CNTL_WDT_INT_ENA_W1TC_M  (RTC_CNTL_WDT_INT_ENA_W1TC_V << RTC_CNTL_WDT_INT_ENA_W1TC_S)
#define RTC_CNTL_WDT_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_WDT_INT_ENA_W1TC_S  3
/** RTC_CNTL_BROWN_OUT_INT_ENA_W1TC : WO; bitpos: [9]; default: 0;
 *  enable brown out interrupt
 */
#define RTC_CNTL_BROWN_OUT_INT_ENA_W1TC    (BIT(9))
#define RTC_CNTL_BROWN_OUT_INT_ENA_W1TC_M  (RTC_CNTL_BROWN_OUT_INT_ENA_W1TC_V << RTC_CNTL_BROWN_OUT_INT_ENA_W1TC_S)
#define RTC_CNTL_BROWN_OUT_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_BROWN_OUT_INT_ENA_W1TC_S  9
/** RTC_CNTL_MAIN_TIMER_INT_ENA_W1TC : WO; bitpos: [10]; default: 0;
 *  enable RTC main timer interrupt
 */
#define RTC_CNTL_MAIN_TIMER_INT_ENA_W1TC    (BIT(10))
#define RTC_CNTL_MAIN_TIMER_INT_ENA_W1TC_M  (RTC_CNTL_MAIN_TIMER_INT_ENA_W1TC_V << RTC_CNTL_MAIN_TIMER_INT_ENA_W1TC_S)
#define RTC_CNTL_MAIN_TIMER_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_MAIN_TIMER_INT_ENA_W1TC_S  10
/** RTC_CNTL_SWD_INT_ENA_W1TC : WO; bitpos: [15]; default: 0;
 *  enable super watch dog interrupt
 */
#define RTC_CNTL_SWD_INT_ENA_W1TC    (BIT(15))
#define RTC_CNTL_SWD_INT_ENA_W1TC_M  (RTC_CNTL_SWD_INT_ENA_W1TC_V << RTC_CNTL_SWD_INT_ENA_W1TC_S)
#define RTC_CNTL_SWD_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_SWD_INT_ENA_W1TC_S  15
/** RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TC : WO; bitpos: [16]; default: 0;
 *  enable xtal32k_dead  interrupt
 */
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TC    (BIT(16))
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TC_M  (RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TC_V << RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TC_S)
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_XTAL32K_DEAD_INT_ENA_W1TC_S  16
/** RTC_CNTL_GLITCH_DET_INT_ENA_W1TC : WO; bitpos: [19]; default: 0;
 *  enbale gitch det interrupt
 */
#define RTC_CNTL_GLITCH_DET_INT_ENA_W1TC    (BIT(19))
#define RTC_CNTL_GLITCH_DET_INT_ENA_W1TC_M  (RTC_CNTL_GLITCH_DET_INT_ENA_W1TC_V << RTC_CNTL_GLITCH_DET_INT_ENA_W1TC_S)
#define RTC_CNTL_GLITCH_DET_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_GLITCH_DET_INT_ENA_W1TC_S  19
/** RTC_CNTL_BBPLL_CAL_INT_ENA_W1TC : WO; bitpos: [20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BBPLL_CAL_INT_ENA_W1TC    (BIT(20))
#define RTC_CNTL_BBPLL_CAL_INT_ENA_W1TC_M  (RTC_CNTL_BBPLL_CAL_INT_ENA_W1TC_V << RTC_CNTL_BBPLL_CAL_INT_ENA_W1TC_S)
#define RTC_CNTL_BBPLL_CAL_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_BBPLL_CAL_INT_ENA_W1TC_S  20
/** RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TC : WO; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TC    (BIT(21))
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TC_M  (RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TC_V << RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TC_S)
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_BLE_COMPARE_WAKE_INT_ENA_W1TC_S  21
/** RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TC : WO; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TC    (BIT(22))
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TC_M  (RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TC_V << RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TC_S)
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TC_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_DONE_INT_ENA_W1TC_S  22

/** RTC_CNTL_RETENTION_CTRL_REG register
 *  register description
 */
#define RTC_CNTL_RETENTION_CTRL_REG (DR_REG_RTCCNTL_BASE + 0x138)
/** RTC_CNTL_CLK_EN : R/W; bitpos: [17]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_CLK_EN    (BIT(17))
#define RTC_CNTL_CLK_EN_M  (RTC_CNTL_CLK_EN_V << RTC_CNTL_CLK_EN_S)
#define RTC_CNTL_CLK_EN_V  0x00000001U
#define RTC_CNTL_CLK_EN_S  17
/** RTC_CNTL_RETENTION_CLK_SEL : R/W; bitpos: [18]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_RETENTION_CLK_SEL    (BIT(18))
#define RTC_CNTL_RETENTION_CLK_SEL_M  (RTC_CNTL_RETENTION_CLK_SEL_V << RTC_CNTL_RETENTION_CLK_SEL_S)
#define RTC_CNTL_RETENTION_CLK_SEL_V  0x00000001U
#define RTC_CNTL_RETENTION_CLK_SEL_S  18
/** RTC_CNTL_RETENTION_DONE_WAIT : R/W; bitpos: [21:19]; default: 2;
 *  Need add description
 */
#define RTC_CNTL_RETENTION_DONE_WAIT    0x00000007U
#define RTC_CNTL_RETENTION_DONE_WAIT_M  (RTC_CNTL_RETENTION_DONE_WAIT_V << RTC_CNTL_RETENTION_DONE_WAIT_S)
#define RTC_CNTL_RETENTION_DONE_WAIT_V  0x00000007U
#define RTC_CNTL_RETENTION_DONE_WAIT_S  19
/** RTC_CNTL_RETENTION_CLKOFF_WAIT : R/W; bitpos: [25:22]; default: 3;
 *  Need add description
 */
#define RTC_CNTL_RETENTION_CLKOFF_WAIT    0x0000000FU
#define RTC_CNTL_RETENTION_CLKOFF_WAIT_M  (RTC_CNTL_RETENTION_CLKOFF_WAIT_V << RTC_CNTL_RETENTION_CLKOFF_WAIT_S)
#define RTC_CNTL_RETENTION_CLKOFF_WAIT_V  0x0000000FU
#define RTC_CNTL_RETENTION_CLKOFF_WAIT_S  22
/** RTC_CNTL_RETENTION_EN : R/W; bitpos: [26]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_RETENTION_EN    (BIT(26))
#define RTC_CNTL_RETENTION_EN_M  (RTC_CNTL_RETENTION_EN_V << RTC_CNTL_RETENTION_EN_S)
#define RTC_CNTL_RETENTION_EN_V  0x00000001U
#define RTC_CNTL_RETENTION_EN_S  26
/** RTC_CNTL_RETENTION_WAIT : R/W; bitpos: [31:27]; default: 20;
 *  wait cycles for rention operation
 */
#define RTC_CNTL_RETENTION_WAIT    0x0000001FU
#define RTC_CNTL_RETENTION_WAIT_M  (RTC_CNTL_RETENTION_WAIT_V << RTC_CNTL_RETENTION_WAIT_S)
#define RTC_CNTL_RETENTION_WAIT_V  0x0000001FU
#define RTC_CNTL_RETENTION_WAIT_S  27

/** RTC_CNTL_RETENTION_CTRL1_REG register
 *  register description
 */
#define RTC_CNTL_RETENTION_CTRL1_REG (DR_REG_RTCCNTL_BASE + 0x13c)
/** RTC_CNTL_RETENTION_LINK_ADDR : R/W; bitpos: [26:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_RETENTION_LINK_ADDR    0x07FFFFFFU
#define RTC_CNTL_RETENTION_LINK_ADDR_M  (RTC_CNTL_RETENTION_LINK_ADDR_V << RTC_CNTL_RETENTION_LINK_ADDR_S)
#define RTC_CNTL_RETENTION_LINK_ADDR_V  0x07FFFFFFU
#define RTC_CNTL_RETENTION_LINK_ADDR_S  0

/** RTC_CNTL_FIB_SEL_REG register
 *  register description
 */
#define RTC_CNTL_FIB_SEL_REG (DR_REG_RTCCNTL_BASE + 0x140)
/** RTC_CNTL_FIB_SEL : R/W; bitpos: [2:0]; default: 7;
 *  select use analog fib signal
 */
#define RTC_CNTL_FIB_SEL    0x00000007U
#define RTC_CNTL_FIB_SEL_M  (RTC_CNTL_FIB_SEL_V << RTC_CNTL_FIB_SEL_S)
#define RTC_CNTL_FIB_SEL_V  0x00000007U
#define RTC_CNTL_FIB_SEL_S  0

#define RTC_CNTL_FIB_GLITCH_RST BIT(0)
#define RTC_CNTL_FIB_BOR_RST BIT(1)
#define RTC_CNTL_FIB_SUPER_WDT_RST BIT(2)

/** RTC_CNTL_GPIO_WAKEUP_REG register
 *  register description
 */
#define RTC_CNTL_GPIO_WAKEUP_REG (DR_REG_RTCCNTL_BASE + 0x144)
/** RTC_CNTL_GPIO_WAKEUP_STATUS : RO; bitpos: [5:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_WAKEUP_STATUS    0x0000003FU
#define RTC_CNTL_GPIO_WAKEUP_STATUS_M  (RTC_CNTL_GPIO_WAKEUP_STATUS_V << RTC_CNTL_GPIO_WAKEUP_STATUS_S)
#define RTC_CNTL_GPIO_WAKEUP_STATUS_V  0x0000003FU
#define RTC_CNTL_GPIO_WAKEUP_STATUS_S  0
/** RTC_CNTL_GPIO_WAKEUP_STATUS_CLR : R/W; bitpos: [6]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_WAKEUP_STATUS_CLR    (BIT(6))
#define RTC_CNTL_GPIO_WAKEUP_STATUS_CLR_M  (RTC_CNTL_GPIO_WAKEUP_STATUS_CLR_V << RTC_CNTL_GPIO_WAKEUP_STATUS_CLR_S)
#define RTC_CNTL_GPIO_WAKEUP_STATUS_CLR_V  0x00000001U
#define RTC_CNTL_GPIO_WAKEUP_STATUS_CLR_S  6
/** RTC_CNTL_GPIO_PIN_CLK_GATE : R/W; bitpos: [7]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN_CLK_GATE    (BIT(7))
#define RTC_CNTL_GPIO_PIN_CLK_GATE_M  (RTC_CNTL_GPIO_PIN_CLK_GATE_V << RTC_CNTL_GPIO_PIN_CLK_GATE_S)
#define RTC_CNTL_GPIO_PIN_CLK_GATE_V  0x00000001U
#define RTC_CNTL_GPIO_PIN_CLK_GATE_S  7
/** RTC_CNTL_GPIO_PIN5_INT_TYPE : R/W; bitpos: [10:8]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN5_INT_TYPE    0x00000007U
#define RTC_CNTL_GPIO_PIN5_INT_TYPE_M  (RTC_CNTL_GPIO_PIN5_INT_TYPE_V << RTC_CNTL_GPIO_PIN5_INT_TYPE_S)
#define RTC_CNTL_GPIO_PIN5_INT_TYPE_V  0x00000007U
#define RTC_CNTL_GPIO_PIN5_INT_TYPE_S  8
/** RTC_CNTL_GPIO_PIN4_INT_TYPE : R/W; bitpos: [13:11]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN4_INT_TYPE    0x00000007U
#define RTC_CNTL_GPIO_PIN4_INT_TYPE_M  (RTC_CNTL_GPIO_PIN4_INT_TYPE_V << RTC_CNTL_GPIO_PIN4_INT_TYPE_S)
#define RTC_CNTL_GPIO_PIN4_INT_TYPE_V  0x00000007U
#define RTC_CNTL_GPIO_PIN4_INT_TYPE_S  11
/** RTC_CNTL_GPIO_PIN3_INT_TYPE : R/W; bitpos: [16:14]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN3_INT_TYPE    0x00000007U
#define RTC_CNTL_GPIO_PIN3_INT_TYPE_M  (RTC_CNTL_GPIO_PIN3_INT_TYPE_V << RTC_CNTL_GPIO_PIN3_INT_TYPE_S)
#define RTC_CNTL_GPIO_PIN3_INT_TYPE_V  0x00000007U
#define RTC_CNTL_GPIO_PIN3_INT_TYPE_S  14
/** RTC_CNTL_GPIO_PIN2_INT_TYPE : R/W; bitpos: [19:17]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN2_INT_TYPE    0x00000007U
#define RTC_CNTL_GPIO_PIN2_INT_TYPE_M  (RTC_CNTL_GPIO_PIN2_INT_TYPE_V << RTC_CNTL_GPIO_PIN2_INT_TYPE_S)
#define RTC_CNTL_GPIO_PIN2_INT_TYPE_V  0x00000007U
#define RTC_CNTL_GPIO_PIN2_INT_TYPE_S  17
/** RTC_CNTL_GPIO_PIN1_INT_TYPE : R/W; bitpos: [22:20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN1_INT_TYPE    0x00000007U
#define RTC_CNTL_GPIO_PIN1_INT_TYPE_M  (RTC_CNTL_GPIO_PIN1_INT_TYPE_V << RTC_CNTL_GPIO_PIN1_INT_TYPE_S)
#define RTC_CNTL_GPIO_PIN1_INT_TYPE_V  0x00000007U
#define RTC_CNTL_GPIO_PIN1_INT_TYPE_S  20
/** RTC_CNTL_GPIO_PIN0_INT_TYPE : R/W; bitpos: [25:23]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN0_INT_TYPE    0x00000007U
#define RTC_CNTL_GPIO_PIN0_INT_TYPE_M  (RTC_CNTL_GPIO_PIN0_INT_TYPE_V << RTC_CNTL_GPIO_PIN0_INT_TYPE_S)
#define RTC_CNTL_GPIO_PIN0_INT_TYPE_V  0x00000007U
#define RTC_CNTL_GPIO_PIN0_INT_TYPE_S  23
/** RTC_CNTL_GPIO_PIN5_WAKEUP_ENABLE : R/W; bitpos: [26]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN5_WAKEUP_ENABLE    (BIT(26))
#define RTC_CNTL_GPIO_PIN5_WAKEUP_ENABLE_M  (RTC_CNTL_GPIO_PIN5_WAKEUP_ENABLE_V << RTC_CNTL_GPIO_PIN5_WAKEUP_ENABLE_S)
#define RTC_CNTL_GPIO_PIN5_WAKEUP_ENABLE_V  0x00000001U
#define RTC_CNTL_GPIO_PIN5_WAKEUP_ENABLE_S  26
/** RTC_CNTL_GPIO_PIN4_WAKEUP_ENABLE : R/W; bitpos: [27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN4_WAKEUP_ENABLE    (BIT(27))
#define RTC_CNTL_GPIO_PIN4_WAKEUP_ENABLE_M  (RTC_CNTL_GPIO_PIN4_WAKEUP_ENABLE_V << RTC_CNTL_GPIO_PIN4_WAKEUP_ENABLE_S)
#define RTC_CNTL_GPIO_PIN4_WAKEUP_ENABLE_V  0x00000001U
#define RTC_CNTL_GPIO_PIN4_WAKEUP_ENABLE_S  27
/** RTC_CNTL_GPIO_PIN3_WAKEUP_ENABLE : R/W; bitpos: [28]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN3_WAKEUP_ENABLE    (BIT(28))
#define RTC_CNTL_GPIO_PIN3_WAKEUP_ENABLE_M  (RTC_CNTL_GPIO_PIN3_WAKEUP_ENABLE_V << RTC_CNTL_GPIO_PIN3_WAKEUP_ENABLE_S)
#define RTC_CNTL_GPIO_PIN3_WAKEUP_ENABLE_V  0x00000001U
#define RTC_CNTL_GPIO_PIN3_WAKEUP_ENABLE_S  28
/** RTC_CNTL_GPIO_PIN2_WAKEUP_ENABLE : R/W; bitpos: [29]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN2_WAKEUP_ENABLE    (BIT(29))
#define RTC_CNTL_GPIO_PIN2_WAKEUP_ENABLE_M  (RTC_CNTL_GPIO_PIN2_WAKEUP_ENABLE_V << RTC_CNTL_GPIO_PIN2_WAKEUP_ENABLE_S)
#define RTC_CNTL_GPIO_PIN2_WAKEUP_ENABLE_V  0x00000001U
#define RTC_CNTL_GPIO_PIN2_WAKEUP_ENABLE_S  29
/** RTC_CNTL_GPIO_PIN1_WAKEUP_ENABLE : R/W; bitpos: [30]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN1_WAKEUP_ENABLE    (BIT(30))
#define RTC_CNTL_GPIO_PIN1_WAKEUP_ENABLE_M  (RTC_CNTL_GPIO_PIN1_WAKEUP_ENABLE_V << RTC_CNTL_GPIO_PIN1_WAKEUP_ENABLE_S)
#define RTC_CNTL_GPIO_PIN1_WAKEUP_ENABLE_V  0x00000001U
#define RTC_CNTL_GPIO_PIN1_WAKEUP_ENABLE_S  30
/** RTC_CNTL_GPIO_PIN0_WAKEUP_ENABLE : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN0_WAKEUP_ENABLE    (BIT(31))
#define RTC_CNTL_GPIO_PIN0_WAKEUP_ENABLE_M  (RTC_CNTL_GPIO_PIN0_WAKEUP_ENABLE_V << RTC_CNTL_GPIO_PIN0_WAKEUP_ENABLE_S)
#define RTC_CNTL_GPIO_PIN0_WAKEUP_ENABLE_V  0x00000001U
#define RTC_CNTL_GPIO_PIN0_WAKEUP_ENABLE_S  31

/** RTC_CNTL_DBG_SEL_REG register
 *  register description
 */
#define RTC_CNTL_DBG_SEL_REG (DR_REG_RTCCNTL_BASE + 0x148)
/** RTC_CNTL_MTDI_ENAMUX : R/W; bitpos: [0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_MTDI_ENAMUX    (BIT(0))
#define RTC_CNTL_MTDI_ENAMUX_M  (RTC_CNTL_MTDI_ENAMUX_V << RTC_CNTL_MTDI_ENAMUX_S)
#define RTC_CNTL_MTDI_ENAMUX_V  0x00000001U
#define RTC_CNTL_MTDI_ENAMUX_S  0
/** RTC_CNTL_DEBUG_12M_NO_GATING : R/W; bitpos: [1]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DEBUG_12M_NO_GATING    (BIT(1))
#define RTC_CNTL_DEBUG_12M_NO_GATING_M  (RTC_CNTL_DEBUG_12M_NO_GATING_V << RTC_CNTL_DEBUG_12M_NO_GATING_S)
#define RTC_CNTL_DEBUG_12M_NO_GATING_V  0x00000001U
#define RTC_CNTL_DEBUG_12M_NO_GATING_S  1
/** RTC_CNTL_DEBUG_BIT_SEL : R/W; bitpos: [6:2]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DEBUG_BIT_SEL    0x0000001FU
#define RTC_CNTL_DEBUG_BIT_SEL_M  (RTC_CNTL_DEBUG_BIT_SEL_V << RTC_CNTL_DEBUG_BIT_SEL_S)
#define RTC_CNTL_DEBUG_BIT_SEL_V  0x0000001FU
#define RTC_CNTL_DEBUG_BIT_SEL_S  2
/** RTC_CNTL_DEBUG_SEL0 : R/W; bitpos: [11:7]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DEBUG_SEL0    0x0000001FU
#define RTC_CNTL_DEBUG_SEL0_M  (RTC_CNTL_DEBUG_SEL0_V << RTC_CNTL_DEBUG_SEL0_S)
#define RTC_CNTL_DEBUG_SEL0_V  0x0000001FU
#define RTC_CNTL_DEBUG_SEL0_S  7
/** RTC_CNTL_DEBUG_SEL1 : R/W; bitpos: [16:12]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DEBUG_SEL1    0x0000001FU
#define RTC_CNTL_DEBUG_SEL1_M  (RTC_CNTL_DEBUG_SEL1_V << RTC_CNTL_DEBUG_SEL1_S)
#define RTC_CNTL_DEBUG_SEL1_V  0x0000001FU
#define RTC_CNTL_DEBUG_SEL1_S  12
/** RTC_CNTL_DEBUG_SEL2 : R/W; bitpos: [21:17]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DEBUG_SEL2    0x0000001FU
#define RTC_CNTL_DEBUG_SEL2_M  (RTC_CNTL_DEBUG_SEL2_V << RTC_CNTL_DEBUG_SEL2_S)
#define RTC_CNTL_DEBUG_SEL2_V  0x0000001FU
#define RTC_CNTL_DEBUG_SEL2_S  17
/** RTC_CNTL_DEBUG_SEL3 : R/W; bitpos: [26:22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DEBUG_SEL3    0x0000001FU
#define RTC_CNTL_DEBUG_SEL3_M  (RTC_CNTL_DEBUG_SEL3_V << RTC_CNTL_DEBUG_SEL3_S)
#define RTC_CNTL_DEBUG_SEL3_V  0x0000001FU
#define RTC_CNTL_DEBUG_SEL3_S  22
/** RTC_CNTL_DEBUG_SEL4 : R/W; bitpos: [31:27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DEBUG_SEL4    0x0000001FU
#define RTC_CNTL_DEBUG_SEL4_M  (RTC_CNTL_DEBUG_SEL4_V << RTC_CNTL_DEBUG_SEL4_S)
#define RTC_CNTL_DEBUG_SEL4_V  0x0000001FU
#define RTC_CNTL_DEBUG_SEL4_S  27

/** RTC_CNTL_DBG_MAP_REG register
 *  register description
 */
#define RTC_CNTL_DBG_MAP_REG (DR_REG_RTCCNTL_BASE + 0x14c)
/** RTC_CNTL_VDD_DIG_TEST : R/W; bitpos: [1:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VDD_DIG_TEST    0x00000003U
#define RTC_CNTL_VDD_DIG_TEST_M  (RTC_CNTL_VDD_DIG_TEST_V << RTC_CNTL_VDD_DIG_TEST_S)
#define RTC_CNTL_VDD_DIG_TEST_V  0x00000003U
#define RTC_CNTL_VDD_DIG_TEST_S  0
/** RTC_CNTL_GPIO_PIN5_MUX_SEL : R/W; bitpos: [2]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN5_MUX_SEL    (BIT(2))
#define RTC_CNTL_GPIO_PIN5_MUX_SEL_M  (RTC_CNTL_GPIO_PIN5_MUX_SEL_V << RTC_CNTL_GPIO_PIN5_MUX_SEL_S)
#define RTC_CNTL_GPIO_PIN5_MUX_SEL_V  0x00000001U
#define RTC_CNTL_GPIO_PIN5_MUX_SEL_S  2
/** RTC_CNTL_GPIO_PIN4_MUX_SEL : R/W; bitpos: [3]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN4_MUX_SEL    (BIT(3))
#define RTC_CNTL_GPIO_PIN4_MUX_SEL_M  (RTC_CNTL_GPIO_PIN4_MUX_SEL_V << RTC_CNTL_GPIO_PIN4_MUX_SEL_S)
#define RTC_CNTL_GPIO_PIN4_MUX_SEL_V  0x00000001U
#define RTC_CNTL_GPIO_PIN4_MUX_SEL_S  3
/** RTC_CNTL_GPIO_PIN3_MUX_SEL : R/W; bitpos: [4]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN3_MUX_SEL    (BIT(4))
#define RTC_CNTL_GPIO_PIN3_MUX_SEL_M  (RTC_CNTL_GPIO_PIN3_MUX_SEL_V << RTC_CNTL_GPIO_PIN3_MUX_SEL_S)
#define RTC_CNTL_GPIO_PIN3_MUX_SEL_V  0x00000001U
#define RTC_CNTL_GPIO_PIN3_MUX_SEL_S  4
/** RTC_CNTL_GPIO_PIN2_MUX_SEL : R/W; bitpos: [5]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN2_MUX_SEL    (BIT(5))
#define RTC_CNTL_GPIO_PIN2_MUX_SEL_M  (RTC_CNTL_GPIO_PIN2_MUX_SEL_V << RTC_CNTL_GPIO_PIN2_MUX_SEL_S)
#define RTC_CNTL_GPIO_PIN2_MUX_SEL_V  0x00000001U
#define RTC_CNTL_GPIO_PIN2_MUX_SEL_S  5
/** RTC_CNTL_GPIO_PIN1_MUX_SEL : R/W; bitpos: [6]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN1_MUX_SEL    (BIT(6))
#define RTC_CNTL_GPIO_PIN1_MUX_SEL_M  (RTC_CNTL_GPIO_PIN1_MUX_SEL_V << RTC_CNTL_GPIO_PIN1_MUX_SEL_S)
#define RTC_CNTL_GPIO_PIN1_MUX_SEL_V  0x00000001U
#define RTC_CNTL_GPIO_PIN1_MUX_SEL_S  6
/** RTC_CNTL_GPIO_PIN0_MUX_SEL : R/W; bitpos: [7]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN0_MUX_SEL    (BIT(7))
#define RTC_CNTL_GPIO_PIN0_MUX_SEL_M  (RTC_CNTL_GPIO_PIN0_MUX_SEL_V << RTC_CNTL_GPIO_PIN0_MUX_SEL_S)
#define RTC_CNTL_GPIO_PIN0_MUX_SEL_V  0x00000001U
#define RTC_CNTL_GPIO_PIN0_MUX_SEL_S  7
/** RTC_CNTL_GPIO_PIN5_FUN_SEL : R/W; bitpos: [11:8]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN5_FUN_SEL    0x0000000FU
#define RTC_CNTL_GPIO_PIN5_FUN_SEL_M  (RTC_CNTL_GPIO_PIN5_FUN_SEL_V << RTC_CNTL_GPIO_PIN5_FUN_SEL_S)
#define RTC_CNTL_GPIO_PIN5_FUN_SEL_V  0x0000000FU
#define RTC_CNTL_GPIO_PIN5_FUN_SEL_S  8
/** RTC_CNTL_GPIO_PIN4_FUN_SEL : R/W; bitpos: [15:12]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN4_FUN_SEL    0x0000000FU
#define RTC_CNTL_GPIO_PIN4_FUN_SEL_M  (RTC_CNTL_GPIO_PIN4_FUN_SEL_V << RTC_CNTL_GPIO_PIN4_FUN_SEL_S)
#define RTC_CNTL_GPIO_PIN4_FUN_SEL_V  0x0000000FU
#define RTC_CNTL_GPIO_PIN4_FUN_SEL_S  12
/** RTC_CNTL_GPIO_PIN3_FUN_SEL : R/W; bitpos: [19:16]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN3_FUN_SEL    0x0000000FU
#define RTC_CNTL_GPIO_PIN3_FUN_SEL_M  (RTC_CNTL_GPIO_PIN3_FUN_SEL_V << RTC_CNTL_GPIO_PIN3_FUN_SEL_S)
#define RTC_CNTL_GPIO_PIN3_FUN_SEL_V  0x0000000FU
#define RTC_CNTL_GPIO_PIN3_FUN_SEL_S  16
/** RTC_CNTL_GPIO_PIN2_FUN_SEL : R/W; bitpos: [23:20]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN2_FUN_SEL    0x0000000FU
#define RTC_CNTL_GPIO_PIN2_FUN_SEL_M  (RTC_CNTL_GPIO_PIN2_FUN_SEL_V << RTC_CNTL_GPIO_PIN2_FUN_SEL_S)
#define RTC_CNTL_GPIO_PIN2_FUN_SEL_V  0x0000000FU
#define RTC_CNTL_GPIO_PIN2_FUN_SEL_S  20
/** RTC_CNTL_GPIO_PIN1_FUN_SEL : R/W; bitpos: [27:24]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN1_FUN_SEL    0x0000000FU
#define RTC_CNTL_GPIO_PIN1_FUN_SEL_M  (RTC_CNTL_GPIO_PIN1_FUN_SEL_V << RTC_CNTL_GPIO_PIN1_FUN_SEL_S)
#define RTC_CNTL_GPIO_PIN1_FUN_SEL_V  0x0000000FU
#define RTC_CNTL_GPIO_PIN1_FUN_SEL_S  24
/** RTC_CNTL_GPIO_PIN0_FUN_SEL : R/W; bitpos: [31:28]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_GPIO_PIN0_FUN_SEL    0x0000000FU
#define RTC_CNTL_GPIO_PIN0_FUN_SEL_M  (RTC_CNTL_GPIO_PIN0_FUN_SEL_V << RTC_CNTL_GPIO_PIN0_FUN_SEL_S)
#define RTC_CNTL_GPIO_PIN0_FUN_SEL_V  0x0000000FU
#define RTC_CNTL_GPIO_PIN0_FUN_SEL_S  28

/** RTC_CNTL_DBG_SAR_SEL_REG register
 *  register description
 */
#define RTC_CNTL_DBG_SAR_SEL_REG (DR_REG_RTCCNTL_BASE + 0x150)
/** RTC_CNTL_SAR_DEBUG_SEL : R/W; bitpos: [31:27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SAR_DEBUG_SEL    0x0000001FU
#define RTC_CNTL_SAR_DEBUG_SEL_M  (RTC_CNTL_SAR_DEBUG_SEL_V << RTC_CNTL_SAR_DEBUG_SEL_S)
#define RTC_CNTL_SAR_DEBUG_SEL_V  0x0000001FU
#define RTC_CNTL_SAR_DEBUG_SEL_S  27

/** RTC_CNTL_PG_CTRL_REG register
 *  register description
 */
#define RTC_CNTL_PG_CTRL_REG (DR_REG_RTCCNTL_BASE + 0x154)
/** RTC_CNTL_POWER_GLITCH_DSENSE : R/W; bitpos: [27:26]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_POWER_GLITCH_DSENSE    0x00000003U
#define RTC_CNTL_POWER_GLITCH_DSENSE_M  (RTC_CNTL_POWER_GLITCH_DSENSE_V << RTC_CNTL_POWER_GLITCH_DSENSE_S)
#define RTC_CNTL_POWER_GLITCH_DSENSE_V  0x00000003U
#define RTC_CNTL_POWER_GLITCH_DSENSE_S  26
/** RTC_CNTL_POWER_GLITCH_FORCE_PD : R/W; bitpos: [28]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_POWER_GLITCH_FORCE_PD    (BIT(28))
#define RTC_CNTL_POWER_GLITCH_FORCE_PD_M  (RTC_CNTL_POWER_GLITCH_FORCE_PD_V << RTC_CNTL_POWER_GLITCH_FORCE_PD_S)
#define RTC_CNTL_POWER_GLITCH_FORCE_PD_V  0x00000001U
#define RTC_CNTL_POWER_GLITCH_FORCE_PD_S  28
/** RTC_CNTL_POWER_GLITCH_FORCE_PU : R/W; bitpos: [29]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_POWER_GLITCH_FORCE_PU    (BIT(29))
#define RTC_CNTL_POWER_GLITCH_FORCE_PU_M  (RTC_CNTL_POWER_GLITCH_FORCE_PU_V << RTC_CNTL_POWER_GLITCH_FORCE_PU_S)
#define RTC_CNTL_POWER_GLITCH_FORCE_PU_V  0x00000001U
#define RTC_CNTL_POWER_GLITCH_FORCE_PU_S  29
/** RTC_CNTL_POWER_GLITCH_EFUSE_SEL : R/W; bitpos: [30]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_POWER_GLITCH_EFUSE_SEL    (BIT(30))
#define RTC_CNTL_POWER_GLITCH_EFUSE_SEL_M  (RTC_CNTL_POWER_GLITCH_EFUSE_SEL_V << RTC_CNTL_POWER_GLITCH_EFUSE_SEL_S)
#define RTC_CNTL_POWER_GLITCH_EFUSE_SEL_V  0x00000001U
#define RTC_CNTL_POWER_GLITCH_EFUSE_SEL_S  30
/** RTC_CNTL_POWER_GLITCH_EN : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_POWER_GLITCH_EN    (BIT(31))
#define RTC_CNTL_POWER_GLITCH_EN_M  (RTC_CNTL_POWER_GLITCH_EN_V << RTC_CNTL_POWER_GLITCH_EN_S)
#define RTC_CNTL_POWER_GLITCH_EN_V  0x00000001U
#define RTC_CNTL_POWER_GLITCH_EN_S  31

/** RTC_CNTL_DCDC_CTRL0_REG register
 *  register description
 */
#define RTC_CNTL_DCDC_CTRL0_REG (DR_REG_RTCCNTL_BASE + 0x158)
/** RTC_CNTL_VSET_DCDC_VALUE : RO; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_VALUE    0x0000001FU
#define RTC_CNTL_VSET_DCDC_VALUE_M  (RTC_CNTL_VSET_DCDC_VALUE_V << RTC_CNTL_VSET_DCDC_VALUE_S)
#define RTC_CNTL_VSET_DCDC_VALUE_V  0x0000001FU
#define RTC_CNTL_VSET_DCDC_VALUE_S  0
/** RTC_CNTL_POWER_GOOD_DCDC : RO; bitpos: [5]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_POWER_GOOD_DCDC    (BIT(5))
#define RTC_CNTL_POWER_GOOD_DCDC_M  (RTC_CNTL_POWER_GOOD_DCDC_V << RTC_CNTL_POWER_GOOD_DCDC_S)
#define RTC_CNTL_POWER_GOOD_DCDC_V  0x00000001U
#define RTC_CNTL_POWER_GOOD_DCDC_S  5
/** RTC_CNTL_PMU_MODE : R/W; bitpos: [20:19]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_PMU_MODE    0x00000003U
#define RTC_CNTL_PMU_MODE_M  (RTC_CNTL_PMU_MODE_V << RTC_CNTL_PMU_MODE_S)
#define RTC_CNTL_PMU_MODE_V  0x00000003U
#define RTC_CNTL_PMU_MODE_S  19
/** RTC_CNTL_RAMPLEVEL_DCDC : R/W; bitpos: [21]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_RAMPLEVEL_DCDC    (BIT(21))
#define RTC_CNTL_RAMPLEVEL_DCDC_M  (RTC_CNTL_RAMPLEVEL_DCDC_V << RTC_CNTL_RAMPLEVEL_DCDC_S)
#define RTC_CNTL_RAMPLEVEL_DCDC_V  0x00000001U
#define RTC_CNTL_RAMPLEVEL_DCDC_S  21
/** RTC_CNTL_RAMP_DCDC : R/W; bitpos: [22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_RAMP_DCDC    (BIT(22))
#define RTC_CNTL_RAMP_DCDC_M  (RTC_CNTL_RAMP_DCDC_V << RTC_CNTL_RAMP_DCDC_S)
#define RTC_CNTL_RAMP_DCDC_V  0x00000001U
#define RTC_CNTL_RAMP_DCDC_S  22
/** RTC_CNTL_DCM2ENB_DCDC : R/W; bitpos: [23]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DCM2ENB_DCDC    (BIT(23))
#define RTC_CNTL_DCM2ENB_DCDC_M  (RTC_CNTL_DCM2ENB_DCDC_V << RTC_CNTL_DCM2ENB_DCDC_S)
#define RTC_CNTL_DCM2ENB_DCDC_V  0x00000001U
#define RTC_CNTL_DCM2ENB_DCDC_S  23
/** RTC_CNTL_DCMLEVEL_DCDC : R/W; bitpos: [25:24]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_DCMLEVEL_DCDC    0x00000003U
#define RTC_CNTL_DCMLEVEL_DCDC_M  (RTC_CNTL_DCMLEVEL_DCDC_V << RTC_CNTL_DCMLEVEL_DCDC_S)
#define RTC_CNTL_DCMLEVEL_DCDC_V  0x00000003U
#define RTC_CNTL_DCMLEVEL_DCDC_S  24
/** RTC_CNTL_FSW_DCDC : R/W; bitpos: [28:26]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_FSW_DCDC    0x00000007U
#define RTC_CNTL_FSW_DCDC_M  (RTC_CNTL_FSW_DCDC_V << RTC_CNTL_FSW_DCDC_S)
#define RTC_CNTL_FSW_DCDC_V  0x00000007U
#define RTC_CNTL_FSW_DCDC_S  26
/** RTC_CNTL_CCM_DCDC : R/W; bitpos: [29]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_CCM_DCDC    (BIT(29))
#define RTC_CNTL_CCM_DCDC_M  (RTC_CNTL_CCM_DCDC_V << RTC_CNTL_CCM_DCDC_S)
#define RTC_CNTL_CCM_DCDC_V  0x00000001U
#define RTC_CNTL_CCM_DCDC_S  29
/** RTC_CNTL_SSTIME_DCDC : R/W; bitpos: [30]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_SSTIME_DCDC    (BIT(30))
#define RTC_CNTL_SSTIME_DCDC_M  (RTC_CNTL_SSTIME_DCDC_V << RTC_CNTL_SSTIME_DCDC_S)
#define RTC_CNTL_SSTIME_DCDC_V  0x00000001U
#define RTC_CNTL_SSTIME_DCDC_S  30
/** RTC_CNTL_POCPENB_DCDC : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_POCPENB_DCDC    (BIT(31))
#define RTC_CNTL_POCPENB_DCDC_M  (RTC_CNTL_POCPENB_DCDC_V << RTC_CNTL_POCPENB_DCDC_S)
#define RTC_CNTL_POCPENB_DCDC_V  0x00000001U
#define RTC_CNTL_POCPENB_DCDC_S  31

/** RTC_CNTL_DCDC_CTRL1_REG register
 *  register description
 */
#define RTC_CNTL_DCDC_CTRL1_REG (DR_REG_RTCCNTL_BASE + 0x15c)
/** RTC_CNTL_DCDC_MODE_SLP : R/W; bitpos: [25:23]; default: 4;
 *  Need add description
 */
#define RTC_CNTL_DCDC_MODE_SLP    0x00000007U
#define RTC_CNTL_DCDC_MODE_SLP_M  (RTC_CNTL_DCDC_MODE_SLP_V << RTC_CNTL_DCDC_MODE_SLP_S)
#define RTC_CNTL_DCDC_MODE_SLP_V  0x00000007U
#define RTC_CNTL_DCDC_MODE_SLP_S  23
/** RTC_CNTL_DCDC_MODE_MONITOR : R/W; bitpos: [28:26]; default: 4;
 *  Need add description
 */
#define RTC_CNTL_DCDC_MODE_MONITOR    0x00000007U
#define RTC_CNTL_DCDC_MODE_MONITOR_M  (RTC_CNTL_DCDC_MODE_MONITOR_V << RTC_CNTL_DCDC_MODE_MONITOR_S)
#define RTC_CNTL_DCDC_MODE_MONITOR_V  0x00000007U
#define RTC_CNTL_DCDC_MODE_MONITOR_S  26
/** RTC_CNTL_DCDC_MODE_IDLE : R/W; bitpos: [31:29]; default: 4;
 *  Need add description
 */
#define RTC_CNTL_DCDC_MODE_IDLE    0x00000007U
#define RTC_CNTL_DCDC_MODE_IDLE_M  (RTC_CNTL_DCDC_MODE_IDLE_V << RTC_CNTL_DCDC_MODE_IDLE_S)
#define RTC_CNTL_DCDC_MODE_IDLE_V  0x00000007U
#define RTC_CNTL_DCDC_MODE_IDLE_S  29

/** RTC_CNTL_DCDC_CTRL2_REG register
 *  register description
 */
#define RTC_CNTL_DCDC_CTRL2_REG (DR_REG_RTCCNTL_BASE + 0x160)
/** RTC_CNTL_VSET_DCDC_TARGET_VALUE1 : R/W; bitpos: [4:0]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_TARGET_VALUE1    0x0000001FU
#define RTC_CNTL_VSET_DCDC_TARGET_VALUE1_M  (RTC_CNTL_VSET_DCDC_TARGET_VALUE1_V << RTC_CNTL_VSET_DCDC_TARGET_VALUE1_S)
#define RTC_CNTL_VSET_DCDC_TARGET_VALUE1_V  0x0000001FU
#define RTC_CNTL_VSET_DCDC_TARGET_VALUE1_S  0
/** RTC_CNTL_VSET_DCDC_TARGET_VALUE0 : R/W; bitpos: [9:5]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_TARGET_VALUE0    0x0000001FU
#define RTC_CNTL_VSET_DCDC_TARGET_VALUE0_M  (RTC_CNTL_VSET_DCDC_TARGET_VALUE0_V << RTC_CNTL_VSET_DCDC_TARGET_VALUE0_S)
#define RTC_CNTL_VSET_DCDC_TARGET_VALUE0_V  0x0000001FU
#define RTC_CNTL_VSET_DCDC_TARGET_VALUE0_S  5
/** RTC_CNTL_VSET_DCDC_INIT_VALUE : R/W; bitpos: [14:10]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_INIT_VALUE    0x0000001FU
#define RTC_CNTL_VSET_DCDC_INIT_VALUE_M  (RTC_CNTL_VSET_DCDC_INIT_VALUE_V << RTC_CNTL_VSET_DCDC_INIT_VALUE_S)
#define RTC_CNTL_VSET_DCDC_INIT_VALUE_V  0x0000001FU
#define RTC_CNTL_VSET_DCDC_INIT_VALUE_S  10
/** RTC_CNTL_VSET_DCDC_INIT : WO; bitpos: [15]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_INIT    (BIT(15))
#define RTC_CNTL_VSET_DCDC_INIT_M  (RTC_CNTL_VSET_DCDC_INIT_V << RTC_CNTL_VSET_DCDC_INIT_S)
#define RTC_CNTL_VSET_DCDC_INIT_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_INIT_S  15
/** RTC_CNTL_VSET_DCDC_FIX : R/W; bitpos: [16]; default: 1;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_FIX    (BIT(16))
#define RTC_CNTL_VSET_DCDC_FIX_M  (RTC_CNTL_VSET_DCDC_FIX_V << RTC_CNTL_VSET_DCDC_FIX_S)
#define RTC_CNTL_VSET_DCDC_FIX_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_FIX_S  16
/** RTC_CNTL_VSET_DCDC_STEP : R/W; bitpos: [21:17]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_STEP    0x0000001FU
#define RTC_CNTL_VSET_DCDC_STEP_M  (RTC_CNTL_VSET_DCDC_STEP_V << RTC_CNTL_VSET_DCDC_STEP_S)
#define RTC_CNTL_VSET_DCDC_STEP_V  0x0000001FU
#define RTC_CNTL_VSET_DCDC_STEP_S  17
/** RTC_CNTL_VSET_DCDC_GAP : R/W; bitpos: [26:22]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_GAP    0x0000001FU
#define RTC_CNTL_VSET_DCDC_GAP_M  (RTC_CNTL_VSET_DCDC_GAP_V << RTC_CNTL_VSET_DCDC_GAP_S)
#define RTC_CNTL_VSET_DCDC_GAP_V  0x0000001FU
#define RTC_CNTL_VSET_DCDC_GAP_S  22
/** RTC_CNTL_VSET_DCDC_SEL_HW_SW : R/W; bitpos: [27]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_SEL_HW_SW    (BIT(27))
#define RTC_CNTL_VSET_DCDC_SEL_HW_SW_M  (RTC_CNTL_VSET_DCDC_SEL_HW_SW_V << RTC_CNTL_VSET_DCDC_SEL_HW_SW_S)
#define RTC_CNTL_VSET_DCDC_SEL_HW_SW_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_SEL_HW_SW_S  27
/** RTC_CNTL_VSET_DCDC_SW_SEL : R/W; bitpos: [28]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_VSET_DCDC_SW_SEL    (BIT(28))
#define RTC_CNTL_VSET_DCDC_SW_SEL_M  (RTC_CNTL_VSET_DCDC_SW_SEL_V << RTC_CNTL_VSET_DCDC_SW_SEL_S)
#define RTC_CNTL_VSET_DCDC_SW_SEL_V  0x00000001U
#define RTC_CNTL_VSET_DCDC_SW_SEL_S  28

/** RTC_CNTL_RC32K_CTRL_REG register
 *  register description
 */
#define RTC_CNTL_RC32K_CTRL_REG (DR_REG_RTCCNTL_BASE + 0x164)
/** RTC_CNTL_RC32K_DFREQ : R/W; bitpos: [30:21]; default: 511;
 *  Need add description
 */
#define RTC_CNTL_RC32K_DFREQ    0x000003FFU
#define RTC_CNTL_RC32K_DFREQ_M  (RTC_CNTL_RC32K_DFREQ_V << RTC_CNTL_RC32K_DFREQ_S)
#define RTC_CNTL_RC32K_DFREQ_V  0x000003FFU
#define RTC_CNTL_RC32K_DFREQ_S  21
/** RTC_CNTL_RC32K_XPD : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_RC32K_XPD    (BIT(31))
#define RTC_CNTL_RC32K_XPD_M  (RTC_CNTL_RC32K_XPD_V << RTC_CNTL_RC32K_XPD_S)
#define RTC_CNTL_RC32K_XPD_V  0x00000001U
#define RTC_CNTL_RC32K_XPD_S  31

/** RTC_CNTL_PLL8M_REG register
 *  register description
 */
#define RTC_CNTL_PLL8M_REG (DR_REG_RTCCNTL_BASE + 0x168)
/** RTC_CNTL_CKREF_PLL8M_SEL : R/W; bitpos: [30]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_CKREF_PLL8M_SEL    (BIT(30))
#define RTC_CNTL_CKREF_PLL8M_SEL_M  (RTC_CNTL_CKREF_PLL8M_SEL_V << RTC_CNTL_CKREF_PLL8M_SEL_S)
#define RTC_CNTL_CKREF_PLL8M_SEL_V  0x00000001U
#define RTC_CNTL_CKREF_PLL8M_SEL_S  30
/** RTC_CNTL_XPD_PLL8M : R/W; bitpos: [31]; default: 0;
 *  Need add description
 */
#define RTC_CNTL_XPD_PLL8M    (BIT(31))
#define RTC_CNTL_XPD_PLL8M_M  (RTC_CNTL_XPD_PLL8M_V << RTC_CNTL_XPD_PLL8M_S)
#define RTC_CNTL_XPD_PLL8M_V  0x00000001U
#define RTC_CNTL_XPD_PLL8M_S  31

/** RTC_CNTL_DATE_REG register
 *  register description
 */
#define RTC_CNTL_DATE_REG (DR_REG_RTCCNTL_BASE + 0x1fc)
/** RTC_CNTL_DATE : R/W; bitpos: [27:0]; default: 34640480;
 *  Need add description
 */
#define RTC_CNTL_DATE    0x0FFFFFFFU
#define RTC_CNTL_DATE_M  (RTC_CNTL_DATE_V << RTC_CNTL_DATE_S)
#define RTC_CNTL_DATE_V  0x0FFFFFFFU
#define RTC_CNTL_DATE_S  0

#ifdef __cplusplus
}
#endif
