/*
 * SPDX-FileCopyrightText: 2017-2021 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef _SOC_SENSITIVE_REG_H_
#define _SOC_SENSITIVE_REG_H_

#include "soc/soc.h"

#ifdef __cplusplus
extern "C" {
#endif
#define SENSITIVE_ROM_TABLE_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x000)
/* SENSITIVE_ROM_TABLE_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_ROM_TABLE_LOCK  (BIT(0))
#define SENSITIVE_ROM_TABLE_LOCK_M  (BIT(0))
#define SENSITIVE_ROM_TABLE_LOCK_V  0x1
#define SENSITIVE_ROM_TABLE_LOCK_S  0

#define SENSITIVE_ROM_TABLE_REG          (DR_REG_SENSITIVE_BASE + 0x004)
/* SENSITIVE_ROM_TABLE : R/W ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: */
#define SENSITIVE_ROM_TABLE  0xFFFFFFFF
#define SENSITIVE_ROM_TABLE_M  ((SENSITIVE_ROM_TABLE_V)<<(SENSITIVE_ROM_TABLE_S))
#define SENSITIVE_ROM_TABLE_V  0xFFFFFFFF
#define SENSITIVE_ROM_TABLE_S  0

#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_REG          (DR_REG_SENSITIVE_BASE + 0x008)
/* SENSITIVE_PRIVILEGE_MODE_SEL_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK  (BIT(0))
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_M  (BIT(0))
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_V  0x1
#define SENSITIVE_PRIVILEGE_MODE_SEL_LOCK_S  0

#define SENSITIVE_PRIVILEGE_MODE_SEL_REG          (DR_REG_SENSITIVE_BASE + 0x00C)
/* SENSITIVE_PRIVILEGE_MODE_SEL : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_PRIVILEGE_MODE_SEL  (BIT(0))
#define SENSITIVE_PRIVILEGE_MODE_SEL_M  (BIT(0))
#define SENSITIVE_PRIVILEGE_MODE_SEL_V  0x1
#define SENSITIVE_PRIVILEGE_MODE_SEL_S  0

#define SENSITIVE_APB_PERIPHERAL_ACCESS_0_REG          (DR_REG_SENSITIVE_BASE + 0x010)
/* SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK  (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_M  (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_V  0x1
#define SENSITIVE_APB_PERIPHERAL_ACCESS_LOCK_S  0

#define SENSITIVE_APB_PERIPHERAL_ACCESS_1_REG          (DR_REG_SENSITIVE_BASE + 0x014)
/* SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: */
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST  (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_M  (BIT(0))
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_V  0x1
#define SENSITIVE_APB_PERIPHERAL_ACCESS_SPLIT_BURST_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_0_REG          (DR_REG_SENSITIVE_BASE + 0x018)
/* SENSITIVE_INTERNAL_SRAM_USAGE_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK  (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_M  (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_V  0x1
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOCK_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_1_REG          (DR_REG_SENSITIVE_BASE + 0x01C)
/* SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM : R/W ;bitpos:[3:1] ;default: ~3'h0 ; */
/*description: */
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM  0x00000007
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_M  ((SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_V)<<(SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_S))
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_V  0x7
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_SRAM_S  1
/* SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE : R/W ;bitpos:[0] ;default: ~1'h0 ; */
/*description: */
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE  (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE_M  (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE_V  0x1
#define SENSITIVE_INTERNAL_SRAM_USAGE_CPU_CACHE_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_3_REG          (DR_REG_SENSITIVE_BASE + 0x020)
/* SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP : R/W ;bitpos:[3] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP  (BIT(3))
#define SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP_M  (BIT(3))
#define SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP_V  0x1
#define SENSITIVE_INTERNAL_SRAM_ALLOC_MAC_DUMP_S  3
/* SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM : R/W ;bitpos:[2:0] ;default: 3'b0 ; */
/*description: */
#define SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM  0x00000007
#define SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_M  ((SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_V)<<(SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_S))
#define SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_V  0x7
#define SENSITIVE_INTERNAL_SRAM_USAGE_MAC_DUMP_SRAM_S  0

#define SENSITIVE_INTERNAL_SRAM_USAGE_4_REG          (DR_REG_SENSITIVE_BASE + 0x024)
/* SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM  (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM_M  (BIT(0))
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM_V  0x1
#define SENSITIVE_INTERNAL_SRAM_USAGE_LOG_SRAM_S  0

#define SENSITIVE_CACHE_TAG_ACCESS_0_REG          (DR_REG_SENSITIVE_BASE + 0x028)
/* SENSITIVE_CACHE_TAG_ACCESS_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK  (BIT(0))
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_M  (BIT(0))
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_V  0x1
#define SENSITIVE_CACHE_TAG_ACCESS_LOCK_S  0

#define SENSITIVE_CACHE_TAG_ACCESS_1_REG          (DR_REG_SENSITIVE_BASE + 0x02C)
/* SENSITIVE_PRO_D_TAG_WR_ACS : R/W ;bitpos:[3] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_PRO_D_TAG_WR_ACS  (BIT(3))
#define SENSITIVE_PRO_D_TAG_WR_ACS_M  (BIT(3))
#define SENSITIVE_PRO_D_TAG_WR_ACS_V  0x1
#define SENSITIVE_PRO_D_TAG_WR_ACS_S  3
/* SENSITIVE_PRO_D_TAG_RD_ACS : R/W ;bitpos:[2] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_PRO_D_TAG_RD_ACS  (BIT(2))
#define SENSITIVE_PRO_D_TAG_RD_ACS_M  (BIT(2))
#define SENSITIVE_PRO_D_TAG_RD_ACS_V  0x1
#define SENSITIVE_PRO_D_TAG_RD_ACS_S  2
/* SENSITIVE_PRO_I_TAG_WR_ACS : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_PRO_I_TAG_WR_ACS  (BIT(1))
#define SENSITIVE_PRO_I_TAG_WR_ACS_M  (BIT(1))
#define SENSITIVE_PRO_I_TAG_WR_ACS_V  0x1
#define SENSITIVE_PRO_I_TAG_WR_ACS_S  1
/* SENSITIVE_PRO_I_TAG_RD_ACS : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_PRO_I_TAG_RD_ACS  (BIT(0))
#define SENSITIVE_PRO_I_TAG_RD_ACS_M  (BIT(0))
#define SENSITIVE_PRO_I_TAG_RD_ACS_V  0x1
#define SENSITIVE_PRO_I_TAG_RD_ACS_S  0

#define SENSITIVE_CACHE_MMU_ACCESS_0_REG          (DR_REG_SENSITIVE_BASE + 0x030)
/* SENSITIVE_CACHE_MMU_ACCESS_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK  (BIT(0))
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_M  (BIT(0))
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_V  0x1
#define SENSITIVE_CACHE_MMU_ACCESS_LOCK_S  0

#define SENSITIVE_CACHE_MMU_ACCESS_1_REG          (DR_REG_SENSITIVE_BASE + 0x034)
/* SENSITIVE_PRO_MMU_WR_ACS : R/W ;bitpos:[1] ;default: 1'b1 ; */
/*description: */
#define SENSITIVE_PRO_MMU_WR_ACS  (BIT(1))
#define SENSITIVE_PRO_MMU_WR_ACS_M  (BIT(1))
#define SENSITIVE_PRO_MMU_WR_ACS_V  0x1
#define SENSITIVE_PRO_MMU_WR_ACS_S  1
/* SENSITIVE_PRO_MMU_RD_ACS : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: */
#define SENSITIVE_PRO_MMU_RD_ACS  (BIT(0))
#define SENSITIVE_PRO_MMU_RD_ACS_M  (BIT(0))
#define SENSITIVE_PRO_MMU_RD_ACS_V  0x1
#define SENSITIVE_PRO_MMU_RD_ACS_S  0

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x038)
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x03C)
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SPI2_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x040)
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x044)
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_UCHI0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x048)
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x04C)
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_I2S0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x050)
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x054)
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_MAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x058)
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x05C)
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_BACKUP_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x060)
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x064)
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_LC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x068)
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x06C)
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_AES_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x070)
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x074)
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SHA_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x078)
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x07C)
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_ADC_DAC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x080)
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x084)
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_BLE_SEC_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x088)
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x08C)
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_WHITE_LIST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x090)
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x094)
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_DMA_APBPERI_SDIO_HOST_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x098)
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x09C)
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN  (BIT(1))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x0A0)
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO ;bitpos:[26:3] ;default: 24'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR  0x00FFFFFF
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  ((SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_V)<<(SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_S))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0xFFFFFF
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  3
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO ;bitpos:[2:1] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD  0x00000003
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  ((SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_V)<<(SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_S))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x3
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  1
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x0A4)
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO ;bitpos:[4:1] ;default: 4'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN  0x0000000F
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  ((SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V)<<(SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0xF
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1
/* SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_M  (BIT(0))
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x1
#define SENSITIVE_DMA_APBPERI_PMS_MONITOR_VIOLATE_STATUS_WR_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x0A8)
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x0AC)
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR  0x000000FF
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_SPLITADDR_S  14
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0  0x00000003
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_M  ((SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_V)<<(SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_S))
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SRAM_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x0B0)
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR  0x000000FF
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_SPLITADDR_S  14
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_0_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x0B4)
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR  0x000000FF
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_SPLITADDR_S  14
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0  0x00000003
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_M  ((SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_V)<<(SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_S))
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_IRAM0_SRAM_LINE_1_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x0B8)
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR  0x000000FF
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_SPLITADDR_S  14
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_0_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_DRAM0_DMA_SPLIT_LINE_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x0BC)
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR : R/W ;bitpos:[21:14] ;default: 8'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR  0x000000FF
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_V  0xFF
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_SPLITADDR_S  14
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2 : R/W ;bitpos:[5:4] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_2_S  4
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1 : R/W ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_1_S  2
/* SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0 : R/W ;bitpos:[1:0] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0  0x00000003
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_M  ((SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_V)<<(SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_S))
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_DMA_SRAM_LINE_1_CATEGORY_0_S  0

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x0C0)
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x0C4)
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS : R/W ;bitpos:[20:18] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S  18
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[14:12] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_CACHEDATAARRAY_PMS_0_S  12
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  9
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  6
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  3
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  0

#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x0C8)
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS : R/W ;bitpos:[20:18] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S  18
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0 : R/W ;bitpos:[14:12] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_CACHEDATAARRAY_PMS_0_S  12
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  9
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  6
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  3
/* SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000007
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x7
#define SENSITIVE_CORE_X_IRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x0CC)
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x0D0)
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN  (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x0D4)
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO ;bitpos:[28:5] ;default: 24'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR  0x00FFFFFF
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  ((SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V)<<(SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0xFFFFFF
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  5
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO ;bitpos:[4:3] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD  0x00000003
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  ((SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V)<<(SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x3
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  3
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE : RO ;bitpos:[2] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE  (BIT(2))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_M  (BIT(2))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_LOADSTORE_S  2
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR  (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (BIT(1))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  1
/* SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x0D8)
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x0DC)
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_1_PMS_S  26
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_ROM_WORLD_0_PMS_S  24
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_3_S  18
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2 : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_2_S  16
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_1_S  14
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_1_PMS_0_S  12
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_3_S  6
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_2_S  4
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_1_S  2
/* SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0  0x00000003
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_M  ((SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V)<<(SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S))
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_V  0x3
#define SENSITIVE_CORE_X_DRAM0_PMS_CONSTRAIN_SRAM_WORLD_0_PMS_0_S  0

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x0E0)
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x0E4)
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN  (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x0E8)
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR : RO ;bitpos:[27:4] ;default: 24'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR  0x00FFFFFF
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_M  ((SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V)<<(SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_V  0xFFFFFF
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_ADDR_S  4
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD : RO ;bitpos:[3:2] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD  0x00000003
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_M  ((SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V)<<(SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_V  0x3
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WORLD_S  2
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK  (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_M  (BIT(1))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_LOCK_S  1
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x0EC)
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN : RO ;bitpos:[4:1] ;default: 4'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN  0x0000000F
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_M  ((SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V)<<(SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_V  0xF
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_BYTEEN_S  1
/* SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_M  (BIT(0))
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_V  0x1
#define SENSITIVE_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_STATUS_WR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x0F0)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x0F4)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1 : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART1_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_MISC_S  24
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WDG_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IO_MUX_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_FE_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_GPIO_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_0_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_G0SPI_1_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UART_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x0F8)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTIMER_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP1_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_EFUSE_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_LEDC_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RMT_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_UHCI0_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2C_EXT0_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BT_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x0FC)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RWBT_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_I2S1_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TWAI_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_CTRL_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SPI_2_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x100)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CLKRST_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_RTC_BLE_TMR_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_COEX_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_IEEE802154MAC_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_BLE_SEC_S  20
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_TIMERGROUP3_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_ETM_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_USB_DEVICE_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_APB_ADC_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_DMA_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CRYPTO_PERI_S  4

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x104)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_WORLD_CONTROLLER_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DIO_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_AD_S  12
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_CACHE_CONFIG_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_DMA_COPY_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_INTERRUPT_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SENSITIVE_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_SYSTEM_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_0_PVT_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_6_REG          (DR_REG_SENSITIVE_BASE + 0x108)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1 : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART1_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_MISC_S  24
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WDG_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IO_MUX_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_FE_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_GPIO_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_0_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_G0SPI_1_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UART_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_7_REG          (DR_REG_SENSITIVE_BASE + 0x10C)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTIMER_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP1_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_EFUSE_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_LEDC_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RMT_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_UHCI0_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2C_EXT0_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BT_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_8_REG          (DR_REG_SENSITIVE_BASE + 0x110)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RWBT_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_I2S1_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TWAI_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_CTRL_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SPI_2_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_9_REG          (DR_REG_SENSITIVE_BASE + 0x114)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CLKRST_S  30
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_RTC_BLE_TMR_S  28
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_COEX_S  26
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_IEEE802154MAC_S  22
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_BLE_SEC_S  20
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_TIMERGROUP3_S  18
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_ETM_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_USB_DEVICE_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_APB_ADC_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_DMA_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CRYPTO_PERI_S  4

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_10_REG          (DR_REG_SENSITIVE_BASE + 0x118)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_WORLD_CONTROLLER_S  16
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DIO_S  14
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_AD_S  12
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_CACHE_CONFIG_S  10
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_DMA_COPY_S  8
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_INTERRUPT_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SENSITIVE_S  4
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_SYSTEM_S  2
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_WORLD_1_PVT_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_11_REG          (DR_REG_SENSITIVE_BASE + 0x11C)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1 : R/W ;bitpos:[21:11] ;default: ~11'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1  0x000007FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_V  0x7FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_1_S  11
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0 : R/W ;bitpos:[10:0] ;default: ~11'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0  0x000007FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_V  0x7FF
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_SPLTADDR_WORLD_0_S  0

#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_12_REG          (DR_REG_SENSITIVE_BASE + 0x120)
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H : R/W ;bitpos:[11:9] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_H_S  9
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L : R/W ;bitpos:[8:6] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_1_L_S  6
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H : R/W ;bitpos:[5:3] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_H_S  3
/* SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L : R/W ;bitpos:[2:0] ;default: ~3'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_M  ((SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V)<<(SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S))
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_CONSTRAIN_RTCFAST_WORLD_0_L_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x124)
/* SENSITIVE_REGION_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_REGION_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_REGION_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_REGION_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x128)
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_6_S  12
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_5_S  10
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_4_S  8
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_3_S  6
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_2_S  4
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_1_S  2
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_0_AREA_0_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x12C)
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6 : R/W ;bitpos:[13:12] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_6_S  12
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5 : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_5_S  10
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4 : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_4_S  8
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_3_S  6
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_2_S  4
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_1_S  2
/* SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0  0x00000003
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_V  0x3
#define SENSITIVE_REGION_PMS_CONSTRAIN_WORLD_1_AREA_0_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x130)
/* SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_V  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_0_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x134)
/* SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_V  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_1_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x138)
/* SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_V  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_2_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_6_REG          (DR_REG_SENSITIVE_BASE + 0x13C)
/* SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_V  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_3_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_7_REG          (DR_REG_SENSITIVE_BASE + 0x140)
/* SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_V  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_4_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_8_REG          (DR_REG_SENSITIVE_BASE + 0x144)
/* SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_V  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_5_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_9_REG          (DR_REG_SENSITIVE_BASE + 0x148)
/* SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_V  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_6_S  0

#define SENSITIVE_REGION_PMS_CONSTRAIN_10_REG          (DR_REG_SENSITIVE_BASE + 0x14C)
/* SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7 : R/W ;bitpos:[29:0] ;default: 30'b0 ; */
/*description: */
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_M  ((SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_V)<<(SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_S))
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_V  0x3FFFFFFF
#define SENSITIVE_REGION_PMS_CONSTRAIN_ADDR_7_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x150)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x154)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x158)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD : RO ;bitpos:[7:6] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWORLD_S  6
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO ;bitpos:[5] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE  (BIT(5))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (BIT(5))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  5
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO ;bitpos:[4:2] ;default: 3'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE  0x00000007
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x7
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  2
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0 : RO ;bitpos:[1] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_M  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HPORT_0_S  1
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x15C)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR : RO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR  0xFFFFFFFF
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_V  0xFFFFFFFF
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_VIOLATE_STATUS_HADDR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_4_REG          (DR_REG_SENSITIVE_BASE + 0x160)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_EN_S  1
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_CLR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_5_REG          (DR_REG_SENSITIVE_BASE + 0x164)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD : RO ;bitpos:[4:3] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HWORLD_S  3
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE : RO ;bitpos:[2:1] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE  0x00000003
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_V  0x3
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HSIZE_S  1
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_V  0x1
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_INTR_S  0

#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_6_REG          (DR_REG_SENSITIVE_BASE + 0x168)
/* SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR : RO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: */
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR  0xFFFFFFFF
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_M  ((SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V)<<(SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S))
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_V  0xFFFFFFFF
#define SENSITIVE_CORE_0_PIF_PMS_MONITOR_NONWORD_VIOLATE_STATUS_HADDR_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_0_REG          (DR_REG_SENSITIVE_BASE + 0x16C)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_M  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LOCK_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_1_REG          (DR_REG_SENSITIVE_BASE + 0x170)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1 : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART1_S  30
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_S  26
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC : R/W ;bitpos:[25:24] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_MISC_S  24
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_WDG_S  18
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IO_MUX_S  16
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_S  14
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_FE_S  10
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_GPIO_S  6
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_0_S  4
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1 : R/W ;bitpos:[3:2] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_G0SPI_1_S  2
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UART_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_2_REG          (DR_REG_SENSITIVE_BASE + 0x174)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SYSTIMER_S  30
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1 : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP1_S  28
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP_S  26
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_EFUSE_S  18
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_LEDC_S  16
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RMT_S  10
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0 : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_UHCI0_S  6
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0 : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2C_EXT0_S  4
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BT_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_3_REG          (DR_REG_SENSITIVE_BASE + 0x178)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RWBT_S  22
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1 : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_I2S1_S  14
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI : R/W ;bitpos:[11:10] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TWAI_S  10
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_CTRL_S  4
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2 : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_SPI_2_S  0

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_4_REG          (DR_REG_SENSITIVE_BASE + 0x17C)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST : R/W ;bitpos:[31:30] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CLKRST_S  30
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR : R/W ;bitpos:[29:28] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_RTC_BLE_TMR_S  28
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX : R/W ;bitpos:[27:26] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_COEX_S  26
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC : R/W ;bitpos:[23:22] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_IEEE802154MAC_S  22
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC : R/W ;bitpos:[21:20] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_BLE_SEC_S  20
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3 : R/W ;bitpos:[19:18] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_TIMERGROUP3_S  18
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM : R/W ;bitpos:[17:16] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_ETM_S  16
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE : R/W ;bitpos:[15:14] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_USB_DEVICE_S  14
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC : R/W ;bitpos:[9:8] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_APB_ADC_S  8
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA : R/W ;bitpos:[7:6] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_DMA_S  6
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI : R/W ;bitpos:[5:4] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_CRYPTO_PERI_S  4

#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_5_REG          (DR_REG_SENSITIVE_BASE + 0x180)
/* SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT : R/W ;bitpos:[1:0] ;default: ~2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_M  ((SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_V)<<(SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_S))
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_CONSTRAIN_PVT_S  0

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_0_REG          (DR_REG_SENSITIVE_BASE + 0x184)
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_M  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_LOCK_S  0

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_1_REG          (DR_REG_SENSITIVE_BASE + 0x188)
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN : R/W ;bitpos:[1] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN  (BIT(1))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_M  (BIT(1))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_EN_S  1
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR : R/W ;bitpos:[0] ;default: ~1'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_M  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_CLR_S  0

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_2_REG          (DR_REG_SENSITIVE_BASE + 0x18C)
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE : RO ;bitpos:[6] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE  (BIT(6))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_M  (BIT(6))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HWRITE_S  6
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE : RO ;bitpos:[5:3] ;default: 3'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE  0x00000007
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_M  ((SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V)<<(SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_V  0x7
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HSIZE_S  3
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS : RO ;bitpos:[2:1] ;default: 2'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS  0x00000003
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_M  ((SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_V)<<(SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_S))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_V  0x3
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_STATUS_HTRANS_S  1
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_M  (BIT(0))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_V  0x1
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_INTR_S  0

#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_3_REG          (DR_REG_SENSITIVE_BASE + 0x190)
/* SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR : RO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: */
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR  0xFFFFFFFF
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_M  ((SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_V)<<(SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_S))
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_V  0xFFFFFFFF
#define SENSITIVE_BACKUP_BUS_PMS_MONITOR_VIOLATE_HADDR_S  0

#define SENSITIVE_CLOCK_GATE_REG          (DR_REG_SENSITIVE_BASE + 0x194)
/* SENSITIVE_CLK_EN : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: */
#define SENSITIVE_CLK_EN  (BIT(0))
#define SENSITIVE_CLK_EN_M  (BIT(0))
#define SENSITIVE_CLK_EN_V  0x1
#define SENSITIVE_CLK_EN_S  0

#define SENSITIVE_DATE_REG          (DR_REG_SENSITIVE_BASE + 0xFFC)
/* SENSITIVE_DATE : R/W ;bitpos:[27:0] ;default: 28'h2101190 ; */
/*description: */
#define SENSITIVE_DATE  0x0FFFFFFF
#define SENSITIVE_DATE_M  ((SENSITIVE_DATE_V)<<(SENSITIVE_DATE_S))
#define SENSITIVE_DATE_V  0xFFFFFFF
#define SENSITIVE_DATE_S  0

#ifdef __cplusplus
}
#endif



#endif /*_SOC_SENSITIVE_REG_H_ */
