| Supported Targets | ESP32 |
| ----------------- | ----- |

# Wave generator Example

(See the README.md file in the upper level 'examples' directory for more information about examples.)

This example demonstrates how to implement a software controlled signal generator by utilizing the DAC and Timer Group drivers. All waveforms demonstrated in this example are generated by software.

Users can connect DAC output channel to their devices and use it as an simple analog signal output source.

## How to use this example

### Hardware Required

* A development board with ESP32 SoC (e.g., ESP32-DevKitC, ESP-WROVER-KIT, etc.)
* A USB cable for power supply and programming
* A bunch of cables
* Target device

Make sure DAC output pin which is GPIO25 if channel 1 set, GPIO26 if channel 2 set, be connected to target device correctly.

### Configure the project
Under example folder, right click and select 'open terminal here'

Execute following statements in terminal:

```
idf.py menuconfig
```

In `Example  Configuration`, set the following options:

#### DAC channel Num

ESP32 DAC contains two channels:
 * **DAC_CHANNEL_1 (GPIO25), selected by default.**
 * DAC_CHANNEL_2 (GPIO26)

#### Wave form

This example demonstrates one of the following waveforms:
* **Sine, selected by default.**
* Triangle
* Sawtooth
* Square

#### Wave frequency

About this option:

This signal generator has a range of frequency is 1kHz to 17kHz. **3kHz selected by default.**

Modify the frequency will change the number of DAC output points. That will affect the smoothness of curve as well. Those output points are used to calculate the raw value(0~255) of each output point. All of these raw value are stored in an array.

Based on the given frequency, the number of DAC output points for each cycle can be caluculated by following formula:
```num_of_output_points = 1000000(us)/(7 us * frequency)```

For example, with high frequency, 20kHz will results in generating only 10 output points, the curve will be sharp and zigzag.

On the contrary, 500 Hz, low frequency relatively, will results in many DAC output points and the array cannot stores so many values that it will causes array overboundary.

In short, there will be less output points per cycle in higher frequency, and more points in lower frequency.

After got the raw value, the real output voltage can be calculated through following formula (VDD is 3.3V):

```points_voltage = (VDD * DAC_OUTPUT / 255)```

The voltage is in range of 0~3300mV.

#### Enable output voltage log

**Disabled selected by default.**

If enabled, expected voltage of each points will be shown in terminal. It's intuitive for debugging and testing. If output example is needed, read **Example Output** chapter below.

### Build and Flash
After configure step is done, build project and flash it to the board:

```
$ idf.py -p PORT flash monitor
```

(To exit the serial monitor, type ``Ctrl-]``.)

See the `Getting Started Guide` for full steps to configure and use ESP-IDF to build projects.

## Example Output
If oscilloscope is available, the target wave will show on oscilloscope after running this example.

Additionally, if more specific output voltage information is needed, run menuconfig and set "Enable print output voltage" to "Enabled". Then, more information will show as log in terminal.

For example, set wave frequency, waveform to 3kHz and sine respectively, and also enable print output voltage option. The output information will show in log in terminal as following:

```
I (318) Wave generator: DAC output channel: 1
I (318) Wave generator: GPIO:25
I (328) Wave generator: Waveform: Sine
I (328) Wave generator: Frequency(Hz): 3000
I (338) Wave generator: Output points num: 47

I (438) Wave generator: Output voltage(mV): 1656
I (538) Wave generator: Output voltage(mV): 1863
I (638) Wave generator: Output voltage(mV): 2083
I (738) Wave generator: Output voltage(mV): 2290
I (838) Wave generator: Output voltage(mV): 2484
I (938) Wave generator: Output voltage(mV): 2678
I (1038) Wave generator: Output voltage(mV): 2834
I (1138) Wave generator: Output voltage(mV): 2976
I (1238) Wave generator: Output voltage(mV): 3092
I (1338) Wave generator: Output voltage(mV): 3183
....

```
`Output voltage` in log means real voltage, in mV, which is output through GPIO by device.