// Copyright 2017-2018 Espressif Systems (Shanghai) PTE LTD
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
#ifndef _SOC_INTERRUPT_REG_H_
#define _SOC_INTERRUPT_REG_H_


#ifdef __cplusplus
extern "C" {
#endif
#include "soc.h"
#define DPORT_PRO_MAC_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x000)
/* DPORT_PRO_MAC_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_MAC_INTR_MAP  0x0000001F
#define DPORT_PRO_MAC_INTR_MAP_M  ((DPORT_PRO_MAC_INTR_MAP_V)<<(DPORT_PRO_MAC_INTR_MAP_S))
#define DPORT_PRO_MAC_INTR_MAP_V  0x1F
#define DPORT_PRO_MAC_INTR_MAP_S  0

#define DPORT_PRO_MAC_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x004)
/* DPORT_PRO_MAC_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_MAC_NMI_MAP  0x0000001F
#define DPORT_PRO_MAC_NMI_MAP_M  ((DPORT_PRO_MAC_NMI_MAP_V)<<(DPORT_PRO_MAC_NMI_MAP_S))
#define DPORT_PRO_MAC_NMI_MAP_V  0x1F
#define DPORT_PRO_MAC_NMI_MAP_S  0

#define DPORT_PRO_PWR_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x008)
/* DPORT_PRO_PWR_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PWR_INTR_MAP  0x0000001F
#define DPORT_PRO_PWR_INTR_MAP_M  ((DPORT_PRO_PWR_INTR_MAP_V)<<(DPORT_PRO_PWR_INTR_MAP_S))
#define DPORT_PRO_PWR_INTR_MAP_V  0x1F
#define DPORT_PRO_PWR_INTR_MAP_S  0

#define DPORT_PRO_BB_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x00C)
/* DPORT_PRO_BB_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_BB_INT_MAP  0x0000001F
#define DPORT_PRO_BB_INT_MAP_M  ((DPORT_PRO_BB_INT_MAP_V)<<(DPORT_PRO_BB_INT_MAP_S))
#define DPORT_PRO_BB_INT_MAP_V  0x1F
#define DPORT_PRO_BB_INT_MAP_S  0

#define DPORT_PRO_BT_MAC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x010)
/* DPORT_PRO_BT_MAC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_BT_MAC_INT_MAP  0x0000001F
#define DPORT_PRO_BT_MAC_INT_MAP_M  ((DPORT_PRO_BT_MAC_INT_MAP_V)<<(DPORT_PRO_BT_MAC_INT_MAP_S))
#define DPORT_PRO_BT_MAC_INT_MAP_V  0x1F
#define DPORT_PRO_BT_MAC_INT_MAP_S  0

#define DPORT_PRO_BT_BB_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x014)
/* DPORT_PRO_BT_BB_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_BT_BB_INT_MAP  0x0000001F
#define DPORT_PRO_BT_BB_INT_MAP_M  ((DPORT_PRO_BT_BB_INT_MAP_V)<<(DPORT_PRO_BT_BB_INT_MAP_S))
#define DPORT_PRO_BT_BB_INT_MAP_V  0x1F
#define DPORT_PRO_BT_BB_INT_MAP_S  0

#define DPORT_PRO_BT_BB_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x018)
/* DPORT_PRO_BT_BB_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_BT_BB_NMI_MAP  0x0000001F
#define DPORT_PRO_BT_BB_NMI_MAP_M  ((DPORT_PRO_BT_BB_NMI_MAP_V)<<(DPORT_PRO_BT_BB_NMI_MAP_S))
#define DPORT_PRO_BT_BB_NMI_MAP_V  0x1F
#define DPORT_PRO_BT_BB_NMI_MAP_S  0

#define DPORT_PRO_RWBT_IRQ_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x01C)
/* DPORT_PRO_RWBT_IRQ_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_RWBT_IRQ_MAP  0x0000001F
#define DPORT_PRO_RWBT_IRQ_MAP_M  ((DPORT_PRO_RWBT_IRQ_MAP_V)<<(DPORT_PRO_RWBT_IRQ_MAP_S))
#define DPORT_PRO_RWBT_IRQ_MAP_V  0x1F
#define DPORT_PRO_RWBT_IRQ_MAP_S  0

#define DPORT_PRO_RWBLE_IRQ_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x020)
/* DPORT_PRO_RWBLE_IRQ_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_RWBLE_IRQ_MAP  0x0000001F
#define DPORT_PRO_RWBLE_IRQ_MAP_M  ((DPORT_PRO_RWBLE_IRQ_MAP_V)<<(DPORT_PRO_RWBLE_IRQ_MAP_S))
#define DPORT_PRO_RWBLE_IRQ_MAP_V  0x1F
#define DPORT_PRO_RWBLE_IRQ_MAP_S  0

#define DPORT_PRO_RWBT_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x024)
/* DPORT_PRO_RWBT_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_RWBT_NMI_MAP  0x0000001F
#define DPORT_PRO_RWBT_NMI_MAP_M  ((DPORT_PRO_RWBT_NMI_MAP_V)<<(DPORT_PRO_RWBT_NMI_MAP_S))
#define DPORT_PRO_RWBT_NMI_MAP_V  0x1F
#define DPORT_PRO_RWBT_NMI_MAP_S  0

#define DPORT_PRO_RWBLE_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x028)
/* DPORT_PRO_RWBLE_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_RWBLE_NMI_MAP  0x0000001F
#define DPORT_PRO_RWBLE_NMI_MAP_M  ((DPORT_PRO_RWBLE_NMI_MAP_V)<<(DPORT_PRO_RWBLE_NMI_MAP_S))
#define DPORT_PRO_RWBLE_NMI_MAP_V  0x1F
#define DPORT_PRO_RWBLE_NMI_MAP_S  0

#define DPORT_PRO_SLC0_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x02C)
/* DPORT_PRO_SLC0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SLC0_INTR_MAP  0x0000001F
#define DPORT_PRO_SLC0_INTR_MAP_M  ((DPORT_PRO_SLC0_INTR_MAP_V)<<(DPORT_PRO_SLC0_INTR_MAP_S))
#define DPORT_PRO_SLC0_INTR_MAP_V  0x1F
#define DPORT_PRO_SLC0_INTR_MAP_S  0

#define DPORT_PRO_SLC1_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x030)
/* DPORT_PRO_SLC1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SLC1_INTR_MAP  0x0000001F
#define DPORT_PRO_SLC1_INTR_MAP_M  ((DPORT_PRO_SLC1_INTR_MAP_V)<<(DPORT_PRO_SLC1_INTR_MAP_S))
#define DPORT_PRO_SLC1_INTR_MAP_V  0x1F
#define DPORT_PRO_SLC1_INTR_MAP_S  0

#define DPORT_PRO_UHCI0_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x034)
/* DPORT_PRO_UHCI0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_UHCI0_INTR_MAP  0x0000001F
#define DPORT_PRO_UHCI0_INTR_MAP_M  ((DPORT_PRO_UHCI0_INTR_MAP_V)<<(DPORT_PRO_UHCI0_INTR_MAP_S))
#define DPORT_PRO_UHCI0_INTR_MAP_V  0x1F
#define DPORT_PRO_UHCI0_INTR_MAP_S  0

#define DPORT_PRO_UHCI1_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x038)
/* DPORT_PRO_UHCI1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_UHCI1_INTR_MAP  0x0000001F
#define DPORT_PRO_UHCI1_INTR_MAP_M  ((DPORT_PRO_UHCI1_INTR_MAP_V)<<(DPORT_PRO_UHCI1_INTR_MAP_S))
#define DPORT_PRO_UHCI1_INTR_MAP_V  0x1F
#define DPORT_PRO_UHCI1_INTR_MAP_S  0

#define DPORT_PRO_TG_T0_LEVEL_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x03C)
/* DPORT_PRO_TG_T0_LEVEL_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG_T0_LEVEL_INT_MAP  0x0000001F
#define DPORT_PRO_TG_T0_LEVEL_INT_MAP_M  ((DPORT_PRO_TG_T0_LEVEL_INT_MAP_V)<<(DPORT_PRO_TG_T0_LEVEL_INT_MAP_S))
#define DPORT_PRO_TG_T0_LEVEL_INT_MAP_V  0x1F
#define DPORT_PRO_TG_T0_LEVEL_INT_MAP_S  0

#define DPORT_PRO_TG_T1_LEVEL_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x040)
/* DPORT_PRO_TG_T1_LEVEL_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG_T1_LEVEL_INT_MAP  0x0000001F
#define DPORT_PRO_TG_T1_LEVEL_INT_MAP_M  ((DPORT_PRO_TG_T1_LEVEL_INT_MAP_V)<<(DPORT_PRO_TG_T1_LEVEL_INT_MAP_S))
#define DPORT_PRO_TG_T1_LEVEL_INT_MAP_V  0x1F
#define DPORT_PRO_TG_T1_LEVEL_INT_MAP_S  0

#define DPORT_PRO_TG_WDT_LEVEL_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x044)
/* DPORT_PRO_TG_WDT_LEVEL_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG_WDT_LEVEL_INT_MAP  0x0000001F
#define DPORT_PRO_TG_WDT_LEVEL_INT_MAP_M  ((DPORT_PRO_TG_WDT_LEVEL_INT_MAP_V)<<(DPORT_PRO_TG_WDT_LEVEL_INT_MAP_S))
#define DPORT_PRO_TG_WDT_LEVEL_INT_MAP_V  0x1F
#define DPORT_PRO_TG_WDT_LEVEL_INT_MAP_S  0

#define DPORT_PRO_TG_LACT_LEVEL_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x048)
/* DPORT_PRO_TG_LACT_LEVEL_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG_LACT_LEVEL_INT_MAP  0x0000001F
#define DPORT_PRO_TG_LACT_LEVEL_INT_MAP_M  ((DPORT_PRO_TG_LACT_LEVEL_INT_MAP_V)<<(DPORT_PRO_TG_LACT_LEVEL_INT_MAP_S))
#define DPORT_PRO_TG_LACT_LEVEL_INT_MAP_V  0x1F
#define DPORT_PRO_TG_LACT_LEVEL_INT_MAP_S  0

#define DPORT_PRO_TG1_T0_LEVEL_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x04C)
/* DPORT_PRO_TG1_T0_LEVEL_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG1_T0_LEVEL_INT_MAP  0x0000001F
#define DPORT_PRO_TG1_T0_LEVEL_INT_MAP_M  ((DPORT_PRO_TG1_T0_LEVEL_INT_MAP_V)<<(DPORT_PRO_TG1_T0_LEVEL_INT_MAP_S))
#define DPORT_PRO_TG1_T0_LEVEL_INT_MAP_V  0x1F
#define DPORT_PRO_TG1_T0_LEVEL_INT_MAP_S  0

#define DPORT_PRO_TG1_T1_LEVEL_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x050)
/* DPORT_PRO_TG1_T1_LEVEL_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG1_T1_LEVEL_INT_MAP  0x0000001F
#define DPORT_PRO_TG1_T1_LEVEL_INT_MAP_M  ((DPORT_PRO_TG1_T1_LEVEL_INT_MAP_V)<<(DPORT_PRO_TG1_T1_LEVEL_INT_MAP_S))
#define DPORT_PRO_TG1_T1_LEVEL_INT_MAP_V  0x1F
#define DPORT_PRO_TG1_T1_LEVEL_INT_MAP_S  0

#define DPORT_PRO_TG1_WDT_LEVEL_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x054)
/* DPORT_PRO_TG1_WDT_LEVEL_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG1_WDT_LEVEL_INT_MAP  0x0000001F
#define DPORT_PRO_TG1_WDT_LEVEL_INT_MAP_M  ((DPORT_PRO_TG1_WDT_LEVEL_INT_MAP_V)<<(DPORT_PRO_TG1_WDT_LEVEL_INT_MAP_S))
#define DPORT_PRO_TG1_WDT_LEVEL_INT_MAP_V  0x1F
#define DPORT_PRO_TG1_WDT_LEVEL_INT_MAP_S  0

#define DPORT_PRO_TG1_LACT_LEVEL_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x058)
/* DPORT_PRO_TG1_LACT_LEVEL_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG1_LACT_LEVEL_INT_MAP  0x0000001F
#define DPORT_PRO_TG1_LACT_LEVEL_INT_MAP_M  ((DPORT_PRO_TG1_LACT_LEVEL_INT_MAP_V)<<(DPORT_PRO_TG1_LACT_LEVEL_INT_MAP_S))
#define DPORT_PRO_TG1_LACT_LEVEL_INT_MAP_V  0x1F
#define DPORT_PRO_TG1_LACT_LEVEL_INT_MAP_S  0

#define DPORT_PRO_GPIO_DPORT_PRO_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x05C)
/* DPORT_PRO_GPIO_DPORT_PRO_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_GPIO_DPORT_PRO_MAP  0x0000001F
#define DPORT_PRO_GPIO_DPORT_PRO_MAP_M  ((DPORT_PRO_GPIO_DPORT_PRO_MAP_V)<<(DPORT_PRO_GPIO_DPORT_PRO_MAP_S))
#define DPORT_PRO_GPIO_DPORT_PRO_MAP_V  0x1F
#define DPORT_PRO_GPIO_DPORT_PRO_MAP_S  0

#define DPORT_PRO_GPIO_DPORT_PRO_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x060)
/* DPORT_PRO_GPIO_DPORT_PRO_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_GPIO_DPORT_PRO_NMI_MAP  0x0000001F
#define DPORT_PRO_GPIO_DPORT_PRO_NMI_MAP_M  ((DPORT_PRO_GPIO_DPORT_PRO_NMI_MAP_V)<<(DPORT_PRO_GPIO_DPORT_PRO_NMI_MAP_S))
#define DPORT_PRO_GPIO_DPORT_PRO_NMI_MAP_V  0x1F
#define DPORT_PRO_GPIO_DPORT_PRO_NMI_MAP_S  0

#define DPORT_PRO_GPIO_DPORT_APP_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x064)
/* DPORT_PRO_GPIO_DPORT_APP_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_GPIO_DPORT_APP_MAP  0x0000001F
#define DPORT_PRO_GPIO_DPORT_APP_MAP_M  ((DPORT_PRO_GPIO_DPORT_APP_MAP_V)<<(DPORT_PRO_GPIO_DPORT_APP_MAP_S))
#define DPORT_PRO_GPIO_DPORT_APP_MAP_V  0x1F
#define DPORT_PRO_GPIO_DPORT_APP_MAP_S  0

#define DPORT_PRO_GPIO_DPORT_APP_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x068)
/* DPORT_PRO_GPIO_DPORT_APP_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_GPIO_DPORT_APP_NMI_MAP  0x0000001F
#define DPORT_PRO_GPIO_DPORT_APP_NMI_MAP_M  ((DPORT_PRO_GPIO_DPORT_APP_NMI_MAP_V)<<(DPORT_PRO_GPIO_DPORT_APP_NMI_MAP_S))
#define DPORT_PRO_GPIO_DPORT_APP_NMI_MAP_V  0x1F
#define DPORT_PRO_GPIO_DPORT_APP_NMI_MAP_S  0

#define DPORT_PRO_DEDICATED_GPIO_IN_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x06C)
/* DPORT_PRO_DEDICATED_GPIO_IN_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_DEDICATED_GPIO_IN_INTR_MAP  0x0000001F
#define DPORT_PRO_DEDICATED_GPIO_IN_INTR_MAP_M  ((DPORT_PRO_DEDICATED_GPIO_IN_INTR_MAP_V)<<(DPORT_PRO_DEDICATED_GPIO_IN_INTR_MAP_S))
#define DPORT_PRO_DEDICATED_GPIO_IN_INTR_MAP_V  0x1F
#define DPORT_PRO_DEDICATED_GPIO_IN_INTR_MAP_S  0

#define DPORT_PRO_CPU_INTR_FROM_CPU_0_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x070)
/* DPORT_PRO_CPU_INTR_FROM_CPU_0_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_CPU_INTR_FROM_CPU_0_MAP  0x0000001F
#define DPORT_PRO_CPU_INTR_FROM_CPU_0_MAP_M  ((DPORT_PRO_CPU_INTR_FROM_CPU_0_MAP_V)<<(DPORT_PRO_CPU_INTR_FROM_CPU_0_MAP_S))
#define DPORT_PRO_CPU_INTR_FROM_CPU_0_MAP_V  0x1F
#define DPORT_PRO_CPU_INTR_FROM_CPU_0_MAP_S  0

#define DPORT_PRO_CPU_INTR_FROM_CPU_1_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x074)
/* DPORT_PRO_CPU_INTR_FROM_CPU_1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_CPU_INTR_FROM_CPU_1_MAP  0x0000001F
#define DPORT_PRO_CPU_INTR_FROM_CPU_1_MAP_M  ((DPORT_PRO_CPU_INTR_FROM_CPU_1_MAP_V)<<(DPORT_PRO_CPU_INTR_FROM_CPU_1_MAP_S))
#define DPORT_PRO_CPU_INTR_FROM_CPU_1_MAP_V  0x1F
#define DPORT_PRO_CPU_INTR_FROM_CPU_1_MAP_S  0

#define DPORT_PRO_CPU_INTR_FROM_CPU_2_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x078)
/* DPORT_PRO_CPU_INTR_FROM_CPU_2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_CPU_INTR_FROM_CPU_2_MAP  0x0000001F
#define DPORT_PRO_CPU_INTR_FROM_CPU_2_MAP_M  ((DPORT_PRO_CPU_INTR_FROM_CPU_2_MAP_V)<<(DPORT_PRO_CPU_INTR_FROM_CPU_2_MAP_S))
#define DPORT_PRO_CPU_INTR_FROM_CPU_2_MAP_V  0x1F
#define DPORT_PRO_CPU_INTR_FROM_CPU_2_MAP_S  0

#define DPORT_PRO_CPU_INTR_FROM_CPU_3_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x07C)
/* DPORT_PRO_CPU_INTR_FROM_CPU_3_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_CPU_INTR_FROM_CPU_3_MAP  0x0000001F
#define DPORT_PRO_CPU_INTR_FROM_CPU_3_MAP_M  ((DPORT_PRO_CPU_INTR_FROM_CPU_3_MAP_V)<<(DPORT_PRO_CPU_INTR_FROM_CPU_3_MAP_S))
#define DPORT_PRO_CPU_INTR_FROM_CPU_3_MAP_V  0x1F
#define DPORT_PRO_CPU_INTR_FROM_CPU_3_MAP_S  0

#define DPORT_PRO_SPI_INTR_1_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x080)
/* DPORT_PRO_SPI_INTR_1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SPI_INTR_1_MAP  0x0000001F
#define DPORT_PRO_SPI_INTR_1_MAP_M  ((DPORT_PRO_SPI_INTR_1_MAP_V)<<(DPORT_PRO_SPI_INTR_1_MAP_S))
#define DPORT_PRO_SPI_INTR_1_MAP_V  0x1F
#define DPORT_PRO_SPI_INTR_1_MAP_S  0

#define DPORT_PRO_SPI_INTR_2_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x084)
/* DPORT_PRO_SPI_INTR_2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SPI_INTR_2_MAP  0x0000001F
#define DPORT_PRO_SPI_INTR_2_MAP_M  ((DPORT_PRO_SPI_INTR_2_MAP_V)<<(DPORT_PRO_SPI_INTR_2_MAP_S))
#define DPORT_PRO_SPI_INTR_2_MAP_V  0x1F
#define DPORT_PRO_SPI_INTR_2_MAP_S  0

#define DPORT_PRO_SPI_INTR_3_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x088)
/* DPORT_PRO_SPI_INTR_3_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SPI_INTR_3_MAP  0x0000001F
#define DPORT_PRO_SPI_INTR_3_MAP_M  ((DPORT_PRO_SPI_INTR_3_MAP_V)<<(DPORT_PRO_SPI_INTR_3_MAP_S))
#define DPORT_PRO_SPI_INTR_3_MAP_V  0x1F
#define DPORT_PRO_SPI_INTR_3_MAP_S  0

#define DPORT_PRO_I2S0_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x08C)
/* DPORT_PRO_I2S0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_I2S0_INT_MAP  0x0000001F
#define DPORT_PRO_I2S0_INT_MAP_M  ((DPORT_PRO_I2S0_INT_MAP_V)<<(DPORT_PRO_I2S0_INT_MAP_S))
#define DPORT_PRO_I2S0_INT_MAP_V  0x1F
#define DPORT_PRO_I2S0_INT_MAP_S  0

#define DPORT_PRO_I2S1_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x090)
/* DPORT_PRO_I2S1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_I2S1_INT_MAP  0x0000001F
#define DPORT_PRO_I2S1_INT_MAP_M  ((DPORT_PRO_I2S1_INT_MAP_V)<<(DPORT_PRO_I2S1_INT_MAP_S))
#define DPORT_PRO_I2S1_INT_MAP_V  0x1F
#define DPORT_PRO_I2S1_INT_MAP_S  0

#define DPORT_PRO_UART_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x094)
/* DPORT_PRO_UART_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_UART_INTR_MAP  0x0000001F
#define DPORT_PRO_UART_INTR_MAP_M  ((DPORT_PRO_UART_INTR_MAP_V)<<(DPORT_PRO_UART_INTR_MAP_S))
#define DPORT_PRO_UART_INTR_MAP_V  0x1F
#define DPORT_PRO_UART_INTR_MAP_S  0

#define DPORT_PRO_UART1_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x098)
/* DPORT_PRO_UART1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_UART1_INTR_MAP  0x0000001F
#define DPORT_PRO_UART1_INTR_MAP_M  ((DPORT_PRO_UART1_INTR_MAP_V)<<(DPORT_PRO_UART1_INTR_MAP_S))
#define DPORT_PRO_UART1_INTR_MAP_V  0x1F
#define DPORT_PRO_UART1_INTR_MAP_S  0

#define DPORT_PRO_UART2_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x09C)
/* DPORT_PRO_UART2_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_UART2_INTR_MAP  0x0000001F
#define DPORT_PRO_UART2_INTR_MAP_M  ((DPORT_PRO_UART2_INTR_MAP_V)<<(DPORT_PRO_UART2_INTR_MAP_S))
#define DPORT_PRO_UART2_INTR_MAP_V  0x1F
#define DPORT_PRO_UART2_INTR_MAP_S  0

#define DPORT_PRO_SDIO_HOST_DPORT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0A0)
/* DPORT_PRO_SDIO_HOST_DPORT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SDIO_HOST_DPORT_MAP  0x0000001F
#define DPORT_PRO_SDIO_HOST_DPORT_MAP_M  ((DPORT_PRO_SDIO_HOST_DPORT_MAP_V)<<(DPORT_PRO_SDIO_HOST_DPORT_MAP_S))
#define DPORT_PRO_SDIO_HOST_DPORT_MAP_V  0x1F
#define DPORT_PRO_SDIO_HOST_DPORT_MAP_S  0

#define DPORT_PRO_PWM0_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0A4)
/* DPORT_PRO_PWM0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PWM0_INTR_MAP  0x0000001F
#define DPORT_PRO_PWM0_INTR_MAP_M  ((DPORT_PRO_PWM0_INTR_MAP_V)<<(DPORT_PRO_PWM0_INTR_MAP_S))
#define DPORT_PRO_PWM0_INTR_MAP_V  0x1F
#define DPORT_PRO_PWM0_INTR_MAP_S  0

#define DPORT_PRO_PWM1_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0A8)
/* DPORT_PRO_PWM1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PWM1_INTR_MAP  0x0000001F
#define DPORT_PRO_PWM1_INTR_MAP_M  ((DPORT_PRO_PWM1_INTR_MAP_V)<<(DPORT_PRO_PWM1_INTR_MAP_S))
#define DPORT_PRO_PWM1_INTR_MAP_V  0x1F
#define DPORT_PRO_PWM1_INTR_MAP_S  0

#define DPORT_PRO_PWM2_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0AC)
/* DPORT_PRO_PWM2_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PWM2_INTR_MAP  0x0000001F
#define DPORT_PRO_PWM2_INTR_MAP_M  ((DPORT_PRO_PWM2_INTR_MAP_V)<<(DPORT_PRO_PWM2_INTR_MAP_S))
#define DPORT_PRO_PWM2_INTR_MAP_V  0x1F
#define DPORT_PRO_PWM2_INTR_MAP_S  0

#define DPORT_PRO_PWM3_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0B0)
/* DPORT_PRO_PWM3_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PWM3_INTR_MAP  0x0000001F
#define DPORT_PRO_PWM3_INTR_MAP_M  ((DPORT_PRO_PWM3_INTR_MAP_V)<<(DPORT_PRO_PWM3_INTR_MAP_S))
#define DPORT_PRO_PWM3_INTR_MAP_V  0x1F
#define DPORT_PRO_PWM3_INTR_MAP_S  0

#define DPORT_PRO_LEDC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0B4)
/* DPORT_PRO_LEDC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_LEDC_INT_MAP  0x0000001F
#define DPORT_PRO_LEDC_INT_MAP_M  ((DPORT_PRO_LEDC_INT_MAP_V)<<(DPORT_PRO_LEDC_INT_MAP_S))
#define DPORT_PRO_LEDC_INT_MAP_V  0x1F
#define DPORT_PRO_LEDC_INT_MAP_S  0

#define DPORT_PRO_EFUSE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0B8)
/* DPORT_PRO_EFUSE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_EFUSE_INT_MAP  0x0000001F
#define DPORT_PRO_EFUSE_INT_MAP_M  ((DPORT_PRO_EFUSE_INT_MAP_V)<<(DPORT_PRO_EFUSE_INT_MAP_S))
#define DPORT_PRO_EFUSE_INT_MAP_V  0x1F
#define DPORT_PRO_EFUSE_INT_MAP_S  0

#define DPORT_PRO_CAN_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0BC)
/* DPORT_PRO_CAN_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_CAN_INT_MAP  0x0000001F
#define DPORT_PRO_CAN_INT_MAP_M  ((DPORT_PRO_CAN_INT_MAP_V)<<(DPORT_PRO_CAN_INT_MAP_S))
#define DPORT_PRO_CAN_INT_MAP_V  0x1F
#define DPORT_PRO_CAN_INT_MAP_S  0

#define DPORT_PRO_USB_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0C0)
/* DPORT_PRO_USB_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_USB_INTR_MAP  0x0000001F
#define DPORT_PRO_USB_INTR_MAP_M  ((DPORT_PRO_USB_INTR_MAP_V)<<(DPORT_PRO_USB_INTR_MAP_S))
#define DPORT_PRO_USB_INTR_MAP_V  0x1F
#define DPORT_PRO_USB_INTR_MAP_S  0

#define DPORT_PRO_RTC_CORE_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0C4)
/* DPORT_PRO_RTC_CORE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_RTC_CORE_INTR_MAP  0x0000001F
#define DPORT_PRO_RTC_CORE_INTR_MAP_M  ((DPORT_PRO_RTC_CORE_INTR_MAP_V)<<(DPORT_PRO_RTC_CORE_INTR_MAP_S))
#define DPORT_PRO_RTC_CORE_INTR_MAP_V  0x1F
#define DPORT_PRO_RTC_CORE_INTR_MAP_S  0

#define DPORT_PRO_RMT_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0C8)
/* DPORT_PRO_RMT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_RMT_INTR_MAP  0x0000001F
#define DPORT_PRO_RMT_INTR_MAP_M  ((DPORT_PRO_RMT_INTR_MAP_V)<<(DPORT_PRO_RMT_INTR_MAP_S))
#define DPORT_PRO_RMT_INTR_MAP_V  0x1F
#define DPORT_PRO_RMT_INTR_MAP_S  0

#define DPORT_PRO_PCNT_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0CC)
/* DPORT_PRO_PCNT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PCNT_INTR_MAP  0x0000001F
#define DPORT_PRO_PCNT_INTR_MAP_M  ((DPORT_PRO_PCNT_INTR_MAP_V)<<(DPORT_PRO_PCNT_INTR_MAP_S))
#define DPORT_PRO_PCNT_INTR_MAP_V  0x1F
#define DPORT_PRO_PCNT_INTR_MAP_S  0

#define DPORT_PRO_I2C_EXT0_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0D0)
/* DPORT_PRO_I2C_EXT0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_I2C_EXT0_INTR_MAP  0x0000001F
#define DPORT_PRO_I2C_EXT0_INTR_MAP_M  ((DPORT_PRO_I2C_EXT0_INTR_MAP_V)<<(DPORT_PRO_I2C_EXT0_INTR_MAP_S))
#define DPORT_PRO_I2C_EXT0_INTR_MAP_V  0x1F
#define DPORT_PRO_I2C_EXT0_INTR_MAP_S  0

#define DPORT_PRO_I2C_EXT1_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0D4)
/* DPORT_PRO_I2C_EXT1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_I2C_EXT1_INTR_MAP  0x0000001F
#define DPORT_PRO_I2C_EXT1_INTR_MAP_M  ((DPORT_PRO_I2C_EXT1_INTR_MAP_V)<<(DPORT_PRO_I2C_EXT1_INTR_MAP_S))
#define DPORT_PRO_I2C_EXT1_INTR_MAP_V  0x1F
#define DPORT_PRO_I2C_EXT1_INTR_MAP_S  0

#define DPORT_PRO_RSA_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0D8)
/* DPORT_PRO_RSA_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_RSA_INTR_MAP  0x0000001F
#define DPORT_PRO_RSA_INTR_MAP_M  ((DPORT_PRO_RSA_INTR_MAP_V)<<(DPORT_PRO_RSA_INTR_MAP_S))
#define DPORT_PRO_RSA_INTR_MAP_V  0x1F
#define DPORT_PRO_RSA_INTR_MAP_S  0

#define DPORT_PRO_SHA_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0DC)
/* DPORT_PRO_SHA_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SHA_INTR_MAP  0x0000001F
#define DPORT_PRO_SHA_INTR_MAP_M  ((DPORT_PRO_SHA_INTR_MAP_V)<<(DPORT_PRO_SHA_INTR_MAP_S))
#define DPORT_PRO_SHA_INTR_MAP_V  0x1F
#define DPORT_PRO_SHA_INTR_MAP_S  0

#define DPORT_PRO_AES_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0E0)
/* DPORT_PRO_AES_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_AES_INTR_MAP  0x0000001F
#define DPORT_PRO_AES_INTR_MAP_M  ((DPORT_PRO_AES_INTR_MAP_V)<<(DPORT_PRO_AES_INTR_MAP_S))
#define DPORT_PRO_AES_INTR_MAP_V  0x1F
#define DPORT_PRO_AES_INTR_MAP_S  0

#define DPORT_PRO_SPI2_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0E4)
/* DPORT_PRO_SPI2_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SPI2_DMA_INT_MAP  0x0000001F
#define DPORT_PRO_SPI2_DMA_INT_MAP_M  ((DPORT_PRO_SPI2_DMA_INT_MAP_V)<<(DPORT_PRO_SPI2_DMA_INT_MAP_S))
#define DPORT_PRO_SPI2_DMA_INT_MAP_V  0x1F
#define DPORT_PRO_SPI2_DMA_INT_MAP_S  0

#define DPORT_PRO_SPI3_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0E8)
/* DPORT_PRO_SPI3_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SPI3_DMA_INT_MAP  0x0000001F
#define DPORT_PRO_SPI3_DMA_INT_MAP_M  ((DPORT_PRO_SPI3_DMA_INT_MAP_V)<<(DPORT_PRO_SPI3_DMA_INT_MAP_S))
#define DPORT_PRO_SPI3_DMA_INT_MAP_V  0x1F
#define DPORT_PRO_SPI3_DMA_INT_MAP_S  0

#define DPORT_PRO_WDG_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0EC)
/* DPORT_PRO_WDG_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_WDG_INT_MAP  0x0000001F
#define DPORT_PRO_WDG_INT_MAP_M  ((DPORT_PRO_WDG_INT_MAP_V)<<(DPORT_PRO_WDG_INT_MAP_S))
#define DPORT_PRO_WDG_INT_MAP_V  0x1F
#define DPORT_PRO_WDG_INT_MAP_S  0

#define DPORT_PRO_TIMER_INT1_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0F0)
/* DPORT_PRO_TIMER_INT1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TIMER_INT1_MAP  0x0000001F
#define DPORT_PRO_TIMER_INT1_MAP_M  ((DPORT_PRO_TIMER_INT1_MAP_V)<<(DPORT_PRO_TIMER_INT1_MAP_S))
#define DPORT_PRO_TIMER_INT1_MAP_V  0x1F
#define DPORT_PRO_TIMER_INT1_MAP_S  0

#define DPORT_PRO_TIMER_INT2_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0F4)
/* DPORT_PRO_TIMER_INT2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TIMER_INT2_MAP  0x0000001F
#define DPORT_PRO_TIMER_INT2_MAP_M  ((DPORT_PRO_TIMER_INT2_MAP_V)<<(DPORT_PRO_TIMER_INT2_MAP_S))
#define DPORT_PRO_TIMER_INT2_MAP_V  0x1F
#define DPORT_PRO_TIMER_INT2_MAP_S  0

#define DPORT_PRO_TG_T0_EDGE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0F8)
/* DPORT_PRO_TG_T0_EDGE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG_T0_EDGE_INT_MAP  0x0000001F
#define DPORT_PRO_TG_T0_EDGE_INT_MAP_M  ((DPORT_PRO_TG_T0_EDGE_INT_MAP_V)<<(DPORT_PRO_TG_T0_EDGE_INT_MAP_S))
#define DPORT_PRO_TG_T0_EDGE_INT_MAP_V  0x1F
#define DPORT_PRO_TG_T0_EDGE_INT_MAP_S  0

#define DPORT_PRO_TG_T1_EDGE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0FC)
/* DPORT_PRO_TG_T1_EDGE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG_T1_EDGE_INT_MAP  0x0000001F
#define DPORT_PRO_TG_T1_EDGE_INT_MAP_M  ((DPORT_PRO_TG_T1_EDGE_INT_MAP_V)<<(DPORT_PRO_TG_T1_EDGE_INT_MAP_S))
#define DPORT_PRO_TG_T1_EDGE_INT_MAP_V  0x1F
#define DPORT_PRO_TG_T1_EDGE_INT_MAP_S  0

#define DPORT_PRO_TG_WDT_EDGE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x100)
/* DPORT_PRO_TG_WDT_EDGE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG_WDT_EDGE_INT_MAP  0x0000001F
#define DPORT_PRO_TG_WDT_EDGE_INT_MAP_M  ((DPORT_PRO_TG_WDT_EDGE_INT_MAP_V)<<(DPORT_PRO_TG_WDT_EDGE_INT_MAP_S))
#define DPORT_PRO_TG_WDT_EDGE_INT_MAP_V  0x1F
#define DPORT_PRO_TG_WDT_EDGE_INT_MAP_S  0

#define DPORT_PRO_TG_LACT_EDGE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x104)
/* DPORT_PRO_TG_LACT_EDGE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG_LACT_EDGE_INT_MAP  0x0000001F
#define DPORT_PRO_TG_LACT_EDGE_INT_MAP_M  ((DPORT_PRO_TG_LACT_EDGE_INT_MAP_V)<<(DPORT_PRO_TG_LACT_EDGE_INT_MAP_S))
#define DPORT_PRO_TG_LACT_EDGE_INT_MAP_V  0x1F
#define DPORT_PRO_TG_LACT_EDGE_INT_MAP_S  0

#define DPORT_PRO_TG1_T0_EDGE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x108)
/* DPORT_PRO_TG1_T0_EDGE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG1_T0_EDGE_INT_MAP  0x0000001F
#define DPORT_PRO_TG1_T0_EDGE_INT_MAP_M  ((DPORT_PRO_TG1_T0_EDGE_INT_MAP_V)<<(DPORT_PRO_TG1_T0_EDGE_INT_MAP_S))
#define DPORT_PRO_TG1_T0_EDGE_INT_MAP_V  0x1F
#define DPORT_PRO_TG1_T0_EDGE_INT_MAP_S  0

#define DPORT_PRO_TG1_T1_EDGE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x10C)
/* DPORT_PRO_TG1_T1_EDGE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG1_T1_EDGE_INT_MAP  0x0000001F
#define DPORT_PRO_TG1_T1_EDGE_INT_MAP_M  ((DPORT_PRO_TG1_T1_EDGE_INT_MAP_V)<<(DPORT_PRO_TG1_T1_EDGE_INT_MAP_S))
#define DPORT_PRO_TG1_T1_EDGE_INT_MAP_V  0x1F
#define DPORT_PRO_TG1_T1_EDGE_INT_MAP_S  0

#define DPORT_PRO_TG1_WDT_EDGE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x110)
/* DPORT_PRO_TG1_WDT_EDGE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG1_WDT_EDGE_INT_MAP  0x0000001F
#define DPORT_PRO_TG1_WDT_EDGE_INT_MAP_M  ((DPORT_PRO_TG1_WDT_EDGE_INT_MAP_V)<<(DPORT_PRO_TG1_WDT_EDGE_INT_MAP_S))
#define DPORT_PRO_TG1_WDT_EDGE_INT_MAP_V  0x1F
#define DPORT_PRO_TG1_WDT_EDGE_INT_MAP_S  0

#define DPORT_PRO_TG1_LACT_EDGE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x114)
/* DPORT_PRO_TG1_LACT_EDGE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_TG1_LACT_EDGE_INT_MAP  0x0000001F
#define DPORT_PRO_TG1_LACT_EDGE_INT_MAP_M  ((DPORT_PRO_TG1_LACT_EDGE_INT_MAP_V)<<(DPORT_PRO_TG1_LACT_EDGE_INT_MAP_S))
#define DPORT_PRO_TG1_LACT_EDGE_INT_MAP_V  0x1F
#define DPORT_PRO_TG1_LACT_EDGE_INT_MAP_S  0

#define DPORT_PRO_CACHE_IA_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x118)
/* DPORT_PRO_CACHE_IA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_CACHE_IA_INT_MAP  0x0000001F
#define DPORT_PRO_CACHE_IA_INT_MAP_M  ((DPORT_PRO_CACHE_IA_INT_MAP_V)<<(DPORT_PRO_CACHE_IA_INT_MAP_S))
#define DPORT_PRO_CACHE_IA_INT_MAP_V  0x1F
#define DPORT_PRO_CACHE_IA_INT_MAP_S  0

#define DPORT_PRO_SYSTIMER_TARGET0_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x11C)
/* DPORT_PRO_SYSTIMER_TARGET0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SYSTIMER_TARGET0_INT_MAP  0x0000001F
#define DPORT_PRO_SYSTIMER_TARGET0_INT_MAP_M  ((DPORT_PRO_SYSTIMER_TARGET0_INT_MAP_V)<<(DPORT_PRO_SYSTIMER_TARGET0_INT_MAP_S))
#define DPORT_PRO_SYSTIMER_TARGET0_INT_MAP_V  0x1F
#define DPORT_PRO_SYSTIMER_TARGET0_INT_MAP_S  0

#define DPORT_PRO_SYSTIMER_TARGET1_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x120)
/* DPORT_PRO_SYSTIMER_TARGET1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SYSTIMER_TARGET1_INT_MAP  0x0000001F
#define DPORT_PRO_SYSTIMER_TARGET1_INT_MAP_M  ((DPORT_PRO_SYSTIMER_TARGET1_INT_MAP_V)<<(DPORT_PRO_SYSTIMER_TARGET1_INT_MAP_S))
#define DPORT_PRO_SYSTIMER_TARGET1_INT_MAP_V  0x1F
#define DPORT_PRO_SYSTIMER_TARGET1_INT_MAP_S  0

#define DPORT_PRO_SYSTIMER_TARGET2_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x124)
/* DPORT_PRO_SYSTIMER_TARGET2_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SYSTIMER_TARGET2_INT_MAP  0x0000001F
#define DPORT_PRO_SYSTIMER_TARGET2_INT_MAP_M  ((DPORT_PRO_SYSTIMER_TARGET2_INT_MAP_V)<<(DPORT_PRO_SYSTIMER_TARGET2_INT_MAP_S))
#define DPORT_PRO_SYSTIMER_TARGET2_INT_MAP_V  0x1F
#define DPORT_PRO_SYSTIMER_TARGET2_INT_MAP_S  0

#define DPORT_PRO_ASSIST_DEBUG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x128)
/* DPORT_PRO_ASSIST_DEBUG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_ASSIST_DEBUG_INTR_MAP  0x0000001F
#define DPORT_PRO_ASSIST_DEBUG_INTR_MAP_M  ((DPORT_PRO_ASSIST_DEBUG_INTR_MAP_V)<<(DPORT_PRO_ASSIST_DEBUG_INTR_MAP_S))
#define DPORT_PRO_ASSIST_DEBUG_INTR_MAP_V  0x1F
#define DPORT_PRO_ASSIST_DEBUG_INTR_MAP_S  0

#define DPORT_PRO_PMS_PRO_IRAM0_ILG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x12C)
/* DPORT_PRO_PMS_PRO_IRAM0_ILG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PMS_PRO_IRAM0_ILG_INTR_MAP  0x0000001F
#define DPORT_PRO_PMS_PRO_IRAM0_ILG_INTR_MAP_M  ((DPORT_PRO_PMS_PRO_IRAM0_ILG_INTR_MAP_V)<<(DPORT_PRO_PMS_PRO_IRAM0_ILG_INTR_MAP_S))
#define DPORT_PRO_PMS_PRO_IRAM0_ILG_INTR_MAP_V  0x1F
#define DPORT_PRO_PMS_PRO_IRAM0_ILG_INTR_MAP_S  0

#define DPORT_PRO_PMS_PRO_DRAM0_ILG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x130)
/* DPORT_PRO_PMS_PRO_DRAM0_ILG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PMS_PRO_DRAM0_ILG_INTR_MAP  0x0000001F
#define DPORT_PRO_PMS_PRO_DRAM0_ILG_INTR_MAP_M  ((DPORT_PRO_PMS_PRO_DRAM0_ILG_INTR_MAP_V)<<(DPORT_PRO_PMS_PRO_DRAM0_ILG_INTR_MAP_S))
#define DPORT_PRO_PMS_PRO_DRAM0_ILG_INTR_MAP_V  0x1F
#define DPORT_PRO_PMS_PRO_DRAM0_ILG_INTR_MAP_S  0

#define DPORT_PRO_PMS_PRO_DPORT_ILG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x134)
/* DPORT_PRO_PMS_PRO_DPORT_ILG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PMS_PRO_DPORT_ILG_INTR_MAP  0x0000001F
#define DPORT_PRO_PMS_PRO_DPORT_ILG_INTR_MAP_M  ((DPORT_PRO_PMS_PRO_DPORT_ILG_INTR_MAP_V)<<(DPORT_PRO_PMS_PRO_DPORT_ILG_INTR_MAP_S))
#define DPORT_PRO_PMS_PRO_DPORT_ILG_INTR_MAP_V  0x1F
#define DPORT_PRO_PMS_PRO_DPORT_ILG_INTR_MAP_S  0

#define DPORT_PRO_PMS_PRO_AHB_ILG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x138)
/* DPORT_PRO_PMS_PRO_AHB_ILG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PMS_PRO_AHB_ILG_INTR_MAP  0x0000001F
#define DPORT_PRO_PMS_PRO_AHB_ILG_INTR_MAP_M  ((DPORT_PRO_PMS_PRO_AHB_ILG_INTR_MAP_V)<<(DPORT_PRO_PMS_PRO_AHB_ILG_INTR_MAP_S))
#define DPORT_PRO_PMS_PRO_AHB_ILG_INTR_MAP_V  0x1F
#define DPORT_PRO_PMS_PRO_AHB_ILG_INTR_MAP_S  0

#define DPORT_PRO_PMS_PRO_CACHE_ILG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x13C)
/* DPORT_PRO_PMS_PRO_CACHE_ILG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PMS_PRO_CACHE_ILG_INTR_MAP  0x0000001F
#define DPORT_PRO_PMS_PRO_CACHE_ILG_INTR_MAP_M  ((DPORT_PRO_PMS_PRO_CACHE_ILG_INTR_MAP_V)<<(DPORT_PRO_PMS_PRO_CACHE_ILG_INTR_MAP_S))
#define DPORT_PRO_PMS_PRO_CACHE_ILG_INTR_MAP_V  0x1F
#define DPORT_PRO_PMS_PRO_CACHE_ILG_INTR_MAP_S  0

#define DPORT_PRO_PMS_DMA_APB_I_ILG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x140)
/* DPORT_PRO_PMS_DMA_APB_I_ILG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PMS_DMA_APB_I_ILG_INTR_MAP  0x0000001F
#define DPORT_PRO_PMS_DMA_APB_I_ILG_INTR_MAP_M  ((DPORT_PRO_PMS_DMA_APB_I_ILG_INTR_MAP_V)<<(DPORT_PRO_PMS_DMA_APB_I_ILG_INTR_MAP_S))
#define DPORT_PRO_PMS_DMA_APB_I_ILG_INTR_MAP_V  0x1F
#define DPORT_PRO_PMS_DMA_APB_I_ILG_INTR_MAP_S  0

#define DPORT_PRO_PMS_DMA_RX_I_ILG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x144)
/* DPORT_PRO_PMS_DMA_RX_I_ILG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PMS_DMA_RX_I_ILG_INTR_MAP  0x0000001F
#define DPORT_PRO_PMS_DMA_RX_I_ILG_INTR_MAP_M  ((DPORT_PRO_PMS_DMA_RX_I_ILG_INTR_MAP_V)<<(DPORT_PRO_PMS_DMA_RX_I_ILG_INTR_MAP_S))
#define DPORT_PRO_PMS_DMA_RX_I_ILG_INTR_MAP_V  0x1F
#define DPORT_PRO_PMS_DMA_RX_I_ILG_INTR_MAP_S  0

#define DPORT_PRO_PMS_DMA_TX_I_ILG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x148)
/* DPORT_PRO_PMS_DMA_TX_I_ILG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_PMS_DMA_TX_I_ILG_INTR_MAP  0x0000001F
#define DPORT_PRO_PMS_DMA_TX_I_ILG_INTR_MAP_M  ((DPORT_PRO_PMS_DMA_TX_I_ILG_INTR_MAP_V)<<(DPORT_PRO_PMS_DMA_TX_I_ILG_INTR_MAP_S))
#define DPORT_PRO_PMS_DMA_TX_I_ILG_INTR_MAP_V  0x1F
#define DPORT_PRO_PMS_DMA_TX_I_ILG_INTR_MAP_S  0

#define DPORT_PRO_SPI_MEM_REJECT_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x14C)
/* DPORT_PRO_SPI_MEM_REJECT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SPI_MEM_REJECT_INTR_MAP  0x0000001F
#define DPORT_PRO_SPI_MEM_REJECT_INTR_MAP_M  ((DPORT_PRO_SPI_MEM_REJECT_INTR_MAP_V)<<(DPORT_PRO_SPI_MEM_REJECT_INTR_MAP_S))
#define DPORT_PRO_SPI_MEM_REJECT_INTR_MAP_V  0x1F
#define DPORT_PRO_SPI_MEM_REJECT_INTR_MAP_S  0

#define DPORT_PRO_DMA_COPY_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x150)
/* DPORT_PRO_DMA_COPY_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_DMA_COPY_INTR_MAP  0x0000001F
#define DPORT_PRO_DMA_COPY_INTR_MAP_M  ((DPORT_PRO_DMA_COPY_INTR_MAP_V)<<(DPORT_PRO_DMA_COPY_INTR_MAP_S))
#define DPORT_PRO_DMA_COPY_INTR_MAP_V  0x1F
#define DPORT_PRO_DMA_COPY_INTR_MAP_S  0

#define DPORT_PRO_SPI4_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x154)
/* DPORT_PRO_SPI4_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SPI4_DMA_INT_MAP  0x0000001F
#define DPORT_PRO_SPI4_DMA_INT_MAP_M  ((DPORT_PRO_SPI4_DMA_INT_MAP_V)<<(DPORT_PRO_SPI4_DMA_INT_MAP_S))
#define DPORT_PRO_SPI4_DMA_INT_MAP_V  0x1F
#define DPORT_PRO_SPI4_DMA_INT_MAP_S  0

#define DPORT_PRO_SPI_INTR_4_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x158)
/* DPORT_PRO_SPI_INTR_4_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_SPI_INTR_4_MAP  0x0000001F
#define DPORT_PRO_SPI_INTR_4_MAP_M  ((DPORT_PRO_SPI_INTR_4_MAP_V)<<(DPORT_PRO_SPI_INTR_4_MAP_S))
#define DPORT_PRO_SPI_INTR_4_MAP_V  0x1F
#define DPORT_PRO_SPI_INTR_4_MAP_S  0

#define DPORT_PRO_DCACHE_PRELOAD_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x15C)
/* DPORT_PRO_DCACHE_PRELOAD_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_DCACHE_PRELOAD_INT_MAP  0x0000001F
#define DPORT_PRO_DCACHE_PRELOAD_INT_MAP_M  ((DPORT_PRO_DCACHE_PRELOAD_INT_MAP_V)<<(DPORT_PRO_DCACHE_PRELOAD_INT_MAP_S))
#define DPORT_PRO_DCACHE_PRELOAD_INT_MAP_V  0x1F
#define DPORT_PRO_DCACHE_PRELOAD_INT_MAP_S  0

#define DPORT_PRO_ICACHE_PRELOAD_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x160)
/* DPORT_PRO_ICACHE_PRELOAD_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_ICACHE_PRELOAD_INT_MAP  0x0000001F
#define DPORT_PRO_ICACHE_PRELOAD_INT_MAP_M  ((DPORT_PRO_ICACHE_PRELOAD_INT_MAP_V)<<(DPORT_PRO_ICACHE_PRELOAD_INT_MAP_S))
#define DPORT_PRO_ICACHE_PRELOAD_INT_MAP_V  0x1F
#define DPORT_PRO_ICACHE_PRELOAD_INT_MAP_S  0

#define DPORT_PRO_APB_ADC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x164)
/* DPORT_PRO_APB_ADC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_APB_ADC_INT_MAP  0x0000001F
#define DPORT_PRO_APB_ADC_INT_MAP_M  ((DPORT_PRO_APB_ADC_INT_MAP_V)<<(DPORT_PRO_APB_ADC_INT_MAP_S))
#define DPORT_PRO_APB_ADC_INT_MAP_V  0x1F
#define DPORT_PRO_APB_ADC_INT_MAP_S  0

#define DPORT_PRO_CRYPTO_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x168)
/* DPORT_PRO_CRYPTO_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_CRYPTO_DMA_INT_MAP  0x0000001F
#define DPORT_PRO_CRYPTO_DMA_INT_MAP_M  ((DPORT_PRO_CRYPTO_DMA_INT_MAP_V)<<(DPORT_PRO_CRYPTO_DMA_INT_MAP_S))
#define DPORT_PRO_CRYPTO_DMA_INT_MAP_V  0x1F
#define DPORT_PRO_CRYPTO_DMA_INT_MAP_S  0

#define DPORT_PRO_CPU_PERI_ERROR_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x16C)
/* DPORT_PRO_CPU_PERI_ERROR_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_CPU_PERI_ERROR_INT_MAP  0x0000001F
#define DPORT_PRO_CPU_PERI_ERROR_INT_MAP_M  ((DPORT_PRO_CPU_PERI_ERROR_INT_MAP_V)<<(DPORT_PRO_CPU_PERI_ERROR_INT_MAP_S))
#define DPORT_PRO_CPU_PERI_ERROR_INT_MAP_V  0x1F
#define DPORT_PRO_CPU_PERI_ERROR_INT_MAP_S  0

#define DPORT_PRO_APB_PERI_ERROR_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x170)
/* DPORT_PRO_APB_PERI_ERROR_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_APB_PERI_ERROR_INT_MAP  0x0000001F
#define DPORT_PRO_APB_PERI_ERROR_INT_MAP_M  ((DPORT_PRO_APB_PERI_ERROR_INT_MAP_V)<<(DPORT_PRO_APB_PERI_ERROR_INT_MAP_S))
#define DPORT_PRO_APB_PERI_ERROR_INT_MAP_V  0x1F
#define DPORT_PRO_APB_PERI_ERROR_INT_MAP_S  0

#define DPORT_PRO_DCACHE_SYNC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x174)
/* DPORT_PRO_DCACHE_SYNC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_DCACHE_SYNC_INT_MAP  0x0000001F
#define DPORT_PRO_DCACHE_SYNC_INT_MAP_M  ((DPORT_PRO_DCACHE_SYNC_INT_MAP_V)<<(DPORT_PRO_DCACHE_SYNC_INT_MAP_S))
#define DPORT_PRO_DCACHE_SYNC_INT_MAP_V  0x1F
#define DPORT_PRO_DCACHE_SYNC_INT_MAP_S  0

#define DPORT_PRO_ICACHE_SYNC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x178)
/* DPORT_PRO_ICACHE_SYNC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define DPORT_PRO_ICACHE_SYNC_INT_MAP  0x0000001F
#define DPORT_PRO_ICACHE_SYNC_INT_MAP_M  ((DPORT_PRO_ICACHE_SYNC_INT_MAP_V)<<(DPORT_PRO_ICACHE_SYNC_INT_MAP_S))
#define DPORT_PRO_ICACHE_SYNC_INT_MAP_V  0x1F
#define DPORT_PRO_ICACHE_SYNC_INT_MAP_S  0

#define DPORT_PRO_INTR_STATUS_0_REG          (DR_REG_INTERRUPT_BASE + 0x17C)
/* DPORT_PRO_INTR_STATUS_0 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define DPORT_PRO_INTR_STATUS_0  0xFFFFFFFF
#define DPORT_PRO_INTR_STATUS_0_M  ((DPORT_PRO_INTR_STATUS_0_V)<<(DPORT_PRO_INTR_STATUS_0_S))
#define DPORT_PRO_INTR_STATUS_0_V  0xFFFFFFFF
#define DPORT_PRO_INTR_STATUS_0_S  0

#define DPORT_PRO_INTR_STATUS_1_REG          (DR_REG_INTERRUPT_BASE + 0x180)
/* DPORT_PRO_INTR_STATUS_1 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define DPORT_PRO_INTR_STATUS_1  0xFFFFFFFF
#define DPORT_PRO_INTR_STATUS_1_M  ((DPORT_PRO_INTR_STATUS_1_V)<<(DPORT_PRO_INTR_STATUS_1_S))
#define DPORT_PRO_INTR_STATUS_1_V  0xFFFFFFFF
#define DPORT_PRO_INTR_STATUS_1_S  0

#define DPORT_PRO_INTR_STATUS_2_REG          (DR_REG_INTERRUPT_BASE + 0x184)
/* DPORT_PRO_INTR_STATUS_2 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define DPORT_PRO_INTR_STATUS_2  0xFFFFFFFF
#define DPORT_PRO_INTR_STATUS_2_M  ((DPORT_PRO_INTR_STATUS_2_V)<<(DPORT_PRO_INTR_STATUS_2_S))
#define DPORT_PRO_INTR_STATUS_2_V  0xFFFFFFFF
#define DPORT_PRO_INTR_STATUS_2_S  0

#define INTERRUPT_CLOCK_GATE_REG          (DR_REG_INTERRUPT_BASE + 0x188)
/* DPORT_PRO_NMI_MASK_HW : R/W ;bitpos:[1] ;default: 1'b0 ; */
/*description: */
#define DPORT_PRO_NMI_MASK_HW  (BIT(1))
#define DPORT_PRO_NMI_MASK_HW_M  (BIT(1))
#define DPORT_PRO_NMI_MASK_HW_V  0x1
#define DPORT_PRO_NMI_MASK_HW_S  1
/* INTERRUPT_CLK_EN : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: */
#define INTERRUPT_CLK_EN  (BIT(0))
#define INTERRUPT_CLK_EN_M  (BIT(0))
#define INTERRUPT_CLK_EN_V  0x1
#define INTERRUPT_CLK_EN_S  0

#define INTERRUPT_DATE_REG          (DR_REG_INTERRUPT_BASE + 0xFFC)
/* INTERRUPT_DATE : R/W ;bitpos:[27:0] ;default: 28'h1904180 ; */
/*description: */
#define INTERRUPT_DATE  0x0FFFFFFF
#define INTERRUPT_DATE_M  ((INTERRUPT_DATE_V)<<(INTERRUPT_DATE_S))
#define INTERRUPT_DATE_V  0xFFFFFFF
#define INTERRUPT_DATE_S  0

#ifdef __cplusplus
}
#endif



#endif /*_SOC_INTERRUPT_REG_H_ */


