/* File generated by gen_digital_signature_tests.py */

#define NUM_HMAC_KEYS 3

static const uint8_t test_hmac_keys[NUM_HMAC_KEYS][32] = {
     { 0x88, 0x7f, 0x3f, 0xa3, 0x29, 0xef, 0x0f, 0x28, 0xcd, 0x52, 0xd8, 0x71, 0x3b, 0x42, 0xf3, 0x6b, 0xab, 0x06, 0x20, 0xf0, 0x97, 0x9e, 0xb1, 0x84, 0xa0, 0x87, 0x33, 0x95, 0x8a, 0x71, 0x3d, 0x42 },
     { 0x23, 0xa3, 0xd4, 0xcd, 0x23, 0x84, 0x2a, 0x00, 0x19, 0x0c, 0xea, 0xcb, 0x2f, 0x74, 0xee, 0x6c, 0x9a, 0xe6, 0x37, 0x5c, 0x11, 0xe7, 0xa6, 0xe4, 0xa0, 0x46, 0xa2, 0x94, 0x4c, 0xc4, 0x7c, 0x03 },
     { 0xc3, 0x57, 0xe6, 0x43, 0x8e, 0x43, 0x18, 0xe2, 0x1c, 0x62, 0xa6, 0x39, 0xe4, 0xcc, 0x2d, 0xd6, 0x65, 0xfd, 0x4e, 0xe1, 0xa8, 0x7e, 0xcc, 0x33, 0xfd, 0x94, 0x5f, 0x6c, 0x51, 0xed, 0x2b, 0x14 },
};

#define NUM_MESSAGES 10

static const uint32_t test_messages[NUM_MESSAGES][4096/32] = {
        // Message 0
        { 0x25ad69d6, 0x91eb323e, 0x17775a77, 0x57a320e0, 0xcd5bf7b4, 0x0cc51926, 0x61d93910, 0x0282a886, 0xf7fedb88, 0x46092195, 0x7a873c61, 0x04a9afff, 0x06944073, 0xf5b751ed, 0x9b57ef00, 0x261cedcb, 0x61de5e9b, 0x361f889b, 0x4f9891dd, 0x895b137a, 0x32f452d7, 0x0bbe988e, 0x2cda65b3, 0xfea620f8, 0x750b25f9, 0x32b14a19, 0x1b63558c, 0xbff2c38b, 0x353ba4d6, 0xef6c71d8, 0x546cb6aa, 0x1cfb96dd, 0x370593e3, 0x9c065ebc, 0x51a06276, 0xe3eacdc4, 0x614bff9e, 0xdcc16475, 0x064e0c13, 0x31fe1540, 0x18290c9c, 0xa3e7772a, 0x014ceb99, 0x9d729d1d, 0x649858cc, 0x9f81ba7b, 0xcbfdc0e6, 0x7e091677, 0xcaaac7b5, 0xc524cda0, 0xcb1abaf2, 0x4cb202af, 0xfd1f0ec1, 0xa3099ff2, 0x6f94bfb2, 0x84b90fe8, 0xfc0a6e55, 0x838a1a70, 0x0b9e89ae, 0xb2282b6f, 0x0d2d0b6b, 0x6c874058, 0x095947e7, 0x7b81745d, 0x9aaa321a, 0x2a4f0439, 0x1e645d88, 0x9cf69049, 0x1665d5ab, 0x045ea4b3, 0xdc4cb8b5, 0xe1f43cc5, 0x162a6bb8, 0x6c669c9f, 0x822a7c45, 0x83c52c9e, 0x05b7365b, 0xd0528bbe, 0x2f95b41b, 0xdcf5ab6d, 0x71a195dc, 0xbf63aa9f, 0x154acefa, 0x0b43db19, 0xdbdd5627, 0xb90a5603, 0xd431e776, 0xbc998a30, 0x94e42eec, 0x589dc036, 0xec84aac2, 0xb5c581d1, 0xa4d7df9b, 0x901be609, 0x884ddeab, 0xf7bb499b, 0xbe09d026, 0x4ff33681, 0x2b0c0448, 0xa2e7ade2, 0x6c1f7a6e, 0xdf54f9a1, 0xdacdac01, 0x00772f78, 0xd2cb9677, 0xc6bb7703, 0x713b0474, 0x2c86eba0, 0x7c3fb771, 0x4f7ba7bc, 0xbe9e678f, 0xbc6f083b, 0xa9722007, 0x74577a82, 0xeaaa6b05, 0x7a697180, 0x2ed75e42, 0x12292317, 0xfdd29654, 0x3af47162, 0xf263eb6d, 0x7fef918c, 0xa1d11947, 0x84e34025, 0xac5a9504, 0xaae95743, 0x8a5c826d, 0xa696e249 },
        // Message 1
        { 0x52933b03, 0x69e94a89, 0x7908dada, 0x89ebb645, 0xa044384f, 0xbb6834d0, 0x4ea6d23d, 0x3c141508, 0x4ac9cf0b, 0x39ea3b66, 0x7528f037, 0x82069116, 0x049da428, 0x4bb5eddd, 0xa1f15964, 0xf6542e77, 0x3f88977c, 0x81043c8d, 0x08a76504, 0x4bf106c7, 0x7be36c2d, 0x6b1eb66d, 0x19b0238a, 0x92d22830, 0x2c5b9ba4, 0x6a129baf, 0xd43cd62e, 0xe0d3c3a6, 0xc9941153, 0x6d97de07, 0xb42b9be7, 0x4e19a52d, 0x9a8bdc8f, 0x02e3fda0, 0x2c0f8661, 0x16d36f09, 0x257fbc3e, 0x9158e856, 0x7dcdfe32, 0xc4370310, 0x513c96e3, 0x60bc3b9e, 0xc5e92dcf, 0x60af2780, 0x02271def, 0xe5d1a9f5, 0x13a9ffd6, 0x7c35b4be, 0xa4f73ee9, 0xd2820adf, 0xb072c31d, 0x82ed09e3, 0x096ce7c9, 0x9da54294, 0x1b3206fd, 0x67f51b4d, 0x1578c0bc, 0xbc92e02c, 0xa8a9eff8, 0x36573899, 0xc862c44a, 0xc5b646e6, 0x51663788, 0x78613337, 0x96a044c8, 0x693f5036, 0x91ea0d26, 0x8e46ecb6, 0xd335c6c5, 0xebe6d968, 0x2d34c755, 0xe0990f08, 0x8b46235e, 0x8d31f479, 0x727f782f, 0xf295339c, 0xdcdd3f5e, 0x81ce8624, 0xf8718118, 0x3e97be4a, 0xbc987520, 0xeed4139e, 0x8fef5b3a, 0xa78cf5ff, 0xf206997b, 0xb641efac, 0xae9249d3, 0xcb31136e, 0x913b7032, 0x27518b0f, 0xfc33f0f2, 0x315c5fb1, 0x304cff19, 0x85b3745a, 0x74bad38c, 0x16469267, 0x8e9da359, 0xce3891a2, 0x29e04bc2, 0x3a22e4a0, 0x3993d209, 0x1abac0d0, 0x7ee12079, 0x339f5052, 0xc8ce326e, 0xf26bfd59, 0xfc2395ce, 0xcb665707, 0x109cccb5, 0x43ceb4d9, 0x7b4fdc20, 0x4c691889, 0xbb8c85bf, 0xd4eb5d69, 0xd3c77a5e, 0x1e45e915, 0xc4f47dca, 0x0d57d09a, 0xa9009a18, 0x2a5d7b26, 0xadc7e9a8, 0x73d72d5d, 0xd18c0705, 0x6c3bd4aa, 0x50bd9908, 0x36b8a902, 0xb8c58b34, 0x07037754 },
        // Message 2
        { 0xe1b3ef28, 0xb1536ed3, 0x659ca5e1, 0x1cf55c3a, 0x953094e8, 0xf293ea2d, 0x747248e9, 0x6fc99f11, 0x46d3e3c2, 0xb6725599, 0x85e0ecb9, 0x95cc20b9, 0xfd40f64c, 0x5bf9e815, 0x62d74be7, 0x1f70d322, 0x43b8e26c, 0x88432146, 0xb72e3e4e, 0x2255392a, 0x5d33b258, 0x84c8960f, 0x7c562e5c, 0x93670a9c, 0xae69b36d, 0x07e7e491, 0x23aa6ebe, 0x42d10fff, 0x8ef9e951, 0xa7c9e449, 0xc379c8da, 0xf6f48e03, 0xef8af416, 0x2f297474, 0x825f771b, 0x4a520c4e, 0xb27845f4, 0x97d9e784, 0xf57309da, 0xb191cc85, 0x663a68e9, 0x092f91cc, 0xc97cb907, 0x620772e8, 0x792c1b9e, 0xa9171449, 0xd304006c, 0x9262ff1f, 0x0f90afdf, 0xad48bbbc, 0xb61a5ad2, 0x4cbe11c1, 0x338d8744, 0xf3119b3f, 0x288a4935, 0xe1edd127, 0x60592eaa, 0xe72ef902, 0x5822b432, 0xf3b30b8d, 0xcbe9e1be, 0x4dca965e, 0xc7129e9f, 0x4454a86a, 0x10e551c9, 0x66ba73c4, 0x1d3b196c, 0xcd775dfa, 0xa6470d0f, 0xb3cd2608, 0xd8473a72, 0xeda40841, 0x397366c5, 0x56af8249, 0x9a0fdcc0, 0x404001c3, 0xbf247c73, 0x0f0ef66e, 0x908f8a9c, 0x497abb84, 0xd53f47ff, 0x65bbaa1e, 0xfe1797e2, 0xef1c2bb2, 0x14c771aa, 0xbaeb8655, 0xc03c3961, 0xf2b7f156, 0xbd88659e, 0xf08a7759, 0x543d31a0, 0x38f451cd, 0x13b05482, 0x32e8c082, 0x27ccd40a, 0xc60256b7, 0x1b9a6cae, 0x1fa04e84, 0x00fda300, 0xcb87f193, 0xcae111f4, 0x1ca4c417, 0xbdaaff81, 0x15069286, 0xd7d0682f, 0x8bdf15af, 0xb476a444, 0xf1aad8e1, 0xc9553f61, 0x5919a23a, 0x136aa610, 0x1c72a6fb, 0x04019822, 0x29254994, 0x839dd2c0, 0x644e841f, 0x755fa15d, 0xc7c8ec35, 0xcf5b3012, 0x34166fbc, 0x1582240f, 0xedb068bc, 0xf3697a43, 0x402b0c48, 0x9a1fe7e7, 0xaaa66714, 0xd86902f9, 0x1e1c94d2 },
        // Message 3
        { 0xfd3be4b4, 0xf9b9af44, 0xb8a5c5bf, 0x6f6233cf, 0x891b97a5, 0x66d69832, 0xf4abe904, 0xd04dfd81, 0xc0c14012, 0x34711122, 0xfddd7847, 0x15d1a8b2, 0x5d5c21ff, 0x4d4e17d4, 0x9082f8be, 0xa6ef5126, 0x4e4a2e39, 0x4bd54d3d, 0xd30cc4af, 0x95f62618, 0x6d94ef44, 0xd199881a, 0x4a1fadde, 0x40afde90, 0x68236473, 0xb424827b, 0xaf1f76d7, 0x936a7301, 0x588c0ee2, 0xa69761bf, 0xb75294bd, 0x9ad8a9ca, 0xf8986013, 0xf2a81906, 0x29e5fe05, 0xc3075719, 0x1b6b35ac, 0xfcf65c2c, 0xb0df0501, 0xaf7aff5f, 0xaef945a9, 0x20ecd8ad, 0x8b305d22, 0xee7f6f16, 0x32e25cf1, 0x86f769c5, 0x23f13341, 0x5a56c2a1, 0x6383f836, 0xd489823d, 0x00d9538a, 0x8bdb2736, 0xd1508a97, 0x1a662e7e, 0xc7df95a1, 0xc6b8a2ad, 0xe1cdfaff, 0x1e12d8be, 0x60f950b0, 0xf5308b54, 0xc046a930, 0xca7f886e, 0x46d5cb07, 0x0f513cfe, 0xbf74feda, 0xe84d3a64, 0x8abc39df, 0x23e77597, 0x09f3f437, 0x81866a24, 0xdbd8a527, 0x805ac7cd, 0x071a302e, 0x04cdb801, 0x42b22363, 0xbe6babb8, 0xcaf2aa32, 0xb7c93173, 0xd3996c64, 0xafa673e0, 0x7e5565fc, 0xdce7ef75, 0xae35f3cf, 0x8e363493, 0xa3d61ee5, 0x591931b1, 0x8c6f5124, 0x79cb6745, 0x780171f4, 0x67dae298, 0xa866e6f6, 0x349a8688, 0x28da92ae, 0xe3af6ec5, 0xb468492b, 0x60c10753, 0x613456f1, 0xf2c112ad, 0x945c2a2e, 0xadbd9a8d, 0xf0003a24, 0xf34801ae, 0x1267c7d6, 0x4cb6995e, 0x1a2f1250, 0x9a385af6, 0xc5936090, 0x11435fe2, 0xd1a5b546, 0xe9fd8a0c, 0x021830ce, 0x8a8bda35, 0x48367bd9, 0x88bd9a62, 0x64ee2074, 0xa1412e37, 0x467bcb58, 0x4f55eeee, 0x1943a6d5, 0x8311ff1e, 0xb413c87a, 0x122ed983, 0xb6339df0, 0x7b5342ac, 0x986934d7, 0x698a0070, 0x440aed6f, 0x7f94a3ef },
        // Message 4
        { 0x129b55a0, 0x57f13f11, 0x372218ad, 0x203f52ad, 0x6ba71e68, 0x6389ec84, 0x9ee6b3f6, 0x7bb6387a, 0x0661605c, 0x914e4b01, 0xc8829e94, 0x235e8a93, 0x22bef3f9, 0xd10fa744, 0xfac22a8a, 0x3db2c98b, 0x22c516dd, 0xa5abb919, 0x81bf4c8b, 0x7e9c3daa, 0x391c4fa6, 0x6dce0869, 0xa4d7948f, 0x7fb2d65d, 0x130f2ad2, 0x6ce821c0, 0xc4a1470a, 0xfd65a295, 0x2626daef, 0x5992aec9, 0xa655fdbe, 0x7c47618a, 0x58d85dc1, 0x145fd3b5, 0x416a71de, 0x8cb34b30, 0xa12e30a4, 0xcc4bf81a, 0x85c5a9eb, 0x9c7823fc, 0x62b7636f, 0x8ed2116f, 0x7ccd6ff7, 0xda9185ff, 0x67be3a47, 0x676814f2, 0x4a67f912, 0x2e1ad79f, 0xdc91ee9b, 0x5bbe4db5, 0xd107e03a, 0x55f51bb1, 0x02a23262, 0x3e290d71, 0xb900f2fc, 0x16ea4c4f, 0x2870c471, 0x415913a5, 0x3fa96989, 0xb3bfe3c2, 0xed7f3b92, 0x6f198430, 0x1f955384, 0x000ed450, 0x429304c8, 0xe29b9061, 0x5d68eab7, 0xeede9c7d, 0xae114518, 0x9d69096d, 0x239b787c, 0xbcf3a366, 0x0a072402, 0xd9e60889, 0x6d476405, 0x6dc67369, 0xca943a4c, 0xd8c4c938, 0x655ecabb, 0x5674ac0e, 0x642fafd4, 0xd67c69f4, 0x1bea5988, 0x5c30b1fc, 0x3f3024fa, 0x3a7e1628, 0x55df382d, 0x8d0cb8cf, 0x5456ac38, 0xfd644f91, 0x9a306795, 0xd3e75547, 0x5c55de78, 0x9ce2e685, 0xa94b7d8a, 0xe4c91593, 0xae923f77, 0x620c904a, 0x4000a809, 0x262eb713, 0x96113a4b, 0x4296ed7c, 0x80d0ce5e, 0x439473de, 0x73d1a427, 0x288ddf47, 0x3a18d2b3, 0xd84c2177, 0x6bca3c32, 0x52ce2a70, 0xcc5ce260, 0x7fb6d38c, 0x197cd744, 0x98a68e37, 0xd3532539, 0x1eaffaff, 0xcae34813, 0xdd453fca, 0xd152dd7e, 0x0331dabe, 0xeb64e351, 0x87dcc689, 0xba712196, 0xb9b7e8d0, 0xb0a64e5f, 0xd32f6c8f, 0x2a20b494, 0xb1441d28 },
        // Message 5
        { 0x7e458bcb, 0xc1a4e883, 0x8a4c63e1, 0xc3628859, 0x95cd76af, 0xf9702598, 0xfb501689, 0x87d20c07, 0xdcb49c7b, 0x8bf2720d, 0xf66abae7, 0x61413883, 0xe88ec6cc, 0x82ce7e47, 0x370a4e3c, 0x49eab037, 0x13666255, 0xc8db39f9, 0x9da49282, 0xa2efa28f, 0x0bdecbe6, 0xaea01442, 0xccd57758, 0x42942001, 0x289465fa, 0xa2bc40a8, 0xf1072cb9, 0xe3c8a0c8, 0x58a14380, 0xa9fe411e, 0x94f0eff3, 0x7f208b11, 0x71329710, 0xa59d6358, 0x717d44bf, 0x05b61a15, 0xcbb8262b, 0x31a1ed2f, 0x8448735a, 0x8e71a6fc, 0xd2e551e5, 0xa3e531f8, 0x58653cd9, 0x486ddb86, 0xaed35ffc, 0x713728ae, 0xd8fa3b11, 0x50379e60, 0x481ff3ff, 0xaf5acd61, 0x4ba743a8, 0x411709cc, 0x9e2ace8e, 0x34088d5b, 0x11fcb732, 0xe2e4dca6, 0xdc593b6a, 0xfffe858e, 0xb43ba733, 0xc317adbf, 0x656cbe49, 0x1a19117b, 0x085796b1, 0x91f4dc0e, 0xdfb57e13, 0xa4106bab, 0x01273c88, 0xaede7148, 0xcd0e46dd, 0x00f4ad43, 0x7b788f87, 0x74817eb6, 0x6abd800f, 0x4f4945be, 0x50e3174a, 0x8c0aae25, 0x04e68fa5, 0x5eecad9a, 0x1489b3b2, 0x1b22d1bb, 0x0ac24cc6, 0x34215234, 0x585801ea, 0x8c8af2bc, 0x253747f6, 0xc8d587c1, 0x7740f4cf, 0x6710ac61, 0x002a4e43, 0x575fea76, 0x221f2ebe, 0x12b0fc0e, 0x706940d2, 0x52d1b14c, 0x1769bc46, 0x2b0c7d6c, 0xa66e5d86, 0xf21ae24b, 0xb44bf56c, 0x9b99d4ed, 0x8e45edbf, 0xe9a4ecad, 0x2b90a4c3, 0xe2c65827, 0xcfe085d9, 0xf4527e3b, 0x0d29e710, 0xa5cbf792, 0xcd2c9b7f, 0x712b2e9a, 0xf9e6a366, 0x46b35e91, 0xb23b99d9, 0xd8c416dd, 0x7ca52df3, 0x50ee406c, 0x288a46dd, 0x87344764, 0x99414b1a, 0xc0b5bcc7, 0x204b8b89, 0x5011c838, 0x2b89e90f, 0x5b5da2ac, 0xaeb8582d, 0x99e350da, 0xab4df3a6, 0x383b6464 },
        // Message 6
        { 0xbf12cd49, 0x10cfb5f1, 0xbd5339e9, 0x9577ecd2, 0xa6512b9f, 0x63adf520, 0xb7cf69f8, 0x07e3d1d0, 0x157ef255, 0x0bb9c98e, 0x6d07520e, 0x1847377c, 0x94bae416, 0xd3f4fd58, 0x34904f8f, 0x1b97def2, 0x08089917, 0x6ded3ad1, 0xca73de78, 0x0b03d977, 0x30291328, 0x5997599a, 0x2c615abe, 0xb7b38ccf, 0xf115178f, 0x6c00807d, 0xaaebee86, 0x9d773b2d, 0x1735bd05, 0x653b8fe3, 0x7cfbd27c, 0x1698bdf1, 0x06838bf6, 0xb9ee84f1, 0xe80f1459, 0xa21f2a35, 0xb5efac66, 0x0a6ab7cb, 0xa5c64451, 0x8190d946, 0x6e8638ca, 0xd3b69c27, 0xbcfdc794, 0x0e71abb4, 0xd9c20d84, 0x7c1c3ab6, 0xddab59ce, 0xcddbabfd, 0x57d8439a, 0x3950c36d, 0xec404b39, 0x481fc103, 0x1de9d239, 0x02737e98, 0x08169474, 0xc71a28ae, 0x57a04dfe, 0x90726e7a, 0xfd3412b3, 0xe29011f9, 0xd4c27f08, 0x06cf7851, 0x3aebc495, 0x87f2d9d8, 0xc06121ed, 0x9aec3ae2, 0x61a49a1c, 0x38449a8f, 0x25d537e5, 0x9969f0b1, 0xfdbe002c, 0xd959d186, 0x81833ff0, 0x1b71c1b6, 0x028cd70f, 0x20d667cb, 0xe49b40a5, 0xe8467006, 0xefd142b7, 0x59979963, 0x44a6ecb4, 0x6b07feb9, 0xff9734c9, 0xde719451, 0x913e6a40, 0xad513e27, 0x4d68530b, 0xc671c2e5, 0x7caeb98d, 0x82021260, 0x70cf9815, 0x475db3b1, 0x9c93b4df, 0x34ed2cf3, 0x45bc4d90, 0xade44d81, 0x52abaaf0, 0x1cd1e9f5, 0x4f6eb998, 0x3db35d49, 0x4b0d7b8a, 0x8e669d3d, 0x45dc0777, 0xba493e96, 0x71973dc0, 0xae9d87e3, 0x52a43f26, 0xb317c4eb, 0x14691807, 0xb8137590, 0xd4b49e0e, 0xa9a490fd, 0x547568a1, 0x032d2b36, 0x6855e036, 0xd835bcbd, 0x9b87baf0, 0x17e7b00c, 0x970be0a4, 0xac2a96ed, 0x5a3c1dcd, 0x395b7308, 0x8dd16f13, 0x833f2192, 0x7da8dd03, 0x84e5b8d0, 0xd3d51807, 0x0206130c },
        // Message 7
        { 0xb1fdaec7, 0xfcf41329, 0xe3a9bd1f, 0xfe289ead, 0x7bd0df52, 0x8bce487e, 0x77a877a1, 0x48ab240b, 0xd4b40910, 0xdd4bab53, 0x205a1ab7, 0xeef8d485, 0x2f02c61d, 0xed100771, 0x472b74d8, 0x3b3076b8, 0xdbdaee53, 0x951c089b, 0x18eca0bb, 0xf5a6c087, 0x997f66df, 0x02019060, 0xe5f76aaa, 0x39b3e011, 0x05f1370d, 0x84c04042, 0x412cd297, 0x8c9f914c, 0xebb5c5d2, 0x3eacc815, 0xc681d3d8, 0x12123dcc, 0xda6f9744, 0x9ee1f915, 0x6e1e9df1, 0xfcca0724, 0x150e0c3c, 0xb1b970b9, 0x07e3e5ef, 0x2e5554c1, 0xfebbd56b, 0xd251aa50, 0x6ceaf4a4, 0x6853e6c8, 0x3f937a01, 0x5809191c, 0x36d42d8a, 0xe3511055, 0x6bc352f4, 0xc38d4fd0, 0xaa7aab97, 0x3d83ae85, 0x896851f6, 0x120f196b, 0x1378a3ce, 0xe491ed51, 0x784cf527, 0xd2710bb9, 0xe7f00f7d, 0x03f12c58, 0xbdcdd8c8, 0xd78895ab, 0xcda87b7b, 0x8d50edf4, 0xc25968ae, 0x799ada13, 0xc0e7dc19, 0x51219645, 0xdd7a653e, 0x1c8c3782, 0xc6964248, 0xea5ceedc, 0xa4489723, 0x82bd46b2, 0x2b6ca97b, 0x038f51dc, 0x1474b642, 0x99313ab3, 0x16531e28, 0x531a29a4, 0x077bd9e3, 0x37c56052, 0x4328da38, 0xaeed51a9, 0x1acda37f, 0xcd40a630, 0xffd58d30, 0x90a72ed5, 0x80d5babd, 0x0e22128f, 0xb57953e1, 0x20d043c4, 0x3bd165db, 0x91dbd896, 0x2faba733, 0xabd6191b, 0xb2dd740c, 0xada1f989, 0x2fe03e4f, 0x289490f4, 0xd6d4dcab, 0xe0a23768, 0xeb1f02ae, 0xd9026b2b, 0x89d6779f, 0xe404a6fb, 0x9b523f7c, 0x9660e51c, 0x049f1c9d, 0x48aa8a37, 0xfe81a298, 0x63370d86, 0x1984ed61, 0xcebf1f9f, 0xee0feaaf, 0x5f4fe31b, 0x6fa9167f, 0x4b8bf7ab, 0xbc7261de, 0x1094f924, 0x8b3eb45a, 0xfd441744, 0xc6597a3a, 0x7d1a967d, 0xe06d2800, 0x63e506bc, 0xd4ed45e9, 0xfaed7d97 },
        // Message 8
        { 0x7afb3d9f, 0x84674f54, 0x344410fd, 0xe31a035f, 0xbabf4d28, 0x106dc59b, 0x3985acad, 0xaf2cde52, 0x17b38869, 0x08127f43, 0x7b1773e8, 0x7d7c7f2b, 0xd272dd8d, 0x8e009c81, 0x81e11eeb, 0x8b85186f, 0x7c706bfa, 0xd0572d80, 0x08a0fdf6, 0xb13765ed, 0x9e88848f, 0xc8c846ff, 0x2c1d0a6e, 0x25651d99, 0xe1239b3e, 0x7400b960, 0xac6638ca, 0x0edb859a, 0x02542461, 0xb97c7daa, 0x0cf69a14, 0x93444fdb, 0x3b3dde0d, 0x3f7649e7, 0xeecfbcd4, 0xf07a0a5a, 0x60e664f9, 0x51276dad, 0xec242fa2, 0x099feb9a, 0x58e312ba, 0x35888742, 0x59cc0866, 0x93fddbc4, 0xcc780789, 0x2a0b43be, 0x9abbe6bf, 0xdecc45cf, 0x9f1f942d, 0x2a1cf618, 0xcc433238, 0xe9b5563e, 0xf05b97ab, 0x72c87dee, 0x922286fc, 0x42b3f0e4, 0xacb6f255, 0x354469c7, 0xcab43af6, 0xa25f9b66, 0x024cd40b, 0x438c5b1e, 0xd91f695b, 0x02c3fbb5, 0x06b4a353, 0xdd2a9a82, 0x0646f834, 0x9a5b3b45, 0x18bf3e1f, 0x8b171f5d, 0x94efd0b2, 0x49a8aa96, 0x657565de, 0x8a687128, 0xf7278ec3, 0xd9a5b689, 0xe5c520e0, 0x3e5a1e07, 0x7842ab13, 0x15f02174, 0x371fc980, 0xbefb47c9, 0x78e54694, 0x31b5be19, 0x0fdd6fea, 0x2c7f9537, 0x01c939d4, 0xc7bd8ca8, 0xdfb9740f, 0x0de2c2e4, 0xbc2c2877, 0x278a6cf3, 0x13867d18, 0xde1aea04, 0xe0c04f2f, 0xda7f2179, 0xaefcde17, 0xa3ed8f00, 0xba83fc5c, 0x38541456, 0x9374099e, 0x87fa6624, 0xc4f4899a, 0xdfdfceab, 0xb4b603d5, 0x7af35061, 0x03c01529, 0xc993ba3d, 0x33fd3795, 0x26f48510, 0x4135f0ed, 0x975f15af, 0xe599d8ad, 0x328f6d71, 0x3ec24819, 0x194bad3b, 0x4990fb29, 0xbb3ca296, 0xd934850f, 0x9ccb38fd, 0x34bf738a, 0x688667d8, 0x5ec4eec7, 0xc80c9f1d, 0x9b355f69, 0x9824810f, 0xaf0ced2a, 0x0eab16ca },
        // Message 9
        { 0xeee28620, 0x90e04d21, 0xbb0f568e, 0xc71451be, 0x75b756a7, 0x834a5182, 0xf8f78a5c, 0xdbf9e4ff, 0x3075fdf6, 0xe86526f0, 0x6c66c0db, 0x8c522068, 0x39e67715, 0x22a8d6fe, 0xbe4351ba, 0x55f77dca, 0x474414e3, 0x8248eef4, 0xa95f71de, 0x88721195, 0x1b4acfbf, 0xe4a53a7c, 0xe23524f1, 0x3bdc0ee1, 0xc2651cab, 0x1a37a39e, 0x8fdb4657, 0xbdaf47fb, 0x001bc7e9, 0x9409fb2c, 0x1fd9baa1, 0x854f8296, 0x31a53299, 0x1b48182a, 0x0e2ad69c, 0x752d7e42, 0x2382f1ca, 0x0790b604, 0x1a25ce0e, 0xa994d71c, 0x7aaa0030, 0x9fef0137, 0xb4b7b9c0, 0x8811f669, 0x890cffd1, 0xf723feb9, 0x6c0c6268, 0xbbdbd670, 0xbf49797f, 0x7e194688, 0xf840b546, 0x61c54766, 0x33fbf211, 0x4f10ff37, 0xa89e3bec, 0xbc7a9f07, 0x94cc61b6, 0x50d51f8e, 0x33f386d6, 0x6e649efe, 0xede8d0a0, 0x7918a1df, 0x5cebd7a0, 0x05c4d1a6, 0x9a1b9364, 0xc5d88343, 0xd1dfd15c, 0x71665835, 0x076a3d24, 0xf99e87e9, 0x3f9ac6b7, 0x026bc328, 0xdf70e30b, 0x70e46bf1, 0x6efbac3a, 0xa4b53f98, 0x7fab3b9c, 0x161eb527, 0x666407eb, 0x618c0d45, 0xd4faa3ec, 0xda5c2a5c, 0xda1990aa, 0xd08c1bd0, 0x939c01b4, 0xa8dfd292, 0xc809222e, 0x4c22d3b7, 0x81722c42, 0x106f41f4, 0x4b310ef6, 0x00b89a9e, 0xcdffa387, 0x81b0a968, 0xe443fcb4, 0xa800fbe5, 0x689ce3b6, 0x98099838, 0x0736479f, 0xba886d57, 0x060b4fd8, 0x66c9243a, 0xd5639e7b, 0x6fbf81cb, 0xa2ef8ead, 0x75bb6016, 0x6c766a54, 0x358a5883, 0x32c08ed2, 0xb9514f5b, 0x9fa98dd1, 0x38c2284c, 0x3ce7c356, 0x900a7e7f, 0x94cc4857, 0x7e73e893, 0x63b14953, 0x9907c6b5, 0x61efab9e, 0x671041af, 0xf71ec020, 0x2d2240c6, 0xa6575676, 0xc8134499, 0x71725702, 0x8bce91fd, 0xf71241eb, 0xfb8be8eb },
    };



#define NUM_CASES 5

static const encrypt_testcase_t test_cases[NUM_CASES] = {
    { /* Case 0 */
        .iv = { 0x20, 0x34, 0x1b, 0x9e, 0x4e, 0xee, 0xf5, 0x90, 0x0a, 0x10, 0x18, 0x33, 0xd1, 0xea, 0xfd, 0x57 },
        .p_data = {
            .Y = { 0xd00d4131, 0x42e3b800, 0x81debccc, 0xaa924fe6, 0x6cd5051f, 0x26dc3ca0, 0x05c0d82c, 0x3b7bee94, 0x63558d8a, 0xfd0eb308, 0x794e5c20, 0x73e3f695, 0x178ab220, 0xe9c71156, 0x23a66469, 0x77fc4da0, 0xb5107a1b, 0x57e48143, 0x8fb62803, 0x4a306b00, 0x48d53d65, 0x265fc48f, 0xccaaef90, 0x95739488, 0x56ca296b, 0xd03dd942, 0xe783cb93, 0x43d103ca, 0x397b44ff, 0xba78da47, 0x58ff35cc, 0x3597c306, 0xc9c8c55d, 0x4406dfe9, 0xe9c8b307, 0x154840fd, 0xcb85ec3d, 0x98eff323, 0xe1db5560, 0x5a347083, 0x0565a1b7, 0x0fa19f08, 0xef948a7d, 0x09fd43ff, 0x01f409a4, 0x2ffa4e07, 0x70ca189e, 0xb053c641, 0x62ed5931, 0x9721b886, 0x17b2744a, 0xe7e8a90a, 0xaf19f0ce, 0xb2e33f01, 0xd5d15a9d, 0x224725bd, 0x344a8c09, 0xe566a096, 0x3bc7bb32, 0x0ca18baf, 0x1f6afd7a, 0x20207af1, 0x07468e08, 0x09ee28ff, 0x58f2a851, 0x4ddd7a4a, 0xb4db75f9, 0xa299b458, 0xc2d8ddac, 0xdc09e3e3, 0xc4de80e9, 0x42486f2f, 0x9b6a23f3, 0x44040219, 0xd0bfc03f, 0x20d95aed, 0x50f73051, 0x7b34a5d9, 0x04852220, 0x50b75fa9, 0x944e9624, 0xf40a75ef, 0xa0e85401, 0x2c21d2e1, 0x91162ed5, 0xa1477199, 0x6fd93a5f, 0x1dddf880, 0xdcd2ce78, 0x609a860e, 0xba7f484e, 0x27eb289f, 0x427c8ec3, 0x559a6557, 0xd1c2829d, 0xa29fbc37, 0x9c640643, 0xee8625ce, 0x4dfdeb25, 0x5a95149d, 0xa0ee4902, 0xaa4f7533, 0x36f19f3e, 0x2b650dbc, 0x982e0035, 0x8a87c147, 0xda3a67aa, 0xe36d4da6, 0x565fcfd9, 0xd6fe873e, 0x9fd8db09, 0x93231d58, 0xb770eb3c, 0x6028e55e, 0x4a9de4f3, 0xa3576926, 0xf706f2b7, 0xcf29e228, 0xd8240003, 0x3610364e, 0x4fe00cba, 0xba1f5fe7, 0xa5961d12, 0x8674beca, 0x3a26e859, 0x94494143, 0x39f7e837, 0x220c7a43 },
            .M = { 0xdca3a77f, 0xcdcda5e3, 0x407f3381, 0x9757927f, 0xf6a64800, 0x5fe33787, 0x83f99db9, 0xf4c69c35, 0x8ee614b4, 0x9b96e785, 0x8fb34ef5, 0x658e280d, 0xf1760165, 0xc53e1604, 0x494e01e9, 0xc627b035, 0x1bff9a0d, 0x0edf480b, 0x57c282ab, 0xd0ca680f, 0x542b9585, 0xcc5bf0a7, 0xf13ff593, 0x85fec2b4, 0x60f1482b, 0xb12ea13d, 0x9cbd149e, 0xe875e38e, 0x8ea30358, 0xaa97a063, 0x3102c8f3, 0xf753588c, 0x1be2c4cb, 0xcdfb516a, 0xecf3dd8b, 0x708a5bd2, 0x35212d9a, 0x43df070b, 0x23be3715, 0x7a889d2c, 0xabb4d2be, 0x126e3c59, 0xfb567be1, 0xde3f166a, 0xce8bceaf, 0xe2c0f7a9, 0xa4391b62, 0xb3723d14, 0x5a7c92a9, 0xef657eab, 0x9273cdaa, 0x6732325a, 0x75f11102, 0xfeaf35a7, 0xc5f24c4f, 0x5fa6f47f, 0xe5d315c4, 0xd0c30ac3, 0x6e30af53, 0x15ea7c04, 0x27542c9b, 0xe7110d2c, 0x590c031f, 0xed2cdb44, 0x6d536171, 0x4c16a9d0, 0x1813559c, 0x24b3450a, 0x957986a1, 0xff99825c, 0x6526b028, 0xb9b491f4, 0x5ee436d9, 0xe80d77af, 0x7f8945c5, 0xfb5bee25, 0x25b3abe7, 0x75f00111, 0x4919459c, 0xa5327123, 0x256ba556, 0x3750cf5b, 0xa4e44680, 0x7aca8456, 0x291927f4, 0xa3466ccf, 0xb84f628f, 0xed8ad88e, 0x78571e21, 0x11f9acb7, 0x4c978277, 0x53e17f25, 0xadb4a29d, 0xf1b40b64, 0x48c1e571, 0xdeafdbc3, 0xa40adc05, 0x8ba20e94, 0xd3a9fde5, 0x7fffb5ed, 0xa862f0fa, 0xe7caae35, 0x96b7d643, 0x9afec32f, 0xaa7283eb, 0xb2f73b69, 0x43eae323, 0x69f434c3, 0x86e61f8a, 0xbb32a56c, 0x4e98ec4b, 0x85d732cf, 0x06590051, 0xeacec305, 0x8823abc8, 0x9bbff3d6, 0xc22e599e, 0x5f3c22b1, 0xceda7281, 0x50d15322, 0x92ae3c57, 0x5c1ba79b, 0xff4e9e1f, 0x07af3a72, 0xef5580b0, 0xf2e4aa45, 0x1992b1dd, 0x9618259a },
            .Rb = { 0xa47164d3, 0x4fdf39b2, 0x445addad, 0x3b3fda8f, 0x8c73bf30, 0x39e6f49e, 0xf3bb848e, 0xe5c79402, 0x706b3890, 0x9e3cd140, 0x7a9f7d0d, 0x665a57c3, 0xeb9007ea, 0x8795a8c2, 0xf84bd154, 0x24944be3, 0xfaeecb0f, 0x9fe751e1, 0xc499e776, 0xde3a97ea, 0x2e61fcfd, 0x8aacbbc4, 0x459f48bb, 0x32872314, 0xa15c87c4, 0xb3c0525d, 0xc5ef1e80, 0x9bb6df54, 0xbc88142d, 0x42cc5839, 0xca4fe5d3, 0x5ed6d62d, 0x1e0f5066, 0x58ca03c0, 0xfab5e8d0, 0x54a98110, 0x6fbf2e4e, 0x0bc7e283, 0x3371dc66, 0xdeaec013, 0xf2f5208c, 0x095132a2, 0x8bc0265f, 0x2fb7db58, 0x609b1be2, 0x3333ec32, 0x81f4fad8, 0x69a4b05e, 0x9e1597b3, 0x4d935d76, 0x2b720935, 0x3bab592d, 0xd3e3a3f9, 0x60fc1d54, 0x6cfeeecc, 0xdce41486, 0x2bfafbcc, 0xb45a7ae2, 0xe918deb5, 0x49c946a7, 0x7e0d37d8, 0x32dd99c8, 0x472fb7e7, 0xf9bd3ead, 0xc03a99fd, 0xa9c31ff1, 0x122e8b3c, 0xb100478a, 0x481ce63a, 0x6526e01c, 0x53fbe332, 0xe3790de0, 0xc92e0256, 0x708543cb, 0x8aa44c20, 0x6e711f42, 0xa9bf37e0, 0x7c105377, 0xe863ddaa, 0xf32a5554, 0x3802fd93, 0x4d250cae, 0x0ae87dce, 0x751ff5da, 0xa54477ff, 0x2849db0e, 0xbb22418f, 0xc592a08e, 0x2dd6b713, 0xa962d274, 0x377b13bf, 0x05c06654, 0x6026086e, 0xc3c9b624, 0x43fa8d82, 0xd151579e, 0xd3ee4f8c, 0x1fc5a258, 0x90e553ff, 0x199dc9c6, 0x2b42c79e, 0x2185e03d, 0xde110253, 0x33855034, 0x35436eff, 0x55d6dfc3, 0xe0282a02, 0xc6e05b46, 0xb177eb71, 0xaa38341a, 0xf003bc32, 0x04b608a2, 0x79a3ea5d, 0xb98630b6, 0x343e6d74, 0xdef6c43b, 0x80b4e113, 0xf8a782db, 0xcf2ff1d5, 0xe3eeb878, 0x6b4a2fd3, 0x98a3f733, 0xca08b9fb, 0x381f4679, 0x2622727d, 0xb98f3c80, 0xfe4af079, 0x2cc92f18 },
            .M_prime = 0x051be781,
            .length = ESP_DS_RSA_4096,
        },
        .expected_c = { 0x7b, 0xb7, 0x4d, 0x7b, 0x43, 0xc2, 0x2d, 0x7d, 0x3a, 0x38, 0xb1, 0xed, 0x6c, 0x7f, 0xcb, 0x50, 0x62, 0x27, 0xf3, 0x92, 0xf9, 0xef, 0xe3, 0x11, 0xc8, 0x55, 0x76, 0x40, 0x21, 0xfc, 0x7f, 0xf4, 0xfd, 0x3e, 0x26, 0xa5, 0xdd, 0xf4, 0xd2, 0x32, 0x10, 0x59, 0x92, 0x8f, 0x83, 0xad, 0x5b, 0x55, 0xd1, 0x9b, 0xe7, 0x00, 0x08, 0x61, 0x9d, 0xf4, 0x7c, 0xf0, 0x3e, 0xbf, 0x22, 0xd3, 0x9c, 0xf8, 0x0c, 0x50, 0x31, 0x18, 0x2c, 0x08, 0xbf, 0xe7, 0x88, 0xca, 0x29, 0x3c, 0x28, 0x74, 0x06, 0x2c, 0x4e, 0x77, 0x79, 0x64, 0x37, 0x7f, 0x96, 0xbc, 0xdc, 0x59, 0x44, 0x74, 0xce, 0xa8, 0x12, 0xe3, 0x15, 0x71, 0x49, 0x6d, 0xec, 0x8f, 0x84, 0x2d, 0xbd, 0x44, 0x4e, 0xcc, 0x9b, 0xc9, 0x85, 0xac, 0xcc, 0x85, 0xba, 0x63, 0x65, 0x17, 0xcd, 0xdb, 0xef, 0xb3, 0x08, 0xb5, 0x3f, 0x83, 0x0b, 0xfa, 0xe5, 0xa3, 0x5e, 0x00, 0xc3, 0x47, 0xd4, 0x0a, 0x93, 0xdb, 0x52, 0x44, 0x4e, 0x73, 0xee, 0x25, 0x0e, 0x7a, 0xfb, 0xcf, 0xb3, 0x47, 0x6d, 0xe6, 0x44, 0x19, 0xf6, 0xb9, 0x5a, 0x95, 0x61, 0x4b, 0x9b, 0xb8, 0x79, 0x29, 0x3b, 0x89, 0x42, 0xce, 0x61, 0xf0, 0x61, 0x37, 0xdd, 0x64, 0xf8, 0xdc, 0x44, 0xfa, 0x29, 0x3d, 0x0f, 0x94, 0x46, 0xbb, 0xa8, 0xa9, 0x98, 0xb1, 0xd6, 0xb6, 0xd3, 0xa6, 0x7f, 0x6d, 0xb4, 0x65, 0x85, 0x80, 0xf3, 0xc2, 0x5d, 0x29, 0x0f, 0x44, 0x1d, 0xf2, 0xfb, 0xfa, 0x86, 0x86, 0x2d, 0x19, 0xa2, 0x1b, 0x2e, 0x23, 0x7c, 0xb2, 0x29, 0x8e, 0xe0, 0x86, 0x94, 0x60, 0xbe, 0x91, 0xc3, 0x9d, 0x88, 0x26, 0xa5, 0x3c, 0xd7, 0xcd, 0x52, 0xd5, 0xe8, 0xb9, 0x85, 0xac, 0x5b, 0x34, 0x37, 0x10, 0xd4, 0x27, 0xd8, 0xa7, 0xf4, 0x8c, 0x05, 0x02, 0xe8, 0x5c, 0x7d, 0x46, 0x1b, 0x06, 0x45, 0xbd, 0x97, 0x0e, 0x35, 0x9e, 0x2d, 0xf9, 0x4d, 0xc8, 0x95, 0x54, 0x37, 0x56, 0x2a, 0x2b, 0x1d, 0xee, 0x33, 0xf8, 0x33, 0xc1, 0xd2, 0x12, 0xcf, 0xc1, 0x84, 0xbd, 0xbc, 0x6b, 0x66, 0x7d, 0x17, 0x23, 0xca, 0xb4, 0x26, 0x4a, 0x37, 0xf8, 0x60, 0x44, 0x52, 0x58, 0xe0, 0x49, 0xaa, 0xf8, 0xea, 0x12, 0x25, 0xcb, 0xf8, 0xb5, 0x4c, 0xf9, 0xe5, 0x8c, 0x3d, 0x65, 0xf4, 0x45, 0x1b, 0x15, 0x65, 0x47, 0xb9, 0xad, 0x08, 0xa8, 0x1b, 0xf8, 0x00, 0x82, 0x1f, 0x1c, 0x3b, 0x59, 0x04, 0x81, 0xab, 0xb0, 0xdd, 0xfc, 0x06, 0xd3, 0xc0, 0x5e, 0x2a, 0x20, 0x5b, 0xf2, 0xf1, 0x77, 0x97, 0x3a, 0xae, 0x92, 0x70, 0xae, 0x16, 0xe0, 0x3e, 0x2a, 0x69, 0xb3, 0x10, 0x7f, 0x8d, 0xc0, 0xb0, 0xef, 0x66, 0x35, 0x67, 0x2a, 0xa5, 0x16, 0xb0, 0x13, 0xf6, 0x6d, 0x68, 0x81, 0x26, 0x0f, 0xc9, 0xa6, 0xcd, 0x32, 0xbb, 0x75, 0x5a, 0x37, 0x49, 0xd7, 0x07, 0x07, 0x58, 0x71, 0xce, 0x39, 0x68, 0x06, 0xc2, 0x13, 0x6a, 0xd5, 0xa9, 0x02, 0xcd, 0x8f, 0x2e, 0x92, 0x70, 0x61, 0xcb, 0x39, 0x76, 0x16, 0x2c, 0x58, 0x41, 0x40, 0x8b, 0x86, 0x88, 0x50, 0x2b, 0xd3, 0xe2, 0xb9, 0xf6, 0xae, 0xb2, 0x57, 0x59, 0xc4, 0x70, 0x1f, 0x90, 0x00, 0xb9, 0x47, 0xc1, 0xcb, 0xf7, 0x7e, 0x90, 0xfe, 0x02, 0xec, 0x3a, 0x47, 0xd8, 0x6a, 0x0a, 0x6d, 0x10, 0x49, 0x07, 0xc4, 0x26, 0x61, 0xe8, 0x6f, 0x87, 0x17, 0x31, 0x43, 0xa8, 0xd4, 0xe2, 0x87, 0x82, 0x6a, 0x6a, 0xa6, 0xbe, 0xd3, 0x77, 0x2d, 0x1e, 0x8f, 0x94, 0xf8, 0x96, 0xd7, 0x9f, 0x66, 0xe1, 0x78, 0x0b, 0x1f, 0x15, 0xaf, 0x7b, 0x0b, 0x47, 0xca, 0xb8, 0xb0, 0xb6, 0xc5, 0xcd, 0x8d, 0x5a, 0x52, 0xa3, 0xce, 0x94, 0xe2, 0xc5, 0xfe, 0x8d, 0x29, 0x88, 0xc9, 0x55, 0x04, 0x07, 0x34, 0xa3, 0xb6, 0x0a, 0x45, 0xd9, 0xed, 0xe7, 0xaa, 0x07, 0x16, 0x5b, 0x2e, 0x45, 0x58, 0x60, 0x51, 0x20, 0xfd, 0xf7, 0x9a, 0xe1, 0xf6, 0xaa, 0xf0, 0x87, 0xd5, 0x37, 0xa6, 0xd9, 0x48, 0xed, 0xe1, 0x15, 0xb7, 0x96, 0x0a, 0x13, 0x9b, 0x33, 0xd0, 0x44, 0xd5, 0xd6, 0x10, 0x21, 0xbd, 0xbd, 0x38, 0xff, 0xb7, 0xb2, 0x4b, 0xe6, 0x69, 0x30, 0xd1, 0x98, 0x96, 0xce, 0x43, 0xa6, 0xe8, 0xbc, 0xe9, 0x80, 0xa3, 0xa6, 0xe0, 0x6b, 0xc4, 0xc4, 0xe0, 0xd2, 0xc5, 0xfb, 0xdd, 0x07, 0xb7, 0xb0, 0x9c, 0x64, 0xd0, 0xfb, 0x7d, 0x47, 0x2b, 0x98, 0x4b, 0xdc, 0x15, 0xe0, 0xfc, 0x56, 0x94, 0x9c, 0x04, 0xa1, 0x68, 0x68, 0x07, 0xca, 0x5c, 0x53, 0xfc, 0xd8, 0x9d, 0xf9, 0x5b, 0x90, 0x7c, 0xa8, 0x45, 0xa4, 0x06, 0xc8, 0x23, 0x58, 0x78, 0xae, 0xde, 0xb8, 0x0a, 0x26, 0x8a, 0x99, 0x0e, 0xa1, 0xc1, 0x0c, 0x7b, 0xd8, 0x19, 0x06, 0x8f, 0x22, 0xe2, 0xe0, 0x85, 0xff, 0xda, 0x27, 0x0e, 0x29, 0x6b, 0x86, 0xc7, 0x54, 0xc1, 0x7a, 0x35, 0xa3, 0xdf, 0x80, 0x73, 0x04, 0xe6, 0x1b, 0x0c, 0x9b, 0x0a, 0x79, 0xc1, 0xe9, 0x08, 0x4c, 0xd4, 0x21, 0x2f, 0x2e, 0x7f, 0xa9, 0x1f, 0x7f, 0xcf, 0x35, 0x12, 0x68, 0x82, 0xd5, 0x7e, 0xa0, 0x79, 0xfc, 0x18, 0xc7, 0x15, 0x6b, 0x59, 0x5a, 0x87, 0x80, 0xf3, 0x87, 0xb5, 0xc3, 0x9c, 0x65, 0xc5, 0x34, 0xf4, 0x23, 0xf2, 0x8e, 0x69, 0xea, 0x86, 0xd1, 0x31, 0x13, 0x8a, 0xa6, 0x3e, 0xb6, 0x09, 0xf3, 0xdc, 0x49, 0x79, 0x99, 0xd8, 0x56, 0x7c, 0x85, 0xe4, 0xe9, 0xbf, 0xd0, 0x4e, 0x85, 0x02, 0x06, 0x73, 0x8a, 0xc3, 0x21, 0xa1, 0xdb, 0xe3, 0xca, 0x4b, 0xe7, 0xaf, 0xeb, 0xc8, 0x92, 0x99, 0x22, 0xf4, 0x6a, 0x33, 0x4b, 0x12, 0xf3, 0xc2, 0xae, 0x03, 0xa2, 0x87, 0xc2, 0x2b, 0x81, 0xec, 0x47, 0xb9, 0x36, 0x95, 0x1f, 0xc5, 0x60, 0x87, 0x3f, 0x7e, 0x51, 0x26, 0x4a, 0xe0, 0x27, 0xfe, 0x20, 0x74, 0xee, 0x01, 0x41, 0x40, 0xf0, 0x55, 0xe8, 0x7f, 0x32, 0x93, 0x8a, 0x46, 0x39, 0x04, 0xdb, 0x2a, 0x58, 0x1a, 0x7b, 0xef, 0xa4, 0x02, 0xa4, 0x55, 0x24, 0x5f, 0xa5, 0xe3, 0xee, 0xc4, 0x0d, 0xd7, 0xc3, 0x76, 0x94, 0x77, 0xfd, 0xdf, 0xf7, 0x3a, 0x8f, 0xc1, 0x0e, 0xef, 0x16, 0x7b, 0x70, 0x7c, 0x6e, 0x09, 0x4b, 0x4b, 0x4e, 0x33, 0x49, 0x33, 0x0a, 0xc6, 0x49, 0xec, 0xc9, 0x5b, 0xb9, 0x77, 0x79, 0xd9, 0x24, 0xe5, 0x7d, 0x4b, 0x0b, 0x4e, 0x6d, 0xf0, 0x24, 0xe7, 0xcc, 0x76, 0x1d, 0x3f, 0xf6, 0xa6, 0x55, 0x75, 0x62, 0xd0, 0x2d, 0xad, 0x21, 0xa1, 0x87, 0x75, 0xfb, 0xd0, 0xbb, 0xb2, 0xb6, 0x63, 0x27, 0x47, 0x3d, 0x30, 0xdf, 0x45, 0x29, 0x3b, 0x8e, 0xaf, 0xd8, 0xfb, 0x22, 0x0d, 0x4a, 0x88, 0xf1, 0xe4, 0x9d, 0xaf, 0xa4, 0x33, 0xc6, 0x19, 0xd0, 0x12, 0x76, 0xa6, 0x99, 0xd5, 0x8a, 0x4f, 0x4d, 0xe5, 0xad, 0x31, 0x5c, 0xb3, 0xbc, 0x51, 0x9c, 0x56, 0xba, 0x19, 0x4a, 0x24, 0xb2, 0x42, 0xdd, 0xc9, 0xf5, 0x7d, 0xc9, 0x65, 0xc9, 0x04, 0xef, 0x40, 0x57, 0xae, 0xd3, 0x6a, 0x9d, 0xc4, 0x9c, 0x24, 0xcd, 0x9e, 0xe8, 0x1d, 0xfd, 0x8f, 0x8b, 0xc3, 0x92, 0x4b, 0x4d, 0x51, 0xc6, 0x66, 0x1b, 0x5c, 0xb9, 0x10, 0x1c, 0xa8, 0x9c, 0x53, 0x1f, 0xe4, 0x15, 0x4d, 0x81, 0xd6, 0xec, 0xd0, 0x1e, 0x0d, 0xa2, 0x54, 0xbd, 0xb5, 0x3a, 0x62, 0xd2, 0x9d, 0xa4, 0xde, 0x67, 0x75, 0xbe, 0xf1, 0x6e, 0x41, 0xd5, 0xe1, 0x81, 0x54, 0xd2, 0xe0, 0x43, 0xf1, 0xbe, 0x40, 0xa6, 0xb6, 0x25, 0x11, 0x7f, 0x81, 0x1c, 0x90, 0x7a, 0x69, 0x35, 0x8a, 0x35, 0x68, 0x85, 0xe2, 0x02, 0xd6, 0x5e, 0x0d, 0x48, 0x0d, 0x14, 0x79, 0x05, 0xe2, 0x91, 0xfd, 0x1d, 0x2a, 0xc7, 0xbd, 0x9e, 0x58, 0x4e, 0x5a, 0xd0, 0xac, 0x21, 0x5e, 0x55, 0x89, 0x76, 0xc2, 0x0f, 0x92, 0xf0, 0xdd, 0x3f, 0x4e, 0xe8, 0x48, 0xf8, 0xe4, 0x7d, 0xfa, 0x37, 0xc3, 0x0c, 0x7e, 0x82, 0xcd, 0x7c, 0x66, 0xf4, 0xea, 0x64, 0x42, 0x56, 0x49, 0x0b, 0x1c, 0x4a, 0xd8, 0x71, 0x5f, 0x08, 0x6e, 0x40, 0xa7, 0x52, 0x27, 0x6e, 0xf9, 0xa2, 0x2f, 0x21, 0xd8, 0x87, 0x70, 0x55, 0x3c, 0x8a, 0xe5, 0x1b, 0x8e, 0x07, 0x9e, 0x75, 0xc5, 0x31, 0xc3, 0xa0, 0x6d, 0x1f, 0xee, 0x51, 0x4e, 0x6b, 0xf5, 0xd4, 0x04, 0xc5, 0x86, 0x51, 0xed, 0x09, 0x51, 0xe7, 0xbe, 0xc6, 0xac, 0x2c, 0x9e, 0xa5, 0x56, 0x33, 0x19, 0xce, 0x6b, 0x08, 0x6a, 0xeb, 0x7b, 0xcd, 0xeb, 0x14, 0xbb, 0xa5, 0xb5, 0x9d, 0xc2, 0x62, 0xb2, 0x5d, 0xcc, 0x2c, 0xe7, 0x38, 0xef, 0x08, 0xd5, 0x5e, 0xff, 0x5e, 0x83, 0x24, 0xc7, 0xed, 0x7c, 0xe7, 0x0a, 0xfb, 0x95, 0x77, 0xeb, 0xe2, 0xec, 0x18, 0xf7, 0x2a, 0x04, 0x0f, 0xa9, 0x1b, 0x46, 0xbb, 0x1b, 0x0c, 0xf4, 0x86, 0xa6, 0xde, 0x50, 0x61, 0x8f, 0xbd, 0xbb, 0x76, 0x5b, 0xee, 0x13, 0x54, 0x25, 0xb5, 0x34, 0x60, 0x1d, 0x02, 0x12, 0x93, 0x7b, 0xd7, 0x4d, 0x65, 0x0e, 0x53, 0xe6, 0x2e, 0xf3, 0xe5, 0xc7, 0xf1, 0x20, 0xae, 0xf9, 0x99, 0xa3, 0xa9, 0xcc, 0xef, 0xc0, 0x05, 0x3e, 0x3d, 0xe9, 0x79, 0xef, 0x71, 0x10, 0x2d, 0x46, 0x60, 0xea, 0x06, 0x0d, 0xe3, 0xdf, 0x7f, 0x04, 0xff, 0x7a, 0x8e, 0x0e, 0x53, 0xd6, 0xea, 0x08, 0xd1, 0x68, 0xea, 0xb2, 0x92, 0xf4, 0x52, 0x08, 0xe9, 0x2c, 0xfe, 0xc1, 0x4d, 0x79, 0x5d, 0x93, 0x4a, 0xd3, 0x98, 0x8f, 0x61, 0x5f, 0x70, 0x76, 0x49, 0xb3, 0x30, 0xe5, 0x20, 0x60, 0x80, 0x7e, 0xd8, 0x72, 0xdf, 0xb7, 0x45, 0x57, 0xfa, 0x7c, 0x16, 0x1c, 0x00, 0x4c, 0x4a, 0xf6, 0xdc, 0xb9, 0x97, 0x84, 0x25, 0xf6, 0x20, 0xf5, 0xb3, 0xa4, 0xea, 0x54, 0xdf, 0x15, 0x14, 0xaa, 0x6c, 0xc2, 0xb9, 0xc2, 0xc6, 0xb7, 0x72, 0x23, 0x75, 0xc0, 0xae, 0x62, 0x5c, 0x3d, 0x3b, 0x9b, 0x36, 0xb7, 0x01, 0x0c, 0xb6, 0x0e, 0x5c, 0x07, 0xce, 0xa1, 0x95, 0xe2, 0xe4, 0x15, 0xc0, 0x4b, 0xa9, 0x2d, 0x29, 0xc8, 0xbe, 0xd0, 0x5b, 0xf1, 0x96, 0xc1, 0x80, 0xbb, 0x85, 0x88, 0xc3, 0x8b, 0xf6, 0xb4, 0x9c, 0xba, 0x7a, 0x73, 0xae, 0xb2, 0x9a, 0x57, 0x47, 0xd8, 0x1c, 0xee, 0x08, 0xa4, 0xcb, 0x22, 0x3b, 0xa4, 0xe9, 0x50, 0x8e, 0xea, 0xa4, 0xf6, 0xb0, 0x1a, 0xf9, 0xb8, 0x7c, 0xc0, 0xc2, 0x65, 0x21, 0xab, 0x00, 0x80, 0xa8, 0xfd, 0x90, 0x3b, 0x07, 0x8f, 0x23, 0xf8, 0x20, 0x11, 0x69, 0x5e, 0x91, 0xd9, 0x64, 0xcd, 0x82, 0x8f, 0x24, 0xfd, 0x51, 0x65, 0xce, 0x9b, 0x9d, 0x47, 0xa5, 0xa7, 0x04, 0xde, 0xa7, 0x95, 0x63, 0x6c, 0xe1, 0x7f, 0xa6, 0xd9, 0x30, 0x65, 0x1d, 0x8e, 0xf3, 0xd6, 0x68, 0x8e, 0x23, 0x0c, 0x31, 0x84, 0xc9, 0xd1, 0xdb, 0xc1, 0x6a, 0xa3, 0xb0, 0x65, 0xab, 0x6f, 0xb1, 0xe1, 0x5c, 0xe3, 0x60, 0x85, 0x8b, 0x6f, 0x56, 0x73, 0xcc, 0x6e, 0x89, 0x3f, 0x63, 0x5c, 0x99, 0x3e, 0x88, 0xb8, 0x97, 0x8d, 0xb7, 0x9a, 0x8a, 0xa8, 0x01, 0x1f, 0x60, 0x0f, 0xc2, 0x25, 0x8e, 0xf3, 0x91, 0xe8, 0x82, 0xd8, 0x6a, 0x0a, 0xa0, 0xbf, 0xf7, 0xab, 0xb2, 0xe0, 0x0b, 0xf9, 0x95, 0x42, 0xdc, 0xb1, 0x8c, 0xe5, 0xd1, 0x49, 0x3e, 0xfd, 0x4c, 0x1c, 0x69, 0x66, 0xf3, 0x0b, 0xc8, 0x84, 0xfd, 0x6a, 0x26, 0x6d, 0x0b, 0xbe, 0x5d, 0x2d, 0x1a, 0x70, 0x37, 0xc5, 0x86, 0x18, 0x45, 0x5a, 0xfb, 0xfb, 0x08, 0x83, 0x4c, 0xaa, 0x49, 0x29, 0x78, 0x28, 0xed, 0xe0, 0x30, 0x57, 0xba, 0x31, 0x86, 0x70, 0x08, 0xcf, 0x05, 0xf0, 0x39, 0x3b },
        .hmac_key_idx = 1,
        // results of message array encrypted with these keys
        .expected_results = {
        // Message 0
      { 0xad64e3d6, 0x8b106777, 0x815e3363, 0xec1cefa9, 0x4ed43b0a, 0xf02cd4eb, 0x23ba7c6c, 0x68a72a02, 0x70d7129b, 0xb6b8c825, 0x088da9ad, 0xb1c44e09, 0xd875293b, 0x7ac3e899, 0x99142b90, 0x5ae8416b, 0x5d38ef1b, 0xa5766699, 0x2fbc94b3, 0x6f692511, 0x93bd2315, 0xda8f2d1f, 0x7c886eea, 0x4973163c, 0xd5fa63a8, 0x367b18b6, 0xa53afc2f, 0x7424959b, 0xa015e985, 0xf3024e6d, 0xf11a1e38, 0x6f536a6f, 0x214a2483, 0x29b81f12, 0xd7b6e75f, 0x3e9410e6, 0xf8d15e08, 0x227291b2, 0xb98583b3, 0xc6d1b445, 0x1d4faa53, 0x41cbc575, 0xd4d0d10d, 0x9a374fe4, 0xf6bc31c8, 0x25fe23d6, 0x91cb54b3, 0x5cb159cf, 0x311d6de2, 0x7f15cd24, 0x442819b8, 0xd1aa67b8, 0x359ca992, 0xea8795f1, 0xcf3af375, 0xa6311692, 0x930d0231, 0x19f68d06, 0x617773fd, 0xc641275a, 0x48202f7c, 0x0e83aa9c, 0x8d0ef1ec, 0x05abed82, 0x4771dad1, 0x1ad118d7, 0x19122c74, 0x6e8c0b9a, 0x2133e3e8, 0xe8fe7ec7, 0xa3425d45, 0x9aae3f84, 0x24623ea8, 0x5080bdab, 0x77d92a76, 0xe6a41898, 0x255b8166, 0x231a72b0, 0x81ee7450, 0x26b729d9, 0x10c63f61, 0x15bad212, 0xd2e4af5b, 0x061648e2, 0x45ed5625, 0x037fca25, 0xfd284c87, 0x4045cffe, 0xebe4ff32, 0xe1887f1e, 0x32c59b83, 0xa3a19d3b, 0xce29e3f4, 0x14d99f93, 0x9ca206dd, 0x3d7de7e4, 0x7bba0e65, 0x37f3de1c, 0xe2dc9a30, 0x8d6e75e3, 0x4e4dccf1, 0x959cb2c8, 0xf534afc0, 0x0ce3e664, 0x21dc5add, 0xeaf7a16a, 0x008321b6, 0xa3332cf5, 0x60035c3d, 0x75d2d317, 0xcface7eb, 0x4ffd1a4e, 0x4fa10fc1, 0x3c3dec0d, 0xc29f7cf9, 0x3afbb27e, 0x2f1fc919, 0x7e7220c6, 0x52b9b93a, 0xd5013182, 0x387f7db7, 0xe6b5ccbe, 0x16b4babc, 0x5a353aec, 0x367df3d6, 0x3894bba9, 0x8ac34e43, 0x5bb40d4c },        // Message 1
      { 0x03bb6664, 0xd72d72ff, 0xc73b452f, 0x659beaa7, 0xb9ff8af6, 0x3ca58dc6, 0x4733dc45, 0xa78a36a4, 0x94faa7db, 0x31a61532, 0x7f4393b8, 0x7499c1b3, 0x11f6f8cb, 0x2dc3e458, 0xf8dfe30e, 0x5c36572e, 0x0529c307, 0x7fdd6893, 0x01361b87, 0x017348b1, 0x0843594d, 0xb34cfba4, 0x4551dbe9, 0xb2e1e305, 0xd4915ac8, 0x44f9854c, 0xc55c6637, 0x731e6b9a, 0xeefac45b, 0x1c42460e, 0x180e1a9a, 0x9b4b7d04, 0x1aa0424c, 0xad48e832, 0x10ae1725, 0x177b022d, 0xa9c668bb, 0x4708a591, 0x54dfe898, 0x6a36f928, 0xe67bb5a1, 0x233a96b3, 0x5f254e0e, 0x3efd590a, 0x57289eb5, 0xa70fd250, 0xb618e961, 0x1de81f5a, 0xe2e65863, 0xeea9574e, 0x12656801, 0xdd70df2f, 0x3f3fa79b, 0xd4d8269e, 0xc31e158f, 0x67d5529f, 0x71cc3480, 0x2458ff25, 0xa3e5ca44, 0xdd9d3210, 0x974d9425, 0xc0309ff6, 0xe348baac, 0x2851c22b, 0x0cb0ab48, 0x30cc4d02, 0x825e41d6, 0x99f15d27, 0x2428f53e, 0xa5e4329a, 0x0119dc42, 0xf04d84e8, 0xb0b8674c, 0xdd9c6c12, 0x2853cfb2, 0xd40bc7b6, 0x198ea476, 0xd4199290, 0xc845bdc9, 0x8196ec8c, 0x917f59f9, 0x176c8a1b, 0x1747cdee, 0x8acd04c9, 0xc9736fc6, 0x6f348b87, 0xb3c22132, 0x638dcb70, 0x4fb6607b, 0x656332db, 0x505a38c5, 0xb5b9cc48, 0xe2931770, 0x174ab298, 0x534e9fd1, 0x393eb9a9, 0x146621c0, 0x3a5a4691, 0x21502f8c, 0x1e563b33, 0x0f732aaf, 0x72e6e50b, 0x7eab2449, 0x821e7ad5, 0x66110b61, 0x25929031, 0x6859b184, 0x6903c8f0, 0x90525dbf, 0xfb6db7d2, 0x8a1607a5, 0x8728c692, 0xa8edfc84, 0x9e32f9da, 0xd164c10c, 0x19afc693, 0x1ac28157, 0x30bee134, 0x3305fa33, 0x66846555, 0xf3e42bdc, 0xc16b909b, 0x13f646fb, 0xc04b34b4, 0x87f8f9fa, 0x1f87e6db, 0xf56930b8, 0x0df0da27 },        // Message 2
      { 0x851945a0, 0x57bee3c5, 0x00f610e7, 0x5142422b, 0x414f674d, 0x1cb62d46, 0xe0d71b8b, 0x8a352519, 0xe92cc7c8, 0x0e42e858, 0x9ffd8642, 0xd96bd921, 0xde9fbcb5, 0x17007fd7, 0x19fccb67, 0xf8ec067c, 0x82f1ea7e, 0x7d2702ee, 0xf0ecbd43, 0x203eafd0, 0x6e0e1faf, 0xe97f18e3, 0xc79fd2a3, 0xc24ffd65, 0x5dba1663, 0x509e7bca, 0x71912187, 0x02896255, 0x7121e116, 0x9fe3e53d, 0x2ee76be5, 0xa134ea83, 0x81cfe061, 0x473b1862, 0x3f137c25, 0x67c5728b, 0x2b01a2a1, 0xa3486b6e, 0x764c09e1, 0x40526a38, 0x1e59acec, 0xba106839, 0xafd220af, 0xec67d474, 0xb84fcffd, 0xd2d38046, 0xfeb11832, 0xf5ec6839, 0xfc8c25e7, 0x305e4e47, 0x8f085983, 0x7fbe13be, 0x1031d4bc, 0xeaedc98b, 0xb7d236ce, 0x7765c9fb, 0xa6efa07c, 0x78e1bc1c, 0xaf6eea96, 0x3b9eda8b, 0x42469533, 0xa8901fba, 0xe07f3b86, 0x4d4d0d5c, 0xcd3c3e3d, 0xa4164dbd, 0x31673184, 0x010462ac, 0x9e7c7221, 0x8ee7ad2b, 0xb13182a5, 0x1e3060a6, 0x59a1cf54, 0x8d41ed6b, 0x2a21e211, 0x94afe6ce, 0xb7aec52b, 0x2d952b39, 0xd16442ce, 0xb9704365, 0x4a84816a, 0x190d4010, 0xf6510028, 0x0665e103, 0x031f2120, 0xd97f7cd5, 0xced48483, 0xa98c3abd, 0xe2ae844f, 0xeee3612e, 0x0b0b90cc, 0x70f20bff, 0x71c1f2b0, 0x13970385, 0xb800f1c0, 0x36a3a834, 0x2821c2f8, 0x48f24fa7, 0x30b03fe7, 0x3cb79767, 0x0b6f2d4a, 0x96a853f4, 0xe1d1a1b8, 0x539e47b8, 0x2c9d7b1a, 0x37187f2b, 0x52a0a8ea, 0x08b8ad2f, 0x6195dc11, 0x55770954, 0x83324986, 0x0a272d2d, 0xece566c8, 0x9c3ae592, 0x92a773e9, 0x855ff9a8, 0x9f975a18, 0xdbf7d47c, 0x674c61b4, 0x1228c414, 0xfdacfc44, 0xed3ee11f, 0xcbc756f7, 0xa4209e7a, 0x09c47d44, 0x97fff5f0, 0xccdbf0c4, 0x58f5d207 },        // Message 3
      { 0x09af4cde, 0xc26f4456, 0xe1b0ab65, 0x2994f33c, 0x26d4d070, 0x4e659e12, 0x17ab2c0c, 0xdc10f9ea, 0x0106aad3, 0x0c5f2bb7, 0x768eb160, 0x4ab5c1dc, 0x22e775a5, 0xaecdf45d, 0x0d2e0d7a, 0x50a5e495, 0x6c0e72f8, 0xa8b3e6f5, 0x54658a8b, 0x0fccbf87, 0x7d2dfee6, 0x78e25027, 0xd285ec2b, 0x374716d7, 0x7eeeaaf4, 0x16fb3295, 0x5421b46e, 0xd773a7f9, 0x3e8b93a5, 0x4a94dde1, 0xc8c30301, 0xcb489733, 0x4726608f, 0xd7a017b3, 0x58be8875, 0x9a96b730, 0x354980f3, 0x7697dd25, 0xed39dc5b, 0xb5e3a1f9, 0x0fd1ba0b, 0x6e9f27bd, 0x5adb6eb3, 0x9032da6d, 0xb908907a, 0xaf382d49, 0x62a393e6, 0xf3f30c66, 0x6267ff17, 0xd88baf5c, 0xa327933c, 0xb35be722, 0xf9416ddd, 0xefc811b5, 0x6e7a190a, 0xc7747e70, 0xd89fbf03, 0x93bd4a16, 0x24525c35, 0xe31b94c1, 0xdb256e3a, 0x8d835e70, 0xb9a7992d, 0x3f0337cd, 0xf5459fcd, 0xbdb1c83e, 0x4920c6ee, 0xe26c3d3b, 0x429542a8, 0x212e2a79, 0x02a1c122, 0xdd4eadc3, 0x24f27aa9, 0x57bf026e, 0xdaf11362, 0x29a1d4d2, 0xbc8d763e, 0xc394eae2, 0xf16986c6, 0xc565d9bb, 0x59de87d6, 0xa7253b70, 0x7509579f, 0xc2bd4624, 0x4fcefa75, 0xfb88417c, 0xdc7a7103, 0xc55ffb57, 0x2d35b6d8, 0x11cac9a0, 0x5c579fe4, 0x63412c13, 0x77c26603, 0xc9ba6f72, 0x8bb54cd3, 0x88db1613, 0x46196fe1, 0x82642468, 0x38165f43, 0x72922ba0, 0x4b138f32, 0x2a7ce049, 0x3cae656a, 0xb8e35305, 0xbbda25af, 0xf028c51f, 0xb762164a, 0xa21c43e5, 0x2a422a41, 0xc4be7b46, 0xd44ddbe2, 0x14360236, 0xb792087b, 0x62ffc404, 0x6ae04b93, 0xc17ef784, 0xac2355c8, 0x3a88195f, 0xf50246a9, 0x71a97dd4, 0x9de2abf4, 0x0405202d, 0xd1967c1e, 0xb514ee8f, 0xf47b69a4, 0xcf9f0b82, 0x7773fb89, 0x66c476e5 },        // Message 4
      { 0xe7149f41, 0x40b5f07a, 0xbce36f5b, 0x6767e1cb, 0x72553730, 0xbc687e86, 0x51078cfc, 0x26741a2e, 0x190f60ac, 0xa4fef2ea, 0xe632b47e, 0x8b634f1f, 0xd0023afc, 0x2e9082ca, 0xb93ee600, 0xad474049, 0xdcb7d324, 0x0f8cca6c, 0x83cc06bb, 0x9e90bc9e, 0xd258fd11, 0xbede7759, 0x64745d08, 0x48bdcdb3, 0x5245776d, 0xe8ea723f, 0x1167afe5, 0x8269ee9a, 0x75261854, 0x296b3296, 0xe4cba6bf, 0x7917bc9a, 0x0912fe69, 0x33440de7, 0xba7b519a, 0xeb10c55d, 0x1d3bf720, 0xe9ae38fd, 0xb2ea8bf5, 0x8e54a5df, 0xedab914d, 0x7388a5c9, 0x72931be3, 0xe38e4032, 0xdf0c38d3, 0xb6edd360, 0x785ee479, 0x19762513, 0x0925e20d, 0x62a40fd2, 0x6a4d1817, 0xa4022e08, 0xf385fe8b, 0x85f14b29, 0x3e3b5fab, 0xe5d2a57a, 0x03e2d3ea, 0xebade4e1, 0x22b18edd, 0x14d0af10, 0x8f277d4b, 0xd3b0c348, 0x40e250ef, 0x6bd3ae57, 0xc9a953cf, 0x0ca81b88, 0x998433f1, 0x1ff222f7, 0xe5da372f, 0x10b33445, 0x3215b538, 0xd232f921, 0xb4a8c572, 0xb96a270c, 0x53ebc591, 0x049e2041, 0x624515c3, 0x752d9300, 0xc92ee2d9, 0x1b3c4d65, 0x5544be70, 0x2e84dbbc, 0x9ad7b773, 0xfd6c78c3, 0x2756b8ea, 0xd9654dbf, 0xefdb8fea, 0xff8f3e4a, 0xb442c6ba, 0x7d3f466e, 0xdd078068, 0x5de44056, 0xedc53bc9, 0xcdef4bc9, 0x7d31ba22, 0xfe4d564f, 0x19cc2509, 0x0dd37f63, 0xdab84311, 0xec9c8744, 0x7dec1cf8, 0xe652a844, 0xad25411e, 0x1b38054d, 0xffa463d8, 0xfa4507d1, 0xa594d044, 0x54d34d1d, 0x8ae3cf61, 0x4b282414, 0x0dbd2f42, 0x459d83c2, 0x06599486, 0xca3e27c9, 0xa48afc65, 0x4562d5e0, 0x5171f204, 0xe36b5acd, 0x715a94e7, 0xa325ca4a, 0xeab2271b, 0xcb2d6fa6, 0xa7da9f80, 0x79302f25, 0xb968465a, 0x41b0db83, 0x7100859e, 0x46bb22fb },        // Message 5
      { 0x41f975ad, 0x8e51a975, 0xc4df30f5, 0xb416e7a8, 0x281307fe, 0x6903ce0d, 0x3d2e6ef6, 0x6ee68423, 0xc6f26a27, 0x465cb819, 0xd195e837, 0x4f6177bc, 0x0b129032, 0x7412026d, 0x8ae2d921, 0x0e7eb13c, 0x1f6eff3b, 0xee8ae652, 0x9e71287c, 0xcb9fff14, 0x51c766d1, 0x459c8c4d, 0x13edc37c, 0x36cb9db0, 0xfcf023ce, 0x1539fc47, 0x825b3c8e, 0xd0f76cd9, 0x8ab48e58, 0x498b3462, 0x5b14c3e3, 0x73a41a67, 0x38e476d3, 0xeb841ca3, 0x76d1e957, 0xe51e4913, 0x14068b64, 0xdc5b50a6, 0xac1c42f5, 0x18ba7b11, 0x58f954b7, 0x410e57f7, 0xcd9a43c3, 0xad99e03d, 0xf342c3cf, 0x989290b7, 0x0bc26b10, 0x0735eab4, 0x2478de48, 0xe8e5b3a2, 0xe2aa820d, 0x6d2b740c, 0x60adf458, 0x61523510, 0x1612a7a1, 0xfbedeaa7, 0x0c286a6b, 0xa71b4a6e, 0x94e5b8e9, 0xd71d50ca, 0x417f4ee0, 0x074c97fc, 0x442ffcee, 0xc5f5a3a6, 0x002403d2, 0x417cd590, 0x198b7d87, 0x9b98f90d, 0x494cdb34, 0xb849ab9e, 0x095bd675, 0xc21ce2fd, 0xe26e497c, 0xce454ad9, 0x8fe58dbc, 0xb3f9c1b0, 0x79241582, 0xd821897b, 0x050f83d3, 0x4a073764, 0xf1481d9a, 0x6ed05dd2, 0x5ceb3fdb, 0x26dcc616, 0x768794bc, 0x4c70c2ff, 0xe65e65a2, 0x5fde4399, 0x38420ae8, 0x2e048bee, 0x47417cd8, 0xa741e004, 0x27fcd34f, 0x3ab3bb70, 0x70da80ea, 0x5e4ce0e1, 0x4bb796fa, 0x41c71f95, 0x0c625e66, 0x9858e034, 0x8f9d00a8, 0x1666d9ac, 0x2094ee86, 0xc044441f, 0x5764af42, 0x5cae4996, 0x847f0c41, 0x531a8606, 0x9cf0577f, 0x2cad8f97, 0x1c003b80, 0x17633e91, 0x5d7c8c80, 0xdf3e4f6f, 0x7ecf1deb, 0xe7a7d5ba, 0xf8f31348, 0x47ab8f1b, 0x0d7e3a8c, 0x579fdeba, 0x38c9e08a, 0xdc2e3af6, 0xcaf0354f, 0xbde9a7a4, 0xee54bc89, 0xb6d23e21, 0xe2c5f3b4, 0x05f1dd01 },        // Message 6
      { 0x34c80729, 0xdaa4db37, 0x3a7beaf2, 0x0925160a, 0x32bc7a52, 0x819a0c47, 0x21beb52e, 0xffd3eb45, 0x637e6fd7, 0xc1c1d9ce, 0xe0e7c2bf, 0xacc5e8dc, 0x5a18fdb6, 0xe65db1b9, 0xe384a368, 0xbe30d248, 0x22d76b17, 0x029a29dc, 0xb67618d1, 0x501c2b94, 0x9292d13d, 0x096c90be, 0x8b454c73, 0xd38e6b4b, 0x7ff3260f, 0xae27576d, 0xc7b85dd3, 0x7a786d11, 0x3cf32837, 0xeebc0f39, 0xa3100e00, 0x2aa32983, 0x3ea9c4d1, 0xa3324b25, 0xc04c1e41, 0x1edd84e5, 0xcddffb5e, 0x7ac0f434, 0x87d02b5f, 0x768cfffa, 0x44590558, 0xd32b1cee, 0x2b162b81, 0x10f86db3, 0x52828dfa, 0x4524bfbd, 0x5ca4d2c0, 0x9af3cbb8, 0xcd820aef, 0x0515b3b7, 0xc4eb76e3, 0x38c07dcc, 0x3b57a1a2, 0x7a30d742, 0x59b8aed0, 0xa83c88bb, 0xbc35b55f, 0xb35ae3a3, 0x3dba8ac7, 0xf7397f3d, 0x14d01795, 0x4ef06f97, 0x44493d9d, 0xeeea16be, 0x144b9c01, 0x65c135ac, 0x45abd3dd, 0x4d8ef054, 0xb7ccc496, 0x6559af3f, 0x898cf9b6, 0x146a3a65, 0xa28ed492, 0xa95378e5, 0x27fb7383, 0x81ff8f7b, 0xba158d41, 0x86f43be6, 0xa7b14200, 0x3e470b2f, 0xe04b3cc1, 0x16ecc38e, 0x9fdd426c, 0x8fa54ab4, 0xd6fc2b18, 0xc94ffdee, 0x035eefec, 0x071b88c8, 0xc8154bc4, 0x78379ce4, 0x9c32007b, 0xa7dde211, 0x34040b92, 0xeeea1f6f, 0x02501670, 0xc4652036, 0xafc843da, 0x24b05af0, 0x62416dfc, 0x2cea719f, 0x1bede5f1, 0x10221bef, 0xd70e4387, 0x19bfe571, 0x829b3f8e, 0xaae72a47, 0x845612cc, 0x2b295b59, 0x71c09258, 0xa2adbb07, 0xe965deaa, 0xfda62743, 0x4490dc5c, 0x3b46b717, 0x1addda37, 0x758acad0, 0x929add94, 0x90836dc9, 0x4052dba2, 0x5c2539d8, 0xff32bd98, 0x0d9f433d, 0x9376cb7f, 0x9bbdc366, 0x30e63fdb, 0x81cb0050, 0xad2f4da9, 0x07785798 },        // Message 7
      { 0x50b3be45, 0x9363ee78, 0x73d56544, 0x92928479, 0x0d66c842, 0x3bbc10e8, 0x94b09e0c, 0x9e60ccd8, 0x1b3d8699, 0x7ff3df78, 0x27fffc15, 0xe3e27987, 0xaebb435f, 0x2d17576c, 0x75463cbc, 0xab0753bd, 0x1fe7ba2a, 0x4b519762, 0x714fefaf, 0x5ec086d4, 0x1c4fe3e9, 0x28ba3c31, 0x66e0feda, 0x07391879, 0x0f493200, 0xd74cea56, 0x7217b609, 0xd8e2bd65, 0xf5728d53, 0x784c268e, 0xa961d123, 0xcaf42b34, 0x2f1de396, 0x0e348de2, 0x2778a5d9, 0x250d02e8, 0xd6785746, 0x61b59b02, 0xaef4999e, 0x1617d5f6, 0xdd6ca6e4, 0xc12b3db6, 0x602f9fae, 0x981edd7b, 0xdb3fad68, 0x2a8e2df6, 0xc4daa5db, 0x492d742e, 0xac86e728, 0x5fad9bc7, 0x71429128, 0x7223712b, 0x3b4be87b, 0xe684d586, 0x52bedc41, 0xefb9cd1c, 0x732b48ed, 0x982b453b, 0x802eda0a, 0xdf7c4202, 0x0a578644, 0x153af92c, 0xc837d0d2, 0x3ed555bc, 0x4c3cb3c3, 0xe546381a, 0xf9e1958e, 0xeff5e885, 0xeec25d85, 0x009b0648, 0xd12f9889, 0xc87d09e8, 0xdc7b63f5, 0xcb45f135, 0x3e3dba60, 0x4602b6c1, 0xc8d9f879, 0xfb4a1ee5, 0xf9e75072, 0xf0bedc77, 0x44811ab8, 0x382acb9e, 0xe56d2adf, 0x0aec5b29, 0xaeb85dd6, 0x48434b35, 0x6ac6c801, 0x153b7f7a, 0xdcbbf4b4, 0x7dd46f66, 0xd5db2e89, 0xfba068dc, 0x0787efb4, 0x7d514b16, 0x540ee55d, 0x46011c33, 0x2a88123a, 0xd495b726, 0x45bbac36, 0x06e43956, 0x5b23845c, 0xedd2f89d, 0xcd347e32, 0x242f45a2, 0xfbfa9d48, 0x77941d39, 0x2080e053, 0x0deef865, 0x231341f4, 0x7b5fdc79, 0xd23a0052, 0xca8ca33d, 0x45d96d9e, 0x7f1a0331, 0x4d2f6822, 0x11bf0a5a, 0x8f20abbb, 0x5b686709, 0xa91615dd, 0x51dda0dc, 0x7a409ccd, 0x77a2311c, 0x29eabd53, 0x076b6152, 0x48d33d1d, 0x63276e2d, 0x46a514d5, 0x02aaede6 },        // Message 8
      { 0x38a374cb, 0xc9d1918e, 0x07a3890e, 0x1672c1b4, 0x32f57318, 0xe2116f2b, 0xdc5c9db6, 0x18819158, 0x94f51b30, 0xc279f040, 0x1048098b, 0xa5cf4505, 0x9bac5422, 0xa669e464, 0xd63e9b9c, 0xf7c95db4, 0xd385073b, 0x4e8356df, 0x7abd508e, 0xdc210394, 0xa32b853e, 0xd47109c8, 0xaffd1935, 0x4218852c, 0x98aa103d, 0x6fa94978, 0x298048b1, 0xda3be091, 0xe28df1c5, 0x90a9d060, 0xb9bc4716, 0xf47c01cd, 0x80636b54, 0xca6cce73, 0x70621a8f, 0x0ed33fde, 0xcb4a622b, 0xd4ea45bb, 0x3c74a291, 0xbf5db1f5, 0x63994bb5, 0x716dfc06, 0x03a77469, 0x1e6b0c71, 0x856e7372, 0xc8d81835, 0x548cab79, 0xbd9b9acd, 0xb8a792bb, 0x0b081f4b, 0xd4790863, 0x19ea7f7a, 0xc84cbc6b, 0x09ea5533, 0x223a4295, 0xd43c5571, 0x63ad9c8b, 0xb8c126b8, 0xc730949e, 0x31d9dec2, 0xa73e8bf7, 0x5cefa74e, 0x4fb3e21f, 0xfe917a6f, 0x6f0748eb, 0x8daf50a2, 0xb228db77, 0x102f2c13, 0x3a8539d9, 0x322004da, 0xaf3aefea, 0x3812850a, 0xac687d9a, 0xe5be0c08, 0xb707c041, 0x0b36e11b, 0xfafa5ff8, 0xcfae2ade, 0xd430beea, 0xa374935f, 0x1eb5788e, 0xf09cadc8, 0x7b3563a8, 0x5866ad1e, 0x0f7d08f3, 0x912c5891, 0x0b76dbf9, 0x66b2936c, 0x4d0e08c5, 0xf76501c8, 0x5b3ac54e, 0xa76606cc, 0x684406f3, 0x18d0db37, 0x03437daf, 0x12818caf, 0xec52c4a7, 0xf9acca52, 0x93018967, 0x70ebc22b, 0xc6e8b754, 0x73c3d5eb, 0x41d17e2d, 0xc8227331, 0x299994dd, 0x0a3a592a, 0x3da6db67, 0x2f1d81ec, 0x1e5dcfb3, 0x3290e095, 0xc36deb5a, 0x1b61bd9f, 0xf45a65e1, 0x339b2224, 0xce21949b, 0x732bca27, 0x2e07bc4f, 0x1cb7d857, 0x65e5e34e, 0xade743d5, 0xfa895f89, 0xe96af33a, 0xace2570b, 0x293bdb52, 0xcd734d90, 0x1cbee7bb, 0x47658667, 0x304d71f9 },        // Message 9
      { 0x2a591f32, 0x83fd0ef3, 0x0fb7395d, 0x6de635a1, 0x5d2a05bd, 0xe081ff4f, 0x258a9637, 0xbcf5ee22, 0x0b329f70, 0x5ebd1355, 0xefd82511, 0x422718c3, 0x04512c18, 0xdaccbc4b, 0xd61318a5, 0x295e8f91, 0xc2cefdcf, 0xead21134, 0xa6c29123, 0x607ee310, 0xfb372732, 0x655ffae6, 0xcefed0d6, 0xa5934c2f, 0x29b02b8e, 0xb27d3116, 0x00327dfa, 0x85883d84, 0x4e31266e, 0x9567584a, 0xf2d08be6, 0xd2598e24, 0xc55c0209, 0xa60dc8f2, 0x15548ac5, 0x885df9cb, 0xfd1e5cc2, 0x9ff644bd, 0x19a302e4, 0xbc56db96, 0xad994297, 0xf6931fc3, 0x70ccebe7, 0x0c51c09c, 0x4cb621f1, 0x0955a711, 0xb3ff8d3a, 0xefcb3db2, 0xf62b813d, 0x075fb90f, 0x33714880, 0x2779d581, 0x1e1cb5f0, 0xe703c513, 0x9fd2a978, 0xc9b525e6, 0x07ba1c29, 0x7dd710c4, 0x7e3a2728, 0x33126e49, 0xce56f200, 0xea183c53, 0x29f065b7, 0xfae9643c, 0xdb7d5168, 0x9baa2b88, 0x55838160, 0xf491972f, 0x936e377c, 0xc2d2ffa4, 0xbed9064e, 0x444921f0, 0xf579b0d4, 0x766a9338, 0x5b9b8c6e, 0x1a2fca94, 0x488bcc87, 0x37d6bbbb, 0xdeb9ee64, 0x382aa8d9, 0x7d34e85b, 0x327d864d, 0xb9d29d0e, 0x0f6054cd, 0x8abedac7, 0xbf2de15b, 0x5610f8f2, 0x0af8ac9a, 0xc70f7570, 0x41774a82, 0x9799bbdc, 0xfba56fc8, 0xdbb2075a, 0xc93c56c5, 0xde6c5aff, 0x30cf4350, 0x21459f2d, 0x150750ea, 0x602ba0ba, 0xc6846e5e, 0xf573725f, 0x179040ca, 0x162c4681, 0xe08ff852, 0x02719dbe, 0x0e8c2bd0, 0x8c6eb3a1, 0xa9358242, 0xfe3bd96f, 0xb9e71377, 0xb7882e58, 0xa0e8a16a, 0x08ca1773, 0xc51e0eb5, 0x8b0ec0d5, 0x2099a2fe, 0x4a63a4d7, 0x0f9b8f58, 0x73129193, 0xf0e030c2, 0xe2a4d19e, 0xe2a47a21, 0xadf39d2a, 0x87182d17, 0x4263c002, 0x931fe79b, 0x38212401, 0x3b30d654 },     },
     },
    { /* Case 1 */
        .iv = { 0x1d, 0xf5, 0x52, 0xf8, 0x56, 0x78, 0x02, 0x7e, 0x88, 0xfc, 0x56, 0x22, 0xbe, 0xb8, 0x41, 0xc2 },
        .p_data = {
            .Y = { 0xbde9e449, 0x708e19ad, 0xb406d7de, 0xe8d1186f, 0x4d038a64, 0x1468220a, 0xfcf880f7, 0xe8309e85, 0x714cf4e0, 0x649a9a79, 0x7132faab, 0xe3b5b943, 0x55858d4e, 0xbf070b09, 0x5bda3d2f, 0xf0287d87, 0xfa0a9145, 0xdbe0506a, 0x8c75bab7, 0xbef0ea5e, 0x7c928bbb, 0xe60c8039, 0xc40c4d1f, 0xf65f6bdc, 0x110653da, 0x6d47b5ee, 0xf8faa240, 0x676c1486, 0x9c68f51f, 0xab1bb10f, 0xb110262e, 0xe53870de, 0x9a9c4d13, 0x4f4d2da5, 0xa83728c4, 0x61e8586f, 0x04256855, 0x422034f4, 0x30d5e846, 0x7a7133a9, 0x7e890396, 0xc7b5b804, 0x7b6cb639, 0xfe309a19, 0x3aee3230, 0xa07dffad, 0x857d8de6, 0x7809389e, 0x5a408141, 0xf2f71360, 0x28ab404d, 0x9b27aeb2, 0x21dbe14c, 0x53ab8bc0, 0x6cdcf57c, 0x239a2173, 0x18bae813, 0xa5318108, 0x2cacb988, 0xa9728987, 0xc620dddc, 0x469ea9f9, 0x316e33ec, 0x19dad501, 0x5e76f369, 0xf9b05aaf, 0xf78ac3a9, 0x0c003bb7, 0x0cf3cf21, 0x6b222e66, 0x0686b3eb, 0x1885187c, 0x6935c613, 0x221bc502, 0xc9cdf08b, 0x11602f5c, 0xaa731078, 0x7ea3e1f6, 0x273cf9e6, 0xe075984f, 0xaf7e2f41, 0x7a034649, 0x1826a91e, 0xd44c8c68, 0xbc977f32, 0x4957bb1e, 0x95f0e4e0, 0xf50cda77, 0x0038541b, 0x9cb88c36, 0x7345250b, 0x7866e4fe, 0xc2429e97, 0x02cb43ac, 0x31b48b02, 0xbbd8e6c0 },
            .M = { 0x331751fb, 0x4fd0f751, 0xaaaa5404, 0x44f41e06, 0x284d8cbe, 0x624aed65, 0x00c1fb3b, 0x48d58a17, 0x47a046d6, 0x8a1df8ed, 0x9c19e1db, 0x02fa90cc, 0x2500481f, 0x06686788, 0x788c6a44, 0x1a633dc3, 0xc1ebd07e, 0x66e01f32, 0x7e412f88, 0x7e6a963e, 0x2b7e3472, 0xf782ce84, 0x051bd99b, 0x593d044e, 0xc7935e58, 0x7d9ac196, 0x5d67e4b4, 0x4d9635ab, 0xe8fa792a, 0x0d930cfb, 0x3a53c81f, 0xa4fbcd1f, 0x8d6c6f59, 0xc52ca818, 0xf5943d4d, 0x04a07c18, 0xc3183cfb, 0x8a6d3641, 0xba146684, 0x13468419, 0x08b5b53b, 0x5265b47c, 0x7abb842c, 0x7e7c2203, 0x9a03a02d, 0x0a256e40, 0x11dc937c, 0xf2083a6f, 0x65d4a3e6, 0xc697c435, 0x08cef472, 0xdab20871, 0x34bf0ebf, 0xf27042f3, 0x9dedf1ab, 0x16f242f7, 0x95e97e6f, 0xd6ba1a88, 0x173616cc, 0xf473e974, 0x99030b29, 0xb850f10a, 0x50cd8d6f, 0xc5271e3a, 0x4989aeff, 0xbe2fff80, 0xddadc969, 0xb62ac9a0, 0x3a8c6f55, 0x7ba7a80f, 0x0b38f828, 0x8726fe8b, 0xd7571dc9, 0x634b3098, 0xf43716e4, 0xc4254608, 0xdf5ce418, 0xdda0df34, 0xba85591d, 0xf5e5e74e, 0xe0519bd6, 0x8860703d, 0x55ec56f3, 0x79b9bcab, 0xcc46d7c4, 0xa423b9e0, 0xcb34fd65, 0x2362b00d, 0xdd5a4b23, 0xa25a9edb, 0x5703fa67, 0x51ee6ffc, 0x250de399, 0x21314ce4, 0x74b95771, 0xd5ad12b9 },
            .Rb = { 0x6c2aef92, 0xac3b56bb, 0x4ff8673c, 0x3d038222, 0x06843cb5, 0x493cccf1, 0xf201e2c5, 0xdb31dff0, 0xb123b7b1, 0x8ad34f84, 0xc44c4d62, 0x55aff931, 0x20ccc59e, 0x1c752c50, 0x0459dacf, 0x83921d53, 0x84b32a0b, 0x9654c9fa, 0xf87340b3, 0x53ff3b9d, 0x5a6331c0, 0xe47440ea, 0x36298e20, 0xd29f569c, 0xb88db861, 0x48b94ae6, 0x676d0fee, 0x8c5a8a74, 0x5e5d7f92, 0x0936c3f0, 0x9ebd3ad2, 0xe729eceb, 0x704bcc3e, 0xa54eccb5, 0xa45541cf, 0x175398a9, 0x059abd8a, 0x69e1085d, 0x23e9f94e, 0xd7abd6ad, 0x340195e3, 0xd660a6e6, 0x4f504d23, 0x01267c9a, 0x76114752, 0x3a3f0b92, 0x848f38ab, 0x3be4c99c, 0x2a6ea606, 0x41397980, 0x45a870ea, 0x686ffc67, 0xc8b78a20, 0x0a8a495e, 0x425fa79d, 0x03c00dd0, 0x2d425a82, 0x54345a74, 0xab0d9819, 0x73be4336, 0x4f574a08, 0xc4588aba, 0xa030beac, 0x29ac1965, 0x1a547c04, 0xb2abe6ab, 0x6e7d8e8e, 0xa2c92981, 0x4c9e65b7, 0xaeda5573, 0x5160515e, 0xcfd0428f, 0xfa038aa7, 0x8b562bac, 0x76253e1f, 0x506ce1e3, 0x1183c6bd, 0x74f55dd2, 0xf98c2bda, 0xb2d6f840, 0x6225eba6, 0xd537b20e, 0xc50e86d9, 0x133f9f93, 0x2f7eee45, 0x1a2eecd1, 0xf15a5d1b, 0xe70c7bdd, 0x27195562, 0x1750cd1c, 0xf28c798b, 0xc8330b61, 0x3124f279, 0x704cb0c1, 0x968696d5, 0x38010f0e },
            .M_prime = 0x9994eecd,
            .length = ESP_DS_RSA_3072,
        },
        .expected_c = { 0x3b, 0xeb, 0x49, 0x13, 0x94, 0xa0, 0x58, 0xf9, 0x54, 0x5e, 0xd2, 0xf1, 0xd4, 0x35, 0x15, 0x57, 0x53, 0x70, 0x33, 0x73, 0x5f, 0xdc, 0x69, 0x00, 0x40, 0xcd, 0x91, 0x4d, 0xee, 0xd5, 0x11, 0xb4, 0x31, 0x56, 0x73, 0x92, 0x1b, 0x70, 0xe9, 0x07, 0xf2, 0x3c, 0xc4, 0x5e, 0xd2, 0x68, 0x65, 0x60, 0x6d, 0xc3, 0x59, 0x76, 0x67, 0x79, 0x10, 0xe5, 0x0d, 0xa9, 0x2d, 0xa9, 0xaa, 0x44, 0xe1, 0x2f, 0xd0, 0xfd, 0x5b, 0x33, 0x9d, 0x79, 0xd4, 0x8d, 0x31, 0xe3, 0x39, 0xa6, 0xa5, 0xca, 0x47, 0xe3, 0x9b, 0x57, 0x79, 0x4e, 0xfa, 0x1a, 0xe3, 0x18, 0xcc, 0x3e, 0xa7, 0x11, 0x71, 0x77, 0x33, 0x40, 0xf8, 0x25, 0xa0, 0x55, 0xa2, 0x5d, 0x21, 0x8e, 0xab, 0x6c, 0x11, 0xbf, 0xe5, 0xef, 0x7f, 0x10, 0x0a, 0x4a, 0xa0, 0xce, 0xb7, 0x44, 0x8b, 0x28, 0xe9, 0xbe, 0xa6, 0x1b, 0x55, 0xe3, 0xac, 0x78, 0x46, 0x05, 0x21, 0x91, 0x72, 0xc2, 0xac, 0xb1, 0x03, 0x86, 0x21, 0xfd, 0xcf, 0xfd, 0xb9, 0xdf, 0x8f, 0x76, 0x93, 0x4f, 0x6b, 0x0f, 0x64, 0x06, 0x66, 0x7f, 0x37, 0x9b, 0xc7, 0x69, 0x2c, 0x36, 0x17, 0x42, 0x4c, 0x61, 0x74, 0x0d, 0xb7, 0xd9, 0x2c, 0xc3, 0xe9, 0x4d, 0xc5, 0x52, 0x24, 0x3c, 0xa1, 0x18, 0xa5, 0x29, 0x00, 0xdb, 0x3a, 0x44, 0x29, 0x08, 0x1d, 0xf7, 0xc4, 0x3d, 0xf2, 0x73, 0xac, 0x4b, 0xb8, 0x73, 0x61, 0xaa, 0x3e, 0x75, 0x65, 0x5c, 0x49, 0x89, 0xc6, 0x0d, 0xdf, 0x49, 0xcb, 0xd1, 0x0a, 0x28, 0x9f, 0xe6, 0x98, 0xda, 0x16, 0xfc, 0xbd, 0x05, 0x52, 0x29, 0xdf, 0x76, 0x63, 0xde, 0xea, 0x1a, 0x46, 0x14, 0x39, 0x81, 0xc9, 0x6b, 0x8b, 0xe5, 0xd8, 0x74, 0x8a, 0x9e, 0xfe, 0x94, 0x77, 0xc7, 0x55, 0x8b, 0xe7, 0x69, 0xc0, 0x0e, 0x5d, 0xc2, 0xea, 0xc9, 0x28, 0x17, 0xe6, 0xb1, 0x62, 0xd0, 0xf5, 0x2d, 0x61, 0x81, 0x65, 0x1b, 0x62, 0x52, 0xe8, 0xda, 0x2d, 0x6e, 0xde, 0x52, 0x45, 0x01, 0xc5, 0x29, 0x59, 0x28, 0x0f, 0x1b, 0x1a, 0x2b, 0x32, 0x45, 0x3b, 0x7d, 0x7c, 0x40, 0xd2, 0xf0, 0x5c, 0x24, 0x30, 0xb3, 0x68, 0xe5, 0xaf, 0x15, 0x16, 0x5d, 0x1f, 0x21, 0xee, 0xe9, 0x70, 0xeb, 0xc3, 0x78, 0xeb, 0x4a, 0xd6, 0x59, 0xcc, 0xa0, 0x72, 0xa6, 0x32, 0x4d, 0x0d, 0x2e, 0x63, 0xba, 0x46, 0x2e, 0x9f, 0xba, 0xc7, 0xc4, 0xcf, 0x6b, 0x12, 0xe6, 0xcf, 0x71, 0xbc, 0xa8, 0x8b, 0x42, 0x1a, 0x22, 0x2a, 0xd0, 0x50, 0xbe, 0x9d, 0x17, 0x6d, 0x91, 0xb2, 0xd6, 0xed, 0x26, 0xa5, 0xb1, 0x2d, 0xec, 0xe6, 0x5b, 0x30, 0x0e, 0x17, 0xa5, 0x4c, 0xeb, 0x06, 0x2e, 0x35, 0x74, 0x24, 0x28, 0x52, 0xa5, 0x2e, 0xa6, 0x3e, 0x73, 0x73, 0x61, 0xcf, 0x5c, 0xfd, 0x8c, 0x84, 0xee, 0x82, 0x5c, 0x72, 0xb4, 0x5a, 0xf4, 0x03, 0x35, 0xe8, 0x40, 0x9c, 0x77, 0x46, 0xdd, 0x4a, 0xff, 0x2f, 0xb5, 0x8d, 0xaa, 0xeb, 0x7c, 0x79, 0xa1, 0x25, 0xc0, 0xc1, 0xc2, 0x40, 0xb9, 0x46, 0xd8, 0x5d, 0x30, 0xfa, 0x13, 0x93, 0x52, 0xc8, 0x19, 0x01, 0x99, 0x81, 0x83, 0x9e, 0x53, 0xf6, 0xf0, 0xdf, 0x2e, 0xae, 0x11, 0x09, 0x00, 0xf5, 0xe8, 0xdd, 0x2e, 0x2a, 0x73, 0x85, 0xe3, 0x60, 0x3e, 0xcd, 0x77, 0xf3, 0x26, 0x39, 0xce, 0x22, 0x17, 0x10, 0xda, 0xd2, 0xd1, 0x57, 0x9b, 0xff, 0x9e, 0xe7, 0x65, 0xf6, 0x85, 0x97, 0x3e, 0x8c, 0x74, 0x05, 0x22, 0x4b, 0xf4, 0xca, 0x4d, 0xde, 0xfc, 0xea, 0x7a, 0x34, 0x0e, 0x99, 0xa4, 0x98, 0xfe, 0xf5, 0x23, 0x32, 0x25, 0x80, 0x6d, 0xb2, 0x67, 0xc7, 0x97, 0x2b, 0x2e, 0x82, 0xf3, 0x46, 0x00, 0x19, 0xc7, 0xff, 0x26, 0x5b, 0x3d, 0xf5, 0xf6, 0xcc, 0x4e, 0x00, 0xc0, 0xc6, 0x25, 0x63, 0x3f, 0xd6, 0x9e, 0x9c, 0xc5, 0xf9, 0x29, 0xe1, 0xd0, 0x10, 0xb0, 0x9f, 0x62, 0x43, 0x3f, 0x2a, 0x8c, 0xc3, 0xf5, 0xa3, 0xde, 0x95, 0xf8, 0x8d, 0xaa, 0x31, 0x21, 0xdd, 0x75, 0x9e, 0x83, 0x95, 0x4d, 0xcf, 0xde, 0xc8, 0xc8, 0x97, 0x88, 0x47, 0x46, 0x29, 0x43, 0x6d, 0x11, 0xcf, 0xf5, 0x39, 0x8a, 0x84, 0x27, 0x74, 0xe8, 0x22, 0xa6, 0x3c, 0xe6, 0xaa, 0x36, 0x01, 0x6d, 0xac, 0x14, 0x24, 0xdc, 0x46, 0xdd, 0xc0, 0x48, 0x04, 0x33, 0x87, 0xf6, 0x40, 0x6a, 0xa0, 0x5c, 0xf1, 0xeb, 0xe1, 0xc1, 0x73, 0xc7, 0x4c, 0x5f, 0xc0, 0xc9, 0xcf, 0x3d, 0x3b, 0xa0, 0xc1, 0xf5, 0xbb, 0x6b, 0x54, 0x88, 0x16, 0xeb, 0xa6, 0xfb, 0x8a, 0xf7, 0x70, 0xbf, 0xf7, 0x2d, 0xbf, 0x74, 0x17, 0x3a, 0x2d, 0x00, 0x5b, 0xb2, 0x1f, 0x61, 0x6c, 0x43, 0x14, 0x97, 0x08, 0x7c, 0x00, 0x2a, 0xd3, 0xd9, 0x6d, 0x09, 0x7c, 0x4a, 0x19, 0x0a, 0x95, 0x64, 0x79, 0x7e, 0xfb, 0xab, 0xea, 0x88, 0xe1, 0x1f, 0x78, 0xdf, 0x50, 0x1b, 0x69, 0x23, 0x9b, 0xd4, 0xba, 0xff, 0x28, 0xdd, 0x2a, 0x4d, 0xe4, 0x68, 0xac, 0xb3, 0xb0, 0x34, 0x47, 0x22, 0xdf, 0x61, 0x79, 0x1c, 0xc5, 0xca, 0x22, 0x55, 0x8e, 0x96, 0x9a, 0xca, 0xc6, 0xc4, 0xc1, 0x40, 0x47, 0x88, 0x15, 0xc7, 0xa2, 0xc4, 0xfb, 0x21, 0x2c, 0x75, 0xd0, 0x17, 0xb5, 0xfc, 0x0f, 0x2b, 0xa6, 0xd8, 0x64, 0x55, 0x1f, 0x2d, 0xcf, 0xed, 0x59, 0xde, 0xf3, 0x52, 0x63, 0x2d, 0x52, 0x78, 0x40, 0x88, 0x12, 0x0e, 0xc5, 0x03, 0xe4, 0x3c, 0xca, 0x21, 0x68, 0xb3, 0x9e, 0x39, 0x5f, 0xe7, 0xc5, 0x5c, 0x6e, 0x6f, 0xb5, 0x26, 0x34, 0xc8, 0x49, 0xbb, 0xd1, 0x5c, 0x5a, 0x2e, 0xe1, 0xed, 0x72, 0x1f, 0x7e, 0xb4, 0xe8, 0x61, 0x67, 0xa7, 0xef, 0x7b, 0x64, 0x62, 0x46, 0xbe, 0x74, 0x6c, 0xd6, 0x09, 0xad, 0x71, 0x6a, 0x06, 0xc2, 0x9b, 0x95, 0x74, 0x59, 0x67, 0x54, 0xa9, 0x75, 0xfb, 0xf9, 0xd2, 0x87, 0xc0, 0x4f, 0xbc, 0xde, 0xc2, 0x2b, 0x66, 0x50, 0x95, 0xba, 0xbb, 0x89, 0x79, 0x9e, 0x85, 0x2b, 0xd3, 0x9f, 0xf5, 0x5e, 0xb5, 0x03, 0xfe, 0xdc, 0xe0, 0x01, 0xe6, 0xa6, 0xc5, 0x41, 0xa2, 0x85, 0x13, 0x7e, 0xff, 0x5d, 0x01, 0x74, 0xde, 0xd2, 0x56, 0xf8, 0x60, 0x6d, 0x64, 0x14, 0xcb, 0x09, 0x3b, 0xfc, 0xde, 0xc3, 0x29, 0xfd, 0xa0, 0xf0, 0x5f, 0x3e, 0xe8, 0xfd, 0x07, 0x5d, 0x63, 0xa1, 0x48, 0x76, 0xd8, 0x27, 0x32, 0xdb, 0x34, 0x72, 0x86, 0x00, 0xb8, 0xbc, 0x53, 0xbd, 0xe8, 0x3f, 0xfc, 0x49, 0x1e, 0x4b, 0x73, 0x2d, 0xe3, 0xc7, 0x78, 0x03, 0x27, 0x82, 0x0d, 0x5c, 0x0d, 0x09, 0x5e, 0xbe, 0x30, 0xc9, 0x5e, 0xe2, 0x67, 0x22, 0x4a, 0x76, 0x7e, 0x1c, 0xd5, 0x3d, 0x17, 0x22, 0x19, 0x80, 0xe3, 0x17, 0x78, 0x56, 0xe3, 0x3c, 0x31, 0xd3, 0x00, 0xf0, 0xda, 0xad, 0xdc, 0xd8, 0x56, 0x3d, 0xc7, 0x3e, 0xf7, 0x95, 0xdf, 0x70, 0xbc, 0x92, 0xba, 0x54, 0x3f, 0xe8, 0x4f, 0xf3, 0x1b, 0x07, 0x6a, 0xb8, 0x2c, 0x39, 0x8b, 0x71, 0xde, 0xe9, 0x09, 0x79, 0x16, 0x07, 0xa6, 0x74, 0xcb, 0x1d, 0x44, 0xc3, 0x90, 0xe7, 0xd6, 0x5e, 0x2a, 0xb8, 0xe9, 0xa7, 0xb7, 0x7b, 0xef, 0x2e, 0x64, 0xea, 0x0a, 0xd2, 0x7e, 0xb6, 0x37, 0xb4, 0x3d, 0x60, 0x01, 0x92, 0x7d, 0xad, 0x9a, 0x57, 0x78, 0x3f, 0x2f, 0xaf, 0x76, 0x23, 0xe5, 0x1a, 0xa0, 0xb4, 0x39, 0xb0, 0x1c, 0x88, 0x72, 0x59, 0x99, 0x5a, 0x53, 0x77, 0x40, 0x1a, 0xc1, 0xb2, 0x66, 0x5e, 0x3f, 0x87, 0xf7, 0x7a, 0x9d, 0x99, 0x09, 0x0d, 0x42, 0xdf, 0x52, 0xf8, 0x7a, 0xf7, 0xa5, 0xa6, 0x8d, 0xee, 0xbc, 0x5a, 0x61, 0xb2, 0x58, 0x5b, 0xbf, 0x38, 0xcb, 0x61, 0xcf, 0x0f, 0xcc, 0xca, 0x00, 0x93, 0x19, 0x0c, 0x67, 0xea, 0xcb, 0xa8, 0x6b, 0x02, 0x86, 0x96, 0x8d, 0x22, 0x0d, 0x08, 0x8b, 0xc2, 0xf3, 0x2a, 0xc2, 0x60, 0xe3, 0xba, 0x34, 0xc4, 0x1a, 0xed, 0x60, 0x9c, 0xa8, 0x10, 0xa5, 0x79, 0x3a, 0x3f, 0x4f, 0x82, 0x66, 0xeb, 0x16, 0x83, 0x5e, 0xf6, 0x5d, 0x62, 0xe3, 0x3d, 0x99, 0x1a, 0xa2, 0x68, 0x4f, 0x6e, 0xa7, 0xe9, 0xfe, 0xbe, 0xdd, 0xba, 0x4e, 0x6f, 0xdd, 0xad, 0x3a, 0x57, 0x3e, 0x1f, 0xbf, 0x94, 0xac, 0xf5, 0x53, 0x98, 0xf9, 0xe3, 0x03, 0x5f, 0x34, 0xab, 0x4f, 0x6f, 0x63, 0xd5, 0x36, 0xd7, 0x3a, 0x5d, 0x0f, 0xeb, 0x8b, 0x84, 0xc4, 0x79, 0x34, 0x4d, 0x1a, 0x93, 0x26, 0xbc, 0x25, 0xfb, 0x29, 0xe8, 0x66, 0x8f, 0x3c, 0xec, 0xd3, 0xf8, 0x3d, 0xb2, 0xbd, 0x66, 0x55, 0x5a, 0x3a, 0x01, 0x13, 0x82, 0xd6, 0xc3, 0xb6, 0xde, 0x52, 0x10, 0x22, 0x2e, 0xc9, 0xa5, 0x31, 0x29, 0xa7, 0xec, 0x23, 0x7b, 0x36, 0x18, 0xbb, 0x9f, 0x96, 0x40, 0x07, 0xc2, 0xfb, 0xf0, 0xcb, 0x53, 0xe4, 0xf9, 0xea, 0x45, 0x23, 0x46, 0x83, 0xce, 0x08, 0x70, 0xf2, 0x3d, 0x16, 0x4e, 0x26, 0xb3, 0x04, 0x8b, 0x55, 0x8b, 0x02, 0xc5, 0x6f, 0x9b, 0x75, 0xed, 0x73, 0x36, 0x6e, 0xad, 0x12, 0xf1, 0xe5, 0xdd, 0x5a, 0xf2, 0xa9, 0x4f, 0xd1, 0xc3, 0xbe, 0xc7, 0x07, 0x93, 0xcc, 0x34, 0xcd, 0xfc, 0x59, 0xda, 0x54, 0x80, 0x3b, 0x35, 0xcb, 0x8e, 0xb0, 0x60, 0x45, 0xc2, 0xb8, 0x65, 0x8c, 0x22, 0xa5, 0x1d, 0x48, 0xc8, 0xb5, 0x06, 0x5e, 0xfe, 0xd9, 0x21, 0x69, 0x18, 0xa4, 0x17, 0xa4, 0x5f, 0x81, 0xfc, 0xae, 0x44, 0xae, 0xd8, 0x10, 0xc9, 0xd7, 0x34, 0x57, 0x1b, 0x11, 0x6b, 0x83, 0x20, 0xbb, 0x13, 0x12, 0x41, 0x21, 0x4e, 0xc4, 0xeb, 0xbc, 0x6b, 0xbe, 0xdb, 0x8b, 0x01, 0xcb, 0x10, 0x47, 0x39, 0x40, 0x6f, 0x13, 0x6f, 0x3b, 0xab, 0xfd, 0x15, 0x95, 0x05, 0xff, 0x6e, 0x95, 0xf9, 0xbd, 0xec, 0x0f, 0x03, 0xc4, 0xa4, 0xe1, 0x97, 0x4e, 0x44, 0x49, 0x26, 0xc5, 0x42, 0x01, 0x5d, 0xd6, 0x94, 0xea, 0x54, 0x69, 0xf9, 0x44, 0x9a, 0x96, 0x3d, 0x16, 0x29, 0x58, 0x63, 0x56, 0xda, 0x17, 0x3a, 0xd4, 0x51, 0x27, 0x6f, 0x29, 0xc1, 0x9d, 0x2b, 0x2d, 0xa2, 0x01, 0x6e, 0x4c, 0x00, 0x43, 0x6d, 0x11, 0xb1, 0xfa, 0x7e, 0x55, 0xc9, 0x99, 0x34, 0x18, 0x60, 0xca, 0x7e, 0x62, 0xf1, 0xa6, 0x89, 0xfc, 0xe3, 0xbc, 0x84, 0x30, 0x07, 0x16, 0xd1, 0x5c, 0x27, 0x22, 0x2d, 0xf5, 0xb9, 0xfd, 0xe2, 0x64, 0x78, 0x01, 0xe2, 0x09, 0x1f, 0x8d, 0xad, 0x7b, 0x6c, 0x21, 0xd0, 0x92, 0x74, 0xe7, 0x1c, 0x5f, 0xc5, 0x7f, 0xf3, 0xf3, 0xad, 0x68, 0x9c, 0x7b, 0x36, 0xb6, 0xbb, 0xac, 0xd4, 0x1c, 0x45, 0xc0, 0x05, 0x3e, 0xb1, 0x8b, 0x45, 0xcf, 0xa5, 0x59, 0xe8, 0xe3, 0x42, 0x85, 0x42, 0x08, 0x7a, 0xdc, 0xa5, 0x7a, 0x90, 0x5d, 0xcf, 0x01, 0x09, 0xc0, 0xb9, 0x12, 0x17, 0x72, 0x14, 0x38, 0xe9, 0x92, 0x1f, 0x84, 0x52, 0x62, 0xb6, 0x2a, 0x8e, 0x42, 0x26, 0xef, 0x98, 0xf4, 0xf3, 0xe8, 0x98, 0xee, 0x99, 0xd6, 0x85, 0xe2, 0x8d, 0x84, 0xc6, 0x93, 0xc0, 0x14, 0x2b, 0x49, 0x5b, 0x1a, 0x41, 0xf9, 0x88, 0x61, 0xcd, 0xe5, 0x34, 0x25, 0xce, 0x2a, 0x86, 0x19, 0x9f, 0xab, 0xaa, 0xcf, 0x4c, 0x9a, 0x34, 0xe0, 0xee, 0xc5, 0x43, 0x28, 0x69, 0x26, 0xac, 0x7f, 0xe7, 0x22, 0xb9, 0x08, 0x40, 0x46, 0x0a, 0x22, 0x0f, 0x43, 0x67, 0xf5, 0xf6, 0x38, 0x42, 0xa2, 0x8b, 0x97, 0x6a, 0x45, 0x08, 0x47, 0xc2, 0x50, 0x8a, 0x0d, 0xb6, 0x56, 0x03, 0xa6, 0x97, 0xf8, 0x53, 0x66, 0x89, 0x3f, 0x9f, 0xeb, 0x8f, 0x51, 0xaa, 0x5b, 0x13, 0xac, 0x08, 0x0e, 0x47, 0xb4, 0xec, 0x72, 0x09, 0x96 },
        .hmac_key_idx = 2,
        // results of message array encrypted with these keys
        .expected_results = {
        // Message 0
      { 0x787f547d, 0xe59e52ff, 0x5006ba1c, 0x13ef4473, 0x3b4ee0f9, 0x331c5997, 0x0f09706f, 0x884210a2, 0xc30fce47, 0xd667bce5, 0xde3c6f1a, 0xfbb3960e, 0x584b00a0, 0x4f4dd56f, 0xad280100, 0x1b2c6f02, 0xd18c80d4, 0x66c417da, 0xab0790db, 0x9250d451, 0x13817143, 0x571db9d4, 0x2b06f3df, 0x666fd28c, 0xd02285de, 0xb5015910, 0x67ef2028, 0x0465804c, 0x2ae5c007, 0xaec36b3f, 0x841ff678, 0xbdb7c0a0, 0xa20b1279, 0xde0ed681, 0x9cc3829e, 0x9f74525e, 0x3d7ba280, 0xc9e84630, 0x6134fa52, 0x63082edb, 0x4d65157a, 0x536cf512, 0x3e2851d4, 0x27e2f77a, 0x18678aca, 0x6030c4d7, 0x7a9938bc, 0xe5a4509a, 0x06168e34, 0x5162ff67, 0x9d162f33, 0x96afcd0b, 0x616009cd, 0x4bfc3ebb, 0xf61f37cf, 0x83e0a935, 0xddd3b7aa, 0x0b7d3b46, 0x9c4bca19, 0xf1f2ad26, 0xa75597fd, 0x0857361f, 0xb4e3acfb, 0x1814f2eb, 0x863d6e2c, 0x4ac6e022, 0x72a8a56f, 0xbd61cf0e, 0xee83d563, 0xce0070cd, 0x3815c054, 0xd4a37762, 0x9e3cbf8f, 0xfc7a8ce8, 0xd66aa52c, 0x6158f112, 0xfbd0622d, 0x67840043, 0xb29937d3, 0xabdd0266, 0x3c3c225d, 0xdf25e017, 0xea918e9e, 0x719b2f87, 0xef57ac30, 0x218ab982, 0x7f0aed0a, 0xa18a68dc, 0xd3bebf19, 0x0d175417, 0x437b8c44, 0x824e3023, 0xadd20741, 0xf6284557, 0x5fb21bb5, 0x3ec4c458 },        // Message 1
      { 0xbbef9546, 0xb5540547, 0x4f3e175e, 0x6525b1c6, 0xc02bcc6c, 0xc91c5451, 0xd63f9cdd, 0x9a978b3b, 0xcb56729b, 0x5dc8d89e, 0x16dcbbbe, 0x42b64b71, 0x5e565227, 0xf0a62f49, 0xc12a43c1, 0x738c7f61, 0x091c9228, 0x45b88f6b, 0x13ddffc4, 0x45839dc6, 0xe8312820, 0xf7855fe8, 0xe830f6b9, 0x03ad57b6, 0xb55e236d, 0x54fb3f0c, 0x607b1f74, 0xf6b96b3d, 0xa71a30be, 0x0efbbeb4, 0xc99dc4b3, 0xc3b0c292, 0xbd6de8d0, 0x1388ec14, 0x46fc8d3d, 0xa83d06fb, 0xc0e021a0, 0x29f195dd, 0xe08c5eec, 0x910bcd6f, 0x72095fa3, 0x65f354dd, 0xece64481, 0xa52b5c78, 0x2ee31f3d, 0x14ca0b65, 0x133bbd61, 0x9a25eb42, 0x3b889dc4, 0x247acc0b, 0x6f0e76b9, 0x52810139, 0x8a2741cc, 0xe553bc99, 0xa6617b4b, 0xdeec33ad, 0xe20c88bc, 0x18f0a4a8, 0x9581b191, 0xa35efbb2, 0x3c3557f0, 0x76511291, 0x933ce7e7, 0xb35b0419, 0xac71c89c, 0x12023124, 0x7dc08883, 0x41a1b738, 0xf9ec998f, 0x150a5b71, 0x380874a1, 0x678331a1, 0xc6c0ef4e, 0x8de81037, 0xf8eb0382, 0xca1d6dc7, 0xebc85104, 0xbe945d0d, 0x09156284, 0xc028832e, 0xcfdd2aaa, 0x0d1e0c0b, 0x6b63e43c, 0x11da5614, 0x70a0cd33, 0xda727ac6, 0x6188b6bc, 0x3de1e4ce, 0x4cd671b9, 0xaaf92692, 0x8dd031c9, 0xd439914e, 0x8251e16e, 0x35679035, 0x50e1a9db, 0x590446b3 },        // Message 2
      { 0x81e4c5ea, 0xa4be7d7f, 0xd341bf14, 0xb9595f3e, 0xd4bf029f, 0x5901b75d, 0x695e3227, 0xb2328678, 0x140da363, 0x5d0486d7, 0xaaa5e020, 0x4e2bf40c, 0x19627253, 0x904c6c6a, 0xf4cb65a3, 0x50c44cba, 0x6e223cc7, 0x77e7e619, 0xd6789aef, 0xc382fb7d, 0x188d76eb, 0x4040b56b, 0xad32df5c, 0x415fefce, 0x9419adf9, 0x800f4e45, 0x64001386, 0xeb4a6f9c, 0xed2f6814, 0x1664284d, 0x36eef091, 0xb43b2094, 0x8649dc39, 0x4d48609b, 0x06dc0d62, 0x7eedb3e2, 0xd3f923e0, 0x290e27b9, 0xa9e2e6f0, 0x2922cdaa, 0x9dd35288, 0xe99f3b74, 0x395ee286, 0xa80ef306, 0x13b067f6, 0x56d0ec18, 0x599c0d0c, 0x65de9309, 0x286cf31a, 0x3380d3b2, 0x09a7fa3a, 0x35252939, 0x166fddad, 0xee4980b7, 0x688dcaed, 0x0b307d47, 0xb69bea6f, 0xe4046e71, 0x2e6c7b32, 0x7bcaa43d, 0x3e3d7ffb, 0x230cc561, 0x1ac716a0, 0xda52299c, 0xdfbc4e97, 0xbcdc9ce9, 0x5f5e759c, 0x60e3d9c7, 0x013de9b0, 0x87fa068b, 0xb5a498d3, 0xa8d8417b, 0x719ea5b0, 0x918d9ec4, 0xffadd5fa, 0x1d2301e3, 0xd453acf5, 0xa7f42d41, 0x6cd7cdb9, 0x247db1b1, 0x3ee6485e, 0xf937fcc8, 0x843b5e71, 0x852474d7, 0x9daf5c6d, 0xa35e64eb, 0x8ad506c3, 0x6e42fe4b, 0x2c7fd7f9, 0xad375dee, 0xd4409d51, 0x65ad6ae5, 0xf8a7da6e, 0xe9782ca0, 0xc37fcf6c, 0xd34a737e },        // Message 3
      { 0x24e8f393, 0xe4f7525b, 0xd26824b8, 0x6bf20dd5, 0x3a8f4233, 0x15ea4c9a, 0xd517c324, 0xec11a194, 0xab4faf20, 0xa38c7d7b, 0x10ec093c, 0xdd469438, 0x1bec7993, 0x690c56bd, 0xecabc76c, 0xc5de8092, 0x2d893d68, 0x957d0245, 0x13ebe668, 0xa6af181b, 0xa6f38a8e, 0x615e35be, 0x8df85275, 0x15ca334f, 0xa151bb2b, 0x59ef4a0d, 0x48b6703a, 0x6f79b825, 0x0c73b362, 0x74cdfafd, 0xbf22fd52, 0xc3ef3c73, 0x7f3a73a5, 0x8ed23fc7, 0xf5899c59, 0xeae0e4a8, 0xddfe84e0, 0x73bb51f9, 0x5c4b93f2, 0xd5bb6755, 0xaa87a4a2, 0xa2afcbb4, 0x0b3f38d2, 0x98b22460, 0xf98a9d18, 0x565b1f87, 0xf476bdce, 0x64b8ad7f, 0x3fd0a485, 0xcd048b39, 0xe0940d6c, 0x50b91163, 0x5e09558e, 0xd227f189, 0x92aa0448, 0xa353dc25, 0x5418daab, 0xcc2cf5f0, 0xe254acb6, 0x2d0f4cba, 0xec13809f, 0x8772508e, 0x76454fb4, 0x284de275, 0xfaa01e0d, 0xaf3eb8e5, 0x44aba9da, 0x57ae1d76, 0x7db28eaa, 0xb08b76f9, 0xbca0d9cd, 0x59f0b014, 0xdb9ce85c, 0xd5b65000, 0xa404947f, 0x2099d8ad, 0xda09d4c0, 0x67b3ef38, 0xfccec840, 0x9f27fa08, 0x55f18043, 0xd7112d80, 0x1d814240, 0x1e6aac1b, 0x9a9a6595, 0xacd74852, 0x4c6ef5a3, 0x5c6eda2a, 0xde1cd0a0, 0xe71e5154, 0x6355c160, 0x15654e27, 0x98e25ee1, 0x8f6ad7ea, 0xd9bac782, 0x1febb913 },        // Message 4
      { 0x1344431b, 0xb5380780, 0x00e3aaeb, 0xdb8f798e, 0x9047012f, 0x2bf1214b, 0x5e2d907c, 0xe7b1a864, 0xa494b04e, 0x22824c3f, 0xff5ebdc4, 0x1cebea8b, 0x327398cf, 0x829dc2be, 0x9098a503, 0x6d7e6e6c, 0x8d6380ac, 0xf324635e, 0xe89b667c, 0x16d3113b, 0x18dcbdc7, 0x5e8515ea, 0xbd310fc5, 0x0c2eb3c5, 0xf26756f0, 0x7dcc41da, 0x9fa69e32, 0xa35c7bc6, 0xe58e77e7, 0x63457812, 0x75e84f5a, 0x775719e0, 0x1fe54290, 0x90b0e76e, 0x6f6eb532, 0xd182892f, 0x1987ac40, 0x23d2c630, 0x2c7b4644, 0x816c840c, 0x00dc5976, 0xdfa3be87, 0x311335de, 0x74d74e59, 0x47767222, 0xd5bf65e3, 0x29735337, 0x2f5267fc, 0x6f07b449, 0x91f4c7d7, 0x5a521eb5, 0xd038e9e8, 0x1e16d69d, 0x85ddb1b9, 0x510a31a5, 0xa708a16c, 0xc1ebb6ae, 0xc987cdd6, 0x14a67ade, 0x7a508333, 0x02fc7171, 0xd7430bcf, 0x01e1e5ae, 0xe34b62b7, 0xe9f2c05f, 0xd07ade09, 0x4f6c9fc1, 0x1299e583, 0xbb2ae540, 0x31b96a6e, 0x4fbd053e, 0x22a322e7, 0xe89d5706, 0x8e9280f2, 0xf3bdb602, 0x45c689fe, 0x696b46e4, 0x9914966e, 0x19aa0a93, 0xf700bb4b, 0x2f8a75e5, 0xf5281cbc, 0x9582cfb3, 0xf2a07f01, 0x84a73efb, 0x1d654d67, 0xaa824534, 0xae94a243, 0xf5119e55, 0x52c44ea0, 0xb5ba3f74, 0x1a35b960, 0xfd02ede4, 0x819623dd, 0x1ae5b9e2, 0xb68c1f6f },        // Message 5
      { 0x0933dd38, 0x5906d39a, 0x52b06233, 0x088e8ae5, 0xb0145a6a, 0xc5573075, 0xedab6650, 0x9771dec5, 0x6b88ec68, 0x14ad20bd, 0x15424cf8, 0xcbf6ed5d, 0x98f1b68e, 0xb5298346, 0xf751af81, 0x25260df8, 0xe6cc0574, 0xc357ca1b, 0x112d1fcb, 0xd0a95706, 0x18fedfcd, 0x48486546, 0x029a269e, 0x2949ae69, 0x2cfabdcd, 0xa6f18222, 0x4f542b1e, 0x49123d07, 0xc56ae67a, 0xaafc3893, 0xceac0aff, 0x1f900689, 0xfb695834, 0x4b77c424, 0x59a01267, 0xb0efb433, 0x38dcd856, 0x201d7821, 0x4b09621e, 0xf6c30557, 0x77dc93c6, 0x1ccb40bb, 0x6aa8228a, 0x4fc5cd91, 0x9fdf033b, 0x41b6959e, 0xcce1948e, 0x109db3aa, 0xd90758a4, 0x6900534a, 0xdabce22d, 0xd18c47de, 0x65e5bc8a, 0xfce9dd86, 0xae2c3280, 0x5baa9b08, 0x35016c07, 0x5ebc3afc, 0x552a3286, 0xb34d48d1, 0xa6e37957, 0x4da97d2a, 0x2477be54, 0xc9e72dc5, 0xddd19f16, 0xf3a875f1, 0xa27e419d, 0x4647de0a, 0x370fd6b0, 0x1d89dfc3, 0xeb746909, 0x563c48b2, 0x301d383e, 0x9700c2b0, 0xa9ca1a10, 0x83fe6a61, 0x0774d438, 0x594d2c08, 0xb386a6b9, 0x962e3f70, 0xe477fd40, 0x82089ade, 0x5fdd7b9a, 0x6814ba6d, 0x13e03fac, 0x5b46e621, 0xda772261, 0xcac5d30b, 0x6f059cf8, 0x480b15e3, 0x89cd7427, 0x5a606b6d, 0x6e7779b5, 0x508f1309, 0xa4d4ce99, 0x791bc144 },        // Message 6
      { 0xa0400d1c, 0x6bd0ac92, 0x3183fbe2, 0xc34cef8a, 0x87ad28e9, 0x486021cb, 0x0e5ddd16, 0x177164ff, 0x6a21fd0c, 0x8bbd75ba, 0x82a1ce89, 0x8f8c5c15, 0x4fd1d7c4, 0x0dbe0927, 0x27f083fc, 0x111463cf, 0x65a9b6a7, 0xe052ac55, 0x2082a848, 0xa031ea56, 0x128bb855, 0x70ea193a, 0xe1ad0c40, 0xad2f9043, 0x0fb092d3, 0x2b9629f6, 0x9584df96, 0x0af17083, 0x844fcaa9, 0x457565f4, 0x8a8af471, 0xb372645f, 0x6f3f88b0, 0x95ffdccf, 0x744c4a1b, 0x25a76606, 0xe10ea6f4, 0xc594e36a, 0xf3ea3fb3, 0x0ab517f0, 0xefd109c9, 0xc90275d8, 0xa85c84d0, 0xd42fac61, 0x0bb55600, 0x21d36224, 0xc15e9e13, 0xa7eeaec7, 0xe5a97860, 0x37cfef7d, 0x52bf0e48, 0xa1bf7c45, 0x8e4cde4b, 0x05b305e2, 0x58da8fa8, 0x1d1f59b6, 0x5b541b4c, 0x9a61c88a, 0xbf468feb, 0xf9bec37e, 0x2d6c45b3, 0x5e29b44d, 0xfb960be2, 0x734e67be, 0x9dd4dac4, 0xfb183ee8, 0xdef87a83, 0x40609716, 0xaf543175, 0xb7bc4356, 0x7a4584af, 0x56c473f1, 0xf3d0a36c, 0xcb6b7ae7, 0xb47a512b, 0x60389a89, 0x731d83ae, 0x6332b62e, 0x6dbb343f, 0x11f7d306, 0x9627005b, 0x1a946cf5, 0xe5cc47d8, 0x7b644d5f, 0x136d79db, 0xa6cc46bd, 0xfa0c1dda, 0x83647dc7, 0xc02d343b, 0x9ee1902c, 0x2b2de8f7, 0xef135a88, 0x49006844, 0xba7b776e, 0x4599898a, 0x2ea99888 },        // Message 7
      { 0x1e44c73e, 0xbc41f37d, 0x8a4c191f, 0xd0a3ca5e, 0x3cccf943, 0xfe1371a5, 0x9714663d, 0xe8bd70f9, 0xf1ee93d1, 0x0c4a6b2e, 0x0d67cd42, 0xb7853d56, 0x0a8eede7, 0xeb3d9d7e, 0x1126bd87, 0xe9482e75, 0xcc758c80, 0xc890dcf6, 0x33aa9e35, 0x2241e5ba, 0xca0ad8f9, 0x1d1fd4d8, 0xb24c457a, 0x4a4320d4, 0x48340e27, 0xb1569a7e, 0xfb39441c, 0xa6ae39bd, 0xc376a698, 0xff93ce6e, 0x711d67bf, 0x3d58121f, 0xc72a2562, 0xd27468a4, 0x10ce733e, 0x7d20108b, 0x680e141f, 0x5a393264, 0x424eae15, 0x04e1bc99, 0xab667009, 0x594c44da, 0x923fbaac, 0xce3a72f0, 0x5c066673, 0x9a37b576, 0xc75fe3e0, 0x486fe42c, 0x08740e9f, 0x0ab6d8c2, 0xbfb40a22, 0x472a54c4, 0x571ad7cd, 0x015b9aec, 0x2a797f31, 0xfd1be88b, 0x11b3e996, 0xffbb3a6f, 0x22958494, 0x9c262451, 0xa94f1367, 0xb31e9be1, 0xe4f52605, 0xae8eb84c, 0xb7e1cb45, 0x8e4ac259, 0xaa6bf7c8, 0x41cc002c, 0xf7cc3f2d, 0xc1f19be5, 0xacfa685a, 0x5b3fb546, 0x4c51ffee, 0x1c35a624, 0x6a15319b, 0x7ee55990, 0x5817f4f2, 0x61c4d8b7, 0x3aab91fd, 0x25d8c325, 0xfd9172c7, 0xe0609af8, 0xb950519c, 0xa95dbafe, 0xfa1ce06c, 0x3c8d45ef, 0xc19c422c, 0xd622336f, 0x69271fb0, 0xabd82a20, 0x1861b104, 0xacf996f4, 0x05c48b55, 0x7364e993, 0x816f7a32, 0x0412c026 },        // Message 8
      { 0xb88c00e3, 0x533b8a8e, 0x8ac25518, 0x13fb308e, 0xe5e17a23, 0x0d3767f2, 0x77de8c92, 0x351cfb18, 0xe62d9cff, 0x7f0adb8c, 0x7f1f6653, 0x26482b4e, 0xd6d074f7, 0xccdc12b1, 0x724a3418, 0x820c1ac6, 0x0b144e53, 0x6d22911e, 0x3730255d, 0xb9db45b5, 0xd624f7bc, 0x0c864bb9, 0x5a11ab62, 0x8d3653f4, 0x1f12b3e0, 0x0a18c9f8, 0x911834f5, 0xeb2ddb13, 0xc093119a, 0xcd994efa, 0x132dd21a, 0x66cad641, 0x91e28e88, 0xb199cd43, 0x573aa7e8, 0x1f8d2e40, 0x45e4155f, 0x79411313, 0x9c4e3a5a, 0xc44db8da, 0x477dde3b, 0xf6f95bde, 0x72ff9965, 0xe7412dea, 0x29be12cd, 0xb46499bf, 0x016aa142, 0x855f47ff, 0x28e918fd, 0x4aa24b10, 0x31c4eba5, 0x7503ff40, 0x9bfca6fa, 0x2a953474, 0x1373816b, 0x1af03b41, 0x2d85de37, 0xc904d2a3, 0x4eebd9f5, 0x55e1a612, 0xa973fa19, 0x53d1967e, 0xd2145180, 0xe5f9a2e7, 0x90388905, 0x808f23ba, 0x294085e8, 0xdae89154, 0x0a70c122, 0xcc40bf48, 0xb3addebd, 0x1915b3ad, 0xe1557666, 0xb7cc2584, 0x1ac91e67, 0x863e0c27, 0xb97edf9b, 0x20aa53fc, 0x97716269, 0x0474cc4d, 0xc62cad31, 0xdd76a294, 0x34d6c574, 0xe31e645a, 0x0b67548c, 0x2d31945a, 0x3684e661, 0x4f78c04f, 0x922ed79f, 0x8e9f770d, 0x21137173, 0xb53b81c9, 0x85635cd3, 0x7e261139, 0x194eadc0, 0x79a373ba },        // Message 9
      { 0x6fb30f9f, 0x343eefff, 0x5b4c7bdc, 0xc482b5c2, 0xbead2ed5, 0x3fa697af, 0x20165a08, 0x4930512f, 0xda280d16, 0x25fa8842, 0x6d30192b, 0x2212a748, 0x8794eec9, 0xf297b40e, 0x02ccfd80, 0x50f22890, 0x04ad5626, 0x70d677aa, 0x61b5cd34, 0x75dea3f0, 0x937c4d20, 0xdef756aa, 0xadc6d8c7, 0x676846ab, 0x98e3bb04, 0x5adaebac, 0xb1fe651a, 0x55b86e52, 0xff647f75, 0x0caa70b7, 0x78703250, 0xaa2ef3c0, 0xdb107e92, 0xe7d9d03c, 0x5dad2f0e, 0xf54b0ae8, 0x19437fd5, 0x8f3ad3d7, 0xa379fba1, 0x05f858d5, 0xfafe5436, 0xf5cadba2, 0x63a37e9a, 0x6f2f8be8, 0x9b549c39, 0x66b5329b, 0x39272bcb, 0x7fa064df, 0x7db7b56e, 0xef45f4af, 0x8a2413df, 0xf10061ff, 0xd4453fb0, 0x33773c64, 0xad4d0222, 0x4d396d6d, 0x9889d1ba, 0x5e6c1f5c, 0x378fca54, 0xb19d50b5, 0xfc46fb91, 0xdbe2719a, 0xc3784d8e, 0x3454ce0e, 0x2da53815, 0x840ec1b8, 0x12b59a23, 0x2c87069a, 0xfd70bad7, 0x980b3e47, 0xa399eeba, 0x0c618d06, 0x7d2cc8d1, 0x7f49a81d, 0xac0f93e3, 0xa7be87ff, 0xf9d56ccc, 0xa86b8998, 0xf0075169, 0x3b2b0e50, 0x7058af3a, 0x7c317550, 0xb3c86fc2, 0x403c0959, 0x54e6e70e, 0x0c772489, 0x83446bc7, 0x15784b65, 0x9f5b2393, 0x1f553fe7, 0x2bab959d, 0x8387f82d, 0xf59c54c1, 0xc85c9717, 0x09335920, 0x5075166c },     },
     },
    { /* Case 2 */
        .iv = { 0x8c, 0x8d, 0xca, 0x5e, 0x78, 0x04, 0xfc, 0x40, 0x98, 0xc6, 0xb5, 0x1d, 0x93, 0x47, 0x6b, 0x4f },
        .p_data = {
            .Y = { 0xd92bd3a1, 0x205d4f50, 0xc5009ded, 0xeb26e749, 0x870834f6, 0x2031440f, 0xb0bedb55, 0xc9f85d0c, 0xc2b6daeb, 0x6ec96499, 0x944933bd, 0x7be95c45, 0x499fd0f1, 0xf2e73c4b, 0x32ef02a9, 0x5644f06a, 0x37c9e424, 0x74d4e492, 0x77aa981f, 0x3ff98fe7, 0x4b107879, 0x3ed88e5c, 0x92c6e7d2, 0xbf1f7c39, 0x01436987, 0x6965bc25, 0x9f1d8493, 0x0c6e6d98, 0x9651b175, 0xb09298fa, 0x4de4eb1d, 0x79cb38b8, 0x6c6c1f0e, 0xc9b0c5b5, 0x7e902197, 0x23dbc40d, 0x71e2cfab, 0xacf386e0, 0xc3babc59, 0x7d235747, 0xb66892dd, 0x62a419e6, 0xa173e155, 0x8abe7897, 0x69a010d5, 0xa76bd219, 0x265ad14b, 0x8304862c, 0x6e333855, 0x83182696, 0x9620adb2, 0x66f507a2, 0x1ecf2cad, 0x3ed3d4a7, 0xdac887fe, 0x3ef473a1, 0xcc8e8f14, 0x65dcd937, 0x4d3c5855, 0x4c8904d1, 0x28d6308a, 0xbbd5c54a, 0x3e07b4f0, 0x1207041a },
            .M = { 0xdfe3f967, 0x6c5edd15, 0x4fd11054, 0xea9f6a60, 0xf5d8a7ee, 0x247ab647, 0x8dfab95b, 0x9ebb5da9, 0x18f5c9e2, 0x1d92c281, 0x2ed79cd5, 0xfba12f5e, 0x458049e7, 0x6cf62e62, 0x6e29184e, 0xf0d6f6b9, 0x3ea1cfb9, 0x2ba8142f, 0xebded270, 0x65f30566, 0x09430b5c, 0x0b7b21be, 0x71ece11c, 0xc08ac1ce, 0x174f164c, 0xad3a8d8a, 0xc0c1094e, 0xabedfe93, 0xeb2bfa48, 0xe28c8d45, 0x27400d02, 0xe6597e23, 0xfa6a0047, 0x74044bb3, 0xa26cdab0, 0xc1788f4c, 0x5f30ac13, 0x51fa02a8, 0x519d756c, 0xcf42bd13, 0x63ada0b2, 0xa34015b8, 0x089efbd0, 0x2a208b2e, 0x6007bf17, 0x2a3016d1, 0x3934bf60, 0x684781bb, 0xd49cd016, 0xd1e9a2b6, 0x730c8a0f, 0x72840df1, 0x8946dab7, 0x6673f8cf, 0xda0b3fd8, 0xdc379c8d, 0x45cf75da, 0x437aaf83, 0x651b11c5, 0xdbe91f96, 0xf461c55b, 0x1f9859bb, 0xae3cc76f, 0xbfbbc9e0 },
            .Rb = { 0x280b5e1f, 0x72bf1b89, 0xd3f9104e, 0xd260624a, 0x7d1f0bf1, 0x567522ab, 0x4d99a330, 0x5b89adba, 0xebb5687e, 0x6f074969, 0x68d154fc, 0x77731f96, 0x4b9e6ede, 0xda9807d7, 0x7db705f5, 0x4b3a386f, 0xd397cbd1, 0x8f96dc7b, 0xcc4ea11f, 0xe1c0f50e, 0xd0479d06, 0xde49194d, 0x4574b048, 0x9b104ab3, 0x58e82107, 0xe72f598d, 0x15c0fb5c, 0x24cc6fbd, 0x59796c9b, 0xe99061a4, 0x58ce9466, 0xfe374dde, 0x2adf5f5e, 0x0d0043a3, 0xca97cf1b, 0x6a1bd199, 0x83e9604d, 0x9671b4c3, 0x87a99a2a, 0x4a8d2952, 0x5decf232, 0x4bfde7ac, 0x066dc874, 0xe9c67b93, 0x2d760b0f, 0x16f250a9, 0xbeaad901, 0x98194004, 0xbf052ec4, 0x83b5eb50, 0x910be2d0, 0x988fe547, 0xbc88fa08, 0xace57c99, 0xbe67719e, 0x6faaafe0, 0x72d736ee, 0x6cb4bcc4, 0x1616cd13, 0xf935cb4c, 0x6c54eb20, 0x8964a74e, 0x3a1f6421, 0x05a2f169 },
            .M_prime = 0x6904eda9,
            .length = ESP_DS_RSA_2048,
        },
        .expected_c = { 0x37, 0x21, 0x20, 0xd3, 0xb9, 0x5e, 0x9b, 0x50, 0x2c, 0xfe, 0x42, 0x88, 0xa3, 0x95, 0xd7, 0xd3, 0x62, 0xea, 0x0b, 0x55, 0xd8, 0x18, 0x4a, 0xc6, 0xe4, 0x90, 0x69, 0x1f, 0x9c, 0x57, 0xe0, 0xfd, 0x61, 0x8d, 0x91, 0x92, 0xbf, 0x63, 0x6b, 0x58, 0x26, 0xbc, 0x1f, 0xfc, 0x13, 0x06, 0xdd, 0xfc, 0x96, 0x62, 0xbf, 0x4c, 0x11, 0xd8, 0xe7, 0x7f, 0x24, 0x03, 0xec, 0x23, 0x25, 0x1f, 0x07, 0x9d, 0x4b, 0xee, 0xfd, 0x5c, 0xd0, 0x73, 0xa5, 0xce, 0xb7, 0xdf, 0x77, 0x49, 0x10, 0x30, 0x45, 0x8a, 0xa4, 0x9c, 0xd6, 0x49, 0xa8, 0x26, 0xac, 0xda, 0x49, 0xa6, 0x20, 0x86, 0xbf, 0x96, 0x57, 0x2a, 0xda, 0xec, 0xf9, 0x13, 0xab, 0x26, 0x70, 0x52, 0xac, 0x53, 0x91, 0x3d, 0x3f, 0x7c, 0xab, 0x87, 0x89, 0xb4, 0x2a, 0x48, 0x7e, 0xaa, 0xc1, 0x05, 0x28, 0x99, 0x27, 0x7a, 0xd3, 0x66, 0x2d, 0x63, 0x07, 0xe1, 0x27, 0xd7, 0xc1, 0x89, 0x16, 0x2c, 0xa1, 0x54, 0x4a, 0x4c, 0x34, 0x69, 0x8a, 0xb2, 0x2d, 0x79, 0x4e, 0x02, 0xfe, 0x54, 0x2d, 0xe3, 0xca, 0xda, 0x14, 0xb3, 0xb8, 0x43, 0x28, 0xa2, 0xc8, 0x3a, 0x80, 0xbc, 0xb4, 0x97, 0x2b, 0x7a, 0xcd, 0x58, 0x62, 0x19, 0xe8, 0x8b, 0x68, 0x15, 0x3d, 0xe4, 0x68, 0xf8, 0xfd, 0x1a, 0xe1, 0x4e, 0x4a, 0x9e, 0xeb, 0xa3, 0x0c, 0x82, 0x68, 0x10, 0x3d, 0xb4, 0x96, 0xe4, 0x3c, 0x1c, 0x12, 0x64, 0x88, 0x85, 0x4b, 0x54, 0xfc, 0x7d, 0x1f, 0xa7, 0xb2, 0x8b, 0xa0, 0x88, 0x4c, 0x1c, 0x0d, 0x24, 0x72, 0xd1, 0x16, 0x8d, 0xcf, 0xa7, 0x68, 0x3a, 0x60, 0x63, 0xb2, 0xf7, 0xa3, 0xaa, 0x6c, 0x26, 0x4b, 0xb4, 0xd7, 0x3e, 0x65, 0x35, 0x41, 0xab, 0x9f, 0x4b, 0xb0, 0x82, 0x1a, 0x50, 0x47, 0x9f, 0x65, 0x26, 0x61, 0x20, 0x79, 0xe0, 0xa2, 0x83, 0x9d, 0xdb, 0x54, 0x48, 0xa2, 0xea, 0xfd, 0x40, 0xf7, 0x54, 0x94, 0x83, 0x9a, 0x5d, 0xdf, 0x98, 0xf7, 0x25, 0x34, 0x21, 0x97, 0xc4, 0x93, 0xb4, 0x10, 0xcc, 0xf3, 0xaf, 0xa4, 0x30, 0xcd, 0x39, 0xf8, 0x58, 0xcb, 0x61, 0x1b, 0x60, 0x3e, 0xcc, 0x17, 0x56, 0x23, 0x9c, 0x42, 0xe9, 0x6e, 0xa3, 0x57, 0x8d, 0x8b, 0x4a, 0x15, 0x13, 0x3f, 0xb9, 0x7f, 0x81, 0xb1, 0x00, 0x1b, 0xe7, 0x68, 0x89, 0x71, 0xb0, 0x50, 0x49, 0xa7, 0x32, 0x8c, 0x9a, 0x81, 0x7e, 0x8b, 0x05, 0xce, 0xa3, 0xa4, 0x39, 0xe2, 0x09, 0xc7, 0x05, 0x5b, 0x92, 0x2e, 0x69, 0x98, 0x97, 0x16, 0xc6, 0xba, 0x86, 0x2a, 0x4c, 0xd3, 0xdf, 0xfa, 0x55, 0x1b, 0xc9, 0x90, 0xe3, 0x24, 0xa1, 0x1a, 0xc8, 0xa0, 0x99, 0x0f, 0xd7, 0x10, 0xd0, 0xa8, 0x69, 0xa8, 0xcc, 0xa8, 0x0b, 0xde, 0xf7, 0x86, 0x9b, 0x43, 0x0f, 0xcf, 0x18, 0x6d, 0x02, 0x06, 0xe7, 0xb3, 0xe7, 0x8f, 0x02, 0x6a, 0x49, 0xc6, 0xe5, 0x94, 0xdc, 0x01, 0x1a, 0xe2, 0xf0, 0xaf, 0x57, 0xe5, 0x63, 0x0b, 0x2b, 0xbf, 0x8d, 0x3c, 0xf3, 0x0a, 0xb7, 0x10, 0x42, 0xcc, 0x12, 0x22, 0x10, 0x65, 0x89, 0x82, 0x26, 0x5b, 0x59, 0x59, 0xfe, 0x14, 0x9c, 0x44, 0x2e, 0xc5, 0xcf, 0xaa, 0x68, 0xeb, 0xeb, 0x6b, 0x52, 0xa7, 0x00, 0x04, 0xd4, 0x77, 0xf5, 0x2c, 0xe6, 0x75, 0xdf, 0xdd, 0xfb, 0x0c, 0xb1, 0xad, 0x79, 0xd8, 0x95, 0xaa, 0x8e, 0x80, 0xa5, 0x1d, 0xaf, 0x51, 0x81, 0xa8, 0x24, 0xa7, 0xc2, 0x08, 0xc8, 0xcf, 0x17, 0x78, 0x25, 0xf6, 0x73, 0xa3, 0xa5, 0xcb, 0x8e, 0x24, 0xfc, 0x9f, 0x41, 0xcb, 0xa7, 0xc0, 0x42, 0xc2, 0xe8, 0xd0, 0xb4, 0xda, 0xeb, 0xda, 0xe2, 0x2a, 0x56, 0xa2, 0x50, 0x35, 0xf8, 0x06, 0x20, 0xbd, 0xa3, 0xef, 0x00, 0xd0, 0xc7, 0x65, 0x02, 0xb0, 0x6b, 0x90, 0x33, 0x01, 0xb4, 0xc0, 0x65, 0x9c, 0x5c, 0xca, 0x97, 0x0d, 0x2f, 0xf8, 0x19, 0x07, 0xcc, 0x22, 0xa9, 0xdf, 0x3c, 0xb1, 0xdf, 0x4b, 0x9e, 0xd2, 0xff, 0x20, 0x8c, 0x09, 0x32, 0xbb, 0x27, 0x56, 0x1e, 0xdc, 0x2a, 0xcb, 0xbe, 0xff, 0xd0, 0x27, 0x0f, 0x12, 0x2d, 0xe2, 0x46, 0xd1, 0xbc, 0xa1, 0xf7, 0x39, 0x3b, 0xec, 0xc7, 0x5f, 0xc0, 0x14, 0x68, 0x22, 0xc5, 0xe4, 0x2a, 0xed, 0xa7, 0x24, 0xd4, 0x81, 0x93, 0x95, 0xc6, 0x2e, 0x8d, 0x18, 0x2d, 0x80, 0x5f, 0xd8, 0x8d, 0x42, 0xef, 0x81, 0x46, 0x36, 0xb7, 0xca, 0x59, 0x67, 0x81, 0xdd, 0x02, 0xa7, 0x02, 0x9b, 0x97, 0x8f, 0x26, 0xb4, 0xd9, 0xc0, 0x2a, 0xf4, 0x9b, 0xd2, 0xd2, 0x8e, 0x57, 0x65, 0x33, 0x5d, 0xba, 0xfe, 0x5c, 0x9f, 0x21, 0x1c, 0xbd, 0x97, 0x15, 0x5c, 0xc4, 0x97, 0x66, 0x03, 0xc5, 0xb7, 0xc3, 0xcc, 0x46, 0xf1, 0xf1, 0x7a, 0xd2, 0x17, 0x06, 0x68, 0x5d, 0xfc, 0x51, 0x5d, 0xb5, 0xac, 0xed, 0x81, 0xc0, 0xec, 0xce, 0x03, 0x47, 0xf2, 0x49, 0xf7, 0xe5, 0x09, 0x90, 0x3e, 0x70, 0x81, 0xc0, 0x1f, 0xb8, 0x78, 0xa4, 0x43, 0x80, 0x25, 0x4c, 0x18, 0x9b, 0xee, 0x06, 0x73, 0x11, 0x50, 0x12, 0x3f, 0x0b, 0x66, 0x7c, 0x29, 0x0e, 0x7e, 0x7f, 0x8f, 0xc8, 0xe7, 0x2a, 0x84, 0xb7, 0x3d, 0xaa, 0x92, 0x2b, 0x97, 0xa0, 0xa1, 0x64, 0x6f, 0x0b, 0xd5, 0xb3, 0x4e, 0x7b, 0x44, 0x8b, 0x16, 0x14, 0x67, 0xa7, 0xf0, 0xb8, 0x00, 0x4b, 0x60, 0x53, 0x34, 0x69, 0x1d, 0x4a, 0xe4, 0x1d, 0x32, 0x16, 0x0d, 0x1f, 0xac, 0xcb, 0x8d, 0x7c, 0x18, 0xde, 0x5e, 0xd1, 0x82, 0x67, 0xf5, 0xde, 0x31, 0x61, 0x23, 0x5e, 0xf2, 0xb8, 0xb1, 0x8c, 0x06, 0x2f, 0x62, 0x9b, 0x8b, 0x41, 0xeb, 0xc9, 0x75, 0x04, 0xc0, 0x3d, 0xd8, 0x41, 0xe7, 0xe7, 0xc0, 0x02, 0x64, 0x2b, 0xd8, 0x59, 0xc3, 0xc4, 0x4e, 0x4f, 0x0a, 0x7f, 0xb0, 0x84, 0x0e, 0x36, 0xf7, 0xfa, 0x4a, 0x17, 0x38, 0x47, 0xf4, 0x9d, 0x99, 0xb9, 0xdb, 0x10, 0xc1, 0xe3, 0xe8, 0xa0, 0xc4, 0xbe, 0xbf, 0x71, 0x46, 0x07, 0xfc, 0x25, 0x4a, 0xc7, 0x6b, 0xed, 0x7d, 0x2c, 0x1a, 0x46, 0x64, 0x4a, 0xff, 0x31, 0xef, 0x6f, 0x62, 0x2b, 0x2e, 0x7d, 0xfb, 0x55, 0x22, 0x76, 0x30, 0x49, 0xc8, 0x17, 0x89, 0x00, 0x4b, 0x85, 0x28, 0x54, 0xb6, 0x12, 0x53, 0x6a, 0x0d, 0xfe, 0xcc, 0x1e, 0x3a, 0x39, 0x3f, 0x96, 0x8d, 0x1e, 0x50, 0x59, 0x50, 0xfa, 0x8d, 0x67, 0x9b, 0xd2, 0x4f, 0x1e, 0xd4, 0x8c, 0x03, 0x7d, 0x76, 0xad, 0xfa, 0x19, 0xd7, 0xcd, 0x7e, 0x2e, 0x85, 0xd4, 0x4c, 0xd5, 0x1b, 0x4e, 0xf8, 0x5b, 0x9a, 0xc4, 0x95, 0x0b, 0x8b, 0x4c, 0x45, 0x42, 0xa2, 0x42, 0xba, 0x72, 0x2d, 0x1d, 0x82, 0x73, 0x5b, 0x44, 0x2d, 0xc3, 0x20, 0x1b, 0xf6, 0x9e, 0x58, 0x3b, 0x8b, 0xf4, 0x20, 0x6f, 0xf8, 0xd3, 0x0e, 0x45, 0xf7, 0xba, 0x86, 0xd3, 0x6c, 0x0d, 0x5a, 0xe1, 0x88, 0x13, 0x25, 0x99, 0x0f, 0x3f, 0xd6, 0x55, 0x12, 0x29, 0x63, 0xfd, 0x50, 0x82, 0xba, 0x1c, 0xbb, 0xeb, 0xba, 0x00, 0x14, 0xd9, 0x8a, 0x73, 0xcd, 0x1e, 0x2c, 0xc6, 0xc5, 0x49, 0x75, 0xbe, 0xab, 0x07, 0x97, 0xf3, 0x1c, 0xe1, 0xd4, 0x44, 0xb8, 0x16, 0xe0, 0x19, 0x9a, 0x33, 0x84, 0x2a, 0x42, 0xd0, 0x04, 0x00, 0x5a, 0x53, 0x41, 0x75, 0xb7, 0x3c, 0x31, 0xe4, 0x39, 0xd5, 0x0b, 0x61, 0x11, 0x4a, 0xcd, 0xac, 0x18, 0x39, 0xca, 0x36, 0x1b, 0x5a, 0xb4, 0xbd, 0x02, 0x81, 0x93, 0xae, 0xd3, 0x83, 0x5a, 0x3c, 0xd9, 0x58, 0x53, 0x0e, 0x7f, 0x01, 0x15, 0xe2, 0x00, 0x07, 0xb1, 0xcd, 0x17, 0x44, 0x29, 0xae, 0xe0, 0xe0, 0x9d, 0xfb, 0x05, 0xdc, 0x26, 0x8c, 0x20, 0x60, 0x90, 0x1c, 0x93, 0xf6, 0xd3, 0x3d, 0xaf, 0x17, 0xde, 0x9c, 0xcc, 0xf0, 0xd2, 0xfe, 0x3a, 0x27, 0x7e, 0x46, 0x8a, 0xd5, 0x9c, 0xf4, 0xa8, 0x1e, 0xe3, 0xff, 0xb3, 0x8b, 0x0c, 0x18, 0x21, 0x5c, 0x4d, 0xa4, 0x44, 0x22, 0x05, 0x6c, 0x26, 0x6c, 0x28, 0xdd, 0x30, 0x5d, 0x06, 0x4e, 0x95, 0xd8, 0x93, 0x3c, 0x0a, 0x3b, 0xce, 0x83, 0x94, 0x67, 0xd1, 0x9a, 0x85, 0xe7, 0xa4, 0xe1, 0xd4, 0xc1, 0x7a, 0xcf, 0xb9, 0x09, 0x54, 0x12, 0xbe, 0xaf, 0x5f, 0x31, 0x82, 0x1b, 0xf0, 0x64, 0xcc, 0x98, 0x5f, 0xd0, 0x1a, 0x82, 0xab, 0x01, 0x2a, 0xe6, 0x59, 0x82, 0x50, 0x42, 0xdc, 0xb7, 0x2b, 0x69, 0x7b, 0x5e, 0x38, 0x44, 0x5e, 0xc0, 0x94, 0x53, 0x76, 0xb3, 0xe0, 0xef, 0x64, 0xbc, 0xad, 0xfd, 0x1b, 0xef, 0xbb, 0x44, 0x18, 0x7b, 0x24, 0x47, 0xd3, 0x47, 0xea, 0x0a, 0x91, 0xcd, 0x76, 0xe0, 0x09, 0x76, 0x63, 0x4b, 0xa5, 0x4e, 0x9c, 0x3d, 0x5d, 0x77, 0x9e, 0xe9, 0xc3, 0x35, 0x40, 0x25, 0x9f, 0xed, 0xdc, 0x4a, 0xb9, 0xe2, 0x42, 0x66, 0x5d, 0x38, 0x2a, 0x12, 0xcb, 0x4d, 0x37, 0xf6, 0x49, 0x80, 0xe8, 0x03, 0x8e, 0x02, 0x79, 0xd9, 0x1e, 0xb9, 0x7a, 0x55, 0x46, 0xac, 0x70, 0xc2, 0xa6, 0x70, 0xe0, 0x46, 0xdf, 0x9b, 0xfc, 0x2d, 0xc3, 0xb7, 0xdb, 0xf1, 0xbb, 0x9d, 0x51, 0x26, 0xd6, 0x19, 0xc8, 0x48, 0xa0, 0xd5, 0xa8, 0x61, 0x16, 0xc2, 0xeb, 0xac, 0xa3, 0xd1, 0x33, 0x79, 0x54, 0x23, 0xc5, 0x3b, 0xec, 0xef, 0xd4, 0xe9, 0x07, 0xc9, 0xc7, 0xc6, 0x5d, 0x7c, 0x86, 0x0b, 0xf7, 0x7f, 0x19, 0x5a, 0xb3, 0x15, 0x0e, 0x0f, 0xde, 0xa9, 0x5c, 0x4e, 0x4c, 0x60, 0x36, 0x8f, 0x0d, 0x27, 0x8f, 0xf6, 0x94, 0xc1, 0x35, 0x88, 0x1d, 0x1f, 0xfd, 0x8e, 0x76, 0xeb, 0x7e, 0x41, 0xd8, 0xe2, 0x17, 0x88, 0x5c, 0x38, 0x8f, 0x9c, 0x34, 0x9c, 0x1d, 0x33, 0x73, 0x99, 0xd8, 0x8c, 0x4d, 0x45, 0x22, 0x3a, 0x40, 0xa8, 0x47, 0x8f, 0x25, 0x6b, 0x44, 0xc2, 0x22, 0x4c, 0x5a, 0x94, 0x78, 0x83, 0xd9, 0x9a, 0x50, 0x09, 0x27, 0x90, 0x85, 0x9d, 0xe7, 0xdf, 0xfd, 0xcb, 0xba, 0x9d, 0x4a, 0xd6, 0xd2, 0xa2, 0x3b, 0xaf, 0x6b, 0xb1, 0xca, 0xc4, 0x2d, 0x89, 0x72, 0xf6, 0x1b, 0xf5, 0xf9, 0x88, 0x28, 0x7f, 0x8e, 0xb5, 0xc4, 0x80, 0x02, 0xff, 0xb9, 0x21, 0x8c, 0xbc, 0x2b, 0x04, 0x2b, 0xf7, 0xc5, 0xf8, 0xbb, 0x3b, 0x93, 0x76, 0x41, 0xfd, 0xb0, 0x59, 0x82, 0xa2, 0xbf, 0xda, 0x56, 0xe4, 0x51, 0x7c, 0xe3, 0x71, 0x2e, 0xb8, 0x17, 0x95, 0xd7, 0x39, 0x9d, 0xfd, 0x87, 0xc1, 0xaa, 0xa3, 0x7a, 0x7b, 0xca, 0xea, 0x67, 0xfe, 0x64, 0x24, 0x9f, 0x45, 0x82, 0xd5, 0x95, 0x47, 0x5c, 0x94, 0xb7, 0xc2, 0x42, 0x80, 0x70, 0x38, 0x98, 0xf5, 0x1b, 0x0e, 0xc8, 0x9d, 0xb4, 0x94, 0x08, 0xbb, 0x02, 0x15, 0xe4, 0x53, 0x4c, 0xca, 0x03, 0xb4, 0xbe, 0xe1, 0x76, 0x2d, 0xef, 0xcd, 0xd1, 0xb5, 0xc9, 0x47, 0xc3, 0x2c, 0xed, 0xb7, 0x8c, 0xfb, 0xcf, 0xf6, 0x46, 0x7a, 0xfc, 0xe5, 0x48, 0x33, 0x42, 0x66, 0x92, 0x60, 0xe3, 0xe5, 0x30, 0x08, 0xb7, 0xca, 0xd3, 0x9c, 0x9c, 0x51, 0xc3, 0xa8, 0x7c, 0xdf, 0x37, 0x92, 0xe7, 0x8c, 0xec, 0x01, 0x26, 0xed, 0xab, 0xd4, 0xc8, 0xec, 0x90, 0x05, 0x46, 0x6a, 0x1e, 0xb6, 0x2f, 0x8e, 0x87, 0x7e, 0xb5, 0x62, 0x04, 0xf2, 0x75, 0x51, 0x71, 0xb2, 0xa6, 0x12, 0x66, 0xe9, 0x96, 0xdd, 0x4f, 0x37, 0xcc, 0xdf, 0xdc, 0xa7, 0x85, 0x21, 0xa4, 0xca, 0xc0, 0x95, 0xdf, 0x3d, 0xba, 0x35, 0x32, 0x18, 0x0e, 0x8f, 0xec, 0x1a, 0xdc, 0x34, 0x79, 0xb3, 0x50, 0xcf, 0xe7, 0x0b, 0x68, 0x79, 0x64, 0x72, 0xac, 0x2c, 0x8c, 0x61, 0x60, 0x9a, 0xd5, 0xbb, 0x68, 0x70, 0x8b, 0x79, 0xad, 0xa1, 0x52, 0xb0, 0xbc, 0x98 },
        .hmac_key_idx = 0,
        // results of message array encrypted with these keys
        .expected_results = {
        // Message 0
      { 0x0cf1fb18, 0x0df728af, 0xb9a602fc, 0x0092f464, 0x8b21ab65, 0x899ed697, 0xb2ed57de, 0xf97f8665, 0x4ddf9d12, 0xff586ef3, 0xf14d3ee5, 0xcb47894c, 0xc5135d24, 0xbc782494, 0xb7ec5837, 0xf27f9d8a, 0x4e63bfb4, 0x021ff411, 0xa23b73f1, 0x067fc63c, 0x3b5e96b2, 0x966d5cfb, 0x3b0e171b, 0x4c436c5f, 0x8e3e6404, 0xcfa339a4, 0x32403938, 0x10c977c5, 0xf1ee0369, 0x2eed90c1, 0x62ced69a, 0xe343ff2b, 0x12e44fa1, 0xecb1bbf7, 0x016255f1, 0xc448927e, 0x7fa63a16, 0xb371927e, 0xac8aa342, 0xc62e16ff, 0x378d5714, 0x7968b892, 0x6b1499f1, 0xe07c2509, 0x7dd5b764, 0x362c967c, 0x831b0d89, 0xd53b17c7, 0xe9cd104d, 0xe2d77124, 0x3789a192, 0xb720c581, 0xc2849e1a, 0xc49a9e6d, 0x5200cda4, 0x1e18db7f, 0xfc48edb8, 0x72d6bcf3, 0x449afe91, 0x032b5c60, 0xd980d938, 0x8face383, 0xdbe55e1f, 0xb701c75e },        // Message 1
      { 0x61a50f61, 0x5c1efe52, 0x855c363d, 0x6cc2a923, 0xfa8a4825, 0x8247d7d7, 0x096a7ad2, 0x36a4b5ce, 0xf12d9c7c, 0x9773d4fd, 0x881fdfb3, 0x2acd2f9c, 0xac73f589, 0xc865ceaf, 0x02cf72ed, 0x416d9f2d, 0xfb4ea8a6, 0x8b23bfaa, 0xe1b3e967, 0x8d0cc685, 0xdb5e5c2a, 0x5e7a8b24, 0xea39d2c2, 0x1237ef02, 0xf1c87f61, 0x3e453dc6, 0x6719f24b, 0xe87fa575, 0x135f0023, 0x0936bd82, 0x590dfd03, 0xc391023c, 0xcd1b0642, 0x57db8ecb, 0x4e5862a3, 0x535ff5be, 0x4f1041e1, 0x9a43a542, 0x4e7b4fb8, 0x4aebb466, 0xd0b92ebd, 0xa9dd2bd1, 0x56f6ce0c, 0x6dac84c3, 0x256e2b42, 0x0a4f24d8, 0xd713c388, 0x9580e5dc, 0x42d8e62a, 0xe94f9560, 0xed7d4705, 0xacb6d651, 0xd17c9da9, 0xcc7e6644, 0xe32ee238, 0xff16ddd3, 0x75526c78, 0xf009671a, 0xb745afba, 0xd9fddcef, 0xbe95a31e, 0xee33909f, 0x18d938ef, 0x76ebb944 },        // Message 2
      { 0x83e23dc3, 0x54fbf70c, 0x8bbb3785, 0x7b0f5810, 0xb94d6873, 0x00c031c3, 0x89c10b40, 0x9858884f, 0x3caa920b, 0x6e97138b, 0xe40405be, 0x2d657cd7, 0x1cd4a976, 0x58bffc75, 0xae1e53a6, 0x90dac103, 0x8e50c14a, 0x5c4f6688, 0xfa0e8895, 0xb692f4c8, 0xa9f0fa19, 0x1e148357, 0x937016bc, 0x3280a776, 0x899c8e94, 0x49851e6b, 0x7403fc6b, 0xef104d1f, 0x28bdf0fa, 0xe3ab1ac9, 0x2acdfd6e, 0x042dfab0, 0x6bfa4f14, 0x152d833e, 0xa666dc1f, 0x31284edb, 0xde63d952, 0x7e1bf4d4, 0xb8e376ed, 0x06fe8719, 0x9c0f9ba0, 0xae5bbfa3, 0xafd9f926, 0x5f48f9e8, 0xc8507963, 0x563ea17e, 0x720fc7b0, 0xa3319d41, 0xdc52a78c, 0xd54f565a, 0xfd4e718d, 0xadd8dadc, 0xdc0a3306, 0xc508165a, 0x453fba24, 0xeacdb589, 0x8183b9e0, 0xf2748d3d, 0x4731eb06, 0xee46dd0a, 0xa8092492, 0x2a8a19db, 0xa4d01f20, 0x8ae851ca },        // Message 3
      { 0xe24fa3a6, 0x29c9908c, 0xe389fd13, 0xccf216c0, 0x8fed473e, 0x16dd28ff, 0xcd823912, 0x07a4de5e, 0x4661af9f, 0xa0a6386d, 0x74fa7f72, 0x590f3b6b, 0x8cca70d3, 0xfb99ccc9, 0x02e2bb99, 0xa333f468, 0x57c78817, 0xb12f8349, 0x5c1b8ad9, 0xc4972c49, 0xe4879524, 0x1387bc57, 0x9ac8774b, 0xe9d85848, 0xc96cf5e5, 0x09f0420a, 0x87b793c9, 0x01d26245, 0x3fd9e3cc, 0x3b3cb03a, 0xe4f105ca, 0x86187443, 0xbf0c98a9, 0xd1339f58, 0x19535c9e, 0x126d6183, 0x7904c5e0, 0x6d6ce6d7, 0xb248f83f, 0x388ab2a6, 0x8a4c73e0, 0x0b00e127, 0x0463d17c, 0xc982ce7a, 0xb018c256, 0x4ab18f9c, 0x992570c9, 0x017a0c1e, 0x2084a8b7, 0x19e326f9, 0x1187c1b0, 0x6e2cc30a, 0x3e2b3aba, 0x4c721c5d, 0xf35cf16b, 0x66d9dfd9, 0x71a3af34, 0xc6ff40fb, 0x3eb7f64c, 0xfdeec267, 0xab3e4a49, 0x7d9a2e3e, 0x4ff3f794, 0x51a046fe },        // Message 4
      { 0xa0768ffb, 0x8b0fb12d, 0x8cfc2bdc, 0x408aba71, 0xcc3904eb, 0xcd53768e, 0xbe0637a8, 0x9cf4bcb8, 0xfc5ee5a8, 0x6b6d9730, 0x27e72abe, 0xc20bb524, 0x049f7daa, 0xf378c884, 0x36008781, 0x048e6bc1, 0x89544bb8, 0x710c8a5b, 0x2315005d, 0x419466d6, 0x5828565d, 0x335b69d4, 0x0917744c, 0xd604c740, 0x91fa15c8, 0x673b2c65, 0x99c8aff8, 0x35a8aa10, 0xe3159e5e, 0xb0335608, 0x7defec64, 0xaa475bae, 0xe14a1d26, 0x9701bd5b, 0xf6ca87bc, 0x69ac22bb, 0xa1875f26, 0x19ec50bd, 0x272167c9, 0x007e88d9, 0x258e8573, 0xde745771, 0x59b114a1, 0x7a9a20b6, 0xc7a897f9, 0x0c2126a4, 0x7f6865c7, 0x4b0b8dd9, 0x6f86f1ce, 0xbe66b74d, 0xc6e6e0bc, 0x1f71ce87, 0x58efcd64, 0xeff51fbc, 0xcc5825aa, 0x4966e66e, 0x9dc7fcf7, 0x717fb9e0, 0xdba4df26, 0xb139ce6c, 0x6bbede8d, 0x610edae2, 0x85f40cbd, 0x5e18a8c7 },        // Message 5
      { 0xa355dec4, 0x2fc0fdcf, 0xd160a4bd, 0xeaaecf9b, 0x48a1600e, 0xaff94e1f, 0x529206a3, 0xc02abc78, 0x62ee2cc3, 0x9a398126, 0x30fdf459, 0x494715c5, 0x8b659b9b, 0xc33a78e9, 0x0b1c8ad0, 0x3b339c5a, 0x1d9956f9, 0x63288b8b, 0xf2a2d9dc, 0xea6efb62, 0x9ad1c9af, 0x048a1d77, 0xc0e6a00c, 0x1cf9bcbb, 0x68ecea65, 0x9a3d7a16, 0x182ac443, 0x656ad8cb, 0x8331a76a, 0xb127b268, 0x9b2dbc0e, 0xe08aab89, 0x42d0fba1, 0x6fe9e6eb, 0xa92e88f4, 0x102a4fab, 0x9c7d46ce, 0x5c003d03, 0x37ea59e7, 0x57906452, 0xf18803e9, 0xbb490d7b, 0xf12c4cf1, 0x4be1a670, 0xacb2126a, 0x26bbf9a4, 0x873741de, 0xfeae1936, 0xb5c53327, 0xe05d87f7, 0x45695d7a, 0x938129b0, 0xd9192204, 0x030a5a0a, 0xaa98f25b, 0x0e167e63, 0xb9a57b1e, 0xe5110da3, 0x4e5f63cf, 0xefc7bf42, 0x01742a8d, 0x2d3564a4, 0x03d5dcf8, 0x366815db },        // Message 6
      { 0x2275d1aa, 0x3cd3b795, 0x0cfbac91, 0x69952d73, 0x0c5b3c4a, 0x9018593f, 0x5c84a320, 0xa0e5954d, 0xe4f2ba7e, 0x9470dbbd, 0x0550c76e, 0x571d8860, 0xc27492b4, 0x2537503a, 0x49b6305c, 0x1a3fe3e6, 0x5b665e25, 0xe2229a36, 0x53b8e230, 0x962f61d7, 0xc54c0eda, 0x03dc07c7, 0xd34d48b1, 0x46cc3688, 0xf0bfa010, 0x6dc25865, 0xdbbc132f, 0x7b14c7d1, 0xe1dbf1f4, 0x84451974, 0xd50aa7f6, 0x7adce0ed, 0x3c56c88b, 0xc2e83142, 0xb0079d88, 0x1a1c1644, 0x8f89ab27, 0xcbba4c75, 0x232a2192, 0x23e15114, 0x07026c17, 0xec911a74, 0x73d61303, 0xd2e57fcf, 0x516b17a9, 0x88c83000, 0x8647939f, 0xb569b387, 0x86f2b289, 0x0360339a, 0x7d6afa28, 0x165b7f75, 0xf54af06d, 0x6f52b2ad, 0x46587039, 0x7dce21e1, 0x540b6afb, 0x58be51b0, 0xd6f26ae5, 0x60d355b7, 0x6b924a1c, 0x41834fe8, 0xc3bf6cb0, 0x891edff8 },        // Message 7
      { 0x6c92bd29, 0x56374335, 0xeacda135, 0x25f7b5de, 0xd7b7ee37, 0x0b94a43a, 0x9f13e90d, 0x887f1141, 0xfd402d66, 0xe14d5632, 0x986f2a79, 0x2424b0d2, 0xc298cd7f, 0xb08b8cd9, 0x3e9e2a28, 0x97af6d15, 0xb51111d0, 0xc7224951, 0xf8a16555, 0x2ebbea2c, 0x6275016a, 0x97908162, 0xd5ff1b0f, 0xba24f7a7, 0x28b02fe5, 0xa3f12b3d, 0x03594bd3, 0x10ca09c7, 0x18cfc8f6, 0x6224a036, 0xd339443f, 0x08623f33, 0x62f6e318, 0xc60f3513, 0xe2c7c6f1, 0x4210ea70, 0xa3c16638, 0x5c1fe980, 0xcc4c7e36, 0xcc32f085, 0xffd3f349, 0x2dc91723, 0x0ffab3de, 0x8d4f7b5e, 0x5d459cea, 0x8dab1cee, 0x7e863a1e, 0xc09f957e, 0x78011576, 0x62671534, 0x56dce1c6, 0xa3f7b519, 0xff3fc113, 0x461a5dee, 0x5dda0e0a, 0xe674944a, 0x12f2435d, 0x86de7f99, 0x091e7e8c, 0xc406b921, 0xa9f6a51d, 0x38b08c5c, 0x2c692f7b, 0x7c329433 },        // Message 8
      { 0x4cd5b0df, 0x63f1f38d, 0xdc5b815b, 0xc5420b6a, 0x54feff63, 0xe7d9aeda, 0xfede70c5, 0x8e06628d, 0xe3166f05, 0xb2988225, 0xcaeabc6e, 0xde9fa16c, 0x31144f02, 0xa8338d72, 0x7ed33953, 0x6af933fe, 0xe57cf1f7, 0xab2fb579, 0x62f73962, 0x1a6f763e, 0xae239352, 0xa5608c15, 0xec56596a, 0xacd51e5b, 0x685fc6c1, 0x87e6712d, 0x3ca10263, 0x5b2691af, 0xf2694d5b, 0x82e5140e, 0xb0d61d9b, 0x2d4618cf, 0x31417bac, 0xeb73d6df, 0xace7b900, 0xf17d26a1, 0xf0752653, 0x2eb22eab, 0x53afd59d, 0xe082bdc5, 0x054f1f04, 0x5296e138, 0xdc729456, 0x946e15ec, 0x4655580d, 0xf173d3a9, 0x6244dfed, 0x5176f53d, 0x9e8666c4, 0xa0126087, 0x031c5c0d, 0x3e6e31ac, 0xdb2c9a2a, 0x29d2b97d, 0x22edb4ce, 0x7652055d, 0xd08d5c34, 0x6ef5e771, 0xb7d16fa1, 0xb0dd1689, 0x06426188, 0xe93ee9dd, 0xd851baf3, 0x3eca900c },        // Message 9
      { 0xd03ea771, 0x9aa69300, 0x14a6171f, 0xac603a72, 0x4c8a90d7, 0xecb7bfc2, 0x6f1121a0, 0xc5313ec5, 0x705d6bac, 0xcda8902e, 0x1f649610, 0x0ffb7c3e, 0xe6cbf7af, 0x8ddb1f22, 0xf55c767b, 0x64f8b2fb, 0xd82dd1f4, 0xf3019176, 0x0e6a0ccd, 0x5ffde245, 0xe0b75a96, 0xa8cb609a, 0x9620c351, 0x0887f387, 0x621313bc, 0x95806a01, 0x65b57249, 0x95dd8efd, 0x461b3660, 0x047ddbaa, 0x39e9c46c, 0x8c89b1e1, 0x5883fbc9, 0x231bc4d9, 0xa0e59750, 0x49095e70, 0x8f008be6, 0x79059539, 0xe4a80946, 0x174acebf, 0x1fa6978a, 0x6823cdb5, 0xb1b5f165, 0x25777eee, 0xcd287458, 0xf367c729, 0xdc3e555b, 0x41fea9ce, 0x4fb25ae1, 0xd55a17b5, 0xb5995c49, 0xbb4324cd, 0xc0a9b545, 0xff268463, 0x7f7ada2a, 0xc1c71cef, 0x030822d7, 0x26646d53, 0x0db0a6c2, 0x1c4e14ec, 0xaac03db2, 0x84665272, 0x71fc21c3, 0x4b792fb3 },     },
     },
    { /* Case 3 */
        .iv = { 0x42, 0x42, 0x67, 0x65, 0xd2, 0x40, 0xf2, 0x13, 0x4b, 0x4e, 0xf2, 0xbb, 0x0b, 0x50, 0x73, 0xa6 },
        .p_data = {
            .Y = { 0x9f2f6001, 0x6ec95f1c, 0x3b2298f5, 0xd1e3d3c4, 0x860e86e6, 0x040656b9, 0x0ca3d0a6, 0x6c50c83c, 0x49b8708c, 0x16fb3c94, 0x41f21d50, 0xe251d287, 0x5ae81903, 0xba377e35, 0xe19886f2, 0x1f6a9cac, 0x6859e965, 0x9ea35fe1, 0xf46ac344, 0x2cdacda4, 0x2a8a457e, 0xdafd0442, 0x18b8629d, 0x64303db4, 0xe4cf3d10, 0x0aa75311, 0x4b51e6bc, 0xe30ac200, 0xa980027f, 0xba083718, 0x7bdecad6, 0x1b55e9b2 },
            .M = { 0xad555911, 0xc9f44e49, 0x070ab362, 0x0def4ec0, 0xc0b91dea, 0xa9ec8918, 0x6eb09989, 0x0bbf0f42, 0x59035d18, 0xf4f159be, 0x656995fe, 0x210fb0f1, 0xfa6b7bb5, 0x98e07bf9, 0x87284868, 0x8580487f, 0x2653de47, 0xf0e0a296, 0xf5d6baa2, 0x908d91d0, 0x0a45feee, 0x19c91b6a, 0xd9aac1bc, 0x133e7c1e, 0x3fc2b26f, 0xbf47e0b5, 0xf1272857, 0x6bdf4c8e, 0x80fd83fe, 0x082e42fe, 0x21f3a6b6, 0xbcf9def5 },
            .Rb = { 0x564cede1, 0x0d587db0, 0x92fd0e75, 0xe9abbaf9, 0xe66f38bb, 0xf9eedb5c, 0xd4ed6bdb, 0xcf1bb1fd, 0x443a9e95, 0xbc2ea1e0, 0x4cb47f1e, 0x9b916868, 0x3342b9ec, 0xb62cb0ec, 0xe3c7606b, 0x84f5714e, 0x65eea717, 0x2ca34f1f, 0x0d5be422, 0x2ee34c8a, 0x9a95d612, 0xd39d7196, 0xba6b3817, 0xbc64fd19, 0x897c5bba, 0x2b524bc7, 0xfdf5553e, 0xe7524e3a, 0x86075abc, 0x668230c7, 0x3d77d0c8, 0x5b481e4c },
            .M_prime = 0x0fc3480f,
            .length = ESP_DS_RSA_1024,
        },
        .expected_c = { 0x0a, 0xd8, 0x70, 0x33, 0x04, 0x6c, 0xa3, 0x1f, 0xf5, 0x38, 0x7a, 0xb7, 0x37, 0xdb, 0x84, 0x80, 0x71, 0x3c, 0x64, 0xdc, 0x2c, 0x88, 0x82, 0x5a, 0xe0, 0x4d, 0xd4, 0xee, 0x73, 0x52, 0x8f, 0xa7, 0x66, 0xae, 0x23, 0xd8, 0xf1, 0x7a, 0x2e, 0xea, 0xe9, 0xbd, 0xcd, 0x69, 0xca, 0x27, 0xdb, 0x8e, 0x57, 0x6b, 0xd8, 0xa8, 0x0e, 0xc5, 0xe4, 0x19, 0x4a, 0x99, 0x0b, 0x31, 0x2e, 0x99, 0xee, 0xfb, 0xab, 0x44, 0x0b, 0xaa, 0x6b, 0x2b, 0x05, 0xa4, 0xb2, 0x3f, 0x8a, 0x9d, 0x4d, 0x18, 0xf0, 0x84, 0x2e, 0xe8, 0x1c, 0xa2, 0x97, 0x4b, 0xc6, 0xaa, 0xa3, 0xeb, 0x3d, 0x65, 0xbb, 0x1f, 0x5f, 0xa5, 0x23, 0x6f, 0x8b, 0x63, 0xd0, 0xf8, 0x8c, 0xa1, 0x6a, 0xb5, 0x7c, 0x5f, 0x15, 0xa0, 0x3a, 0xf2, 0xe5, 0x50, 0x58, 0x34, 0xed, 0x72, 0x3c, 0x52, 0xf1, 0x6e, 0x36, 0x09, 0x4f, 0xef, 0x68, 0xb6, 0x8f, 0x27, 0x54, 0xe6, 0x57, 0x7a, 0xc7, 0xe3, 0xc3, 0xbc, 0x88, 0x2b, 0xf3, 0x85, 0xfa, 0x9e, 0x29, 0xa3, 0x8a, 0xe4, 0xd0, 0xf8, 0xae, 0xec, 0x96, 0x07, 0x75, 0xe4, 0x6e, 0x50, 0x2a, 0xd0, 0x88, 0xdb, 0x21, 0x4f, 0x79, 0xb5, 0xea, 0x16, 0xfb, 0xac, 0x4a, 0x65, 0xee, 0xea, 0x9e, 0xd0, 0x5b, 0x9a, 0xeb, 0x5b, 0xb2, 0x1b, 0xa5, 0x2e, 0x17, 0xd1, 0x9e, 0x34, 0x9c, 0x94, 0xc3, 0xc7, 0x5b, 0x7a, 0xbc, 0xd0, 0xfc, 0xc8, 0x2a, 0x03, 0xd9, 0xe0, 0x85, 0x7c, 0xc6, 0x16, 0x0c, 0x5e, 0x6e, 0xff, 0x33, 0x5d, 0xec, 0x2f, 0xd8, 0x52, 0x90, 0x63, 0x1c, 0x8b, 0x03, 0x1e, 0xaa, 0x69, 0xe1, 0x7b, 0xe0, 0xc8, 0x37, 0x67, 0xc4, 0xe5, 0x69, 0x34, 0x54, 0xb5, 0x36, 0x80, 0x58, 0x57, 0x31, 0x13, 0x2b, 0xe5, 0xb7, 0x5c, 0xa2, 0xfd, 0xf7, 0x7d, 0xce, 0x4a, 0x1c, 0xb8, 0x89, 0x4e, 0xda, 0x63, 0x77, 0xde, 0x6a, 0x7b, 0x56, 0x90, 0x85, 0x84, 0x84, 0x81, 0x71, 0x09, 0xca, 0x0e, 0x0e, 0xa6, 0x7a, 0x20, 0xcd, 0xbd, 0xcb, 0xcc, 0x9e, 0xc6, 0x10, 0x27, 0x6c, 0x98, 0xf1, 0xe1, 0xeb, 0xbd, 0xc6, 0x93, 0x80, 0x86, 0x6f, 0xfe, 0xbc, 0x49, 0x4c, 0x71, 0xb2, 0x61, 0x90, 0x21, 0x3b, 0x1b, 0xd2, 0x92, 0x08, 0xc8, 0x83, 0x04, 0x73, 0x34, 0xe9, 0xc1, 0x03, 0x81, 0x12, 0xb9, 0x17, 0x32, 0x4c, 0xe5, 0xdb, 0xa7, 0x38, 0x96, 0xef, 0xa5, 0x59, 0xfe, 0x97, 0xf8, 0x2f, 0x82, 0xf4, 0xf7, 0x76, 0x4d, 0x1d, 0xb0, 0xd7, 0x2e, 0x31, 0x94, 0xf7, 0x80, 0x21, 0x40, 0xab, 0xc6, 0xa2, 0x89, 0xba, 0xb1, 0x8e, 0xb7, 0x9e, 0xe0, 0x35, 0xb1, 0xa1, 0xcf, 0xa5, 0xa2, 0xf4, 0x02, 0x3b, 0x3a, 0xb1, 0x0a, 0x96, 0xe2, 0x85, 0x35, 0xf8, 0x32, 0xc2, 0x49, 0xc8, 0x52, 0x59, 0x57, 0x24, 0xea, 0xcb, 0x43, 0x57, 0x54, 0x94, 0x62, 0xdf, 0xf7, 0x6a, 0x83, 0x34, 0x6a, 0x47, 0xf5, 0x2f, 0x45, 0xeb, 0x27, 0xf4, 0x65, 0xee, 0x4a, 0x0e, 0x31, 0x76, 0x6f, 0xbc, 0x21, 0x67, 0xe2, 0x3f, 0xd3, 0x3e, 0x28, 0xad, 0x17, 0x55, 0x8b, 0x22, 0x29, 0x31, 0xb2, 0x22, 0x44, 0xff, 0x3e, 0xe5, 0x54, 0xcd, 0x01, 0x77, 0xed, 0x37, 0x74, 0x54, 0xe1, 0xaf, 0x32, 0x6e, 0x8e, 0x41, 0x56, 0xf8, 0x18, 0x89, 0x00, 0x44, 0xa7, 0xa2, 0x45, 0xf1, 0x90, 0x0d, 0xec, 0xe9, 0x1e, 0x6f, 0xda, 0x9f, 0x95, 0x9f, 0x32, 0x1c, 0x13, 0xa0, 0xed, 0x76, 0xcf, 0xa0, 0x83, 0x1a, 0x48, 0x9f, 0xf2, 0xf6, 0x4e, 0xe5, 0x00, 0xa2, 0x07, 0xc3, 0xf1, 0x68, 0xe4, 0x45, 0x61, 0x75, 0xce, 0xd4, 0xd1, 0xa2, 0x58, 0x02, 0x92, 0xce, 0x19, 0x90, 0xd5, 0xf4, 0x38, 0x09, 0xd9, 0x94, 0x5f, 0xc3, 0x77, 0xc4, 0xf8, 0xd3, 0x1f, 0x6e, 0x8d, 0x03, 0x94, 0x7f, 0xab, 0xf9, 0xc7, 0x16, 0x9b, 0xeb, 0xa4, 0xca, 0x1e, 0xc1, 0x21, 0xa2, 0xa2, 0xef, 0x71, 0x3a, 0x8c, 0x72, 0xe3, 0xfb, 0xa7, 0x35, 0x54, 0x2e, 0xcb, 0x45, 0x47, 0xee, 0xad, 0xe8, 0x02, 0x06, 0x4d, 0x28, 0x8e, 0xd5, 0x09, 0x4c, 0x1c, 0xb8, 0xf1, 0xdc, 0x3f, 0xe0, 0x11, 0xc0, 0xc6, 0xfa, 0x32, 0x7a, 0x48, 0x53, 0x5e, 0x43, 0x5c, 0xf5, 0xd7, 0x89, 0xb8, 0xd4, 0xff, 0x2f, 0x5f, 0x4d, 0x32, 0xc8, 0xfa, 0xf6, 0x30, 0x3c, 0x9b, 0x2a, 0x38, 0x60, 0x2a, 0xf8, 0x9a, 0xbf, 0xd2, 0xe3, 0x6b, 0xdf, 0x99, 0x02, 0xa1, 0x13, 0x05, 0x52, 0x9e, 0x0a, 0xc7, 0x8d, 0xb6, 0x9b, 0x3a, 0xb7, 0xb7, 0x92, 0x72, 0xd1, 0x2f, 0x13, 0xcd, 0xe6, 0x74, 0xe4, 0x14, 0x8c, 0x83, 0x93, 0xdb, 0xca, 0x5c, 0xf5, 0x2a, 0x14, 0x9a, 0x5f, 0x6d, 0x0b, 0x27, 0x99, 0xc7, 0x2b, 0x90, 0x5f, 0x4d, 0xca, 0xe6, 0xcb, 0x61, 0x32, 0x4e, 0x6f, 0xcb, 0x5a, 0xaf, 0x96, 0x71, 0x1a, 0x16, 0xd7, 0x94, 0xfa, 0x77, 0x1d, 0xbe, 0x36, 0x2b, 0x84, 0x7a, 0xc0, 0xb6, 0x53, 0x77, 0x88, 0xff, 0x5d, 0xbc, 0x7c, 0x55, 0x15, 0x18, 0x0c, 0x02, 0x81, 0x7a, 0x49, 0x13, 0xdb, 0x7e, 0x4a, 0x25, 0x83, 0x37, 0x0e, 0x6f, 0x4f, 0x2a, 0xe7, 0xa4, 0xac, 0x07, 0x75, 0x84, 0x0f, 0x61, 0x64, 0x2d, 0xe6, 0x1c, 0x11, 0x37, 0xcf, 0xa5, 0x26, 0xde, 0xde, 0x45, 0x57, 0x8e, 0xf1, 0x78, 0x1a, 0xaf, 0x82, 0x81, 0xe6, 0x68, 0x03, 0xc3, 0x46, 0xe0, 0xb5, 0xa9, 0xd8, 0x74, 0xb6, 0x76, 0x83, 0xa7, 0x47, 0x06, 0xb5, 0xc1, 0x53, 0x4c, 0x69, 0x74, 0xcd, 0xd5, 0x6b, 0x7c, 0xfa, 0x2c, 0xb0, 0xac, 0x48, 0xa9, 0xc6, 0x98, 0x6a, 0x95, 0x33, 0x74, 0xe2, 0x99, 0x53, 0xfe, 0xe9, 0x84, 0x8a, 0x3d, 0x33, 0x2d, 0x8e, 0x50, 0x7d, 0xd3, 0x13, 0x70, 0x79, 0x8b, 0x92, 0x7b, 0x1c, 0xdc, 0x6f, 0x9e, 0x19, 0xa3, 0xd7, 0xd7, 0xde, 0xe6, 0x81, 0x01, 0x8f, 0x52, 0x3a, 0xec, 0x4f, 0xd5, 0x64, 0x8c, 0x7d, 0x45, 0xae, 0x8f, 0xff, 0x86, 0x5b, 0x68, 0xe5, 0xf8, 0x30, 0x8b, 0xd9, 0x76, 0x72, 0xc7, 0x8c, 0xb3, 0x59, 0xa7, 0xbf, 0x84, 0xe2, 0x0c, 0x92, 0xf0, 0x33, 0xc5, 0x04, 0xb3, 0xd7, 0xda, 0xb5, 0xad, 0x13, 0x9d, 0xfc, 0xad, 0x30, 0x2b, 0x69, 0x82, 0x60, 0x80, 0xd1, 0xe7, 0xdb, 0x77, 0xc0, 0x71, 0xcf, 0xe9, 0x11, 0x9c, 0x58, 0xb1, 0xd2, 0x69, 0x9c, 0xae, 0xbb, 0xca, 0xb1, 0xd8, 0x15, 0x56, 0xe0, 0x41, 0xab, 0x85, 0x32, 0x63, 0x07, 0x13, 0x16, 0x33, 0x34, 0xf5, 0x40, 0x69, 0x1e, 0xae, 0x64, 0x58, 0xbb, 0x58, 0x73, 0x23, 0x48, 0x46, 0x57, 0x24, 0xd6, 0xda, 0x31, 0x57, 0xf4, 0xcc, 0xd3, 0xca, 0x95, 0x43, 0xe2, 0xb0, 0xcc, 0x85, 0x57, 0xda, 0x4b, 0x9c, 0xd3, 0xef, 0xaa, 0x4b, 0xa2, 0x6d, 0xd6, 0xdd, 0x5c, 0xb6, 0x40, 0xa8, 0x1a, 0x87, 0x35, 0x11, 0x56, 0x6f, 0x88, 0x56, 0xe4, 0x7c, 0x78, 0x92, 0x7d, 0xe4, 0x82, 0x26, 0x98, 0xc8, 0x33, 0xad, 0x46, 0x3e, 0x3f, 0x58, 0xb0, 0x00, 0x3c, 0x6c, 0x25, 0x6d, 0xae, 0x49, 0xa5, 0x77, 0x51, 0x7b, 0x1d, 0x5b, 0x0c, 0x3f, 0xbf, 0xf8, 0xf9, 0x0f, 0x9f, 0x8e, 0xd0, 0x9c, 0xfd, 0x04, 0xa4, 0x7d, 0xbc, 0xe1, 0xff, 0xad, 0x18, 0xe7, 0x54, 0xe0, 0x7e, 0x74, 0x8e, 0x1a, 0x5c, 0x26, 0x3e, 0x37, 0xb2, 0xd6, 0x1f, 0x7b, 0xac, 0x30, 0x89, 0xa1, 0x51, 0xd9, 0x6b, 0x9c, 0xdb, 0x15, 0x1c, 0xef, 0x06, 0x67, 0x71, 0xa8, 0xf4, 0xa0, 0xa7, 0xd7, 0xf1, 0xc2, 0x88, 0x0d, 0xae, 0x6b, 0xa0, 0x38, 0x18, 0xef, 0x29, 0xe2, 0xe0, 0x50, 0xc5, 0xe7, 0xaa, 0x80, 0x2b, 0x1c, 0x87, 0x52, 0x1f, 0x7d, 0x0f, 0x6b, 0xca, 0x87, 0xbd, 0x62, 0xc5, 0x43, 0x9e, 0xf4, 0x91, 0x4d, 0xf7, 0xc1, 0x2c, 0xae, 0x14, 0x15, 0x2d, 0xd4, 0x0d, 0x63, 0x1b, 0xa4, 0x49, 0xba, 0xb9, 0x6b, 0x17, 0x0f, 0x7b, 0x9b, 0x7b, 0xc1, 0xcd, 0xae, 0xe8, 0x4b, 0x0b, 0x87, 0xd4, 0x24, 0x0b, 0xe8, 0xfa, 0x9e, 0x50, 0x14, 0x6f, 0xbc, 0x32, 0x04, 0xcf, 0xd2, 0xfa, 0x04, 0x30, 0xce, 0xfe, 0xf7, 0x16, 0xcf, 0xb7, 0x63, 0x15, 0x10, 0xd3, 0x3d, 0xc1, 0x8c, 0xd8, 0xbb, 0xe7, 0x0f, 0x77, 0x15, 0x39, 0xf4, 0xd5, 0x16, 0xb9, 0x58, 0x82, 0xcb, 0xac, 0x69, 0x3b, 0xf8, 0x65, 0xd0, 0xb4, 0x00, 0xa7, 0xc8, 0xcc, 0x09, 0x2e, 0x4c, 0x5b, 0x05, 0x0d, 0xef, 0x15, 0x57, 0xbb, 0xfd, 0xe2, 0x54, 0xf9, 0x8c, 0xd2, 0x12, 0x80, 0xaa, 0x75, 0x4f, 0x08, 0xb6, 0x52, 0x1a, 0x03, 0x34, 0x6f, 0xf9, 0x15, 0x97, 0x5c, 0x4a, 0x44, 0xfd, 0xf4, 0x01, 0x31, 0x42, 0x2f, 0x49, 0x0c, 0x36, 0x6c, 0x69, 0xc2, 0x58, 0xe9, 0x74, 0xd0, 0x8c, 0x8f, 0x87, 0x08, 0x34, 0xa2, 0x20, 0x38, 0xc7, 0x07, 0x23, 0x56, 0x78, 0x53, 0x31, 0x10, 0x0b, 0x44, 0xfd, 0x19, 0xb4, 0xa2, 0x8e, 0x61, 0xba, 0x69, 0x9e, 0x56, 0xe7, 0x7e, 0x16, 0x65, 0xa8, 0x7d, 0xab, 0x34, 0xe6, 0x5e, 0x2b, 0x39, 0xe9, 0xfe, 0xa0, 0x16, 0xda, 0x45, 0x9a, 0x3e, 0x08, 0xeb, 0x32, 0x3c, 0xaa, 0x48, 0x2f, 0x82, 0x1e, 0x36, 0xc8, 0xa7, 0x32, 0x6f, 0x2c, 0xca, 0x70, 0x5c, 0xf8, 0x60, 0xa6, 0x63, 0x45, 0x25, 0xb7, 0x71, 0x09, 0x0f, 0x3a, 0x52, 0x4d, 0x25, 0x2b, 0x43, 0xd6, 0xc2, 0x9c, 0x9c, 0xb0, 0x72, 0xf7, 0x3b, 0x60, 0x57, 0x07, 0x34, 0x7f, 0x9b, 0x99, 0x10, 0xdc, 0xed, 0x1a, 0xa0, 0x40, 0x36, 0x0e, 0xa8, 0xdc, 0xc7, 0x17, 0xa2, 0x0f, 0xae, 0x95, 0x3f, 0xeb, 0x59, 0xe5, 0x4c, 0x19, 0x8f, 0x46, 0xb9, 0x16, 0xe0, 0xe9, 0x5a, 0x83, 0x80, 0x83, 0x15, 0x02, 0xa7, 0xb7, 0xa4, 0xac, 0xb7, 0xc6, 0x59, 0x6c, 0x6a, 0xd1, 0x6f, 0xaf, 0x62, 0x3c, 0xed, 0xc4, 0x0e, 0x6b, 0x60, 0x4f, 0x86, 0xe0, 0xbe, 0x04, 0x7a, 0xa4, 0x44, 0x49, 0xac, 0xc0, 0xec, 0xb9, 0x69, 0x13, 0x35, 0x6a, 0xb8, 0x79, 0xcc, 0x25, 0xb2, 0x09, 0x93, 0x7c, 0xc7, 0xdd, 0x51, 0x9f, 0xab, 0xc8, 0xe7, 0xc8, 0x60, 0xfd, 0x06, 0xff, 0xb8, 0x6d, 0x33, 0x1b, 0x0f, 0xbd, 0x54, 0x0a, 0xb6, 0x6b, 0x5d, 0x14, 0x00, 0x57, 0x10, 0x56, 0x9a, 0xd1, 0x76, 0x6f, 0xcb, 0x28, 0x00, 0x97, 0x8c, 0xa6, 0x55, 0x4b, 0x21, 0x6a, 0x32, 0x4f, 0x33, 0x7c, 0xfb, 0x80, 0x5b, 0x4c, 0x5f, 0x78, 0xdd, 0xd4, 0x81, 0x93, 0x63, 0x2c, 0x42, 0x54, 0xf0, 0xa1, 0x62, 0x9f, 0xbe, 0x27, 0xb1, 0xb5, 0x06, 0x31, 0x74, 0x5f, 0xac, 0x94, 0x70, 0xf5, 0x93, 0x71, 0x0b, 0x5a, 0x71, 0xbe, 0x6b, 0xcf, 0x07, 0xa5, 0xd3, 0x09, 0x71, 0xca, 0x5a, 0xf8, 0xb3, 0x3e, 0x79, 0x15, 0x57, 0x3c, 0xc3, 0x94, 0xb5, 0x91, 0xfa, 0x80, 0xd1, 0xd2, 0x54, 0x70, 0xfd, 0x1b, 0x22, 0xc2, 0x41, 0x03, 0x08, 0xbc, 0x12, 0xcf, 0x00, 0x6a, 0x89, 0x09, 0x99, 0x4c, 0x4d, 0xd7, 0x7d, 0xe0, 0x1e, 0x93, 0xdd, 0xbc, 0x49, 0xb4, 0x05, 0xa0, 0xf9, 0x6a, 0x04, 0x57, 0x2c, 0xb6, 0x76, 0x8c, 0xa6, 0xf1, 0xd7, 0x3a, 0x74, 0x7f, 0xc5, 0xd0, 0xdf, 0x0a, 0x80, 0xc2, 0xb4, 0x59, 0x8f, 0x97, 0xc5, 0x11, 0x31, 0xce, 0xef, 0x19, 0x4f, 0x16, 0x07, 0xe7, 0xd9, 0x1e, 0x60, 0x7e, 0xe2, 0x03, 0x20, 0xea, 0x06, 0xa0, 0x65, 0x24, 0x3c, 0xa6, 0x38, 0xad, 0xd8, 0x3f, 0x80, 0x8f, 0xe9, 0x75, 0x1d, 0xf7, 0x7f, 0x21, 0xb8, 0x17, 0x8c, 0x9a, 0xb7, 0x4a, 0x67, 0x1c, 0x62, 0x99, 0x9e, 0x2f, 0x0a, 0x16, 0x4d, 0x66, 0x89, 0x5d, 0xc6, 0xdf, 0xa8, 0xd2, 0xb6, 0xd6 },
        .hmac_key_idx = 0,
        // results of message array encrypted with these keys
        .expected_results = {
        // Message 0
      { 0xde003a9e, 0x5082b9e6, 0xb67bd658, 0x0c4ad8e6, 0x97c751e8, 0x5f98ea52, 0x89928d3c, 0x6ab0de91, 0x360fc47d, 0x2df0fe90, 0xb1535d85, 0x1d806b81, 0xa5eea593, 0xb69b2fd5, 0x3c428ec9, 0xdff8913b, 0x982dbe8a, 0x4ced42e1, 0x4d0b86b0, 0x44748e21, 0x1cfbfe7c, 0xad6ad139, 0xb14119d3, 0xf91aef00, 0x2f90f1a0, 0x3539acc8, 0x7738f0b3, 0xbb3cc743, 0x984c5ac3, 0x9da71361, 0xed53ac65, 0x52f33589 },        // Message 1
      { 0x23ade72c, 0xf4c55443, 0xfcc9591d, 0x7c379760, 0x55be7ec6, 0x423b1a83, 0x6e0df572, 0xd493a2c6, 0xfe89357a, 0x6f430d14, 0x36ddf6b2, 0xcb6ac4ff, 0x59b17f4f, 0x5c47e3b3, 0x74031f1e, 0x3ff80c3d, 0xb52db8d9, 0x90c1f4fd, 0x9d893694, 0xfb22ccf9, 0xa6746b2e, 0xf3f00e83, 0x90fff3d3, 0x6e4d17f8, 0x7a643c48, 0x6457d143, 0x2f82251b, 0x4bf5bc6a, 0xc055a5fe, 0x4c10dc93, 0xdddd8bcb, 0x36306a9c },        // Message 2
      { 0x2d30e890, 0x9f533bb7, 0x41e8601b, 0x5c7e6745, 0x7bc9c682, 0x7074beb6, 0x58cdeb05, 0x187fd5fd, 0xbd36f0b1, 0xa245c520, 0x042eea7d, 0x1f67a5c8, 0xc37102c2, 0xf514d2c4, 0x7795b1e9, 0xa5405d8e, 0xd07590fc, 0x57552f51, 0x8bafa16c, 0xe767e51a, 0x0def3958, 0x160b63f1, 0x1762faf6, 0xed203454, 0x6a407754, 0x7d01a06d, 0x2d07dcaa, 0xfacd2494, 0x05adda9f, 0xf3c2ae4f, 0x667a7217, 0x4db5664c },        // Message 3
      { 0x723719dc, 0x6d897ce8, 0x6c7982f9, 0x3ac96ead, 0xd969c7df, 0xa45e9956, 0x8781bbb0, 0x92067869, 0x9be3aa16, 0xcdbf1867, 0xc880c370, 0xc2d8d73f, 0xdd6cb152, 0x0781f6b8, 0x3037b9b1, 0x41ef7688, 0xb3babe3b, 0x507dd8af, 0x9501e8cb, 0x441c1e4e, 0xac056062, 0x7809cd29, 0xb00a7b35, 0xd4637aee, 0x61ad5100, 0xbb5436a2, 0x07426f79, 0xcfda71cb, 0x0ea45b9a, 0x3edabe23, 0x4b3272e8, 0x28db2b68 },        // Message 4
      { 0xeeb0ffe6, 0x4d74f9a2, 0xd7532487, 0xf13a3f45, 0x23badbed, 0xe542317b, 0xdb2ac406, 0x5812228b, 0xfed8773e, 0x804cfa28, 0xc903067f, 0x2af8b223, 0x310a6cac, 0xd65175be, 0xd937b207, 0x8fdd9b68, 0x2c219d1a, 0xe90e05b1, 0xfd98e248, 0x997dfa37, 0x7f4de7eb, 0xa9054525, 0xcd5f9b18, 0xcff0ef92, 0x27e7cf59, 0x72e64b8d, 0xe5ee8bc0, 0x28d40904, 0x09bcc460, 0xf48339f8, 0xf747aba6, 0x9c63eba7 },        // Message 5
      { 0x50151d80, 0xb8de0791, 0xe067da0d, 0xbfc0982b, 0x9b683788, 0x4d4f59f8, 0x1c0612c1, 0x76657cbb, 0x13f81d2d, 0xb5fee19b, 0x3ae18482, 0x3cc3af02, 0x969ba738, 0x9745888f, 0xd821402f, 0xf8606499, 0xbe873170, 0x638a74dc, 0xfc775c4a, 0xd66e4e8f, 0x9f67609e, 0xa09663d8, 0xab77763c, 0x58dc0d9a, 0x2bf376cd, 0x7e452b26, 0xce91be52, 0xae3132f5, 0x37a4c7ea, 0x543e3285, 0xe1f456b8, 0x4920c464 },        // Message 6
      { 0x505a742c, 0x522198a2, 0x9d66b70a, 0x8a354f88, 0xde7c3d36, 0x984ea2a6, 0x19653760, 0x38f8d533, 0x1a14e1a9, 0xe8996402, 0xe8442336, 0xaeda3af6, 0x4d913ec1, 0x2f5f2b1b, 0xfb006be5, 0xceb5a977, 0xeb6b032d, 0xaea761b3, 0x720d42a5, 0xaa1e4d2c, 0x0b06b2f2, 0xafd7e9e0, 0x9eed5087, 0xec62c666, 0x7ec20e72, 0xeefa3566, 0xb1cd420c, 0xf2c6104c, 0xad93698e, 0x2c33475a, 0xc20543c8, 0x40b3fe77 },        // Message 7
      { 0x2a6f47be, 0x49fe3699, 0xbfa36dbe, 0x21329296, 0xa2cc0b2e, 0x5befb258, 0xaf151f36, 0xbf7ef9f4, 0x9e2b51d6, 0xd6e00c11, 0x28ef8ba6, 0x1fb31f27, 0xd41b261d, 0x03b5e03c, 0xefffefda, 0xcb9d62c6, 0xa574a251, 0x3a681771, 0x628ff6b2, 0xfb58aa9e, 0xc511ea26, 0x59370be2, 0x57ef0756, 0x52ff5477, 0xcfa98692, 0xd79aeac6, 0x1a2de7cb, 0xee43d7bf, 0x35071bde, 0xd6e3902f, 0x4af8d789, 0x885858b2 },        // Message 8
      { 0x9de514f7, 0x8739b510, 0x7d41872d, 0x2dc0a619, 0xf14a8e41, 0xabb7eecd, 0x819b5998, 0xc3bc979d, 0x7222470d, 0x34267466, 0x6e228115, 0xa08d9dd7, 0x41d422c5, 0x63f2cee4, 0xc3c63e5b, 0xcbd138e0, 0xdbd81e36, 0x0fa1f791, 0x94cd0da2, 0x5868ef17, 0x2380ac57, 0x37fa5e08, 0xf7637806, 0xe503195f, 0xc30ebdb2, 0x1eb26761, 0xa6454ef9, 0x68933e71, 0x9588f5e1, 0x7a8d008a, 0x413eab0e, 0x66fd0399 },        // Message 9
      { 0xb53af187, 0x08c0db1d, 0x551db3b9, 0xb74a0a63, 0xc6f94f1f, 0x467b5216, 0x151e8de2, 0x8d60d524, 0x97bb2cb6, 0x146218c6, 0x2cc38dbb, 0x56dd5b6f, 0x8ce5604b, 0x20545ec6, 0xcc83d0ea, 0x89fa1acb, 0x078aa9d5, 0x65fad84b, 0x57d3bfcb, 0x80c0ef82, 0x52f5ff9a, 0xd4050ba0, 0x6f248486, 0x21590ae4, 0x313b367d, 0xfb03fcf4, 0x5d45e056, 0x775e31bd, 0x167149a4, 0x03cac08b, 0x789a08a2, 0xaf284d5d },     },
     },
    { /* Case 4 */
        .iv = { 0x57, 0x8a, 0x40, 0x0d, 0x2a, 0xca, 0x20, 0x2f, 0x9a, 0xc1, 0x2c, 0x55, 0x03, 0xab, 0x90, 0x70 },
        .p_data = {
            .Y = { 0xd68eaea1, 0xca9084f6, 0x18d0284a, 0x83976aa9, 0x03f21081, 0xafc48664, 0x1f37e7da, 0xfcaf2dcb, 0xc0966052, 0xeb7635d3, 0x2fc76b17, 0xa6b6e2f0, 0xa280bf22, 0xd6fbb642, 0xb2fdcca7, 0xf9740d73, 0xe63711a1, 0x07ad39e8, 0x63da15c3, 0x53c8f5b2, 0xcfc5915c, 0x4d7626f9, 0x626af48e, 0x46ebf86a, 0x72b79784, 0x46b52341, 0x80079fcd, 0xe5f089f3, 0xe1b09ce7, 0x64bc0726, 0x5a4b82f4, 0xcd339602, 0x4fb1d236, 0xbde05e48, 0xd4f2df90, 0x10d50279, 0x19c5b6d4, 0xc80b1368, 0xbe225586, 0xe46aaa6a, 0x2e162da2, 0x0136ba4a, 0xbef54279, 0x76405e93, 0xa94b4ca5, 0x097bc5d6, 0xc377a6eb, 0xd2ce8ad3, 0xad5d3c86, 0xaeb87544, 0xf3229af9, 0xcbe333a5, 0x3f445b30, 0x85c7ca8d, 0x765a64ae, 0x9d081466, 0xab21e234, 0x43bda112, 0x427ac3b8, 0x3d9c5540, 0x5ed95b3a, 0xe71790f3, 0x4a757ae5, 0xa3b9a8ea, 0xd1c52761, 0xc4ff7db3, 0xa4b2b728, 0xbcb9376b, 0x5bc8d4d9, 0xffcdb882, 0x77d8a17f, 0x07aee59b, 0xa33dff02, 0x480abd52, 0x7ada963e, 0x8876393b, 0xf02bc923, 0xd2ea012d, 0xd77316cf, 0x723c198d, 0x8603ce7b, 0x886f8011, 0x1f68fd7f, 0x3e3ab7db, 0xaf5b768a, 0x31163ad9, 0x821cff40, 0x11f24fd4, 0xec7931f4, 0xcfc79dcc, 0x3355ba10, 0x1ce51310, 0x9e03b18d, 0x5a9f31f5, 0xfb55885a, 0xb9d17568, 0x84bd80ee, 0x6a6d4785, 0x150e4c30, 0xc2359fa5, 0x7b7eeed6, 0x1afb360b, 0x50d54f30, 0xc059740e, 0xd24ffce7, 0x954b4e2f, 0x865747ee, 0xf28c2a3e, 0x5fd32cab, 0xa2515f56, 0xec4748d6, 0xbdc481f5, 0xca464076, 0x9d0bd509, 0x0b6ea30a, 0x850d4124, 0x619053f8, 0x7d69976b, 0x28e7be78, 0xbc64ccfa, 0x75770f4d, 0xf5acff41, 0xe4c2a624, 0x15aa291e, 0xe06e5ba1, 0xd2e8208f, 0x230f0e06, 0x6b9ab3ca },
            .M = { 0x81a50fa3, 0xe84721e1, 0x365ec92b, 0x846e26b1, 0x23271d42, 0xa920e6b8, 0xbc8b4a8f, 0xc9770a89, 0x906502d7, 0x94ba3702, 0xd7b523b9, 0xf74a8e04, 0xeab37cc9, 0xe0840e66, 0xd34be3b6, 0x0eb548ae, 0x38dbf833, 0xc1a52a98, 0xcd26a4f5, 0xc5ffa555, 0xa87ef6ea, 0x37b7b2cb, 0x4b1d8870, 0x1b8e9625, 0x81197593, 0x37d7df70, 0x86620a90, 0x0470314a, 0xc21139bc, 0xf424b97b, 0x67a23769, 0xd0cddb47, 0xb6d89639, 0x583f6174, 0x4d809567, 0x77f98178, 0x8a1de928, 0x4d970bd0, 0x665da868, 0x59574054, 0xe73c0afc, 0x44437c68, 0x205b1633, 0x9ffc6ae1, 0x551a907b, 0xa6ab5bb3, 0x8af6e6a5, 0x16fff585, 0x6e0ff8b1, 0x22adcf0f, 0x6a73e921, 0x410a3ece, 0x75d202b1, 0xd88ebada, 0x97626bd4, 0xa550bd23, 0xfbab5726, 0x32d6e9ca, 0xd2e33436, 0x5eb4454d, 0xd139c461, 0x8021b738, 0x4a337790, 0xc544f64d, 0xdfad9082, 0xc9a665f7, 0x5a6eeb48, 0x5e599808, 0x3e7499cb, 0x464028c3, 0x1d465976, 0xbc1cb718, 0x90c7b79c, 0x768cb0a0, 0x55a3dfa6, 0xe0dbeeaf, 0x28783dad, 0xe7b7f6cf, 0xb4d218d8, 0xd3d43581, 0xc7e4babf, 0xd7c2284b, 0xae991ef5, 0xb02bf055, 0x310c4a9d, 0x28fea7a1, 0xb21144ac, 0x55eece99, 0x11e3678e, 0x8d420d9d, 0x7f6880c3, 0x7f719a40, 0xf3a62ca5, 0x856d3dc6, 0x5e34813b, 0x7b5252be, 0x339689b5, 0x0ecdcf83, 0x826b1dfd, 0x4431aaf0, 0x234c4a13, 0x41f6aaf9, 0x74db83fe, 0x64f5ed55, 0x6525ae9f, 0x9471cb98, 0x69510f51, 0xf4d2d80f, 0xf85fd3a9, 0x80d76415, 0x27f754aa, 0x970ab8f9, 0xc1485504, 0x17a5e4e2, 0xbe712051, 0x8e4b55e7, 0xc0d5943f, 0x1b7be14c, 0x10e144cd, 0x7c6cea60, 0xdc677a72, 0x68a60e23, 0x563ea9bc, 0x02e84e65, 0xe2011f47, 0x35fad1ee, 0xdc2a5d41, 0xba275daf },
            .Rb = { 0xb260bc33, 0xe82f99f7, 0x67bf49c8, 0xe7050bb8, 0x4d1cdab0, 0x9fbb73a0, 0xa057d9f2, 0xec17c7eb, 0x117c3a9b, 0x08f531d4, 0xd6fdab88, 0x5aa4ca83, 0xd64eda4d, 0xa32482b0, 0x6d1756fb, 0x317db9ba, 0x9641ac16, 0x5b6a0e9c, 0xec0908e5, 0x21ec7ad2, 0x30396cbd, 0x5c8a3501, 0xb90c759c, 0x03ae2c0f, 0xab36e114, 0x57454b8c, 0x46dededd, 0x0fa2c8a4, 0x6df3b1ab, 0xedc23adf, 0x8dd8e394, 0xc2835db0, 0xa8d5109d, 0xd7a7592b, 0x28f05524, 0x84adddf4, 0xb3339b10, 0x97e506ae, 0x3f576bb3, 0x593eb118, 0x1a877cc9, 0xc8e9a841, 0xdda7547d, 0xcecdee15, 0xd8b47b12, 0x87c322cb, 0x226f72ac, 0x45e73550, 0x3c657e7d, 0x48ff109b, 0xe3eef8d4, 0x2de83271, 0x590c1676, 0x0c3f66ce, 0x5622fa74, 0x351591d7, 0x017f0f07, 0x03403fe6, 0xfdfaea32, 0x62d535b4, 0xc8289782, 0x8b65883a, 0x05a4231b, 0x6cc423c5, 0x9936311e, 0xcdead19b, 0xe1ffdf04, 0xd931824d, 0xc4308262, 0xd6788e55, 0xd786bc1c, 0x34b96160, 0x3c538968, 0x5dcb3c09, 0x63aea046, 0x0f3ac0e0, 0x55b56efc, 0x2cc00bce, 0x46246ebd, 0x827a9e44, 0x3ad05ac8, 0xb9d952ca, 0xd2a3b527, 0x9a7dcabd, 0xda1c1e36, 0x920fabaa, 0xf54d02f8, 0x5e2788d7, 0xada7f1db, 0x10e08905, 0x9dc4ce12, 0x4e554cad, 0x1471d01c, 0x8dba83dc, 0x8b9fcddc, 0x2ba120f0, 0x77a49be6, 0x6d42a829, 0x9a0485e5, 0x95649ef6, 0x645c087c, 0xde81b14f, 0xb5bb6675, 0x9866dc54, 0x9ca500cc, 0x92a96b2a, 0x5eaaef8c, 0x56eee4cc, 0x721874aa, 0xb53b97fa, 0x72e524a3, 0xf8c4d9a4, 0x960b1f94, 0xd97b91b2, 0x882ee24c, 0xe631936c, 0xe228c64a, 0x76e1daa1, 0x67d13fe5, 0xffe26933, 0x7a8becfe, 0x1a483f83, 0x704cc2bd, 0x4438a1ea, 0x51b0e2a3, 0x359fd430, 0x27406ad9, 0x5698874d },
            .M_prime = 0x97d463f5,
            .length = ESP_DS_RSA_4096,
        },
        .expected_c = { 0x90, 0x6d, 0xf8, 0x13, 0x1b, 0x3d, 0xd9, 0x9d, 0x2b, 0xf1, 0x48, 0xa4, 0xbd, 0x0e, 0xf9, 0x48, 0xae, 0x0f, 0x3e, 0x38, 0x7b, 0x0a, 0x31, 0x60, 0xca, 0x64, 0x02, 0xcc, 0x7d, 0x07, 0xe6, 0x9f, 0x62, 0x6a, 0x09, 0xaa, 0xdb, 0x5c, 0x24, 0xa9, 0x30, 0x63, 0x84, 0xcb, 0xc6, 0x60, 0x40, 0x63, 0xa3, 0x7a, 0x3a, 0x42, 0xf5, 0xb0, 0xb2, 0x35, 0xb7, 0xed, 0x7a, 0xcb, 0xcd, 0xfa, 0xfc, 0xc2, 0xbf, 0xce, 0xa7, 0x72, 0x2f, 0x15, 0xb3, 0x91, 0xb3, 0xcb, 0xec, 0x43, 0x37, 0x51, 0x0a, 0xde, 0x99, 0xed, 0x94, 0xfd, 0xdb, 0x72, 0x21, 0x48, 0xe2, 0x79, 0x2d, 0x94, 0xaf, 0xae, 0x1d, 0x85, 0xa4, 0x8e, 0xe0, 0xdc, 0xb1, 0x91, 0x51, 0x76, 0x1a, 0xb1, 0x0b, 0x85, 0x44, 0x08, 0xa7, 0x3f, 0x84, 0xaa, 0x58, 0xec, 0x4c, 0xd5, 0x8b, 0x62, 0xfb, 0x8b, 0xe8, 0xdc, 0x53, 0x56, 0x50, 0x30, 0x33, 0xc2, 0x7b, 0x7a, 0xd9, 0x76, 0xd6, 0x9f, 0x2e, 0x39, 0x87, 0xe1, 0x6d, 0xd0, 0x6b, 0xe4, 0xf4, 0x2e, 0xc9, 0x26, 0x68, 0x60, 0x73, 0x9b, 0x94, 0x4a, 0x63, 0x77, 0x98, 0x79, 0xe9, 0xa8, 0x8d, 0x3d, 0xf8, 0x6e, 0x95, 0xad, 0xc3, 0xd0, 0x99, 0x18, 0xd8, 0x3b, 0x9d, 0xfe, 0x0c, 0x42, 0x99, 0x00, 0x2e, 0xe4, 0x9e, 0x60, 0x7f, 0x06, 0x29, 0x8b, 0xc2, 0x9d, 0x75, 0x5d, 0xcf, 0xaa, 0x28, 0xd3, 0x0a, 0x3f, 0x38, 0x9f, 0xa2, 0x47, 0x10, 0x5e, 0xfc, 0xff, 0x50, 0xec, 0x73, 0x66, 0x14, 0x60, 0xd4, 0x0e, 0xd9, 0xaf, 0xb4, 0x26, 0x13, 0x47, 0x5a, 0xf3, 0x26, 0x24, 0x86, 0x55, 0x35, 0x56, 0x47, 0xe1, 0x85, 0x0e, 0xa6, 0x94, 0x51, 0xab, 0x55, 0xa1, 0xbe, 0x6e, 0x05, 0x55, 0x4d, 0x51, 0xf7, 0x2b, 0x5a, 0x60, 0x54, 0x9f, 0x24, 0xf6, 0x7d, 0x8d, 0xe8, 0xc8, 0x30, 0x21, 0x84, 0x57, 0xa6, 0x9f, 0x53, 0x20, 0x78, 0xe8, 0xbe, 0xfa, 0xa2, 0xda, 0xc8, 0x50, 0x3f, 0xc1, 0xf0, 0xee, 0x76, 0x14, 0x49, 0x12, 0x9c, 0x24, 0x76, 0x68, 0x5e, 0x6e, 0xa6, 0xa9, 0xfa, 0x82, 0x06, 0x31, 0xc0, 0x84, 0x35, 0x10, 0xa6, 0x6c, 0x37, 0xa8, 0x76, 0x4f, 0xa2, 0x02, 0xaa, 0x47, 0xf2, 0x66, 0x45, 0xf8, 0x2e, 0x03, 0xab, 0xb2, 0x7a, 0xee, 0xd8, 0x3a, 0x5f, 0xc5, 0xaa, 0x27, 0x80, 0x7a, 0xfb, 0xc2, 0x1d, 0xfa, 0x97, 0xc3, 0x7e, 0x4c, 0x9f, 0xca, 0x01, 0xe1, 0x4f, 0xd5, 0x20, 0x06, 0x9a, 0xeb, 0xd3, 0x55, 0xe4, 0x66, 0xfc, 0xc1, 0x8a, 0x48, 0xc8, 0x84, 0x9c, 0x11, 0x34, 0x02, 0x9c, 0x90, 0x40, 0x44, 0xe7, 0x28, 0xd7, 0xfb, 0xa5, 0x82, 0xa3, 0x3f, 0xfe, 0x36, 0x24, 0x85, 0x8d, 0x9f, 0xaf, 0x4a, 0x8c, 0xfd, 0x37, 0x96, 0xc7, 0xfe, 0x9f, 0xc4, 0xd6, 0x6a, 0xc0, 0xb6, 0x2d, 0xe2, 0xf8, 0x11, 0xff, 0x92, 0x7d, 0x2d, 0x9f, 0xda, 0x9a, 0x96, 0x41, 0x4e, 0xcf, 0xb2, 0xff, 0x63, 0xd7, 0x5d, 0x56, 0x5e, 0xc0, 0xbf, 0x6c, 0x6f, 0x44, 0x87, 0x7e, 0x4a, 0xdd, 0xa3, 0xcf, 0x4a, 0x01, 0x96, 0x95, 0xe2, 0xf8, 0x57, 0x3c, 0xf7, 0xb8, 0x38, 0x9d, 0xd5, 0x3c, 0xa2, 0xbf, 0x43, 0xb0, 0x39, 0xe7, 0xe3, 0xf2, 0x76, 0x6e, 0xd8, 0x83, 0x0a, 0x75, 0x27, 0xf8, 0x05, 0xc1, 0x3d, 0x48, 0xf8, 0x61, 0x65, 0x8f, 0x32, 0x50, 0xb6, 0x3e, 0x04, 0x88, 0x66, 0xbb, 0x13, 0x8c, 0xad, 0x07, 0x19, 0xb6, 0xe7, 0x15, 0x51, 0xd6, 0x07, 0x14, 0x7a, 0x42, 0x0e, 0x97, 0xc6, 0x56, 0x19, 0x78, 0x33, 0xee, 0x21, 0x05, 0x0d, 0xb8, 0xae, 0x3a, 0x43, 0xc6, 0xee, 0x70, 0x1b, 0xf3, 0x36, 0xe5, 0xa6, 0x3f, 0xa7, 0x02, 0x34, 0x9f, 0xa2, 0x32, 0x79, 0x53, 0x10, 0x0a, 0x9b, 0xf9, 0x82, 0x9f, 0x34, 0x91, 0x6a, 0x46, 0x12, 0x5d, 0x5f, 0xcf, 0x6b, 0x99, 0x19, 0xa7, 0x4c, 0x1a, 0xed, 0x9c, 0x48, 0x76, 0xe8, 0x09, 0xc9, 0xe3, 0x6f, 0x1c, 0x97, 0x8a, 0x4a, 0xf2, 0xb9, 0x89, 0x2c, 0x07, 0xb3, 0x0d, 0xfd, 0x08, 0xe5, 0x37, 0x6d, 0x41, 0x0a, 0x5a, 0xc1, 0x2d, 0x92, 0xbd, 0x67, 0xd4, 0x0a, 0xf3, 0x2f, 0x67, 0x0a, 0x4e, 0xe3, 0x0a, 0x35, 0xcd, 0x12, 0x7f, 0xb4, 0xfa, 0x6c, 0x68, 0xc5, 0xa8, 0xa2, 0x93, 0x6f, 0x9d, 0xd4, 0xf8, 0x5a, 0x98, 0x37, 0xcf, 0x64, 0x75, 0x3b, 0x7e, 0x5a, 0x93, 0x09, 0x8b, 0x51, 0x99, 0x95, 0x81, 0xe7, 0xb4, 0x05, 0x48, 0x88, 0x2c, 0x6d, 0x4b, 0x38, 0x50, 0x94, 0xdd, 0x66, 0x58, 0x36, 0x0c, 0x0f, 0xc5, 0xe3, 0x4d, 0xb9, 0xcd, 0x2a, 0x50, 0xef, 0xe8, 0x11, 0x1c, 0x98, 0xda, 0xc2, 0x15, 0xd6, 0x8d, 0xde, 0x07, 0xfb, 0xf0, 0xbb, 0x14, 0xad, 0x0d, 0xa2, 0x5d, 0x34, 0x0b, 0x82, 0x7d, 0x03, 0x7f, 0xaf, 0x30, 0x5a, 0x07, 0x0d, 0x1b, 0xea, 0x4d, 0x75, 0xb2, 0xfd, 0x4a, 0x3f, 0x3b, 0x1a, 0x14, 0xda, 0xa9, 0xd9, 0x1f, 0x81, 0x0d, 0x3a, 0x95, 0xfe, 0xf9, 0x19, 0x83, 0x4d, 0xb2, 0xe1, 0xa8, 0xed, 0x97, 0x3c, 0x08, 0x71, 0x51, 0x6c, 0xfe, 0xee, 0x40, 0x72, 0x92, 0xee, 0xa1, 0x16, 0x2f, 0x6a, 0xd6, 0x23, 0xcf, 0x83, 0x73, 0x5a, 0x0b, 0x54, 0x55, 0xc9, 0xc9, 0x6a, 0x77, 0x08, 0x6f, 0xce, 0xaa, 0x2c, 0x4c, 0x81, 0x94, 0x20, 0x33, 0x71, 0xd7, 0x8a, 0xce, 0x42, 0x8f, 0xa2, 0xf5, 0x91, 0xcc, 0x90, 0x16, 0x2b, 0x03, 0xba, 0x06, 0xf1, 0xc7, 0xe8, 0x80, 0x72, 0xae, 0xc0, 0x2d, 0xbc, 0x90, 0xcd, 0xb2, 0x54, 0xfc, 0x75, 0xfb, 0xa2, 0x58, 0x21, 0xac, 0x84, 0x9c, 0xa1, 0x00, 0x7b, 0xb0, 0x44, 0x7a, 0x59, 0x5f, 0x9c, 0xaa, 0xff, 0x29, 0x07, 0xb4, 0xed, 0xdf, 0x0f, 0x66, 0xa0, 0xd5, 0x8a, 0xb1, 0xcf, 0x7e, 0xd3, 0x4d, 0x8d, 0x74, 0x88, 0xfb, 0x88, 0x2c, 0x7b, 0x75, 0x7c, 0xc7, 0x9e, 0xdd, 0x48, 0xbf, 0x13, 0xb3, 0x65, 0x6d, 0x4a, 0x37, 0x30, 0x31, 0xb3, 0x2c, 0x9f, 0xaf, 0x65, 0xcd, 0x14, 0xcf, 0x4a, 0xb5, 0x46, 0x62, 0x59, 0x05, 0xfa, 0xde, 0x5a, 0xf6, 0x57, 0x2a, 0xae, 0x59, 0x54, 0x97, 0xb0, 0xb7, 0xb0, 0x38, 0xed, 0x9b, 0x7b, 0x54, 0x47, 0xee, 0x2e, 0x58, 0x66, 0x90, 0x14, 0x51, 0xa0, 0xd6, 0xbe, 0x85, 0xc4, 0xd2, 0x90, 0xf0, 0x04, 0x49, 0x51, 0xb7, 0x15, 0xb2, 0xac, 0x26, 0x7d, 0x2b, 0xb2, 0xeb, 0x2e, 0xce, 0x37, 0xdc, 0x17, 0x49, 0x1b, 0xc7, 0x11, 0x31, 0x48, 0x44, 0xe7, 0x94, 0xf3, 0x6d, 0x69, 0xd8, 0xc3, 0x19, 0x97, 0x82, 0x1b, 0xc8, 0xae, 0x1a, 0x36, 0x46, 0x11, 0xf3, 0x6f, 0x33, 0x74, 0xb4, 0x4d, 0xaa, 0xba, 0xdf, 0x60, 0xdd, 0x15, 0xa9, 0x7d, 0x77, 0x30, 0x38, 0x46, 0xfa, 0x48, 0xd7, 0x82, 0x32, 0xf9, 0x82, 0x5c, 0xd9, 0xf2, 0xf8, 0x4a, 0x5f, 0x45, 0x92, 0xa8, 0x2c, 0xf6, 0xa9, 0x21, 0x49, 0x22, 0x90, 0x3d, 0xbe, 0x9d, 0xbe, 0x1a, 0x98, 0xea, 0xb3, 0xc6, 0xb5, 0x3f, 0xe7, 0x07, 0x5f, 0x59, 0xc2, 0x32, 0x6e, 0x22, 0x10, 0x3a, 0x9f, 0x57, 0xc1, 0xf1, 0x51, 0x53, 0x82, 0xa0, 0x27, 0xa9, 0xce, 0x8b, 0x54, 0x84, 0x66, 0xec, 0x8d, 0x39, 0xe3, 0x8f, 0x01, 0x27, 0xcc, 0xf7, 0xda, 0x90, 0xbc, 0xd3, 0x0e, 0xde, 0xc8, 0xd5, 0xc6, 0xd7, 0x35, 0x22, 0x62, 0xf3, 0xf5, 0xb8, 0x6b, 0xd5, 0x9e, 0x87, 0x47, 0x0e, 0x69, 0x0c, 0xfd, 0x44, 0x15, 0xc9, 0x7b, 0x2c, 0x5f, 0x7d, 0xb6, 0x73, 0x4e, 0xb8, 0xfd, 0x26, 0xd2, 0x0a, 0xc9, 0x22, 0x4d, 0xef, 0xf1, 0x97, 0xb1, 0xa5, 0xed, 0xd0, 0x71, 0x0c, 0x0a, 0xce, 0xfb, 0xda, 0x82, 0xeb, 0x4c, 0x03, 0xe3, 0xba, 0x5d, 0xe1, 0x36, 0x96, 0xc2, 0x50, 0xe0, 0x3d, 0xb7, 0xac, 0x3b, 0xf2, 0xda, 0xff, 0xbb, 0xdb, 0x61, 0x57, 0xc6, 0x9d, 0x96, 0x38, 0xcf, 0x1d, 0x2e, 0xb7, 0x4f, 0x63, 0xc4, 0x51, 0xe8, 0xe1, 0x2b, 0x80, 0x06, 0xae, 0x7c, 0x9d, 0xd3, 0x1d, 0x27, 0x3e, 0x5d, 0xa4, 0x96, 0xba, 0x37, 0x16, 0x4f, 0x39, 0x14, 0x4f, 0xb8, 0x25, 0xf6, 0xb8, 0xac, 0x09, 0xba, 0xdd, 0x47, 0x02, 0x30, 0x05, 0x54, 0xac, 0x41, 0x80, 0x50, 0x8a, 0x3f, 0x27, 0x70, 0x33, 0xe2, 0x49, 0xe8, 0xe5, 0xfc, 0x8a, 0xc5, 0x84, 0x6b, 0xa5, 0x3e, 0xe7, 0x1e, 0xb8, 0x37, 0xc6, 0x08, 0x25, 0xe5, 0x24, 0x93, 0x80, 0xa9, 0xfd, 0x4a, 0x08, 0xb2, 0x83, 0x6e, 0x5b, 0x3c, 0x89, 0x3f, 0x50, 0x78, 0x78, 0x9e, 0x91, 0xf6, 0x08, 0x85, 0xf2, 0xbc, 0x59, 0xbe, 0x52, 0xa0, 0x36, 0x9e, 0x95, 0x24, 0x18, 0x59, 0x46, 0x19, 0xff, 0x3b, 0x67, 0x1c, 0x23, 0x9d, 0x05, 0x59, 0x24, 0x35, 0xbc, 0xd4, 0x3b, 0x1c, 0x15, 0x41, 0x77, 0x6c, 0x5c, 0x86, 0x1b, 0xb7, 0x1c, 0xe0, 0x1b, 0x0f, 0xa5, 0x69, 0x70, 0xff, 0x35, 0x3d, 0x72, 0x33, 0x40, 0x1c, 0x02, 0xdc, 0x3a, 0x20, 0xa9, 0xee, 0xfa, 0xf6, 0xea, 0x73, 0xd0, 0xb4, 0x61, 0xcb, 0xe2, 0xa1, 0xc1, 0x55, 0x22, 0xf1, 0x62, 0x73, 0x24, 0x27, 0xa9, 0xeb, 0x91, 0x8b, 0x9c, 0xb1, 0xb1, 0x9a, 0x87, 0x39, 0xfd, 0x71, 0x26, 0xda, 0x3f, 0xae, 0xb0, 0x3d, 0x57, 0x66, 0x9e, 0x97, 0xcb, 0x01, 0xbf, 0x0a, 0xdc, 0x34, 0x6b, 0x31, 0x18, 0x1c, 0xb8, 0x14, 0x4d, 0x26, 0xb6, 0xa2, 0x76, 0x4d, 0x92, 0xdd, 0xa0, 0xbb, 0xd4, 0x5e, 0x8e, 0xa8, 0xb9, 0x3f, 0x67, 0x27, 0xf2, 0x6c, 0x8b, 0x8f, 0x8e, 0x83, 0x0f, 0x04, 0x45, 0xec, 0xc5, 0x98, 0x31, 0xe1, 0xc3, 0x1e, 0x71, 0xf8, 0x96, 0x28, 0x8a, 0xf3, 0x11, 0xd6, 0xed, 0xce, 0xf2, 0x0b, 0xae, 0x62, 0x9f, 0x0d, 0xe5, 0xb0, 0x6f, 0xeb, 0x78, 0x08, 0x80, 0xdf, 0xb8, 0x85, 0x6d, 0x56, 0x6c, 0x39, 0x5b, 0xcb, 0x15, 0x24, 0xb0, 0x68, 0x04, 0x18, 0xf6, 0x1a, 0x51, 0x77, 0x06, 0x59, 0x52, 0xf3, 0x4e, 0xda, 0xd6, 0xde, 0x5b, 0xa1, 0x6c, 0xb5, 0x6b, 0x1c, 0xf1, 0x31, 0xa8, 0x3a, 0xf7, 0x78, 0xf6, 0xc5, 0x42, 0x8b, 0xd7, 0x0b, 0x62, 0x16, 0x0e, 0xb4, 0xb3, 0x22, 0x88, 0xe7, 0x46, 0xdf, 0x02, 0x21, 0x23, 0x56, 0xa2, 0xd8, 0xa4, 0x1e, 0xb3, 0x70, 0xb2, 0x31, 0xec, 0x7b, 0x7a, 0x64, 0xb8, 0x10, 0xe3, 0x9b, 0x61, 0xdc, 0xf5, 0xc6, 0x74, 0x88, 0x70, 0xcf, 0x70, 0xe3, 0x1b, 0x38, 0x85, 0x98, 0xd0, 0x66, 0xd9, 0xb6, 0xb4, 0x30, 0xd9, 0x72, 0x76, 0x23, 0xc8, 0xf0, 0xa1, 0xdb, 0xb5, 0x25, 0xde, 0xe3, 0x70, 0x01, 0x98, 0xa0, 0x57, 0x66, 0x86, 0x0b, 0x4f, 0xcb, 0xb8, 0x70, 0x85, 0x15, 0xda, 0x52, 0xc1, 0xc4, 0x83, 0x99, 0xe6, 0xdb, 0x9c, 0x3a, 0xd8, 0x16, 0xd9, 0xf1, 0x02, 0x45, 0x58, 0xbd, 0x26, 0x77, 0x15, 0xf3, 0x0d, 0xe6, 0x5c, 0x08, 0x83, 0x23, 0x66, 0x95, 0x6e, 0xba, 0x8e, 0x73, 0x83, 0x67, 0xb7, 0xf9, 0x72, 0xd4, 0x4f, 0xda, 0xe3, 0x47, 0xb4, 0xac, 0x2d, 0x5a, 0xcc, 0x89, 0xfa, 0xbd, 0x41, 0x08, 0xc0, 0xa6, 0x5f, 0x85, 0xbb, 0x86, 0x88, 0x18, 0x28, 0xc9, 0x88, 0x24, 0xa2, 0xe4, 0x59, 0xfa, 0xbf, 0x45, 0x9c, 0x0c, 0xa7, 0xa3, 0x72, 0x77, 0xbd, 0x9b, 0x9d, 0x68, 0xcc, 0x78, 0x8b, 0x12, 0x88, 0xd0, 0x56, 0x05, 0xc8, 0x60, 0x16, 0x62, 0xf9, 0xbd, 0xda, 0xaf, 0xf7, 0x50, 0x45, 0xb4, 0x1c, 0x2e, 0x3e, 0xc6, 0xee, 0x83, 0x19, 0xbb, 0xc7, 0x38, 0x9d, 0xbf, 0xa4, 0x75, 0x65, 0x0c, 0x20, 0xb3, 0x14, 0x5f, 0x56, 0x86, 0xe1, 0xbb, 0xc6, 0x24, 0xab, 0xa9, 0xda, 0x62, 0xe3 },
        .hmac_key_idx = 2,
        // results of message array encrypted with these keys
        .expected_results = {
        // Message 0
      { 0x65197dcf, 0xa3eb53cc, 0x8ac303f8, 0x9f8be6a4, 0x149e5c16, 0x13bd5eb3, 0xe37a58f2, 0x15bdae79, 0x4b45a71f, 0x1fff1104, 0x7c1abf6e, 0x29f83af7, 0xb9f6597c, 0x8c5db0aa, 0x6241dc31, 0x9fe732ac, 0x14a06d6c, 0x587870ff, 0x9f665518, 0xd9152be0, 0x9053ac17, 0x1b2b7ed6, 0xf3ee7340, 0x9144c035, 0xf476104a, 0xa416ff5e, 0xc26b5ae6, 0xecfa6839, 0x5d7b27ef, 0xb4944aef, 0x9528aafb, 0x3cf44e0b, 0x592841d9, 0x82344326, 0xf29ce5b4, 0xc2053396, 0x5cb3f5e7, 0xddf79c67, 0x92a2bed6, 0x0fafc084, 0xce964ca7, 0xf85a8c55, 0xbeced009, 0xd66f92c7, 0x89528b65, 0xce8ffc16, 0x11b05e80, 0x5e09752a, 0x14c86f0a, 0x91527d88, 0x0e866d52, 0x79d86380, 0xde900c71, 0xfbc3bf44, 0x0e24336b, 0xd5a61131, 0x4575e8fa, 0x0e8e2ef2, 0x1da2f720, 0xfe8dcb60, 0xb9376392, 0xd51a7bdc, 0xe49e0950, 0x717ae47a, 0x04be3127, 0x675e909e, 0xf626ad66, 0x2d181c1e, 0x052ba468, 0x4fa84600, 0xbdcfee3d, 0x3e55708c, 0xab084e32, 0x9e75b227, 0xd941219e, 0xd2f1e213, 0x3c712bcb, 0xc1906782, 0xdf325e7c, 0xa0ef949e, 0x5853a9af, 0x7385c463, 0x1a0fc29e, 0x3ba87eaf, 0x883b21b6, 0xb7f5d63c, 0x9debd875, 0x9914f6ce, 0x4f611b76, 0x66679d47, 0x4adcef41, 0xf29e7d74, 0x2043730c, 0x5d97cea3, 0x5251b36f, 0xac862a45, 0x9bc16eda, 0xf74bc917, 0x63b5c5dd, 0x73484adc, 0x855c1b6f, 0x487f145b, 0xdb39a3a8, 0x8a7a4dde, 0x5cd56428, 0x021b19a3, 0x798ef9fd, 0xd68e00a7, 0x3e95ed7b, 0xa897cc0f, 0x01766fc1, 0x34569603, 0xc130d7a8, 0x7c7062c9, 0x29eebe11, 0x7cb735f6, 0x3dee1d9a, 0x2e75161b, 0x9e48d2d3, 0x4af9dc74, 0xfba841bb, 0xfa0125ba, 0xec8ba0da, 0xcd01aa9c, 0x6eb48e1b, 0x605c5848, 0x9e905377, 0x6f9f11a8 },        // Message 1
      { 0x370048f5, 0x2c54ee92, 0xab96e860, 0x979cd630, 0x195437b9, 0x3e488c09, 0x89a4085a, 0xbecba820, 0x5b16e99c, 0x0a71b666, 0xcc03b367, 0xda6c6651, 0x89a8b1ea, 0xf0715da4, 0x5d4565aa, 0x3836451a, 0xb8399c8c, 0x5a985fd2, 0xf878e044, 0xaa74a013, 0x5274b554, 0xcdaf82d8, 0xe1228a9a, 0x09404913, 0x6e5dabb7, 0x3753e5cb, 0x91153ea9, 0xecb8fe4b, 0xc2d02e2b, 0x1f8b15c0, 0x228f9c83, 0xaaa273a0, 0x9dbfc7cd, 0x72f3c30a, 0xa9623f76, 0x67dd1cfc, 0x3bfa1bab, 0xb9c1ef60, 0x517fc29a, 0x58eb8ccf, 0x8231e212, 0x0ceb2058, 0xf9d65e1f, 0xb90bf58c, 0x77dfce79, 0x645d593c, 0x99e0269a, 0x4381ff02, 0xee24c0d3, 0x791a842f, 0xf370362e, 0x4a07d5d4, 0x1159b4cc, 0x39bc62cc, 0x2ee7e39f, 0xc3c1463a, 0xea54a001, 0xdf88cd42, 0xb23e6279, 0x0a107aa1, 0x3d394d9e, 0x90bbf4d1, 0x0c9aca6c, 0xe326e643, 0x60dde45b, 0xf09bcb1f, 0xd532314d, 0x83046416, 0x7485865d, 0x308dfbee, 0x0f7807f9, 0xdf86c67f, 0x7969c5ef, 0x1c31e84d, 0xdbdac915, 0xa2904c1b, 0xb71b28c3, 0x0c55ccbe, 0x72a3960c, 0x3263bf1a, 0x44fdec5c, 0x67402729, 0xeead9bbb, 0x5150e4cc, 0xc54a4a1e, 0x5edcc489, 0xb527b1b6, 0x72d59b8a, 0x95b0efb3, 0x9a9828b4, 0x21322387, 0x0d59fd42, 0xec9ce2ff, 0x9b578d5c, 0xe6ca9413, 0x653dac5f, 0x585ac976, 0xf2b36cde, 0x4b234af0, 0x97a3377b, 0xaa476f6d, 0x32a55f93, 0xa92882fe, 0xa37bf834, 0xd718671c, 0xc61a68f2, 0xc407248a, 0xab57fe11, 0x37df37bb, 0x1cb04341, 0x7a34f942, 0x511de02b, 0xe174ecf2, 0xfa3efd8c, 0x3c43c077, 0xdd792a44, 0x78629619, 0xbe018e7f, 0x75f7b5e4, 0x4a4067f3, 0x7b7c838b, 0xd16d8ef4, 0x8660638b, 0x103cc5b3, 0x42384c4a, 0x49873e0c, 0xd5962764, 0x535d4a0e },        // Message 2
      { 0x57864910, 0xc1199860, 0x41a691f4, 0x71b7db62, 0x8acee085, 0x7b709881, 0x0b7cf6e2, 0xcf64f148, 0x70f8b771, 0xaaebfc0c, 0x426abc82, 0x9867b9e0, 0xcb4ee3da, 0xcee649a4, 0x53be565c, 0xdd34338e, 0x1954ce06, 0x627e9e2a, 0x748b037d, 0x80c517ef, 0xa10720af, 0xa98c8ed4, 0x01043db1, 0xbe86e39f, 0x49c3be6a, 0x0e3785e2, 0x72283e1b, 0x75814721, 0x8e33d1cf, 0x2f022e38, 0x2332c04e, 0x8da4f77c, 0xf1fc905d, 0xb6c94738, 0xcb2a6888, 0x14b96111, 0x92bcfa52, 0x07576571, 0xc41720fe, 0x1d4d8490, 0x716b7134, 0xec860794, 0xc6e70c38, 0x89f7aac2, 0xf1ace458, 0x44ee2858, 0xb128a19d, 0xd0d41c70, 0x8c70cf62, 0xc7bd7a84, 0x69b2d9d1, 0x0c4dbfed, 0x63e3226c, 0x2e804568, 0xa7a55afe, 0x59b9d40b, 0x28016881, 0x682e937f, 0x8405df2d, 0x7a440fab, 0x039e1c26, 0xa094182a, 0x1bdd3492, 0xc4651083, 0x8b84787f, 0xe52b63b7, 0x1040795f, 0x29778c47, 0xb4c9f4fb, 0x8bc8d845, 0x84599ed3, 0x6628f56c, 0x5283f4d5, 0xfe22afde, 0xf7a105b3, 0x48b9f231, 0xd913f403, 0x57426856, 0x59cc6726, 0xe5b92c66, 0x7e55fbdc, 0xf57907ec, 0x002539f5, 0xc5ec15e5, 0xcb728426, 0xdcca799f, 0xa3e884e1, 0xe2c464f5, 0x7529aa33, 0x7864963a, 0x75ded226, 0xcf88b3c1, 0xbf457ee2, 0x43f7452e, 0x4ecb9e64, 0x17e403f0, 0x0362a4aa, 0x08a60270, 0xe03453ba, 0x71eca1d9, 0xedeb823b, 0x2a13e2cf, 0x8f8cdf94, 0xfb81d597, 0xda79b905, 0xd4408845, 0x1f3bc5c0, 0x728e9cbe, 0xacce7fea, 0x614d63c1, 0xed199afd, 0x59120491, 0xb6a13d87, 0x5684f628, 0x66cbfa88, 0xeb11738e, 0x086a4ed0, 0xf923a85f, 0x4d518a42, 0xcab1d988, 0xb65b8f19, 0x785e34ea, 0xb6fa0605, 0x8183af47, 0xfb5d5d0e, 0xaa073eed, 0xcb00d5fd, 0x878f2546 },        // Message 3
      { 0x27ba6317, 0xf8353510, 0x7866dbca, 0xa26a3b01, 0xbf57f699, 0xb7ab4553, 0xc2a372d4, 0xde8021c4, 0xa38a0327, 0xa33594e2, 0xe31149c2, 0x2c9ef5eb, 0xaba9b738, 0x58faca71, 0x0eaf23f5, 0x1a27c2bf, 0x7e75c947, 0x2d0e8eb9, 0x47a82ed8, 0xb0ad8805, 0x151c45a5, 0x082a181d, 0x22ad9185, 0x36037048, 0xaa43568e, 0xf0f546d0, 0x71adba39, 0x04c10c99, 0x6ba154be, 0x4690d9a3, 0xf6266fb9, 0x7ae7dbe1, 0xf4721ba7, 0xab2f1df4, 0x0db5931d, 0x6a3b67b8, 0x5524b434, 0xb910406e, 0xcd99df9e, 0x41986730, 0xdfd9be6f, 0x817c22b0, 0xa1968fe6, 0x78fc1d75, 0xca91f98c, 0xbea4a56f, 0xb2945f29, 0xa7c543dd, 0x381afebb, 0x8275d3ea, 0x580d230b, 0x0109f401, 0xf6031adf, 0xb13bab0c, 0xad05ae83, 0x31695078, 0x47c03087, 0xc4789c9f, 0xd946a9c2, 0xc0209618, 0xae58babc, 0xb07adf2b, 0xae42c281, 0x89852ec4, 0xd34d6d7c, 0xc28b2593, 0x393583f1, 0x8f21d03b, 0xab34e913, 0x854c8862, 0x64efa1df, 0x176f2d79, 0x36bf0a8d, 0xce03fbf6, 0x804e7a91, 0x7152fe94, 0xc586be73, 0xb7a17fd4, 0x16cd8104, 0x34fa05cb, 0xc1e5ee3a, 0xfcea8bbd, 0x59b910a3, 0xa5b58cb8, 0xf7f94eed, 0x690072a9, 0xd6ad5644, 0x7523aadc, 0xc91816ca, 0xc64f5ed6, 0x8c31322d, 0x1124942c, 0x009a9e2d, 0xebeef465, 0x6f196314, 0x00d3f1c5, 0xde50afa4, 0xc1fe18be, 0x34d20cb5, 0xb813b616, 0x6612515b, 0xa98403a4, 0x75225bcd, 0x89044400, 0x88c408d3, 0x40afaa00, 0xa466e4bc, 0xa2cd3220, 0xbf856c65, 0xa732cf0e, 0x1e06c856, 0xd5103424, 0x4c91fd51, 0x15c9b918, 0x4e9000d0, 0x96bdf007, 0x0fa84bab, 0x32bd41f7, 0x99ad9e6e, 0x8c62d67f, 0x88260469, 0x555a1ebc, 0x065a3b07, 0x23e16d7d, 0xbbf4d4a2, 0x5b4dd1e4, 0x62a61595, 0x0ce46645 },        // Message 4
      { 0x4c2602f4, 0xeccb594c, 0x3842d0b4, 0x8d6aa69f, 0x0b34b81e, 0x7b03ac7e, 0xd6cde827, 0xe7603ec2, 0x16c9849d, 0x01271af2, 0x4f0dec43, 0x5b6f369b, 0xf04ad886, 0x40a72e17, 0x1e059bf0, 0x2cd20e80, 0x482d8852, 0x8e2f25f2, 0x514157bd, 0x0f805a05, 0x595454ca, 0x68c56f8d, 0xb3a776c9, 0x0066ef2e, 0x53ae57f3, 0x8f8f13f4, 0x12a42daf, 0x06489233, 0xa93a2f58, 0x5f416074, 0x75f2b52b, 0x173a08be, 0x6268dd65, 0x19df5ace, 0x2e967867, 0x97837674, 0x14bfb2e5, 0xb0c4c115, 0xa7f3dfaa, 0xed171f42, 0x8a766ff8, 0x9e143f98, 0xe73d3557, 0x0064e537, 0x3611732d, 0x4bb49ec6, 0x66879f4f, 0xeb122470, 0xaa5910ec, 0x74b12be1, 0xe8bce233, 0xb50e92ed, 0xcb71e07f, 0xf0801d4f, 0xa08cc9df, 0x7641f601, 0x4ed3d799, 0x2cbd8ed1, 0xefc20e5c, 0x6efb5708, 0x49e433f5, 0xc36c11a4, 0x3183c476, 0xcb65552e, 0x62d1033a, 0x16d1978a, 0x8219584f, 0x3d0b87fb, 0xed0d706b, 0xee7b3453, 0x2fa00b52, 0x11c99ed9, 0xf9c5a97c, 0xc9652dea, 0xd83ad40b, 0xcf9000fb, 0xa90ae3ba, 0xd9e54cff, 0xa5aac9a4, 0x26ca5d1e, 0x885777e5, 0x1c558d67, 0xcc46592d, 0x0e7fada1, 0x7fb1557b, 0x1422e0c0, 0x5ee7581e, 0x625b1461, 0x9101ba90, 0x3bd54ec5, 0x92143360, 0x29699a80, 0xca3718c1, 0xa618f8c7, 0x82d7bb4b, 0x11779bde, 0x17d82087, 0xf113a20f, 0x81847348, 0x8dd288da, 0x057a5243, 0xd328dc4d, 0x9c50b9b0, 0xab07d49e, 0xabd7b9b9, 0x710e5f25, 0xe44d7af1, 0xe8a3cc73, 0xe3d57983, 0xa603759c, 0x679a0e99, 0x86c71679, 0x0d9f13ca, 0x49f5a35a, 0xe20bcbc6, 0x917d4f91, 0x47b9c1cc, 0x63d8d641, 0x2903b2ab, 0x4a07fcc4, 0xe5253c27, 0xc90f4fe0, 0x61e02cf1, 0x665e4ba9, 0x1854d63a, 0xf98cb53f, 0x981cb0b3, 0x0ac5237b },        // Message 5
      { 0xbfee0364, 0x36015aa3, 0x7185f581, 0xd457a818, 0x1c31ae2b, 0xca4c75d2, 0x65b1240d, 0x7a8925b0, 0x7e17e590, 0x1de18271, 0xaa1a71e9, 0x471af19f, 0x7a99de80, 0x50f6c678, 0xc3b02f78, 0x275b1a2e, 0xd64b8c14, 0x5ec8ce6f, 0x428a0244, 0x4a4a74d1, 0x5061e012, 0xfa2eac19, 0x310d5400, 0x8b52e1ed, 0x16132535, 0xdfc949c8, 0x34465318, 0xf9d0b2fd, 0x60f0b280, 0x95424c64, 0x87bb37ff, 0xb52a4604, 0x103ddb03, 0xca4a7291, 0x899bf318, 0x892170de, 0x0f903cd6, 0x3dc6e81d, 0x2f7e0fc6, 0x2647fdff, 0xde0fed94, 0x64f9f7dc, 0xc523f327, 0x9dfbb16b, 0x5157856e, 0xc6b464c0, 0x0728c057, 0xb999bd17, 0x7ab7c299, 0xea589050, 0x48804efe, 0xe0830f5e, 0x84125bbc, 0x1fe7afdf, 0x5133a1da, 0xdf4f0df7, 0xcbdf653b, 0xb5f5b074, 0x3c6cb4a8, 0x14aa0089, 0x6878a887, 0x31f1a7b7, 0xe6ebc741, 0x81f7fa8d, 0x25748246, 0x2ec6cfaf, 0xc2d2b2d6, 0x0f802d66, 0x3adb1a9f, 0x8158f1f7, 0x88cde9ed, 0x65c6ce95, 0xec0e6571, 0x7857046c, 0xde1e6a7f, 0x82201d9e, 0xb9f79f14, 0xfe662723, 0x0cdb9edb, 0x864691e9, 0xec3fc731, 0x1591e7c0, 0x1f2e8f1e, 0x863da0b0, 0x49e2bc04, 0x3cf991fe, 0xb9895c3d, 0xa5f979f2, 0x58787627, 0x0aba0b5b, 0x15f80b91, 0x2e2ba759, 0xed9977ec, 0xc8a79c02, 0x68fe81e5, 0x7e551dac, 0xd411a949, 0x15f83907, 0xee3571c5, 0xdee96e92, 0x41930894, 0x1f2f32ee, 0x71dd1578, 0xf24ed087, 0xa55ce9f2, 0x8b3343a2, 0x2af67bbd, 0x3fc54173, 0xa6fc5c74, 0x7c58391b, 0x430788a4, 0xb86a90cc, 0x46db0b38, 0x94afcf29, 0xd90015d7, 0x45f60b8d, 0xb5d3e2da, 0xc05b762a, 0x666b36a0, 0x55ba610e, 0xf5a2392c, 0x997980fa, 0x4455f80b, 0xe81e2162, 0x534fc303, 0xa9804759, 0x41d5b57c, 0x0398c27f },        // Message 6
      { 0x65e13c17, 0xa8494854, 0xcdffabe7, 0xd2d43212, 0x30cb1dc2, 0xb7e2368e, 0x030c2883, 0xa4cb91d8, 0xbbef07a7, 0xfd673d97, 0x8d15202f, 0x3c98bb2b, 0x88ebe3b0, 0x800eafb9, 0x3fb5984c, 0x7e29b3b3, 0xd8d12588, 0x373fa21c, 0x8a63edeb, 0x27d0a0a6, 0x0b554d3a, 0x6b92a798, 0x8de95891, 0x298e9011, 0xc3532218, 0xc618c867, 0xdc4dda30, 0xbc9c791f, 0x9070bbd8, 0x6c923a0a, 0xdf672602, 0x35cc34a0, 0xc593892f, 0x9c47ce1d, 0xcfa51e7d, 0x1ff37847, 0x6e01c481, 0x048deac5, 0xde61f769, 0x20d81d70, 0x25adfd21, 0x90524699, 0x8965b109, 0xa49fc717, 0x879d5dc8, 0x7710ac00, 0x7138b79a, 0xd1f7a490, 0x6a5620bb, 0xf30f9e37, 0x711dea6f, 0x24e802b1, 0x54825dcb, 0x98f2f537, 0x6449fec5, 0xc5431a97, 0xabbdf3c7, 0x6fa6c588, 0x569f48d8, 0xd0f85d0b, 0xe72eee9a, 0xdcdc6c22, 0x2b238f60, 0xe9037213, 0x2c6bf037, 0xa7ecfa4d, 0xfa687956, 0x39f566ff, 0x6e49bcf8, 0xc1fd4658, 0x46f94002, 0x2e9ae12c, 0x79a70023, 0x519c6c44, 0x5cbacbfd, 0x7f241dae, 0xa79d30cb, 0xdd21f651, 0x3d66981f, 0x3e7ba695, 0x45d08213, 0xc47fe5d2, 0x507f8532, 0x4ad12339, 0x6f48c5d3, 0x73cc13d2, 0xd0fa27d9, 0x91c3de34, 0xabdf110f, 0x268f7122, 0x3890ac97, 0x58d8a85f, 0xce54a3d2, 0x863b237d, 0x718bad38, 0x1cdfe698, 0xf4ff8cd7, 0x7f8db35c, 0xe54f15a6, 0xa461adfe, 0x310f29e3, 0x5cc8e054, 0x5d1ca532, 0xfb59f27c, 0xe9ef6f9b, 0xc090823b, 0xfcbeb62a, 0xdd782d87, 0x31e20b36, 0x109a5051, 0x366e995e, 0xd9258e01, 0xac49ba01, 0xb05a99c2, 0xbc422118, 0x4d4a63f8, 0xa6adf1ed, 0xe7628076, 0x5e5f10a4, 0x199d405a, 0xff28fd42, 0xbe522d42, 0xc4bc599e, 0xe82190ae, 0x3be3229e, 0x36d5d970, 0x16e3f7b5, 0x6fc40096 },        // Message 7
      { 0xa8e4a604, 0xa72523d5, 0xdab02f44, 0xae02f55f, 0x0c0022bb, 0xb40b14e7, 0xaa4c945b, 0xad468eb0, 0x5d1b1593, 0xfc6af6ca, 0xd0ab9d5d, 0x6d9cfef3, 0x7ec6b26b, 0x78685448, 0xbe3474ad, 0x72c04ace, 0xaca50cb3, 0xf8b6cf97, 0xbb74fe93, 0xe02ac2e8, 0xf5fc7a4b, 0xe7a1ba54, 0x3e9d93b2, 0xa11faeb5, 0x01093443, 0x8fa08988, 0xf7546162, 0x26d10159, 0x4a98c18a, 0xd58d97f7, 0xc38879ad, 0x89ff6e66, 0xa1e208d3, 0xbf483d34, 0x1fc33d7c, 0x4d2c5304, 0xf822cda6, 0x31515f9c, 0x1461871f, 0xcbf4a900, 0x25f3c792, 0xe21e3d35, 0x6007c93e, 0x6794a608, 0x321c0d55, 0x1545ede8, 0x656714ac, 0x3e7fc582, 0xc79a05c4, 0x643d6839, 0xfb7d489c, 0x76d61526, 0x4375d672, 0x56522aa5, 0xabe3a085, 0x2ab42c64, 0xa0dca5dd, 0x6ac8aa25, 0xd0564d71, 0x3f21e026, 0x16a3e254, 0x9fdac16a, 0x67d199a9, 0x8e757054, 0x251e329a, 0xc20a8a57, 0x7dca5424, 0x4cde0e8b, 0x6fc99c17, 0x7c3396c5, 0x6daf0147, 0xbda11114, 0xff7c5aee, 0x5040534c, 0x8e61116f, 0xc35e533e, 0x29cf9072, 0x99ab3540, 0x87843c6c, 0xefd1ee77, 0xecaee932, 0xd5860a47, 0x73f46c98, 0x2c1e1c66, 0x1dedcf9a, 0xf46f1b0e, 0x045a4262, 0x8cb89e5e, 0x1a9a53b0, 0xa3ecaf42, 0x3a93198c, 0xbe95333c, 0xa370bd1c, 0xbb360fb2, 0xdfc0e8d7, 0xaa16a57c, 0x4903d416, 0x5b010021, 0x67070555, 0x30532640, 0x1d09242c, 0x758b466a, 0x44f10eb3, 0x5aee391b, 0x3dc1bd03, 0x9550c24b, 0xbf154e33, 0x847df588, 0x50ebb8c7, 0x23801a6f, 0x69853a09, 0xfdf9630a, 0x2a855796, 0xd6ae8286, 0x3788e87b, 0xc83a0ef7, 0x928313a1, 0x74eb1dd5, 0x12d2a6da, 0x57234976, 0x058b7785, 0xc306804b, 0x17cfd5a0, 0xc118a816, 0x1cf6b08d, 0x524e8d47, 0x1dcfe12a, 0x6791b8eb },        // Message 8
      { 0xa7d847a8, 0x07227d3c, 0xf929e542, 0xd8f1ca3a, 0x97f53996, 0x41cb013f, 0x51cb0f37, 0x510cae2a, 0x87a7b954, 0x453c543f, 0xebe2c59c, 0x4830baca, 0xfa2fdf6d, 0x433b9f38, 0x6e18f66b, 0xcf92605f, 0x95d7e88b, 0x05f53dd8, 0xed28fa5a, 0xbaeb79f2, 0x9f8f2990, 0xa7547ff1, 0xd52f53b5, 0x34653532, 0xb5798ae0, 0x01aa181e, 0x65cad5fe, 0x1ae2ae51, 0xcdffabf2, 0x550e3b9e, 0x243ed139, 0x6cfc4162, 0xd76c55cd, 0xe6355882, 0x947a1907, 0x25ef8abe, 0x5d7fcd4d, 0x2cdad1e3, 0x3462f545, 0xeb109cdd, 0x54747de8, 0xfef3c2e4, 0x1a85d2c2, 0x887184af, 0x297460df, 0x0191f3c3, 0x27d1156b, 0x9060ad2e, 0x780313bf, 0xd1fe122a, 0xf99baf6d, 0x611c6371, 0x33741129, 0xa35410cb, 0x49c2f0c7, 0xc9bdc492, 0x5525e4d2, 0xc7ed59b4, 0x403d70fb, 0xc713657e, 0xf2e78571, 0x0b6931d5, 0xe9f61ba1, 0xe5bbd7ef, 0x53928dd6, 0x277e1804, 0xdf7b836e, 0x8b383b5d, 0x3cae75fd, 0xbcdb2f2f, 0x4b7d9d59, 0x8178bf3d, 0xe14a2e64, 0x38a0618e, 0x1b5052a2, 0x76de279a, 0xf2213efc, 0x829209a4, 0x86ed5afe, 0x2bd2d61d, 0x0b963d6f, 0x81063d91, 0x06cfb033, 0x56b47158, 0xc1969c21, 0xf1043f84, 0x94a98985, 0x3c19a989, 0xa376de07, 0x1577fe3f, 0x9fc7f8c1, 0x91027901, 0xf53bd5c0, 0x8fb7c061, 0x256614c8, 0x9d41f20b, 0xfea19fa1, 0x19031c45, 0xed24ea91, 0x20c3eb3d, 0xa5778121, 0x385ad69d, 0x95bdb23d, 0x9fd7fb6f, 0x0b0e491e, 0x2e534f0e, 0xd68bcf37, 0xef8ef018, 0xd9037d8e, 0x0c4dd160, 0xac2d17cc, 0x5169595b, 0x22829d8b, 0x27d20842, 0xb0fdc5dd, 0x2c594330, 0x4b0f74f4, 0xb61009db, 0xa25399b7, 0xf203e6c6, 0xb4b9ffc3, 0x12f58dea, 0xfb8967f9, 0x6ee4c51b, 0x714a692a, 0x4f91749b, 0xee1684f3, 0x5e404c96 },        // Message 9
      { 0xa2061f81, 0x1f2df209, 0xd400fb0d, 0xac5cae7e, 0x53420f0e, 0x4d6ce262, 0x35fd5ef7, 0x61f455c1, 0x90227a4d, 0xdf123dbe, 0x690f84fd, 0xcd327384, 0xca3bfcd6, 0x22bbc407, 0x61f4314f, 0xe2dfc51a, 0x17c6e1e0, 0xe23a4854, 0x491559c0, 0x2b32efca, 0x2a77e7bb, 0x21d9d772, 0x2375d5f9, 0x9f7aebd7, 0x6d0bbc42, 0xc094db92, 0xa37eca7a, 0x3dda1bfb, 0x6026f229, 0x2717f0c0, 0x0d23a09e, 0x4d8ae998, 0x9f18290d, 0x109241d9, 0x6c3302ef, 0x48ad5993, 0xe9f8b538, 0xddebaec5, 0x6f8efc96, 0xd05ece14, 0x60b8d19c, 0x7283df36, 0xa8efeb9d, 0x1b12933d, 0x6d53ac6b, 0x070d7248, 0x8be81634, 0xb2acd4f1, 0xcbbe361b, 0xdb5cd974, 0xe6e608d5, 0xb256e81e, 0x61ce39d1, 0xddebd827, 0x77c0aaf6, 0x1123a817, 0x17b66ab2, 0xdecd346e, 0xbf22865d, 0xff3d3dcd, 0x045d5b9d, 0x3ea643d6, 0xd3cb2eeb, 0x1c0eacd5, 0x9282755d, 0x2d18e935, 0xb78c29a8, 0x6edec65e, 0x594109d4, 0x26b4aafa, 0xbaead83a, 0x2306839a, 0x3104ce00, 0xf6150b9b, 0x7b29b751, 0x6ce581d0, 0x41bbc298, 0xc24d95ba, 0x732dcdac, 0x0ae0792f, 0xd8f0415b, 0x15c5a820, 0xba0c9f4e, 0x8bc1652b, 0x1c870546, 0xe93c6434, 0xe57846f8, 0xa68bc745, 0x03aa8189, 0xf64eb817, 0x6678d8b9, 0x42c5bccb, 0xb97863b4, 0xe2f64c82, 0x38ab2b62, 0x8704bb07, 0x3335ce2e, 0xa7c160eb, 0x3db4baa7, 0xb88dbb07, 0xed4aa03d, 0x51d752e8, 0x2ee7c3ba, 0xda33970c, 0xb63d69ac, 0x175b83c9, 0x72f867c1, 0xd7a9ee05, 0xe3b042e6, 0x1f5cf101, 0xcf3604e6, 0x04db83fb, 0xb9e913bd, 0x4044949b, 0x00b0ade7, 0xda7b47ed, 0x19e7709a, 0xdbebffa9, 0x678690c8, 0x5fcdf486, 0xd8e5a539, 0x56a7328d, 0x4ebbcb73, 0x067b05d0, 0xe4fbc025, 0xe41cc703, 0x9d75bf51, 0x99d3f232 },     },
     },
};
