/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.variable;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.variable.OpenocdDynamicVariable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.launchbar.core.ILaunchBarManager;

public class OpenocdVariableResolver
implements IDynamicVariableResolver {
    private static final String OPENOCD_PREFIX = "com.espressif.idf.debug.gdbjtag.openocd";
    private static final String INSTALL_FOLDER = "install.folder";
    private static final String EXECUTABLE_NAME = "executable.name";

    public String resolveValue(IDynamicVariable variable, String argument) {
        return this.getAppropriateEnumVariable(variable).map(this::resolveForOpenocdDynamicEnum).orElse(variable.getName());
    }

    private Optional<OpenocdDynamicVariable> getAppropriateEnumVariable(IDynamicVariable variable) {
        return Arrays.stream(OpenocdDynamicVariable.values()).filter(v -> v.getValue().equals(variable.getName())).findAny();
    }

    private String resolveForOpenocdDynamicEnum(OpenocdDynamicVariable enumVariable) {
        ILaunchConfiguration configuration = this.getActiveLaunchConfiguration();
        switch (enumVariable) {
            case OPENOCD_PATH: {
                Path openocdBinPath = this.getOpenocdBinPath(configuration);
                return openocdBinPath.toString();
            }
            case OPENOCD_EXE: {
                Path openocdExe = this.getOpenocdExecutable(configuration);
                return openocdExe.toString();
            }
            case OPENOCD_SCRIPTS: {
                return new IDFEnvironmentVariables().getEnvValue("OPENOCD_SCRIPTS");
            }
        }
        return "";
    }

    private ILaunchConfiguration getActiveLaunchConfiguration() {
        try {
            return IDFCorePlugin.getService(ILaunchBarManager.class).getActiveLaunchConfiguration();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return null;
        }
    }

    protected Path getOpenocdBinPath(ILaunchConfiguration configuration) {
        String installFolder = EclipseUtils.getPreferenceValueForId((String)OPENOCD_PREFIX, (String)INSTALL_FOLDER, (String)"", (IProject)EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)configuration));
        return Paths.get(installFolder, new String[0]);
    }

    protected Path getOpenocdExecutable(ILaunchConfiguration configuration) {
        String executableName = EclipseUtils.getPreferenceValueForId((String)OPENOCD_PREFIX, (String)EXECUTABLE_NAME, (String)"", (IProject)EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)configuration));
        return Paths.get(executableName, new String[0]);
    }
}

