/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.util.Map;

public class WinNativeFileTagOperations {
    private static final int MICROSOFT_REPARSE_TAG_BIT = Integer.MIN_VALUE;

    public static int getReparseTag(String filePath) {
        WIN32_FIND_DATA findFileData = new WIN32_FIND_DATA();
        WinNT.HANDLE hFind = Kernel32.INSTANCE.FindFirstFile(filePath, findFileData);
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)hFind)) {
            Logger.log("FindFirstFile failed: " + Native.getLastError());
        }
        try {
            if ((findFileData.dwFileAttributes.intValue() & 0x400) != 0) {
                int reparseTag = findFileData.dwReserved0.intValue();
                Logger.log("The file has a reparse point. Reparse Tag: 0x" + Integer.toHexString(reparseTag));
                int n = reparseTag;
                return n;
            }
            Logger.log("The file does not have a reparse point.");
        }
        finally {
            Kernel32.INSTANCE.FindClose(hFind);
        }
        return -1;
    }

    public static boolean isReparseTagMicrosoft(int tag) {
        return (tag & Integer.MIN_VALUE) != 0;
    }

    public static boolean fileExists(File file) {
        WIN32_FIND_DATA findFileData;
        String filePath = file.getAbsolutePath();
        WinNT.HANDLE hFind = Kernel32.INSTANCE.FindFirstFile(filePath, findFileData = new WIN32_FIND_DATA());
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)hFind)) {
            return false;
        }
        Kernel32.INSTANCE.FindClose(hFind);
        return true;
    }

    public static boolean isDirectory(String filePath) {
        WIN32_FIND_DATA findFileData = new WIN32_FIND_DATA();
        WinNT.HANDLE hFind = Kernel32.INSTANCE.FindFirstFile(filePath, findFileData);
        if (WinBase.INVALID_HANDLE_VALUE.equals((Object)hFind)) {
            Logger.log("FindFirstFile failed: " + Native.getLastError());
            return false;
        }
        try {
            boolean bl = (findFileData.dwFileAttributes.intValue() & 0x10) != 0;
            return bl;
        }
        finally {
            Kernel32.INSTANCE.FindClose(hFind);
        }
    }

    public static interface Kernel32
    extends com.sun.jna.platform.win32.Kernel32 {
        public static final Kernel32 INSTANCE = (Kernel32)Native.load((String)"kernel32", Kernel32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public WinNT.HANDLE FindFirstFile(String var1, WIN32_FIND_DATA var2);

        public boolean FindClose(WinNT.HANDLE var1);
    }

    @Structure.FieldOrder(value={"dwFileAttributes", "ftCreationTime", "ftLastAccessTime", "ftLastWriteTime", "nFileSizeHigh", "nFileSizeLow", "dwReserved0", "dwReserved1", "cFileName", "cAlternateFileName"})
    public static class WIN32_FIND_DATA
    extends Structure {
        public WinDef.DWORD dwFileAttributes;
        public WinBase.FILETIME ftCreationTime;
        public WinBase.FILETIME ftLastAccessTime;
        public WinBase.FILETIME ftLastWriteTime;
        public WinDef.DWORD nFileSizeHigh;
        public WinDef.DWORD nFileSizeLow;
        public WinDef.DWORD dwReserved0;
        public WinDef.DWORD dwReserved1;
        public byte[] cFileName = new byte[260];
        public byte[] cAlternateFileName = new byte[14];

        public WIN32_FIND_DATA() {
        }

        public WIN32_FIND_DATA(Pointer memory) {
            super(memory);
            this.read();
        }
    }
}

