/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools.launch.strategies;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.launch.LaunchResult;
import com.espressif.idf.core.tools.launch.ProcessUtils;
import com.espressif.idf.core.tools.launch.ProcessWaiter;
import com.espressif.idf.core.tools.launch.strategies.AbstractLoggingLauncherStrategy;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsoleStream;

public final class MacOsEimLauncherStrategy
extends AbstractLoggingLauncherStrategy {
    private static final String MACOS_LAUNCH_AND_PID_APPLESCRIPT = "set appPath to system attribute \"APP_PATH\"\nset bundleId to system attribute \"BUNDLE_ID\"\n\ndo shell script \"open -a \" & quoted form of appPath\n\ntell application \"System Events\"\n\trepeat 300 times\n\t\tset matches to (application processes whose bundle identifier is bundleId)\n\t\tif (count of matches) > 0 then\n\t\t\treturn unix id of (item 1 of matches)\n\t\tend if\n\t\tdelay 0.1\n\tend repeat\nend tell\n\nerror \"PID not found (app may not have launched)\"\n";

    public MacOsEimLauncherStrategy(Display display, MessageConsoleStream standardConsoleStream, MessageConsoleStream errorConsoleStream) {
        super(display, standardConsoleStream, errorConsoleStream);
    }

    @Override
    public LaunchResult launch(String eimPath) throws IOException {
        String out;
        int exit;
        String appBundlePath = this.deriveAppBundlePath(eimPath);
        String execPath = this.deriveExecPath(eimPath, appBundlePath);
        String bundleId = this.readBundleId(appBundlePath);
        ProcessBuilder pb = new ProcessBuilder("osascript", "-");
        pb.redirectErrorStream(true);
        pb.environment().put("APP_PATH", appBundlePath);
        pb.environment().put("BUNDLE_ID", bundleId);
        Process p = pb.start();
        Throwable throwable = null;
        Object var8_9 = null;
        try (OutputStream stdin = p.getOutputStream();){
            stdin.write(MACOS_LAUNCH_AND_PID_APPLESCRIPT.getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        try {
            exit = p.waitFor();
            out = ProcessUtils.readAll(p.getInputStream());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for osascript", e);
        }
        Logger.log("APP_PATH=" + appBundlePath);
        Logger.log("BUNDLE_ID=" + bundleId);
        Logger.log("Launcher output was:\n" + out);
        Long pid = ProcessUtils.parseFirstLongLine(out);
        if (exit == 0 && pid != null) {
            return LaunchResult.ofPid(pid, execPath, out);
        }
        return LaunchResult.ofNoPid(execPath, "osascript exit=" + exit + "\n" + out);
    }

    @Override
    public IStatus waitForExit(LaunchResult launchResult, IProgressMonitor monitor) {
        if (launchResult.pid().isPresent()) {
            return ProcessWaiter.waitForExitByPid(launchResult.pid(), monitor);
        }
        return ProcessWaiter.waitForExitByExecPath(launchResult.execPath(), monitor);
    }

    private String deriveAppBundlePath(String eimPath) {
        Path p = Paths.get(eimPath, new String[0]).toAbsolutePath().normalize();
        while (p != null) {
            String name;
            String string = name = p.getFileName() != null ? p.getFileName().toString() : "";
            if (name.endsWith(".app")) {
                return p.toString();
            }
            p = p.getParent();
        }
        throw new IllegalArgumentException("Cannot derive .app bundle path from: " + eimPath);
    }

    private String deriveExecPath(String eimPath, String appBundlePath) {
        if (eimPath != null && eimPath.contains(".app/Contents/MacOS/")) {
            return eimPath;
        }
        return Paths.get(appBundlePath, "Contents", "MacOS", "eim").toString();
    }

    private String readBundleId(String appBundlePath) throws IOException {
        String out;
        int exit;
        String infoPlist = Paths.get(appBundlePath, "Contents", "Info.plist").toString();
        Process p = new ProcessBuilder("/usr/libexec/PlistBuddy", "-c", "Print :CFBundleIdentifier", infoPlist).redirectErrorStream(true).start();
        try {
            exit = p.waitFor();
            out = ProcessUtils.readAll(p.getInputStream());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while reading Info.plist", e);
        }
        if (exit != 0 || out == null || out.isBlank()) {
            throw new IOException("Failed to read CFBundleIdentifier. Output was:\n" + out);
        }
        return out.trim();
    }
}

