/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.EimConstants;
import com.espressif.idf.core.tools.exceptions.EimVersionMismatchException;
import com.espressif.idf.core.tools.vo.EimJson;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.Platform;

public class EimIdfConfiguratinParser {
    private EimJson eimJson;
    private Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().excludeFieldsWithoutExposeAnnotation().create();

    private void load() throws IOException, EimVersionMismatchException {
        String path = Platform.getOS().equals("win32") ? EimConstants.EIM_WIN_PATH : EimConstants.EIM_POSIX_PATH;
        File file = new File(path);
        if (!file.exists()) {
            Logger.log("EIM config file not found: " + path);
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileReader fileReader = new FileReader(file);){
            this.eimJson = (EimJson)this.gson.fromJson((Reader)fileReader, EimJson.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!this.eimJson.getVersion().equals("1.0")) {
            throw new EimVersionMismatchException("1.0", this.eimJson.getVersion());
        }
    }

    public EimJson getEimJson(boolean reload) throws IOException, EimVersionMismatchException {
        if (reload || this.eimJson == null) {
            this.load();
        }
        return this.eimJson;
    }
}

