/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.ui;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.LaunchConfigurationDelegate;
import com.espressif.idf.debug.gdbjtag.openocd.ui.Messages;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.handlers.EclipseHandler;
import com.espressif.idf.ui.tracing.AppLvlTracingDialog;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.launchbar.ui.NewLaunchConfigWizard;
import org.eclipse.launchbar.ui.NewLaunchConfigWizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AppLvlTracingHandler
extends AbstractHandler {
    private IResource project;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Shell activeShell = EclipseUtil.getShell();
        this.project = EclipseHandler.getSelectedProject((String)"org.eclipse.ui.navigator.ProjectExplorer");
        if (this.project == null) {
            this.project = EclipseHandler.getSelectedResource((IEvaluationContext)((IEvaluationContext)event.getApplicationContext()));
        }
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        Job job = new Job(Messages.AppLvlTracingJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations();
                    int n = iLaunchConfigurationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LaunchConfiguration cg;
                        ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                        IResource[] mappedResource = config.getMappedResources();
                        if (mappedResource != null && mappedResource[0].getProject() == AppLvlTracingHandler.this.project && (cg = (LaunchConfiguration)config).getPreferredLaunchDelegate("run") instanceof LaunchConfigurationDelegate) {
                            this.launchOpenocdFromLaunchConfiguration(cg);
                            this.openAppLvlTracingDialog(activeShell);
                            return Status.OK_STATUS;
                        }
                        ++n2;
                    }
                    AppLvlTracingHandler.this.showMessage(Messages.DebugConfigurationNotFoundMsg);
                }
                catch (CoreException e) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)activeShell, (String)Messages.OpenOcdFailedMsg, (String)e.getMessage());
                        }
                    });
                    Logger.log((Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }

            private void openAppLvlTracingDialog(final Shell activeShell2) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AppLvlTracingDialog dialog = new AppLvlTracingDialog(activeShell2);
                        dialog.setProjectPath((this).AppLvlTracingHandler.this.project);
                        dialog.open();
                    }
                });
            }

            private void launchOpenocdFromLaunchConfiguration(LaunchConfiguration config) throws CoreException {
                if (!DebugUtils.isLaunchConfigurationStarted((ILaunchConfiguration)config)) {
                    LaunchConfigurationDelegate debugDelegate = (LaunchConfigurationDelegate)config.getPreferredLaunchDelegate("run");
                    debugDelegate.ignoreGdbClient();
                    config.launch("run", null, false);
                    debugDelegate.doNotIngoreGdbClient();
                }
            }
        };
        job.schedule();
        return null;
    }

    private void showMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell activeShell = Display.getDefault().getActiveShell();
                boolean isYes = MessageDialog.openQuestion((Shell)activeShell, (String)Messages.MissingDebugConfigurationTitle, (String)message);
                if (isYes) {
                    NewLaunchConfigWizard wizard = new NewLaunchConfigWizard();
                    NewLaunchConfigWizardDialog dialog = new NewLaunchConfigWizardDialog(activeShell, (IWizard)wizard);
                    dialog.open();
                    try {
                        wizard.getWorkingCopy().doSave();
                    }
                    catch (CoreException e) {
                        Logger.log((Exception)((Object)e));
                    }
                }
            }
        });
    }
}

