/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd;

import com.espressif.idf.debug.gdbjtag.openocd.preferences.DefaultPreferences;
import com.espressif.idf.debug.gdbjtag.openocd.preferences.PersistentPreferences;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.espressif.idf.debug.gdbjtag.openocd";
    public static final String GDB_SERVER_LAUNCH_TIMEOUT = "fGdbServerLaunchTimeout";
    private static Activator fgInstance;
    protected DefaultPreferences fDefaultPreferences = null;
    protected PersistentPreferences fPersistentPreferences = null;
    protected boolean fIsDebugging;

    protected void initializeDefaultPreferences(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault(GDB_SERVER_LAUNCH_TIMEOUT, 25);
    }

    public String getBundleId() {
        return PLUGIN_ID;
    }

    public static Activator getInstance() {
        return fgInstance;
    }

    public Activator() {
        fgInstance = this;
        this.fIsDebugging = "true".equalsIgnoreCase(Platform.getDebugOption((String)(this.getBundleId() + "/debug")));
    }

    public void start(BundleContext context) throws Exception {
        if (this.isDebugging()) {
            System.out.println(this.getBundleId() + ".start()");
        }
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.isDebugging()) {
            System.out.println(this.getBundleId() + ".stop()");
        }
    }

    public boolean isDebugging() {
        return this.fIsDebugging;
    }

    public ImageDescriptor getImageDescriptor(String name) {
        String str = name.toLowerCase();
        ImageDescriptor imageDescriptor = this.getImageRegistry().getDescriptor(str);
        if (imageDescriptor == null) {
            imageDescriptor = this.declareImage(str);
        }
        return imageDescriptor;
    }

    public Image getImage(String name) {
        String str = name.toLowerCase();
        Image image = this.getImageRegistry().get(str);
        if (image != null) {
            return image;
        }
        ImageDescriptor imageDescriptor = this.declareImage(str);
        if (imageDescriptor == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        image = this.getImageRegistry().get(str);
        return image;
    }

    protected ImageDescriptor declareImage(String name) {
        ImageDescriptor imageDescriptor;
        Path path;
        Path pathx = path = new Path("icons/", name);
        String extension = ((IPath)path).getFileExtension();
        if (extension == null || extension.isEmpty()) {
            pathx = ((IPath)path).addFileExtension("png");
        }
        if ((imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getBundleId(), (String)((IPath)pathx).toString())) == null) {
            if (extension == null || extension.isEmpty()) {
                pathx = ((IPath)path).addFileExtension("gif");
                imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getBundleId(), (String)((IPath)pathx).toString());
            }
            if (imageDescriptor == null) {
                return null;
            }
        }
        try {
            String key = this.getKey(name);
            if (this.getImageRegistry().getDescriptor(key) == null) {
                this.getImageRegistry().put(key, imageDescriptor);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
        return imageDescriptor;
    }

    private String getKey(String name) {
        return name.toLowerCase();
    }

    public static void log(IStatus status) {
        Activator.getInstance().getLog().log(status);
    }

    public static void log(Throwable e) {
        Activator.log((IStatus)new Status(4, Activator.getInstance().getBundleId(), 1, "Internal Error", e));
    }

    public static void log(String message) {
        Activator.log((IStatus)new Status(4, Activator.getInstance().getBundleId(), 1, message, null));
    }

    public DefaultPreferences getDefaultPreferences() {
        if (this.fDefaultPreferences == null) {
            this.fDefaultPreferences = new DefaultPreferences(PLUGIN_ID);
        }
        return this.fDefaultPreferences;
    }

    public PersistentPreferences getPersistentPreferences() {
        if (this.fPersistentPreferences == null) {
            this.fPersistentPreferences = new PersistentPreferences(PLUGIN_ID);
        }
        return this.fPersistentPreferences;
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = fgInstance.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

