/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.update;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.tools.ManageEspIdfVersionsHandler;
import com.espressif.idf.ui.update.AbstractToolsHandler;
import com.espressif.idf.ui.update.Messages;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ListInstalledToolsHandler
extends AbstractToolsHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.idfPath = IDFUtil.getIDFPath();
        Logger.log((String)("IDF_PATH :" + this.idfPath));
        this.pythonExecutablenPath = this.getPythonExecutablePath();
        Logger.log((String)("Python Path :" + this.pythonExecutablenPath));
        if (StringUtil.isEmpty((String)this.pythonExecutablenPath) || StringUtil.isEmpty((String)this.idfPath)) {
            this.showMessage(Messages.ListInstalledTools_MissingIdfPathMsg);
            throw new ExecutionException("Paths can't be empty. Please check IDF_PATH and Python");
        }
        this.activateIDFConsoleView();
        final String listInstalledToolsJobName = Messages.ListInstalledToolsHandler_InstalledToolsListJobName;
        Job job = new Job(listInstalledToolsJobName){

            protected IStatus run(IProgressMonitor monitor) {
                ListInstalledToolsHandler.this.execute();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return listInstalledToolsJobName.equals(family);
            }
        };
        job.schedule();
        return null;
    }

    private void showMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean isYes = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.ListInstalledTools_MessageTitle, (String)message);
                if (isYes) {
                    ManageEspIdfVersionsHandler manageEspIdfVersionsHandler = new ManageEspIdfVersionsHandler();
                    try {
                        manageEspIdfVersionsHandler.execute(null);
                    }
                    catch (ExecutionException e) {
                        Logger.log((Exception)((Object)e));
                    }
                }
            }
        });
    }

    @Override
    protected void execute() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("list");
        if (StringUtil.isEmpty((String)this.gitExecutablePath)) {
            this.gitExecutablePath = new IDFEnvironmentVariables().getEnvValue("GIT_PATH");
        }
        this.runCommand(arguments, this.console);
    }
}

