/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools.manager.pages;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.EimIdfConfiguratinParser;
import com.espressif.idf.core.tools.SetupToolsInIde;
import com.espressif.idf.core.tools.ToolInitializer;
import com.espressif.idf.core.tools.exceptions.EimVersionMismatchException;
import com.espressif.idf.core.tools.util.ToolsUtility;
import com.espressif.idf.core.tools.vo.EimJson;
import com.espressif.idf.core.tools.vo.IdfInstalled;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.UIPlugin;
import com.espressif.idf.ui.tools.EimButtonLaunchListener;
import com.espressif.idf.ui.tools.Messages;
import com.espressif.idf.ui.tools.SetupToolsJobListener;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.prefs.Preferences;

public class ESPIDFMainTablePage {
    private Composite container;
    private TableViewer tableViewer;
    private ColumnViewerComparator comparator;
    private TableViewerColumn versionColumn;
    private TableViewerColumn locationColumn;
    private TableViewerColumn activateColumn;
    private TableViewerColumn removeColumn;
    private TableViewerColumn nameColumn;
    private Button eimLaunchBtn;
    private TableColumnLayout tableColumnLayout;
    private Composite tableComposite;
    private List<IdfInstalled> idfInstalledList;
    private static EimJson eimJson;
    private EimIdfConfiguratinParser eimIdfConfiguratinParser = new EimIdfConfiguratinParser();
    private ToolInitializer toolInitializer = new ToolInitializer((Preferences)InstanceScope.INSTANCE.getNode("com.espressif.idf.ui"));
    private static final String RELOAD_ICON = "icons/tools/reload.png";
    private static final String IDF_TOOL_SET_BTN_KEY = "IDFToolSet";
    private static ESPIDFMainTablePage espidfMainTablePage;

    private ESPIDFMainTablePage() {
    }

    public static ESPIDFMainTablePage getInstance(EimJson eimJson) {
        if (espidfMainTablePage == null) {
            espidfMainTablePage = new ESPIDFMainTablePage();
        }
        ESPIDFMainTablePage.eimJson = eimJson;
        return espidfMainTablePage;
    }

    public Composite createPage(Composite composite) {
        this.idfInstalledList = eimJson != null ? eimJson.getIdfInstalled() : null;
        this.container = new Composite(composite, 0);
        int numColumns = 2;
        GridLayout gridLayout = new GridLayout(2, false);
        this.container.setLayout((Layout)gridLayout);
        this.createButtonAndGuideLink(this.container);
        this.createIdfTable(this.container);
        return this.container;
    }

    private void createButtonAndGuideLink(Composite composite) {
        Link guideLink = new Link(composite, 64);
        guideLink.setText(Messages.IDFGuideLinkLabel_Text);
        guideLink.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        guideLink.addListener(13, e -> {
            try {
                Desktop.getDesktop().browse(new URI("https://dl.espressif.com/dl/esp-idf/support-periods.svg"));
            }
            catch (Exception ex) {
                Logger.log((Exception)ex);
            }
        });
        this.eimLaunchBtn = new Button(composite, 8);
        this.eimLaunchBtn.setText(!this.toolInitializer.isEimInstalled() ? Messages.EIMButtonDownloadText : Messages.EIMButtonLaunchText);
        this.eimLaunchBtn.addSelectionListener((SelectionListener)new EimButtonLaunchListener(espidfMainTablePage, Display.getDefault(), this.getConsoleStream(false), this.getConsoleStream(true)));
    }

    public void setupInitialEspIdf() {
        IEclipsePreferences scopedPreferenceStore;
        if (this.idfInstalledList != null && this.idfInstalledList.size() == 1 && !(scopedPreferenceStore = InstanceScope.INSTANCE.getNode("com.espressif.idf.ui")).getBoolean("INSTALL_TOOLS_FLAG", false)) {
            SetupToolsInIde setupToolsInIde = new SetupToolsInIde(this.idfInstalledList.get(0), eimJson, this.getConsoleStream(true), this.getConsoleStream(false));
            SetupToolsJobListener toolsActivationJobListener = new SetupToolsJobListener(this, setupToolsInIde);
            setupToolsInIde.addJobChangeListener((IJobChangeListener)toolsActivationJobListener);
            setupToolsInIde.schedule();
        }
    }

    public void refreshEditorUI() {
        if (this.container == null) {
            return;
        }
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String EDITOR_KEY = "action_editor";
            String EDITOR_KEY_LAST = "action_editor_last";
            TableEditor editorFirst = (TableEditor)item.getData(EDITOR_KEY);
            TableEditor editorLast = (TableEditor)item.getData(EDITOR_KEY_LAST);
            if (editorFirst != null) {
                if (editorFirst.getEditor() != null && !editorFirst.getEditor().isDisposed()) {
                    editorFirst.getEditor().dispose();
                }
                editorFirst.dispose();
                item.setData(EDITOR_KEY, null);
            }
            if (editorLast != null) {
                if (editorLast.getEditor() != null && !editorLast.getEditor().isDisposed()) {
                    editorLast.getEditor().dispose();
                }
                editorLast.dispose();
                item.setData(EDITOR_KEY_LAST, null);
            }
            ++n2;
        }
        try {
            try {
                eimJson = this.eimIdfConfiguratinParser.getEimJson(true);
            }
            catch (EimVersionMismatchException e) {
                Logger.log((Exception)((Object)e));
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)e.msgTitle(), (String)e.getMessage());
            }
            if (eimJson == null) {
                return;
            }
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        this.idfInstalledList = eimJson.getIdfInstalled();
        this.setupColumns();
        this.tableViewer.setInput(this.idfInstalledList);
        this.tableViewer.getControl().requestLayout();
        this.tableViewer.refresh();
        this.eimLaunchBtn.setText(!this.toolInitializer.isEimInstalled() ? Messages.EIMButtonDownloadText : Messages.EIMButtonLaunchText);
        this.container.redraw();
    }

    private Composite createIdfTable(Composite parent) {
        Group idfToolsGroup = new Group(parent, 16);
        idfToolsGroup.setText("IDF Tools");
        idfToolsGroup.setLayout((Layout)new GridLayout(2, false));
        idfToolsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tableComposite = new Composite((Composite)idfToolsGroup, 0);
        this.tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableColumnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)this.tableColumnLayout);
        this.tableViewer = new TableViewer(this.tableComposite, 2304);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(41, event -> {
            event.height = 25;
        });
        this.comparator = new ColumnViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)this.comparator);
        this.setupColumns();
        table.addListener(41, e -> {
            e.height = 30;
        });
        this.tableViewer.setInput(this.idfInstalledList);
        table.layout();
        Composite buttonComposite = new Composite((Composite)idfToolsGroup, 0);
        GridData buttonCompositeGridData = new GridData(131072, 0x1000000, false, false);
        buttonCompositeGridData.verticalAlignment = 128;
        buttonComposite.setLayoutData((Object)buttonCompositeGridData);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        return idfToolsGroup;
    }

    private void disposeColumns() {
        if (this.activateColumn != null && this.activateColumn.getColumn() != null) {
            this.activateColumn.getColumn().dispose();
        }
        if (this.versionColumn != null && this.versionColumn.getColumn() != null) {
            this.versionColumn.getColumn().dispose();
        }
        if (this.locationColumn != null && this.locationColumn.getColumn() != null) {
            this.locationColumn.getColumn().dispose();
        }
        if (this.removeColumn != null && this.removeColumn.getColumn() != null) {
            this.removeColumn.getColumn().dispose();
        }
        if (this.nameColumn != null && this.nameColumn.getColumn() != null) {
            this.nameColumn.getColumn().dispose();
        }
    }

    private void setupColumns() {
        this.disposeColumns();
        int colIndex = 0;
        this.activateColumn = new TableViewerColumn(this.tableViewer, 0);
        this.activateColumn.getColumn().setText(Messages.EspIdfManagerActivateCol);
        this.activateColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.tableColumnLayout.setColumnData((Widget)this.activateColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(2, 5, true));
        this.versionColumn = new TableViewerColumn(this.tableViewer, 0);
        this.versionColumn.getColumn().setText(Messages.EspIdfManagerVersionCol);
        this.versionColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.setComparatorForCols(this.versionColumn, colIndex++);
        this.tableColumnLayout.setColumnData((Widget)this.versionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, 50, true));
        this.nameColumn = new TableViewerColumn(this.tableViewer, 0);
        this.nameColumn.getColumn().setText(Messages.EspIdfManagerNameCol);
        this.nameColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.setComparatorForCols(this.nameColumn, colIndex++);
        this.tableColumnLayout.setColumnData((Widget)this.nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, 50, true));
        this.locationColumn = new TableViewerColumn(this.tableViewer, 0);
        this.locationColumn.getColumn().setText(Messages.EspIdfManagerLocationCol);
        this.locationColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.setComparatorForCols(this.locationColumn, colIndex++);
        this.tableColumnLayout.setColumnData((Widget)this.locationColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 100, true));
        this.removeColumn = new TableViewerColumn(this.tableViewer, 0);
        this.removeColumn.setLabelProvider((CellLabelProvider)new IdfManagerTableColumnLabelProvider());
        this.tableColumnLayout.setColumnData((Widget)this.removeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, 100, true));
    }

    private void setComparatorForCols(final TableViewerColumn column, final int colIndex) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ESPIDFMainTablePage.this.comparator.setColumn(colIndex);
                int direction = ESPIDFMainTablePage.this.tableViewer.getTable().getSortDirection();
                direction = ESPIDFMainTablePage.this.tableViewer.getTable().getSortColumn() == column.getColumn() ? (direction == 128 ? 1024 : 128) : 1024;
                ESPIDFMainTablePage.this.tableViewer.getTable().setSortDirection(direction);
                ESPIDFMainTablePage.this.tableViewer.getTable().setSortColumn(column.getColumn());
                ESPIDFMainTablePage.this.tableViewer.refresh();
            }
        });
    }

    private MessageConsoleStream getConsoleStream(boolean errorStream) {
        IDFConsole idfConsole = new IDFConsole();
        return idfConsole.getConsoleStream(Messages.IDFToolsHandler_ToolsManagerConsole, null, errorStream, true);
    }

    private class ColumnViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IdfInstalled p1 = (IdfInstalled)e1;
            IdfInstalled p2 = (IdfInstalled)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = p1.getName().compareTo(p2.getName());
                    break;
                }
                case 1: {
                    rc = p1.getPath().compareTo(p2.getPath());
                    break;
                }
                case 2: {
                    Boolean p1State = ToolsUtility.isIdfInstalledActive((IdfInstalled)p1);
                    Boolean p2State = ToolsUtility.isIdfInstalledActive((IdfInstalled)p2);
                    rc = p1State.compareTo(p2State);
                    break;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class IdfManagerTableColumnLabelProvider
    extends ColumnLabelProvider {
        private Color activeBackgroundColor = new Color((Device)Display.getCurrent(), 144, 238, 144);

        private IdfManagerTableColumnLabelProvider() {
        }

        public Color getBackground(Object element) {
            IdfInstalled idfInstalled;
            if (element instanceof IdfInstalled && ToolsUtility.isIdfInstalledActive((IdfInstalled)(idfInstalled = (IdfInstalled)element))) {
                return this.activeBackgroundColor;
            }
            return null;
        }

        public void update(ViewerCell cell) {
            boolean isFirstCol;
            int totalCols = ESPIDFMainTablePage.this.tableViewer.getTable().getColumnCount();
            boolean isLastCol = cell.getColumnIndex() == totalCols - 1;
            boolean bl = isFirstCol = cell.getColumnIndex() == 0;
            if (isFirstCol) {
                this.createButtonsForFirstCol(cell);
            } else if (isLastCol) {
                this.createButtonsForLastCol(cell);
            } else {
                this.updateDataIntoCells(cell);
            }
            Color color = this.getBackground(cell.getElement());
            if (color != null) {
                cell.setBackground(color);
            }
        }

        private void updateDataIntoCells(ViewerCell cell) {
            if (!(cell.getElement() instanceof IdfInstalled) && cell.getElement() == null) {
                return;
            }
            IdfInstalled idfInstalled = (IdfInstalled)cell.getElement();
            switch (cell.getColumnIndex()) {
                case 0: {
                    break;
                }
                case 1: {
                    cell.setText(this.getIdfVersion(idfInstalled));
                    break;
                }
                case 2: {
                    cell.setText(idfInstalled.getName());
                    break;
                }
                case 3: {
                    cell.setText(idfInstalled.getPath());
                    break;
                }
            }
        }

        private String getIdfVersion(IdfInstalled idfInstalled) {
            String version = ToolsUtility.getIdfVersion((IdfInstalled)idfInstalled, (String)eimJson.getGitPath());
            return version;
        }

        private void createButtonsForFirstCol(ViewerCell cell) {
            String EDITOR_KEY;
            TableItem item = (TableItem)cell.getItem();
            if (item.getData(EDITOR_KEY = "action_editor") != null) {
                return;
            }
            TableEditor editor = new TableEditor(ESPIDFMainTablePage.this.tableViewer.getTable());
            Composite buttonComposite = new Composite((Composite)ESPIDFMainTablePage.this.tableViewer.getTable(), 0);
            buttonComposite.setLayout((Layout)new FillLayout());
            item.setData(EDITOR_KEY, (Object)editor);
            IdfInstalled idfInstalled = (IdfInstalled)cell.getElement();
            Button setActiveButton = new Button(buttonComposite, 16);
            setActiveButton.setSelection(ToolsUtility.isIdfInstalledActive((IdfInstalled)idfInstalled));
            setActiveButton.setData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY, (Object)idfInstalled);
            setActiveButton.addListener(13, e -> {
                Button btn = (Button)e.widget;
                SetupToolsInIde setupToolsInIde = new SetupToolsInIde(idfInstalled, eimJson, ESPIDFMainTablePage.this.getConsoleStream(true), ESPIDFMainTablePage.this.getConsoleStream(false));
                SetupToolsJobListener toolsActivationJobListener = new SetupToolsJobListener(ESPIDFMainTablePage.this, setupToolsInIde);
                setupToolsInIde.addJobChangeListener((IJobChangeListener)toolsActivationJobListener);
                setupToolsInIde.schedule();
                btn.setEnabled(false);
            });
            editor.grabHorizontal = true;
            editor.setEditor((Control)buttonComposite, item, cell.getColumnIndex());
        }

        private void createButtonsForLastCol(ViewerCell cell) {
            TableItem item = (TableItem)cell.getItem();
            Rectangle cellBounds = cell.getBounds();
            String EDITOR_KEY = "action_editor_last";
            if (item.getData(EDITOR_KEY) != null) {
                return;
            }
            TableEditor editor = new TableEditor(ESPIDFMainTablePage.this.tableViewer.getTable());
            Composite buttonComposite = new Composite((Composite)ESPIDFMainTablePage.this.tableViewer.getTable(), 0);
            FillLayout fillLayout = new FillLayout(256);
            buttonComposite.setLayout((Layout)fillLayout);
            buttonComposite.redraw();
            item.setData(EDITOR_KEY, (Object)editor);
            IdfInstalled idfInstalled = (IdfInstalled)cell.getElement();
            int buttonHeight = Math.min(cellBounds.height - 6, 30);
            if (ToolsUtility.isIdfInstalledActive((IdfInstalled)idfInstalled)) {
                Button reloadButton = new Button(buttonComposite, 0x800008);
                reloadButton.pack();
                reloadButton.setData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY, (Object)idfInstalled);
                reloadButton.setImage(UIPlugin.getImage(ESPIDFMainTablePage.RELOAD_ICON));
                reloadButton.setToolTipText(Messages.EspIdfManagerReloadBtnToolTip);
                reloadButton.addListener(13, e -> {
                    Button btn = (Button)e.widget;
                    IdfInstalled selectedToolSet = (IdfInstalled)btn.getData(ESPIDFMainTablePage.IDF_TOOL_SET_BTN_KEY);
                    SetupToolsInIde setupToolsInIde = new SetupToolsInIde(selectedToolSet, eimJson, ESPIDFMainTablePage.this.getConsoleStream(true), ESPIDFMainTablePage.this.getConsoleStream(false));
                    SetupToolsJobListener toolsActivationJobListener = new SetupToolsJobListener(ESPIDFMainTablePage.this, setupToolsInIde);
                    setupToolsInIde.addJobChangeListener((IJobChangeListener)toolsActivationJobListener);
                    setupToolsInIde.schedule();
                });
                reloadButton.setSize(cellBounds.width, buttonHeight);
                reloadButton.addListener(9, e -> e.gc.drawRectangle(reloadButton.getBounds()));
                reloadButton.redraw();
            }
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.horizontalAlignment = 0x1000000;
            editor.verticalAlignment = 0x1000000;
            editor.setEditor((Control)buttonComposite, item, cell.getColumnIndex());
            buttonComposite.layout(true, true);
            buttonComposite.redraw();
            editor.layout();
            ESPIDFMainTablePage.this.tableViewer.getTable().layout(true, true);
        }

        public void dispose() {
            if (this.activeBackgroundColor != null && !this.activeBackgroundColor.isDisposed()) {
                this.activeBackgroundColor.dispose();
            }
            super.dispose();
        }
    }
}

