/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.partitiontable.dialog;

import com.espressif.idf.core.build.PartitionTableBean;
import com.espressif.idf.core.util.PartitionBeanValidator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PartitionTableLabelProvider
extends CellLabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final String CHECKED_KEY = "CHECKED";
    private static final String UNCHECK_KEY = "UNCHECKED";

    public void addListener(ILabelProviderListener listener) {
    }

    public PartitionTableLabelProvider() {
        Shell shell = Display.getDefault().getActiveShell();
        if (JFaceResources.getImageRegistry().getDescriptor(CHECKED_KEY) == null) {
            JFaceResources.getImageRegistry().put(UNCHECK_KEY, this.makeShot(shell, false));
            JFaceResources.getImageRegistry().put(CHECKED_KEY, this.makeShot(shell, true));
        }
    }

    public void dispose() {
    }

    private Image makeShot(Shell shell, boolean type) {
        Shell s = new Shell(shell, 8);
        Button b = new Button((Composite)s, 32);
        b.setSelection(type);
        Point bsize = b.computeSize(-1, -1);
        bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
        bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
        b.setSize(bsize);
        b.setLocation(1, 1);
        s.setSize(bsize);
        s.open();
        GC gc = new GC((Drawable)b);
        Image image = new Image((Device)shell.getDisplay(), bsize.x, bsize.y);
        gc.copyArea(image, -1, 0);
        gc.dispose();
        s.close();
        return image;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 5) {
            Image checkBoxImage = ((PartitionTableBean)element).getFlag().contentEquals("encrypted") ? JFaceResources.getImage((String)CHECKED_KEY) : JFaceResources.getImage((String)UNCHECK_KEY);
            return checkBoxImage;
        }
        String status = new PartitionBeanValidator().validateBean((PartitionTableBean)element, columnIndex);
        if (!status.isBlank()) {
            return JFaceResources.getImage((String)"dialog_message_error_image");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        PartitionTableBean bean = (PartitionTableBean)element;
        switch (columnIndex) {
            case 0: {
                return bean.getName();
            }
            case 1: {
                return bean.getType();
            }
            case 2: {
                return bean.getSubType();
            }
            case 3: {
                return bean.getOffSet();
            }
            case 4: {
                return bean.getSize();
            }
            case 5: {
                return bean.getFlag();
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        String status = new PartitionBeanValidator().validateBean((PartitionTableBean)element, columnIndex);
        if (!status.isBlank()) {
            return Display.getCurrent().getSystemColor(3);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public void update(ViewerCell cell) {
    }
}

