/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.nvs.dialog;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.nvs.dialog.NvsEditorSettings;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class NvsEditorPreferenceService {
    private static final String PLUGIN_ID = "com.espressif.idf.core";
    private static final String PREF_PARTITION_SIZE = "nvsPartitionSize";
    private static final String PREF_ENCRYPT_ENABLED = "nvsEncryptEnabled";
    private static final String PREF_GENERATE_KEY_ENABLED = "nvsGenerateKeyEnabled";
    private static final String PREF_ENCRYPTION_KEY_PATH = "nvsEncryptionKeyPath";
    private IEclipsePreferences preferences;

    public NvsEditorPreferenceService(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        this.preferences = projectScope.getNode(PLUGIN_ID);
    }

    public NvsEditorSettings loadSettings() {
        String partitionSize = this.preferences.get(PREF_PARTITION_SIZE, "0x3000");
        boolean encryptEnabled = this.preferences.getBoolean(PREF_ENCRYPT_ENABLED, false);
        boolean generateKeyEnabled = this.preferences.getBoolean(PREF_GENERATE_KEY_ENABLED, true);
        String encryptionKeyPath = this.preferences.get(PREF_ENCRYPTION_KEY_PATH, "");
        return new NvsEditorSettings(partitionSize, encryptEnabled, generateKeyEnabled, encryptionKeyPath);
    }

    public void saveSettings(NvsEditorSettings settings) {
        this.preferences.put(PREF_PARTITION_SIZE, settings.partitionSize());
        this.preferences.putBoolean(PREF_ENCRYPT_ENABLED, settings.encryptEnabled());
        this.preferences.putBoolean(PREF_GENERATE_KEY_ENABLED, settings.generateKeyEnabled());
        this.preferences.put(PREF_ENCRYPTION_KEY_PATH, settings.encryptionKeyPath());
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }
}

