/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.installcomponents.container;

import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.installcomponents.container.ComponentContainer;
import com.espressif.idf.ui.installcomponents.deserializer.ComponentsDeserializer;
import com.espressif.idf.ui.installcomponents.vo.ComponentVO;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;

public class InstallComponentsCompositePage {
    private IFile componentsJsonFile;
    private IProject project;
    private List<ComponentVO> componentVOs;
    private List<ComponentContainer> componentContainers;
    private ScrolledComposite scrolledParent;
    private Composite containerComposite;

    public InstallComponentsCompositePage(IFile componentsJsonFile, IProject project) {
        this.componentsJsonFile = componentsJsonFile;
        this.project = project;
        this.componentContainers = new ArrayList<ComponentContainer>();
    }

    public void createControls(Composite parent) throws IOException {
        this.containerComposite = parent;
        Composite composite = parent.getParent();
        if (composite instanceof ScrolledComposite) {
            ScrolledComposite parentScrolledComposite;
            this.scrolledParent = parentScrolledComposite = (ScrolledComposite)composite;
        }
        this.loadComponents();
        for (ComponentVO componentVO : this.componentVOs) {
            this.setComponentAdded(componentVO);
            ComponentContainer componentContainer = new ComponentContainer(componentVO, parent, this.project);
            componentContainer.createControl();
            this.componentContainers.add(componentContainer);
        }
    }

    private void setComponentAdded(ComponentVO componentVO) throws IOException {
        String toMatch = componentVO.getNamespace().concat("/").concat(componentVO.getName());
        IFile file = this.componentsJsonFile.getProject().getFolder("main").getFile("idf_component.yml");
        if (file.exists()) {
            List<String> ymlEntries = Files.readAllLines(file.getLocation().toFile().toPath());
            for (String ymlEntry : ymlEntries) {
                if (!StringUtil.isEmpty((String)ymlEntry) && ymlEntry.charAt(0) == '#' || !ymlEntry.contains(toMatch)) continue;
                componentVO.setComponentAdded(true);
                return;
            }
        }
    }

    private void loadComponents() throws IOException {
        IFile eclipseFile = this.componentsJsonFile;
        File physicalFile = eclipseFile.getLocation().toFile();
        Charset charset = StandardCharsets.UTF_8;
        try {
            charset = Charset.forName(eclipseFile.getCharset());
        }
        catch (IllegalArgumentException | CoreException throwable) {
            // empty catch block
        }
        Throwable throwable = null;
        Object var5_7 = null;
        try (FileReader reader = new FileReader(physicalFile, charset);){
            Gson gson = new GsonBuilder().registerTypeAdapter(ArrayList.class, (Object)new ComponentsDeserializer()).setPrettyPrinting().disableHtmlEscaping().create();
            this.componentVOs = (List)gson.fromJson((Reader)reader, ArrayList.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void dispose() {
        for (ComponentContainer componentContainer : this.componentContainers) {
            componentContainer.dispose();
        }
    }

    public void filterComponents(String query) {
        String searchString = query == null ? "" : query.toLowerCase().trim();
        boolean layoutNeeded = false;
        for (ComponentContainer container : this.componentContainers) {
            boolean matches;
            ComponentVO vo = container.getComponentVO();
            if (vo == null) continue;
            String name = vo.getName();
            boolean bl = matches = StringUtil.isEmpty((String)searchString) || name != null && name.toLowerCase().contains(searchString);
            if (!container.setVisible(matches)) continue;
            layoutNeeded = true;
        }
        if (layoutNeeded && this.containerComposite != null && !this.containerComposite.isDisposed()) {
            this.containerComposite.layout(true, true);
            if (this.scrolledParent != null) {
                int width = this.scrolledParent.getClientArea().width;
                this.scrolledParent.setMinSize(this.containerComposite.computeSize(width, -1));
            }
        }
    }
}

