/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui;

import com.espressif.idf.core.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.ui.console.MessageConsoleStream;

public class InputStreamConsoleThread
extends Thread {
    private InputStream input;
    private MessageConsoleStream console;

    public InputStreamConsoleThread(InputStream inputStream, MessageConsoleStream console) {
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream cannot be null!");
        }
        this.input = inputStream;
        this.console = console;
    }

    @Override
    public void run() {
        block14: {
            InputStreamReader streamReader = null;
            try {
                try {
                    streamReader = new InputStreamReader(this.input, "UTF-8");
                    BufferedReader br = new BufferedReader(streamReader);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (line.matches("^\\d+%$")) {
                            this.updateProgressBar(line);
                            continue;
                        }
                        this.console.println(line);
                    }
                }
                catch (IOException e) {
                    Logger.log((Exception)e);
                    if (streamReader == null) break block14;
                    try {
                        streamReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (streamReader != null) {
                    try {
                        streamReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void updateProgressBar(String progressLine) {
        int progress = Integer.parseInt(progressLine.replace("%", ""));
        StringBuilder progressBar = new StringBuilder("[");
        int totalBars = 50;
        int filledBars = progress * totalBars / 100;
        int i = 0;
        while (i < totalBars) {
            if (i < filledBars) {
                progressBar.append("=");
            } else if (i == filledBars) {
                progressBar.append(">");
            } else {
                progressBar.append(" ");
            }
            ++i;
        }
        progressBar.append("] ").append(progress).append("%");
        this.console.print("\r" + progressBar.toString());
    }
}

