/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.launcher;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.terminal.connector.controls.IDFConsoleWizardConfigurationPanel;
import com.espressif.idf.terminal.connector.launcher.IDFConsoleMementoHandler;
import com.espressif.idf.terminal.connector.launcher.Messages;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.terminal.connector.ISettingsStore;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.connector.InMemorySettingsStore;
import org.eclipse.terminal.connector.TerminalConnectorExtension;
import org.eclipse.terminal.connector.process.ProcessSettings;
import org.eclipse.terminal.view.ui.IMementoHandler;
import org.eclipse.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;

public class IDFConsoleLauncherDelegate
extends AbstractLauncherDelegate {
    private static final String CONNECTOR_ID = "com.espressif.idf.terminal.connector.espidfConnector";
    private static final String TERMINAL_TITLE_LABEL = Messages.IDFConsoleLauncherDelegate_TerminalTitle;
    private IMementoHandler mementoHandler = new IDFConsoleMementoHandler();

    public boolean needsUserConfiguration() {
        return false;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new IDFConsoleWizardConfigurationPanel(container);
    }

    public CompletableFuture<?> execute(Map<String, Object> properties) {
        properties.put("tm.terminal.connector.id", CONNECTOR_ID);
        String projectName = (String)properties.get("title");
        String title = projectName != null ? String.format("%s (%s)", projectName, TERMINAL_TITLE_LABEL) : TERMINAL_TITLE_LABEL;
        properties.put("title", title);
        return this.getTerminalService().openConsole(properties);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        String image = this.getShellExecutable();
        ProcessSettings processSettings = new ProcessSettings();
        processSettings.setImage(image);
        processSettings.setLocalEcho(false);
        String workingDir = (String)properties.get("process.working_dir");
        if (workingDir != null) {
            processSettings.setWorkingDir(workingDir);
        }
        try {
            ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)CONNECTOR_ID);
            if (connector != null) {
                InMemorySettingsStore store = new InMemorySettingsStore();
                processSettings.save((ISettingsStore)store);
                connector.setDefaultSettings();
                connector.load((ISettingsStore)store);
                return connector;
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IMementoHandler.class.equals(adapter)) {
            return adapter.cast(this.mementoHandler);
        }
        return (T)super.getAdapter(adapter);
    }

    private String getShellExecutable() {
        if ("win32".equals(Platform.getOS())) {
            return "powershell.exe";
        }
        String shell = System.getenv("SHELL");
        return shell != null && !shell.isBlank() ? shell : "/bin/sh";
    }
}

