/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools;

import com.espressif.idf.core.logging.Logger;
import java.util.Queue;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class LogMessagesThread
extends Thread {
    private final Queue<String> logMessages;
    private boolean stopLogging;
    private final Text logAreaText;
    private Display display;

    public LogMessagesThread(Queue<String> logMessages, Text logAreaText, Display display) {
        this.logMessages = logMessages;
        this.logAreaText = logAreaText;
        this.display = display;
    }

    @Override
    public void run() {
        while (!this.stopLogging) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.log((Exception)e);
            }
            if (this.logMessages.size() == 0) continue;
            String msg = this.logMessages.poll();
            this.showMessage(msg);
        }
    }

    private void showMessage(final String message) {
        if (this.display == null && this.logAreaText != null) {
            this.display = this.logAreaText.getDisplay();
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LogMessagesThread.this.logAreaText.getText().length() != 0) {
                    LogMessagesThread.this.logAreaText.append(System.getProperty("line.separator"));
                }
                LogMessagesThread.this.logAreaText.append(message);
            }
        });
    }

    public void setStopLogging(boolean stopLogging) {
        this.stopLogging = stopLogging;
    }
}

