/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.SDKConfigJsonReader;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.size.IDFSizeChartsComposite;
import com.espressif.idf.ui.size.IDFSizeDetailsComposite;
import com.espressif.idf.ui.size.IDFSizeOverviewComposite;
import com.espressif.idf.ui.size.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class IDFSizeAnalysisEditor
extends MultiPageEditorPart {
    public static String EDITOR_ID = "com.espressif.idf.ui.editor.idfsize";
    private IProject project;
    private IFile file;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        FileEditorInput editorInput = (FileEditorInput)this.getEditorInput();
        this.file = editorInput.getFile();
        this.project = this.file.getProject();
        this.setPartName(this.project.getName());
    }

    protected void createPages() {
        String osString = this.file.getLocation().toOSString();
        Logger.log((String)("Editor input:" + osString));
        if (!this.verifyVersion()) {
            this.createErrorMessageOnEditor();
        } else {
            this.createOverviewPage();
            this.createChartsComposite();
            this.createDetailsPage();
        }
    }

    private boolean verifyVersion() {
        int minor;
        int major;
        block6: {
            String[] parts;
            IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
            String idfVersion = idfEnvironmentVariables.getEnvValue("ESP_IDF_VERSION");
            if (StringUtil.isEmpty((String)idfVersion)) {
                return false;
            }
            if (idfVersion.toLowerCase().startsWith("v")) {
                idfVersion = idfVersion.substring(1);
            }
            if ((parts = idfVersion.split("\\.")).length < 2) {
                return false;
            }
            try {
                major = Integer.parseInt(parts[0]);
                minor = Integer.parseInt(parts[1]);
                if (major <= 5) break block6;
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return major == 5 && minor > 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void createErrorMessageOnEditor() {
        Composite parent = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 20;
        layout.marginTop = 100;
        parent.setLayout((Layout)layout);
        Label title = new Label(parent, 0x1000000);
        title.setText(Messages.IDFSizeEditorVersionError);
        GridData titleData = new GridData(0x1000000, 0x1000000, true, false);
        title.setLayoutData((Object)titleData);
        FontDescriptor boldFontDescriptor = FontDescriptor.createFrom((Font)title.getFont()).setStyle(1);
        title.setFont(boldFontDescriptor.createFont((Device)parent.getDisplay()));
        Label explanation = new Label(parent, 0x1000040);
        explanation.setText(Messages.IDFSizeEditorVersionErrorDescription);
        GridData explanationData = new GridData(0x1000000, 0x1000000, true, false);
        explanationData.widthHint = 500;
        explanation.setLayoutData((Object)explanationData);
        Button closeBtn = new Button(parent, 8);
        closeBtn.setText(Messages.IDFSizeEditorCloseButton);
        GridData buttonData = new GridData(0x1000000, 0x1000000, true, false);
        closeBtn.setLayoutData((Object)buttonData);
        closeBtn.addListener(13, e -> {
            boolean bl = this.getSite().getPage().closeEditor((IEditorPart)this, false);
        });
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages.IDFSizeEditorError);
    }

    private void createDetailsPage() {
        Composite parent = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 400;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        new IDFSizeDetailsComposite().createPartControl(tableComposite, this.file);
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages.IDFSizeEditorDetails);
    }

    private void createOverviewPage() {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getDefault().getSystemColor(1));
        new IDFSizeOverviewComposite().createPartControl(parent, this.file, this.getTarget());
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages.IDFSizeEditorOverview);
    }

    private void createChartsComposite() {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout());
        new IDFSizeChartsComposite().createPartControl(parent, this.file, this.getTarget());
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages.IDFSizeEditorCharts);
    }

    private String getTarget() {
        return new SDKConfigJsonReader(this.project).getValue("IDF_TARGET");
    }
}

