/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.wokwi.ui;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.wokwi.ui.Messages;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class WokwiConfigTab
extends AbstractLaunchConfigurationTab {
    private Label fProjLabel;
    private Text projectTxt;
    private Button fProjButton;
    private IProject selectedProject;
    private Text wokwiProjectIdTxt;
    private Text wokwiServerTxt;

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createProjectGroup(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createProjectGroup(Composite parent, int colSpan) {
        Group projectGroup = new Group(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 3;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projectGroup.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projectGroup.setLayoutData((Object)gd);
        this.fProjLabel = new Label((Composite)projectGroup, 0);
        this.fProjLabel.setText(Messages.WokwiConfigTab_Project);
        gd = new GridData();
        this.fProjLabel.setLayoutData((Object)gd);
        this.projectTxt = new Text((Composite)projectGroup, 2052);
        gd = new GridData(768);
        this.projectTxt.setLayoutData((Object)gd);
        this.fProjButton = this.createPushButton((Composite)projectGroup, Messages.WokwiConfigTab_Browse, null);
        this.projectTxt.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                WokwiConfigTab.this.chooseProject();
                WokwiConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label wokwiServerLbl = new Label((Composite)projectGroup, 0);
        wokwiServerLbl.setText(Messages.WokwiConfigTab_Server);
        gd = new GridData();
        wokwiServerLbl.setLayoutData((Object)gd);
        this.wokwiServerTxt = new Text((Composite)projectGroup, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.wokwiServerTxt.setLayoutData((Object)gd);
        this.wokwiServerTxt.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
        Label projectIdLbl = new Label((Composite)projectGroup, 0);
        projectIdLbl.setText(Messages.WokwiConfigTab_ProjectID);
        this.wokwiProjectIdTxt = new Text((Composite)projectGroup, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.wokwiProjectIdTxt.setLayoutData((Object)gd);
        Link wokwiProjectIdhelp = new Link((Composite)projectGroup, 0);
        wokwiProjectIdhelp.setText(Messages.WokwiConfigTab_HelpTxt);
        gd = new GridData();
        wokwiProjectIdhelp.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalIndent = 5;
        wokwiProjectIdhelp.setLayoutData((Object)gd);
        wokwiProjectIdhelp.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)"https://wokwi.com/projects/345932416223806035");
            }
        });
        Link wokwiserverConfigLbl = new Link(parent, 0);
        wokwiserverConfigLbl.setText(Messages.WokwiConfigTab_InstallationHelpTxt + "https://github.com/MabezDev/wokwi-server</a>");
        gd = new GridData();
        wokwiserverConfigLbl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalIndent = 5;
        wokwiserverConfigLbl.setLayoutData((Object)gd);
        wokwiserverConfigLbl.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)event.text);
            }
        });
    }

    private void chooseProject() {
        try {
            ICProject cProject;
            Object[] projects = CoreModel.getDefault().getCModel().getCProjects();
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(Messages.WokwiConfigTab_ProjectSelection);
            dialog.setMessage(Messages.WokwiConfigTab_ChooseProject);
            dialog.setElements(projects);
            String initialProjectName = this.projectTxt != null ? this.projectTxt.getText().trim() : "";
            ICProject iCProject = cProject = initialProjectName.isEmpty() ? null : CoreModel.getDefault().getCModel().getCProject(this.projectTxt.getText());
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                this.selectedProject = ((ICProject)dialog.getFirstResult()).getProject();
            }
            if (this.projectTxt != null && this.selectedProject != null) {
                this.projectTxt.setText(this.selectedProject.getName());
            }
        }
        catch (CModelException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.selectedProject = this.getSelectedProject();
        if (this.selectedProject != null) {
            this.initializeCProject(this.selectedProject, configuration);
        }
        try {
            configuration.doSave();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private IProject getSelectedProject() {
        final ArrayList projectList = new ArrayList(1);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IProject project = EclipseUtil.getSelectedProjectInExplorer();
                projectList.add(project);
            }
        });
        IProject project = (IProject)projectList.get(0);
        return project;
    }

    protected void initializeCProject(IProject project, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (project != null && project.exists()) {
            name = project.getName();
            config.setMappedResources(new IResource[]{project});
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                String buildConfigID = projDes.getActiveConfiguration().getId();
                config.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
            }
        }
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", name);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean isConfigValid = super.isValid(launchConfig);
        boolean hasProject = false;
        try {
            hasProject = launchConfig.getMappedResources() != null ? launchConfig.getMappedResources()[0].getProject().exists() : false;
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        String projectName = this.projectTxt.getText().trim();
        if (projectName.length() == 0) {
            this.setErrorMessage(Messages.WokwiConfigTab_ProjectNotSpecified);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.setErrorMessage(Messages.WokwiConfigTab_ProjDoesNotExist);
            return false;
        }
        if (!project.isOpen()) {
            this.setErrorMessage(Messages.WokwiConfigTab_ProjMustOpened);
            return false;
        }
        String wokwiServerPath = this.wokwiServerTxt.getText().trim();
        if (wokwiServerPath.length() == 0) {
            this.setErrorMessage(Messages.WokwiConfigTab_ServerCantEmpty);
            return false;
        }
        if (!new File(wokwiServerPath).exists()) {
            this.setErrorMessage(Messages.WokwiConfigTab_ServerDoesntExist);
            return false;
        }
        if (isConfigValid && hasProject) {
            this.setErrorMessage(null);
        }
        return isConfigValid && hasProject;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.projectTxt.getText());
            wc.setAttribute("ATTR_WOKWI_PROJECT_ID", this.wokwiProjectIdTxt.getText());
            new IDFEnvironmentVariables().addEnvVariable("WOKWI_SERVER_PATH", this.wokwiServerTxt.getText());
            if (this.selectedProject != null) {
                wc.setMappedResources(new IResource[]{this.selectedProject});
            }
            wc.doSave();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProjetFromConfig(configuration);
    }

    private void updateProjetFromConfig(ILaunchConfiguration configuration) {
        String projectName = "";
        String wokwiProjectId = "";
        String wokwiSeverPath = "";
        try {
            projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            wokwiProjectId = configuration.getAttribute("ATTR_WOKWI_PROJECT_ID", "");
            wokwiSeverPath = new IDFEnvironmentVariables().getEnvValue("WOKWI_SERVER_PATH");
        }
        catch (CoreException ce) {
            Logger.log((Exception)((Object)ce));
        }
        if (!this.projectTxt.getText().equals(projectName)) {
            this.projectTxt.setText(projectName);
        }
        if (!StringUtil.isEmpty((String)wokwiProjectId)) {
            this.wokwiProjectIdTxt.setText(wokwiProjectId);
        }
        if (!StringUtil.isEmpty((String)wokwiSeverPath)) {
            this.wokwiServerTxt.setText(wokwiSeverPath);
        }
    }

    public String getName() {
        return Messages.WokwiConfigTab_WokwiServer;
    }
}

