/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.resources.OpenDialogListenerSupport;
import com.espressif.idf.core.resources.PopupDialog;
import com.espressif.idf.core.util.DataSizeUtil;
import com.espressif.idf.core.util.IDFUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ParitionSizeHandler {
    private IProject project;
    private ConsoleOutputStream infoStream;
    private IConsole console;

    public ParitionSizeHandler(IProject project, ConsoleOutputStream infoStream, IConsole console) {
        this.project = project;
        this.infoStream = infoStream;
        this.console = console;
    }

    public void startCheckingSize() throws IOException, CoreException {
        IPath binPath;
        if (IDFUtil.getMapFilePath(this.project) != null) {
            this.startIdfSizeProcess();
        }
        if ((binPath = IDFUtil.getBinFilePath(this.project)) != null) {
            this.checkRemainingSize(binPath);
        }
    }

    private String getPartitionTable() throws IOException, CoreException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonEnvPath());
        commands.add(IDFUtil.getIDFPath() + File.separator + "components" + File.separator + "partition_table" + File.separator + "gen_esp32part.py");
        commands.add(IDFUtil.getBuildDir(this.project) + File.separator + "partition_table" + File.separator + "partition-table.bin");
        Process process = this.startProcess(commands);
        return new String(process.getInputStream().readAllBytes());
    }

    private Process startProcess(List<String> commands) throws IOException {
        this.infoStream.write(String.join((CharSequence)" ", commands) + "\n");
        Path workingDir = (Path)this.project.getLocation();
        ProcessBuilder processBuilder = new ProcessBuilder(commands).directory(workingDir.toFile());
        return processBuilder.start();
    }

    private void startIdfSizeProcess() throws IOException, CoreException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonEnvPath());
        commands.add(IDFUtil.getIDFSizeScriptFile().getAbsolutePath());
        commands.add(IDFUtil.getMapFilePath(this.project).toString());
        Process process = this.startProcess(commands);
        if (process != null) {
            this.console.getOutputStream().write(process.getInputStream().readAllBytes());
        }
    }

    private void checkRemainingSize(IPath path) throws IOException, CoreException {
        String[] lines;
        String partitionTableContent = this.getPartitionTable();
        long imageSize = path.toFile().length();
        String[] stringArray = lines = partitionTableContent.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] columns;
            double maxSize;
            double remainSize;
            String line = stringArray[n2];
            if (line.contains("app") && (remainSize = ((maxSize = (double)DataSizeUtil.parseSize((columns = line.split(","))[4])) - (double)imageSize) / maxSize) < 0.3) {
                OpenDialogListenerSupport.getSupport().firePropertyChange(PopupDialog.LOW_PARTITION_SIZE.name(), maxSize, remainSize * maxSize);
                break;
            }
            ++n2;
        }
    }
}

