/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf.process;

import com.espressif.idf.debug.gdbjtag.openocd.dsf.process.monitors.StreamsProxy;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.NullStreamsProxy;

public class IdfRuntimeProcess
extends GDBProcess {
    private boolean fCaptureOutput = true;
    private StreamsProxy streamsProxy;

    public IdfRuntimeProcess(ILaunch launch, Process process, String name, Map<String, String> attributes) {
        super(launch, process, name, attributes);
    }

    protected IStreamsProxy createStreamsProxy() {
        String captureOutput = this.getLaunch().getAttribute("org.eclipse.debug.core.capture_output");
        boolean bl = this.fCaptureOutput = !"false".equals(captureOutput);
        if (!this.fCaptureOutput) {
            return new NullStreamsProxy(this.getSystemProcess());
        }
        String encoding = this.getLaunch().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        Charset charset = null;
        if (encoding != null) {
            try {
                charset = Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        String outputFileName = this.getAttributeSafe((arg_0, arg_1) -> ((ILaunchConfiguration)this.getLaunch().getLaunchConfiguration()).getAttribute(arg_0, arg_1), "org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", "");
        boolean append = this.getAttributeSafe((arg_0, arg_1) -> ((ILaunchConfiguration)this.getLaunch().getLaunchConfiguration()).getAttribute(arg_0, arg_1), "org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", false);
        this.streamsProxy = new StreamsProxy((IProcess)this, this.getSystemProcess(), charset, this.getLabel(), outputFileName, append);
        return this.streamsProxy;
    }

    public void terminate() throws DebugException {
        super.terminate();
        this.streamsProxy.kill();
    }

    private <T> T getAttributeSafe(AttributeGetter<T> getter, String attribute, T defaultValue) {
        try {
            return getter.get(attribute, defaultValue);
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
            return defaultValue;
        }
    }

    @FunctionalInterface
    static interface AttributeGetter<T> {
        public T get(String var1, T var2) throws CoreException;
    }
}

