/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor.rules;

import com.cthing.cmakeed.core.reservedwords.CMakeReservedWord;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWords;
import com.cthing.cmakeed.ui.editor.CMakeNameDetector;
import com.cthing.cmakeed.ui.editor.CMakePartitionScanner;
import com.cthing.cmakeed.ui.editor.EditorUtils;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class CMakeReservedWordRule
implements IRule,
IPredicateRule {
    private IToken commandToken;
    private IWordDetector detector = new CMakeNameDetector();
    private StringBuilder buffer = new StringBuilder();

    public CMakeReservedWordRule(IToken commandToken, boolean findDeprecated) {
        this.commandToken = commandToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int offset;
        CMakePartitionScanner cscan;
        IDocument doc;
        this.buffer.setLength(0);
        int ch = scanner.read();
        while (ch != -1 && this.detector.isWordPart((char)ch)) {
            this.buffer.append((char)ch);
            ch = scanner.read();
        }
        scanner.unread();
        CMakeReservedWord cmd = CMakeReservedWords.getCommand((String)this.buffer.toString());
        if (cmd != null && scanner instanceof CMakePartitionScanner && EditorUtils.inArguments(doc = (cscan = (CMakePartitionScanner)scanner).getDocument(), offset = cscan.getTokenOffset()) && EditorUtils.startOfWord(doc, offset)) {
            return this.commandToken;
        }
        EditorUtils.unread(scanner, this.buffer);
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this.commandToken;
    }
}

